/****** FILE: framework/thirdparty/jquery/jquery.js *****/

(function(window,undefined){var document=window.document,navigator=window.navigator,location=window.location;var jQuery=(function(){var jQuery=function(selector,context){return new jQuery.fn.init(selector,context,rootjQuery);},_jQuery=window.jQuery,_$=window.$,rootjQuery,quickExpr=/^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,rnotwhite=/\S/,trimLeft=/^\s+/,trimRight=/\s+$/,rsingleTag=/^<(\w+)\s*\/?>(?:<\/\1>)?$/,rvalidchars=/^[\],:{}\s]*$/,rvalidescape=/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,rvalidtokens=/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,rvalidbraces=/(?:^|:|,)(?:\s*\[)+/g,rwebkit=/(webkit)[ \/]([\w.]+)/,ropera=/(opera)(?:.*version)?[ \/]([\w.]+)/,rmsie=/(msie) ([\w.]+)/,rmozilla=/(mozilla)(?:.*? rv:([\w.]+))?/,rdashAlpha=/-([a-z]|[0-9])/ig,rmsPrefix=/^-ms-/,fcamelCase=function(all,letter){return(letter+"").toUpperCase();},userAgent=navigator.userAgent,browserMatch,readyList,DOMContentLoaded,toString=Object.prototype.toString,hasOwn=Object.prototype.hasOwnProperty,push=Array.prototype.push,slice=Array.prototype.slice,trim=String.prototype.trim,indexOf=Array.prototype.indexOf,class2type={};jQuery.fn=jQuery.prototype={constructor:jQuery,init:function(selector,context,rootjQuery){var match,elem,ret,doc;if(!selector){return this;}
if(selector.nodeType){this.context=this[0]=selector;this.length=1;return this;}
if(selector==="body"&&!context&&document.body){this.context=document;this[0]=document.body;this.selector=selector;this.length=1;return this;}
if(typeof selector==="string"){if(selector.charAt(0)==="<"&&selector.charAt(selector.length-1)===">"&&selector.length>=3){match=[null,selector,null];}else{match=quickExpr.exec(selector);}
if(match&&(match[1]||!context)){if(match[1]){context=context instanceof jQuery?context[0]:context;doc=(context?context.ownerDocument||context:document);ret=rsingleTag.exec(selector);if(ret){if(jQuery.isPlainObject(context)){selector=[document.createElement(ret[1])];jQuery.fn.attr.call(selector,context,true);}else{selector=[doc.createElement(ret[1])];}}else{ret=jQuery.buildFragment([match[1]],[doc]);selector=(ret.cacheable?jQuery.clone(ret.fragment):ret.fragment).childNodes;}
return jQuery.merge(this,selector);}else{elem=document.getElementById(match[2]);if(elem&&elem.parentNode){if(elem.id!==match[2]){return rootjQuery.find(selector);}
this.length=1;this[0]=elem;}
this.context=document;this.selector=selector;return this;}}else if(!context||context.jquery){return(context||rootjQuery).find(selector);}else{return this.constructor(context).find(selector);}}else if(jQuery.isFunction(selector)){return rootjQuery.ready(selector);}
if(selector.selector!==undefined){this.selector=selector.selector;this.context=selector.context;}
return jQuery.makeArray(selector,this);},selector:"",jquery:"1.7.2",length:0,size:function(){return this.length;},toArray:function(){return slice.call(this,0);},get:function(num){return num==null?this.toArray():(num<0?this[this.length+num]:this[num]);},pushStack:function(elems,name,selector){var ret=this.constructor();if(jQuery.isArray(elems)){push.apply(ret,elems);}else{jQuery.merge(ret,elems);}
ret.prevObject=this;ret.context=this.context;if(name==="find"){ret.selector=this.selector+(this.selector?" ":"")+selector;}else if(name){ret.selector=this.selector+"."+name+"("+selector+")";}
return ret;},each:function(callback,args){return jQuery.each(this,callback,args);},ready:function(fn){jQuery.bindReady();readyList.add(fn);return this;},eq:function(i){i=+i;return i===-1?this.slice(i):this.slice(i,i+1);},first:function(){return this.eq(0);},last:function(){return this.eq(-1);},slice:function(){return this.pushStack(slice.apply(this,arguments),"slice",slice.call(arguments).join(","));},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem);}));},end:function(){return this.prevObject||this.constructor(null);},push:push,sort:[].sort,splice:[].splice};jQuery.fn.init.prototype=jQuery.fn;jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=false;if(typeof target==="boolean"){deep=target;target=arguments[1]||{};i=2;}
if(typeof target!=="object"&&!jQuery.isFunction(target)){target={};}
if(length===i){target=this;--i;}
for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){src=target[name];copy=options[name];if(target===copy){continue;}
if(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=jQuery.isArray(copy)))){if(copyIsArray){copyIsArray=false;clone=src&&jQuery.isArray(src)?src:[];}else{clone=src&&jQuery.isPlainObject(src)?src:{};}
target[name]=jQuery.extend(deep,clone,copy);}else if(copy!==undefined){target[name]=copy;}}}}
return target;};jQuery.extend({noConflict:function(deep){if(window.$===jQuery){window.$=_$;}
if(deep&&window.jQuery===jQuery){window.jQuery=_jQuery;}
return jQuery;},isReady:false,readyWait:1,holdReady:function(hold){if(hold){jQuery.readyWait++;}else{jQuery.ready(true);}},ready:function(wait){if((wait===true&&!--jQuery.readyWait)||(wait!==true&&!jQuery.isReady)){if(!document.body){return setTimeout(jQuery.ready,1);}
jQuery.isReady=true;if(wait!==true&&--jQuery.readyWait>0){return;}
readyList.fireWith(document,[jQuery]);if(jQuery.fn.trigger){jQuery(document).trigger("ready").off("ready");}}},bindReady:function(){if(readyList){return;}
readyList=jQuery.Callbacks("once memory");if(document.readyState==="complete"){return setTimeout(jQuery.ready,1);}
if(document.addEventListener){document.addEventListener("DOMContentLoaded",DOMContentLoaded,false);window.addEventListener("load",jQuery.ready,false);}else if(document.attachEvent){document.attachEvent("onreadystatechange",DOMContentLoaded);window.attachEvent("onload",jQuery.ready);var toplevel=false;try{toplevel=window.frameElement==null;}catch(e){}
if(document.documentElement.doScroll&&toplevel){doScrollCheck();}}},isFunction:function(obj){return jQuery.type(obj)==="function";},isArray:Array.isArray||function(obj){return jQuery.type(obj)==="array";},isWindow:function(obj){return obj!=null&&obj==obj.window;},isNumeric:function(obj){return!isNaN(parseFloat(obj))&&isFinite(obj);},type:function(obj){return obj==null?String(obj):class2type[toString.call(obj)]||"object";},isPlainObject:function(obj){if(!obj||jQuery.type(obj)!=="object"||obj.nodeType||jQuery.isWindow(obj)){return false;}
try{if(obj.constructor&&!hasOwn.call(obj,"constructor")&&!hasOwn.call(obj.constructor.prototype,"isPrototypeOf")){return false;}}catch(e){return false;}
var key;for(key in obj){}
return key===undefined||hasOwn.call(obj,key);},isEmptyObject:function(obj){for(var name in obj){return false;}
return true;},error:function(msg){throw new Error(msg);},parseJSON:function(data){if(typeof data!=="string"||!data){return null;}
data=jQuery.trim(data);if(window.JSON&&window.JSON.parse){return window.JSON.parse(data);}
if(rvalidchars.test(data.replace(rvalidescape,"@").replace(rvalidtokens,"]").replace(rvalidbraces,""))){return(new Function("return "+data))();}
jQuery.error("Invalid JSON: "+data);},parseXML:function(data){if(typeof data!=="string"||!data){return null;}
var xml,tmp;try{if(window.DOMParser){tmp=new DOMParser();xml=tmp.parseFromString(data,"text/xml");}else{xml=new ActiveXObject("Microsoft.XMLDOM");xml.async="false";xml.loadXML(data);}}catch(e){xml=undefined;}
if(!xml||!xml.documentElement||xml.getElementsByTagName("parsererror").length){jQuery.error("Invalid XML: "+data);}
return xml;},noop:function(){},globalEval:function(data){if(data&&rnotwhite.test(data)){(window.execScript||function(data){window["eval"].call(window,data);})(data);}},camelCase:function(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase);},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()===name.toUpperCase();},each:function(object,callback,args){var name,i=0,length=object.length,isObj=length===undefined||jQuery.isFunction(object);if(args){if(isObj){for(name in object){if(callback.apply(object[name],args)===false){break;}}}else{for(;i<length;){if(callback.apply(object[i++],args)===false){break;}}}}else{if(isObj){for(name in object){if(callback.call(object[name],name,object[name])===false){break;}}}else{for(;i<length;){if(callback.call(object[i],i,object[i++])===false){break;}}}}
return object;},trim:trim?function(text){return text==null?"":trim.call(text);}:function(text){return text==null?"":text.toString().replace(trimLeft,"").replace(trimRight,"");},makeArray:function(array,results){var ret=results||[];if(array!=null){var type=jQuery.type(array);if(array.length==null||type==="string"||type==="function"||type==="regexp"||jQuery.isWindow(array)){push.call(ret,array);}else{jQuery.merge(ret,array);}}
return ret;},inArray:function(elem,array,i){var len;if(array){if(indexOf){return indexOf.call(array,elem,i);}
len=array.length;i=i?i<0?Math.max(0,len+i):i:0;for(;i<len;i++){if(i in array&&array[i]===elem){return i;}}}
return-1;},merge:function(first,second){var i=first.length,j=0;if(typeof second.length==="number"){for(var l=second.length;j<l;j++){first[i++]=second[j];}}else{while(second[j]!==undefined){first[i++]=second[j++];}}
first.length=i;return first;},grep:function(elems,callback,inv){var ret=[],retVal;inv=!!inv;for(var i=0,length=elems.length;i<length;i++){retVal=!!callback(elems[i],i);if(inv!==retVal){ret.push(elems[i]);}}
return ret;},map:function(elems,callback,arg){var value,key,ret=[],i=0,length=elems.length,isArray=elems instanceof jQuery||length!==undefined&&typeof length==="number"&&((length>0&&elems[0]&&elems[length-1])||length===0||jQuery.isArray(elems));if(isArray){for(;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret[ret.length]=value;}}}else{for(key in elems){value=callback(elems[key],key,arg);if(value!=null){ret[ret.length]=value;}}}
return ret.concat.apply([],ret);},guid:1,proxy:function(fn,context){if(typeof context==="string"){var tmp=fn[context];context=fn;fn=tmp;}
if(!jQuery.isFunction(fn)){return undefined;}
var args=slice.call(arguments,2),proxy=function(){return fn.apply(context,args.concat(slice.call(arguments)));};proxy.guid=fn.guid=fn.guid||proxy.guid||jQuery.guid++;return proxy;},access:function(elems,fn,key,value,chainable,emptyGet,pass){var exec,bulk=key==null,i=0,length=elems.length;if(key&&typeof key==="object"){for(i in key){jQuery.access(elems,fn,i,key[i],1,emptyGet,value);}
chainable=1;}else if(value!==undefined){exec=pass===undefined&&jQuery.isFunction(value);if(bulk){if(exec){exec=fn;fn=function(elem,key,value){return exec.call(jQuery(elem),value);};}else{fn.call(elems,value);fn=null;}}
if(fn){for(;i<length;i++){fn(elems[i],key,exec?value.call(elems[i],i,fn(elems[i],key)):value,pass);}}
chainable=1;}
return chainable?elems:bulk?fn.call(elems):length?fn(elems[0],key):emptyGet;},now:function(){return(new Date()).getTime();},uaMatch:function(ua){ua=ua.toLowerCase();var match=rwebkit.exec(ua)||ropera.exec(ua)||rmsie.exec(ua)||ua.indexOf("compatible")<0&&rmozilla.exec(ua)||[];return{browser:match[1]||"",version:match[2]||"0"};},sub:function(){function jQuerySub(selector,context){return new jQuerySub.fn.init(selector,context);}
jQuery.extend(true,jQuerySub,this);jQuerySub.superclass=this;jQuerySub.fn=jQuerySub.prototype=this();jQuerySub.fn.constructor=jQuerySub;jQuerySub.sub=this.sub;jQuerySub.fn.init=function init(selector,context){if(context&&context instanceof jQuery&&!(context instanceof jQuerySub)){context=jQuerySub(context);}
return jQuery.fn.init.call(this,selector,context,rootjQuerySub);};jQuerySub.fn.init.prototype=jQuerySub.fn;var rootjQuerySub=jQuerySub(document);return jQuerySub;},browser:{}});jQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "),function(i,name){class2type["[object "+name+"]"]=name.toLowerCase();});browserMatch=jQuery.uaMatch(userAgent);if(browserMatch.browser){jQuery.browser[browserMatch.browser]=true;jQuery.browser.version=browserMatch.version;}
if(jQuery.browser.webkit){jQuery.browser.safari=true;}
if(rnotwhite.test("\xA0")){trimLeft=/^[\s\xA0]+/;trimRight=/[\s\xA0]+$/;}
rootjQuery=jQuery(document);if(document.addEventListener){DOMContentLoaded=function(){document.removeEventListener("DOMContentLoaded",DOMContentLoaded,false);jQuery.ready();};}else if(document.attachEvent){DOMContentLoaded=function(){if(document.readyState==="complete"){document.detachEvent("onreadystatechange",DOMContentLoaded);jQuery.ready();}};}
function doScrollCheck(){if(jQuery.isReady){return;}
try{document.documentElement.doScroll("left");}catch(e){setTimeout(doScrollCheck,1);return;}
jQuery.ready();}
return jQuery;})();var flagsCache={};function createFlags(flags){var object=flagsCache[flags]={},i,length;flags=flags.split(/\s+/);for(i=0,length=flags.length;i<length;i++){object[flags[i]]=true;}
return object;}
jQuery.Callbacks=function(flags){flags=flags?(flagsCache[flags]||createFlags(flags)):{};var
list=[],stack=[],memory,fired,firing,firingStart,firingLength,firingIndex,add=function(args){var i,length,elem,type,actual;for(i=0,length=args.length;i<length;i++){elem=args[i];type=jQuery.type(elem);if(type==="array"){add(elem);}else if(type==="function"){if(!flags.unique||!self.has(elem)){list.push(elem);}}}},fire=function(context,args){args=args||[];memory=!flags.memory||[context,args];fired=true;firing=true;firingIndex=firingStart||0;firingStart=0;firingLength=list.length;for(;list&&firingIndex<firingLength;firingIndex++){if(list[firingIndex].apply(context,args)===false&&flags.stopOnFalse){memory=true;break;}}
firing=false;if(list){if(!flags.once){if(stack&&stack.length){memory=stack.shift();self.fireWith(memory[0],memory[1]);}}else if(memory===true){self.disable();}else{list=[];}}},self={add:function(){if(list){var length=list.length;add(arguments);if(firing){firingLength=list.length;}else if(memory&&memory!==true){firingStart=length;fire(memory[0],memory[1]);}}
return this;},remove:function(){if(list){var args=arguments,argIndex=0,argLength=args.length;for(;argIndex<argLength;argIndex++){for(var i=0;i<list.length;i++){if(args[argIndex]===list[i]){if(firing){if(i<=firingLength){firingLength--;if(i<=firingIndex){firingIndex--;}}}
list.splice(i--,1);if(flags.unique){break;}}}}}
return this;},has:function(fn){if(list){var i=0,length=list.length;for(;i<length;i++){if(fn===list[i]){return true;}}}
return false;},empty:function(){list=[];return this;},disable:function(){list=stack=memory=undefined;return this;},disabled:function(){return!list;},lock:function(){stack=undefined;if(!memory||memory===true){self.disable();}
return this;},locked:function(){return!stack;},fireWith:function(context,args){if(stack){if(firing){if(!flags.once){stack.push([context,args]);}}else if(!(flags.once&&memory)){fire(context,args);}}
return this;},fire:function(){self.fireWith(this,arguments);return this;},fired:function(){return!!fired;}};return self;};var
sliceDeferred=[].slice;jQuery.extend({Deferred:function(func){var doneList=jQuery.Callbacks("once memory"),failList=jQuery.Callbacks("once memory"),progressList=jQuery.Callbacks("memory"),state="pending",lists={resolve:doneList,reject:failList,notify:progressList},promise={done:doneList.add,fail:failList.add,progress:progressList.add,state:function(){return state;},isResolved:doneList.fired,isRejected:failList.fired,then:function(doneCallbacks,failCallbacks,progressCallbacks){deferred.done(doneCallbacks).fail(failCallbacks).progress(progressCallbacks);return this;},always:function(){deferred.done.apply(deferred,arguments).fail.apply(deferred,arguments);return this;},pipe:function(fnDone,fnFail,fnProgress){return jQuery.Deferred(function(newDefer){jQuery.each({done:[fnDone,"resolve"],fail:[fnFail,"reject"],progress:[fnProgress,"notify"]},function(handler,data){var fn=data[0],action=data[1],returned;if(jQuery.isFunction(fn)){deferred[handler](function(){returned=fn.apply(this,arguments);if(returned&&jQuery.isFunction(returned.promise)){returned.promise().then(newDefer.resolve,newDefer.reject,newDefer.notify);}else{newDefer[action+"With"](this===deferred?newDefer:this,[returned]);}});}else{deferred[handler](newDefer[action]);}});}).promise();},promise:function(obj){if(obj==null){obj=promise;}else{for(var key in promise){obj[key]=promise[key];}}
return obj;}},deferred=promise.promise({}),key;for(key in lists){deferred[key]=lists[key].fire;deferred[key+"With"]=lists[key].fireWith;}
deferred.done(function(){state="resolved";},failList.disable,progressList.lock).fail(function(){state="rejected";},doneList.disable,progressList.lock);if(func){func.call(deferred,deferred);}
return deferred;},when:function(firstParam){var args=sliceDeferred.call(arguments,0),i=0,length=args.length,pValues=new Array(length),count=length,pCount=length,deferred=length<=1&&firstParam&&jQuery.isFunction(firstParam.promise)?firstParam:jQuery.Deferred(),promise=deferred.promise();function resolveFunc(i){return function(value){args[i]=arguments.length>1?sliceDeferred.call(arguments,0):value;if(!(--count)){deferred.resolveWith(deferred,args);}};}
function progressFunc(i){return function(value){pValues[i]=arguments.length>1?sliceDeferred.call(arguments,0):value;deferred.notifyWith(promise,pValues);};}
if(length>1){for(;i<length;i++){if(args[i]&&args[i].promise&&jQuery.isFunction(args[i].promise)){args[i].promise().then(resolveFunc(i),deferred.reject,progressFunc(i));}else{--count;}}
if(!count){deferred.resolveWith(deferred,args);}}else if(deferred!==firstParam){deferred.resolveWith(deferred,length?[firstParam]:[]);}
return promise;}});jQuery.support=(function(){var support,all,a,select,opt,input,fragment,tds,events,eventName,i,isSupported,div=document.createElement("div"),documentElement=document.documentElement;div.setAttribute("className","t");div.innerHTML="   <link/><table></table><a href='/a' style='top:1px;float:left;opacity:.55;'>a</a><input type='checkbox'/>";all=div.getElementsByTagName("*");a=div.getElementsByTagName("a")[0];if(!all||!all.length||!a){return{};}
select=document.createElement("select");opt=select.appendChild(document.createElement("option"));input=div.getElementsByTagName("input")[0];support={leadingWhitespace:(div.firstChild.nodeType===3),tbody:!div.getElementsByTagName("tbody").length,htmlSerialize:!!div.getElementsByTagName("link").length,style:/top/.test(a.getAttribute("style")),hrefNormalized:(a.getAttribute("href")==="/a"),opacity:/^0.55/.test(a.style.opacity),cssFloat:!!a.style.cssFloat,checkOn:(input.value==="on"),optSelected:opt.selected,getSetAttribute:div.className!=="t",enctype:!!document.createElement("form").enctype,html5Clone:document.createElement("nav").cloneNode(true).outerHTML!=="<:nav></:nav>",submitBubbles:true,changeBubbles:true,focusinBubbles:false,deleteExpando:true,noCloneEvent:true,inlineBlockNeedsLayout:false,shrinkWrapBlocks:false,reliableMarginRight:true,pixelMargin:true};jQuery.boxModel=support.boxModel=(document.compatMode==="CSS1Compat");input.checked=true;support.noCloneChecked=input.cloneNode(true).checked;select.disabled=true;support.optDisabled=!opt.disabled;try{delete div.test;}catch(e){support.deleteExpando=false;}
if(!div.addEventListener&&div.attachEvent&&div.fireEvent){div.attachEvent("onclick",function(){support.noCloneEvent=false;});div.cloneNode(true).fireEvent("onclick");}
input=document.createElement("input");input.value="t";input.setAttribute("type","radio");support.radioValue=input.value==="t";input.setAttribute("checked","checked");input.setAttribute("name","t");div.appendChild(input);fragment=document.createDocumentFragment();fragment.appendChild(div.lastChild);support.checkClone=fragment.cloneNode(true).cloneNode(true).lastChild.checked;support.appendChecked=input.checked;fragment.removeChild(input);fragment.appendChild(div);if(div.attachEvent){for(i in{submit:1,change:1,focusin:1}){eventName="on"+i;isSupported=(eventName in div);if(!isSupported){div.setAttribute(eventName,"return;");isSupported=(typeof div[eventName]==="function");}
support[i+"Bubbles"]=isSupported;}}
fragment.removeChild(div);fragment=select=opt=div=input=null;jQuery(function(){var container,outer,inner,table,td,offsetSupport,marginDiv,conMarginTop,style,html,positionTopLeftWidthHeight,paddingMarginBorderVisibility,paddingMarginBorder,body=document.getElementsByTagName("body")[0];if(!body){return;}
conMarginTop=1;paddingMarginBorder="padding:0;margin:0;border:";positionTopLeftWidthHeight="position:absolute;top:0;left:0;width:1px;height:1px;";paddingMarginBorderVisibility=paddingMarginBorder+"0;visibility:hidden;";style="style='"+positionTopLeftWidthHeight+paddingMarginBorder+"5px solid #000;";html="<div "+style+"display:block;'><div style='"+paddingMarginBorder+"0;display:block;overflow:hidden;'></div></div>"+"<table "+style+"' cellpadding='0' cellspacing='0'>"+"<tr><td></td></tr></table>";container=document.createElement("div");container.style.cssText=paddingMarginBorderVisibility+"width:0;height:0;position:static;top:0;margin-top:"+conMarginTop+"px";body.insertBefore(container,body.firstChild);div=document.createElement("div");container.appendChild(div);div.innerHTML="<table><tr><td style='"+paddingMarginBorder+"0;display:none'></td><td>t</td></tr></table>";tds=div.getElementsByTagName("td");isSupported=(tds[0].offsetHeight===0);tds[0].style.display="";tds[1].style.display="none";support.reliableHiddenOffsets=isSupported&&(tds[0].offsetHeight===0);if(window.getComputedStyle){div.innerHTML="";marginDiv=document.createElement("div");marginDiv.style.width="0";marginDiv.style.marginRight="0";div.style.width="2px";div.appendChild(marginDiv);support.reliableMarginRight=(parseInt((window.getComputedStyle(marginDiv,null)||{marginRight:0}).marginRight,10)||0)===0;}
if(typeof div.style.zoom!=="undefined"){div.innerHTML="";div.style.width=div.style.padding="1px";div.style.border=0;div.style.overflow="hidden";div.style.display="inline";div.style.zoom=1;support.inlineBlockNeedsLayout=(div.offsetWidth===3);div.style.display="block";div.style.overflow="visible";div.innerHTML="<div style='width:5px;'></div>";support.shrinkWrapBlocks=(div.offsetWidth!==3);}
div.style.cssText=positionTopLeftWidthHeight+paddingMarginBorderVisibility;div.innerHTML=html;outer=div.firstChild;inner=outer.firstChild;td=outer.nextSibling.firstChild.firstChild;offsetSupport={doesNotAddBorder:(inner.offsetTop!==5),doesAddBorderForTableAndCells:(td.offsetTop===5)};inner.style.position="fixed";inner.style.top="20px";offsetSupport.fixedPosition=(inner.offsetTop===20||inner.offsetTop===15);inner.style.position=inner.style.top="";outer.style.overflow="hidden";outer.style.position="relative";offsetSupport.subtractsBorderForOverflowNotVisible=(inner.offsetTop===-5);offsetSupport.doesNotIncludeMarginInBodyOffset=(body.offsetTop!==conMarginTop);if(window.getComputedStyle){div.style.marginTop="1%";support.pixelMargin=(window.getComputedStyle(div,null)||{marginTop:0}).marginTop!=="1%";}
if(typeof container.style.zoom!=="undefined"){container.style.zoom=1;}
body.removeChild(container);marginDiv=div=container=null;jQuery.extend(support,offsetSupport);});return support;})();var rbrace=/^(?:\{.*\}|\[.*\])$/,rmultiDash=/([A-Z])/g;jQuery.extend({cache:{},uuid:0,expando:"jQuery"+(jQuery.fn.jquery+Math.random()).replace(/\D/g,""),noData:{"embed":true,"object":"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000","applet":true},hasData:function(elem){elem=elem.nodeType?jQuery.cache[elem[jQuery.expando]]:elem[jQuery.expando];return!!elem&&!isEmptyDataObject(elem);},data:function(elem,name,data,pvt){if(!jQuery.acceptData(elem)){return;}
var privateCache,thisCache,ret,internalKey=jQuery.expando,getByName=typeof name==="string",isNode=elem.nodeType,cache=isNode?jQuery.cache:elem,id=isNode?elem[internalKey]:elem[internalKey]&&internalKey,isEvents=name==="events";if((!id||!cache[id]||(!isEvents&&!pvt&&!cache[id].data))&&getByName&&data===undefined){return;}
if(!id){if(isNode){elem[internalKey]=id=++jQuery.uuid;}else{id=internalKey;}}
if(!cache[id]){cache[id]={};if(!isNode){cache[id].toJSON=jQuery.noop;}}
if(typeof name==="object"||typeof name==="function"){if(pvt){cache[id]=jQuery.extend(cache[id],name);}else{cache[id].data=jQuery.extend(cache[id].data,name);}}
privateCache=thisCache=cache[id];if(!pvt){if(!thisCache.data){thisCache.data={};}
thisCache=thisCache.data;}
if(data!==undefined){thisCache[jQuery.camelCase(name)]=data;}
if(isEvents&&!thisCache[name]){return privateCache.events;}
if(getByName){ret=thisCache[name];if(ret==null){ret=thisCache[jQuery.camelCase(name)];}}else{ret=thisCache;}
return ret;},removeData:function(elem,name,pvt){if(!jQuery.acceptData(elem)){return;}
var thisCache,i,l,internalKey=jQuery.expando,isNode=elem.nodeType,cache=isNode?jQuery.cache:elem,id=isNode?elem[internalKey]:internalKey;if(!cache[id]){return;}
if(name){thisCache=pvt?cache[id]:cache[id].data;if(thisCache){if(!jQuery.isArray(name)){if(name in thisCache){name=[name];}else{name=jQuery.camelCase(name);if(name in thisCache){name=[name];}else{name=name.split(" ");}}}
for(i=0,l=name.length;i<l;i++){delete thisCache[name[i]];}
if(!(pvt?isEmptyDataObject:jQuery.isEmptyObject)(thisCache)){return;}}}
if(!pvt){delete cache[id].data;if(!isEmptyDataObject(cache[id])){return;}}
if(jQuery.support.deleteExpando||!cache.setInterval){delete cache[id];}else{cache[id]=null;}
if(isNode){if(jQuery.support.deleteExpando){delete elem[internalKey];}else if(elem.removeAttribute){elem.removeAttribute(internalKey);}else{elem[internalKey]=null;}}},_data:function(elem,name,data){return jQuery.data(elem,name,data,true);},acceptData:function(elem){if(elem.nodeName){var match=jQuery.noData[elem.nodeName.toLowerCase()];if(match){return!(match===true||elem.getAttribute("classid")!==match);}}
return true;}});jQuery.fn.extend({data:function(key,value){var parts,part,attr,name,l,elem=this[0],i=0,data=null;if(key===undefined){if(this.length){data=jQuery.data(elem);if(elem.nodeType===1&&!jQuery._data(elem,"parsedAttrs")){attr=elem.attributes;for(l=attr.length;i<l;i++){name=attr[i].name;if(name.indexOf("data-")===0){name=jQuery.camelCase(name.substring(5));dataAttr(elem,name,data[name]);}}
jQuery._data(elem,"parsedAttrs",true);}}
return data;}
if(typeof key==="object"){return this.each(function(){jQuery.data(this,key);});}
parts=key.split(".",2);parts[1]=parts[1]?"."+parts[1]:"";part=parts[1]+"!";return jQuery.access(this,function(value){if(value===undefined){data=this.triggerHandler("getData"+part,[parts[0]]);if(data===undefined&&elem){data=jQuery.data(elem,key);data=dataAttr(elem,key,data);}
return data===undefined&&parts[1]?this.data(parts[0]):data;}
parts[1]=value;this.each(function(){var self=jQuery(this);self.triggerHandler("setData"+part,parts);jQuery.data(this,key,value);self.triggerHandler("changeData"+part,parts);});},null,value,arguments.length>1,null,false);},removeData:function(key){return this.each(function(){jQuery.removeData(this,key);});}});function dataAttr(elem,key,data){if(data===undefined&&elem.nodeType===1){var name="data-"+key.replace(rmultiDash,"-$1").toLowerCase();data=elem.getAttribute(name);if(typeof data==="string"){try{data=data==="true"?true:data==="false"?false:data==="null"?null:jQuery.isNumeric(data)?+data:rbrace.test(data)?jQuery.parseJSON(data):data;}catch(e){}
jQuery.data(elem,key,data);}else{data=undefined;}}
return data;}
function isEmptyDataObject(obj){for(var name in obj){if(name==="data"&&jQuery.isEmptyObject(obj[name])){continue;}
if(name!=="toJSON"){return false;}}
return true;}
function handleQueueMarkDefer(elem,type,src){var deferDataKey=type+"defer",queueDataKey=type+"queue",markDataKey=type+"mark",defer=jQuery._data(elem,deferDataKey);if(defer&&(src==="queue"||!jQuery._data(elem,queueDataKey))&&(src==="mark"||!jQuery._data(elem,markDataKey))){setTimeout(function(){if(!jQuery._data(elem,queueDataKey)&&!jQuery._data(elem,markDataKey)){jQuery.removeData(elem,deferDataKey,true);defer.fire();}},0);}}
jQuery.extend({_mark:function(elem,type){if(elem){type=(type||"fx")+"mark";jQuery._data(elem,type,(jQuery._data(elem,type)||0)+1);}},_unmark:function(force,elem,type){if(force!==true){type=elem;elem=force;force=false;}
if(elem){type=type||"fx";var key=type+"mark",count=force?0:((jQuery._data(elem,key)||1)-1);if(count){jQuery._data(elem,key,count);}else{jQuery.removeData(elem,key,true);handleQueueMarkDefer(elem,type,"mark");}}},queue:function(elem,type,data){var q;if(elem){type=(type||"fx")+"queue";q=jQuery._data(elem,type);if(data){if(!q||jQuery.isArray(data)){q=jQuery._data(elem,type,jQuery.makeArray(data));}else{q.push(data);}}
return q||[];}},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),fn=queue.shift(),hooks={};if(fn==="inprogress"){fn=queue.shift();}
if(fn){if(type==="fx"){queue.unshift("inprogress");}
jQuery._data(elem,type+".run",hooks);fn.call(elem,function(){jQuery.dequeue(elem,type);},hooks);}
if(!queue.length){jQuery.removeData(elem,type+"queue "+type+".run",true);handleQueueMarkDefer(elem,type,"queue");}}});jQuery.fn.extend({queue:function(type,data){var setter=2;if(typeof type!=="string"){data=type;type="fx";setter--;}
if(arguments.length<setter){return jQuery.queue(this[0],type);}
return data===undefined?this:this.each(function(){var queue=jQuery.queue(this,type,data);if(type==="fx"&&queue[0]!=="inprogress"){jQuery.dequeue(this,type);}});},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type);});},delay:function(time,type){time=jQuery.fx?jQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,function(next,hooks){var timeout=setTimeout(next,time);hooks.stop=function(){clearTimeout(timeout);};});},clearQueue:function(type){return this.queue(type||"fx",[]);},promise:function(type,object){if(typeof type!=="string"){object=type;type=undefined;}
type=type||"fx";var defer=jQuery.Deferred(),elements=this,i=elements.length,count=1,deferDataKey=type+"defer",queueDataKey=type+"queue",markDataKey=type+"mark",tmp;function resolve(){if(!(--count)){defer.resolveWith(elements,[elements]);}}
while(i--){if((tmp=jQuery.data(elements[i],deferDataKey,undefined,true)||(jQuery.data(elements[i],queueDataKey,undefined,true)||jQuery.data(elements[i],markDataKey,undefined,true))&&jQuery.data(elements[i],deferDataKey,jQuery.Callbacks("once memory"),true))){count++;tmp.add(resolve);}}
resolve();return defer.promise(object);}});var rclass=/[\n\t\r]/g,rspace=/\s+/,rreturn=/\r/g,rtype=/^(?:button|input)$/i,rfocusable=/^(?:button|input|object|select|textarea)$/i,rclickable=/^a(?:rea)?$/i,rboolean=/^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,getSetAttribute=jQuery.support.getSetAttribute,nodeHook,boolHook,fixSpecified;jQuery.fn.extend({attr:function(name,value){return jQuery.access(this,jQuery.attr,name,value,arguments.length>1);},removeAttr:function(name){return this.each(function(){jQuery.removeAttr(this,name);});},prop:function(name,value){return jQuery.access(this,jQuery.prop,name,value,arguments.length>1);},removeProp:function(name){name=jQuery.propFix[name]||name;return this.each(function(){try{this[name]=undefined;delete this[name];}catch(e){}});},addClass:function(value){var classNames,i,l,elem,setClass,c,cl;if(jQuery.isFunction(value)){return this.each(function(j){jQuery(this).addClass(value.call(this,j,this.className));});}
if(value&&typeof value==="string"){classNames=value.split(rspace);for(i=0,l=this.length;i<l;i++){elem=this[i];if(elem.nodeType===1){if(!elem.className&&classNames.length===1){elem.className=value;}else{setClass=" "+elem.className+" ";for(c=0,cl=classNames.length;c<cl;c++){if(!~setClass.indexOf(" "+classNames[c]+" ")){setClass+=classNames[c]+" ";}}
elem.className=jQuery.trim(setClass);}}}}
return this;},removeClass:function(value){var classNames,i,l,elem,className,c,cl;if(jQuery.isFunction(value)){return this.each(function(j){jQuery(this).removeClass(value.call(this,j,this.className));});}
if((value&&typeof value==="string")||value===undefined){classNames=(value||"").split(rspace);for(i=0,l=this.length;i<l;i++){elem=this[i];if(elem.nodeType===1&&elem.className){if(value){className=(" "+elem.className+" ").replace(rclass," ");for(c=0,cl=classNames.length;c<cl;c++){className=className.replace(" "+classNames[c]+" "," ");}
elem.className=jQuery.trim(className);}else{elem.className="";}}}}
return this;},toggleClass:function(value,stateVal){var type=typeof value,isBool=typeof stateVal==="boolean";if(jQuery.isFunction(value)){return this.each(function(i){jQuery(this).toggleClass(value.call(this,i,this.className,stateVal),stateVal);});}
return this.each(function(){if(type==="string"){var className,i=0,self=jQuery(this),state=stateVal,classNames=value.split(rspace);while((className=classNames[i++])){state=isBool?state:!self.hasClass(className);self[state?"addClass":"removeClass"](className);}}else if(type==="undefined"||type==="boolean"){if(this.className){jQuery._data(this,"__className__",this.className);}
this.className=this.className||value===false?"":jQuery._data(this,"__className__")||"";}});},hasClass:function(selector){var className=" "+selector+" ",i=0,l=this.length;for(;i<l;i++){if(this[i].nodeType===1&&(" "+this[i].className+" ").replace(rclass," ").indexOf(className)>-1){return true;}}
return false;},val:function(value){var hooks,ret,isFunction,elem=this[0];if(!arguments.length){if(elem){hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()];if(hooks&&"get"in hooks&&(ret=hooks.get(elem,"value"))!==undefined){return ret;}
ret=elem.value;return typeof ret==="string"?ret.replace(rreturn,""):ret==null?"":ret;}
return;}
isFunction=jQuery.isFunction(value);return this.each(function(i){var self=jQuery(this),val;if(this.nodeType!==1){return;}
if(isFunction){val=value.call(this,i,self.val());}else{val=value;}
if(val==null){val="";}else if(typeof val==="number"){val+="";}else if(jQuery.isArray(val)){val=jQuery.map(val,function(value){return value==null?"":value+"";});}
hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!hooks||!("set"in hooks)||hooks.set(this,val,"value")===undefined){this.value=val;}});}});jQuery.extend({valHooks:{option:{get:function(elem){var val=elem.attributes.value;return!val||val.specified?elem.value:elem.text;}},select:{get:function(elem){var value,i,max,option,index=elem.selectedIndex,values=[],options=elem.options,one=elem.type==="select-one";if(index<0){return null;}
i=one?index:0;max=one?index+1:options.length;for(;i<max;i++){option=options[i];if(option.selected&&(jQuery.support.optDisabled?!option.disabled:option.getAttribute("disabled")===null)&&(!option.parentNode.disabled||!jQuery.nodeName(option.parentNode,"optgroup"))){value=jQuery(option).val();if(one){return value;}
values.push(value);}}
if(one&&!values.length&&options.length){return jQuery(options[index]).val();}
return values;},set:function(elem,value){var values=jQuery.makeArray(value);jQuery(elem).find("option").each(function(){this.selected=jQuery.inArray(jQuery(this).val(),values)>=0;});if(!values.length){elem.selectedIndex=-1;}
return values;}}},attrFn:{val:true,css:true,html:true,text:true,data:true,width:true,height:true,offset:true},attr:function(elem,name,value,pass){var ret,hooks,notxml,nType=elem.nodeType;if(!elem||nType===3||nType===8||nType===2){return;}
if(pass&&name in jQuery.attrFn){return jQuery(elem)[name](value);}
if(typeof elem.getAttribute==="undefined"){return jQuery.prop(elem,name,value);}
notxml=nType!==1||!jQuery.isXMLDoc(elem);if(notxml){name=name.toLowerCase();hooks=jQuery.attrHooks[name]||(rboolean.test(name)?boolHook:nodeHook);}
if(value!==undefined){if(value===null){jQuery.removeAttr(elem,name);return;}else if(hooks&&"set"in hooks&&notxml&&(ret=hooks.set(elem,value,name))!==undefined){return ret;}else{elem.setAttribute(name,""+value);return value;}}else if(hooks&&"get"in hooks&&notxml&&(ret=hooks.get(elem,name))!==null){return ret;}else{ret=elem.getAttribute(name);return ret===null?undefined:ret;}},removeAttr:function(elem,value){var propName,attrNames,name,l,isBool,i=0;if(value&&elem.nodeType===1){attrNames=value.toLowerCase().split(rspace);l=attrNames.length;for(;i<l;i++){name=attrNames[i];if(name){propName=jQuery.propFix[name]||name;isBool=rboolean.test(name);if(!isBool){jQuery.attr(elem,name,"");}
elem.removeAttribute(getSetAttribute?name:propName);if(isBool&&propName in elem){elem[propName]=false;}}}}},attrHooks:{type:{set:function(elem,value){if(rtype.test(elem.nodeName)&&elem.parentNode){jQuery.error("type property can't be changed");}else if(!jQuery.support.radioValue&&value==="radio"&&jQuery.nodeName(elem,"input")){var val=elem.value;elem.setAttribute("type",value);if(val){elem.value=val;}
return value;}}},value:{get:function(elem,name){if(nodeHook&&jQuery.nodeName(elem,"button")){return nodeHook.get(elem,name);}
return name in elem?elem.value:null;},set:function(elem,value,name){if(nodeHook&&jQuery.nodeName(elem,"button")){return nodeHook.set(elem,value,name);}
elem.value=value;}}},propFix:{tabindex:"tabIndex",readonly:"readOnly","for":"htmlFor","class":"className",maxlength:"maxLength",cellspacing:"cellSpacing",cellpadding:"cellPadding",rowspan:"rowSpan",colspan:"colSpan",usemap:"useMap",frameborder:"frameBorder",contenteditable:"contentEditable"},prop:function(elem,name,value){var ret,hooks,notxml,nType=elem.nodeType;if(!elem||nType===3||nType===8||nType===2){return;}
notxml=nType!==1||!jQuery.isXMLDoc(elem);if(notxml){name=jQuery.propFix[name]||name;hooks=jQuery.propHooks[name];}
if(value!==undefined){if(hooks&&"set"in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret;}else{return(elem[name]=value);}}else{if(hooks&&"get"in hooks&&(ret=hooks.get(elem,name))!==null){return ret;}else{return elem[name];}}},propHooks:{tabIndex:{get:function(elem){var attributeNode=elem.getAttributeNode("tabindex");return attributeNode&&attributeNode.specified?parseInt(attributeNode.value,10):rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href?0:undefined;}}}});jQuery.attrHooks.tabindex=jQuery.propHooks.tabIndex;boolHook={get:function(elem,name){var attrNode,property=jQuery.prop(elem,name);return property===true||typeof property!=="boolean"&&(attrNode=elem.getAttributeNode(name))&&attrNode.nodeValue!==false?name.toLowerCase():undefined;},set:function(elem,value,name){var propName;if(value===false){jQuery.removeAttr(elem,name);}else{propName=jQuery.propFix[name]||name;if(propName in elem){elem[propName]=true;}
elem.setAttribute(name,name.toLowerCase());}
return name;}};if(!getSetAttribute){fixSpecified={name:true,id:true,coords:true};nodeHook=jQuery.valHooks.button={get:function(elem,name){var ret;ret=elem.getAttributeNode(name);return ret&&(fixSpecified[name]?ret.nodeValue!=="":ret.specified)?ret.nodeValue:undefined;},set:function(elem,value,name){var ret=elem.getAttributeNode(name);if(!ret){ret=document.createAttribute(name);elem.setAttributeNode(ret);}
return(ret.nodeValue=value+"");}};jQuery.attrHooks.tabindex.set=nodeHook.set;jQuery.each(["width","height"],function(i,name){jQuery.attrHooks[name]=jQuery.extend(jQuery.attrHooks[name],{set:function(elem,value){if(value===""){elem.setAttribute(name,"auto");return value;}}});});jQuery.attrHooks.contenteditable={get:nodeHook.get,set:function(elem,value,name){if(value===""){value="false";}
nodeHook.set(elem,value,name);}};}
if(!jQuery.support.hrefNormalized){jQuery.each(["href","src","width","height"],function(i,name){jQuery.attrHooks[name]=jQuery.extend(jQuery.attrHooks[name],{get:function(elem){var ret=elem.getAttribute(name,2);return ret===null?undefined:ret;}});});}
if(!jQuery.support.style){jQuery.attrHooks.style={get:function(elem){return elem.style.cssText.toLowerCase()||undefined;},set:function(elem,value){return(elem.style.cssText=""+value);}};}
if(!jQuery.support.optSelected){jQuery.propHooks.selected=jQuery.extend(jQuery.propHooks.selected,{get:function(elem){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex;}}
return null;}});}
if(!jQuery.support.enctype){jQuery.propFix.enctype="encoding";}
if(!jQuery.support.checkOn){jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]={get:function(elem){return elem.getAttribute("value")===null?"on":elem.value;}};});}
jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]=jQuery.extend(jQuery.valHooks[this],{set:function(elem,value){if(jQuery.isArray(value)){return(elem.checked=jQuery.inArray(jQuery(elem).val(),value)>=0);}}});});var rformElems=/^(?:textarea|input|select)$/i,rtypenamespace=/^([^\.]*)?(?:\.(.+))?$/,rhoverHack=/(?:^|\s)hover(\.\S+)?\b/,rkeyEvent=/^key/,rmouseEvent=/^(?:mouse|contextmenu)|click/,rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,rquickIs=/^(\w*)(?:#([\w\-]+))?(?:\.([\w\-]+))?$/,quickParse=function(selector){var quick=rquickIs.exec(selector);if(quick){quick[1]=(quick[1]||"").toLowerCase();quick[3]=quick[3]&&new RegExp("(?:^|\\s)"+quick[3]+"(?:\\s|$)");}
return quick;},quickIs=function(elem,m){var attrs=elem.attributes||{};return((!m[1]||elem.nodeName.toLowerCase()===m[1])&&(!m[2]||(attrs.id||{}).value===m[2])&&(!m[3]||m[3].test((attrs["class"]||{}).value)));},hoverHack=function(events){return jQuery.event.special.hover?events:events.replace(rhoverHack,"mouseenter$1 mouseleave$1");};jQuery.event={add:function(elem,types,handler,data,selector){var elemData,eventHandle,events,t,tns,type,namespaces,handleObj,handleObjIn,quick,handlers,special;if(elem.nodeType===3||elem.nodeType===8||!types||!handler||!(elemData=jQuery._data(elem))){return;}
if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;selector=handleObjIn.selector;}
if(!handler.guid){handler.guid=jQuery.guid++;}
events=elemData.events;if(!events){elemData.events=events={};}
eventHandle=elemData.handle;if(!eventHandle){elemData.handle=eventHandle=function(e){return typeof jQuery!=="undefined"&&(!e||jQuery.event.triggered!==e.type)?jQuery.event.dispatch.apply(eventHandle.elem,arguments):undefined;};eventHandle.elem=elem;}
types=jQuery.trim(hoverHack(types)).split(" ");for(t=0;t<types.length;t++){tns=rtypenamespace.exec(types[t])||[];type=tns[1];namespaces=(tns[2]||"").split(".").sort();special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;special=jQuery.event.special[type]||{};handleObj=jQuery.extend({type:type,origType:tns[1],data:data,handler:handler,guid:handler.guid,selector:selector,quick:selector&&quickParse(selector),namespace:namespaces.join(".")},handleObjIn);handlers=events[type];if(!handlers){handlers=events[type]=[];handlers.delegateCount=0;if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===false){if(elem.addEventListener){elem.addEventListener(type,eventHandle,false);}else if(elem.attachEvent){elem.attachEvent("on"+type,eventHandle);}}}
if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid;}}
if(selector){handlers.splice(handlers.delegateCount++,0,handleObj);}else{handlers.push(handleObj);}
jQuery.event.global[type]=true;}
elem=null;},global:{},remove:function(elem,types,handler,selector,mappedTypes){var elemData=jQuery.hasData(elem)&&jQuery._data(elem),t,tns,type,origType,namespaces,origCount,j,events,special,handle,eventType,handleObj;if(!elemData||!(events=elemData.events)){return;}
types=jQuery.trim(hoverHack(types||"")).split(" ");for(t=0;t<types.length;t++){tns=rtypenamespace.exec(types[t])||[];type=origType=tns[1];namespaces=tns[2];if(!type){for(type in events){jQuery.event.remove(elem,type+types[t],handler,selector,true);}
continue;}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;eventType=events[type]||[];origCount=eventType.length;namespaces=namespaces?new RegExp("(^|\\.)"+namespaces.split(".").sort().join("\\.(?:.*\\.)?")+"(\\.|$)"):null;for(j=0;j<eventType.length;j++){handleObj=eventType[j];if((mappedTypes||origType===handleObj.origType)&&(!handler||handler.guid===handleObj.guid)&&(!namespaces||namespaces.test(handleObj.namespace))&&(!selector||selector===handleObj.selector||selector==="**"&&handleObj.selector)){eventType.splice(j--,1);if(handleObj.selector){eventType.delegateCount--;}
if(special.remove){special.remove.call(elem,handleObj);}}}
if(eventType.length===0&&origCount!==eventType.length){if(!special.teardown||special.teardown.call(elem,namespaces)===false){jQuery.removeEvent(elem,type,elemData.handle);}
delete events[type];}}
if(jQuery.isEmptyObject(events)){handle=elemData.handle;if(handle){handle.elem=null;}
jQuery.removeData(elem,["events","handle"],true);}},customEvent:{"getData":true,"setData":true,"changeData":true},trigger:function(event,data,elem,onlyHandlers){if(elem&&(elem.nodeType===3||elem.nodeType===8)){return;}
var type=event.type||event,namespaces=[],cache,exclusive,i,cur,old,ontype,special,handle,eventPath,bubbleType;if(rfocusMorph.test(type+jQuery.event.triggered)){return;}
if(type.indexOf("!")>=0){type=type.slice(0,-1);exclusive=true;}
if(type.indexOf(".")>=0){namespaces=type.split(".");type=namespaces.shift();namespaces.sort();}
if((!elem||jQuery.event.customEvent[type])&&!jQuery.event.global[type]){return;}
event=typeof event==="object"?event[jQuery.expando]?event:new jQuery.Event(type,event):new jQuery.Event(type);event.type=type;event.isTrigger=true;event.exclusive=exclusive;event.namespace=namespaces.join(".");event.namespace_re=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.)?")+"(\\.|$)"):null;ontype=type.indexOf(":")<0?"on"+type:"";if(!elem){cache=jQuery.cache;for(i in cache){if(cache[i].events&&cache[i].events[type]){jQuery.event.trigger(event,data,cache[i].handle.elem,true);}}
return;}
event.result=undefined;if(!event.target){event.target=elem;}
data=data!=null?jQuery.makeArray(data):[];data.unshift(event);special=jQuery.event.special[type]||{};if(special.trigger&&special.trigger.apply(elem,data)===false){return;}
eventPath=[[elem,special.bindType||type]];if(!onlyHandlers&&!special.noBubble&&!jQuery.isWindow(elem)){bubbleType=special.delegateType||type;cur=rfocusMorph.test(bubbleType+type)?elem:elem.parentNode;old=null;for(;cur;cur=cur.parentNode){eventPath.push([cur,bubbleType]);old=cur;}
if(old&&old===elem.ownerDocument){eventPath.push([old.defaultView||old.parentWindow||window,bubbleType]);}}
for(i=0;i<eventPath.length&&!event.isPropagationStopped();i++){cur=eventPath[i][0];event.type=eventPath[i][1];handle=(jQuery._data(cur,"events")||{})[event.type]&&jQuery._data(cur,"handle");if(handle){handle.apply(cur,data);}
handle=ontype&&cur[ontype];if(handle&&jQuery.acceptData(cur)&&handle.apply(cur,data)===false){event.preventDefault();}}
event.type=type;if(!onlyHandlers&&!event.isDefaultPrevented()){if((!special._default||special._default.apply(elem.ownerDocument,data)===false)&&!(type==="click"&&jQuery.nodeName(elem,"a"))&&jQuery.acceptData(elem)){if(ontype&&elem[type]&&((type!=="focus"&&type!=="blur")||event.target.offsetWidth!==0)&&!jQuery.isWindow(elem)){old=elem[ontype];if(old){elem[ontype]=null;}
jQuery.event.triggered=type;elem[type]();jQuery.event.triggered=undefined;if(old){elem[ontype]=old;}}}}
return event.result;},dispatch:function(event){event=jQuery.event.fix(event||window.event);var handlers=((jQuery._data(this,"events")||{})[event.type]||[]),delegateCount=handlers.delegateCount,args=[].slice.call(arguments,0),run_all=!event.exclusive&&!event.namespace,special=jQuery.event.special[event.type]||{},handlerQueue=[],i,j,cur,jqcur,ret,selMatch,matched,matches,handleObj,sel,related;args[0]=event;event.delegateTarget=this;if(special.preDispatch&&special.preDispatch.call(this,event)===false){return;}
if(delegateCount&&!(event.button&&event.type==="click")){jqcur=jQuery(this);jqcur.context=this.ownerDocument||this;for(cur=event.target;cur!=this;cur=cur.parentNode||this){if(cur.disabled!==true){selMatch={};matches=[];jqcur[0]=cur;for(i=0;i<delegateCount;i++){handleObj=handlers[i];sel=handleObj.selector;if(selMatch[sel]===undefined){selMatch[sel]=(handleObj.quick?quickIs(cur,handleObj.quick):jqcur.is(sel));}
if(selMatch[sel]){matches.push(handleObj);}}
if(matches.length){handlerQueue.push({elem:cur,matches:matches});}}}}
if(handlers.length>delegateCount){handlerQueue.push({elem:this,matches:handlers.slice(delegateCount)});}
for(i=0;i<handlerQueue.length&&!event.isPropagationStopped();i++){matched=handlerQueue[i];event.currentTarget=matched.elem;for(j=0;j<matched.matches.length&&!event.isImmediatePropagationStopped();j++){handleObj=matched.matches[j];if(run_all||(!event.namespace&&!handleObj.namespace)||event.namespace_re&&event.namespace_re.test(handleObj.namespace)){event.data=handleObj.data;event.handleObj=handleObj;ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args);if(ret!==undefined){event.result=ret;if(ret===false){event.preventDefault();event.stopPropagation();}}}}}
if(special.postDispatch){special.postDispatch.call(this,event);}
return event.result;},props:"attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(event,original){if(event.which==null){event.which=original.charCode!=null?original.charCode:original.keyCode;}
return event;}},mouseHooks:{props:"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(event,original){var eventDoc,doc,body,button=original.button,fromElement=original.fromElement;if(event.pageX==null&&original.clientX!=null){eventDoc=event.target.ownerDocument||document;doc=eventDoc.documentElement;body=eventDoc.body;event.pageX=original.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0);event.pageY=original.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0);}
if(!event.relatedTarget&&fromElement){event.relatedTarget=fromElement===event.target?original.toElement:fromElement;}
if(!event.which&&button!==undefined){event.which=(button&1?1:(button&2?3:(button&4?2:0)));}
return event;}},fix:function(event){if(event[jQuery.expando]){return event;}
var i,prop,originalEvent=event,fixHook=jQuery.event.fixHooks[event.type]||{},copy=fixHook.props?this.props.concat(fixHook.props):this.props;event=jQuery.Event(originalEvent);for(i=copy.length;i;){prop=copy[--i];event[prop]=originalEvent[prop];}
if(!event.target){event.target=originalEvent.srcElement||document;}
if(event.target.nodeType===3){event.target=event.target.parentNode;}
if(event.metaKey===undefined){event.metaKey=event.ctrlKey;}
return fixHook.filter?fixHook.filter(event,originalEvent):event;},special:{ready:{setup:jQuery.bindReady},load:{noBubble:true},focus:{delegateType:"focusin"},blur:{delegateType:"focusout"},beforeunload:{setup:function(data,namespaces,eventHandle){if(jQuery.isWindow(this)){this.onbeforeunload=eventHandle;}},teardown:function(namespaces,eventHandle){if(this.onbeforeunload===eventHandle){this.onbeforeunload=null;}}}},simulate:function(type,elem,event,bubble){var e=jQuery.extend(new jQuery.Event(),event,{type:type,isSimulated:true,originalEvent:{}});if(bubble){jQuery.event.trigger(e,null,elem);}else{jQuery.event.dispatch.call(elem,e);}
if(e.isDefaultPrevented()){event.preventDefault();}}};jQuery.event.handle=jQuery.event.dispatch;jQuery.removeEvent=document.removeEventListener?function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle,false);}}:function(elem,type,handle){if(elem.detachEvent){elem.detachEvent("on"+type,handle);}};jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event)){return new jQuery.Event(src,props);}
if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=(src.defaultPrevented||src.returnValue===false||src.getPreventDefault&&src.getPreventDefault())?returnTrue:returnFalse;}else{this.type=src;}
if(props){jQuery.extend(this,props);}
this.timeStamp=src&&src.timeStamp||jQuery.now();this[jQuery.expando]=true;};function returnFalse(){return false;}
function returnTrue(){return true;}
jQuery.Event.prototype={preventDefault:function(){this.isDefaultPrevented=returnTrue;var e=this.originalEvent;if(!e){return;}
if(e.preventDefault){e.preventDefault();}else{e.returnValue=false;}},stopPropagation:function(){this.isPropagationStopped=returnTrue;var e=this.originalEvent;if(!e){return;}
if(e.stopPropagation){e.stopPropagation();}
e.cancelBubble=true;},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=returnTrue;this.stopPropagation();},isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse};jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var target=this,related=event.relatedTarget,handleObj=event.handleObj,selector=handleObj.selector,ret;if(!related||(related!==target&&!jQuery.contains(target,related))){event.type=handleObj.origType;ret=handleObj.handler.apply(this,arguments);event.type=fix;}
return ret;}};});if(!jQuery.support.submitBubbles){jQuery.event.special.submit={setup:function(){if(jQuery.nodeName(this,"form")){return false;}
jQuery.event.add(this,"click._submit keypress._submit",function(e){var elem=e.target,form=jQuery.nodeName(elem,"input")||jQuery.nodeName(elem,"button")?elem.form:undefined;if(form&&!form._submit_attached){jQuery.event.add(form,"submit._submit",function(event){event._submit_bubble=true;});form._submit_attached=true;}});},postDispatch:function(event){if(event._submit_bubble){delete event._submit_bubble;if(this.parentNode&&!event.isTrigger){jQuery.event.simulate("submit",this.parentNode,event,true);}}},teardown:function(){if(jQuery.nodeName(this,"form")){return false;}
jQuery.event.remove(this,"._submit");}};}
if(!jQuery.support.changeBubbles){jQuery.event.special.change={setup:function(){if(rformElems.test(this.nodeName)){if(this.type==="checkbox"||this.type==="radio"){jQuery.event.add(this,"propertychange._change",function(event){if(event.originalEvent.propertyName==="checked"){this._just_changed=true;}});jQuery.event.add(this,"click._change",function(event){if(this._just_changed&&!event.isTrigger){this._just_changed=false;jQuery.event.simulate("change",this,event,true);}});}
return false;}
jQuery.event.add(this,"beforeactivate._change",function(e){var elem=e.target;if(rformElems.test(elem.nodeName)&&!elem._change_attached){jQuery.event.add(elem,"change._change",function(event){if(this.parentNode&&!event.isSimulated&&!event.isTrigger){jQuery.event.simulate("change",this.parentNode,event,true);}});elem._change_attached=true;}});},handle:function(event){var elem=event.target;if(this!==elem||event.isSimulated||event.isTrigger||(elem.type!=="radio"&&elem.type!=="checkbox")){return event.handleObj.handler.apply(this,arguments);}},teardown:function(){jQuery.event.remove(this,"._change");return rformElems.test(this.nodeName);}};}
if(!jQuery.support.focusinBubbles){jQuery.each({focus:"focusin",blur:"focusout"},function(orig,fix){var attaches=0,handler=function(event){jQuery.event.simulate(fix,event.target,jQuery.event.fix(event),true);};jQuery.event.special[fix]={setup:function(){if(attaches++===0){document.addEventListener(orig,handler,true);}},teardown:function(){if(--attaches===0){document.removeEventListener(orig,handler,true);}}};});}
jQuery.fn.extend({on:function(types,selector,data,fn,one){var origFn,type;if(typeof types==="object"){if(typeof selector!=="string"){data=data||selector;selector=undefined;}
for(type in types){this.on(type,selector,data,types[type],one);}
return this;}
if(data==null&&fn==null){fn=selector;data=selector=undefined;}else if(fn==null){if(typeof selector==="string"){fn=data;data=undefined;}else{fn=data;data=selector;selector=undefined;}}
if(fn===false){fn=returnFalse;}else if(!fn){return this;}
if(one===1){origFn=fn;fn=function(event){jQuery().off(event);return origFn.apply(this,arguments);};fn.guid=origFn.guid||(origFn.guid=jQuery.guid++);}
return this.each(function(){jQuery.event.add(this,types,fn,data,selector);});},one:function(types,selector,data,fn){return this.on(types,selector,data,fn,1);},off:function(types,selector,fn){if(types&&types.preventDefault&&types.handleObj){var handleObj=types.handleObj;jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler);return this;}
if(typeof types==="object"){for(var type in types){this.off(type,selector,types[type]);}
return this;}
if(selector===false||typeof selector==="function"){fn=selector;selector=undefined;}
if(fn===false){fn=returnFalse;}
return this.each(function(){jQuery.event.remove(this,types,fn,selector);});},bind:function(types,data,fn){return this.on(types,null,data,fn);},unbind:function(types,fn){return this.off(types,null,fn);},live:function(types,data,fn){jQuery(this.context).on(types,this.selector,data,fn);return this;},die:function(types,fn){jQuery(this.context).off(types,this.selector||"**",fn);return this;},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn);},undelegate:function(selector,types,fn){return arguments.length==1?this.off(selector,"**"):this.off(types,selector,fn);},trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this);});},triggerHandler:function(type,data){if(this[0]){return jQuery.event.trigger(type,data,this[0],true);}},toggle:function(fn){var args=arguments,guid=fn.guid||jQuery.guid++,i=0,toggler=function(event){var lastToggle=(jQuery._data(this,"lastToggle"+fn.guid)||0)%i;jQuery._data(this,"lastToggle"+fn.guid,lastToggle+1);event.preventDefault();return args[lastToggle].apply(this,arguments)||false;};toggler.guid=guid;while(i<args.length){args[i++].guid=guid;}
return this.click(toggler);},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut||fnOver);}});jQuery.each(("blur focus focusin focusout load resize scroll unload click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup error contextmenu").split(" "),function(i,name){jQuery.fn[name]=function(data,fn){if(fn==null){fn=data;data=null;}
return arguments.length>0?this.on(name,null,data,fn):this.trigger(name);};if(jQuery.attrFn){jQuery.attrFn[name]=true;}
if(rkeyEvent.test(name)){jQuery.event.fixHooks[name]=jQuery.event.keyHooks;}
if(rmouseEvent.test(name)){jQuery.event.fixHooks[name]=jQuery.event.mouseHooks;}});(function(){var chunker=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g,expando="sizcache"+(Math.random()+'').replace('.',''),done=0,toString=Object.prototype.toString,hasDuplicate=false,baseHasDuplicate=true,rBackslash=/\\/g,rReturn=/\r\n/g,rNonWord=/\W/;[0,0].sort(function(){baseHasDuplicate=false;return 0;});var Sizzle=function(selector,context,results,seed){results=results||[];context=context||document;var origContext=context;if(context.nodeType!==1&&context.nodeType!==9){return[];}
if(!selector||typeof selector!=="string"){return results;}
var m,set,checkSet,extra,ret,cur,pop,i,prune=true,contextXML=Sizzle.isXML(context),parts=[],soFar=selector;do{chunker.exec("");m=chunker.exec(soFar);if(m){soFar=m[3];parts.push(m[1]);if(m[2]){extra=m[3];break;}}}while(m);if(parts.length>1&&origPOS.exec(selector)){if(parts.length===2&&Expr.relative[parts[0]]){set=posProcess(parts[0]+parts[1],context,seed);}else{set=Expr.relative[parts[0]]?[context]:Sizzle(parts.shift(),context);while(parts.length){selector=parts.shift();if(Expr.relative[selector]){selector+=parts.shift();}
set=posProcess(selector,set,seed);}}}else{if(!seed&&parts.length>1&&context.nodeType===9&&!contextXML&&Expr.match.ID.test(parts[0])&&!Expr.match.ID.test(parts[parts.length-1])){ret=Sizzle.find(parts.shift(),context,contextXML);context=ret.expr?Sizzle.filter(ret.expr,ret.set)[0]:ret.set[0];}
if(context){ret=seed?{expr:parts.pop(),set:makeArray(seed)}:Sizzle.find(parts.pop(),parts.length===1&&(parts[0]==="~"||parts[0]==="+")&&context.parentNode?context.parentNode:context,contextXML);set=ret.expr?Sizzle.filter(ret.expr,ret.set):ret.set;if(parts.length>0){checkSet=makeArray(set);}else{prune=false;}
while(parts.length){cur=parts.pop();pop=cur;if(!Expr.relative[cur]){cur="";}else{pop=parts.pop();}
if(pop==null){pop=context;}
Expr.relative[cur](checkSet,pop,contextXML);}}else{checkSet=parts=[];}}
if(!checkSet){checkSet=set;}
if(!checkSet){Sizzle.error(cur||selector);}
if(toString.call(checkSet)==="[object Array]"){if(!prune){results.push.apply(results,checkSet);}else if(context&&context.nodeType===1){for(i=0;checkSet[i]!=null;i++){if(checkSet[i]&&(checkSet[i]===true||checkSet[i].nodeType===1&&Sizzle.contains(context,checkSet[i]))){results.push(set[i]);}}}else{for(i=0;checkSet[i]!=null;i++){if(checkSet[i]&&checkSet[i].nodeType===1){results.push(set[i]);}}}}else{makeArray(checkSet,results);}
if(extra){Sizzle(extra,origContext,results,seed);Sizzle.uniqueSort(results);}
return results;};Sizzle.uniqueSort=function(results){if(sortOrder){hasDuplicate=baseHasDuplicate;results.sort(sortOrder);if(hasDuplicate){for(var i=1;i<results.length;i++){if(results[i]===results[i-1]){results.splice(i--,1);}}}}
return results;};Sizzle.matches=function(expr,set){return Sizzle(expr,null,null,set);};Sizzle.matchesSelector=function(node,expr){return Sizzle(expr,null,null,[node]).length>0;};Sizzle.find=function(expr,context,isXML){var set,i,len,match,type,left;if(!expr){return[];}
for(i=0,len=Expr.order.length;i<len;i++){type=Expr.order[i];if((match=Expr.leftMatch[type].exec(expr))){left=match[1];match.splice(1,1);if(left.substr(left.length-1)!=="\\"){match[1]=(match[1]||"").replace(rBackslash,"");set=Expr.find[type](match,context,isXML);if(set!=null){expr=expr.replace(Expr.match[type],"");break;}}}}
if(!set){set=typeof context.getElementsByTagName!=="undefined"?context.getElementsByTagName("*"):[];}
return{set:set,expr:expr};};Sizzle.filter=function(expr,set,inplace,not){var match,anyFound,type,found,item,filter,left,i,pass,old=expr,result=[],curLoop=set,isXMLFilter=set&&set[0]&&Sizzle.isXML(set[0]);while(expr&&set.length){for(type in Expr.filter){if((match=Expr.leftMatch[type].exec(expr))!=null&&match[2]){filter=Expr.filter[type];left=match[1];anyFound=false;match.splice(1,1);if(left.substr(left.length-1)==="\\"){continue;}
if(curLoop===result){result=[];}
if(Expr.preFilter[type]){match=Expr.preFilter[type](match,curLoop,inplace,result,not,isXMLFilter);if(!match){anyFound=found=true;}else if(match===true){continue;}}
if(match){for(i=0;(item=curLoop[i])!=null;i++){if(item){found=filter(item,match,i,curLoop);pass=not^found;if(inplace&&found!=null){if(pass){anyFound=true;}else{curLoop[i]=false;}}else if(pass){result.push(item);anyFound=true;}}}}
if(found!==undefined){if(!inplace){curLoop=result;}
expr=expr.replace(Expr.match[type],"");if(!anyFound){return[];}
break;}}}
if(expr===old){if(anyFound==null){Sizzle.error(expr);}else{break;}}
old=expr;}
return curLoop;};Sizzle.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg);};var getText=Sizzle.getText=function(elem){var i,node,nodeType=elem.nodeType,ret="";if(nodeType){if(nodeType===1||nodeType===9||nodeType===11){if(typeof elem.textContent==='string'){return elem.textContent;}else if(typeof elem.innerText==='string'){return elem.innerText.replace(rReturn,'');}else{for(elem=elem.firstChild;elem;elem=elem.nextSibling){ret+=getText(elem);}}}else if(nodeType===3||nodeType===4){return elem.nodeValue;}}else{for(i=0;(node=elem[i]);i++){if(node.nodeType!==8){ret+=getText(node);}}}
return ret;};var Expr=Sizzle.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,CLASS:/\.((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,NAME:/\[name=['"]*((?:[\w\u00c0-\uFFFF\-]|\\.)+)['"]*\]/,ATTR:/\[\s*((?:[\w\u00c0-\uFFFF\-]|\\.)+)\s*(?:(\S?=)\s*(?:(['"])(.*?)\3|(#?(?:[\w\u00c0-\uFFFF\-]|\\.)*)|)|)\s*\]/,TAG:/^((?:[\w\u00c0-\uFFFF\*\-]|\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\(\s*(even|odd|(?:[+\-]?\d+|(?:[+\-]?\d*)?n\s*(?:[+\-]\s*\d+)?))\s*\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^\-]|$)/,PSEUDO:/:((?:[\w\u00c0-\uFFFF\-]|\\.)+)(?:\((['"]?)((?:\([^\)]+\)|[^\(\)]*)+)\2\))?/},leftMatch:{},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(elem){return elem.getAttribute("href");},type:function(elem){return elem.getAttribute("type");}},relative:{"+":function(checkSet,part){var isPartStr=typeof part==="string",isTag=isPartStr&&!rNonWord.test(part),isPartStrNotTag=isPartStr&&!isTag;if(isTag){part=part.toLowerCase();}
for(var i=0,l=checkSet.length,elem;i<l;i++){if((elem=checkSet[i])){while((elem=elem.previousSibling)&&elem.nodeType!==1){}
checkSet[i]=isPartStrNotTag||elem&&elem.nodeName.toLowerCase()===part?elem||false:elem===part;}}
if(isPartStrNotTag){Sizzle.filter(part,checkSet,true);}},">":function(checkSet,part){var elem,isPartStr=typeof part==="string",i=0,l=checkSet.length;if(isPartStr&&!rNonWord.test(part)){part=part.toLowerCase();for(;i<l;i++){elem=checkSet[i];if(elem){var parent=elem.parentNode;checkSet[i]=parent.nodeName.toLowerCase()===part?parent:false;}}}else{for(;i<l;i++){elem=checkSet[i];if(elem){checkSet[i]=isPartStr?elem.parentNode:elem.parentNode===part;}}
if(isPartStr){Sizzle.filter(part,checkSet,true);}}},"":function(checkSet,part,isXML){var nodeCheck,doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!rNonWord.test(part)){part=part.toLowerCase();nodeCheck=part;checkFn=dirNodeCheck;}
checkFn("parentNode",part,doneName,checkSet,nodeCheck,isXML);},"~":function(checkSet,part,isXML){var nodeCheck,doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!rNonWord.test(part)){part=part.toLowerCase();nodeCheck=part;checkFn=dirNodeCheck;}
checkFn("previousSibling",part,doneName,checkSet,nodeCheck,isXML);}},find:{ID:function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m&&m.parentNode?[m]:[];}},NAME:function(match,context){if(typeof context.getElementsByName!=="undefined"){var ret=[],results=context.getElementsByName(match[1]);for(var i=0,l=results.length;i<l;i++){if(results[i].getAttribute("name")===match[1]){ret.push(results[i]);}}
return ret.length===0?null:ret;}},TAG:function(match,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(match[1]);}}},preFilter:{CLASS:function(match,curLoop,inplace,result,not,isXML){match=" "+match[1].replace(rBackslash,"")+" ";if(isXML){return match;}
for(var i=0,elem;(elem=curLoop[i])!=null;i++){if(elem){if(not^(elem.className&&(" "+elem.className+" ").replace(/[\t\n\r]/g," ").indexOf(match)>=0)){if(!inplace){result.push(elem);}}else if(inplace){curLoop[i]=false;}}}
return false;},ID:function(match){return match[1].replace(rBackslash,"");},TAG:function(match,curLoop){return match[1].replace(rBackslash,"").toLowerCase();},CHILD:function(match){if(match[1]==="nth"){if(!match[2]){Sizzle.error(match[0]);}
match[2]=match[2].replace(/^\+|\s*/g,'');var test=/(-?)(\d*)(?:n([+\-]?\d*))?/.exec(match[2]==="even"&&"2n"||match[2]==="odd"&&"2n+1"||!/\D/.test(match[2])&&"0n+"+match[2]||match[2]);match[2]=(test[1]+(test[2]||1))-0;match[3]=test[3]-0;}
else if(match[2]){Sizzle.error(match[0]);}
match[0]=done++;return match;},ATTR:function(match,curLoop,inplace,result,not,isXML){var name=match[1]=match[1].replace(rBackslash,"");if(!isXML&&Expr.attrMap[name]){match[1]=Expr.attrMap[name];}
match[4]=(match[4]||match[5]||"").replace(rBackslash,"");if(match[2]==="~="){match[4]=" "+match[4]+" ";}
return match;},PSEUDO:function(match,curLoop,inplace,result,not){if(match[1]==="not"){if((chunker.exec(match[3])||"").length>1||/^\w/.test(match[3])){match[3]=Sizzle(match[3],null,null,curLoop);}else{var ret=Sizzle.filter(match[3],curLoop,inplace,true^not);if(!inplace){result.push.apply(result,ret);}
return false;}}else if(Expr.match.POS.test(match[0])||Expr.match.CHILD.test(match[0])){return true;}
return match;},POS:function(match){match.unshift(true);return match;}},filters:{enabled:function(elem){return elem.disabled===false&&elem.type!=="hidden";},disabled:function(elem){return elem.disabled===true;},checked:function(elem){return elem.checked===true;},selected:function(elem){if(elem.parentNode){elem.parentNode.selectedIndex;}
return elem.selected===true;},parent:function(elem){return!!elem.firstChild;},empty:function(elem){return!elem.firstChild;},has:function(elem,i,match){return!!Sizzle(match[3],elem).length;},header:function(elem){return(/h\d/i).test(elem.nodeName);},text:function(elem){var attr=elem.getAttribute("type"),type=elem.type;return elem.nodeName.toLowerCase()==="input"&&"text"===type&&(attr===type||attr===null);},radio:function(elem){return elem.nodeName.toLowerCase()==="input"&&"radio"===elem.type;},checkbox:function(elem){return elem.nodeName.toLowerCase()==="input"&&"checkbox"===elem.type;},file:function(elem){return elem.nodeName.toLowerCase()==="input"&&"file"===elem.type;},password:function(elem){return elem.nodeName.toLowerCase()==="input"&&"password"===elem.type;},submit:function(elem){var name=elem.nodeName.toLowerCase();return(name==="input"||name==="button")&&"submit"===elem.type;},image:function(elem){return elem.nodeName.toLowerCase()==="input"&&"image"===elem.type;},reset:function(elem){var name=elem.nodeName.toLowerCase();return(name==="input"||name==="button")&&"reset"===elem.type;},button:function(elem){var name=elem.nodeName.toLowerCase();return name==="input"&&"button"===elem.type||name==="button";},input:function(elem){return(/input|select|textarea|button/i).test(elem.nodeName);},focus:function(elem){return elem===elem.ownerDocument.activeElement;}},setFilters:{first:function(elem,i){return i===0;},last:function(elem,i,match,array){return i===array.length-1;},even:function(elem,i){return i%2===0;},odd:function(elem,i){return i%2===1;},lt:function(elem,i,match){return i<match[3]-0;},gt:function(elem,i,match){return i>match[3]-0;},nth:function(elem,i,match){return match[3]-0===i;},eq:function(elem,i,match){return match[3]-0===i;}},filter:{PSEUDO:function(elem,match,i,array){var name=match[1],filter=Expr.filters[name];if(filter){return filter(elem,i,match,array);}else if(name==="contains"){return(elem.textContent||elem.innerText||getText([elem])||"").indexOf(match[3])>=0;}else if(name==="not"){var not=match[3];for(var j=0,l=not.length;j<l;j++){if(not[j]===elem){return false;}}
return true;}else{Sizzle.error(name);}},CHILD:function(elem,match){var first,last,doneName,parent,cache,count,diff,type=match[1],node=elem;switch(type){case"only":case"first":while((node=node.previousSibling)){if(node.nodeType===1){return false;}}
if(type==="first"){return true;}
node=elem;case"last":while((node=node.nextSibling)){if(node.nodeType===1){return false;}}
return true;case"nth":first=match[2];last=match[3];if(first===1&&last===0){return true;}
doneName=match[0];parent=elem.parentNode;if(parent&&(parent[expando]!==doneName||!elem.nodeIndex)){count=0;for(node=parent.firstChild;node;node=node.nextSibling){if(node.nodeType===1){node.nodeIndex=++count;}}
parent[expando]=doneName;}
diff=elem.nodeIndex-last;if(first===0){return diff===0;}else{return(diff%first===0&&diff/first>=0);}}},ID:function(elem,match){return elem.nodeType===1&&elem.getAttribute("id")===match;},TAG:function(elem,match){return(match==="*"&&elem.nodeType===1)||!!elem.nodeName&&elem.nodeName.toLowerCase()===match;},CLASS:function(elem,match){return(" "+(elem.className||elem.getAttribute("class"))+" ").indexOf(match)>-1;},ATTR:function(elem,match){var name=match[1],result=Sizzle.attr?Sizzle.attr(elem,name):Expr.attrHandle[name]?Expr.attrHandle[name](elem):elem[name]!=null?elem[name]:elem.getAttribute(name),value=result+"",type=match[2],check=match[4];return result==null?type==="!=":!type&&Sizzle.attr?result!=null:type==="="?value===check:type==="*="?value.indexOf(check)>=0:type==="~="?(" "+value+" ").indexOf(check)>=0:!check?value&&result!==false:type==="!="?value!==check:type==="^="?value.indexOf(check)===0:type==="$="?value.substr(value.length-check.length)===check:type==="|="?value===check||value.substr(0,check.length+1)===check+"-":false;},POS:function(elem,match,i,array){var name=match[2],filter=Expr.setFilters[name];if(filter){return filter(elem,i,match,array);}}}};var origPOS=Expr.match.POS,fescape=function(all,num){return"\\"+(num-0+1);};for(var type in Expr.match){Expr.match[type]=new RegExp(Expr.match[type].source+(/(?![^\[]*\])(?![^\(]*\))/.source));Expr.leftMatch[type]=new RegExp(/(^(?:.|\r|\n)*?)/.source+Expr.match[type].source.replace(/\\(\d+)/g,fescape));}
Expr.match.globalPOS=origPOS;var makeArray=function(array,results){array=Array.prototype.slice.call(array,0);if(results){results.push.apply(results,array);return results;}
return array;};try{Array.prototype.slice.call(document.documentElement.childNodes,0)[0].nodeType;}catch(e){makeArray=function(array,results){var i=0,ret=results||[];if(toString.call(array)==="[object Array]"){Array.prototype.push.apply(ret,array);}else{if(typeof array.length==="number"){for(var l=array.length;i<l;i++){ret.push(array[i]);}}else{for(;array[i];i++){ret.push(array[i]);}}}
return ret;};}
var sortOrder,siblingCheck;if(document.documentElement.compareDocumentPosition){sortOrder=function(a,b){if(a===b){hasDuplicate=true;return 0;}
if(!a.compareDocumentPosition||!b.compareDocumentPosition){return a.compareDocumentPosition?-1:1;}
return a.compareDocumentPosition(b)&4?-1:1;};}else{sortOrder=function(a,b){if(a===b){hasDuplicate=true;return 0;}else if(a.sourceIndex&&b.sourceIndex){return a.sourceIndex-b.sourceIndex;}
var al,bl,ap=[],bp=[],aup=a.parentNode,bup=b.parentNode,cur=aup;if(aup===bup){return siblingCheck(a,b);}else if(!aup){return-1;}else if(!bup){return 1;}
while(cur){ap.unshift(cur);cur=cur.parentNode;}
cur=bup;while(cur){bp.unshift(cur);cur=cur.parentNode;}
al=ap.length;bl=bp.length;for(var i=0;i<al&&i<bl;i++){if(ap[i]!==bp[i]){return siblingCheck(ap[i],bp[i]);}}
return i===al?siblingCheck(a,bp[i],-1):siblingCheck(ap[i],b,1);};siblingCheck=function(a,b,ret){if(a===b){return ret;}
var cur=a.nextSibling;while(cur){if(cur===b){return-1;}
cur=cur.nextSibling;}
return 1;};}
(function(){var form=document.createElement("div"),id="script"+(new Date()).getTime(),root=document.documentElement;form.innerHTML="<a name='"+id+"'/>";root.insertBefore(form,root.firstChild);if(document.getElementById(id)){Expr.find.ID=function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?m.id===match[1]||typeof m.getAttributeNode!=="undefined"&&m.getAttributeNode("id").nodeValue===match[1]?[m]:undefined:[];}};Expr.filter.ID=function(elem,match){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return elem.nodeType===1&&node&&node.nodeValue===match;};}
root.removeChild(form);root=form=null;})();(function(){var div=document.createElement("div");div.appendChild(document.createComment(""));if(div.getElementsByTagName("*").length>0){Expr.find.TAG=function(match,context){var results=context.getElementsByTagName(match[1]);if(match[1]==="*"){var tmp=[];for(var i=0;results[i];i++){if(results[i].nodeType===1){tmp.push(results[i]);}}
results=tmp;}
return results;};}
div.innerHTML="<a href='#'></a>";if(div.firstChild&&typeof div.firstChild.getAttribute!=="undefined"&&div.firstChild.getAttribute("href")!=="#"){Expr.attrHandle.href=function(elem){return elem.getAttribute("href",2);};}
div=null;})();if(document.querySelectorAll){(function(){var oldSizzle=Sizzle,div=document.createElement("div"),id="__sizzle__";div.innerHTML="<p class='TEST'></p>";if(div.querySelectorAll&&div.querySelectorAll(".TEST").length===0){return;}
Sizzle=function(query,context,extra,seed){context=context||document;if(!seed&&!Sizzle.isXML(context)){var match=/^(\w+$)|^\.([\w\-]+$)|^#([\w\-]+$)/.exec(query);if(match&&(context.nodeType===1||context.nodeType===9)){if(match[1]){return makeArray(context.getElementsByTagName(query),extra);}else if(match[2]&&Expr.find.CLASS&&context.getElementsByClassName){return makeArray(context.getElementsByClassName(match[2]),extra);}}
if(context.nodeType===9){if(query==="body"&&context.body){return makeArray([context.body],extra);}else if(match&&match[3]){var elem=context.getElementById(match[3]);if(elem&&elem.parentNode){if(elem.id===match[3]){return makeArray([elem],extra);}}else{return makeArray([],extra);}}
try{return makeArray(context.querySelectorAll(query),extra);}catch(qsaError){}}else if(context.nodeType===1&&context.nodeName.toLowerCase()!=="object"){var oldContext=context,old=context.getAttribute("id"),nid=old||id,hasParent=context.parentNode,relativeHierarchySelector=/^\s*[+~]/.test(query);if(!old){context.setAttribute("id",nid);}else{nid=nid.replace(/'/g,"\\$&");}
if(relativeHierarchySelector&&hasParent){context=context.parentNode;}
try{if(!relativeHierarchySelector||hasParent){return makeArray(context.querySelectorAll("[id='"+nid+"'] "+query),extra);}}catch(pseudoError){}finally{if(!old){oldContext.removeAttribute("id");}}}}
return oldSizzle(query,context,extra,seed);};for(var prop in oldSizzle){Sizzle[prop]=oldSizzle[prop];}
div=null;})();}
(function(){var html=document.documentElement,matches=html.matchesSelector||html.mozMatchesSelector||html.webkitMatchesSelector||html.msMatchesSelector;if(matches){var disconnectedMatch=!matches.call(document.createElement("div"),"div"),pseudoWorks=false;try{matches.call(document.documentElement,"[test!='']:sizzle");}catch(pseudoError){pseudoWorks=true;}
Sizzle.matchesSelector=function(node,expr){expr=expr.replace(/\=\s*([^'"\]]*)\s*\]/g,"='$1']");if(!Sizzle.isXML(node)){try{if(pseudoWorks||!Expr.match.PSEUDO.test(expr)&&!/!=/.test(expr)){var ret=matches.call(node,expr);if(ret||!disconnectedMatch||node.document&&node.document.nodeType!==11){return ret;}}}catch(e){}}
return Sizzle(expr,null,null,[node]).length>0;};}})();(function(){var div=document.createElement("div");div.innerHTML="<div class='test e'></div><div class='test'></div>";if(!div.getElementsByClassName||div.getElementsByClassName("e").length===0){return;}
div.lastChild.className="e";if(div.getElementsByClassName("e").length===1){return;}
Expr.order.splice(1,0,"CLASS");Expr.find.CLASS=function(match,context,isXML){if(typeof context.getElementsByClassName!=="undefined"&&!isXML){return context.getElementsByClassName(match[1]);}};div=null;})();function dirNodeCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var match=false;elem=elem[dir];while(elem){if(elem[expando]===doneName){match=checkSet[elem.sizset];break;}
if(elem.nodeType===1&&!isXML){elem[expando]=doneName;elem.sizset=i;}
if(elem.nodeName.toLowerCase()===cur){match=elem;break;}
elem=elem[dir];}
checkSet[i]=match;}}}
function dirCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var match=false;elem=elem[dir];while(elem){if(elem[expando]===doneName){match=checkSet[elem.sizset];break;}
if(elem.nodeType===1){if(!isXML){elem[expando]=doneName;elem.sizset=i;}
if(typeof cur!=="string"){if(elem===cur){match=true;break;}}else if(Sizzle.filter(cur,[elem]).length>0){match=elem;break;}}
elem=elem[dir];}
checkSet[i]=match;}}}
if(document.documentElement.contains){Sizzle.contains=function(a,b){return a!==b&&(a.contains?a.contains(b):true);};}else if(document.documentElement.compareDocumentPosition){Sizzle.contains=function(a,b){return!!(a.compareDocumentPosition(b)&16);};}else{Sizzle.contains=function(){return false;};}
Sizzle.isXML=function(elem){var documentElement=(elem?elem.ownerDocument||elem:0).documentElement;return documentElement?documentElement.nodeName!=="HTML":false;};var posProcess=function(selector,context,seed){var match,tmpSet=[],later="",root=context.nodeType?[context]:context;while((match=Expr.match.PSEUDO.exec(selector))){later+=match[0];selector=selector.replace(Expr.match.PSEUDO,"");}
selector=Expr.relative[selector]?selector+"*":selector;for(var i=0,l=root.length;i<l;i++){Sizzle(selector,root[i],tmpSet,seed);}
return Sizzle.filter(later,tmpSet);};Sizzle.attr=jQuery.attr;Sizzle.selectors.attrMap={};jQuery.find=Sizzle;jQuery.expr=Sizzle.selectors;jQuery.expr[":"]=jQuery.expr.filters;jQuery.unique=Sizzle.uniqueSort;jQuery.text=Sizzle.getText;jQuery.isXMLDoc=Sizzle.isXML;jQuery.contains=Sizzle.contains;})();var runtil=/Until$/,rparentsprev=/^(?:parents|prevUntil|prevAll)/,rmultiselector=/,/,isSimple=/^.[^:#\[\.,]*$/,slice=Array.prototype.slice,POS=jQuery.expr.match.globalPOS,guaranteedUnique={children:true,contents:true,next:true,prev:true};jQuery.fn.extend({find:function(selector){var self=this,i,l;if(typeof selector!=="string"){return jQuery(selector).filter(function(){for(i=0,l=self.length;i<l;i++){if(jQuery.contains(self[i],this)){return true;}}});}
var ret=this.pushStack("","find",selector),length,n,r;for(i=0,l=this.length;i<l;i++){length=ret.length;jQuery.find(selector,this[i],ret);if(i>0){for(n=length;n<ret.length;n++){for(r=0;r<length;r++){if(ret[r]===ret[n]){ret.splice(n--,1);break;}}}}}
return ret;},has:function(target){var targets=jQuery(target);return this.filter(function(){for(var i=0,l=targets.length;i<l;i++){if(jQuery.contains(this,targets[i])){return true;}}});},not:function(selector){return this.pushStack(winnow(this,selector,false),"not",selector);},filter:function(selector){return this.pushStack(winnow(this,selector,true),"filter",selector);},is:function(selector){return!!selector&&(typeof selector==="string"?POS.test(selector)?jQuery(selector,this.context).index(this[0])>=0:jQuery.filter(selector,this).length>0:this.filter(selector).length>0);},closest:function(selectors,context){var ret=[],i,l,cur=this[0];if(jQuery.isArray(selectors)){var level=1;while(cur&&cur.ownerDocument&&cur!==context){for(i=0;i<selectors.length;i++){if(jQuery(cur).is(selectors[i])){ret.push({selector:selectors[i],elem:cur,level:level});}}
cur=cur.parentNode;level++;}
return ret;}
var pos=POS.test(selectors)||typeof selectors!=="string"?jQuery(selectors,context||this.context):0;for(i=0,l=this.length;i<l;i++){cur=this[i];while(cur){if(pos?pos.index(cur)>-1:jQuery.find.matchesSelector(cur,selectors)){ret.push(cur);break;}else{cur=cur.parentNode;if(!cur||!cur.ownerDocument||cur===context||cur.nodeType===11){break;}}}}
ret=ret.length>1?jQuery.unique(ret):ret;return this.pushStack(ret,"closest",selectors);},index:function(elem){if(!elem){return(this[0]&&this[0].parentNode)?this.prevAll().length:-1;}
if(typeof elem==="string"){return jQuery.inArray(this[0],jQuery(elem));}
return jQuery.inArray(elem.jquery?elem[0]:elem,this);},add:function(selector,context){var set=typeof selector==="string"?jQuery(selector,context):jQuery.makeArray(selector&&selector.nodeType?[selector]:selector),all=jQuery.merge(this.get(),set);return this.pushStack(isDisconnected(set[0])||isDisconnected(all[0])?all:jQuery.unique(all));},andSelf:function(){return this.add(this.prevObject);}});function isDisconnected(node){return!node||!node.parentNode||node.parentNode.nodeType===11;}
jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null;},parents:function(elem){return jQuery.dir(elem,"parentNode");},parentsUntil:function(elem,i,until){return jQuery.dir(elem,"parentNode",until);},next:function(elem){return jQuery.nth(elem,2,"nextSibling");},prev:function(elem){return jQuery.nth(elem,2,"previousSibling");},nextAll:function(elem){return jQuery.dir(elem,"nextSibling");},prevAll:function(elem){return jQuery.dir(elem,"previousSibling");},nextUntil:function(elem,i,until){return jQuery.dir(elem,"nextSibling",until);},prevUntil:function(elem,i,until){return jQuery.dir(elem,"previousSibling",until);},siblings:function(elem){return jQuery.sibling((elem.parentNode||{}).firstChild,elem);},children:function(elem){return jQuery.sibling(elem.firstChild);},contents:function(elem){return jQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes);}},function(name,fn){jQuery.fn[name]=function(until,selector){var ret=jQuery.map(this,fn,until);if(!runtil.test(name)){selector=until;}
if(selector&&typeof selector==="string"){ret=jQuery.filter(selector,ret);}
ret=this.length>1&&!guaranteedUnique[name]?jQuery.unique(ret):ret;if((this.length>1||rmultiselector.test(selector))&&rparentsprev.test(name)){ret=ret.reverse();}
return this.pushStack(ret,name,slice.call(arguments).join(","));};});jQuery.extend({filter:function(expr,elems,not){if(not){expr=":not("+expr+")";}
return elems.length===1?jQuery.find.matchesSelector(elems[0],expr)?[elems[0]]:[]:jQuery.find.matches(expr,elems);},dir:function(elem,dir,until){var matched=[],cur=elem[dir];while(cur&&cur.nodeType!==9&&(until===undefined||cur.nodeType!==1||!jQuery(cur).is(until))){if(cur.nodeType===1){matched.push(cur);}
cur=cur[dir];}
return matched;},nth:function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir]){if(cur.nodeType===1&&++num===result){break;}}
return cur;},sibling:function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){r.push(n);}}
return r;}});function winnow(elements,qualifier,keep){qualifier=qualifier||0;if(jQuery.isFunction(qualifier)){return jQuery.grep(elements,function(elem,i){var retVal=!!qualifier.call(elem,i,elem);return retVal===keep;});}else if(qualifier.nodeType){return jQuery.grep(elements,function(elem,i){return(elem===qualifier)===keep;});}else if(typeof qualifier==="string"){var filtered=jQuery.grep(elements,function(elem){return elem.nodeType===1;});if(isSimple.test(qualifier)){return jQuery.filter(qualifier,filtered,!keep);}else{qualifier=jQuery.filter(qualifier,filtered);}}
return jQuery.grep(elements,function(elem,i){return(jQuery.inArray(elem,qualifier)>=0)===keep;});}
function createSafeFragment(document){var list=nodeNames.split("|"),safeFrag=document.createDocumentFragment();if(safeFrag.createElement){while(list.length){safeFrag.createElement(list.pop());}}
return safeFrag;}
var nodeNames="abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|"+"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",rinlinejQuery=/ jQuery\d+="(?:\d+|null)"/g,rleadingWhitespace=/^\s+/,rxhtmlTag=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/ig,rtagName=/<([\w:]+)/,rtbody=/<tbody/i,rhtml=/<|&#?\w+;/,rnoInnerhtml=/<(?:script|style)/i,rnocache=/<(?:script|object|embed|option|style)/i,rnoshimcache=new RegExp("<(?:"+nodeNames+")[\\s/>]","i"),rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rscriptType=/\/(java|ecma)script/i,rcleanScript=/^\s*<!(?:\[CDATA\[|\-\-)/,wrapMap={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],area:[1,"<map>","</map>"],_default:[0,"",""]},safeFragment=createSafeFragment(document);wrapMap.optgroup=wrapMap.option;wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!jQuery.support.htmlSerialize){wrapMap._default=[1,"div<div>","</div>"];}
jQuery.fn.extend({text:function(value){return jQuery.access(this,function(value){return value===undefined?jQuery.text(this):this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(value));},null,value,arguments.length);},wrapAll:function(html){if(jQuery.isFunction(html)){return this.each(function(i){jQuery(this).wrapAll(html.call(this,i));});}
if(this[0]){var wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(true);if(this[0].parentNode){wrap.insertBefore(this[0]);}
wrap.map(function(){var elem=this;while(elem.firstChild&&elem.firstChild.nodeType===1){elem=elem.firstChild;}
return elem;}).append(this);}
return this;},wrapInner:function(html){if(jQuery.isFunction(html)){return this.each(function(i){jQuery(this).wrapInner(html.call(this,i));});}
return this.each(function(){var self=jQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html);}else{self.append(html);}});},wrap:function(html){var isFunction=jQuery.isFunction(html);return this.each(function(i){jQuery(this).wrapAll(isFunction?html.call(this,i):html);});},unwrap:function(){return this.parent().each(function(){if(!jQuery.nodeName(this,"body")){jQuery(this).replaceWith(this.childNodes);}}).end();},append:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType===1){this.appendChild(elem);}});},prepend:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType===1){this.insertBefore(elem,this.firstChild);}});},before:function(){if(this[0]&&this[0].parentNode){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this);});}else if(arguments.length){var set=jQuery.clean(arguments);set.push.apply(set,this.toArray());return this.pushStack(set,"before",arguments);}},after:function(){if(this[0]&&this[0].parentNode){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this.nextSibling);});}else if(arguments.length){var set=this.pushStack(this,"after",arguments);set.push.apply(set,jQuery.clean(arguments));return set;}},remove:function(selector,keepData){for(var i=0,elem;(elem=this[i])!=null;i++){if(!selector||jQuery.filter(selector,[elem]).length){if(!keepData&&elem.nodeType===1){jQuery.cleanData(elem.getElementsByTagName("*"));jQuery.cleanData([elem]);}
if(elem.parentNode){elem.parentNode.removeChild(elem);}}}
return this;},empty:function(){for(var i=0,elem;(elem=this[i])!=null;i++){if(elem.nodeType===1){jQuery.cleanData(elem.getElementsByTagName("*"));}
while(elem.firstChild){elem.removeChild(elem.firstChild);}}
return this;},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?false:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map(function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents);});},html:function(value){return jQuery.access(this,function(value){var elem=this[0]||{},i=0,l=this.length;if(value===undefined){return elem.nodeType===1?elem.innerHTML.replace(rinlinejQuery,""):null;}
if(typeof value==="string"&&!rnoInnerhtml.test(value)&&(jQuery.support.leadingWhitespace||!rleadingWhitespace.test(value))&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=value.replace(rxhtmlTag,"<$1></$2>");try{for(;i<l;i++){elem=this[i]||{};if(elem.nodeType===1){jQuery.cleanData(elem.getElementsByTagName("*"));elem.innerHTML=value;}}
elem=0;}catch(e){}}
if(elem){this.empty().append(value);}},null,value,arguments.length);},replaceWith:function(value){if(this[0]&&this[0].parentNode){if(jQuery.isFunction(value)){return this.each(function(i){var self=jQuery(this),old=self.html();self.replaceWith(value.call(this,i,old));});}
if(typeof value!=="string"){value=jQuery(value).detach();}
return this.each(function(){var next=this.nextSibling,parent=this.parentNode;jQuery(this).remove();if(next){jQuery(next).before(value);}else{jQuery(parent).append(value);}});}else{return this.length?this.pushStack(jQuery(jQuery.isFunction(value)?value():value),"replaceWith",value):this;}},detach:function(selector){return this.remove(selector,true);},domManip:function(args,table,callback){var results,first,fragment,parent,value=args[0],scripts=[];if(!jQuery.support.checkClone&&arguments.length===3&&typeof value==="string"&&rchecked.test(value)){return this.each(function(){jQuery(this).domManip(args,table,callback,true);});}
if(jQuery.isFunction(value)){return this.each(function(i){var self=jQuery(this);args[0]=value.call(this,i,table?self.html():undefined);self.domManip(args,table,callback);});}
if(this[0]){parent=value&&value.parentNode;if(jQuery.support.parentNode&&parent&&parent.nodeType===11&&parent.childNodes.length===this.length){results={fragment:parent};}else{results=jQuery.buildFragment(args,this,scripts);}
fragment=results.fragment;if(fragment.childNodes.length===1){first=fragment=fragment.firstChild;}else{first=fragment.firstChild;}
if(first){table=table&&jQuery.nodeName(first,"tr");for(var i=0,l=this.length,lastIndex=l-1;i<l;i++){callback.call(table?root(this[i],first):this[i],results.cacheable||(l>1&&i<lastIndex)?jQuery.clone(fragment,true,true):fragment);}}
if(scripts.length){jQuery.each(scripts,function(i,elem){if(elem.src){jQuery.ajax({type:"GET",global:false,url:elem.src,async:false,dataType:"script"});}else{jQuery.globalEval((elem.text||elem.textContent||elem.innerHTML||"").replace(rcleanScript,"/*$0*/"));}
if(elem.parentNode){elem.parentNode.removeChild(elem);}});}}
return this;}});function root(elem,cur){return jQuery.nodeName(elem,"table")?(elem.getElementsByTagName("tbody")[0]||elem.appendChild(elem.ownerDocument.createElement("tbody"))):elem;}
function cloneCopyEvent(src,dest){if(dest.nodeType!==1||!jQuery.hasData(src)){return;}
var type,i,l,oldData=jQuery._data(src),curData=jQuery._data(dest,oldData),events=oldData.events;if(events){delete curData.handle;curData.events={};for(type in events){for(i=0,l=events[type].length;i<l;i++){jQuery.event.add(dest,type,events[type][i]);}}}
if(curData.data){curData.data=jQuery.extend({},curData.data);}}
function cloneFixAttributes(src,dest){var nodeName;if(dest.nodeType!==1){return;}
if(dest.clearAttributes){dest.clearAttributes();}
if(dest.mergeAttributes){dest.mergeAttributes(src);}
nodeName=dest.nodeName.toLowerCase();if(nodeName==="object"){dest.outerHTML=src.outerHTML;}else if(nodeName==="input"&&(src.type==="checkbox"||src.type==="radio")){if(src.checked){dest.defaultChecked=dest.checked=src.checked;}
if(dest.value!==src.value){dest.value=src.value;}}else if(nodeName==="option"){dest.selected=src.defaultSelected;}else if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue;}else if(nodeName==="script"&&dest.text!==src.text){dest.text=src.text;}
dest.removeAttribute(jQuery.expando);dest.removeAttribute("_submit_attached");dest.removeAttribute("_change_attached");}
jQuery.buildFragment=function(args,nodes,scripts){var fragment,cacheable,cacheresults,doc,first=args[0];if(nodes&&nodes[0]){doc=nodes[0].ownerDocument||nodes[0];}
if(!doc.createDocumentFragment){doc=document;}
if(args.length===1&&typeof first==="string"&&first.length<512&&doc===document&&first.charAt(0)==="<"&&!rnocache.test(first)&&(jQuery.support.checkClone||!rchecked.test(first))&&(jQuery.support.html5Clone||!rnoshimcache.test(first))){cacheable=true;cacheresults=jQuery.fragments[first];if(cacheresults&&cacheresults!==1){fragment=cacheresults;}}
if(!fragment){fragment=doc.createDocumentFragment();jQuery.clean(args,doc,fragment,scripts);}
if(cacheable){jQuery.fragments[first]=cacheresults?fragment:1;}
return{fragment:fragment,cacheable:cacheable};};jQuery.fragments={};jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var ret=[],insert=jQuery(selector),parent=this.length===1&&this[0].parentNode;if(parent&&parent.nodeType===11&&parent.childNodes.length===1&&insert.length===1){insert[original](this[0]);return this;}else{for(var i=0,l=insert.length;i<l;i++){var elems=(i>0?this.clone(true):this).get();jQuery(insert[i])[original](elems);ret=ret.concat(elems);}
return this.pushStack(ret,name,insert.selector);}};});function getAll(elem){if(typeof elem.getElementsByTagName!=="undefined"){return elem.getElementsByTagName("*");}else if(typeof elem.querySelectorAll!=="undefined"){return elem.querySelectorAll("*");}else{return[];}}
function fixDefaultChecked(elem){if(elem.type==="checkbox"||elem.type==="radio"){elem.defaultChecked=elem.checked;}}
function findInputs(elem){var nodeName=(elem.nodeName||"").toLowerCase();if(nodeName==="input"){fixDefaultChecked(elem);}else if(nodeName!=="script"&&typeof elem.getElementsByTagName!=="undefined"){jQuery.grep(elem.getElementsByTagName("input"),fixDefaultChecked);}}
function shimCloneNode(elem){var div=document.createElement("div");safeFragment.appendChild(div);div.innerHTML=elem.outerHTML;return div.firstChild;}
jQuery.extend({clone:function(elem,dataAndEvents,deepDataAndEvents){var srcElements,destElements,i,clone=jQuery.support.html5Clone||jQuery.isXMLDoc(elem)||!rnoshimcache.test("<"+elem.nodeName+">")?elem.cloneNode(true):shimCloneNode(elem);if((!jQuery.support.noCloneEvent||!jQuery.support.noCloneChecked)&&(elem.nodeType===1||elem.nodeType===11)&&!jQuery.isXMLDoc(elem)){cloneFixAttributes(elem,clone);srcElements=getAll(elem);destElements=getAll(clone);for(i=0;srcElements[i];++i){if(destElements[i]){cloneFixAttributes(srcElements[i],destElements[i]);}}}
if(dataAndEvents){cloneCopyEvent(elem,clone);if(deepDataAndEvents){srcElements=getAll(elem);destElements=getAll(clone);for(i=0;srcElements[i];++i){cloneCopyEvent(srcElements[i],destElements[i]);}}}
srcElements=destElements=null;return clone;},clean:function(elems,context,fragment,scripts){var checkScriptType,script,j,ret=[];context=context||document;if(typeof context.createElement==="undefined"){context=context.ownerDocument||context[0]&&context[0].ownerDocument||document;}
for(var i=0,elem;(elem=elems[i])!=null;i++){if(typeof elem==="number"){elem+="";}
if(!elem){continue;}
if(typeof elem==="string"){if(!rhtml.test(elem)){elem=context.createTextNode(elem);}else{elem=elem.replace(rxhtmlTag,"<$1></$2>");var tag=(rtagName.exec(elem)||["",""])[1].toLowerCase(),wrap=wrapMap[tag]||wrapMap._default,depth=wrap[0],div=context.createElement("div"),safeChildNodes=safeFragment.childNodes,remove;if(context===document){safeFragment.appendChild(div);}else{createSafeFragment(context).appendChild(div);}
div.innerHTML=wrap[1]+elem+wrap[2];while(depth--){div=div.lastChild;}
if(!jQuery.support.tbody){var hasBody=rtbody.test(elem),tbody=tag==="table"&&!hasBody?div.firstChild&&div.firstChild.childNodes:wrap[1]==="<table>"&&!hasBody?div.childNodes:[];for(j=tbody.length-1;j>=0;--j){if(jQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length){tbody[j].parentNode.removeChild(tbody[j]);}}}
if(!jQuery.support.leadingWhitespace&&rleadingWhitespace.test(elem)){div.insertBefore(context.createTextNode(rleadingWhitespace.exec(elem)[0]),div.firstChild);}
elem=div.childNodes;if(div){div.parentNode.removeChild(div);if(safeChildNodes.length>0){remove=safeChildNodes[safeChildNodes.length-1];if(remove&&remove.parentNode){remove.parentNode.removeChild(remove);}}}}}
var len;if(!jQuery.support.appendChecked){if(elem[0]&&typeof(len=elem.length)==="number"){for(j=0;j<len;j++){findInputs(elem[j]);}}else{findInputs(elem);}}
if(elem.nodeType){ret.push(elem);}else{ret=jQuery.merge(ret,elem);}}
if(fragment){checkScriptType=function(elem){return!elem.type||rscriptType.test(elem.type);};for(i=0;ret[i];i++){script=ret[i];if(scripts&&jQuery.nodeName(script,"script")&&(!script.type||rscriptType.test(script.type))){scripts.push(script.parentNode?script.parentNode.removeChild(script):script);}else{if(script.nodeType===1){var jsTags=jQuery.grep(script.getElementsByTagName("script"),checkScriptType);ret.splice.apply(ret,[i+1,0].concat(jsTags));}
fragment.appendChild(script);}}}
return ret;},cleanData:function(elems){var data,id,cache=jQuery.cache,special=jQuery.event.special,deleteExpando=jQuery.support.deleteExpando;for(var i=0,elem;(elem=elems[i])!=null;i++){if(elem.nodeName&&jQuery.noData[elem.nodeName.toLowerCase()]){continue;}
id=elem[jQuery.expando];if(id){data=cache[id];if(data&&data.events){for(var type in data.events){if(special[type]){jQuery.event.remove(elem,type);}else{jQuery.removeEvent(elem,type,data.handle);}}
if(data.handle){data.handle.elem=null;}}
if(deleteExpando){delete elem[jQuery.expando];}else if(elem.removeAttribute){elem.removeAttribute(jQuery.expando);}
delete cache[id];}}}});var ralpha=/alpha\([^)]*\)/i,ropacity=/opacity=([^)]*)/,rupper=/([A-Z]|^ms)/g,rnum=/^[\-+]?(?:\d*\.)?\d+$/i,rnumnonpx=/^-?(?:\d*\.)?\d+(?!px)[^\d\s]+$/i,rrelNum=/^([\-+])=([\-+.\de]+)/,rmargin=/^margin/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssExpand=["Top","Right","Bottom","Left"],curCSS,getComputedStyle,currentStyle;jQuery.fn.css=function(name,value){return jQuery.access(this,function(elem,name,value){return value!==undefined?jQuery.style(elem,name,value):jQuery.css(elem,name);},name,value,arguments.length>1);};jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return ret===""?"1":ret;}else{return elem.style.opacity;}}}},cssNumber:{"fillOpacity":true,"fontWeight":true,"lineHeight":true,"opacity":true,"orphans":true,"widows":true,"zIndex":true,"zoom":true},cssProps:{"float":jQuery.support.cssFloat?"cssFloat":"styleFloat"},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return;}
var ret,type,origName=jQuery.camelCase(name),style=elem.style,hooks=jQuery.cssHooks[origName];name=jQuery.cssProps[origName]||origName;if(value!==undefined){type=typeof value;if(type==="string"&&(ret=rrelNum.exec(value))){value=(+(ret[1]+1)*+ret[2])+parseFloat(jQuery.css(elem,name));type="number";}
if(value==null||type==="number"&&isNaN(value)){return;}
if(type==="number"&&!jQuery.cssNumber[origName]){value+="px";}
if(!hooks||!("set"in hooks)||(value=hooks.set(elem,value))!==undefined){try{style[name]=value;}catch(e){}}}else{if(hooks&&"get"in hooks&&(ret=hooks.get(elem,false,extra))!==undefined){return ret;}
return style[name];}},css:function(elem,name,extra){var ret,hooks;name=jQuery.camelCase(name);hooks=jQuery.cssHooks[name];name=jQuery.cssProps[name]||name;if(name==="cssFloat"){name="float";}
if(hooks&&"get"in hooks&&(ret=hooks.get(elem,true,extra))!==undefined){return ret;}else if(curCSS){return curCSS(elem,name);}},swap:function(elem,options,callback){var old={},ret,name;for(name in options){old[name]=elem.style[name];elem.style[name]=options[name];}
ret=callback.call(elem);for(name in options){elem.style[name]=old[name];}
return ret;}});jQuery.curCSS=jQuery.css;if(document.defaultView&&document.defaultView.getComputedStyle){getComputedStyle=function(elem,name){var ret,defaultView,computedStyle,width,style=elem.style;name=name.replace(rupper,"-$1").toLowerCase();if((defaultView=elem.ownerDocument.defaultView)&&(computedStyle=defaultView.getComputedStyle(elem,null))){ret=computedStyle.getPropertyValue(name);if(ret===""&&!jQuery.contains(elem.ownerDocument.documentElement,elem)){ret=jQuery.style(elem,name);}}
if(!jQuery.support.pixelMargin&&computedStyle&&rmargin.test(name)&&rnumnonpx.test(ret)){width=style.width;style.width=ret;ret=computedStyle.width;style.width=width;}
return ret;};}
if(document.documentElement.currentStyle){currentStyle=function(elem,name){var left,rsLeft,uncomputed,ret=elem.currentStyle&&elem.currentStyle[name],style=elem.style;if(ret==null&&style&&(uncomputed=style[name])){ret=uncomputed;}
if(rnumnonpx.test(ret)){left=style.left;rsLeft=elem.runtimeStyle&&elem.runtimeStyle.left;if(rsLeft){elem.runtimeStyle.left=elem.currentStyle.left;}
style.left=name==="fontSize"?"1em":ret;ret=style.pixelLeft+"px";style.left=left;if(rsLeft){elem.runtimeStyle.left=rsLeft;}}
return ret===""?"auto":ret;};}
curCSS=getComputedStyle||currentStyle;function getWidthOrHeight(elem,name,extra){var val=name==="width"?elem.offsetWidth:elem.offsetHeight,i=name==="width"?1:0,len=4;if(val>0){if(extra!=="border"){for(;i<len;i+=2){if(!extra){val-=parseFloat(jQuery.css(elem,"padding"+cssExpand[i]))||0;}
if(extra==="margin"){val+=parseFloat(jQuery.css(elem,extra+cssExpand[i]))||0;}else{val-=parseFloat(jQuery.css(elem,"border"+cssExpand[i]+"Width"))||0;}}}
return val+"px";}
val=curCSS(elem,name);if(val<0||val==null){val=elem.style[name];}
if(rnumnonpx.test(val)){return val;}
val=parseFloat(val)||0;if(extra){for(;i<len;i+=2){val+=parseFloat(jQuery.css(elem,"padding"+cssExpand[i]))||0;if(extra!=="padding"){val+=parseFloat(jQuery.css(elem,"border"+cssExpand[i]+"Width"))||0;}
if(extra==="margin"){val+=parseFloat(jQuery.css(elem,extra+cssExpand[i]))||0;}}}
return val+"px";}
jQuery.each(["height","width"],function(i,name){jQuery.cssHooks[name]={get:function(elem,computed,extra){if(computed){if(elem.offsetWidth!==0){return getWidthOrHeight(elem,name,extra);}else{return jQuery.swap(elem,cssShow,function(){return getWidthOrHeight(elem,name,extra);});}}},set:function(elem,value){return rnum.test(value)?value+"px":value;}};});if(!jQuery.support.opacity){jQuery.cssHooks.opacity={get:function(elem,computed){return ropacity.test((computed&&elem.currentStyle?elem.currentStyle.filter:elem.style.filter)||"")?(parseFloat(RegExp.$1)/100)+"":computed?"1":"";},set:function(elem,value){var style=elem.style,currentStyle=elem.currentStyle,opacity=jQuery.isNumeric(value)?"alpha(opacity="+value*100+")":"",filter=currentStyle&&currentStyle.filter||style.filter||"";style.zoom=1;if(value>=1&&jQuery.trim(filter.replace(ralpha,""))===""){style.removeAttribute("filter");if(currentStyle&&!currentStyle.filter){return;}}
style.filter=ralpha.test(filter)?filter.replace(ralpha,opacity):filter+" "+opacity;}};}
jQuery(function(){if(!jQuery.support.reliableMarginRight){jQuery.cssHooks.marginRight={get:function(elem,computed){return jQuery.swap(elem,{"display":"inline-block"},function(){if(computed){return curCSS(elem,"margin-right");}else{return elem.style.marginRight;}});}};}});if(jQuery.expr&&jQuery.expr.filters){jQuery.expr.filters.hidden=function(elem){var width=elem.offsetWidth,height=elem.offsetHeight;return(width===0&&height===0)||(!jQuery.support.reliableHiddenOffsets&&((elem.style&&elem.style.display)||jQuery.css(elem,"display"))==="none");};jQuery.expr.filters.visible=function(elem){return!jQuery.expr.filters.hidden(elem);};}
jQuery.each({margin:"",padding:"",border:"Width"},function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){var i,parts=typeof value==="string"?value.split(" "):[value],expanded={};for(i=0;i<4;i++){expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0];}
return expanded;}};});var r20=/%20/g,rbracket=/\[\]$/,rCRLF=/\r?\n/g,rhash=/#.*$/,rheaders=/^(.*?):[ \t]*([^\r\n]*)\r?$/mg,rinput=/^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,rlocalProtocol=/^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,rquery=/\?/,rscript=/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,rselectTextarea=/^(?:select|textarea)/i,rspacesAjax=/\s+/,rts=/([?&])_=[^&]*/,rurl=/^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+))?)?/,_load=jQuery.fn.load,prefilters={},transports={},ajaxLocation,ajaxLocParts,allTypes=["*/"]+["*"];try{ajaxLocation=location.href;}catch(e){ajaxLocation=document.createElement("a");ajaxLocation.href="";ajaxLocation=ajaxLocation.href;}
ajaxLocParts=rurl.exec(ajaxLocation.toLowerCase())||[];function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*";}
if(jQuery.isFunction(func)){var dataTypes=dataTypeExpression.toLowerCase().split(rspacesAjax),i=0,length=dataTypes.length,dataType,list,placeBefore;for(;i<length;i++){dataType=dataTypes[i];placeBefore=/^\+/.test(dataType);if(placeBefore){dataType=dataType.substr(1)||"*";}
list=structure[dataType]=structure[dataType]||[];list[placeBefore?"unshift":"push"](func);}}};}
function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR,dataType,inspected){dataType=dataType||options.dataTypes[0];inspected=inspected||{};inspected[dataType]=true;var list=structure[dataType],i=0,length=list?list.length:0,executeOnly=(structure===prefilters),selection;for(;i<length&&(executeOnly||!selection);i++){selection=list[i](options,originalOptions,jqXHR);if(typeof selection==="string"){if(!executeOnly||inspected[selection]){selection=undefined;}else{options.dataTypes.unshift(selection);selection=inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR,selection,inspected);}}}
if((executeOnly||!selection)&&!inspected["*"]){selection=inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR,"*",inspected);}
return selection;}
function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src){if(src[key]!==undefined){(flatOptions[key]?target:(deep||(deep={})))[key]=src[key];}}
if(deep){jQuery.extend(true,target,deep);}}
jQuery.fn.extend({load:function(url,params,callback){if(typeof url!=="string"&&_load){return _load.apply(this,arguments);}else if(!this.length){return this;}
var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off);}
var type="GET";if(params){if(jQuery.isFunction(params)){callback=params;params=undefined;}else if(typeof params==="object"){params=jQuery.param(params,jQuery.ajaxSettings.traditional);type="POST";}}
var self=this;jQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(jqXHR,status,responseText){responseText=jqXHR.responseText;if(jqXHR.isResolved()){jqXHR.done(function(r){responseText=r;});self.html(selector?jQuery("<div>").append(responseText.replace(rscript,"")).find(selector):responseText);}
if(callback){self.each(callback,[responseText,status,jqXHR]);}}});return this;},serialize:function(){return jQuery.param(this.serializeArray());},serializeArray:function(){return this.map(function(){return this.elements?jQuery.makeArray(this.elements):this;}).filter(function(){return this.name&&!this.disabled&&(this.checked||rselectTextarea.test(this.nodeName)||rinput.test(this.type));}).map(function(i,elem){var val=jQuery(this).val();return val==null?null:jQuery.isArray(val)?jQuery.map(val,function(val,i){return{name:elem.name,value:val.replace(rCRLF,"\r\n")};}):{name:elem.name,value:val.replace(rCRLF,"\r\n")};}).get();}});jQuery.each("ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split(" "),function(i,o){jQuery.fn[o]=function(f){return this.on(o,f);};});jQuery.each(["get","post"],function(i,method){jQuery[method]=function(url,data,callback,type){if(jQuery.isFunction(data)){type=type||callback;callback=data;data=undefined;}
return jQuery.ajax({type:method,url:url,data:data,success:callback,dataType:type});};});jQuery.extend({getScript:function(url,callback){return jQuery.get(url,undefined,callback,"script");},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json");},ajaxSetup:function(target,settings){if(settings){ajaxExtend(target,jQuery.ajaxSettings);}else{settings=target;target=jQuery.ajaxSettings;}
ajaxExtend(target,settings);return target;},ajaxSettings:{url:ajaxLocation,isLocal:rlocalProtocol.test(ajaxLocParts[1]),global:true,type:"GET",contentType:"application/x-www-form-urlencoded; charset=UTF-8",processData:true,async:true,accepts:{xml:"application/xml, text/xml",html:"text/html",text:"text/plain",json:"application/json, text/javascript","*":allTypes},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText"},converters:{"* text":window.String,"text html":true,"text json":jQuery.parseJSON,"text xml":jQuery.parseXML},flatOptions:{context:true,url:true}},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof url==="object"){options=url;url=undefined;}
options=options||{};var
s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=callbackContext!==s&&(callbackContext.nodeType||callbackContext instanceof jQuery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},ifModifiedKey,requestHeaders={},requestHeadersNames={},responseHeadersString,responseHeaders,transport,timeoutTimer,parts,state=0,fireGlobals,i,jqXHR={readyState:0,setRequestHeader:function(name,value){if(!state){var lname=name.toLowerCase();name=requestHeadersNames[lname]=requestHeadersNames[lname]||name;requestHeaders[name]=value;}
return this;},getAllResponseHeaders:function(){return state===2?responseHeadersString:null;},getResponseHeader:function(key){var match;if(state===2){if(!responseHeaders){responseHeaders={};while((match=rheaders.exec(responseHeadersString))){responseHeaders[match[1].toLowerCase()]=match[2];}}
match=responseHeaders[key.toLowerCase()];}
return match===undefined?null:match;},overrideMimeType:function(type){if(!state){s.mimeType=type;}
return this;},abort:function(statusText){statusText=statusText||"abort";if(transport){transport.abort(statusText);}
done(0,statusText);return this;}};function done(status,nativeStatusText,responses,headers){if(state===2){return;}
state=2;if(timeoutTimer){clearTimeout(timeoutTimer);}
transport=undefined;responseHeadersString=headers||"";jqXHR.readyState=status>0?4:0;var isSuccess,success,error,statusText=nativeStatusText,response=responses?ajaxHandleResponses(s,jqXHR,responses):undefined,lastModified,etag;if(status>=200&&status<300||status===304){if(s.ifModified){if((lastModified=jqXHR.getResponseHeader("Last-Modified"))){jQuery.lastModified[ifModifiedKey]=lastModified;}
if((etag=jqXHR.getResponseHeader("Etag"))){jQuery.etag[ifModifiedKey]=etag;}}
if(status===304){statusText="notmodified";isSuccess=true;}else{try{success=ajaxConvert(s,response);statusText="success";isSuccess=true;}catch(e){statusText="parsererror";error=e;}}}else{error=statusText;if(!statusText||status){statusText="error";if(status<0){status=0;}}}
jqXHR.status=status;jqXHR.statusText=""+(nativeStatusText||statusText);if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jqXHR]);}else{deferred.rejectWith(callbackContext,[jqXHR,statusText,error]);}
jqXHR.statusCode(statusCode);statusCode=undefined;if(fireGlobals){globalEventContext.trigger("ajax"+(isSuccess?"Success":"Error"),[jqXHR,s,isSuccess?success:error]);}
completeDeferred.fireWith(callbackContext,[jqXHR,statusText]);if(fireGlobals){globalEventContext.trigger("ajaxComplete",[jqXHR,s]);if(!(--jQuery.active)){jQuery.event.trigger("ajaxStop");}}}
deferred.promise(jqXHR);jqXHR.success=jqXHR.done;jqXHR.error=jqXHR.fail;jqXHR.complete=completeDeferred.add;jqXHR.statusCode=function(map){if(map){var tmp;if(state<2){for(tmp in map){statusCode[tmp]=[statusCode[tmp],map[tmp]];}}else{tmp=map[jqXHR.status];jqXHR.then(tmp,tmp);}}
return this;};s.url=((url||s.url)+"").replace(rhash,"").replace(rprotocol,ajaxLocParts[1]+"//");s.dataTypes=jQuery.trim(s.dataType||"*").toLowerCase().split(rspacesAjax);if(s.crossDomain==null){parts=rurl.exec(s.url.toLowerCase());s.crossDomain=!!(parts&&(parts[1]!=ajaxLocParts[1]||parts[2]!=ajaxLocParts[2]||(parts[3]||(parts[1]==="http:"?80:443))!=(ajaxLocParts[3]||(ajaxLocParts[1]==="http:"?80:443))));}
if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data,s.traditional);}
inspectPrefiltersOrTransports(prefilters,s,options,jqXHR);if(state===2){return false;}
fireGlobals=s.global;s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);if(fireGlobals&&jQuery.active++===0){jQuery.event.trigger("ajaxStart");}
if(!s.hasContent){if(s.data){s.url+=(rquery.test(s.url)?"&":"?")+s.data;delete s.data;}
ifModifiedKey=s.url;if(s.cache===false){var ts=jQuery.now(),ret=s.url.replace(rts,"$1_="+ts);s.url=ret+((ret===s.url)?(rquery.test(s.url)?"&":"?")+"_="+ts:"");}}
if(s.data&&s.hasContent&&s.contentType!==false||options.contentType){jqXHR.setRequestHeader("Content-Type",s.contentType);}
if(s.ifModified){ifModifiedKey=ifModifiedKey||s.url;if(jQuery.lastModified[ifModifiedKey]){jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[ifModifiedKey]);}
if(jQuery.etag[ifModifiedKey]){jqXHR.setRequestHeader("If-None-Match",jQuery.etag[ifModifiedKey]);}}
jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+(s.dataTypes[0]!=="*"?", "+allTypes+"; q=0.01":""):s.accepts["*"]);for(i in s.headers){jqXHR.setRequestHeader(i,s.headers[i]);}
if(s.beforeSend&&(s.beforeSend.call(callbackContext,jqXHR,s)===false||state===2)){jqXHR.abort();return false;}
for(i in{success:1,error:1,complete:1}){jqXHR[i](s[i]);}
transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR);if(!transport){done(-1,"No Transport");}else{jqXHR.readyState=1;if(fireGlobals){globalEventContext.trigger("ajaxSend",[jqXHR,s]);}
if(s.async&&s.timeout>0){timeoutTimer=setTimeout(function(){jqXHR.abort("timeout");},s.timeout);}
try{state=1;transport.send(requestHeaders,done);}catch(e){if(state<2){done(-1,e);}else{throw e;}}}
return jqXHR;},param:function(a,traditional){var s=[],add=function(key,value){value=jQuery.isFunction(value)?value():value;s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value);};if(traditional===undefined){traditional=jQuery.ajaxSettings.traditional;}
if(jQuery.isArray(a)||(a.jquery&&!jQuery.isPlainObject(a))){jQuery.each(a,function(){add(this.name,this.value);});}else{for(var prefix in a){buildParams(prefix,a[prefix],traditional,add);}}
return s.join("&").replace(r20,"+");}});function buildParams(prefix,obj,traditional,add){if(jQuery.isArray(obj)){jQuery.each(obj,function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v);}else{buildParams(prefix+"["+(typeof v==="object"?i:"")+"]",v,traditional,add);}});}else if(!traditional&&jQuery.type(obj)==="object"){for(var name in obj){buildParams(prefix+"["+name+"]",obj[name],traditional,add);}}else{add(prefix,obj);}}
jQuery.extend({active:0,lastModified:{},etag:{}});function ajaxHandleResponses(s,jqXHR,responses){var contents=s.contents,dataTypes=s.dataTypes,responseFields=s.responseFields,ct,type,finalDataType,firstDataType;for(type in responseFields){if(type in responses){jqXHR[responseFields[type]]=responses[type];}}
while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=s.mimeType||jqXHR.getResponseHeader("content-type");}}
if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break;}}}
if(dataTypes[0]in responses){finalDataType=dataTypes[0];}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break;}
if(!firstDataType){firstDataType=type;}}
finalDataType=finalDataType||firstDataType;}
if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType);}
return responses[finalDataType];}}
function ajaxConvert(s,response){if(s.dataFilter){response=s.dataFilter(response,s.dataType);}
var dataTypes=s.dataTypes,converters={},i,key,length=dataTypes.length,tmp,current=dataTypes[0],prev,conversion,conv,conv1,conv2;for(i=1;i<length;i++){if(i===1){for(key in s.converters){if(typeof key==="string"){converters[key.toLowerCase()]=s.converters[key];}}}
prev=current;current=dataTypes[i];if(current==="*"){current=prev;}else if(prev!=="*"&&prev!==current){conversion=prev+" "+current;conv=converters[conversion]||converters["* "+current];if(!conv){conv2=undefined;for(conv1 in converters){tmp=conv1.split(" ");if(tmp[0]===prev||tmp[0]==="*"){conv2=converters[tmp[1]+" "+current];if(conv2){conv1=converters[conv1];if(conv1===true){conv=conv2;}else if(conv2===true){conv=conv1;}
break;}}}}
if(!(conv||conv2)){jQuery.error("No conversion from "+conversion.replace(" "," to "));}
if(conv!==true){response=conv?conv(response):conv2(conv1(response));}}}
return response;}
var jsc=jQuery.now(),jsre=/(\=)\?(&|$)|\?\?/i;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){return jQuery.expando+"_"+(jsc++);}});jQuery.ajaxPrefilter("json jsonp",function(s,originalSettings,jqXHR){var inspectData=(typeof s.data==="string")&&/^application\/x\-www\-form\-urlencoded/.test(s.contentType);if(s.dataTypes[0]==="jsonp"||s.jsonp!==false&&(jsre.test(s.url)||inspectData&&jsre.test(s.data))){var responseContainer,jsonpCallback=s.jsonpCallback=jQuery.isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback,previous=window[jsonpCallback],url=s.url,data=s.data,replace="$1"+jsonpCallback+"$2";if(s.jsonp!==false){url=url.replace(jsre,replace);if(s.url===url){if(inspectData){data=data.replace(jsre,replace);}
if(s.data===data){url+=(/\?/.test(url)?"&":"?")+s.jsonp+"="+jsonpCallback;}}}
s.url=url;s.data=data;window[jsonpCallback]=function(response){responseContainer=[response];};jqXHR.always(function(){window[jsonpCallback]=previous;if(responseContainer&&jQuery.isFunction(previous)){window[jsonpCallback](responseContainer[0]);}});s.converters["script json"]=function(){if(!responseContainer){jQuery.error(jsonpCallback+" was not called");}
return responseContainer[0];};s.dataTypes[0]="json";return"script";}});jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/javascript|ecmascript/},converters:{"text script":function(text){jQuery.globalEval(text);return text;}}});jQuery.ajaxPrefilter("script",function(s){if(s.cache===undefined){s.cache=false;}
if(s.crossDomain){s.type="GET";s.global=false;}});jQuery.ajaxTransport("script",function(s){if(s.crossDomain){var script,head=document.head||document.getElementsByTagName("head")[0]||document.documentElement;return{send:function(_,callback){script=document.createElement("script");script.async="async";if(s.scriptCharset){script.charset=s.scriptCharset;}
script.src=s.url;script.onload=script.onreadystatechange=function(_,isAbort){if(isAbort||!script.readyState||/loaded|complete/.test(script.readyState)){script.onload=script.onreadystatechange=null;if(head&&script.parentNode){head.removeChild(script);}
script=undefined;if(!isAbort){callback(200,"success");}}};head.insertBefore(script,head.firstChild);},abort:function(){if(script){script.onload(0,1);}}};}});var
xhrOnUnloadAbort=window.ActiveXObject?function(){for(var key in xhrCallbacks){xhrCallbacks[key](0,1);}}:false,xhrId=0,xhrCallbacks;function createStandardXHR(){try{return new window.XMLHttpRequest();}catch(e){}}
function createActiveXHR(){try{return new window.ActiveXObject("Microsoft.XMLHTTP");}catch(e){}}
jQuery.ajaxSettings.xhr=window.ActiveXObject?function(){return!this.isLocal&&createStandardXHR()||createActiveXHR();}:createStandardXHR;(function(xhr){jQuery.extend(jQuery.support,{ajax:!!xhr,cors:!!xhr&&("withCredentials"in xhr)});})(jQuery.ajaxSettings.xhr());if(jQuery.support.ajax){jQuery.ajaxTransport(function(s){if(!s.crossDomain||jQuery.support.cors){var callback;return{send:function(headers,complete){var xhr=s.xhr(),handle,i;if(s.username){xhr.open(s.type,s.url,s.async,s.username,s.password);}else{xhr.open(s.type,s.url,s.async);}
if(s.xhrFields){for(i in s.xhrFields){xhr[i]=s.xhrFields[i];}}
if(s.mimeType&&xhr.overrideMimeType){xhr.overrideMimeType(s.mimeType);}
if(!s.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest";}
try{for(i in headers){xhr.setRequestHeader(i,headers[i]);}}catch(_){}
xhr.send((s.hasContent&&s.data)||null);callback=function(_,isAbort){var status,statusText,responseHeaders,responses,xml;try{if(callback&&(isAbort||xhr.readyState===4)){callback=undefined;if(handle){xhr.onreadystatechange=jQuery.noop;if(xhrOnUnloadAbort){delete xhrCallbacks[handle];}}
if(isAbort){if(xhr.readyState!==4){xhr.abort();}}else{status=xhr.status;responseHeaders=xhr.getAllResponseHeaders();responses={};xml=xhr.responseXML;if(xml&&xml.documentElement){responses.xml=xml;}
try{responses.text=xhr.responseText;}catch(_){}
try{statusText=xhr.statusText;}catch(e){statusText="";}
if(!status&&s.isLocal&&!s.crossDomain){status=responses.text?200:404;}else if(status===1223){status=204;}}}}catch(firefoxAccessException){if(!isAbort){complete(-1,firefoxAccessException);}}
if(responses){complete(status,statusText,responses,responseHeaders);}};if(!s.async||xhr.readyState===4){callback();}else{handle=++xhrId;if(xhrOnUnloadAbort){if(!xhrCallbacks){xhrCallbacks={};jQuery(window).unload(xhrOnUnloadAbort);}
xhrCallbacks[handle]=callback;}
xhr.onreadystatechange=callback;}},abort:function(){if(callback){callback(0,1);}}};}});}
var elemdisplay={},iframe,iframeDoc,rfxtypes=/^(?:toggle|show|hide)$/,rfxnum=/^([+\-]=)?([\d+.\-]+)([a-z%]*)$/i,timerId,fxAttrs=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]],fxNow;jQuery.fn.extend({show:function(speed,easing,callback){var elem,display;if(speed||speed===0){return this.animate(genFx("show",3),speed,easing,callback);}else{for(var i=0,j=this.length;i<j;i++){elem=this[i];if(elem.style){display=elem.style.display;if(!jQuery._data(elem,"olddisplay")&&display==="none"){display=elem.style.display="";}
if((display===""&&jQuery.css(elem,"display")==="none")||!jQuery.contains(elem.ownerDocument.documentElement,elem)){jQuery._data(elem,"olddisplay",defaultDisplay(elem.nodeName));}}}
for(i=0;i<j;i++){elem=this[i];if(elem.style){display=elem.style.display;if(display===""||display==="none"){elem.style.display=jQuery._data(elem,"olddisplay")||"";}}}
return this;}},hide:function(speed,easing,callback){if(speed||speed===0){return this.animate(genFx("hide",3),speed,easing,callback);}else{var elem,display,i=0,j=this.length;for(;i<j;i++){elem=this[i];if(elem.style){display=jQuery.css(elem,"display");if(display!=="none"&&!jQuery._data(elem,"olddisplay")){jQuery._data(elem,"olddisplay",display);}}}
for(i=0;i<j;i++){if(this[i].style){this[i].style.display="none";}}
return this;}},_toggle:jQuery.fn.toggle,toggle:function(fn,fn2,callback){var bool=typeof fn==="boolean";if(jQuery.isFunction(fn)&&jQuery.isFunction(fn2)){this._toggle.apply(this,arguments);}else if(fn==null||bool){this.each(function(){var state=bool?fn:jQuery(this).is(":hidden");jQuery(this)[state?"show":"hide"]();});}else{this.animate(genFx("toggle",3),fn,fn2,callback);}
return this;},fadeTo:function(speed,to,easing,callback){return this.filter(":hidden").css("opacity",0).show().end().animate({opacity:to},speed,easing,callback);},animate:function(prop,speed,easing,callback){var optall=jQuery.speed(speed,easing,callback);if(jQuery.isEmptyObject(prop)){return this.each(optall.complete,[false]);}
prop=jQuery.extend({},prop);function doAnimation(){if(optall.queue===false){jQuery._mark(this);}
var opt=jQuery.extend({},optall),isElement=this.nodeType===1,hidden=isElement&&jQuery(this).is(":hidden"),name,val,p,e,hooks,replace,parts,start,end,unit,method;opt.animatedProperties={};for(p in prop){name=jQuery.camelCase(p);if(p!==name){prop[name]=prop[p];delete prop[p];}
if((hooks=jQuery.cssHooks[name])&&"expand"in hooks){replace=hooks.expand(prop[name]);delete prop[name];for(p in replace){if(!(p in prop)){prop[p]=replace[p];}}}}
for(name in prop){val=prop[name];if(jQuery.isArray(val)){opt.animatedProperties[name]=val[1];val=prop[name]=val[0];}else{opt.animatedProperties[name]=opt.specialEasing&&opt.specialEasing[name]||opt.easing||'swing';}
if(val==="hide"&&hidden||val==="show"&&!hidden){return opt.complete.call(this);}
if(isElement&&(name==="height"||name==="width")){opt.overflow=[this.style.overflow,this.style.overflowX,this.style.overflowY];if(jQuery.css(this,"display")==="inline"&&jQuery.css(this,"float")==="none"){if(!jQuery.support.inlineBlockNeedsLayout||defaultDisplay(this.nodeName)==="inline"){this.style.display="inline-block";}else{this.style.zoom=1;}}}}
if(opt.overflow!=null){this.style.overflow="hidden";}
for(p in prop){e=new jQuery.fx(this,opt,p);val=prop[p];if(rfxtypes.test(val)){method=jQuery._data(this,"toggle"+p)||(val==="toggle"?hidden?"show":"hide":0);if(method){jQuery._data(this,"toggle"+p,method==="show"?"hide":"show");e[method]();}else{e[val]();}}else{parts=rfxnum.exec(val);start=e.cur();if(parts){end=parseFloat(parts[2]);unit=parts[3]||(jQuery.cssNumber[p]?"":"px");if(unit!=="px"){jQuery.style(this,p,(end||1)+unit);start=((end||1)/e.cur())*start;jQuery.style(this,p,start+unit);}
if(parts[1]){end=((parts[1]==="-="?-1:1)*end)+start;}
e.custom(start,end,unit);}else{e.custom(start,val,"");}}}
return true;}
return optall.queue===false?this.each(doAnimation):this.queue(optall.queue,doAnimation);},stop:function(type,clearQueue,gotoEnd){if(typeof type!=="string"){gotoEnd=clearQueue;clearQueue=type;type=undefined;}
if(clearQueue&&type!==false){this.queue(type||"fx",[]);}
return this.each(function(){var index,hadTimers=false,timers=jQuery.timers,data=jQuery._data(this);if(!gotoEnd){jQuery._unmark(true,this);}
function stopQueue(elem,data,index){var hooks=data[index];jQuery.removeData(elem,index,true);hooks.stop(gotoEnd);}
if(type==null){for(index in data){if(data[index]&&data[index].stop&&index.indexOf(".run")===index.length-4){stopQueue(this,data,index);}}}else if(data[index=type+".run"]&&data[index].stop){stopQueue(this,data,index);}
for(index=timers.length;index--;){if(timers[index].elem===this&&(type==null||timers[index].queue===type)){if(gotoEnd){timers[index](true);}else{timers[index].saveState();}
hadTimers=true;timers.splice(index,1);}}
if(!(gotoEnd&&hadTimers)){jQuery.dequeue(this,type);}});}});function createFxNow(){setTimeout(clearFxNow,0);return(fxNow=jQuery.now());}
function clearFxNow(){fxNow=undefined;}
function genFx(type,num){var obj={};jQuery.each(fxAttrs.concat.apply([],fxAttrs.slice(0,num)),function(){obj[this]=type;});return obj;}
jQuery.each({slideDown:genFx("show",1),slideUp:genFx("hide",1),slideToggle:genFx("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback);};});jQuery.extend({speed:function(speed,easing,fn){var opt=speed&&typeof speed==="object"?jQuery.extend({},speed):{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!jQuery.isFunction(easing)&&easing};opt.duration=jQuery.fx.off?0:typeof opt.duration==="number"?opt.duration:opt.duration in jQuery.fx.speeds?jQuery.fx.speeds[opt.duration]:jQuery.fx.speeds._default;if(opt.queue==null||opt.queue===true){opt.queue="fx";}
opt.old=opt.complete;opt.complete=function(noUnmark){if(jQuery.isFunction(opt.old)){opt.old.call(this);}
if(opt.queue){jQuery.dequeue(this,opt.queue);}else if(noUnmark!==false){jQuery._unmark(this);}};return opt;},easing:{linear:function(p){return p;},swing:function(p){return(-Math.cos(p*Math.PI)/2)+0.5;}},timers:[],fx:function(elem,options,prop){this.options=options;this.elem=elem;this.prop=prop;options.orig=options.orig||{};}});jQuery.fx.prototype={update:function(){if(this.options.step){this.options.step.call(this.elem,this.now,this);}
(jQuery.fx.step[this.prop]||jQuery.fx.step._default)(this);},cur:function(){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null)){return this.elem[this.prop];}
var parsed,r=jQuery.css(this.elem,this.prop);return isNaN(parsed=parseFloat(r))?!r||r==="auto"?0:r:parsed;},custom:function(from,to,unit){var self=this,fx=jQuery.fx;this.startTime=fxNow||createFxNow();this.end=to;this.now=this.start=from;this.pos=this.state=0;this.unit=unit||this.unit||(jQuery.cssNumber[this.prop]?"":"px");function t(gotoEnd){return self.step(gotoEnd);}
t.queue=this.options.queue;t.elem=this.elem;t.saveState=function(){if(jQuery._data(self.elem,"fxshow"+self.prop)===undefined){if(self.options.hide){jQuery._data(self.elem,"fxshow"+self.prop,self.start);}else if(self.options.show){jQuery._data(self.elem,"fxshow"+self.prop,self.end);}}};if(t()&&jQuery.timers.push(t)&&!timerId){timerId=setInterval(fx.tick,fx.interval);}},show:function(){var dataShow=jQuery._data(this.elem,"fxshow"+this.prop);this.options.orig[this.prop]=dataShow||jQuery.style(this.elem,this.prop);this.options.show=true;if(dataShow!==undefined){this.custom(this.cur(),dataShow);}else{this.custom(this.prop==="width"||this.prop==="height"?1:0,this.cur());}
jQuery(this.elem).show();},hide:function(){this.options.orig[this.prop]=jQuery._data(this.elem,"fxshow"+this.prop)||jQuery.style(this.elem,this.prop);this.options.hide=true;this.custom(this.cur(),0);},step:function(gotoEnd){var p,n,complete,t=fxNow||createFxNow(),done=true,elem=this.elem,options=this.options;if(gotoEnd||t>=options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();options.animatedProperties[this.prop]=true;for(p in options.animatedProperties){if(options.animatedProperties[p]!==true){done=false;}}
if(done){if(options.overflow!=null&&!jQuery.support.shrinkWrapBlocks){jQuery.each(["","X","Y"],function(index,value){elem.style["overflow"+value]=options.overflow[index];});}
if(options.hide){jQuery(elem).hide();}
if(options.hide||options.show){for(p in options.animatedProperties){jQuery.style(elem,p,options.orig[p]);jQuery.removeData(elem,"fxshow"+p,true);jQuery.removeData(elem,"toggle"+p,true);}}
complete=options.complete;if(complete){options.complete=false;complete.call(elem);}}
return false;}else{if(options.duration==Infinity){this.now=t;}else{n=t-this.startTime;this.state=n/options.duration;this.pos=jQuery.easing[options.animatedProperties[this.prop]](this.state,n,0,1,options.duration);this.now=this.start+((this.end-this.start)*this.pos);}
this.update();}
return true;}};jQuery.extend(jQuery.fx,{tick:function(){var timer,timers=jQuery.timers,i=0;for(;i<timers.length;i++){timer=timers[i];if(!timer()&&timers[i]===timer){timers.splice(i--,1);}}
if(!timers.length){jQuery.fx.stop();}},interval:13,stop:function(){clearInterval(timerId);timerId=null;},speeds:{slow:600,fast:200,_default:400},step:{opacity:function(fx){jQuery.style(fx.elem,"opacity",fx.now);},_default:function(fx){if(fx.elem.style&&fx.elem.style[fx.prop]!=null){fx.elem.style[fx.prop]=fx.now+fx.unit;}else{fx.elem[fx.prop]=fx.now;}}}});jQuery.each(fxAttrs.concat.apply([],fxAttrs),function(i,prop){if(prop.indexOf("margin")){jQuery.fx.step[prop]=function(fx){jQuery.style(fx.elem,prop,Math.max(0,fx.now)+fx.unit);};}});if(jQuery.expr&&jQuery.expr.filters){jQuery.expr.filters.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem;}).length;};}
function defaultDisplay(nodeName){if(!elemdisplay[nodeName]){var body=document.body,elem=jQuery("<"+nodeName+">").appendTo(body),display=elem.css("display");elem.remove();if(display==="none"||display===""){if(!iframe){iframe=document.createElement("iframe");iframe.frameBorder=iframe.width=iframe.height=0;}
body.appendChild(iframe);if(!iframeDoc||!iframe.createElement){iframeDoc=(iframe.contentWindow||iframe.contentDocument).document;iframeDoc.write((jQuery.support.boxModel?"<!doctype html>":"")+"<html><body>");iframeDoc.close();}
elem=iframeDoc.createElement(nodeName);iframeDoc.body.appendChild(elem);display=jQuery.css(elem,"display");body.removeChild(iframe);}
elemdisplay[nodeName]=display;}
return elemdisplay[nodeName];}
var getOffset,rtable=/^t(?:able|d|h)$/i,rroot=/^(?:body|html)$/i;if("getBoundingClientRect"in document.documentElement){getOffset=function(elem,doc,docElem,box){try{box=elem.getBoundingClientRect();}catch(e){}
if(!box||!jQuery.contains(docElem,elem)){return box?{top:box.top,left:box.left}:{top:0,left:0};}
var body=doc.body,win=getWindow(doc),clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,scrollTop=win.pageYOffset||jQuery.support.boxModel&&docElem.scrollTop||body.scrollTop,scrollLeft=win.pageXOffset||jQuery.support.boxModel&&docElem.scrollLeft||body.scrollLeft,top=box.top+scrollTop-clientTop,left=box.left+scrollLeft-clientLeft;return{top:top,left:left};};}else{getOffset=function(elem,doc,docElem){var computedStyle,offsetParent=elem.offsetParent,prevOffsetParent=elem,body=doc.body,defaultView=doc.defaultView,prevComputedStyle=defaultView?defaultView.getComputedStyle(elem,null):elem.currentStyle,top=elem.offsetTop,left=elem.offsetLeft;while((elem=elem.parentNode)&&elem!==body&&elem!==docElem){if(jQuery.support.fixedPosition&&prevComputedStyle.position==="fixed"){break;}
computedStyle=defaultView?defaultView.getComputedStyle(elem,null):elem.currentStyle;top-=elem.scrollTop;left-=elem.scrollLeft;if(elem===offsetParent){top+=elem.offsetTop;left+=elem.offsetLeft;if(jQuery.support.doesNotAddBorder&&!(jQuery.support.doesAddBorderForTableAndCells&&rtable.test(elem.nodeName))){top+=parseFloat(computedStyle.borderTopWidth)||0;left+=parseFloat(computedStyle.borderLeftWidth)||0;}
prevOffsetParent=offsetParent;offsetParent=elem.offsetParent;}
if(jQuery.support.subtractsBorderForOverflowNotVisible&&computedStyle.overflow!=="visible"){top+=parseFloat(computedStyle.borderTopWidth)||0;left+=parseFloat(computedStyle.borderLeftWidth)||0;}
prevComputedStyle=computedStyle;}
if(prevComputedStyle.position==="relative"||prevComputedStyle.position==="static"){top+=body.offsetTop;left+=body.offsetLeft;}
if(jQuery.support.fixedPosition&&prevComputedStyle.position==="fixed"){top+=Math.max(docElem.scrollTop,body.scrollTop);left+=Math.max(docElem.scrollLeft,body.scrollLeft);}
return{top:top,left:left};};}
jQuery.fn.offset=function(options){if(arguments.length){return options===undefined?this:this.each(function(i){jQuery.offset.setOffset(this,options,i);});}
var elem=this[0],doc=elem&&elem.ownerDocument;if(!doc){return null;}
if(elem===doc.body){return jQuery.offset.bodyOffset(elem);}
return getOffset(elem,doc,doc.documentElement);};jQuery.offset={bodyOffset:function(body){var top=body.offsetTop,left=body.offsetLeft;if(jQuery.support.doesNotIncludeMarginInBodyOffset){top+=parseFloat(jQuery.css(body,"marginTop"))||0;left+=parseFloat(jQuery.css(body,"marginLeft"))||0;}
return{top:top,left:left};},setOffset:function(elem,options,i){var position=jQuery.css(elem,"position");if(position==="static"){elem.style.position="relative";}
var curElem=jQuery(elem),curOffset=curElem.offset(),curCSSTop=jQuery.css(elem,"top"),curCSSLeft=jQuery.css(elem,"left"),calculatePosition=(position==="absolute"||position==="fixed")&&jQuery.inArray("auto",[curCSSTop,curCSSLeft])>-1,props={},curPosition={},curTop,curLeft;if(calculatePosition){curPosition=curElem.position();curTop=curPosition.top;curLeft=curPosition.left;}else{curTop=parseFloat(curCSSTop)||0;curLeft=parseFloat(curCSSLeft)||0;}
if(jQuery.isFunction(options)){options=options.call(elem,i,curOffset);}
if(options.top!=null){props.top=(options.top-curOffset.top)+curTop;}
if(options.left!=null){props.left=(options.left-curOffset.left)+curLeft;}
if("using"in options){options.using.call(elem,props);}else{curElem.css(props);}}};jQuery.fn.extend({position:function(){if(!this[0]){return null;}
var elem=this[0],offsetParent=this.offsetParent(),offset=this.offset(),parentOffset=rroot.test(offsetParent[0].nodeName)?{top:0,left:0}:offsetParent.offset();offset.top-=parseFloat(jQuery.css(elem,"marginTop"))||0;offset.left-=parseFloat(jQuery.css(elem,"marginLeft"))||0;parentOffset.top+=parseFloat(jQuery.css(offsetParent[0],"borderTopWidth"))||0;parentOffset.left+=parseFloat(jQuery.css(offsetParent[0],"borderLeftWidth"))||0;return{top:offset.top-parentOffset.top,left:offset.left-parentOffset.left};},offsetParent:function(){return this.map(function(){var offsetParent=this.offsetParent||document.body;while(offsetParent&&(!rroot.test(offsetParent.nodeName)&&jQuery.css(offsetParent,"position")==="static")){offsetParent=offsetParent.offsetParent;}
return offsetParent;});}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(method,prop){var top=/Y/.test(prop);jQuery.fn[method]=function(val){return jQuery.access(this,function(elem,method,val){var win=getWindow(elem);if(val===undefined){return win?(prop in win)?win[prop]:jQuery.support.boxModel&&win.document.documentElement[method]||win.document.body[method]:elem[method];}
if(win){win.scrollTo(!top?val:jQuery(win).scrollLeft(),top?val:jQuery(win).scrollTop());}else{elem[method]=val;}},method,val,arguments.length,null);};});function getWindow(elem){return jQuery.isWindow(elem)?elem:elem.nodeType===9?elem.defaultView||elem.parentWindow:false;}
jQuery.each({Height:"height",Width:"width"},function(name,type){var clientProp="client"+name,scrollProp="scroll"+name,offsetProp="offset"+name;jQuery.fn["inner"+name]=function(){var elem=this[0];return elem?elem.style?parseFloat(jQuery.css(elem,type,"padding")):this[type]():null;};jQuery.fn["outer"+name]=function(margin){var elem=this[0];return elem?elem.style?parseFloat(jQuery.css(elem,type,margin?"margin":"border")):this[type]():null;};jQuery.fn[type]=function(value){return jQuery.access(this,function(elem,type,value){var doc,docElemProp,orig,ret;if(jQuery.isWindow(elem)){doc=elem.document;docElemProp=doc.documentElement[clientProp];return jQuery.support.boxModel&&docElemProp||doc.body&&doc.body[clientProp]||docElemProp;}
if(elem.nodeType===9){doc=elem.documentElement;if(doc[clientProp]>=doc[scrollProp]){return doc[clientProp];}
return Math.max(elem.body[scrollProp],doc[scrollProp],elem.body[offsetProp],doc[offsetProp]);}
if(value===undefined){orig=jQuery.css(elem,type);ret=parseFloat(orig);return jQuery.isNumeric(ret)?ret:orig;}
jQuery(elem).css(type,value);},type,value,arguments.length,null);};});window.jQuery=window.$=jQuery;if(typeof define==="function"&&define.amd&&define.amd.jQuery){define("jquery",[],function(){return jQuery;});}})(window);;

/****** FILE: framework/javascript/jquery-ondemand/jquery.ondemand.js *****/

(function($){var decodePath=function(str){return str.replace(/%2C/g,',').replace(/\&amp;/g,'&');};$.extend({_ondemand_loaded_list:null,isItemLoaded:function(scriptUrl){var self=this,src;if(this._ondemand_loaded_list===null){this._ondemand_loaded_list={};$('script').each(function(){src=$(this).attr('src');if(src)self._ondemand_loaded_list[src]=1;});$('link[rel="stylesheet"]').each(function(){src=$(this).attr('href');if(src)self._ondemand_loaded_list[src]=1;});}
return(this._ondemand_loaded_list[decodePath(scriptUrl)]!==undefined);},requireCss:function(styleUrl,media){if(!media)media='all';if($.isItemLoaded(styleUrl))return;if(document.createStyleSheet){var ss=document.createStyleSheet(styleUrl);ss.media=media;}else{var styleTag=document.createElement('link');$(styleTag).attr({href:styleUrl,type:'text/css',media:media,rel:'stylesheet'}).appendTo($('head').get(0));}
this._ondemand_loaded_list[styleUrl]=1;},processOnDemandHeaders:function(xml,status,xhr){var self=this,processDfd=new $.Deferred();if(xhr.getResponseHeader&&xhr.getResponseHeader('X-Include-CSS')){var cssIncludes=xhr.getResponseHeader('X-Include-CSS').split(',');for(var i=0;i<cssIncludes.length;i++){if(cssIncludes[i].match(/^(.*):##:(.*)$/)){$.requireCss(decodePath(RegExp.$1),RegExp.$2);}else{$.requireCss(decodePath(cssIncludes[i]));}}}
var newJsIncludes=[];if(xhr.getResponseHeader&&xhr.getResponseHeader('X-Include-JS')){var jsIncludes=xhr.getResponseHeader('X-Include-JS').split(',');for(var i=0;i<jsIncludes.length;i++){var jsIncludePath=decodePath(jsIncludes[i]);if(!$.isItemLoaded(jsIncludePath)){newJsIncludes.push(jsIncludePath);}}}
var getScriptQueue=function(){if(newJsIncludes.length){var newJsInclude=newJsIncludes.shift();$.ajax({dataType:'script',url:newJsInclude,success:function(){self._ondemand_loaded_list[newJsInclude]=1;getScriptQueue();},cache:false,async:false});}else{processDfd.resolve(xml,status,xhr);}}
if(newJsIncludes.length){getScriptQueue();}else{processDfd.resolve(xml,status,xhr);}
return processDfd.promise();}});$.ajaxSetup({beforeSend:function(jqXHR,s){if(s.dataType=='script')return;var dfd=new $.Deferred();jqXHR.success(function(success,statusText,jXHR){$.processOnDemandHeaders(success,statusText,jXHR).done(function(){dfd.resolveWith(s.context||this,[success,statusText,jXHR]);});});jqXHR.success=function(callback){dfd.done(callback);}}});})(jQuery);;

/****** FILE: framework/admin/javascript/lib.js *****/

(function($){var $window=$(window),$html=$('html'),$head=$('head'),path={urlParseRE:/^(((([^:\/#\?]+:)?(?:(\/\/)((?:(([^:@\/#\?]+)(?:\:([^:@\/#\?]+))?)@)?(([^:\/#\?\]\[]+|\[[^\/\]@#?]+\])(?:\:([0-9]+))?))?)?)?((\/?(?:[^\/\?#]+\/+)*)([^\?#]*)))?(\?[^#]+)?)(#.*)?/,parseUrl:function(url){if($.type(url)==="object"){return url;}
var matches=path.urlParseRE.exec(url||"")||[];return{href:matches[0]||"",hrefNoHash:matches[1]||"",hrefNoSearch:matches[2]||"",domain:matches[3]||"",protocol:matches[4]||"",doubleSlash:matches[5]||"",authority:matches[6]||"",username:matches[8]||"",password:matches[9]||"",host:matches[10]||"",hostname:matches[11]||"",port:matches[12]||"",pathname:matches[13]||"",directory:matches[14]||"",filename:matches[15]||"",search:matches[16]||"",hash:matches[17]||""};},makePathAbsolute:function(relPath,absPath){if(relPath&&relPath.charAt(0)==="/"){return relPath;}
relPath=relPath||"";absPath=absPath?absPath.replace(/^\/|(\/[^\/]*|[^\/]+)$/g,""):"";var absStack=absPath?absPath.split("/"):[],relStack=relPath.split("/");for(var i=0;i<relStack.length;i++){var d=relStack[i];switch(d){case".":break;case"..":if(absStack.length){absStack.pop();}
break;default:absStack.push(d);break;}}
return"/"+absStack.join("/");},isSameDomain:function(absUrl1,absUrl2){return path.parseUrl(absUrl1).domain===path.parseUrl(absUrl2).domain;},isRelativeUrl:function(url){return path.parseUrl(url).protocol==="";},isAbsoluteUrl:function(url){return path.parseUrl(url).protocol!=="";},makeUrlAbsolute:function(relUrl,absUrl){if(!path.isRelativeUrl(relUrl)){return relUrl;}
var relObj=path.parseUrl(relUrl),absObj=path.parseUrl(absUrl),protocol=relObj.protocol||absObj.protocol,doubleSlash=relObj.protocol?relObj.doubleSlash:(relObj.doubleSlash||absObj.doubleSlash),authority=relObj.authority||absObj.authority,hasPath=relObj.pathname!=="",pathname=path.makePathAbsolute(relObj.pathname||absObj.filename,absObj.pathname),search=relObj.search||(!hasPath&&absObj.search)||"",hash=relObj.hash;return protocol+doubleSlash+authority+pathname+search+hash;},addSearchParams:function(url,params){var u=path.parseUrl(url),p=(typeof params==="object")?$.param(params):params,s=u.search||"?";return u.hrefNoSearch+s+(s.charAt(s.length-1)!=="?"?"&":"")+p+(u.hash||"");},convertUrlToDataUrl:function(absUrl){var u=path.parseUrl(absUrl);if(path.isEmbeddedPage(u)){return u.hash.split(dialogHashKey)[0].replace(/^#/,"");}else if(path.isSameDomain(u,documentBase)){return u.hrefNoHash.replace(documentBase.domain,"");}
return absUrl;},get:function(newPath){if(newPath===undefined){newPath=location.hash;}
return path.stripHash(newPath).replace(/[^\/]*\.[^\/*]+$/,'');},getFilePath:function(path){var splitkey='&'+$.mobile.subPageUrlKey;return path&&path.split(splitkey)[0].split(dialogHashKey)[0];},set:function(path){location.hash=path;},isPath:function(url){return(/\//).test(url);},clean:function(url){return url.replace(documentBase.domain,"");},stripHash:function(url){return url.replace(/^#/,"");},cleanHash:function(hash){return path.stripHash(hash.replace(/\?.*$/,"").replace(dialogHashKey,""));},isExternal:function(url){var u=path.parseUrl(url);return u.protocol&&u.domain!==documentUrl.domain?true:false;},hasProtocol:function(url){return(/^(:?\w+:)/).test(url);}};$.path=path;}(jQuery));;

/****** FILE: framework/thirdparty/jquery-ui/jquery-ui.js *****/

(function($,undefined){var uuid=0,runiqueId=/^ui-id-\d+$/;$.ui=$.ui||{};if($.ui.version){return;}
$.extend($.ui,{version:"1.9.2",keyCode:{BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38}});$.fn.extend({_focus:$.fn.focus,focus:function(delay,fn){return typeof delay==="number"?this.each(function(){var elem=this;setTimeout(function(){$(elem).focus();if(fn){fn.call(elem);}},delay);}):this._focus.apply(this,arguments);},scrollParent:function(){var scrollParent;if(($.ui.ie&&(/(static|relative)/).test(this.css('position')))||(/absolute/).test(this.css('position'))){scrollParent=this.parents().filter(function(){return(/(relative|absolute|fixed)/).test($.css(this,'position'))&&(/(auto|scroll)/).test($.css(this,'overflow')+$.css(this,'overflow-y')+$.css(this,'overflow-x'));}).eq(0);}else{scrollParent=this.parents().filter(function(){return(/(auto|scroll)/).test($.css(this,'overflow')+$.css(this,'overflow-y')+$.css(this,'overflow-x'));}).eq(0);}
return(/fixed/).test(this.css('position'))||!scrollParent.length?$(document):scrollParent;},zIndex:function(zIndex){if(zIndex!==undefined){return this.css("zIndex",zIndex);}
if(this.length){var elem=$(this[0]),position,value;while(elem.length&&elem[0]!==document){position=elem.css("position");if(position==="absolute"||position==="relative"||position==="fixed"){value=parseInt(elem.css("zIndex"),10);if(!isNaN(value)&&value!==0){return value;}}
elem=elem.parent();}}
return 0;},uniqueId:function(){return this.each(function(){if(!this.id){this.id="ui-id-"+(++uuid);}});},removeUniqueId:function(){return this.each(function(){if(runiqueId.test(this.id)){$(this).removeAttr("id");}});}});function focusable(element,isTabIndexNotNaN){var map,mapName,img,nodeName=element.nodeName.toLowerCase();if("area"===nodeName){map=element.parentNode;mapName=map.name;if(!element.href||!mapName||map.nodeName.toLowerCase()!=="map"){return false;}
img=$("img[usemap=#"+mapName+"]")[0];return!!img&&visible(img);}
return(/input|select|textarea|button|object/.test(nodeName)?!element.disabled:"a"===nodeName?element.href||isTabIndexNotNaN:isTabIndexNotNaN)&&visible(element);}
function visible(element){return $.expr.filters.visible(element)&&!$(element).parents().andSelf().filter(function(){return $.css(this,"visibility")==="hidden";}).length;}
$.extend($.expr[":"],{data:$.expr.createPseudo?$.expr.createPseudo(function(dataName){return function(elem){return!!$.data(elem,dataName);};}):function(elem,i,match){return!!$.data(elem,match[3]);},focusable:function(element){return focusable(element,!isNaN($.attr(element,"tabindex")));},tabbable:function(element){var tabIndex=$.attr(element,"tabindex"),isTabIndexNaN=isNaN(tabIndex);return(isTabIndexNaN||tabIndex>=0)&&focusable(element,!isTabIndexNaN);}});$(function(){var body=document.body,div=body.appendChild(div=document.createElement("div"));div.offsetHeight;$.extend(div.style,{minHeight:"100px",height:"auto",padding:0,borderWidth:0});$.support.minHeight=div.offsetHeight===100;$.support.selectstart="onselectstart"in div;body.removeChild(div).style.display="none";});if(!$("<a>").outerWidth(1).jquery){$.each(["Width","Height"],function(i,name){var side=name==="Width"?["Left","Right"]:["Top","Bottom"],type=name.toLowerCase(),orig={innerWidth:$.fn.innerWidth,innerHeight:$.fn.innerHeight,outerWidth:$.fn.outerWidth,outerHeight:$.fn.outerHeight};function reduce(elem,size,border,margin){$.each(side,function(){size-=parseFloat($.css(elem,"padding"+this))||0;if(border){size-=parseFloat($.css(elem,"border"+this+"Width"))||0;}
if(margin){size-=parseFloat($.css(elem,"margin"+this))||0;}});return size;}
$.fn["inner"+name]=function(size){if(size===undefined){return orig["inner"+name].call(this);}
return this.each(function(){$(this).css(type,reduce(this,size)+"px");});};$.fn["outer"+name]=function(size,margin){if(typeof size!=="number"){return orig["outer"+name].call(this,size);}
return this.each(function(){$(this).css(type,reduce(this,size,true,margin)+"px");});};});}
if($("<a>").data("a-b","a").removeData("a-b").data("a-b")){$.fn.removeData=(function(removeData){return function(key){if(arguments.length){return removeData.call(this,$.camelCase(key));}else{return removeData.call(this);}};})($.fn.removeData);}
(function(){var uaMatch=/msie ([\w.]+)/.exec(navigator.userAgent.toLowerCase())||[];$.ui.ie=uaMatch.length?true:false;$.ui.ie6=parseFloat(uaMatch[1],10)===6;})();$.fn.extend({disableSelection:function(){return this.bind(($.support.selectstart?"selectstart":"mousedown")+".ui-disableSelection",function(event){event.preventDefault();});},enableSelection:function(){return this.unbind(".ui-disableSelection");}});$.extend($.ui,{plugin:{add:function(module,option,set){var i,proto=$.ui[module].prototype;for(i in set){proto.plugins[i]=proto.plugins[i]||[];proto.plugins[i].push([option,set[i]]);}},call:function(instance,name,args){var i,set=instance.plugins[name];if(!set||!instance.element[0].parentNode||instance.element[0].parentNode.nodeType===11){return;}
for(i=0;i<set.length;i++){if(instance.options[set[i][0]]){set[i][1].apply(instance.element,args);}}}},contains:$.contains,hasScroll:function(el,a){if($(el).css("overflow")==="hidden"){return false;}
var scroll=(a&&a==="left")?"scrollLeft":"scrollTop",has=false;if(el[scroll]>0){return true;}
el[scroll]=1;has=(el[scroll]>0);el[scroll]=0;return has;},isOverAxis:function(x,reference,size){return(x>reference)&&(x<(reference+size));},isOver:function(y,x,top,left,height,width){return $.ui.isOverAxis(y,top,height)&&$.ui.isOverAxis(x,left,width);}});})(jQuery);(function($,undefined){var uuid=0,slice=Array.prototype.slice,_cleanData=$.cleanData;$.cleanData=function(elems){for(var i=0,elem;(elem=elems[i])!=null;i++){try{$(elem).triggerHandler("remove");}catch(e){}}
_cleanData(elems);};$.widget=function(name,base,prototype){var fullName,existingConstructor,constructor,basePrototype,namespace=name.split(".")[0];name=name.split(".")[1];fullName=namespace+"-"+name;if(!prototype){prototype=base;base=$.Widget;}
$.expr[":"][fullName.toLowerCase()]=function(elem){return!!$.data(elem,fullName);};$[namespace]=$[namespace]||{};existingConstructor=$[namespace][name];constructor=$[namespace][name]=function(options,element){if(!this._createWidget){return new constructor(options,element);}
if(arguments.length){this._createWidget(options,element);}};$.extend(constructor,existingConstructor,{version:prototype.version,_proto:$.extend({},prototype),_childConstructors:[]});basePrototype=new base();basePrototype.options=$.widget.extend({},basePrototype.options);$.each(prototype,function(prop,value){if($.isFunction(value)){prototype[prop]=(function(){var _super=function(){return base.prototype[prop].apply(this,arguments);},_superApply=function(args){return base.prototype[prop].apply(this,args);};return function(){var __super=this._super,__superApply=this._superApply,returnValue;this._super=_super;this._superApply=_superApply;returnValue=value.apply(this,arguments);this._super=__super;this._superApply=__superApply;return returnValue;};})();}});constructor.prototype=$.widget.extend(basePrototype,{widgetEventPrefix:existingConstructor?basePrototype.widgetEventPrefix:name},prototype,{constructor:constructor,namespace:namespace,widgetName:name,widgetBaseClass:fullName,widgetFullName:fullName});if(existingConstructor){$.each(existingConstructor._childConstructors,function(i,child){var childPrototype=child.prototype;$.widget(childPrototype.namespace+"."+childPrototype.widgetName,constructor,child._proto);});delete existingConstructor._childConstructors;}else{base._childConstructors.push(constructor);}
$.widget.bridge(name,constructor);};$.widget.extend=function(target){var input=slice.call(arguments,1),inputIndex=0,inputLength=input.length,key,value;for(;inputIndex<inputLength;inputIndex++){for(key in input[inputIndex]){value=input[inputIndex][key];if(input[inputIndex].hasOwnProperty(key)&&value!==undefined){if($.isPlainObject(value)){target[key]=$.isPlainObject(target[key])?$.widget.extend({},target[key],value):$.widget.extend({},value);}else{target[key]=value;}}}}
return target;};$.widget.bridge=function(name,object){var fullName=object.prototype.widgetFullName||name;$.fn[name]=function(options){var isMethodCall=typeof options==="string",args=slice.call(arguments,1),returnValue=this;options=!isMethodCall&&args.length?$.widget.extend.apply(null,[options].concat(args)):options;if(isMethodCall){this.each(function(){var methodValue,instance=$.data(this,fullName);if(!instance){return $.error("cannot call methods on "+name+" prior to initialization; "+"attempted to call method '"+options+"'");}
if(!$.isFunction(instance[options])||options.charAt(0)==="_"){return $.error("no such method '"+options+"' for "+name+" widget instance");}
methodValue=instance[options].apply(instance,args);if(methodValue!==instance&&methodValue!==undefined){returnValue=methodValue&&methodValue.jquery?returnValue.pushStack(methodValue.get()):methodValue;return false;}});}else{this.each(function(){var instance=$.data(this,fullName);if(instance){instance.option(options||{})._init();}else{$.data(this,fullName,new object(options,this));}});}
return returnValue;};};$.Widget=function(){};$.Widget._childConstructors=[];$.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{disabled:false,create:null},_createWidget:function(options,element){element=$(element||this.defaultElement||this)[0];this.element=$(element);this.uuid=uuid++;this.eventNamespace="."+this.widgetName+this.uuid;this.options=$.widget.extend({},this.options,this._getCreateOptions(),options);this.bindings=$();this.hoverable=$();this.focusable=$();if(element!==this){$.data(element,this.widgetName,this);$.data(element,this.widgetFullName,this);this._on(true,this.element,{remove:function(event){if(event.target===element){this.destroy();}}});this.document=$(element.style?element.ownerDocument:element.document||element);this.window=$(this.document[0].defaultView||this.document[0].parentWindow);}
this._create();this._trigger("create",null,this._getCreateEventData());this._init();},_getCreateOptions:$.noop,_getCreateEventData:$.noop,_create:$.noop,_init:$.noop,destroy:function(){this._destroy();this.element.unbind(this.eventNamespace).removeData(this.widgetName).removeData(this.widgetFullName).removeData($.camelCase(this.widgetFullName));this.widget().unbind(this.eventNamespace).removeAttr("aria-disabled").removeClass(this.widgetFullName+"-disabled "+"ui-state-disabled");this.bindings.unbind(this.eventNamespace);this.hoverable.removeClass("ui-state-hover");this.focusable.removeClass("ui-state-focus");},_destroy:$.noop,widget:function(){return this.element;},option:function(key,value){var options=key,parts,curOption,i;if(arguments.length===0){return $.widget.extend({},this.options);}
if(typeof key==="string"){options={};parts=key.split(".");key=parts.shift();if(parts.length){curOption=options[key]=$.widget.extend({},this.options[key]);for(i=0;i<parts.length-1;i++){curOption[parts[i]]=curOption[parts[i]]||{};curOption=curOption[parts[i]];}
key=parts.pop();if(value===undefined){return curOption[key]===undefined?null:curOption[key];}
curOption[key]=value;}else{if(value===undefined){return this.options[key]===undefined?null:this.options[key];}
options[key]=value;}}
this._setOptions(options);return this;},_setOptions:function(options){var key;for(key in options){this._setOption(key,options[key]);}
return this;},_setOption:function(key,value){this.options[key]=value;if(key==="disabled"){this.widget().toggleClass(this.widgetFullName+"-disabled ui-state-disabled",!!value).attr("aria-disabled",value);this.hoverable.removeClass("ui-state-hover");this.focusable.removeClass("ui-state-focus");}
return this;},enable:function(){return this._setOption("disabled",false);},disable:function(){return this._setOption("disabled",true);},_on:function(suppressDisabledCheck,element,handlers){var delegateElement,instance=this;if(typeof suppressDisabledCheck!=="boolean"){handlers=element;element=suppressDisabledCheck;suppressDisabledCheck=false;}
if(!handlers){handlers=element;element=this.element;delegateElement=this.widget();}else{element=delegateElement=$(element);this.bindings=this.bindings.add(element);}
$.each(handlers,function(event,handler){function handlerProxy(){if(!suppressDisabledCheck&&(instance.options.disabled===true||$(this).hasClass("ui-state-disabled"))){return;}
return(typeof handler==="string"?instance[handler]:handler).apply(instance,arguments);}
if(typeof handler!=="string"){handlerProxy.guid=handler.guid=handler.guid||handlerProxy.guid||$.guid++;}
var match=event.match(/^(\w+)\s*(.*)$/),eventName=match[1]+instance.eventNamespace,selector=match[2];if(selector){delegateElement.delegate(selector,eventName,handlerProxy);}else{element.bind(eventName,handlerProxy);}});},_off:function(element,eventName){eventName=(eventName||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace;element.unbind(eventName).undelegate(eventName);},_delay:function(handler,delay){function handlerProxy(){return(typeof handler==="string"?instance[handler]:handler).apply(instance,arguments);}
var instance=this;return setTimeout(handlerProxy,delay||0);},_hoverable:function(element){this.hoverable=this.hoverable.add(element);this._on(element,{mouseenter:function(event){$(event.currentTarget).addClass("ui-state-hover");},mouseleave:function(event){$(event.currentTarget).removeClass("ui-state-hover");}});},_focusable:function(element){this.focusable=this.focusable.add(element);this._on(element,{focusin:function(event){$(event.currentTarget).addClass("ui-state-focus");},focusout:function(event){$(event.currentTarget).removeClass("ui-state-focus");}});},_trigger:function(type,event,data){var prop,orig,callback=this.options[type];data=data||{};event=$.Event(event);event.type=(type===this.widgetEventPrefix?type:this.widgetEventPrefix+type).toLowerCase();event.target=this.element[0];orig=event.originalEvent;if(orig){for(prop in orig){if(!(prop in event)){event[prop]=orig[prop];}}}
this.element.trigger(event,data);return!($.isFunction(callback)&&callback.apply(this.element[0],[event].concat(data))===false||event.isDefaultPrevented());}};$.each({show:"fadeIn",hide:"fadeOut"},function(method,defaultEffect){$.Widget.prototype["_"+method]=function(element,options,callback){if(typeof options==="string"){options={effect:options};}
var hasOptions,effectName=!options?method:options===true||typeof options==="number"?defaultEffect:options.effect||defaultEffect;options=options||{};if(typeof options==="number"){options={duration:options};}
hasOptions=!$.isEmptyObject(options);options.complete=callback;if(options.delay){element.delay(options.delay);}
if(hasOptions&&$.effects&&($.effects.effect[effectName]||$.uiBackCompat!==false&&$.effects[effectName])){element[method](options);}else if(effectName!==method&&element[effectName]){element[effectName](options.duration,options.easing,callback);}else{element.queue(function(next){$(this)[method]();if(callback){callback.call(element[0]);}
next();});}};});if($.uiBackCompat!==false){$.Widget.prototype._getCreateOptions=function(){return $.metadata&&$.metadata.get(this.element[0])[this.widgetName];};}})(jQuery);(function($,undefined){var mouseHandled=false;$(document).mouseup(function(e){mouseHandled=false;});$.widget("ui.mouse",{version:"1.9.2",options:{cancel:'input,textarea,button,select,option',distance:1,delay:0},_mouseInit:function(){var that=this;this.element.bind('mousedown.'+this.widgetName,function(event){return that._mouseDown(event);}).bind('click.'+this.widgetName,function(event){if(true===$.data(event.target,that.widgetName+'.preventClickEvent')){$.removeData(event.target,that.widgetName+'.preventClickEvent');event.stopImmediatePropagation();return false;}});this.started=false;},_mouseDestroy:function(){this.element.unbind('.'+this.widgetName);if(this._mouseMoveDelegate){$(document).unbind('mousemove.'+this.widgetName,this._mouseMoveDelegate).unbind('mouseup.'+this.widgetName,this._mouseUpDelegate);}},_mouseDown:function(event){if(mouseHandled){return;}
(this._mouseStarted&&this._mouseUp(event));this._mouseDownEvent=event;var that=this,btnIsLeft=(event.which===1),elIsCancel=(typeof this.options.cancel==="string"&&event.target.nodeName?$(event.target).closest(this.options.cancel).length:false);if(!btnIsLeft||elIsCancel||!this._mouseCapture(event)){return true;}
this.mouseDelayMet=!this.options.delay;if(!this.mouseDelayMet){this._mouseDelayTimer=setTimeout(function(){that.mouseDelayMet=true;},this.options.delay);}
if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=(this._mouseStart(event)!==false);if(!this._mouseStarted){event.preventDefault();return true;}}
if(true===$.data(event.target,this.widgetName+'.preventClickEvent')){$.removeData(event.target,this.widgetName+'.preventClickEvent');}
this._mouseMoveDelegate=function(event){return that._mouseMove(event);};this._mouseUpDelegate=function(event){return that._mouseUp(event);};$(document).bind('mousemove.'+this.widgetName,this._mouseMoveDelegate).bind('mouseup.'+this.widgetName,this._mouseUpDelegate);event.preventDefault();mouseHandled=true;return true;},_mouseMove:function(event){if($.ui.ie&&!(document.documentMode>=9)&&!event.button){return this._mouseUp(event);}
if(this._mouseStarted){this._mouseDrag(event);return event.preventDefault();}
if(this._mouseDistanceMet(event)&&this._mouseDelayMet(event)){this._mouseStarted=(this._mouseStart(this._mouseDownEvent,event)!==false);(this._mouseStarted?this._mouseDrag(event):this._mouseUp(event));}
return!this._mouseStarted;},_mouseUp:function(event){$(document).unbind('mousemove.'+this.widgetName,this._mouseMoveDelegate).unbind('mouseup.'+this.widgetName,this._mouseUpDelegate);if(this._mouseStarted){this._mouseStarted=false;if(event.target===this._mouseDownEvent.target){$.data(event.target,this.widgetName+'.preventClickEvent',true);}
this._mouseStop(event);}
return false;},_mouseDistanceMet:function(event){return(Math.max(Math.abs(this._mouseDownEvent.pageX-event.pageX),Math.abs(this._mouseDownEvent.pageY-event.pageY))>=this.options.distance);},_mouseDelayMet:function(event){return this.mouseDelayMet;},_mouseStart:function(event){},_mouseDrag:function(event){},_mouseStop:function(event){},_mouseCapture:function(event){return true;}});})(jQuery);(function($,undefined){$.ui=$.ui||{};var cachedScrollbarWidth,max=Math.max,abs=Math.abs,round=Math.round,rhorizontal=/left|center|right/,rvertical=/top|center|bottom/,roffset=/[\+\-]\d+%?/,rposition=/^\w+/,rpercent=/%$/,_position=$.fn.position;function getOffsets(offsets,width,height){return[parseInt(offsets[0],10)*(rpercent.test(offsets[0])?width/100:1),parseInt(offsets[1],10)*(rpercent.test(offsets[1])?height/100:1)];}
function parseCss(element,property){return parseInt($.css(element,property),10)||0;}
$.position={scrollbarWidth:function(){if(cachedScrollbarWidth!==undefined){return cachedScrollbarWidth;}
var w1,w2,div=$("<div style='display:block;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>"),innerDiv=div.children()[0];$("body").append(div);w1=innerDiv.offsetWidth;div.css("overflow","scroll");w2=innerDiv.offsetWidth;if(w1===w2){w2=div[0].clientWidth;}
div.remove();return(cachedScrollbarWidth=w1-w2);},getScrollInfo:function(within){var overflowX=within.isWindow?"":within.element.css("overflow-x"),overflowY=within.isWindow?"":within.element.css("overflow-y"),hasOverflowX=overflowX==="scroll"||(overflowX==="auto"&&within.width<within.element[0].scrollWidth),hasOverflowY=overflowY==="scroll"||(overflowY==="auto"&&within.height<within.element[0].scrollHeight);return{width:hasOverflowX?$.position.scrollbarWidth():0,height:hasOverflowY?$.position.scrollbarWidth():0};},getWithinInfo:function(element){var withinElement=$(element||window),isWindow=$.isWindow(withinElement[0]);return{element:withinElement,isWindow:isWindow,offset:withinElement.offset()||{left:0,top:0},scrollLeft:withinElement.scrollLeft(),scrollTop:withinElement.scrollTop(),width:isWindow?withinElement.width():withinElement.outerWidth(),height:isWindow?withinElement.height():withinElement.outerHeight()};}};$.fn.position=function(options){if(!options||!options.of){return _position.apply(this,arguments);}
options=$.extend({},options);var atOffset,targetWidth,targetHeight,targetOffset,basePosition,target=$(options.of),within=$.position.getWithinInfo(options.within),scrollInfo=$.position.getScrollInfo(within),targetElem=target[0],collision=(options.collision||"flip").split(" "),offsets={};if(targetElem.nodeType===9){targetWidth=target.width();targetHeight=target.height();targetOffset={top:0,left:0};}else if($.isWindow(targetElem)){targetWidth=target.width();targetHeight=target.height();targetOffset={top:target.scrollTop(),left:target.scrollLeft()};}else if(targetElem.preventDefault){options.at="left top";targetWidth=targetHeight=0;targetOffset={top:targetElem.pageY,left:targetElem.pageX};}else{targetWidth=target.outerWidth();targetHeight=target.outerHeight();targetOffset=target.offset();}
basePosition=$.extend({},targetOffset);$.each(["my","at"],function(){var pos=(options[this]||"").split(" "),horizontalOffset,verticalOffset;if(pos.length===1){pos=rhorizontal.test(pos[0])?pos.concat(["center"]):rvertical.test(pos[0])?["center"].concat(pos):["center","center"];}
pos[0]=rhorizontal.test(pos[0])?pos[0]:"center";pos[1]=rvertical.test(pos[1])?pos[1]:"center";horizontalOffset=roffset.exec(pos[0]);verticalOffset=roffset.exec(pos[1]);offsets[this]=[horizontalOffset?horizontalOffset[0]:0,verticalOffset?verticalOffset[0]:0];options[this]=[rposition.exec(pos[0])[0],rposition.exec(pos[1])[0]];});if(collision.length===1){collision[1]=collision[0];}
if(options.at[0]==="right"){basePosition.left+=targetWidth;}else if(options.at[0]==="center"){basePosition.left+=targetWidth/2;}
if(options.at[1]==="bottom"){basePosition.top+=targetHeight;}else if(options.at[1]==="center"){basePosition.top+=targetHeight/2;}
atOffset=getOffsets(offsets.at,targetWidth,targetHeight);basePosition.left+=atOffset[0];basePosition.top+=atOffset[1];return this.each(function(){var collisionPosition,using,elem=$(this),elemWidth=elem.outerWidth(),elemHeight=elem.outerHeight(),marginLeft=parseCss(this,"marginLeft"),marginTop=parseCss(this,"marginTop"),collisionWidth=elemWidth+marginLeft+parseCss(this,"marginRight")+scrollInfo.width,collisionHeight=elemHeight+marginTop+parseCss(this,"marginBottom")+scrollInfo.height,position=$.extend({},basePosition),myOffset=getOffsets(offsets.my,elem.outerWidth(),elem.outerHeight());if(options.my[0]==="right"){position.left-=elemWidth;}else if(options.my[0]==="center"){position.left-=elemWidth/2;}
if(options.my[1]==="bottom"){position.top-=elemHeight;}else if(options.my[1]==="center"){position.top-=elemHeight/2;}
position.left+=myOffset[0];position.top+=myOffset[1];if(!$.support.offsetFractions){position.left=round(position.left);position.top=round(position.top);}
collisionPosition={marginLeft:marginLeft,marginTop:marginTop};$.each(["left","top"],function(i,dir){if($.ui.position[collision[i]]){$.ui.position[collision[i]][dir](position,{targetWidth:targetWidth,targetHeight:targetHeight,elemWidth:elemWidth,elemHeight:elemHeight,collisionPosition:collisionPosition,collisionWidth:collisionWidth,collisionHeight:collisionHeight,offset:[atOffset[0]+myOffset[0],atOffset[1]+myOffset[1]],my:options.my,at:options.at,within:within,elem:elem});}});if($.fn.bgiframe){elem.bgiframe();}
if(options.using){using=function(props){var left=targetOffset.left-position.left,right=left+targetWidth-elemWidth,top=targetOffset.top-position.top,bottom=top+targetHeight-elemHeight,feedback={target:{element:target,left:targetOffset.left,top:targetOffset.top,width:targetWidth,height:targetHeight},element:{element:elem,left:position.left,top:position.top,width:elemWidth,height:elemHeight},horizontal:right<0?"left":left>0?"right":"center",vertical:bottom<0?"top":top>0?"bottom":"middle"};if(targetWidth<elemWidth&&abs(left+right)<targetWidth){feedback.horizontal="center";}
if(targetHeight<elemHeight&&abs(top+bottom)<targetHeight){feedback.vertical="middle";}
if(max(abs(left),abs(right))>max(abs(top),abs(bottom))){feedback.important="horizontal";}else{feedback.important="vertical";}
options.using.call(this,props,feedback);};}
elem.offset($.extend(position,{using:using}));});};$.ui.position={fit:{left:function(position,data){var within=data.within,withinOffset=within.isWindow?within.scrollLeft:within.offset.left,outerWidth=within.width,collisionPosLeft=position.left-data.collisionPosition.marginLeft,overLeft=withinOffset-collisionPosLeft,overRight=collisionPosLeft+data.collisionWidth-outerWidth-withinOffset,newOverRight;if(data.collisionWidth>outerWidth){if(overLeft>0&&overRight<=0){newOverRight=position.left+overLeft+data.collisionWidth-outerWidth-withinOffset;position.left+=overLeft-newOverRight;}else if(overRight>0&&overLeft<=0){position.left=withinOffset;}else{if(overLeft>overRight){position.left=withinOffset+outerWidth-data.collisionWidth;}else{position.left=withinOffset;}}}else if(overLeft>0){position.left+=overLeft;}else if(overRight>0){position.left-=overRight;}else{position.left=max(position.left-collisionPosLeft,position.left);}},top:function(position,data){var within=data.within,withinOffset=within.isWindow?within.scrollTop:within.offset.top,outerHeight=data.within.height,collisionPosTop=position.top-data.collisionPosition.marginTop,overTop=withinOffset-collisionPosTop,overBottom=collisionPosTop+data.collisionHeight-outerHeight-withinOffset,newOverBottom;if(data.collisionHeight>outerHeight){if(overTop>0&&overBottom<=0){newOverBottom=position.top+overTop+data.collisionHeight-outerHeight-withinOffset;position.top+=overTop-newOverBottom;}else if(overBottom>0&&overTop<=0){position.top=withinOffset;}else{if(overTop>overBottom){position.top=withinOffset+outerHeight-data.collisionHeight;}else{position.top=withinOffset;}}}else if(overTop>0){position.top+=overTop;}else if(overBottom>0){position.top-=overBottom;}else{position.top=max(position.top-collisionPosTop,position.top);}}},flip:{left:function(position,data){var within=data.within,withinOffset=within.offset.left+within.scrollLeft,outerWidth=within.width,offsetLeft=within.isWindow?within.scrollLeft:within.offset.left,collisionPosLeft=position.left-data.collisionPosition.marginLeft,overLeft=collisionPosLeft-offsetLeft,overRight=collisionPosLeft+data.collisionWidth-outerWidth-offsetLeft,myOffset=data.my[0]==="left"?-data.elemWidth:data.my[0]==="right"?data.elemWidth:0,atOffset=data.at[0]==="left"?data.targetWidth:data.at[0]==="right"?-data.targetWidth:0,offset=-2*data.offset[0],newOverRight,newOverLeft;if(overLeft<0){newOverRight=position.left+myOffset+atOffset+offset+data.collisionWidth-outerWidth-withinOffset;if(newOverRight<0||newOverRight<abs(overLeft)){position.left+=myOffset+atOffset+offset;}}
else if(overRight>0){newOverLeft=position.left-data.collisionPosition.marginLeft+myOffset+atOffset+offset-offsetLeft;if(newOverLeft>0||abs(newOverLeft)<overRight){position.left+=myOffset+atOffset+offset;}}},top:function(position,data){var within=data.within,withinOffset=within.offset.top+within.scrollTop,outerHeight=within.height,offsetTop=within.isWindow?within.scrollTop:within.offset.top,collisionPosTop=position.top-data.collisionPosition.marginTop,overTop=collisionPosTop-offsetTop,overBottom=collisionPosTop+data.collisionHeight-outerHeight-offsetTop,top=data.my[1]==="top",myOffset=top?-data.elemHeight:data.my[1]==="bottom"?data.elemHeight:0,atOffset=data.at[1]==="top"?data.targetHeight:data.at[1]==="bottom"?-data.targetHeight:0,offset=-2*data.offset[1],newOverTop,newOverBottom;if(overTop<0){newOverBottom=position.top+myOffset+atOffset+offset+data.collisionHeight-outerHeight-withinOffset;if((position.top+myOffset+atOffset+offset)>overTop&&(newOverBottom<0||newOverBottom<abs(overTop))){position.top+=myOffset+atOffset+offset;}}
else if(overBottom>0){newOverTop=position.top-data.collisionPosition.marginTop+myOffset+atOffset+offset-offsetTop;if((position.top+myOffset+atOffset+offset)>overBottom&&(newOverTop>0||abs(newOverTop)<overBottom)){position.top+=myOffset+atOffset+offset;}}}},flipfit:{left:function(){$.ui.position.flip.left.apply(this,arguments);$.ui.position.fit.left.apply(this,arguments);},top:function(){$.ui.position.flip.top.apply(this,arguments);$.ui.position.fit.top.apply(this,arguments);}}};(function(){var testElement,testElementParent,testElementStyle,offsetLeft,i,body=document.getElementsByTagName("body")[0],div=document.createElement("div");testElement=document.createElement(body?"div":"body");testElementStyle={visibility:"hidden",width:0,height:0,border:0,margin:0,background:"none"};if(body){$.extend(testElementStyle,{position:"absolute",left:"-1000px",top:"-1000px"});}
for(i in testElementStyle){testElement.style[i]=testElementStyle[i];}
testElement.appendChild(div);testElementParent=body||document.documentElement;testElementParent.insertBefore(testElement,testElementParent.firstChild);div.style.cssText="position: absolute; left: 10.7432222px;";offsetLeft=$(div).offset().left;$.support.offsetFractions=offsetLeft>10&&offsetLeft<11;testElement.innerHTML="";testElementParent.removeChild(testElement);})();if($.uiBackCompat!==false){(function($){var _position=$.fn.position;$.fn.position=function(options){if(!options||!options.offset){return _position.call(this,options);}
var offset=options.offset.split(" "),at=options.at.split(" ");if(offset.length===1){offset[1]=offset[0];}
if(/^\d/.test(offset[0])){offset[0]="+"+offset[0];}
if(/^\d/.test(offset[1])){offset[1]="+"+offset[1];}
if(at.length===1){if(/left|center|right/.test(at[0])){at[1]="center";}else{at[1]=at[0];at[0]="center";}}
return _position.call(this,$.extend(options,{at:at[0]+offset[0]+" "+at[1]+offset[1],offset:undefined}));};}(jQuery));}}(jQuery));(function($,undefined){var uid=0,hideProps={},showProps={};hideProps.height=hideProps.paddingTop=hideProps.paddingBottom=hideProps.borderTopWidth=hideProps.borderBottomWidth="hide";showProps.height=showProps.paddingTop=showProps.paddingBottom=showProps.borderTopWidth=showProps.borderBottomWidth="show";$.widget("ui.accordion",{version:"1.9.2",options:{active:0,animate:{},collapsible:false,event:"click",header:"> li > :first-child,> :not(li):even",heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},activate:null,beforeActivate:null},_create:function(){var accordionId=this.accordionId="ui-accordion-"+
(this.element.attr("id")||++uid),options=this.options;this.prevShow=this.prevHide=$();this.element.addClass("ui-accordion ui-widget ui-helper-reset");this.headers=this.element.find(options.header).addClass("ui-accordion-header ui-helper-reset ui-state-default ui-corner-all");this._hoverable(this.headers);this._focusable(this.headers);this.headers.next().addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom").hide();if(!options.collapsible&&(options.active===false||options.active==null)){options.active=0;}
if(options.active<0){options.active+=this.headers.length;}
this.active=this._findActive(options.active).addClass("ui-accordion-header-active ui-state-active").toggleClass("ui-corner-all ui-corner-top");this.active.next().addClass("ui-accordion-content-active").show();this._createIcons();this.refresh();this.element.attr("role","tablist");this.headers.attr("role","tab").each(function(i){var header=$(this),headerId=header.attr("id"),panel=header.next(),panelId=panel.attr("id");if(!headerId){headerId=accordionId+"-header-"+i;header.attr("id",headerId);}
if(!panelId){panelId=accordionId+"-panel-"+i;panel.attr("id",panelId);}
header.attr("aria-controls",panelId);panel.attr("aria-labelledby",headerId);}).next().attr("role","tabpanel");this.headers.not(this.active).attr({"aria-selected":"false",tabIndex:-1}).next().attr({"aria-expanded":"false","aria-hidden":"true"}).hide();if(!this.active.length){this.headers.eq(0).attr("tabIndex",0);}else{this.active.attr({"aria-selected":"true",tabIndex:0}).next().attr({"aria-expanded":"true","aria-hidden":"false"});}
this._on(this.headers,{keydown:"_keydown"});this._on(this.headers.next(),{keydown:"_panelKeyDown"});this._setupEvents(options.event);},_getCreateEventData:function(){return{header:this.active,content:!this.active.length?$():this.active.next()};},_createIcons:function(){var icons=this.options.icons;if(icons){$("<span>").addClass("ui-accordion-header-icon ui-icon "+icons.header).prependTo(this.headers);this.active.children(".ui-accordion-header-icon").removeClass(icons.header).addClass(icons.activeHeader);this.headers.addClass("ui-accordion-icons");}},_destroyIcons:function(){this.headers.removeClass("ui-accordion-icons").children(".ui-accordion-header-icon").remove();},_destroy:function(){var contents;this.element.removeClass("ui-accordion ui-widget ui-helper-reset").removeAttr("role");this.headers.removeClass("ui-accordion-header ui-accordion-header-active ui-helper-reset ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top").removeAttr("role").removeAttr("aria-selected").removeAttr("aria-controls").removeAttr("tabIndex").each(function(){if(/^ui-accordion/.test(this.id)){this.removeAttribute("id");}});this._destroyIcons();contents=this.headers.next().css("display","").removeAttr("role").removeAttr("aria-expanded").removeAttr("aria-hidden").removeAttr("aria-labelledby").removeClass("ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled").each(function(){if(/^ui-accordion/.test(this.id)){this.removeAttribute("id");}});if(this.options.heightStyle!=="content"){contents.css("height","");}},_setOption:function(key,value){if(key==="active"){this._activate(value);return;}
if(key==="event"){if(this.options.event){this._off(this.headers,this.options.event);}
this._setupEvents(value);}
this._super(key,value);if(key==="collapsible"&&!value&&this.options.active===false){this._activate(0);}
if(key==="icons"){this._destroyIcons();if(value){this._createIcons();}}
if(key==="disabled"){this.headers.add(this.headers.next()).toggleClass("ui-state-disabled",!!value);}},_keydown:function(event){if(event.altKey||event.ctrlKey){return;}
var keyCode=$.ui.keyCode,length=this.headers.length,currentIndex=this.headers.index(event.target),toFocus=false;switch(event.keyCode){case keyCode.RIGHT:case keyCode.DOWN:toFocus=this.headers[(currentIndex+1)%length];break;case keyCode.LEFT:case keyCode.UP:toFocus=this.headers[(currentIndex-1+length)%length];break;case keyCode.SPACE:case keyCode.ENTER:this._eventHandler(event);break;case keyCode.HOME:toFocus=this.headers[0];break;case keyCode.END:toFocus=this.headers[length-1];break;}
if(toFocus){$(event.target).attr("tabIndex",-1);$(toFocus).attr("tabIndex",0);toFocus.focus();event.preventDefault();}},_panelKeyDown:function(event){if(event.keyCode===$.ui.keyCode.UP&&event.ctrlKey){$(event.currentTarget).prev().focus();}},refresh:function(){var maxHeight,overflow,heightStyle=this.options.heightStyle,parent=this.element.parent();if(heightStyle==="fill"){if(!$.support.minHeight){overflow=parent.css("overflow");parent.css("overflow","hidden");}
maxHeight=parent.height();this.element.siblings(":visible").each(function(){var elem=$(this),position=elem.css("position");if(position==="absolute"||position==="fixed"){return;}
maxHeight-=elem.outerHeight(true);});if(overflow){parent.css("overflow",overflow);}
this.headers.each(function(){maxHeight-=$(this).outerHeight(true);});this.headers.next().each(function(){$(this).height(Math.max(0,maxHeight-
$(this).innerHeight()+$(this).height()));}).css("overflow","auto");}else if(heightStyle==="auto"){maxHeight=0;this.headers.next().each(function(){maxHeight=Math.max(maxHeight,$(this).css("height","").height());}).height(maxHeight);}},_activate:function(index){var active=this._findActive(index)[0];if(active===this.active[0]){return;}
active=active||this.active[0];this._eventHandler({target:active,currentTarget:active,preventDefault:$.noop});},_findActive:function(selector){return typeof selector==="number"?this.headers.eq(selector):$();},_setupEvents:function(event){var events={};if(!event){return;}
$.each(event.split(" "),function(index,eventName){events[eventName]="_eventHandler";});this._on(this.headers,events);},_eventHandler:function(event){var options=this.options,active=this.active,clicked=$(event.currentTarget),clickedIsActive=clicked[0]===active[0],collapsing=clickedIsActive&&options.collapsible,toShow=collapsing?$():clicked.next(),toHide=active.next(),eventData={oldHeader:active,oldPanel:toHide,newHeader:collapsing?$():clicked,newPanel:toShow};event.preventDefault();if((clickedIsActive&&!options.collapsible)||(this._trigger("beforeActivate",event,eventData)===false)){return;}
options.active=collapsing?false:this.headers.index(clicked);this.active=clickedIsActive?$():clicked;this._toggle(eventData);active.removeClass("ui-accordion-header-active ui-state-active");if(options.icons){active.children(".ui-accordion-header-icon").removeClass(options.icons.activeHeader).addClass(options.icons.header);}
if(!clickedIsActive){clicked.removeClass("ui-corner-all").addClass("ui-accordion-header-active ui-state-active ui-corner-top");if(options.icons){clicked.children(".ui-accordion-header-icon").removeClass(options.icons.header).addClass(options.icons.activeHeader);}
clicked.next().addClass("ui-accordion-content-active");}},_toggle:function(data){var toShow=data.newPanel,toHide=this.prevShow.length?this.prevShow:data.oldPanel;this.prevShow.add(this.prevHide).stop(true,true);this.prevShow=toShow;this.prevHide=toHide;if(this.options.animate){this._animate(toShow,toHide,data);}else{toHide.hide();toShow.show();this._toggleComplete(data);}
toHide.attr({"aria-expanded":"false","aria-hidden":"true"});toHide.prev().attr("aria-selected","false");if(toShow.length&&toHide.length){toHide.prev().attr("tabIndex",-1);}else if(toShow.length){this.headers.filter(function(){return $(this).attr("tabIndex")===0;}).attr("tabIndex",-1);}
toShow.attr({"aria-expanded":"true","aria-hidden":"false"}).prev().attr({"aria-selected":"true",tabIndex:0});},_animate:function(toShow,toHide,data){var total,easing,duration,that=this,adjust=0,down=toShow.length&&(!toHide.length||(toShow.index()<toHide.index())),animate=this.options.animate||{},options=down&&animate.down||animate,complete=function(){that._toggleComplete(data);};if(typeof options==="number"){duration=options;}
if(typeof options==="string"){easing=options;}
easing=easing||options.easing||animate.easing;duration=duration||options.duration||animate.duration;if(!toHide.length){return toShow.animate(showProps,duration,easing,complete);}
if(!toShow.length){return toHide.animate(hideProps,duration,easing,complete);}
total=toShow.show().outerHeight();toHide.animate(hideProps,{duration:duration,easing:easing,step:function(now,fx){fx.now=Math.round(now);}});toShow.hide().animate(showProps,{duration:duration,easing:easing,complete:complete,step:function(now,fx){fx.now=Math.round(now);if(fx.prop!=="height"){adjust+=fx.now;}else if(that.options.heightStyle!=="content"){fx.now=Math.round(total-toHide.outerHeight()-adjust);adjust=0;}}});},_toggleComplete:function(data){var toHide=data.oldPanel;toHide.removeClass("ui-accordion-content-active").prev().removeClass("ui-corner-top").addClass("ui-corner-all");if(toHide.length){toHide.parent()[0].className=toHide.parent()[0].className;}
this._trigger("activate",null,data);}});if($.uiBackCompat!==false){(function($,prototype){$.extend(prototype.options,{navigation:false,navigationFilter:function(){return this.href.toLowerCase()===location.href.toLowerCase();}});var _create=prototype._create;prototype._create=function(){if(this.options.navigation){var that=this,headers=this.element.find(this.options.header),content=headers.next(),current=headers.add(content).find("a").filter(this.options.navigationFilter)
[0];if(current){headers.add(content).each(function(index){if($.contains(this,current)){that.options.active=Math.floor(index/2);return false;}});}}
_create.call(this);};}(jQuery,jQuery.ui.accordion.prototype));(function($,prototype){$.extend(prototype.options,{heightStyle:null,autoHeight:true,clearStyle:false,fillSpace:false});var _create=prototype._create,_setOption=prototype._setOption;$.extend(prototype,{_create:function(){this.options.heightStyle=this.options.heightStyle||this._mergeHeightStyle();_create.call(this);},_setOption:function(key){if(key==="autoHeight"||key==="clearStyle"||key==="fillSpace"){this.options.heightStyle=this._mergeHeightStyle();}
_setOption.apply(this,arguments);},_mergeHeightStyle:function(){var options=this.options;if(options.fillSpace){return"fill";}
if(options.clearStyle){return"content";}
if(options.autoHeight){return"auto";}}});}(jQuery,jQuery.ui.accordion.prototype));(function($,prototype){$.extend(prototype.options.icons,{activeHeader:null,headerSelected:"ui-icon-triangle-1-s"});var _createIcons=prototype._createIcons;prototype._createIcons=function(){if(this.options.icons){this.options.icons.activeHeader=this.options.icons.activeHeader||this.options.icons.headerSelected;}
_createIcons.call(this);};}(jQuery,jQuery.ui.accordion.prototype));(function($,prototype){prototype.activate=prototype._activate;var _findActive=prototype._findActive;prototype._findActive=function(index){if(index===-1){index=false;}
if(index&&typeof index!=="number"){index=this.headers.index(this.headers.filter(index));if(index===-1){index=false;}}
return _findActive.call(this,index);};}(jQuery,jQuery.ui.accordion.prototype));jQuery.ui.accordion.prototype.resize=jQuery.ui.accordion.prototype.refresh;(function($,prototype){$.extend(prototype.options,{change:null,changestart:null});var _trigger=prototype._trigger;prototype._trigger=function(type,event,data){var ret=_trigger.apply(this,arguments);if(!ret){return false;}
if(type==="beforeActivate"){ret=_trigger.call(this,"changestart",event,{oldHeader:data.oldHeader,oldContent:data.oldPanel,newHeader:data.newHeader,newContent:data.newPanel});}else if(type==="activate"){ret=_trigger.call(this,"change",event,{oldHeader:data.oldHeader,oldContent:data.oldPanel,newHeader:data.newHeader,newContent:data.newPanel});}
return ret;};}(jQuery,jQuery.ui.accordion.prototype));(function($,prototype){$.extend(prototype.options,{animate:null,animated:"slide"});var _create=prototype._create;prototype._create=function(){var options=this.options;if(options.animate===null){if(!options.animated){options.animate=false;}else if(options.animated==="slide"){options.animate=300;}else if(options.animated==="bounceslide"){options.animate={duration:200,down:{easing:"easeOutBounce",duration:1000}};}else{options.animate=options.animated;}}
_create.call(this);};}(jQuery,jQuery.ui.accordion.prototype));}})(jQuery);(function($,undefined){var requestIndex=0;$.widget("ui.autocomplete",{version:"1.9.2",defaultElement:"<input>",options:{appendTo:"body",autoFocus:false,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},pending:0,_create:function(){var suppressKeyPress,suppressKeyPressRepeat,suppressInput;this.isMultiLine=this._isMultiLine();this.valueMethod=this.element[this.element.is("input,textarea")?"val":"text"];this.isNewMenu=true;this.element.addClass("ui-autocomplete-input").attr("autocomplete","off");this._on(this.element,{keydown:function(event){if(this.element.prop("readOnly")){suppressKeyPress=true;suppressInput=true;suppressKeyPressRepeat=true;return;}
suppressKeyPress=false;suppressInput=false;suppressKeyPressRepeat=false;var keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.PAGE_UP:suppressKeyPress=true;this._move("previousPage",event);break;case keyCode.PAGE_DOWN:suppressKeyPress=true;this._move("nextPage",event);break;case keyCode.UP:suppressKeyPress=true;this._keyEvent("previous",event);break;case keyCode.DOWN:suppressKeyPress=true;this._keyEvent("next",event);break;case keyCode.ENTER:case keyCode.NUMPAD_ENTER:if(this.menu.active){suppressKeyPress=true;event.preventDefault();this.menu.select(event);}
break;case keyCode.TAB:if(this.menu.active){this.menu.select(event);}
break;case keyCode.ESCAPE:if(this.menu.element.is(":visible")){this._value(this.term);this.close(event);event.preventDefault();}
break;default:suppressKeyPressRepeat=true;this._searchTimeout(event);break;}},keypress:function(event){if(suppressKeyPress){suppressKeyPress=false;event.preventDefault();return;}
if(suppressKeyPressRepeat){return;}
var keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.PAGE_UP:this._move("previousPage",event);break;case keyCode.PAGE_DOWN:this._move("nextPage",event);break;case keyCode.UP:this._keyEvent("previous",event);break;case keyCode.DOWN:this._keyEvent("next",event);break;}},input:function(event){if(suppressInput){suppressInput=false;event.preventDefault();return;}
this._searchTimeout(event);},focus:function(){this.selectedItem=null;this.previous=this._value();},blur:function(event){if(this.cancelBlur){delete this.cancelBlur;return;}
clearTimeout(this.searching);this.close(event);this._change(event);}});this._initSource();this.menu=$("<ul>").addClass("ui-autocomplete").appendTo(this.document.find(this.options.appendTo||"body")[0]).menu({input:$(),role:null}).zIndex(this.element.zIndex()+1).hide().data("menu");this._on(this.menu.element,{mousedown:function(event){event.preventDefault();this.cancelBlur=true;this._delay(function(){delete this.cancelBlur;});var menuElement=this.menu.element[0];if(!$(event.target).closest(".ui-menu-item").length){this._delay(function(){var that=this;this.document.one("mousedown",function(event){if(event.target!==that.element[0]&&event.target!==menuElement&&!$.contains(menuElement,event.target)){that.close();}});});}},menufocus:function(event,ui){if(this.isNewMenu){this.isNewMenu=false;if(event.originalEvent&&/^mouse/.test(event.originalEvent.type)){this.menu.blur();this.document.one("mousemove",function(){$(event.target).trigger(event.originalEvent);});return;}}
var item=ui.item.data("ui-autocomplete-item")||ui.item.data("item.autocomplete");if(false!==this._trigger("focus",event,{item:item})){if(event.originalEvent&&/^key/.test(event.originalEvent.type)){this._value(item.value);}}else{this.liveRegion.text(item.value);}},menuselect:function(event,ui){var item=ui.item.data("ui-autocomplete-item")||ui.item.data("item.autocomplete"),previous=this.previous;if(this.element[0]!==this.document[0].activeElement){this.element.focus();this.previous=previous;this._delay(function(){this.previous=previous;this.selectedItem=item;});}
if(false!==this._trigger("select",event,{item:item})){this._value(item.value);}
this.term=this._value();this.close(event);this.selectedItem=item;}});this.liveRegion=$("<span>",{role:"status","aria-live":"polite"}).addClass("ui-helper-hidden-accessible").insertAfter(this.element);if($.fn.bgiframe){this.menu.element.bgiframe();}
this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete");}});},_destroy:function(){clearTimeout(this.searching);this.element.removeClass("ui-autocomplete-input").removeAttr("autocomplete");this.menu.element.remove();this.liveRegion.remove();},_setOption:function(key,value){this._super(key,value);if(key==="source"){this._initSource();}
if(key==="appendTo"){this.menu.element.appendTo(this.document.find(value||"body")[0]);}
if(key==="disabled"&&value&&this.xhr){this.xhr.abort();}},_isMultiLine:function(){if(this.element.is("textarea")){return true;}
if(this.element.is("input")){return false;}
return this.element.prop("isContentEditable");},_initSource:function(){var array,url,that=this;if($.isArray(this.options.source)){array=this.options.source;this.source=function(request,response){response($.ui.autocomplete.filter(array,request.term));};}else if(typeof this.options.source==="string"){url=this.options.source;this.source=function(request,response){if(that.xhr){that.xhr.abort();}
that.xhr=$.ajax({url:url,data:request,dataType:"json",success:function(data){response(data);},error:function(){response([]);}});};}else{this.source=this.options.source;}},_searchTimeout:function(event){clearTimeout(this.searching);this.searching=this._delay(function(){if(this.term!==this._value()){this.selectedItem=null;this.search(null,event);}},this.options.delay);},search:function(value,event){value=value!=null?value:this._value();this.term=this._value();if(value.length<this.options.minLength){return this.close(event);}
if(this._trigger("search",event)===false){return;}
return this._search(value);},_search:function(value){this.pending++;this.element.addClass("ui-autocomplete-loading");this.cancelSearch=false;this.source({term:value},this._response());},_response:function(){var that=this,index=++requestIndex;return function(content){if(index===requestIndex){that.__response(content);}
that.pending--;if(!that.pending){that.element.removeClass("ui-autocomplete-loading");}};},__response:function(content){if(content){content=this._normalize(content);}
this._trigger("response",null,{content:content});if(!this.options.disabled&&content&&content.length&&!this.cancelSearch){this._suggest(content);this._trigger("open");}else{this._close();}},close:function(event){this.cancelSearch=true;this._close(event);},_close:function(event){if(this.menu.element.is(":visible")){this.menu.element.hide();this.menu.blur();this.isNewMenu=true;this._trigger("close",event);}},_change:function(event){if(this.previous!==this._value()){this._trigger("change",event,{item:this.selectedItem});}},_normalize:function(items){if(items.length&&items[0].label&&items[0].value){return items;}
return $.map(items,function(item){if(typeof item==="string"){return{label:item,value:item};}
return $.extend({label:item.label||item.value,value:item.value||item.label},item);});},_suggest:function(items){var ul=this.menu.element.empty().zIndex(this.element.zIndex()+1);this._renderMenu(ul,items);this.menu.refresh();ul.show();this._resizeMenu();ul.position($.extend({of:this.element},this.options.position));if(this.options.autoFocus){this.menu.next();}},_resizeMenu:function(){var ul=this.menu.element;ul.outerWidth(Math.max(ul.width("").outerWidth()+1,this.element.outerWidth()));},_renderMenu:function(ul,items){var that=this;$.each(items,function(index,item){that._renderItemData(ul,item);});},_renderItemData:function(ul,item){return this._renderItem(ul,item).data("ui-autocomplete-item",item);},_renderItem:function(ul,item){return $("<li>").append($("<a>").text(item.label)).appendTo(ul);},_move:function(direction,event){if(!this.menu.element.is(":visible")){this.search(null,event);return;}
if(this.menu.isFirstItem()&&/^previous/.test(direction)||this.menu.isLastItem()&&/^next/.test(direction)){this._value(this.term);this.menu.blur();return;}
this.menu[direction](event);},widget:function(){return this.menu.element;},_value:function(){return this.valueMethod.apply(this.element,arguments);},_keyEvent:function(keyEvent,event){if(!this.isMultiLine||this.menu.element.is(":visible")){this._move(keyEvent,event);event.preventDefault();}}});$.extend($.ui.autocomplete,{escapeRegex:function(value){return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&");},filter:function(array,term){var matcher=new RegExp($.ui.autocomplete.escapeRegex(term),"i");return $.grep(array,function(value){return matcher.test(value.label||value.value||value);});}});$.widget("ui.autocomplete",$.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(amount){return amount+(amount>1?" results are":" result is")+" available, use up and down arrow keys to navigate.";}}},__response:function(content){var message;this._superApply(arguments);if(this.options.disabled||this.cancelSearch){return;}
if(content&&content.length){message=this.options.messages.results(content.length);}else{message=this.options.messages.noResults;}
this.liveRegion.text(message);}});}(jQuery));(function($,undefined){var lastActive,startXPos,startYPos,clickDragged,baseClasses="ui-button ui-widget ui-state-default ui-corner-all",stateClasses="ui-state-hover ui-state-active ",typeClasses="ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only",formResetHandler=function(){var buttons=$(this).find(":ui-button");setTimeout(function(){buttons.button("refresh");},1);},radioGroup=function(radio){var name=radio.name,form=radio.form,radios=$([]);if(name){if(form){radios=$(form).find("[name='"+name+"']");}else{radios=$("[name='"+name+"']",radio.ownerDocument).filter(function(){return!this.form;});}}
return radios;};$.widget("ui.button",{version:"1.9.2",defaultElement:"<button>",options:{disabled:null,text:true,label:null,icons:{primary:null,secondary:null}},_create:function(){this.element.closest("form").unbind("reset"+this.eventNamespace).bind("reset"+this.eventNamespace,formResetHandler);if(typeof this.options.disabled!=="boolean"){this.options.disabled=!!this.element.prop("disabled");}else{this.element.prop("disabled",this.options.disabled);}
this._determineButtonType();this.hasTitle=!!this.buttonElement.attr("title");var that=this,options=this.options,toggleButton=this.type==="checkbox"||this.type==="radio",activeClass=!toggleButton?"ui-state-active":"",focusClass="ui-state-focus";if(options.label===null){options.label=(this.type==="input"?this.buttonElement.val():this.buttonElement.html());}
this._hoverable(this.buttonElement);this.buttonElement.addClass(baseClasses).attr("role","button").bind("mouseenter"+this.eventNamespace,function(){if(options.disabled){return;}
if(this===lastActive){$(this).addClass("ui-state-active");}}).bind("mouseleave"+this.eventNamespace,function(){if(options.disabled){return;}
$(this).removeClass(activeClass);}).bind("click"+this.eventNamespace,function(event){if(options.disabled){event.preventDefault();event.stopImmediatePropagation();}});this.element.bind("focus"+this.eventNamespace,function(){that.buttonElement.addClass(focusClass);}).bind("blur"+this.eventNamespace,function(){that.buttonElement.removeClass(focusClass);});if(toggleButton){this.element.bind("change"+this.eventNamespace,function(){if(clickDragged){return;}
that.refresh();});this.buttonElement.bind("mousedown"+this.eventNamespace,function(event){if(options.disabled){return;}
clickDragged=false;startXPos=event.pageX;startYPos=event.pageY;}).bind("mouseup"+this.eventNamespace,function(event){if(options.disabled){return;}
if(startXPos!==event.pageX||startYPos!==event.pageY){clickDragged=true;}});}
if(this.type==="checkbox"){this.buttonElement.bind("click"+this.eventNamespace,function(){if(options.disabled||clickDragged){return false;}
$(this).toggleClass("ui-state-active");that.buttonElement.attr("aria-pressed",that.element[0].checked);});}else if(this.type==="radio"){this.buttonElement.bind("click"+this.eventNamespace,function(){if(options.disabled||clickDragged){return false;}
$(this).addClass("ui-state-active");that.buttonElement.attr("aria-pressed","true");var radio=that.element[0];radioGroup(radio).not(radio).map(function(){return $(this).button("widget")[0];}).removeClass("ui-state-active").attr("aria-pressed","false");});}else{this.buttonElement.bind("mousedown"+this.eventNamespace,function(){if(options.disabled){return false;}
$(this).addClass("ui-state-active");lastActive=this;that.document.one("mouseup",function(){lastActive=null;});}).bind("mouseup"+this.eventNamespace,function(){if(options.disabled){return false;}
$(this).removeClass("ui-state-active");}).bind("keydown"+this.eventNamespace,function(event){if(options.disabled){return false;}
if(event.keyCode===$.ui.keyCode.SPACE||event.keyCode===$.ui.keyCode.ENTER){$(this).addClass("ui-state-active");}}).bind("keyup"+this.eventNamespace,function(){$(this).removeClass("ui-state-active");});if(this.buttonElement.is("a")){this.buttonElement.keyup(function(event){if(event.keyCode===$.ui.keyCode.SPACE){$(this).click();}});}}
this._setOption("disabled",options.disabled);this._resetButton();},_determineButtonType:function(){var ancestor,labelSelector,checked;if(this.element.is("[type=checkbox]")){this.type="checkbox";}else if(this.element.is("[type=radio]")){this.type="radio";}else if(this.element.is("input")){this.type="input";}else{this.type="button";}
if(this.type==="checkbox"||this.type==="radio"){ancestor=this.element.parents().last();labelSelector="label[for='"+this.element.attr("id")+"']";this.buttonElement=ancestor.find(labelSelector);if(!this.buttonElement.length){ancestor=ancestor.length?ancestor.siblings():this.element.siblings();this.buttonElement=ancestor.filter(labelSelector);if(!this.buttonElement.length){this.buttonElement=ancestor.find(labelSelector);}}
this.element.addClass("ui-helper-hidden-accessible");checked=this.element.is(":checked");if(checked){this.buttonElement.addClass("ui-state-active");}
this.buttonElement.prop("aria-pressed",checked);}else{this.buttonElement=this.element;}},widget:function(){return this.buttonElement;},_destroy:function(){this.element.removeClass("ui-helper-hidden-accessible");this.buttonElement.removeClass(baseClasses+" "+stateClasses+" "+typeClasses).removeAttr("role").removeAttr("aria-pressed").html(this.buttonElement.find(".ui-button-text").html());if(!this.hasTitle){this.buttonElement.removeAttr("title");}},_setOption:function(key,value){this._super(key,value);if(key==="disabled"){if(value){this.element.prop("disabled",true);}else{this.element.prop("disabled",false);}
return;}
this._resetButton();},refresh:function(){var isDisabled=this.element.is("input, button")?this.element.is(":disabled"):this.element.hasClass("ui-button-disabled");if(isDisabled!==this.options.disabled){this._setOption("disabled",isDisabled);}
if(this.type==="radio"){radioGroup(this.element[0]).each(function(){if($(this).is(":checked")){$(this).button("widget").addClass("ui-state-active").attr("aria-pressed","true");}else{$(this).button("widget").removeClass("ui-state-active").attr("aria-pressed","false");}});}else if(this.type==="checkbox"){if(this.element.is(":checked")){this.buttonElement.addClass("ui-state-active").attr("aria-pressed","true");}else{this.buttonElement.removeClass("ui-state-active").attr("aria-pressed","false");}}},_resetButton:function(){if(this.type==="input"){if(this.options.label){this.element.val(this.options.label);}
return;}
var buttonElement=this.buttonElement.removeClass(typeClasses),buttonText=$("<span></span>",this.document[0]).addClass("ui-button-text").html(this.options.label).appendTo(buttonElement.empty()).text(),icons=this.options.icons,multipleIcons=icons.primary&&icons.secondary,buttonClasses=[];if(icons.primary||icons.secondary){if(this.options.text){buttonClasses.push("ui-button-text-icon"+(multipleIcons?"s":(icons.primary?"-primary":"-secondary")));}
if(icons.primary){buttonElement.prepend("<span class='ui-button-icon-primary ui-icon "+icons.primary+"'></span>");}
if(icons.secondary){buttonElement.append("<span class='ui-button-icon-secondary ui-icon "+icons.secondary+"'></span>");}
if(!this.options.text){buttonClasses.push(multipleIcons?"ui-button-icons-only":"ui-button-icon-only");if(!this.hasTitle){buttonElement.attr("title",$.trim(buttonText));}}}else{buttonClasses.push("ui-button-text-only");}
buttonElement.addClass(buttonClasses.join(" "));}});$.widget("ui.buttonset",{version:"1.9.2",options:{items:"button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(button)"},_create:function(){this.element.addClass("ui-buttonset");},_init:function(){this.refresh();},_setOption:function(key,value){if(key==="disabled"){this.buttons.button("option",key,value);}
this._super(key,value);},refresh:function(){var rtl=this.element.css("direction")==="rtl";this.buttons=this.element.find(this.options.items).filter(":ui-button").button("refresh").end().not(":ui-button").button().end().map(function(){return $(this).button("widget")[0];}).removeClass("ui-corner-all ui-corner-left ui-corner-right").filter(":first").addClass(rtl?"ui-corner-right":"ui-corner-left").end().filter(":last").addClass(rtl?"ui-corner-left":"ui-corner-right").end().end();},_destroy:function(){this.element.removeClass("ui-buttonset");this.buttons.map(function(){return $(this).button("widget")[0];}).removeClass("ui-corner-left ui-corner-right").end().button("destroy");}});}(jQuery));(function($,undefined){$.extend($.ui,{datepicker:{version:"1.9.2"}});var PROP_NAME='datepicker';var dpuuid=new Date().getTime();var instActive;function Datepicker(){this.debug=false;this._curInst=null;this._keyEvent=false;this._disabledInputs=[];this._datepickerShowing=false;this._inDialog=false;this._mainDivId='ui-datepicker-div';this._inlineClass='ui-datepicker-inline';this._appendClass='ui-datepicker-append';this._triggerClass='ui-datepicker-trigger';this._dialogClass='ui-datepicker-dialog';this._disableClass='ui-datepicker-disabled';this._unselectableClass='ui-datepicker-unselectable';this._currentClass='ui-datepicker-current-day';this._dayOverClass='ui-datepicker-days-cell-over';this.regional=[];this.regional['']={closeText:'Done',prevText:'Prev',nextText:'Next',currentText:'Today',monthNames:['January','February','March','April','May','June','July','August','September','October','November','December'],monthNamesShort:['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],dayNames:['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'],dayNamesShort:['Sun','Mon','Tue','Wed','Thu','Fri','Sat'],dayNamesMin:['Su','Mo','Tu','We','Th','Fr','Sa'],weekHeader:'Wk',dateFormat:'mm/dd/yy',firstDay:0,isRTL:false,showMonthAfterYear:false,yearSuffix:''};this._defaults={showOn:'focus',showAnim:'fadeIn',showOptions:{},defaultDate:null,appendText:'',buttonText:'...',buttonImage:'',buttonImageOnly:false,hideIfNoPrevNext:false,navigationAsDateFormat:false,gotoCurrent:false,changeMonth:false,changeYear:false,yearRange:'c-10:c+10',showOtherMonths:false,selectOtherMonths:false,showWeek:false,calculateWeek:this.iso8601Week,shortYearCutoff:'+10',minDate:null,maxDate:null,duration:'fast',beforeShowDay:null,beforeShow:null,onSelect:null,onChangeMonthYear:null,onClose:null,numberOfMonths:1,showCurrentAtPos:0,stepMonths:1,stepBigMonths:12,altField:'',altFormat:'',constrainInput:true,showButtonPanel:false,autoSize:false,disabled:false};$.extend(this._defaults,this.regional['']);this.dpDiv=bindHover($('<div id="'+this._mainDivId+'" class="ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all"></div>'));}
$.extend(Datepicker.prototype,{markerClassName:'hasDatepicker',maxRows:4,log:function(){if(this.debug)
console.log.apply('',arguments);},_widgetDatepicker:function(){return this.dpDiv;},setDefaults:function(settings){extendRemove(this._defaults,settings||{});return this;},_attachDatepicker:function(target,settings){var inlineSettings=null;for(var attrName in this._defaults){var attrValue=target.getAttribute('date:'+attrName);if(attrValue){inlineSettings=inlineSettings||{};try{inlineSettings[attrName]=eval(attrValue);}catch(err){inlineSettings[attrName]=attrValue;}}}
var nodeName=target.nodeName.toLowerCase();var inline=(nodeName=='div'||nodeName=='span');if(!target.id){this.uuid+=1;target.id='dp'+this.uuid;}
var inst=this._newInst($(target),inline);inst.settings=$.extend({},settings||{},inlineSettings||{});if(nodeName=='input'){this._connectDatepicker(target,inst);}else if(inline){this._inlineDatepicker(target,inst);}},_newInst:function(target,inline){var id=target[0].id.replace(/([^A-Za-z0-9_-])/g,'\\\\$1');return{id:id,input:target,selectedDay:0,selectedMonth:0,selectedYear:0,drawMonth:0,drawYear:0,inline:inline,dpDiv:(!inline?this.dpDiv:bindHover($('<div class="'+this._inlineClass+' ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all"></div>')))};},_connectDatepicker:function(target,inst){var input=$(target);inst.append=$([]);inst.trigger=$([]);if(input.hasClass(this.markerClassName))
return;this._attachments(input,inst);input.addClass(this.markerClassName).keydown(this._doKeyDown).keypress(this._doKeyPress).keyup(this._doKeyUp).bind("setData.datepicker",function(event,key,value){inst.settings[key]=value;}).bind("getData.datepicker",function(event,key){return this._get(inst,key);});this._autoSize(inst);$.data(target,PROP_NAME,inst);if(inst.settings.disabled){this._disableDatepicker(target);}},_attachments:function(input,inst){var appendText=this._get(inst,'appendText');var isRTL=this._get(inst,'isRTL');if(inst.append)
inst.append.remove();if(appendText){inst.append=$('<span class="'+this._appendClass+'">'+appendText+'</span>');input[isRTL?'before':'after'](inst.append);}
input.unbind('focus',this._showDatepicker);if(inst.trigger)
inst.trigger.remove();var showOn=this._get(inst,'showOn');if(showOn=='focus'||showOn=='both')
input.focus(this._showDatepicker);if(showOn=='button'||showOn=='both'){var buttonText=this._get(inst,'buttonText');var buttonImage=this._get(inst,'buttonImage');inst.trigger=$(this._get(inst,'buttonImageOnly')?$('<img/>').addClass(this._triggerClass).attr({src:buttonImage,alt:buttonText,title:buttonText}):$('<button type="button"></button>').addClass(this._triggerClass).html(buttonImage==''?buttonText:$('<img/>').attr({src:buttonImage,alt:buttonText,title:buttonText})));input[isRTL?'before':'after'](inst.trigger);inst.trigger.click(function(){if($.datepicker._datepickerShowing&&$.datepicker._lastInput==input[0])
$.datepicker._hideDatepicker();else if($.datepicker._datepickerShowing&&$.datepicker._lastInput!=input[0]){$.datepicker._hideDatepicker();$.datepicker._showDatepicker(input[0]);}else
$.datepicker._showDatepicker(input[0]);return false;});}},_autoSize:function(inst){if(this._get(inst,'autoSize')&&!inst.inline){var date=new Date(2009,12-1,20);var dateFormat=this._get(inst,'dateFormat');if(dateFormat.match(/[DM]/)){var findMax=function(names){var max=0;var maxI=0;for(var i=0;i<names.length;i++){if(names[i].length>max){max=names[i].length;maxI=i;}}
return maxI;};date.setMonth(findMax(this._get(inst,(dateFormat.match(/MM/)?'monthNames':'monthNamesShort'))));date.setDate(findMax(this._get(inst,(dateFormat.match(/DD/)?'dayNames':'dayNamesShort')))+20-date.getDay());}
inst.input.attr('size',this._formatDate(inst,date).length);}},_inlineDatepicker:function(target,inst){var divSpan=$(target);if(divSpan.hasClass(this.markerClassName))
return;divSpan.addClass(this.markerClassName).append(inst.dpDiv).bind("setData.datepicker",function(event,key,value){inst.settings[key]=value;}).bind("getData.datepicker",function(event,key){return this._get(inst,key);});$.data(target,PROP_NAME,inst);this._setDate(inst,this._getDefaultDate(inst),true);this._updateDatepicker(inst);this._updateAlternate(inst);if(inst.settings.disabled){this._disableDatepicker(target);}
inst.dpDiv.css("display","block");},_dialogDatepicker:function(input,date,onSelect,settings,pos){var inst=this._dialogInst;if(!inst){this.uuid+=1;var id='dp'+this.uuid;this._dialogInput=$('<input type="text" id="'+id+'" style="position: absolute; top: -100px; width: 0px;"/>');this._dialogInput.keydown(this._doKeyDown);$('body').append(this._dialogInput);inst=this._dialogInst=this._newInst(this._dialogInput,false);inst.settings={};$.data(this._dialogInput[0],PROP_NAME,inst);}
extendRemove(inst.settings,settings||{});date=(date&&date.constructor==Date?this._formatDate(inst,date):date);this._dialogInput.val(date);this._pos=(pos?(pos.length?pos:[pos.pageX,pos.pageY]):null);if(!this._pos){var browserWidth=document.documentElement.clientWidth;var browserHeight=document.documentElement.clientHeight;var scrollX=document.documentElement.scrollLeft||document.body.scrollLeft;var scrollY=document.documentElement.scrollTop||document.body.scrollTop;this._pos=[(browserWidth/2)-100+scrollX,(browserHeight/2)-150+scrollY];}
this._dialogInput.css('left',(this._pos[0]+20)+'px').css('top',this._pos[1]+'px');inst.settings.onSelect=onSelect;this._inDialog=true;this.dpDiv.addClass(this._dialogClass);this._showDatepicker(this._dialogInput[0]);if($.blockUI)
$.blockUI(this.dpDiv);$.data(this._dialogInput[0],PROP_NAME,inst);return this;},_destroyDatepicker:function(target){var $target=$(target);var inst=$.data(target,PROP_NAME);if(!$target.hasClass(this.markerClassName)){return;}
var nodeName=target.nodeName.toLowerCase();$.removeData(target,PROP_NAME);if(nodeName=='input'){inst.append.remove();inst.trigger.remove();$target.removeClass(this.markerClassName).unbind('focus',this._showDatepicker).unbind('keydown',this._doKeyDown).unbind('keypress',this._doKeyPress).unbind('keyup',this._doKeyUp);}else if(nodeName=='div'||nodeName=='span')
$target.removeClass(this.markerClassName).empty();},_enableDatepicker:function(target){var $target=$(target);var inst=$.data(target,PROP_NAME);if(!$target.hasClass(this.markerClassName)){return;}
var nodeName=target.nodeName.toLowerCase();if(nodeName=='input'){target.disabled=false;inst.trigger.filter('button').each(function(){this.disabled=false;}).end().filter('img').css({opacity:'1.0',cursor:''});}
else if(nodeName=='div'||nodeName=='span'){var inline=$target.children('.'+this._inlineClass);inline.children().removeClass('ui-state-disabled');inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",false);}
this._disabledInputs=$.map(this._disabledInputs,function(value){return(value==target?null:value);});},_disableDatepicker:function(target){var $target=$(target);var inst=$.data(target,PROP_NAME);if(!$target.hasClass(this.markerClassName)){return;}
var nodeName=target.nodeName.toLowerCase();if(nodeName=='input'){target.disabled=true;inst.trigger.filter('button').each(function(){this.disabled=true;}).end().filter('img').css({opacity:'0.5',cursor:'default'});}
else if(nodeName=='div'||nodeName=='span'){var inline=$target.children('.'+this._inlineClass);inline.children().addClass('ui-state-disabled');inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",true);}
this._disabledInputs=$.map(this._disabledInputs,function(value){return(value==target?null:value);});this._disabledInputs[this._disabledInputs.length]=target;},_isDisabledDatepicker:function(target){if(!target){return false;}
for(var i=0;i<this._disabledInputs.length;i++){if(this._disabledInputs[i]==target)
return true;}
return false;},_getInst:function(target){try{return $.data(target,PROP_NAME);}
catch(err){throw'Missing instance data for this datepicker';}},_optionDatepicker:function(target,name,value){var inst=this._getInst(target);if(arguments.length==2&&typeof name=='string'){return(name=='defaults'?$.extend({},$.datepicker._defaults):(inst?(name=='all'?$.extend({},inst.settings):this._get(inst,name)):null));}
var settings=name||{};if(typeof name=='string'){settings={};settings[name]=value;}
if(inst){if(this._curInst==inst){this._hideDatepicker();}
var date=this._getDateDatepicker(target,true);var minDate=this._getMinMaxDate(inst,'min');var maxDate=this._getMinMaxDate(inst,'max');extendRemove(inst.settings,settings);if(minDate!==null&&settings['dateFormat']!==undefined&&settings['minDate']===undefined)
inst.settings.minDate=this._formatDate(inst,minDate);if(maxDate!==null&&settings['dateFormat']!==undefined&&settings['maxDate']===undefined)
inst.settings.maxDate=this._formatDate(inst,maxDate);this._attachments($(target),inst);this._autoSize(inst);this._setDate(inst,date);this._updateAlternate(inst);this._updateDatepicker(inst);}},_changeDatepicker:function(target,name,value){this._optionDatepicker(target,name,value);},_refreshDatepicker:function(target){var inst=this._getInst(target);if(inst){this._updateDatepicker(inst);}},_setDateDatepicker:function(target,date){var inst=this._getInst(target);if(inst){this._setDate(inst,date);this._updateDatepicker(inst);this._updateAlternate(inst);}},_getDateDatepicker:function(target,noDefault){var inst=this._getInst(target);if(inst&&!inst.inline)
this._setDateFromField(inst,noDefault);return(inst?this._getDate(inst):null);},_doKeyDown:function(event){var inst=$.datepicker._getInst(event.target);var handled=true;var isRTL=inst.dpDiv.is('.ui-datepicker-rtl');inst._keyEvent=true;if($.datepicker._datepickerShowing)
switch(event.keyCode){case 9:$.datepicker._hideDatepicker();handled=false;break;case 13:var sel=$('td.'+$.datepicker._dayOverClass+':not(.'+
$.datepicker._currentClass+')',inst.dpDiv);if(sel[0])
$.datepicker._selectDay(event.target,inst.selectedMonth,inst.selectedYear,sel[0]);var onSelect=$.datepicker._get(inst,'onSelect');if(onSelect){var dateStr=$.datepicker._formatDate(inst);onSelect.apply((inst.input?inst.input[0]:null),[dateStr,inst]);}
else
$.datepicker._hideDatepicker();return false;break;case 27:$.datepicker._hideDatepicker();break;case 33:$.datepicker._adjustDate(event.target,(event.ctrlKey?-$.datepicker._get(inst,'stepBigMonths'):-$.datepicker._get(inst,'stepMonths')),'M');break;case 34:$.datepicker._adjustDate(event.target,(event.ctrlKey?+$.datepicker._get(inst,'stepBigMonths'):+$.datepicker._get(inst,'stepMonths')),'M');break;case 35:if(event.ctrlKey||event.metaKey)$.datepicker._clearDate(event.target);handled=event.ctrlKey||event.metaKey;break;case 36:if(event.ctrlKey||event.metaKey)$.datepicker._gotoToday(event.target);handled=event.ctrlKey||event.metaKey;break;case 37:if(event.ctrlKey||event.metaKey)$.datepicker._adjustDate(event.target,(isRTL?+1:-1),'D');handled=event.ctrlKey||event.metaKey;if(event.originalEvent.altKey)$.datepicker._adjustDate(event.target,(event.ctrlKey?-$.datepicker._get(inst,'stepBigMonths'):-$.datepicker._get(inst,'stepMonths')),'M');break;case 38:if(event.ctrlKey||event.metaKey)$.datepicker._adjustDate(event.target,-7,'D');handled=event.ctrlKey||event.metaKey;break;case 39:if(event.ctrlKey||event.metaKey)$.datepicker._adjustDate(event.target,(isRTL?-1:+1),'D');handled=event.ctrlKey||event.metaKey;if(event.originalEvent.altKey)$.datepicker._adjustDate(event.target,(event.ctrlKey?+$.datepicker._get(inst,'stepBigMonths'):+$.datepicker._get(inst,'stepMonths')),'M');break;case 40:if(event.ctrlKey||event.metaKey)$.datepicker._adjustDate(event.target,+7,'D');handled=event.ctrlKey||event.metaKey;break;default:handled=false;}
else if(event.keyCode==36&&event.ctrlKey)
$.datepicker._showDatepicker(this);else{handled=false;}
if(handled){event.preventDefault();event.stopPropagation();}},_doKeyPress:function(event){var inst=$.datepicker._getInst(event.target);if($.datepicker._get(inst,'constrainInput')){var chars=$.datepicker._possibleChars($.datepicker._get(inst,'dateFormat'));var chr=String.fromCharCode(event.charCode==undefined?event.keyCode:event.charCode);return event.ctrlKey||event.metaKey||(chr<' '||!chars||chars.indexOf(chr)>-1);}},_doKeyUp:function(event){var inst=$.datepicker._getInst(event.target);if(inst.input.val()!=inst.lastVal){try{var date=$.datepicker.parseDate($.datepicker._get(inst,'dateFormat'),(inst.input?inst.input.val():null),$.datepicker._getFormatConfig(inst));if(date){$.datepicker._setDateFromField(inst);$.datepicker._updateAlternate(inst);$.datepicker._updateDatepicker(inst);}}
catch(err){$.datepicker.log(err);}}
return true;},_showDatepicker:function(input){input=input.target||input;if(input.nodeName.toLowerCase()!='input')
input=$('input',input.parentNode)[0];if($.datepicker._isDisabledDatepicker(input)||$.datepicker._lastInput==input)
return;var inst=$.datepicker._getInst(input);if($.datepicker._curInst&&$.datepicker._curInst!=inst){$.datepicker._curInst.dpDiv.stop(true,true);if(inst&&$.datepicker._datepickerShowing){$.datepicker._hideDatepicker($.datepicker._curInst.input[0]);}}
var beforeShow=$.datepicker._get(inst,'beforeShow');var beforeShowSettings=beforeShow?beforeShow.apply(input,[input,inst]):{};if(beforeShowSettings===false){return;}
extendRemove(inst.settings,beforeShowSettings);inst.lastVal=null;$.datepicker._lastInput=input;$.datepicker._setDateFromField(inst);if($.datepicker._inDialog)
input.value='';if(!$.datepicker._pos){$.datepicker._pos=$.datepicker._findPos(input);$.datepicker._pos[1]+=input.offsetHeight;}
var isFixed=false;$(input).parents().each(function(){isFixed|=$(this).css('position')=='fixed';return!isFixed;});var offset={left:$.datepicker._pos[0],top:$.datepicker._pos[1]};$.datepicker._pos=null;inst.dpDiv.empty();inst.dpDiv.css({position:'absolute',display:'block',top:'-1000px'});$.datepicker._updateDatepicker(inst);offset=$.datepicker._checkOffset(inst,offset,isFixed);inst.dpDiv.css({position:($.datepicker._inDialog&&$.blockUI?'static':(isFixed?'fixed':'absolute')),display:'none',left:offset.left+'px',top:offset.top+'px'});if(!inst.inline){var showAnim=$.datepicker._get(inst,'showAnim');var duration=$.datepicker._get(inst,'duration');var postProcess=function(){var cover=inst.dpDiv.find('iframe.ui-datepicker-cover');if(!!cover.length){var borders=$.datepicker._getBorders(inst.dpDiv);cover.css({left:-borders[0],top:-borders[1],width:inst.dpDiv.outerWidth(),height:inst.dpDiv.outerHeight()});}};inst.dpDiv.zIndex($(input).zIndex()+1);$.datepicker._datepickerShowing=true;if($.effects&&($.effects.effect[showAnim]||$.effects[showAnim]))
inst.dpDiv.show(showAnim,$.datepicker._get(inst,'showOptions'),duration,postProcess);else
inst.dpDiv[showAnim||'show']((showAnim?duration:null),postProcess);if(!showAnim||!duration)
postProcess();if(inst.input.is(':visible')&&!inst.input.is(':disabled'))
inst.input.focus();$.datepicker._curInst=inst;}},_updateDatepicker:function(inst){this.maxRows=4;var borders=$.datepicker._getBorders(inst.dpDiv);instActive=inst;inst.dpDiv.empty().append(this._generateHTML(inst));this._attachHandlers(inst);var cover=inst.dpDiv.find('iframe.ui-datepicker-cover');if(!!cover.length){cover.css({left:-borders[0],top:-borders[1],width:inst.dpDiv.outerWidth(),height:inst.dpDiv.outerHeight()})}
inst.dpDiv.find('.'+this._dayOverClass+' a').mouseover();var numMonths=this._getNumberOfMonths(inst);var cols=numMonths[1];var width=17;inst.dpDiv.removeClass('ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4').width('');if(cols>1)
inst.dpDiv.addClass('ui-datepicker-multi-'+cols).css('width',(width*cols)+'em');inst.dpDiv[(numMonths[0]!=1||numMonths[1]!=1?'add':'remove')+'Class']('ui-datepicker-multi');inst.dpDiv[(this._get(inst,'isRTL')?'add':'remove')+'Class']('ui-datepicker-rtl');if(inst==$.datepicker._curInst&&$.datepicker._datepickerShowing&&inst.input&&inst.input.is(':visible')&&!inst.input.is(':disabled')&&inst.input[0]!=document.activeElement)
inst.input.focus();if(inst.yearshtml){var origyearshtml=inst.yearshtml;setTimeout(function(){if(origyearshtml===inst.yearshtml&&inst.yearshtml){inst.dpDiv.find('select.ui-datepicker-year:first').replaceWith(inst.yearshtml);}
origyearshtml=inst.yearshtml=null;},0);}},_getBorders:function(elem){var convert=function(value){return{thin:1,medium:2,thick:3}[value]||value;};return[parseFloat(convert(elem.css('border-left-width'))),parseFloat(convert(elem.css('border-top-width')))];},_checkOffset:function(inst,offset,isFixed){var dpWidth=inst.dpDiv.outerWidth();var dpHeight=inst.dpDiv.outerHeight();var inputWidth=inst.input?inst.input.outerWidth():0;var inputHeight=inst.input?inst.input.outerHeight():0;var viewWidth=document.documentElement.clientWidth+(isFixed?0:$(document).scrollLeft());var viewHeight=document.documentElement.clientHeight+(isFixed?0:$(document).scrollTop());offset.left-=(this._get(inst,'isRTL')?(dpWidth-inputWidth):0);offset.left-=(isFixed&&offset.left==inst.input.offset().left)?$(document).scrollLeft():0;offset.top-=(isFixed&&offset.top==(inst.input.offset().top+inputHeight))?$(document).scrollTop():0;offset.left-=Math.min(offset.left,(offset.left+dpWidth>viewWidth&&viewWidth>dpWidth)?Math.abs(offset.left+dpWidth-viewWidth):0);offset.top-=Math.min(offset.top,(offset.top+dpHeight>viewHeight&&viewHeight>dpHeight)?Math.abs(dpHeight+inputHeight):0);return offset;},_findPos:function(obj){var inst=this._getInst(obj);var isRTL=this._get(inst,'isRTL');while(obj&&(obj.type=='hidden'||obj.nodeType!=1||$.expr.filters.hidden(obj))){obj=obj[isRTL?'previousSibling':'nextSibling'];}
var position=$(obj).offset();return[position.left,position.top];},_hideDatepicker:function(input){var inst=this._curInst;if(!inst||(input&&inst!=$.data(input,PROP_NAME)))
return;if(this._datepickerShowing){var showAnim=this._get(inst,'showAnim');var duration=this._get(inst,'duration');var postProcess=function(){$.datepicker._tidyDialog(inst);};if($.effects&&($.effects.effect[showAnim]||$.effects[showAnim]))
inst.dpDiv.hide(showAnim,$.datepicker._get(inst,'showOptions'),duration,postProcess);else
inst.dpDiv[(showAnim=='slideDown'?'slideUp':(showAnim=='fadeIn'?'fadeOut':'hide'))]((showAnim?duration:null),postProcess);if(!showAnim)
postProcess();this._datepickerShowing=false;var onClose=this._get(inst,'onClose');if(onClose)
onClose.apply((inst.input?inst.input[0]:null),[(inst.input?inst.input.val():''),inst]);this._lastInput=null;if(this._inDialog){this._dialogInput.css({position:'absolute',left:'0',top:'-100px'});if($.blockUI){$.unblockUI();$('body').append(this.dpDiv);}}
this._inDialog=false;}},_tidyDialog:function(inst){inst.dpDiv.removeClass(this._dialogClass).unbind('.ui-datepicker-calendar');},_checkExternalClick:function(event){if(!$.datepicker._curInst)
return;var $target=$(event.target),inst=$.datepicker._getInst($target[0]);if((($target[0].id!=$.datepicker._mainDivId&&$target.parents('#'+$.datepicker._mainDivId).length==0&&!$target.hasClass($.datepicker.markerClassName)&&!$target.closest("."+$.datepicker._triggerClass).length&&$.datepicker._datepickerShowing&&!($.datepicker._inDialog&&$.blockUI)))||($target.hasClass($.datepicker.markerClassName)&&$.datepicker._curInst!=inst))
$.datepicker._hideDatepicker();},_adjustDate:function(id,offset,period){var target=$(id);var inst=this._getInst(target[0]);if(this._isDisabledDatepicker(target[0])){return;}
this._adjustInstDate(inst,offset+
(period=='M'?this._get(inst,'showCurrentAtPos'):0),period);this._updateDatepicker(inst);},_gotoToday:function(id){var target=$(id);var inst=this._getInst(target[0]);if(this._get(inst,'gotoCurrent')&&inst.currentDay){inst.selectedDay=inst.currentDay;inst.drawMonth=inst.selectedMonth=inst.currentMonth;inst.drawYear=inst.selectedYear=inst.currentYear;}
else{var date=new Date();inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();}
this._notifyChange(inst);this._adjustDate(target);},_selectMonthYear:function(id,select,period){var target=$(id);var inst=this._getInst(target[0]);inst['selected'+(period=='M'?'Month':'Year')]=inst['draw'+(period=='M'?'Month':'Year')]=parseInt(select.options[select.selectedIndex].value,10);this._notifyChange(inst);this._adjustDate(target);},_selectDay:function(id,month,year,td){var target=$(id);if($(td).hasClass(this._unselectableClass)||this._isDisabledDatepicker(target[0])){return;}
var inst=this._getInst(target[0]);inst.selectedDay=inst.currentDay=$('a',td).html();inst.selectedMonth=inst.currentMonth=month;inst.selectedYear=inst.currentYear=year;this._selectDate(id,this._formatDate(inst,inst.currentDay,inst.currentMonth,inst.currentYear));},_clearDate:function(id){var target=$(id);var inst=this._getInst(target[0]);this._selectDate(target,'');},_selectDate:function(id,dateStr){var target=$(id);var inst=this._getInst(target[0]);dateStr=(dateStr!=null?dateStr:this._formatDate(inst));if(inst.input)
inst.input.val(dateStr);this._updateAlternate(inst);var onSelect=this._get(inst,'onSelect');if(onSelect)
onSelect.apply((inst.input?inst.input[0]:null),[dateStr,inst]);else if(inst.input)
inst.input.trigger('change');if(inst.inline)
this._updateDatepicker(inst);else{this._hideDatepicker();this._lastInput=inst.input[0];if(typeof(inst.input[0])!='object')
inst.input.focus();this._lastInput=null;}},_updateAlternate:function(inst){var altField=this._get(inst,'altField');if(altField){var altFormat=this._get(inst,'altFormat')||this._get(inst,'dateFormat');var date=this._getDate(inst);var dateStr=this.formatDate(altFormat,date,this._getFormatConfig(inst));$(altField).each(function(){$(this).val(dateStr);});}},noWeekends:function(date){var day=date.getDay();return[(day>0&&day<6),''];},iso8601Week:function(date){var checkDate=new Date(date.getTime());checkDate.setDate(checkDate.getDate()+4-(checkDate.getDay()||7));var time=checkDate.getTime();checkDate.setMonth(0);checkDate.setDate(1);return Math.floor(Math.round((time-checkDate)/86400000)/7)+1;},parseDate:function(format,value,settings){if(format==null||value==null)
throw'Invalid arguments';value=(typeof value=='object'?value.toString():value+'');if(value=='')
return null;var shortYearCutoff=(settings?settings.shortYearCutoff:null)||this._defaults.shortYearCutoff;shortYearCutoff=(typeof shortYearCutoff!='string'?shortYearCutoff:new Date().getFullYear()%100+parseInt(shortYearCutoff,10));var dayNamesShort=(settings?settings.dayNamesShort:null)||this._defaults.dayNamesShort;var dayNames=(settings?settings.dayNames:null)||this._defaults.dayNames;var monthNamesShort=(settings?settings.monthNamesShort:null)||this._defaults.monthNamesShort;var monthNames=(settings?settings.monthNames:null)||this._defaults.monthNames;var year=-1;var month=-1;var day=-1;var doy=-1;var literal=false;var lookAhead=function(match){var matches=(iFormat+1<format.length&&format.charAt(iFormat+1)==match);if(matches)
iFormat++;return matches;};var getNumber=function(match){var isDoubled=lookAhead(match);var size=(match=='@'?14:(match=='!'?20:(match=='y'&&isDoubled?4:(match=='o'?3:2))));var digits=new RegExp('^\\d{1,'+size+'}');var num=value.substring(iValue).match(digits);if(!num)
throw'Missing number at position '+iValue;iValue+=num[0].length;return parseInt(num[0],10);};var getName=function(match,shortNames,longNames){var names=$.map(lookAhead(match)?longNames:shortNames,function(v,k){return[[k,v]];}).sort(function(a,b){return-(a[1].length-b[1].length);});var index=-1;$.each(names,function(i,pair){var name=pair[1];if(value.substr(iValue,name.length).toLowerCase()==name.toLowerCase()){index=pair[0];iValue+=name.length;return false;}});if(index!=-1)
return index+1;else
throw'Unknown name at position '+iValue;};var checkLiteral=function(){if(value.charAt(iValue)!=format.charAt(iFormat))
throw'Unexpected literal at position '+iValue;iValue++;};var iValue=0;for(var iFormat=0;iFormat<format.length;iFormat++){if(literal)
if(format.charAt(iFormat)=="'"&&!lookAhead("'"))
literal=false;else
checkLiteral();else
switch(format.charAt(iFormat)){case'd':day=getNumber('d');break;case'D':getName('D',dayNamesShort,dayNames);break;case'o':doy=getNumber('o');break;case'm':month=getNumber('m');break;case'M':month=getName('M',monthNamesShort,monthNames);break;case'y':year=getNumber('y');break;case'@':var date=new Date(getNumber('@'));year=date.getFullYear();month=date.getMonth()+1;day=date.getDate();break;case'!':var date=new Date((getNumber('!')-this._ticksTo1970)/10000);year=date.getFullYear();month=date.getMonth()+1;day=date.getDate();break;case"'":if(lookAhead("'"))
checkLiteral();else
literal=true;break;default:checkLiteral();}}
if(iValue<value.length){var extra=value.substr(iValue);if(!/^\s+/.test(extra)){throw"Extra/unparsed characters found in date: "+extra;}}
if(year==-1)
year=new Date().getFullYear();else if(year<100)
year+=new Date().getFullYear()-new Date().getFullYear()%100+
(year<=shortYearCutoff?0:-100);if(doy>-1){month=1;day=doy;do{var dim=this._getDaysInMonth(year,month-1);if(day<=dim)
break;month++;day-=dim;}while(true);}
var date=this._daylightSavingAdjust(new Date(year,month-1,day));if(date.getFullYear()!=year||date.getMonth()+1!=month||date.getDate()!=day)
throw'Invalid date';return date;},ATOM:'yy-mm-dd',COOKIE:'D, dd M yy',ISO_8601:'yy-mm-dd',RFC_822:'D, d M y',RFC_850:'DD, dd-M-y',RFC_1036:'D, d M y',RFC_1123:'D, d M yy',RFC_2822:'D, d M yy',RSS:'D, d M y',TICKS:'!',TIMESTAMP:'@',W3C:'yy-mm-dd',_ticksTo1970:(((1970-1)*365+Math.floor(1970/4)-Math.floor(1970/100)+
Math.floor(1970/400))*24*60*60*10000000),formatDate:function(format,date,settings){if(!date)
return'';var dayNamesShort=(settings?settings.dayNamesShort:null)||this._defaults.dayNamesShort;var dayNames=(settings?settings.dayNames:null)||this._defaults.dayNames;var monthNamesShort=(settings?settings.monthNamesShort:null)||this._defaults.monthNamesShort;var monthNames=(settings?settings.monthNames:null)||this._defaults.monthNames;var lookAhead=function(match){var matches=(iFormat+1<format.length&&format.charAt(iFormat+1)==match);if(matches)
iFormat++;return matches;};var formatNumber=function(match,value,len){var num=''+value;if(lookAhead(match))
while(num.length<len)
num='0'+num;return num;};var formatName=function(match,value,shortNames,longNames){return(lookAhead(match)?longNames[value]:shortNames[value]);};var output='';var literal=false;if(date)
for(var iFormat=0;iFormat<format.length;iFormat++){if(literal)
if(format.charAt(iFormat)=="'"&&!lookAhead("'"))
literal=false;else
output+=format.charAt(iFormat);else
switch(format.charAt(iFormat)){case'd':output+=formatNumber('d',date.getDate(),2);break;case'D':output+=formatName('D',date.getDay(),dayNamesShort,dayNames);break;case'o':output+=formatNumber('o',Math.round((new Date(date.getFullYear(),date.getMonth(),date.getDate()).getTime()-new Date(date.getFullYear(),0,0).getTime())/86400000),3);break;case'm':output+=formatNumber('m',date.getMonth()+1,2);break;case'M':output+=formatName('M',date.getMonth(),monthNamesShort,monthNames);break;case'y':output+=(lookAhead('y')?date.getFullYear():(date.getYear()%100<10?'0':'')+date.getYear()%100);break;case'@':output+=date.getTime();break;case'!':output+=date.getTime()*10000+this._ticksTo1970;break;case"'":if(lookAhead("'"))
output+="'";else
literal=true;break;default:output+=format.charAt(iFormat);}}
return output;},_possibleChars:function(format){var chars='';var literal=false;var lookAhead=function(match){var matches=(iFormat+1<format.length&&format.charAt(iFormat+1)==match);if(matches)
iFormat++;return matches;};for(var iFormat=0;iFormat<format.length;iFormat++)
if(literal)
if(format.charAt(iFormat)=="'"&&!lookAhead("'"))
literal=false;else
chars+=format.charAt(iFormat);else
switch(format.charAt(iFormat)){case'd':case'm':case'y':case'@':chars+='0123456789';break;case'D':case'M':return null;case"'":if(lookAhead("'"))
chars+="'";else
literal=true;break;default:chars+=format.charAt(iFormat);}
return chars;},_get:function(inst,name){return inst.settings[name]!==undefined?inst.settings[name]:this._defaults[name];},_setDateFromField:function(inst,noDefault){if(inst.input.val()==inst.lastVal){return;}
var dateFormat=this._get(inst,'dateFormat');var dates=inst.lastVal=inst.input?inst.input.val():null;var date,defaultDate;date=defaultDate=this._getDefaultDate(inst);var settings=this._getFormatConfig(inst);try{date=this.parseDate(dateFormat,dates,settings)||defaultDate;}catch(event){this.log(event);dates=(noDefault?'':dates);}
inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();inst.currentDay=(dates?date.getDate():0);inst.currentMonth=(dates?date.getMonth():0);inst.currentYear=(dates?date.getFullYear():0);this._adjustInstDate(inst);},_getDefaultDate:function(inst){return this._restrictMinMax(inst,this._determineDate(inst,this._get(inst,'defaultDate'),new Date()));},_determineDate:function(inst,date,defaultDate){var offsetNumeric=function(offset){var date=new Date();date.setDate(date.getDate()+offset);return date;};var offsetString=function(offset){try{return $.datepicker.parseDate($.datepicker._get(inst,'dateFormat'),offset,$.datepicker._getFormatConfig(inst));}
catch(e){}
var date=(offset.toLowerCase().match(/^c/)?$.datepicker._getDate(inst):null)||new Date();var year=date.getFullYear();var month=date.getMonth();var day=date.getDate();var pattern=/([+-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g;var matches=pattern.exec(offset);while(matches){switch(matches[2]||'d'){case'd':case'D':day+=parseInt(matches[1],10);break;case'w':case'W':day+=parseInt(matches[1],10)*7;break;case'm':case'M':month+=parseInt(matches[1],10);day=Math.min(day,$.datepicker._getDaysInMonth(year,month));break;case'y':case'Y':year+=parseInt(matches[1],10);day=Math.min(day,$.datepicker._getDaysInMonth(year,month));break;}
matches=pattern.exec(offset);}
return new Date(year,month,day);};var newDate=(date==null||date===''?defaultDate:(typeof date=='string'?offsetString(date):(typeof date=='number'?(isNaN(date)?defaultDate:offsetNumeric(date)):new Date(date.getTime()))));newDate=(newDate&&newDate.toString()=='Invalid Date'?defaultDate:newDate);if(newDate){newDate.setHours(0);newDate.setMinutes(0);newDate.setSeconds(0);newDate.setMilliseconds(0);}
return this._daylightSavingAdjust(newDate);},_daylightSavingAdjust:function(date){if(!date)return null;date.setHours(date.getHours()>12?date.getHours()+2:0);return date;},_setDate:function(inst,date,noChange){var clear=!date;var origMonth=inst.selectedMonth;var origYear=inst.selectedYear;var newDate=this._restrictMinMax(inst,this._determineDate(inst,date,new Date()));inst.selectedDay=inst.currentDay=newDate.getDate();inst.drawMonth=inst.selectedMonth=inst.currentMonth=newDate.getMonth();inst.drawYear=inst.selectedYear=inst.currentYear=newDate.getFullYear();if((origMonth!=inst.selectedMonth||origYear!=inst.selectedYear)&&!noChange)
this._notifyChange(inst);this._adjustInstDate(inst);if(inst.input){inst.input.val(clear?'':this._formatDate(inst));}},_getDate:function(inst){var startDate=(!inst.currentYear||(inst.input&&inst.input.val()=='')?null:this._daylightSavingAdjust(new Date(inst.currentYear,inst.currentMonth,inst.currentDay)));return startDate;},_attachHandlers:function(inst){var stepMonths=this._get(inst,'stepMonths');var id='#'+inst.id.replace(/\\\\/g,"\\");inst.dpDiv.find('[data-handler]').map(function(){var handler={prev:function(){window['DP_jQuery_'+dpuuid].datepicker._adjustDate(id,-stepMonths,'M');},next:function(){window['DP_jQuery_'+dpuuid].datepicker._adjustDate(id,+stepMonths,'M');},hide:function(){window['DP_jQuery_'+dpuuid].datepicker._hideDatepicker();},today:function(){window['DP_jQuery_'+dpuuid].datepicker._gotoToday(id);},selectDay:function(){window['DP_jQuery_'+dpuuid].datepicker._selectDay(id,+this.getAttribute('data-month'),+this.getAttribute('data-year'),this);return false;},selectMonth:function(){window['DP_jQuery_'+dpuuid].datepicker._selectMonthYear(id,this,'M');return false;},selectYear:function(){window['DP_jQuery_'+dpuuid].datepicker._selectMonthYear(id,this,'Y');return false;}};$(this).bind(this.getAttribute('data-event'),handler[this.getAttribute('data-handler')]);});},_generateHTML:function(inst){var today=new Date();today=this._daylightSavingAdjust(new Date(today.getFullYear(),today.getMonth(),today.getDate()));var isRTL=this._get(inst,'isRTL');var showButtonPanel=this._get(inst,'showButtonPanel');var hideIfNoPrevNext=this._get(inst,'hideIfNoPrevNext');var navigationAsDateFormat=this._get(inst,'navigationAsDateFormat');var numMonths=this._getNumberOfMonths(inst);var showCurrentAtPos=this._get(inst,'showCurrentAtPos');var stepMonths=this._get(inst,'stepMonths');var isMultiMonth=(numMonths[0]!=1||numMonths[1]!=1);var currentDate=this._daylightSavingAdjust((!inst.currentDay?new Date(9999,9,9):new Date(inst.currentYear,inst.currentMonth,inst.currentDay)));var minDate=this._getMinMaxDate(inst,'min');var maxDate=this._getMinMaxDate(inst,'max');var drawMonth=inst.drawMonth-showCurrentAtPos;var drawYear=inst.drawYear;if(drawMonth<0){drawMonth+=12;drawYear--;}
if(maxDate){var maxDraw=this._daylightSavingAdjust(new Date(maxDate.getFullYear(),maxDate.getMonth()-(numMonths[0]*numMonths[1])+1,maxDate.getDate()));maxDraw=(minDate&&maxDraw<minDate?minDate:maxDraw);while(this._daylightSavingAdjust(new Date(drawYear,drawMonth,1))>maxDraw){drawMonth--;if(drawMonth<0){drawMonth=11;drawYear--;}}}
inst.drawMonth=drawMonth;inst.drawYear=drawYear;var prevText=this._get(inst,'prevText');prevText=(!navigationAsDateFormat?prevText:this.formatDate(prevText,this._daylightSavingAdjust(new Date(drawYear,drawMonth-stepMonths,1)),this._getFormatConfig(inst)));var prev=(this._canAdjustMonth(inst,-1,drawYear,drawMonth)?'<a class="ui-datepicker-prev ui-corner-all" data-handler="prev" data-event="click"'+' title="'+prevText+'"><span class="ui-icon ui-icon-circle-triangle-'+(isRTL?'e':'w')+'">'+prevText+'</span></a>':(hideIfNoPrevNext?'':'<a class="ui-datepicker-prev ui-corner-all ui-state-disabled" title="'+prevText+'"><span class="ui-icon ui-icon-circle-triangle-'+(isRTL?'e':'w')+'">'+prevText+'</span></a>'));var nextText=this._get(inst,'nextText');nextText=(!navigationAsDateFormat?nextText:this.formatDate(nextText,this._daylightSavingAdjust(new Date(drawYear,drawMonth+stepMonths,1)),this._getFormatConfig(inst)));var next=(this._canAdjustMonth(inst,+1,drawYear,drawMonth)?'<a class="ui-datepicker-next ui-corner-all" data-handler="next" data-event="click"'+' title="'+nextText+'"><span class="ui-icon ui-icon-circle-triangle-'+(isRTL?'w':'e')+'">'+nextText+'</span></a>':(hideIfNoPrevNext?'':'<a class="ui-datepicker-next ui-corner-all ui-state-disabled" title="'+nextText+'"><span class="ui-icon ui-icon-circle-triangle-'+(isRTL?'w':'e')+'">'+nextText+'</span></a>'));var currentText=this._get(inst,'currentText');var gotoDate=(this._get(inst,'gotoCurrent')&&inst.currentDay?currentDate:today);currentText=(!navigationAsDateFormat?currentText:this.formatDate(currentText,gotoDate,this._getFormatConfig(inst)));var controls=(!inst.inline?'<button type="button" class="ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all" data-handler="hide" data-event="click">'+
this._get(inst,'closeText')+'</button>':'');var buttonPanel=(showButtonPanel)?'<div class="ui-datepicker-buttonpane ui-widget-content">'+(isRTL?controls:'')+
(this._isInRange(inst,gotoDate)?'<button type="button" class="ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all" data-handler="today" data-event="click"'+'>'+currentText+'</button>':'')+(isRTL?'':controls)+'</div>':'';var firstDay=parseInt(this._get(inst,'firstDay'),10);firstDay=(isNaN(firstDay)?0:firstDay);var showWeek=this._get(inst,'showWeek');var dayNames=this._get(inst,'dayNames');var dayNamesShort=this._get(inst,'dayNamesShort');var dayNamesMin=this._get(inst,'dayNamesMin');var monthNames=this._get(inst,'monthNames');var monthNamesShort=this._get(inst,'monthNamesShort');var beforeShowDay=this._get(inst,'beforeShowDay');var showOtherMonths=this._get(inst,'showOtherMonths');var selectOtherMonths=this._get(inst,'selectOtherMonths');var calculateWeek=this._get(inst,'calculateWeek')||this.iso8601Week;var defaultDate=this._getDefaultDate(inst);var html='';for(var row=0;row<numMonths[0];row++){var group='';this.maxRows=4;for(var col=0;col<numMonths[1];col++){var selectedDate=this._daylightSavingAdjust(new Date(drawYear,drawMonth,inst.selectedDay));var cornerClass=' ui-corner-all';var calender='';if(isMultiMonth){calender+='<div class="ui-datepicker-group';if(numMonths[1]>1)
switch(col){case 0:calender+=' ui-datepicker-group-first';cornerClass=' ui-corner-'+(isRTL?'right':'left');break;case numMonths[1]-1:calender+=' ui-datepicker-group-last';cornerClass=' ui-corner-'+(isRTL?'left':'right');break;default:calender+=' ui-datepicker-group-middle';cornerClass='';break;}
calender+='">';}
calender+='<div class="ui-datepicker-header ui-widget-header ui-helper-clearfix'+cornerClass+'">'+
(/all|left/.test(cornerClass)&&row==0?(isRTL?next:prev):'')+
(/all|right/.test(cornerClass)&&row==0?(isRTL?prev:next):'')+
this._generateMonthYearHeader(inst,drawMonth,drawYear,minDate,maxDate,row>0||col>0,monthNames,monthNamesShort)+'</div><table class="ui-datepicker-calendar"><thead>'+'<tr>';var thead=(showWeek?'<th class="ui-datepicker-week-col">'+this._get(inst,'weekHeader')+'</th>':'');for(var dow=0;dow<7;dow++){var day=(dow+firstDay)%7;thead+='<th'+((dow+firstDay+6)%7>=5?' class="ui-datepicker-week-end"':'')+'>'+'<span title="'+dayNames[day]+'">'+dayNamesMin[day]+'</span></th>';}
calender+=thead+'</tr></thead><tbody>';var daysInMonth=this._getDaysInMonth(drawYear,drawMonth);if(drawYear==inst.selectedYear&&drawMonth==inst.selectedMonth)
inst.selectedDay=Math.min(inst.selectedDay,daysInMonth);var leadDays=(this._getFirstDayOfMonth(drawYear,drawMonth)-firstDay+7)%7;var curRows=Math.ceil((leadDays+daysInMonth)/7);var numRows=(isMultiMonth?this.maxRows>curRows?this.maxRows:curRows:curRows);this.maxRows=numRows;var printDate=this._daylightSavingAdjust(new Date(drawYear,drawMonth,1-leadDays));for(var dRow=0;dRow<numRows;dRow++){calender+='<tr>';var tbody=(!showWeek?'':'<td class="ui-datepicker-week-col">'+
this._get(inst,'calculateWeek')(printDate)+'</td>');for(var dow=0;dow<7;dow++){var daySettings=(beforeShowDay?beforeShowDay.apply((inst.input?inst.input[0]:null),[printDate]):[true,'']);var otherMonth=(printDate.getMonth()!=drawMonth);var unselectable=(otherMonth&&!selectOtherMonths)||!daySettings[0]||(minDate&&printDate<minDate)||(maxDate&&printDate>maxDate);tbody+='<td class="'+
((dow+firstDay+6)%7>=5?' ui-datepicker-week-end':'')+
(otherMonth?' ui-datepicker-other-month':'')+
((printDate.getTime()==selectedDate.getTime()&&drawMonth==inst.selectedMonth&&inst._keyEvent)||(defaultDate.getTime()==printDate.getTime()&&defaultDate.getTime()==selectedDate.getTime())?' '+this._dayOverClass:'')+
(unselectable?' '+this._unselectableClass+' ui-state-disabled':'')+
(otherMonth&&!showOtherMonths?'':' '+daySettings[1]+
(printDate.getTime()==currentDate.getTime()?' '+this._currentClass:'')+
(printDate.getTime()==today.getTime()?' ui-datepicker-today':''))+'"'+
((!otherMonth||showOtherMonths)&&daySettings[2]?' title="'+daySettings[2]+'"':'')+
(unselectable?'':' data-handler="selectDay" data-event="click" data-month="'+printDate.getMonth()+'" data-year="'+printDate.getFullYear()+'"')+'>'+
(otherMonth&&!showOtherMonths?'&#xa0;':(unselectable?'<span class="ui-state-default">'+printDate.getDate()+'</span>':'<a class="ui-state-default'+
(printDate.getTime()==today.getTime()?' ui-state-highlight':'')+
(printDate.getTime()==currentDate.getTime()?' ui-state-active':'')+
(otherMonth?' ui-priority-secondary':'')+'" href="#">'+printDate.getDate()+'</a>'))+'</td>';printDate.setDate(printDate.getDate()+1);printDate=this._daylightSavingAdjust(printDate);}
calender+=tbody+'</tr>';}
drawMonth++;if(drawMonth>11){drawMonth=0;drawYear++;}
calender+='</tbody></table>'+(isMultiMonth?'</div>'+
((numMonths[0]>0&&col==numMonths[1]-1)?'<div class="ui-datepicker-row-break"></div>':''):'');group+=calender;}
html+=group;}
html+=buttonPanel+($.ui.ie6&&!inst.inline?'<iframe src="javascript:false;" class="ui-datepicker-cover" frameborder="0"></iframe>':'');inst._keyEvent=false;return html;},_generateMonthYearHeader:function(inst,drawMonth,drawYear,minDate,maxDate,secondary,monthNames,monthNamesShort){var changeMonth=this._get(inst,'changeMonth');var changeYear=this._get(inst,'changeYear');var showMonthAfterYear=this._get(inst,'showMonthAfterYear');var html='<div class="ui-datepicker-title">';var monthHtml='';if(secondary||!changeMonth)
monthHtml+='<span class="ui-datepicker-month">'+monthNames[drawMonth]+'</span>';else{var inMinYear=(minDate&&minDate.getFullYear()==drawYear);var inMaxYear=(maxDate&&maxDate.getFullYear()==drawYear);monthHtml+='<select class="ui-datepicker-month" data-handler="selectMonth" data-event="change">';for(var month=0;month<12;month++){if((!inMinYear||month>=minDate.getMonth())&&(!inMaxYear||month<=maxDate.getMonth()))
monthHtml+='<option value="'+month+'"'+
(month==drawMonth?' selected="selected"':'')+'>'+monthNamesShort[month]+'</option>';}
monthHtml+='</select>';}
if(!showMonthAfterYear)
html+=monthHtml+(secondary||!(changeMonth&&changeYear)?'&#xa0;':'');if(!inst.yearshtml){inst.yearshtml='';if(secondary||!changeYear)
html+='<span class="ui-datepicker-year">'+drawYear+'</span>';else{var years=this._get(inst,'yearRange').split(':');var thisYear=new Date().getFullYear();var determineYear=function(value){var year=(value.match(/c[+-].*/)?drawYear+parseInt(value.substring(1),10):(value.match(/[+-].*/)?thisYear+parseInt(value,10):parseInt(value,10)));return(isNaN(year)?thisYear:year);};var year=determineYear(years[0]);var endYear=Math.max(year,determineYear(years[1]||''));year=(minDate?Math.max(year,minDate.getFullYear()):year);endYear=(maxDate?Math.min(endYear,maxDate.getFullYear()):endYear);inst.yearshtml+='<select class="ui-datepicker-year" data-handler="selectYear" data-event="change">';for(;year<=endYear;year++){inst.yearshtml+='<option value="'+year+'"'+
(year==drawYear?' selected="selected"':'')+'>'+year+'</option>';}
inst.yearshtml+='</select>';html+=inst.yearshtml;inst.yearshtml=null;}}
html+=this._get(inst,'yearSuffix');if(showMonthAfterYear)
html+=(secondary||!(changeMonth&&changeYear)?'&#xa0;':'')+monthHtml;html+='</div>';return html;},_adjustInstDate:function(inst,offset,period){var year=inst.drawYear+(period=='Y'?offset:0);var month=inst.drawMonth+(period=='M'?offset:0);var day=Math.min(inst.selectedDay,this._getDaysInMonth(year,month))+
(period=='D'?offset:0);var date=this._restrictMinMax(inst,this._daylightSavingAdjust(new Date(year,month,day)));inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();if(period=='M'||period=='Y')
this._notifyChange(inst);},_restrictMinMax:function(inst,date){var minDate=this._getMinMaxDate(inst,'min');var maxDate=this._getMinMaxDate(inst,'max');var newDate=(minDate&&date<minDate?minDate:date);newDate=(maxDate&&newDate>maxDate?maxDate:newDate);return newDate;},_notifyChange:function(inst){var onChange=this._get(inst,'onChangeMonthYear');if(onChange)
onChange.apply((inst.input?inst.input[0]:null),[inst.selectedYear,inst.selectedMonth+1,inst]);},_getNumberOfMonths:function(inst){var numMonths=this._get(inst,'numberOfMonths');return(numMonths==null?[1,1]:(typeof numMonths=='number'?[1,numMonths]:numMonths));},_getMinMaxDate:function(inst,minMax){return this._determineDate(inst,this._get(inst,minMax+'Date'),null);},_getDaysInMonth:function(year,month){return 32-this._daylightSavingAdjust(new Date(year,month,32)).getDate();},_getFirstDayOfMonth:function(year,month){return new Date(year,month,1).getDay();},_canAdjustMonth:function(inst,offset,curYear,curMonth){var numMonths=this._getNumberOfMonths(inst);var date=this._daylightSavingAdjust(new Date(curYear,curMonth+(offset<0?offset:numMonths[0]*numMonths[1]),1));if(offset<0)
date.setDate(this._getDaysInMonth(date.getFullYear(),date.getMonth()));return this._isInRange(inst,date);},_isInRange:function(inst,date){var minDate=this._getMinMaxDate(inst,'min');var maxDate=this._getMinMaxDate(inst,'max');return((!minDate||date.getTime()>=minDate.getTime())&&(!maxDate||date.getTime()<=maxDate.getTime()));},_getFormatConfig:function(inst){var shortYearCutoff=this._get(inst,'shortYearCutoff');shortYearCutoff=(typeof shortYearCutoff!='string'?shortYearCutoff:new Date().getFullYear()%100+parseInt(shortYearCutoff,10));return{shortYearCutoff:shortYearCutoff,dayNamesShort:this._get(inst,'dayNamesShort'),dayNames:this._get(inst,'dayNames'),monthNamesShort:this._get(inst,'monthNamesShort'),monthNames:this._get(inst,'monthNames')};},_formatDate:function(inst,day,month,year){if(!day){inst.currentDay=inst.selectedDay;inst.currentMonth=inst.selectedMonth;inst.currentYear=inst.selectedYear;}
var date=(day?(typeof day=='object'?day:this._daylightSavingAdjust(new Date(year,month,day))):this._daylightSavingAdjust(new Date(inst.currentYear,inst.currentMonth,inst.currentDay)));return this.formatDate(this._get(inst,'dateFormat'),date,this._getFormatConfig(inst));}});function bindHover(dpDiv){var selector='button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a';return dpDiv.delegate(selector,'mouseout',function(){$(this).removeClass('ui-state-hover');if(this.className.indexOf('ui-datepicker-prev')!=-1)$(this).removeClass('ui-datepicker-prev-hover');if(this.className.indexOf('ui-datepicker-next')!=-1)$(this).removeClass('ui-datepicker-next-hover');}).delegate(selector,'mouseover',function(){if(!$.datepicker._isDisabledDatepicker(instActive.inline?dpDiv.parent()[0]:instActive.input[0])){$(this).parents('.ui-datepicker-calendar').find('a').removeClass('ui-state-hover');$(this).addClass('ui-state-hover');if(this.className.indexOf('ui-datepicker-prev')!=-1)$(this).addClass('ui-datepicker-prev-hover');if(this.className.indexOf('ui-datepicker-next')!=-1)$(this).addClass('ui-datepicker-next-hover');}});}
function extendRemove(target,props){$.extend(target,props);for(var name in props)
if(props[name]==null||props[name]==undefined)
target[name]=props[name];return target;};$.fn.datepicker=function(options){if(!this.length){return this;}
if(!$.datepicker.initialized){$(document).mousedown($.datepicker._checkExternalClick).find(document.body).append($.datepicker.dpDiv);$.datepicker.initialized=true;}
var otherArgs=Array.prototype.slice.call(arguments,1);if(typeof options=='string'&&(options=='isDisabled'||options=='getDate'||options=='widget'))
return $.datepicker['_'+options+'Datepicker'].apply($.datepicker,[this[0]].concat(otherArgs));if(options=='option'&&arguments.length==2&&typeof arguments[1]=='string')
return $.datepicker['_'+options+'Datepicker'].apply($.datepicker,[this[0]].concat(otherArgs));return this.each(function(){typeof options=='string'?$.datepicker['_'+options+'Datepicker'].apply($.datepicker,[this].concat(otherArgs)):$.datepicker._attachDatepicker(this,options);});};$.datepicker=new Datepicker();$.datepicker.initialized=false;$.datepicker.uuid=new Date().getTime();$.datepicker.version="1.9.2";window['DP_jQuery_'+dpuuid]=$;})(jQuery);(function($,undefined){var uiDialogClasses="ui-dialog ui-widget ui-widget-content ui-corner-all ",sizeRelatedOptions={buttons:true,height:true,maxHeight:true,maxWidth:true,minHeight:true,minWidth:true,width:true},resizableRelatedOptions={maxHeight:true,maxWidth:true,minHeight:true,minWidth:true};$.widget("ui.dialog",{version:"1.9.2",options:{autoOpen:true,buttons:{},closeOnEscape:true,closeText:"close",dialogClass:"",draggable:true,hide:null,height:"auto",maxHeight:false,maxWidth:false,minHeight:150,minWidth:150,modal:false,position:{my:"center",at:"center",of:window,collision:"fit",using:function(pos){var topOffset=$(this).css(pos).offset().top;if(topOffset<0){$(this).css("top",pos.top-topOffset);}}},resizable:true,show:null,stack:true,title:"",width:300,zIndex:1000},_create:function(){this.originalTitle=this.element.attr("title");if(typeof this.originalTitle!=="string"){this.originalTitle="";}
this.oldPosition={parent:this.element.parent(),index:this.element.parent().children().index(this.element)};this.options.title=this.options.title||this.originalTitle;var that=this,options=this.options,title=options.title||"&#160;",uiDialog,uiDialogTitlebar,uiDialogTitlebarClose,uiDialogTitle,uiDialogButtonPane;uiDialog=(this.uiDialog=$("<div>")).addClass(uiDialogClasses+options.dialogClass).css({display:"none",outline:0,zIndex:options.zIndex}).attr("tabIndex",-1).keydown(function(event){if(options.closeOnEscape&&!event.isDefaultPrevented()&&event.keyCode&&event.keyCode===$.ui.keyCode.ESCAPE){that.close(event);event.preventDefault();}}).mousedown(function(event){that.moveToTop(false,event);}).appendTo("body");this.element.show().removeAttr("title").addClass("ui-dialog-content ui-widget-content").appendTo(uiDialog);uiDialogTitlebar=(this.uiDialogTitlebar=$("<div>")).addClass("ui-dialog-titlebar  ui-widget-header  "+"ui-corner-all  ui-helper-clearfix").bind("mousedown",function(){uiDialog.focus();}).prependTo(uiDialog);uiDialogTitlebarClose=$("<a href='#'></a>").addClass("ui-dialog-titlebar-close  ui-corner-all").attr("role","button").click(function(event){event.preventDefault();that.close(event);}).appendTo(uiDialogTitlebar);(this.uiDialogTitlebarCloseText=$("<span>")).addClass("ui-icon ui-icon-closethick").text(options.closeText).appendTo(uiDialogTitlebarClose);uiDialogTitle=$("<span>").uniqueId().addClass("ui-dialog-title").html(title).prependTo(uiDialogTitlebar);uiDialogButtonPane=(this.uiDialogButtonPane=$("<div>")).addClass("ui-dialog-buttonpane ui-widget-content ui-helper-clearfix");(this.uiButtonSet=$("<div>")).addClass("ui-dialog-buttonset").appendTo(uiDialogButtonPane);uiDialog.attr({role:"dialog","aria-labelledby":uiDialogTitle.attr("id")});uiDialogTitlebar.find("*").add(uiDialogTitlebar).disableSelection();this._hoverable(uiDialogTitlebarClose);this._focusable(uiDialogTitlebarClose);if(options.draggable&&$.fn.draggable){this._makeDraggable();}
if(options.resizable&&$.fn.resizable){this._makeResizable();}
this._createButtons(options.buttons);this._isOpen=false;if($.fn.bgiframe){uiDialog.bgiframe();}
this._on(uiDialog,{keydown:function(event){if(!options.modal||event.keyCode!==$.ui.keyCode.TAB){return;}
var tabbables=$(":tabbable",uiDialog),first=tabbables.filter(":first"),last=tabbables.filter(":last");if(event.target===last[0]&&!event.shiftKey){first.focus(1);return false;}else if(event.target===first[0]&&event.shiftKey){last.focus(1);return false;}}});},_init:function(){if(this.options.autoOpen){this.open();}},_destroy:function(){var next,oldPosition=this.oldPosition;if(this.overlay){this.overlay.destroy();}
this.uiDialog.hide();this.element.removeClass("ui-dialog-content ui-widget-content").hide().appendTo("body");this.uiDialog.remove();if(this.originalTitle){this.element.attr("title",this.originalTitle);}
next=oldPosition.parent.children().eq(oldPosition.index);if(next.length&&next[0]!==this.element[0]){next.before(this.element);}else{oldPosition.parent.append(this.element);}},widget:function(){return this.uiDialog;},close:function(event){var that=this,maxZ,thisZ;if(!this._isOpen){return;}
if(false===this._trigger("beforeClose",event)){return;}
this._isOpen=false;if(this.overlay){this.overlay.destroy();}
if(this.options.hide){this._hide(this.uiDialog,this.options.hide,function(){that._trigger("close",event);});}else{this.uiDialog.hide();this._trigger("close",event);}
$.ui.dialog.overlay.resize();if(this.options.modal){maxZ=0;$(".ui-dialog").each(function(){if(this!==that.uiDialog[0]){thisZ=$(this).css("z-index");if(!isNaN(thisZ)){maxZ=Math.max(maxZ,thisZ);}}});$.ui.dialog.maxZ=maxZ;}
return this;},isOpen:function(){return this._isOpen;},moveToTop:function(force,event){var options=this.options,saveScroll;if((options.modal&&!force)||(!options.stack&&!options.modal)){return this._trigger("focus",event);}
if(options.zIndex>$.ui.dialog.maxZ){$.ui.dialog.maxZ=options.zIndex;}
if(this.overlay){$.ui.dialog.maxZ+=1;$.ui.dialog.overlay.maxZ=$.ui.dialog.maxZ;this.overlay.$el.css("z-index",$.ui.dialog.overlay.maxZ);}
saveScroll={scrollTop:this.element.scrollTop(),scrollLeft:this.element.scrollLeft()};$.ui.dialog.maxZ+=1;this.uiDialog.css("z-index",$.ui.dialog.maxZ);this.element.attr(saveScroll);this._trigger("focus",event);return this;},open:function(){if(this._isOpen){return;}
var hasFocus,options=this.options,uiDialog=this.uiDialog;this._size();this._position(options.position);uiDialog.show(options.show);this.overlay=options.modal?new $.ui.dialog.overlay(this):null;this.moveToTop(true);hasFocus=this.element.find(":tabbable");if(!hasFocus.length){hasFocus=this.uiDialogButtonPane.find(":tabbable");if(!hasFocus.length){hasFocus=uiDialog;}}
hasFocus.eq(0).focus();this._isOpen=true;this._trigger("open");return this;},_createButtons:function(buttons){var that=this,hasButtons=false;this.uiDialogButtonPane.remove();this.uiButtonSet.empty();if(typeof buttons==="object"&&buttons!==null){$.each(buttons,function(){return!(hasButtons=true);});}
if(hasButtons){$.each(buttons,function(name,props){var button,click;props=$.isFunction(props)?{click:props,text:name}:props;props=$.extend({type:"button"},props);click=props.click;props.click=function(){click.apply(that.element[0],arguments);};button=$("<button></button>",props).appendTo(that.uiButtonSet);if($.fn.button){button.button();}});this.uiDialog.addClass("ui-dialog-buttons");this.uiDialogButtonPane.appendTo(this.uiDialog);}else{this.uiDialog.removeClass("ui-dialog-buttons");}},_makeDraggable:function(){var that=this,options=this.options;function filteredUi(ui){return{position:ui.position,offset:ui.offset};}
this.uiDialog.draggable({cancel:".ui-dialog-content, .ui-dialog-titlebar-close",handle:".ui-dialog-titlebar",containment:"document",start:function(event,ui){$(this).addClass("ui-dialog-dragging");that._trigger("dragStart",event,filteredUi(ui));},drag:function(event,ui){that._trigger("drag",event,filteredUi(ui));},stop:function(event,ui){options.position=[ui.position.left-that.document.scrollLeft(),ui.position.top-that.document.scrollTop()];$(this).removeClass("ui-dialog-dragging");that._trigger("dragStop",event,filteredUi(ui));$.ui.dialog.overlay.resize();}});},_makeResizable:function(handles){handles=(handles===undefined?this.options.resizable:handles);var that=this,options=this.options,position=this.uiDialog.css("position"),resizeHandles=typeof handles==='string'?handles:"n,e,s,w,se,sw,ne,nw";function filteredUi(ui){return{originalPosition:ui.originalPosition,originalSize:ui.originalSize,position:ui.position,size:ui.size};}
this.uiDialog.resizable({cancel:".ui-dialog-content",containment:"document",alsoResize:this.element,maxWidth:options.maxWidth,maxHeight:options.maxHeight,minWidth:options.minWidth,minHeight:this._minHeight(),handles:resizeHandles,start:function(event,ui){$(this).addClass("ui-dialog-resizing");that._trigger("resizeStart",event,filteredUi(ui));},resize:function(event,ui){that._trigger("resize",event,filteredUi(ui));},stop:function(event,ui){$(this).removeClass("ui-dialog-resizing");options.height=$(this).height();options.width=$(this).width();that._trigger("resizeStop",event,filteredUi(ui));$.ui.dialog.overlay.resize();}}).css("position",position).find(".ui-resizable-se").addClass("ui-icon ui-icon-grip-diagonal-se");},_minHeight:function(){var options=this.options;if(options.height==="auto"){return options.minHeight;}else{return Math.min(options.minHeight,options.height);}},_position:function(position){var myAt=[],offset=[0,0],isVisible;if(position){if(typeof position==="string"||(typeof position==="object"&&"0"in position)){myAt=position.split?position.split(" "):[position[0],position[1]];if(myAt.length===1){myAt[1]=myAt[0];}
$.each(["left","top"],function(i,offsetPosition){if(+myAt[i]===myAt[i]){offset[i]=myAt[i];myAt[i]=offsetPosition;}});position={my:myAt[0]+(offset[0]<0?offset[0]:"+"+offset[0])+" "+
myAt[1]+(offset[1]<0?offset[1]:"+"+offset[1]),at:myAt.join(" ")};}
position=$.extend({},$.ui.dialog.prototype.options.position,position);}else{position=$.ui.dialog.prototype.options.position;}
isVisible=this.uiDialog.is(":visible");if(!isVisible){this.uiDialog.show();}
this.uiDialog.position(position);if(!isVisible){this.uiDialog.hide();}},_setOptions:function(options){var that=this,resizableOptions={},resize=false;$.each(options,function(key,value){that._setOption(key,value);if(key in sizeRelatedOptions){resize=true;}
if(key in resizableRelatedOptions){resizableOptions[key]=value;}});if(resize){this._size();}
if(this.uiDialog.is(":data(resizable)")){this.uiDialog.resizable("option",resizableOptions);}},_setOption:function(key,value){var isDraggable,isResizable,uiDialog=this.uiDialog;switch(key){case"buttons":this._createButtons(value);break;case"closeText":this.uiDialogTitlebarCloseText.text(""+value);break;case"dialogClass":uiDialog.removeClass(this.options.dialogClass).addClass(uiDialogClasses+value);break;case"disabled":if(value){uiDialog.addClass("ui-dialog-disabled");}else{uiDialog.removeClass("ui-dialog-disabled");}
break;case"draggable":isDraggable=uiDialog.is(":data(draggable)");if(isDraggable&&!value){uiDialog.draggable("destroy");}
if(!isDraggable&&value){this._makeDraggable();}
break;case"position":this._position(value);break;case"resizable":isResizable=uiDialog.is(":data(resizable)");if(isResizable&&!value){uiDialog.resizable("destroy");}
if(isResizable&&typeof value==="string"){uiDialog.resizable("option","handles",value);}
if(!isResizable&&value!==false){this._makeResizable(value);}
break;case"title":$(".ui-dialog-title",this.uiDialogTitlebar).html(""+(value||"&#160;"));break;}
this._super(key,value);},_size:function(){var nonContentHeight,minContentHeight,autoHeight,options=this.options,isVisible=this.uiDialog.is(":visible");this.element.show().css({width:"auto",minHeight:0,height:0});if(options.minWidth>options.width){options.width=options.minWidth;}
nonContentHeight=this.uiDialog.css({height:"auto",width:options.width}).outerHeight();minContentHeight=Math.max(0,options.minHeight-nonContentHeight);if(options.height==="auto"){if($.support.minHeight){this.element.css({minHeight:minContentHeight,height:"auto"});}else{this.uiDialog.show();autoHeight=this.element.css("height","auto").height();if(!isVisible){this.uiDialog.hide();}
this.element.height(Math.max(autoHeight,minContentHeight));}}else{this.element.height(Math.max(options.height-nonContentHeight,0));}
if(this.uiDialog.is(":data(resizable)")){this.uiDialog.resizable("option","minHeight",this._minHeight());}}});$.extend($.ui.dialog,{uuid:0,maxZ:0,getTitleId:function($el){var id=$el.attr("id");if(!id){this.uuid+=1;id=this.uuid;}
return"ui-dialog-title-"+id;},overlay:function(dialog){this.$el=$.ui.dialog.overlay.create(dialog);}});$.extend($.ui.dialog.overlay,{instances:[],oldInstances:[],maxZ:0,events:$.map("focus,mousedown,mouseup,keydown,keypress,click".split(","),function(event){return event+".dialog-overlay";}).join(" "),create:function(dialog){if(this.instances.length===0){setTimeout(function(){if($.ui.dialog.overlay.instances.length){$(document).bind($.ui.dialog.overlay.events,function(event){if($(event.target).zIndex()<$.ui.dialog.overlay.maxZ){return false;}});}},1);$(window).bind("resize.dialog-overlay",$.ui.dialog.overlay.resize);}
var $el=(this.oldInstances.pop()||$("<div>").addClass("ui-widget-overlay"));$(document).bind("keydown.dialog-overlay",function(event){var instances=$.ui.dialog.overlay.instances;if(instances.length!==0&&instances[instances.length-1]===$el&&dialog.options.closeOnEscape&&!event.isDefaultPrevented()&&event.keyCode&&event.keyCode===$.ui.keyCode.ESCAPE){dialog.close(event);event.preventDefault();}});$el.appendTo(document.body).css({width:this.width(),height:this.height()});if($.fn.bgiframe){$el.bgiframe();}
this.instances.push($el);return $el;},destroy:function($el){var indexOf=$.inArray($el,this.instances),maxZ=0;if(indexOf!==-1){this.oldInstances.push(this.instances.splice(indexOf,1)[0]);}
if(this.instances.length===0){$([document,window]).unbind(".dialog-overlay");}
$el.height(0).width(0).remove();$.each(this.instances,function(){maxZ=Math.max(maxZ,this.css("z-index"));});this.maxZ=maxZ;},height:function(){var scrollHeight,offsetHeight;if($.ui.ie){scrollHeight=Math.max(document.documentElement.scrollHeight,document.body.scrollHeight);offsetHeight=Math.max(document.documentElement.offsetHeight,document.body.offsetHeight);if(scrollHeight<offsetHeight){return $(window).height()+"px";}else{return scrollHeight+"px";}}else{return $(document).height()+"px";}},width:function(){var scrollWidth,offsetWidth;if($.ui.ie){scrollWidth=Math.max(document.documentElement.scrollWidth,document.body.scrollWidth);offsetWidth=Math.max(document.documentElement.offsetWidth,document.body.offsetWidth);if(scrollWidth<offsetWidth){return $(window).width()+"px";}else{return scrollWidth+"px";}}else{return $(document).width()+"px";}},resize:function(){var $overlays=$([]);$.each($.ui.dialog.overlay.instances,function(){$overlays=$overlays.add(this);});$overlays.css({width:0,height:0}).css({width:$.ui.dialog.overlay.width(),height:$.ui.dialog.overlay.height()});}});$.extend($.ui.dialog.overlay.prototype,{destroy:function(){$.ui.dialog.overlay.destroy(this.$el);}});}(jQuery));(function($,undefined){$.widget("ui.draggable",$.ui.mouse,{version:"1.9.2",widgetEventPrefix:"drag",options:{addClasses:true,appendTo:"parent",axis:false,connectToSortable:false,containment:false,cursor:"auto",cursorAt:false,grid:false,handle:false,helper:"original",iframeFix:false,opacity:false,refreshPositions:false,revert:false,revertDuration:500,scope:"default",scroll:true,scrollSensitivity:20,scrollSpeed:20,snap:false,snapMode:"both",snapTolerance:20,stack:false,zIndex:false},_create:function(){if(this.options.helper=='original'&&!(/^(?:r|a|f)/).test(this.element.css("position")))
this.element[0].style.position='relative';(this.options.addClasses&&this.element.addClass("ui-draggable"));(this.options.disabled&&this.element.addClass("ui-draggable-disabled"));this._mouseInit();},_destroy:function(){this.element.removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled");this._mouseDestroy();},_mouseCapture:function(event){var o=this.options;if(this.helper||o.disabled||$(event.target).is('.ui-resizable-handle'))
return false;this.handle=this._getHandle(event);if(!this.handle)
return false;$(o.iframeFix===true?"iframe":o.iframeFix).each(function(){$('<div class="ui-draggable-iframeFix" style="background: #fff;"></div>').css({width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1000}).css($(this).offset()).appendTo("body");});return true;},_mouseStart:function(event){var o=this.options;this.helper=this._createHelper(event);this.helper.addClass("ui-draggable-dragging");this._cacheHelperProportions();if($.ui.ddmanager)
$.ui.ddmanager.current=this;this._cacheMargins();this.cssPosition=this.helper.css("position");this.scrollParent=this.helper.scrollParent();this.offset=this.positionAbs=this.element.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};$.extend(this.offset,{click:{left:event.pageX-this.offset.left,top:event.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.originalPosition=this.position=this._generatePosition(event);this.originalPageX=event.pageX;this.originalPageY=event.pageY;(o.cursorAt&&this._adjustOffsetFromHelper(o.cursorAt));if(o.containment)
this._setContainment();if(this._trigger("start",event)===false){this._clear();return false;}
this._cacheHelperProportions();if($.ui.ddmanager&&!o.dropBehaviour)
$.ui.ddmanager.prepareOffsets(this,event);this._mouseDrag(event,true);if($.ui.ddmanager)$.ui.ddmanager.dragStart(this,event);return true;},_mouseDrag:function(event,noPropagation){this.position=this._generatePosition(event);this.positionAbs=this._convertPositionTo("absolute");if(!noPropagation){var ui=this._uiHash();if(this._trigger('drag',event,ui)===false){this._mouseUp({});return false;}
this.position=ui.position;}
if(!this.options.axis||this.options.axis!="y")this.helper[0].style.left=this.position.left+'px';if(!this.options.axis||this.options.axis!="x")this.helper[0].style.top=this.position.top+'px';if($.ui.ddmanager)$.ui.ddmanager.drag(this,event);return false;},_mouseStop:function(event){var dropped=false;if($.ui.ddmanager&&!this.options.dropBehaviour)
dropped=$.ui.ddmanager.drop(this,event);if(this.dropped){dropped=this.dropped;this.dropped=false;}
var element=this.element[0],elementInDom=false;while(element&&(element=element.parentNode)){if(element==document){elementInDom=true;}}
if(!elementInDom&&this.options.helper==="original")
return false;if((this.options.revert=="invalid"&&!dropped)||(this.options.revert=="valid"&&dropped)||this.options.revert===true||($.isFunction(this.options.revert)&&this.options.revert.call(this.element,dropped))){var that=this;$(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){if(that._trigger("stop",event)!==false){that._clear();}});}else{if(this._trigger("stop",event)!==false){this._clear();}}
return false;},_mouseUp:function(event){$("div.ui-draggable-iframeFix").each(function(){this.parentNode.removeChild(this);});if($.ui.ddmanager)$.ui.ddmanager.dragStop(this,event);return $.ui.mouse.prototype._mouseUp.call(this,event);},cancel:function(){if(this.helper.is(".ui-draggable-dragging")){this._mouseUp({});}else{this._clear();}
return this;},_getHandle:function(event){var handle=!this.options.handle||!$(this.options.handle,this.element).length?true:false;$(this.options.handle,this.element).find("*").andSelf().each(function(){if(this==event.target)handle=true;});return handle;},_createHelper:function(event){var o=this.options;var helper=$.isFunction(o.helper)?$(o.helper.apply(this.element[0],[event])):(o.helper=='clone'?this.element.clone().removeAttr('id'):this.element);if(!helper.parents('body').length)
helper.appendTo((o.appendTo=='parent'?this.element[0].parentNode:o.appendTo));if(helper[0]!=this.element[0]&&!(/(fixed|absolute)/).test(helper.css("position")))
helper.css("position","absolute");return helper;},_adjustOffsetFromHelper:function(obj){if(typeof obj=='string'){obj=obj.split(' ');}
if($.isArray(obj)){obj={left:+obj[0],top:+obj[1]||0};}
if('left'in obj){this.offset.click.left=obj.left+this.margins.left;}
if('right'in obj){this.offset.click.left=this.helperProportions.width-obj.right+this.margins.left;}
if('top'in obj){this.offset.click.top=obj.top+this.margins.top;}
if('bottom'in obj){this.offset.click.top=this.helperProportions.height-obj.bottom+this.margins.top;}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();if(this.cssPosition=='absolute'&&this.scrollParent[0]!=document&&$.contains(this.scrollParent[0],this.offsetParent[0])){po.left+=this.scrollParent.scrollLeft();po.top+=this.scrollParent.scrollTop();}
if((this.offsetParent[0]==document.body)||(this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()=='html'&&$.ui.ie))
po={top:0,left:0};return{top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)};},_getRelativeOffset:function(){if(this.cssPosition=="relative"){var p=this.element.position();return{top:p.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:p.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()};}else{return{top:0,left:0};}},_cacheMargins:function(){this.margins={left:(parseInt(this.element.css("marginLeft"),10)||0),top:(parseInt(this.element.css("marginTop"),10)||0),right:(parseInt(this.element.css("marginRight"),10)||0),bottom:(parseInt(this.element.css("marginBottom"),10)||0)};},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};},_setContainment:function(){var o=this.options;if(o.containment=='parent')o.containment=this.helper[0].parentNode;if(o.containment=='document'||o.containment=='window')this.containment=[o.containment=='document'?0:$(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,o.containment=='document'?0:$(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,(o.containment=='document'?0:$(window).scrollLeft())+$(o.containment=='document'?document:window).width()-this.helperProportions.width-this.margins.left,(o.containment=='document'?0:$(window).scrollTop())+($(o.containment=='document'?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];if(!(/^(document|window|parent)$/).test(o.containment)&&o.containment.constructor!=Array){var c=$(o.containment);var ce=c[0];if(!ce)return;var co=c.offset();var over=($(ce).css("overflow")!='hidden');this.containment=[(parseInt($(ce).css("borderLeftWidth"),10)||0)+(parseInt($(ce).css("paddingLeft"),10)||0),(parseInt($(ce).css("borderTopWidth"),10)||0)+(parseInt($(ce).css("paddingTop"),10)||0),(over?Math.max(ce.scrollWidth,ce.offsetWidth):ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-(parseInt($(ce).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(over?Math.max(ce.scrollHeight,ce.offsetHeight):ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-(parseInt($(ce).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom];this.relative_container=c;}else if(o.containment.constructor==Array){this.containment=o.containment;}},_convertPositionTo:function(d,pos){if(!pos)pos=this.position;var mod=d=="absolute"?1:-1;var o=this.options,scroll=this.cssPosition=='absolute'&&!(this.scrollParent[0]!=document&&$.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);return{top:(pos.top
+this.offset.relative.top*mod
+this.offset.parent.top*mod
-((this.cssPosition=='fixed'?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop()))*mod)),left:(pos.left
+this.offset.relative.left*mod
+this.offset.parent.left*mod
-((this.cssPosition=='fixed'?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())*mod))};},_generatePosition:function(event){var o=this.options,scroll=this.cssPosition=='absolute'&&!(this.scrollParent[0]!=document&&$.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);var pageX=event.pageX;var pageY=event.pageY;if(this.originalPosition){var containment;if(this.containment){if(this.relative_container){var co=this.relative_container.offset();containment=[this.containment[0]+co.left,this.containment[1]+co.top,this.containment[2]+co.left,this.containment[3]+co.top];}
else{containment=this.containment;}
if(event.pageX-this.offset.click.left<containment[0])pageX=containment[0]+this.offset.click.left;if(event.pageY-this.offset.click.top<containment[1])pageY=containment[1]+this.offset.click.top;if(event.pageX-this.offset.click.left>containment[2])pageX=containment[2]+this.offset.click.left;if(event.pageY-this.offset.click.top>containment[3])pageY=containment[3]+this.offset.click.top;}
if(o.grid){var top=o.grid[1]?this.originalPageY+Math.round((pageY-this.originalPageY)/o.grid[1])*o.grid[1]:this.originalPageY;pageY=containment?(!(top-this.offset.click.top<containment[1]||top-this.offset.click.top>containment[3])?top:(!(top-this.offset.click.top<containment[1])?top-o.grid[1]:top+o.grid[1])):top;var left=o.grid[0]?this.originalPageX+Math.round((pageX-this.originalPageX)/o.grid[0])*o.grid[0]:this.originalPageX;pageX=containment?(!(left-this.offset.click.left<containment[0]||left-this.offset.click.left>containment[2])?left:(!(left-this.offset.click.left<containment[0])?left-o.grid[0]:left+o.grid[0])):left;}}
return{top:(pageY
-this.offset.click.top
-this.offset.relative.top
-this.offset.parent.top
+((this.cssPosition=='fixed'?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop())))),left:(pageX
-this.offset.click.left
-this.offset.relative.left
-this.offset.parent.left
+((this.cssPosition=='fixed'?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())))};},_clear:function(){this.helper.removeClass("ui-draggable-dragging");if(this.helper[0]!=this.element[0]&&!this.cancelHelperRemoval)this.helper.remove();this.helper=null;this.cancelHelperRemoval=false;},_trigger:function(type,event,ui){ui=ui||this._uiHash();$.ui.plugin.call(this,type,[event,ui]);if(type=="drag")this.positionAbs=this._convertPositionTo("absolute");return $.Widget.prototype._trigger.call(this,type,event,ui);},plugins:{},_uiHash:function(event){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs};}});$.ui.plugin.add("draggable","connectToSortable",{start:function(event,ui){var inst=$(this).data("draggable"),o=inst.options,uiSortable=$.extend({},ui,{item:inst.element});inst.sortables=[];$(o.connectToSortable).each(function(){var sortable=$.data(this,'sortable');if(sortable&&!sortable.options.disabled){inst.sortables.push({instance:sortable,shouldRevert:sortable.options.revert});sortable.refreshPositions();sortable._trigger("activate",event,uiSortable);}});},stop:function(event,ui){var inst=$(this).data("draggable"),uiSortable=$.extend({},ui,{item:inst.element});$.each(inst.sortables,function(){if(this.instance.isOver){this.instance.isOver=0;inst.cancelHelperRemoval=true;this.instance.cancelHelperRemoval=false;if(this.shouldRevert)this.instance.options.revert=true;this.instance._mouseStop(event);this.instance.options.helper=this.instance.options._helper;if(inst.options.helper=='original')
this.instance.currentItem.css({top:'auto',left:'auto'});}else{this.instance.cancelHelperRemoval=false;this.instance._trigger("deactivate",event,uiSortable);}});},drag:function(event,ui){var inst=$(this).data("draggable"),that=this;var checkPos=function(o){var dyClick=this.offset.click.top,dxClick=this.offset.click.left;var helperTop=this.positionAbs.top,helperLeft=this.positionAbs.left;var itemHeight=o.height,itemWidth=o.width;var itemTop=o.top,itemLeft=o.left;return $.ui.isOver(helperTop+dyClick,helperLeft+dxClick,itemTop,itemLeft,itemHeight,itemWidth);};$.each(inst.sortables,function(i){var innermostIntersecting=false;var thisSortable=this;this.instance.positionAbs=inst.positionAbs;this.instance.helperProportions=inst.helperProportions;this.instance.offset.click=inst.offset.click;if(this.instance._intersectsWith(this.instance.containerCache)){innermostIntersecting=true;$.each(inst.sortables,function(){this.instance.positionAbs=inst.positionAbs;this.instance.helperProportions=inst.helperProportions;this.instance.offset.click=inst.offset.click;if(this!=thisSortable&&this.instance._intersectsWith(this.instance.containerCache)&&$.ui.contains(thisSortable.instance.element[0],this.instance.element[0]))
innermostIntersecting=false;return innermostIntersecting;});}
if(innermostIntersecting){if(!this.instance.isOver){this.instance.isOver=1;this.instance.currentItem=$(that).clone().removeAttr('id').appendTo(this.instance.element).data("sortable-item",true);this.instance.options._helper=this.instance.options.helper;this.instance.options.helper=function(){return ui.helper[0];};event.target=this.instance.currentItem[0];this.instance._mouseCapture(event,true);this.instance._mouseStart(event,true,true);this.instance.offset.click.top=inst.offset.click.top;this.instance.offset.click.left=inst.offset.click.left;this.instance.offset.parent.left-=inst.offset.parent.left-this.instance.offset.parent.left;this.instance.offset.parent.top-=inst.offset.parent.top-this.instance.offset.parent.top;inst._trigger("toSortable",event);inst.dropped=this.instance.element;inst.currentItem=inst.element;this.instance.fromOutside=inst;}
if(this.instance.currentItem)this.instance._mouseDrag(event);}else{if(this.instance.isOver){this.instance.isOver=0;this.instance.cancelHelperRemoval=true;this.instance.options.revert=false;this.instance._trigger('out',event,this.instance._uiHash(this.instance));this.instance._mouseStop(event,true);this.instance.options.helper=this.instance.options._helper;this.instance.currentItem.remove();if(this.instance.placeholder)this.instance.placeholder.remove();inst._trigger("fromSortable",event);inst.dropped=false;}};});}});$.ui.plugin.add("draggable","cursor",{start:function(event,ui){var t=$('body'),o=$(this).data('draggable').options;if(t.css("cursor"))o._cursor=t.css("cursor");t.css("cursor",o.cursor);},stop:function(event,ui){var o=$(this).data('draggable').options;if(o._cursor)$('body').css("cursor",o._cursor);}});$.ui.plugin.add("draggable","opacity",{start:function(event,ui){var t=$(ui.helper),o=$(this).data('draggable').options;if(t.css("opacity"))o._opacity=t.css("opacity");t.css('opacity',o.opacity);},stop:function(event,ui){var o=$(this).data('draggable').options;if(o._opacity)$(ui.helper).css('opacity',o._opacity);}});$.ui.plugin.add("draggable","scroll",{start:function(event,ui){var i=$(this).data("draggable");if(i.scrollParent[0]!=document&&i.scrollParent[0].tagName!='HTML')i.overflowOffset=i.scrollParent.offset();},drag:function(event,ui){var i=$(this).data("draggable"),o=i.options,scrolled=false;if(i.scrollParent[0]!=document&&i.scrollParent[0].tagName!='HTML'){if(!o.axis||o.axis!='x'){if((i.overflowOffset.top+i.scrollParent[0].offsetHeight)-event.pageY<o.scrollSensitivity)
i.scrollParent[0].scrollTop=scrolled=i.scrollParent[0].scrollTop+o.scrollSpeed;else if(event.pageY-i.overflowOffset.top<o.scrollSensitivity)
i.scrollParent[0].scrollTop=scrolled=i.scrollParent[0].scrollTop-o.scrollSpeed;}
if(!o.axis||o.axis!='y'){if((i.overflowOffset.left+i.scrollParent[0].offsetWidth)-event.pageX<o.scrollSensitivity)
i.scrollParent[0].scrollLeft=scrolled=i.scrollParent[0].scrollLeft+o.scrollSpeed;else if(event.pageX-i.overflowOffset.left<o.scrollSensitivity)
i.scrollParent[0].scrollLeft=scrolled=i.scrollParent[0].scrollLeft-o.scrollSpeed;}}else{if(!o.axis||o.axis!='x'){if(event.pageY-$(document).scrollTop()<o.scrollSensitivity)
scrolled=$(document).scrollTop($(document).scrollTop()-o.scrollSpeed);else if($(window).height()-(event.pageY-$(document).scrollTop())<o.scrollSensitivity)
scrolled=$(document).scrollTop($(document).scrollTop()+o.scrollSpeed);}
if(!o.axis||o.axis!='y'){if(event.pageX-$(document).scrollLeft()<o.scrollSensitivity)
scrolled=$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed);else if($(window).width()-(event.pageX-$(document).scrollLeft())<o.scrollSensitivity)
scrolled=$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed);}}
if(scrolled!==false&&$.ui.ddmanager&&!o.dropBehaviour)
$.ui.ddmanager.prepareOffsets(i,event);}});$.ui.plugin.add("draggable","snap",{start:function(event,ui){var i=$(this).data("draggable"),o=i.options;i.snapElements=[];$(o.snap.constructor!=String?(o.snap.items||':data(draggable)'):o.snap).each(function(){var $t=$(this);var $o=$t.offset();if(this!=i.element[0])i.snapElements.push({item:this,width:$t.outerWidth(),height:$t.outerHeight(),top:$o.top,left:$o.left});});},drag:function(event,ui){var inst=$(this).data("draggable"),o=inst.options;var d=o.snapTolerance;var x1=ui.offset.left,x2=x1+inst.helperProportions.width,y1=ui.offset.top,y2=y1+inst.helperProportions.height;for(var i=inst.snapElements.length-1;i>=0;i--){var l=inst.snapElements[i].left,r=l+inst.snapElements[i].width,t=inst.snapElements[i].top,b=t+inst.snapElements[i].height;if(!((l-d<x1&&x1<r+d&&t-d<y1&&y1<b+d)||(l-d<x1&&x1<r+d&&t-d<y2&&y2<b+d)||(l-d<x2&&x2<r+d&&t-d<y1&&y1<b+d)||(l-d<x2&&x2<r+d&&t-d<y2&&y2<b+d))){if(inst.snapElements[i].snapping)(inst.options.snap.release&&inst.options.snap.release.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item})));inst.snapElements[i].snapping=false;continue;}
if(o.snapMode!='inner'){var ts=Math.abs(t-y2)<=d;var bs=Math.abs(b-y1)<=d;var ls=Math.abs(l-x2)<=d;var rs=Math.abs(r-x1)<=d;if(ts)ui.position.top=inst._convertPositionTo("relative",{top:t-inst.helperProportions.height,left:0}).top-inst.margins.top;if(bs)ui.position.top=inst._convertPositionTo("relative",{top:b,left:0}).top-inst.margins.top;if(ls)ui.position.left=inst._convertPositionTo("relative",{top:0,left:l-inst.helperProportions.width}).left-inst.margins.left;if(rs)ui.position.left=inst._convertPositionTo("relative",{top:0,left:r}).left-inst.margins.left;}
var first=(ts||bs||ls||rs);if(o.snapMode!='outer'){var ts=Math.abs(t-y1)<=d;var bs=Math.abs(b-y2)<=d;var ls=Math.abs(l-x1)<=d;var rs=Math.abs(r-x2)<=d;if(ts)ui.position.top=inst._convertPositionTo("relative",{top:t,left:0}).top-inst.margins.top;if(bs)ui.position.top=inst._convertPositionTo("relative",{top:b-inst.helperProportions.height,left:0}).top-inst.margins.top;if(ls)ui.position.left=inst._convertPositionTo("relative",{top:0,left:l}).left-inst.margins.left;if(rs)ui.position.left=inst._convertPositionTo("relative",{top:0,left:r-inst.helperProportions.width}).left-inst.margins.left;}
if(!inst.snapElements[i].snapping&&(ts||bs||ls||rs||first))
(inst.options.snap.snap&&inst.options.snap.snap.call(inst.element,event,$.extend(inst._uiHash(),{snapItem:inst.snapElements[i].item})));inst.snapElements[i].snapping=(ts||bs||ls||rs||first);};}});$.ui.plugin.add("draggable","stack",{start:function(event,ui){var o=$(this).data("draggable").options;var group=$.makeArray($(o.stack)).sort(function(a,b){return(parseInt($(a).css("zIndex"),10)||0)-(parseInt($(b).css("zIndex"),10)||0);});if(!group.length){return;}
var min=parseInt(group[0].style.zIndex)||0;$(group).each(function(i){this.style.zIndex=min+i;});this[0].style.zIndex=min+group.length;}});$.ui.plugin.add("draggable","zIndex",{start:function(event,ui){var t=$(ui.helper),o=$(this).data("draggable").options;if(t.css("zIndex"))o._zIndex=t.css("zIndex");t.css('zIndex',o.zIndex);},stop:function(event,ui){var o=$(this).data("draggable").options;if(o._zIndex)$(ui.helper).css('zIndex',o._zIndex);}});})(jQuery);(function($,undefined){$.widget("ui.droppable",{version:"1.9.2",widgetEventPrefix:"drop",options:{accept:'*',activeClass:false,addClasses:true,greedy:false,hoverClass:false,scope:'default',tolerance:'intersect'},_create:function(){var o=this.options,accept=o.accept;this.isover=0;this.isout=1;this.accept=$.isFunction(accept)?accept:function(d){return d.is(accept);};this.proportions={width:this.element[0].offsetWidth,height:this.element[0].offsetHeight};$.ui.ddmanager.droppables[o.scope]=$.ui.ddmanager.droppables[o.scope]||[];$.ui.ddmanager.droppables[o.scope].push(this);(o.addClasses&&this.element.addClass("ui-droppable"));},_destroy:function(){var drop=$.ui.ddmanager.droppables[this.options.scope];for(var i=0;i<drop.length;i++)
if(drop[i]==this)
drop.splice(i,1);this.element.removeClass("ui-droppable ui-droppable-disabled");},_setOption:function(key,value){if(key=='accept'){this.accept=$.isFunction(value)?value:function(d){return d.is(value);};}
$.Widget.prototype._setOption.apply(this,arguments);},_activate:function(event){var draggable=$.ui.ddmanager.current;if(this.options.activeClass)this.element.addClass(this.options.activeClass);(draggable&&this._trigger('activate',event,this.ui(draggable)));},_deactivate:function(event){var draggable=$.ui.ddmanager.current;if(this.options.activeClass)this.element.removeClass(this.options.activeClass);(draggable&&this._trigger('deactivate',event,this.ui(draggable)));},_over:function(event){var draggable=$.ui.ddmanager.current;if(!draggable||(draggable.currentItem||draggable.element)[0]==this.element[0])return;if(this.accept.call(this.element[0],(draggable.currentItem||draggable.element))){if(this.options.hoverClass)this.element.addClass(this.options.hoverClass);this._trigger('over',event,this.ui(draggable));}},_out:function(event){var draggable=$.ui.ddmanager.current;if(!draggable||(draggable.currentItem||draggable.element)[0]==this.element[0])return;if(this.accept.call(this.element[0],(draggable.currentItem||draggable.element))){if(this.options.hoverClass)this.element.removeClass(this.options.hoverClass);this._trigger('out',event,this.ui(draggable));}},_drop:function(event,custom){var draggable=custom||$.ui.ddmanager.current;if(!draggable||(draggable.currentItem||draggable.element)[0]==this.element[0])return false;var childrenIntersection=false;this.element.find(":data(droppable)").not(".ui-draggable-dragging").each(function(){var inst=$.data(this,'droppable');if(inst.options.greedy&&!inst.options.disabled&&inst.options.scope==draggable.options.scope&&inst.accept.call(inst.element[0],(draggable.currentItem||draggable.element))&&$.ui.intersect(draggable,$.extend(inst,{offset:inst.element.offset()}),inst.options.tolerance)){childrenIntersection=true;return false;}});if(childrenIntersection)return false;if(this.accept.call(this.element[0],(draggable.currentItem||draggable.element))){if(this.options.activeClass)this.element.removeClass(this.options.activeClass);if(this.options.hoverClass)this.element.removeClass(this.options.hoverClass);this._trigger('drop',event,this.ui(draggable));return this.element;}
return false;},ui:function(c){return{draggable:(c.currentItem||c.element),helper:c.helper,position:c.position,offset:c.positionAbs};}});$.ui.intersect=function(draggable,droppable,toleranceMode){if(!droppable.offset)return false;var x1=(draggable.positionAbs||draggable.position.absolute).left,x2=x1+draggable.helperProportions.width,y1=(draggable.positionAbs||draggable.position.absolute).top,y2=y1+draggable.helperProportions.height;var l=droppable.offset.left,r=l+droppable.proportions.width,t=droppable.offset.top,b=t+droppable.proportions.height;switch(toleranceMode){case'fit':return(l<=x1&&x2<=r&&t<=y1&&y2<=b);break;case'intersect':return(l<x1+(draggable.helperProportions.width/2)&&x2-(draggable.helperProportions.width/2)<r&&t<y1+(draggable.helperProportions.height/2)&&y2-(draggable.helperProportions.height/2)<b);break;case'pointer':var draggableLeft=((draggable.positionAbs||draggable.position.absolute).left+(draggable.clickOffset||draggable.offset.click).left),draggableTop=((draggable.positionAbs||draggable.position.absolute).top+(draggable.clickOffset||draggable.offset.click).top),isOver=$.ui.isOver(draggableTop,draggableLeft,t,l,droppable.proportions.height,droppable.proportions.width);return isOver;break;case'touch':return((y1>=t&&y1<=b)||(y2>=t&&y2<=b)||(y1<t&&y2>b))&&((x1>=l&&x1<=r)||(x2>=l&&x2<=r)||(x1<l&&x2>r));break;default:return false;break;}};$.ui.ddmanager={current:null,droppables:{'default':[]},prepareOffsets:function(t,event){var m=$.ui.ddmanager.droppables[t.options.scope]||[];var type=event?event.type:null;var list=(t.currentItem||t.element).find(":data(droppable)").andSelf();droppablesLoop:for(var i=0;i<m.length;i++){if(m[i].options.disabled||(t&&!m[i].accept.call(m[i].element[0],(t.currentItem||t.element))))continue;for(var j=0;j<list.length;j++){if(list[j]==m[i].element[0]){m[i].proportions.height=0;continue droppablesLoop;}};m[i].visible=m[i].element.css("display")!="none";if(!m[i].visible)continue;if(type=="mousedown")m[i]._activate.call(m[i],event);m[i].offset=m[i].element.offset();m[i].proportions={width:m[i].element[0].offsetWidth,height:m[i].element[0].offsetHeight};}},drop:function(draggable,event){var dropped=false;$.each($.ui.ddmanager.droppables[draggable.options.scope]||[],function(){if(!this.options)return;if(!this.options.disabled&&this.visible&&$.ui.intersect(draggable,this,this.options.tolerance))
dropped=this._drop.call(this,event)||dropped;if(!this.options.disabled&&this.visible&&this.accept.call(this.element[0],(draggable.currentItem||draggable.element))){this.isout=1;this.isover=0;this._deactivate.call(this,event);}});return dropped;},dragStart:function(draggable,event){draggable.element.parentsUntil("body").bind("scroll.droppable",function(){if(!draggable.options.refreshPositions)$.ui.ddmanager.prepareOffsets(draggable,event);});},drag:function(draggable,event){if(draggable.options.refreshPositions)$.ui.ddmanager.prepareOffsets(draggable,event);$.each($.ui.ddmanager.droppables[draggable.options.scope]||[],function(){if(this.options.disabled||this.greedyChild||!this.visible)return;var intersects=$.ui.intersect(draggable,this,this.options.tolerance);var c=!intersects&&this.isover==1?'isout':(intersects&&this.isover==0?'isover':null);if(!c)return;var parentInstance;if(this.options.greedy){var scope=this.options.scope;var parent=this.element.parents(':data(droppable)').filter(function(){return $.data(this,'droppable').options.scope===scope;});if(parent.length){parentInstance=$.data(parent[0],'droppable');parentInstance.greedyChild=(c=='isover'?1:0);}}
if(parentInstance&&c=='isover'){parentInstance['isover']=0;parentInstance['isout']=1;parentInstance._out.call(parentInstance,event);}
this[c]=1;this[c=='isout'?'isover':'isout']=0;this[c=="isover"?"_over":"_out"].call(this,event);if(parentInstance&&c=='isout'){parentInstance['isout']=0;parentInstance['isover']=1;parentInstance._over.call(parentInstance,event);}});},dragStop:function(draggable,event){draggable.element.parentsUntil("body").unbind("scroll.droppable");if(!draggable.options.refreshPositions)$.ui.ddmanager.prepareOffsets(draggable,event);}};})(jQuery);;(jQuery.effects||(function($,undefined){var backCompat=$.uiBackCompat!==false,dataSpace="ui-effects-";$.effects={effect:{}};(function(jQuery,undefined){var stepHooks="backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor".split(" "),rplusequals=/^([\-+])=\s*(\d+\.?\d*)/,stringParsers=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,parse:function(execResult){return[execResult[1],execResult[2],execResult[3],execResult[4]];}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,parse:function(execResult){return[execResult[1]*2.55,execResult[2]*2.55,execResult[3]*2.55,execResult[4]];}},{re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse:function(execResult){return[parseInt(execResult[1],16),parseInt(execResult[2],16),parseInt(execResult[3],16)];}},{re:/#([a-f0-9])([a-f0-9])([a-f0-9])/,parse:function(execResult){return[parseInt(execResult[1]+execResult[1],16),parseInt(execResult[2]+execResult[2],16),parseInt(execResult[3]+execResult[3],16)];}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function(execResult){return[execResult[1],execResult[2]/100,execResult[3]/100,execResult[4]];}}],color=jQuery.Color=function(color,green,blue,alpha){return new jQuery.Color.fn.parse(color,green,blue,alpha);},spaces={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},propTypes={"byte":{floor:true,max:255},"percent":{max:1},"degrees":{mod:360,floor:true}},support=color.support={},supportElem=jQuery("<p>")[0],colors,each=jQuery.each;supportElem.style.cssText="background-color:rgba(1,1,1,.5)";support.rgba=supportElem.style.backgroundColor.indexOf("rgba")>-1;each(spaces,function(spaceName,space){space.cache="_"+spaceName;space.props.alpha={idx:3,type:"percent",def:1};});function clamp(value,prop,allowEmpty){var type=propTypes[prop.type]||{};if(value==null){return(allowEmpty||!prop.def)?null:prop.def;}
value=type.floor?~~value:parseFloat(value);if(isNaN(value)){return prop.def;}
if(type.mod){return(value+type.mod)%type.mod;}
return 0>value?0:type.max<value?type.max:value;}
function stringParse(string){var inst=color(),rgba=inst._rgba=[];string=string.toLowerCase();each(stringParsers,function(i,parser){var parsed,match=parser.re.exec(string),values=match&&parser.parse(match),spaceName=parser.space||"rgba";if(values){parsed=inst[spaceName](values);inst[spaces[spaceName].cache]=parsed[spaces[spaceName].cache];rgba=inst._rgba=parsed._rgba;return false;}});if(rgba.length){if(rgba.join()==="0,0,0,0"){jQuery.extend(rgba,colors.transparent);}
return inst;}
return colors[string];}
color.fn=jQuery.extend(color.prototype,{parse:function(red,green,blue,alpha){if(red===undefined){this._rgba=[null,null,null,null];return this;}
if(red.jquery||red.nodeType){red=jQuery(red).css(green);green=undefined;}
var inst=this,type=jQuery.type(red),rgba=this._rgba=[];if(green!==undefined){red=[red,green,blue,alpha];type="array";}
if(type==="string"){return this.parse(stringParse(red)||colors._default);}
if(type==="array"){each(spaces.rgba.props,function(key,prop){rgba[prop.idx]=clamp(red[prop.idx],prop);});return this;}
if(type==="object"){if(red instanceof color){each(spaces,function(spaceName,space){if(red[space.cache]){inst[space.cache]=red[space.cache].slice();}});}else{each(spaces,function(spaceName,space){var cache=space.cache;each(space.props,function(key,prop){if(!inst[cache]&&space.to){if(key==="alpha"||red[key]==null){return;}
inst[cache]=space.to(inst._rgba);}
inst[cache][prop.idx]=clamp(red[key],prop,true);});if(inst[cache]&&$.inArray(null,inst[cache].slice(0,3))<0){inst[cache][3]=1;if(space.from){inst._rgba=space.from(inst[cache]);}}});}
return this;}},is:function(compare){var is=color(compare),same=true,inst=this;each(spaces,function(_,space){var localCache,isCache=is[space.cache];if(isCache){localCache=inst[space.cache]||space.to&&space.to(inst._rgba)||[];each(space.props,function(_,prop){if(isCache[prop.idx]!=null){same=(isCache[prop.idx]===localCache[prop.idx]);return same;}});}
return same;});return same;},_space:function(){var used=[],inst=this;each(spaces,function(spaceName,space){if(inst[space.cache]){used.push(spaceName);}});return used.pop();},transition:function(other,distance){var end=color(other),spaceName=end._space(),space=spaces[spaceName],startColor=this.alpha()===0?color("transparent"):this,start=startColor[space.cache]||space.to(startColor._rgba),result=start.slice();end=end[space.cache];each(space.props,function(key,prop){var index=prop.idx,startValue=start[index],endValue=end[index],type=propTypes[prop.type]||{};if(endValue===null){return;}
if(startValue===null){result[index]=endValue;}else{if(type.mod){if(endValue-startValue>type.mod/2){startValue+=type.mod;}else if(startValue-endValue>type.mod/2){startValue-=type.mod;}}
result[index]=clamp((endValue-startValue)*distance+startValue,prop);}});return this[spaceName](result);},blend:function(opaque){if(this._rgba[3]===1){return this;}
var rgb=this._rgba.slice(),a=rgb.pop(),blend=color(opaque)._rgba;return color(jQuery.map(rgb,function(v,i){return(1-a)*blend[i]+a*v;}));},toRgbaString:function(){var prefix="rgba(",rgba=jQuery.map(this._rgba,function(v,i){return v==null?(i>2?1:0):v;});if(rgba[3]===1){rgba.pop();prefix="rgb(";}
return prefix+rgba.join()+")";},toHslaString:function(){var prefix="hsla(",hsla=jQuery.map(this.hsla(),function(v,i){if(v==null){v=i>2?1:0;}
if(i&&i<3){v=Math.round(v*100)+"%";}
return v;});if(hsla[3]===1){hsla.pop();prefix="hsl(";}
return prefix+hsla.join()+")";},toHexString:function(includeAlpha){var rgba=this._rgba.slice(),alpha=rgba.pop();if(includeAlpha){rgba.push(~~(alpha*255));}
return"#"+jQuery.map(rgba,function(v){v=(v||0).toString(16);return v.length===1?"0"+v:v;}).join("");},toString:function(){return this._rgba[3]===0?"transparent":this.toRgbaString();}});color.fn.parse.prototype=color.fn;function hue2rgb(p,q,h){h=(h+1)%1;if(h*6<1){return p+(q-p)*h*6;}
if(h*2<1){return q;}
if(h*3<2){return p+(q-p)*((2/3)-h)*6;}
return p;}
spaces.hsla.to=function(rgba){if(rgba[0]==null||rgba[1]==null||rgba[2]==null){return[null,null,null,rgba[3]];}
var r=rgba[0]/255,g=rgba[1]/255,b=rgba[2]/255,a=rgba[3],max=Math.max(r,g,b),min=Math.min(r,g,b),diff=max-min,add=max+min,l=add*0.5,h,s;if(min===max){h=0;}else if(r===max){h=(60*(g-b)/diff)+360;}else if(g===max){h=(60*(b-r)/diff)+120;}else{h=(60*(r-g)/diff)+240;}
if(l===0||l===1){s=l;}else if(l<=0.5){s=diff/add;}else{s=diff/(2-add);}
return[Math.round(h)%360,s,l,a==null?1:a];};spaces.hsla.from=function(hsla){if(hsla[0]==null||hsla[1]==null||hsla[2]==null){return[null,null,null,hsla[3]];}
var h=hsla[0]/360,s=hsla[1],l=hsla[2],a=hsla[3],q=l<=0.5?l*(1+s):l+s-l*s,p=2*l-q;return[Math.round(hue2rgb(p,q,h+(1/3))*255),Math.round(hue2rgb(p,q,h)*255),Math.round(hue2rgb(p,q,h-(1/3))*255),a];};each(spaces,function(spaceName,space){var props=space.props,cache=space.cache,to=space.to,from=space.from;color.fn[spaceName]=function(value){if(to&&!this[cache]){this[cache]=to(this._rgba);}
if(value===undefined){return this[cache].slice();}
var ret,type=jQuery.type(value),arr=(type==="array"||type==="object")?value:arguments,local=this[cache].slice();each(props,function(key,prop){var val=arr[type==="object"?key:prop.idx];if(val==null){val=local[prop.idx];}
local[prop.idx]=clamp(val,prop);});if(from){ret=color(from(local));ret[cache]=local;return ret;}else{return color(local);}};each(props,function(key,prop){if(color.fn[key]){return;}
color.fn[key]=function(value){var vtype=jQuery.type(value),fn=(key==="alpha"?(this._hsla?"hsla":"rgba"):spaceName),local=this[fn](),cur=local[prop.idx],match;if(vtype==="undefined"){return cur;}
if(vtype==="function"){value=value.call(this,cur);vtype=jQuery.type(value);}
if(value==null&&prop.empty){return this;}
if(vtype==="string"){match=rplusequals.exec(value);if(match){value=cur+parseFloat(match[2])*(match[1]==="+"?1:-1);}}
local[prop.idx]=value;return this[fn](local);};});});each(stepHooks,function(i,hook){jQuery.cssHooks[hook]={set:function(elem,value){var parsed,curElem,backgroundColor="";if(jQuery.type(value)!=="string"||(parsed=stringParse(value))){value=color(parsed||value);if(!support.rgba&&value._rgba[3]!==1){curElem=hook==="backgroundColor"?elem.parentNode:elem;while((backgroundColor===""||backgroundColor==="transparent")&&curElem&&curElem.style){try{backgroundColor=jQuery.css(curElem,"backgroundColor");curElem=curElem.parentNode;}catch(e){}}
value=value.blend(backgroundColor&&backgroundColor!=="transparent"?backgroundColor:"_default");}
value=value.toRgbaString();}
try{elem.style[hook]=value;}catch(error){}}};jQuery.fx.step[hook]=function(fx){if(!fx.colorInit){fx.start=color(fx.elem,hook);fx.end=color(fx.end);fx.colorInit=true;}
jQuery.cssHooks[hook].set(fx.elem,fx.start.transition(fx.end,fx.pos));};});jQuery.cssHooks.borderColor={expand:function(value){var expanded={};each(["Top","Right","Bottom","Left"],function(i,part){expanded["border"+part+"Color"]=value;});return expanded;}};colors=jQuery.Color.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",transparent:[null,null,null,0],_default:"#ffffff"};})(jQuery);(function(){var classAnimationActions=["add","remove","toggle"],shorthandStyles={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};$.each(["borderLeftStyle","borderRightStyle","borderBottomStyle","borderTopStyle"],function(_,prop){$.fx.step[prop]=function(fx){if(fx.end!=="none"&&!fx.setAttr||fx.pos===1&&!fx.setAttr){jQuery.style(fx.elem,prop,fx.end);fx.setAttr=true;}};});function getElementStyles(){var style=this.ownerDocument.defaultView?this.ownerDocument.defaultView.getComputedStyle(this,null):this.currentStyle,newStyle={},key,len;if(style&&style.length&&style[0]&&style[style[0]]){len=style.length;while(len--){key=style[len];if(typeof style[key]==="string"){newStyle[$.camelCase(key)]=style[key];}}}else{for(key in style){if(typeof style[key]==="string"){newStyle[key]=style[key];}}}
return newStyle;}
function styleDifference(oldStyle,newStyle){var diff={},name,value;for(name in newStyle){value=newStyle[name];if(oldStyle[name]!==value){if(!shorthandStyles[name]){if($.fx.step[name]||!isNaN(parseFloat(value))){diff[name]=value;}}}}
return diff;}
$.effects.animateClass=function(value,duration,easing,callback){var o=$.speed(duration,easing,callback);return this.queue(function(){var animated=$(this),baseClass=animated.attr("class")||"",applyClassChange,allAnimations=o.children?animated.find("*").andSelf():animated;allAnimations=allAnimations.map(function(){var el=$(this);return{el:el,start:getElementStyles.call(this)};});applyClassChange=function(){$.each(classAnimationActions,function(i,action){if(value[action]){animated[action+"Class"](value[action]);}});};applyClassChange();allAnimations=allAnimations.map(function(){this.end=getElementStyles.call(this.el[0]);this.diff=styleDifference(this.start,this.end);return this;});animated.attr("class",baseClass);allAnimations=allAnimations.map(function(){var styleInfo=this,dfd=$.Deferred(),opts=jQuery.extend({},o,{queue:false,complete:function(){dfd.resolve(styleInfo);}});this.el.animate(this.diff,opts);return dfd.promise();});$.when.apply($,allAnimations.get()).done(function(){applyClassChange();$.each(arguments,function(){var el=this.el;$.each(this.diff,function(key){el.css(key,'');});});o.complete.call(animated[0]);});});};$.fn.extend({_addClass:$.fn.addClass,addClass:function(classNames,speed,easing,callback){return speed?$.effects.animateClass.call(this,{add:classNames},speed,easing,callback):this._addClass(classNames);},_removeClass:$.fn.removeClass,removeClass:function(classNames,speed,easing,callback){return speed?$.effects.animateClass.call(this,{remove:classNames},speed,easing,callback):this._removeClass(classNames);},_toggleClass:$.fn.toggleClass,toggleClass:function(classNames,force,speed,easing,callback){if(typeof force==="boolean"||force===undefined){if(!speed){return this._toggleClass(classNames,force);}else{return $.effects.animateClass.call(this,(force?{add:classNames}:{remove:classNames}),speed,easing,callback);}}else{return $.effects.animateClass.call(this,{toggle:classNames},force,speed,easing);}},switchClass:function(remove,add,speed,easing,callback){return $.effects.animateClass.call(this,{add:add,remove:remove},speed,easing,callback);}});})();(function(){$.extend($.effects,{version:"1.9.2",save:function(element,set){for(var i=0;i<set.length;i++){if(set[i]!==null){element.data(dataSpace+set[i],element[0].style[set[i]]);}}},restore:function(element,set){var val,i;for(i=0;i<set.length;i++){if(set[i]!==null){val=element.data(dataSpace+set[i]);if(val===undefined){val="";}
element.css(set[i],val);}}},setMode:function(el,mode){if(mode==="toggle"){mode=el.is(":hidden")?"show":"hide";}
return mode;},getBaseline:function(origin,original){var y,x;switch(origin[0]){case"top":y=0;break;case"middle":y=0.5;break;case"bottom":y=1;break;default:y=origin[0]/original.height;}
switch(origin[1]){case"left":x=0;break;case"center":x=0.5;break;case"right":x=1;break;default:x=origin[1]/original.width;}
return{x:x,y:y};},createWrapper:function(element){if(element.parent().is(".ui-effects-wrapper")){return element.parent();}
var props={width:element.outerWidth(true),height:element.outerHeight(true),"float":element.css("float")},wrapper=$("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),size={width:element.width(),height:element.height()},active=document.activeElement;try{active.id;}catch(e){active=document.body;}
element.wrap(wrapper);if(element[0]===active||$.contains(element[0],active)){$(active).focus();}
wrapper=element.parent();if(element.css("position")==="static"){wrapper.css({position:"relative"});element.css({position:"relative"});}else{$.extend(props,{position:element.css("position"),zIndex:element.css("z-index")});$.each(["top","left","bottom","right"],function(i,pos){props[pos]=element.css(pos);if(isNaN(parseInt(props[pos],10))){props[pos]="auto";}});element.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"});}
element.css(size);return wrapper.css(props).show();},removeWrapper:function(element){var active=document.activeElement;if(element.parent().is(".ui-effects-wrapper")){element.parent().replaceWith(element);if(element[0]===active||$.contains(element[0],active)){$(active).focus();}}
return element;},setTransition:function(element,list,factor,value){value=value||{};$.each(list,function(i,x){var unit=element.cssUnit(x);if(unit[0]>0){value[x]=unit[0]*factor+unit[1];}});return value;}});function _normalizeArguments(effect,options,speed,callback){if($.isPlainObject(effect)){options=effect;effect=effect.effect;}
effect={effect:effect};if(options==null){options={};}
if($.isFunction(options)){callback=options;speed=null;options={};}
if(typeof options==="number"||$.fx.speeds[options]){callback=speed;speed=options;options={};}
if($.isFunction(speed)){callback=speed;speed=null;}
if(options){$.extend(effect,options);}
speed=speed||options.duration;effect.duration=$.fx.off?0:typeof speed==="number"?speed:speed in $.fx.speeds?$.fx.speeds[speed]:$.fx.speeds._default;effect.complete=callback||options.complete;return effect;}
function standardSpeed(speed){if(!speed||typeof speed==="number"||$.fx.speeds[speed]){return true;}
if(typeof speed==="string"&&!$.effects.effect[speed]){if(backCompat&&$.effects[speed]){return false;}
return true;}
return false;}
$.fn.extend({effect:function(){var args=_normalizeArguments.apply(this,arguments),mode=args.mode,queue=args.queue,effectMethod=$.effects.effect[args.effect],oldEffectMethod=!effectMethod&&backCompat&&$.effects[args.effect];if($.fx.off||!(effectMethod||oldEffectMethod)){if(mode){return this[mode](args.duration,args.complete);}else{return this.each(function(){if(args.complete){args.complete.call(this);}});}}
function run(next){var elem=$(this),complete=args.complete,mode=args.mode;function done(){if($.isFunction(complete)){complete.call(elem[0]);}
if($.isFunction(next)){next();}}
if(elem.is(":hidden")?mode==="hide":mode==="show"){done();}else{effectMethod.call(elem[0],args,done);}}
if(effectMethod){return queue===false?this.each(run):this.queue(queue||"fx",run);}else{return oldEffectMethod.call(this,{options:args,duration:args.duration,callback:args.complete,mode:args.mode});}},_show:$.fn.show,show:function(speed){if(standardSpeed(speed)){return this._show.apply(this,arguments);}else{var args=_normalizeArguments.apply(this,arguments);args.mode="show";return this.effect.call(this,args);}},_hide:$.fn.hide,hide:function(speed){if(standardSpeed(speed)){return this._hide.apply(this,arguments);}else{var args=_normalizeArguments.apply(this,arguments);args.mode="hide";return this.effect.call(this,args);}},__toggle:$.fn.toggle,toggle:function(speed){if(standardSpeed(speed)||typeof speed==="boolean"||$.isFunction(speed)){return this.__toggle.apply(this,arguments);}else{var args=_normalizeArguments.apply(this,arguments);args.mode="toggle";return this.effect.call(this,args);}},cssUnit:function(key){var style=this.css(key),val=[];$.each(["em","px","%","pt"],function(i,unit){if(style.indexOf(unit)>0){val=[parseFloat(style),unit];}});return val;}});})();(function(){var baseEasings={};$.each(["Quad","Cubic","Quart","Quint","Expo"],function(i,name){baseEasings[name]=function(p){return Math.pow(p,i+2);};});$.extend(baseEasings,{Sine:function(p){return 1-Math.cos(p*Math.PI/2);},Circ:function(p){return 1-Math.sqrt(1-p*p);},Elastic:function(p){return p===0||p===1?p:-Math.pow(2,8*(p-1))*Math.sin(((p-1)*80-7.5)*Math.PI/15);},Back:function(p){return p*p*(3*p-2);},Bounce:function(p){var pow2,bounce=4;while(p<((pow2=Math.pow(2,--bounce))-1)/11){}
return 1/Math.pow(4,3-bounce)-7.5625*Math.pow((pow2*3-2)/22-p,2);}});$.each(baseEasings,function(name,easeIn){$.easing["easeIn"+name]=easeIn;$.easing["easeOut"+name]=function(p){return 1-easeIn(1-p);};$.easing["easeInOut"+name]=function(p){return p<0.5?easeIn(p*2)/2:1-easeIn(p*-2+2)/2;};});})();})(jQuery));(function($,undefined){var rvertical=/up|down|vertical/,rpositivemotion=/up|left|vertical|horizontal/;$.effects.effect.blind=function(o,done){var el=$(this),props=["position","top","bottom","left","right","height","width"],mode=$.effects.setMode(el,o.mode||"hide"),direction=o.direction||"up",vertical=rvertical.test(direction),ref=vertical?"height":"width",ref2=vertical?"top":"left",motion=rpositivemotion.test(direction),animation={},show=mode==="show",wrapper,distance,margin;if(el.parent().is(".ui-effects-wrapper")){$.effects.save(el.parent(),props);}else{$.effects.save(el,props);}
el.show();wrapper=$.effects.createWrapper(el).css({overflow:"hidden"});distance=wrapper[ref]();margin=parseFloat(wrapper.css(ref2))||0;animation[ref]=show?distance:0;if(!motion){el.css(vertical?"bottom":"right",0).css(vertical?"top":"left","auto").css({position:"absolute"});animation[ref2]=show?margin:distance+margin;}
if(show){wrapper.css(ref,0);if(!motion){wrapper.css(ref2,margin+distance);}}
wrapper.animate(animation,{duration:o.duration,easing:o.easing,queue:false,complete:function(){if(mode==="hide"){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();}});};})(jQuery);(function($,undefined){$.effects.effect.bounce=function(o,done){var el=$(this),props=["position","top","bottom","left","right","height","width"],mode=$.effects.setMode(el,o.mode||"effect"),hide=mode==="hide",show=mode==="show",direction=o.direction||"up",distance=o.distance,times=o.times||5,anims=times*2+(show||hide?1:0),speed=o.duration/anims,easing=o.easing,ref=(direction==="up"||direction==="down")?"top":"left",motion=(direction==="up"||direction==="left"),i,upAnim,downAnim,queue=el.queue(),queuelen=queue.length;if(show||hide){props.push("opacity");}
$.effects.save(el,props);el.show();$.effects.createWrapper(el);if(!distance){distance=el[ref==="top"?"outerHeight":"outerWidth"]()/3;}
if(show){downAnim={opacity:1};downAnim[ref]=0;el.css("opacity",0).css(ref,motion?-distance*2:distance*2).animate(downAnim,speed,easing);}
if(hide){distance=distance/Math.pow(2,times-1);}
downAnim={};downAnim[ref]=0;for(i=0;i<times;i++){upAnim={};upAnim[ref]=(motion?"-=":"+=")+distance;el.animate(upAnim,speed,easing).animate(downAnim,speed,easing);distance=hide?distance*2:distance/2;}
if(hide){upAnim={opacity:0};upAnim[ref]=(motion?"-=":"+=")+distance;el.animate(upAnim,speed,easing);}
el.queue(function(){if(hide){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();});if(queuelen>1){queue.splice.apply(queue,[1,0].concat(queue.splice(queuelen,anims+1)));}
el.dequeue();};})(jQuery);(function($,undefined){$.effects.effect.clip=function(o,done){var el=$(this),props=["position","top","bottom","left","right","height","width"],mode=$.effects.setMode(el,o.mode||"hide"),show=mode==="show",direction=o.direction||"vertical",vert=direction==="vertical",size=vert?"height":"width",position=vert?"top":"left",animation={},wrapper,animate,distance;$.effects.save(el,props);el.show();wrapper=$.effects.createWrapper(el).css({overflow:"hidden"});animate=(el[0].tagName==="IMG")?wrapper:el;distance=animate[size]();if(show){animate.css(size,0);animate.css(position,distance/2);}
animation[size]=show?distance:0;animation[position]=show?0:distance/2;animate.animate(animation,{queue:false,duration:o.duration,easing:o.easing,complete:function(){if(!show){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();}});};})(jQuery);(function($,undefined){$.effects.effect.drop=function(o,done){var el=$(this),props=["position","top","bottom","left","right","opacity","height","width"],mode=$.effects.setMode(el,o.mode||"hide"),show=mode==="show",direction=o.direction||"left",ref=(direction==="up"||direction==="down")?"top":"left",motion=(direction==="up"||direction==="left")?"pos":"neg",animation={opacity:show?1:0},distance;$.effects.save(el,props);el.show();$.effects.createWrapper(el);distance=o.distance||el[ref==="top"?"outerHeight":"outerWidth"](true)/2;if(show){el.css("opacity",0).css(ref,motion==="pos"?-distance:distance);}
animation[ref]=(show?(motion==="pos"?"+=":"-="):(motion==="pos"?"-=":"+="))+
distance;el.animate(animation,{queue:false,duration:o.duration,easing:o.easing,complete:function(){if(mode==="hide"){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();}});};})(jQuery);(function($,undefined){$.effects.effect.explode=function(o,done){var rows=o.pieces?Math.round(Math.sqrt(o.pieces)):3,cells=rows,el=$(this),mode=$.effects.setMode(el,o.mode||"hide"),show=mode==="show",offset=el.show().css("visibility","hidden").offset(),width=Math.ceil(el.outerWidth()/cells),height=Math.ceil(el.outerHeight()/rows),pieces=[],i,j,left,top,mx,my;function childComplete(){pieces.push(this);if(pieces.length===rows*cells){animComplete();}}
for(i=0;i<rows;i++){top=offset.top+i*height;my=i-(rows-1)/2;for(j=0;j<cells;j++){left=offset.left+j*width;mx=j-(cells-1)/2;el.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",visibility:"visible",left:-j*width,top:-i*height}).parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:width,height:height,left:left+(show?mx*width:0),top:top+(show?my*height:0),opacity:show?0:1}).animate({left:left+(show?0:mx*width),top:top+(show?0:my*height),opacity:show?1:0},o.duration||500,o.easing,childComplete);}}
function animComplete(){el.css({visibility:"visible"});$(pieces).remove();if(!show){el.hide();}
done();}};})(jQuery);(function($,undefined){$.effects.effect.fade=function(o,done){var el=$(this),mode=$.effects.setMode(el,o.mode||"toggle");el.animate({opacity:mode},{queue:false,duration:o.duration,easing:o.easing,complete:done});};})(jQuery);(function($,undefined){$.effects.effect.fold=function(o,done){var el=$(this),props=["position","top","bottom","left","right","height","width"],mode=$.effects.setMode(el,o.mode||"hide"),show=mode==="show",hide=mode==="hide",size=o.size||15,percent=/([0-9]+)%/.exec(size),horizFirst=!!o.horizFirst,widthFirst=show!==horizFirst,ref=widthFirst?["width","height"]:["height","width"],duration=o.duration/2,wrapper,distance,animation1={},animation2={};$.effects.save(el,props);el.show();wrapper=$.effects.createWrapper(el).css({overflow:"hidden"});distance=widthFirst?[wrapper.width(),wrapper.height()]:[wrapper.height(),wrapper.width()];if(percent){size=parseInt(percent[1],10)/100*distance[hide?0:1];}
if(show){wrapper.css(horizFirst?{height:0,width:size}:{height:size,width:0});}
animation1[ref[0]]=show?distance[0]:size;animation2[ref[1]]=show?distance[1]:0;wrapper.animate(animation1,duration,o.easing).animate(animation2,duration,o.easing,function(){if(hide){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();});};})(jQuery);(function($,undefined){$.effects.effect.highlight=function(o,done){var elem=$(this),props=["backgroundImage","backgroundColor","opacity"],mode=$.effects.setMode(elem,o.mode||"show"),animation={backgroundColor:elem.css("backgroundColor")};if(mode==="hide"){animation.opacity=0;}
$.effects.save(elem,props);elem.show().css({backgroundImage:"none",backgroundColor:o.color||"#ffff99"}).animate(animation,{queue:false,duration:o.duration,easing:o.easing,complete:function(){if(mode==="hide"){elem.hide();}
$.effects.restore(elem,props);done();}});};})(jQuery);(function($,undefined){$.effects.effect.pulsate=function(o,done){var elem=$(this),mode=$.effects.setMode(elem,o.mode||"show"),show=mode==="show",hide=mode==="hide",showhide=(show||mode==="hide"),anims=((o.times||5)*2)+(showhide?1:0),duration=o.duration/anims,animateTo=0,queue=elem.queue(),queuelen=queue.length,i;if(show||!elem.is(":visible")){elem.css("opacity",0).show();animateTo=1;}
for(i=1;i<anims;i++){elem.animate({opacity:animateTo},duration,o.easing);animateTo=1-animateTo;}
elem.animate({opacity:animateTo},duration,o.easing);elem.queue(function(){if(hide){elem.hide();}
done();});if(queuelen>1){queue.splice.apply(queue,[1,0].concat(queue.splice(queuelen,anims+1)));}
elem.dequeue();};})(jQuery);(function($,undefined){$.effects.effect.puff=function(o,done){var elem=$(this),mode=$.effects.setMode(elem,o.mode||"hide"),hide=mode==="hide",percent=parseInt(o.percent,10)||150,factor=percent/100,original={height:elem.height(),width:elem.width(),outerHeight:elem.outerHeight(),outerWidth:elem.outerWidth()};$.extend(o,{effect:"scale",queue:false,fade:true,mode:mode,complete:done,percent:hide?percent:100,from:hide?original:{height:original.height*factor,width:original.width*factor,outerHeight:original.outerHeight*factor,outerWidth:original.outerWidth*factor}});elem.effect(o);};$.effects.effect.scale=function(o,done){var el=$(this),options=$.extend(true,{},o),mode=$.effects.setMode(el,o.mode||"effect"),percent=parseInt(o.percent,10)||(parseInt(o.percent,10)===0?0:(mode==="hide"?0:100)),direction=o.direction||"both",origin=o.origin,original={height:el.height(),width:el.width(),outerHeight:el.outerHeight(),outerWidth:el.outerWidth()},factor={y:direction!=="horizontal"?(percent/100):1,x:direction!=="vertical"?(percent/100):1};options.effect="size";options.queue=false;options.complete=done;if(mode!=="effect"){options.origin=origin||["middle","center"];options.restore=true;}
options.from=o.from||(mode==="show"?{height:0,width:0,outerHeight:0,outerWidth:0}:original);options.to={height:original.height*factor.y,width:original.width*factor.x,outerHeight:original.outerHeight*factor.y,outerWidth:original.outerWidth*factor.x};if(options.fade){if(mode==="show"){options.from.opacity=0;options.to.opacity=1;}
if(mode==="hide"){options.from.opacity=1;options.to.opacity=0;}}
el.effect(options);};$.effects.effect.size=function(o,done){var original,baseline,factor,el=$(this),props0=["position","top","bottom","left","right","width","height","overflow","opacity"],props1=["position","top","bottom","left","right","overflow","opacity"],props2=["width","height","overflow"],cProps=["fontSize"],vProps=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],hProps=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],mode=$.effects.setMode(el,o.mode||"effect"),restore=o.restore||mode!=="effect",scale=o.scale||"both",origin=o.origin||["middle","center"],position=el.css("position"),props=restore?props0:props1,zero={height:0,width:0,outerHeight:0,outerWidth:0};if(mode==="show"){el.show();}
original={height:el.height(),width:el.width(),outerHeight:el.outerHeight(),outerWidth:el.outerWidth()};if(o.mode==="toggle"&&mode==="show"){el.from=o.to||zero;el.to=o.from||original;}else{el.from=o.from||(mode==="show"?zero:original);el.to=o.to||(mode==="hide"?zero:original);}
factor={from:{y:el.from.height/original.height,x:el.from.width/original.width},to:{y:el.to.height/original.height,x:el.to.width/original.width}};if(scale==="box"||scale==="both"){if(factor.from.y!==factor.to.y){props=props.concat(vProps);el.from=$.effects.setTransition(el,vProps,factor.from.y,el.from);el.to=$.effects.setTransition(el,vProps,factor.to.y,el.to);}
if(factor.from.x!==factor.to.x){props=props.concat(hProps);el.from=$.effects.setTransition(el,hProps,factor.from.x,el.from);el.to=$.effects.setTransition(el,hProps,factor.to.x,el.to);}}
if(scale==="content"||scale==="both"){if(factor.from.y!==factor.to.y){props=props.concat(cProps).concat(props2);el.from=$.effects.setTransition(el,cProps,factor.from.y,el.from);el.to=$.effects.setTransition(el,cProps,factor.to.y,el.to);}}
$.effects.save(el,props);el.show();$.effects.createWrapper(el);el.css("overflow","hidden").css(el.from);if(origin){baseline=$.effects.getBaseline(origin,original);el.from.top=(original.outerHeight-el.outerHeight())*baseline.y;el.from.left=(original.outerWidth-el.outerWidth())*baseline.x;el.to.top=(original.outerHeight-el.to.outerHeight)*baseline.y;el.to.left=(original.outerWidth-el.to.outerWidth)*baseline.x;}
el.css(el.from);if(scale==="content"||scale==="both"){vProps=vProps.concat(["marginTop","marginBottom"]).concat(cProps);hProps=hProps.concat(["marginLeft","marginRight"]);props2=props0.concat(vProps).concat(hProps);el.find("*[width]").each(function(){var child=$(this),c_original={height:child.height(),width:child.width(),outerHeight:child.outerHeight(),outerWidth:child.outerWidth()};if(restore){$.effects.save(child,props2);}
child.from={height:c_original.height*factor.from.y,width:c_original.width*factor.from.x,outerHeight:c_original.outerHeight*factor.from.y,outerWidth:c_original.outerWidth*factor.from.x};child.to={height:c_original.height*factor.to.y,width:c_original.width*factor.to.x,outerHeight:c_original.height*factor.to.y,outerWidth:c_original.width*factor.to.x};if(factor.from.y!==factor.to.y){child.from=$.effects.setTransition(child,vProps,factor.from.y,child.from);child.to=$.effects.setTransition(child,vProps,factor.to.y,child.to);}
if(factor.from.x!==factor.to.x){child.from=$.effects.setTransition(child,hProps,factor.from.x,child.from);child.to=$.effects.setTransition(child,hProps,factor.to.x,child.to);}
child.css(child.from);child.animate(child.to,o.duration,o.easing,function(){if(restore){$.effects.restore(child,props2);}});});}
el.animate(el.to,{queue:false,duration:o.duration,easing:o.easing,complete:function(){if(el.to.opacity===0){el.css("opacity",el.from.opacity);}
if(mode==="hide"){el.hide();}
$.effects.restore(el,props);if(!restore){if(position==="static"){el.css({position:"relative",top:el.to.top,left:el.to.left});}else{$.each(["top","left"],function(idx,pos){el.css(pos,function(_,str){var val=parseInt(str,10),toRef=idx?el.to.left:el.to.top;if(str==="auto"){return toRef+"px";}
return val+toRef+"px";});});}}
$.effects.removeWrapper(el);done();}});};})(jQuery);(function($,undefined){$.effects.effect.shake=function(o,done){var el=$(this),props=["position","top","bottom","left","right","height","width"],mode=$.effects.setMode(el,o.mode||"effect"),direction=o.direction||"left",distance=o.distance||20,times=o.times||3,anims=times*2+1,speed=Math.round(o.duration/anims),ref=(direction==="up"||direction==="down")?"top":"left",positiveMotion=(direction==="up"||direction==="left"),animation={},animation1={},animation2={},i,queue=el.queue(),queuelen=queue.length;$.effects.save(el,props);el.show();$.effects.createWrapper(el);animation[ref]=(positiveMotion?"-=":"+=")+distance;animation1[ref]=(positiveMotion?"+=":"-=")+distance*2;animation2[ref]=(positiveMotion?"-=":"+=")+distance*2;el.animate(animation,speed,o.easing);for(i=1;i<times;i++){el.animate(animation1,speed,o.easing).animate(animation2,speed,o.easing);}
el.animate(animation1,speed,o.easing).animate(animation,speed/2,o.easing).queue(function(){if(mode==="hide"){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();});if(queuelen>1){queue.splice.apply(queue,[1,0].concat(queue.splice(queuelen,anims+1)));}
el.dequeue();};})(jQuery);(function($,undefined){$.effects.effect.slide=function(o,done){var el=$(this),props=["position","top","bottom","left","right","width","height"],mode=$.effects.setMode(el,o.mode||"show"),show=mode==="show",direction=o.direction||"left",ref=(direction==="up"||direction==="down")?"top":"left",positiveMotion=(direction==="up"||direction==="left"),distance,animation={};$.effects.save(el,props);el.show();distance=o.distance||el[ref==="top"?"outerHeight":"outerWidth"](true);$.effects.createWrapper(el).css({overflow:"hidden"});if(show){el.css(ref,positiveMotion?(isNaN(distance)?"-"+distance:-distance):distance);}
animation[ref]=(show?(positiveMotion?"+=":"-="):(positiveMotion?"-=":"+="))+
distance;el.animate(animation,{queue:false,duration:o.duration,easing:o.easing,complete:function(){if(mode==="hide"){el.hide();}
$.effects.restore(el,props);$.effects.removeWrapper(el);done();}});};})(jQuery);(function($,undefined){$.effects.effect.transfer=function(o,done){var elem=$(this),target=$(o.to),targetFixed=target.css("position")==="fixed",body=$("body"),fixTop=targetFixed?body.scrollTop():0,fixLeft=targetFixed?body.scrollLeft():0,endPosition=target.offset(),animation={top:endPosition.top-fixTop,left:endPosition.left-fixLeft,height:target.innerHeight(),width:target.innerWidth()},startPosition=elem.offset(),transfer=$('<div class="ui-effects-transfer"></div>').appendTo(document.body).addClass(o.className).css({top:startPosition.top-fixTop,left:startPosition.left-fixLeft,height:elem.innerHeight(),width:elem.innerWidth(),position:targetFixed?"fixed":"absolute"}).animate(animation,o.duration,o.easing,function(){transfer.remove();done();});};})(jQuery);(function($,undefined){var mouseHandled=false;$.widget("ui.menu",{version:"1.9.2",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-carat-1-e"},menus:"ul",position:{my:"left top",at:"right top"},role:"menu",blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element;this.element.uniqueId().addClass("ui-menu ui-widget ui-widget-content ui-corner-all").toggleClass("ui-menu-icons",!!this.element.find(".ui-icon").length).attr({role:this.options.role,tabIndex:0}).bind("click"+this.eventNamespace,$.proxy(function(event){if(this.options.disabled){event.preventDefault();}},this));if(this.options.disabled){this.element.addClass("ui-state-disabled").attr("aria-disabled","true");}
this._on({"mousedown .ui-menu-item > a":function(event){event.preventDefault();},"click .ui-state-disabled > a":function(event){event.preventDefault();},"click .ui-menu-item:has(a)":function(event){var target=$(event.target).closest(".ui-menu-item");if(!mouseHandled&&target.not(".ui-state-disabled").length){mouseHandled=true;this.select(event);if(target.has(".ui-menu").length){this.expand(event);}else if(!this.element.is(":focus")){this.element.trigger("focus",[true]);if(this.active&&this.active.parents(".ui-menu").length===1){clearTimeout(this.timer);}}}},"mouseenter .ui-menu-item":function(event){var target=$(event.currentTarget);target.siblings().children(".ui-state-active").removeClass("ui-state-active");this.focus(event,target);},mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function(event,keepActiveItem){var item=this.active||this.element.children(".ui-menu-item").eq(0);if(!keepActiveItem){this.focus(event,item);}},blur:function(event){this._delay(function(){if(!$.contains(this.element[0],this.document[0].activeElement)){this.collapseAll(event);}});},keydown:"_keydown"});this.refresh();this._on(this.document,{click:function(event){if(!$(event.target).closest(".ui-menu").length){this.collapseAll(event);}
mouseHandled=false;}});},_destroy:function(){this.element.removeAttr("aria-activedescendant").find(".ui-menu").andSelf().removeClass("ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons").removeAttr("role").removeAttr("tabIndex").removeAttr("aria-labelledby").removeAttr("aria-expanded").removeAttr("aria-hidden").removeAttr("aria-disabled").removeUniqueId().show();this.element.find(".ui-menu-item").removeClass("ui-menu-item").removeAttr("role").removeAttr("aria-disabled").children("a").removeUniqueId().removeClass("ui-corner-all ui-state-hover").removeAttr("tabIndex").removeAttr("role").removeAttr("aria-haspopup").children().each(function(){var elem=$(this);if(elem.data("ui-menu-submenu-carat")){elem.remove();}});this.element.find(".ui-menu-divider").removeClass("ui-menu-divider ui-widget-content");},_keydown:function(event){var match,prev,character,skip,regex,preventDefault=true;function escape(value){return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&");}
switch(event.keyCode){case $.ui.keyCode.PAGE_UP:this.previousPage(event);break;case $.ui.keyCode.PAGE_DOWN:this.nextPage(event);break;case $.ui.keyCode.HOME:this._move("first","first",event);break;case $.ui.keyCode.END:this._move("last","last",event);break;case $.ui.keyCode.UP:this.previous(event);break;case $.ui.keyCode.DOWN:this.next(event);break;case $.ui.keyCode.LEFT:this.collapse(event);break;case $.ui.keyCode.RIGHT:if(this.active&&!this.active.is(".ui-state-disabled")){this.expand(event);}
break;case $.ui.keyCode.ENTER:case $.ui.keyCode.SPACE:this._activate(event);break;case $.ui.keyCode.ESCAPE:this.collapse(event);break;default:preventDefault=false;prev=this.previousFilter||"";character=String.fromCharCode(event.keyCode);skip=false;clearTimeout(this.filterTimer);if(character===prev){skip=true;}else{character=prev+character;}
regex=new RegExp("^"+escape(character),"i");match=this.activeMenu.children(".ui-menu-item").filter(function(){return regex.test($(this).children("a").text());});match=skip&&match.index(this.active.next())!==-1?this.active.nextAll(".ui-menu-item"):match;if(!match.length){character=String.fromCharCode(event.keyCode);regex=new RegExp("^"+escape(character),"i");match=this.activeMenu.children(".ui-menu-item").filter(function(){return regex.test($(this).children("a").text());});}
if(match.length){this.focus(event,match);if(match.length>1){this.previousFilter=character;this.filterTimer=this._delay(function(){delete this.previousFilter;},1000);}else{delete this.previousFilter;}}else{delete this.previousFilter;}}
if(preventDefault){event.preventDefault();}},_activate:function(event){if(!this.active.is(".ui-state-disabled")){if(this.active.children("a[aria-haspopup='true']").length){this.expand(event);}else{this.select(event);}}},refresh:function(){var menus,icon=this.options.icons.submenu,submenus=this.element.find(this.options.menus);submenus.filter(":not(.ui-menu)").addClass("ui-menu ui-widget ui-widget-content ui-corner-all").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var menu=$(this),item=menu.prev("a"),submenuCarat=$("<span>").addClass("ui-menu-icon ui-icon "+icon).data("ui-menu-submenu-carat",true);item.attr("aria-haspopup","true").prepend(submenuCarat);menu.attr("aria-labelledby",item.attr("id"));});menus=submenus.add(this.element);menus.children(":not(.ui-menu-item):has(a)").addClass("ui-menu-item").attr("role","presentation").children("a").uniqueId().addClass("ui-corner-all").attr({tabIndex:-1,role:this._itemRole()});menus.children(":not(.ui-menu-item)").each(function(){var item=$(this);if(!/[^\-—–\s]/.test(item.text())){item.addClass("ui-widget-content ui-menu-divider");}});menus.children(".ui-state-disabled").attr("aria-disabled","true");if(this.active&&!$.contains(this.element[0],this.active[0])){this.blur();}},_itemRole:function(){return{menu:"menuitem",listbox:"option"}[this.options.role];},focus:function(event,item){var nested,focused;this.blur(event,event&&event.type==="focus");this._scrollIntoView(item);this.active=item.first();focused=this.active.children("a").addClass("ui-state-focus");if(this.options.role){this.element.attr("aria-activedescendant",focused.attr("id"));}
this.active.parent().closest(".ui-menu-item").children("a:first").addClass("ui-state-active");if(event&&event.type==="keydown"){this._close();}else{this.timer=this._delay(function(){this._close();},this.delay);}
nested=item.children(".ui-menu");if(nested.length&&(/^mouse/.test(event.type))){this._startOpening(nested);}
this.activeMenu=item.parent();this._trigger("focus",event,{item:item});},_scrollIntoView:function(item){var borderTop,paddingTop,offset,scroll,elementHeight,itemHeight;if(this._hasScroll()){borderTop=parseFloat($.css(this.activeMenu[0],"borderTopWidth"))||0;paddingTop=parseFloat($.css(this.activeMenu[0],"paddingTop"))||0;offset=item.offset().top-this.activeMenu.offset().top-borderTop-paddingTop;scroll=this.activeMenu.scrollTop();elementHeight=this.activeMenu.height();itemHeight=item.height();if(offset<0){this.activeMenu.scrollTop(scroll+offset);}else if(offset+itemHeight>elementHeight){this.activeMenu.scrollTop(scroll+offset-elementHeight+itemHeight);}}},blur:function(event,fromFocus){if(!fromFocus){clearTimeout(this.timer);}
if(!this.active){return;}
this.active.children("a").removeClass("ui-state-focus");this.active=null;this._trigger("blur",event,{item:this.active});},_startOpening:function(submenu){clearTimeout(this.timer);if(submenu.attr("aria-hidden")!=="true"){return;}
this.timer=this._delay(function(){this._close();this._open(submenu);},this.delay);},_open:function(submenu){var position=$.extend({of:this.active},this.options.position);clearTimeout(this.timer);this.element.find(".ui-menu").not(submenu.parents(".ui-menu")).hide().attr("aria-hidden","true");submenu.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(position);},collapseAll:function(event,all){clearTimeout(this.timer);this.timer=this._delay(function(){var currentMenu=all?this.element:$(event&&event.target).closest(this.element.find(".ui-menu"));if(!currentMenu.length){currentMenu=this.element;}
this._close(currentMenu);this.blur(event);this.activeMenu=currentMenu;},this.delay);},_close:function(startMenu){if(!startMenu){startMenu=this.active?this.active.parent():this.element;}
startMenu.find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false").end().find("a.ui-state-active").removeClass("ui-state-active");},collapse:function(event){var newItem=this.active&&this.active.parent().closest(".ui-menu-item",this.element);if(newItem&&newItem.length){this._close();this.focus(event,newItem);}},expand:function(event){var newItem=this.active&&this.active.children(".ui-menu ").children(".ui-menu-item").first();if(newItem&&newItem.length){this._open(newItem.parent());this._delay(function(){this.focus(event,newItem);});}},next:function(event){this._move("next","first",event);},previous:function(event){this._move("prev","last",event);},isFirstItem:function(){return this.active&&!this.active.prevAll(".ui-menu-item").length;},isLastItem:function(){return this.active&&!this.active.nextAll(".ui-menu-item").length;},_move:function(direction,filter,event){var next;if(this.active){if(direction==="first"||direction==="last"){next=this.active
[direction==="first"?"prevAll":"nextAll"](".ui-menu-item").eq(-1);}else{next=this.active
[direction+"All"](".ui-menu-item").eq(0);}}
if(!next||!next.length||!this.active){next=this.activeMenu.children(".ui-menu-item")[filter]();}
this.focus(event,next);},nextPage:function(event){var item,base,height;if(!this.active){this.next(event);return;}
if(this.isLastItem()){return;}
if(this._hasScroll()){base=this.active.offset().top;height=this.element.height();this.active.nextAll(".ui-menu-item").each(function(){item=$(this);return item.offset().top-base-height<0;});this.focus(event,item);}else{this.focus(event,this.activeMenu.children(".ui-menu-item")
[!this.active?"first":"last"]());}},previousPage:function(event){var item,base,height;if(!this.active){this.next(event);return;}
if(this.isFirstItem()){return;}
if(this._hasScroll()){base=this.active.offset().top;height=this.element.height();this.active.prevAll(".ui-menu-item").each(function(){item=$(this);return item.offset().top-base+height>0;});this.focus(event,item);}else{this.focus(event,this.activeMenu.children(".ui-menu-item").first());}},_hasScroll:function(){return this.element.outerHeight()<this.element.prop("scrollHeight");},select:function(event){this.active=this.active||$(event.target).closest(".ui-menu-item");var ui={item:this.active};if(!this.active.has(".ui-menu").length){this.collapseAll(event,true);}
this._trigger("select",event,ui);}});}(jQuery));(function($,undefined){$.widget("ui.progressbar",{version:"1.9.2",options:{value:0,max:100},min:0,_create:function(){this.element.addClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").attr({role:"progressbar","aria-valuemin":this.min,"aria-valuemax":this.options.max,"aria-valuenow":this._value()});this.valueDiv=$("<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>").appendTo(this.element);this.oldValue=this._value();this._refreshValue();},_destroy:function(){this.element.removeClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow");this.valueDiv.remove();},value:function(newValue){if(newValue===undefined){return this._value();}
this._setOption("value",newValue);return this;},_setOption:function(key,value){if(key==="value"){this.options.value=value;this._refreshValue();if(this._value()===this.options.max){this._trigger("complete");}}
this._super(key,value);},_value:function(){var val=this.options.value;if(typeof val!=="number"){val=0;}
return Math.min(this.options.max,Math.max(this.min,val));},_percentage:function(){return 100*this._value()/this.options.max;},_refreshValue:function(){var value=this.value(),percentage=this._percentage();if(this.oldValue!==value){this.oldValue=value;this._trigger("change");}
this.valueDiv.toggle(value>this.min).toggleClass("ui-corner-right",value===this.options.max).width(percentage.toFixed(0)+"%");this.element.attr("aria-valuenow",value);}});})(jQuery);(function($,undefined){$.widget("ui.resizable",$.ui.mouse,{version:"1.9.2",widgetEventPrefix:"resize",options:{alsoResize:false,animate:false,animateDuration:"slow",animateEasing:"swing",aspectRatio:false,autoHide:false,containment:false,ghost:false,grid:false,handles:"e,s,se",helper:false,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:1000},_create:function(){var that=this,o=this.options;this.element.addClass("ui-resizable");$.extend(this,{_aspectRatio:!!(o.aspectRatio),aspectRatio:o.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:o.helper||o.ghost||o.animate?o.helper||'ui-resizable-helper':null});if(this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)){this.element.wrap($('<div class="ui-wrapper" style="overflow: hidden;"></div>').css({position:this.element.css('position'),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css('top'),left:this.element.css('left')}));this.element=this.element.parent().data("resizable",this.element.data('resizable'));this.elementIsWrapper=true;this.element.css({marginLeft:this.originalElement.css("marginLeft"),marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom")});this.originalElement.css({marginLeft:0,marginTop:0,marginRight:0,marginBottom:0});this.originalResizeStyle=this.originalElement.css('resize');this.originalElement.css('resize','none');this._proportionallyResizeElements.push(this.originalElement.css({position:'static',zoom:1,display:'block'}));this.originalElement.css({margin:this.originalElement.css('margin')});this._proportionallyResize();}
this.handles=o.handles||(!$('.ui-resizable-handle',this.element).length?"e,s,se":{n:'.ui-resizable-n',e:'.ui-resizable-e',s:'.ui-resizable-s',w:'.ui-resizable-w',se:'.ui-resizable-se',sw:'.ui-resizable-sw',ne:'.ui-resizable-ne',nw:'.ui-resizable-nw'});if(this.handles.constructor==String){if(this.handles=='all')this.handles='n,e,s,w,se,sw,ne,nw';var n=this.handles.split(",");this.handles={};for(var i=0;i<n.length;i++){var handle=$.trim(n[i]),hname='ui-resizable-'+handle;var axis=$('<div class="ui-resizable-handle '+hname+'"></div>');axis.css({zIndex:o.zIndex});if('se'==handle){axis.addClass('ui-icon ui-icon-gripsmall-diagonal-se');};this.handles[handle]='.ui-resizable-'+handle;this.element.append(axis);}}
this._renderAxis=function(target){target=target||this.element;for(var i in this.handles){if(this.handles[i].constructor==String)
this.handles[i]=$(this.handles[i],this.element).show();if(this.elementIsWrapper&&this.originalElement[0].nodeName.match(/textarea|input|select|button/i)){var axis=$(this.handles[i],this.element),padWrapper=0;padWrapper=/sw|ne|nw|se|n|s/.test(i)?axis.outerHeight():axis.outerWidth();var padPos=['padding',/ne|nw|n/.test(i)?'Top':/se|sw|s/.test(i)?'Bottom':/^e$/.test(i)?'Right':'Left'].join("");target.css(padPos,padWrapper);this._proportionallyResize();}
if(!$(this.handles[i]).length)
continue;}};this._renderAxis(this.element);this._handles=$('.ui-resizable-handle',this.element).disableSelection();this._handles.mouseover(function(){if(!that.resizing){if(this.className)
var axis=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);that.axis=axis&&axis[1]?axis[1]:'se';}});if(o.autoHide){this._handles.hide();$(this.element).addClass("ui-resizable-autohide").mouseenter(function(){if(o.disabled)return;$(this).removeClass("ui-resizable-autohide");that._handles.show();}).mouseleave(function(){if(o.disabled)return;if(!that.resizing){$(this).addClass("ui-resizable-autohide");that._handles.hide();}});}
this._mouseInit();},_destroy:function(){this._mouseDestroy();var _destroy=function(exp){$(exp).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing").removeData("resizable").removeData("ui-resizable").unbind(".resizable").find('.ui-resizable-handle').remove();};if(this.elementIsWrapper){_destroy(this.element);var wrapper=this.element;this.originalElement.css({position:wrapper.css('position'),width:wrapper.outerWidth(),height:wrapper.outerHeight(),top:wrapper.css('top'),left:wrapper.css('left')}).insertAfter(wrapper);wrapper.remove();}
this.originalElement.css('resize',this.originalResizeStyle);_destroy(this.originalElement);return this;},_mouseCapture:function(event){var handle=false;for(var i in this.handles){if($(this.handles[i])[0]==event.target){handle=true;}}
return!this.options.disabled&&handle;},_mouseStart:function(event){var o=this.options,iniPos=this.element.position(),el=this.element;this.resizing=true;this.documentScroll={top:$(document).scrollTop(),left:$(document).scrollLeft()};if(el.is('.ui-draggable')||(/absolute/).test(el.css('position'))){el.css({position:'absolute',top:iniPos.top,left:iniPos.left});}
this._renderProxy();var curleft=num(this.helper.css('left')),curtop=num(this.helper.css('top'));if(o.containment){curleft+=$(o.containment).scrollLeft()||0;curtop+=$(o.containment).scrollTop()||0;}
this.offset=this.helper.offset();this.position={left:curleft,top:curtop};this.size=this._helper?{width:el.outerWidth(),height:el.outerHeight()}:{width:el.width(),height:el.height()};this.originalSize=this._helper?{width:el.outerWidth(),height:el.outerHeight()}:{width:el.width(),height:el.height()};this.originalPosition={left:curleft,top:curtop};this.sizeDiff={width:el.outerWidth()-el.width(),height:el.outerHeight()-el.height()};this.originalMousePosition={left:event.pageX,top:event.pageY};this.aspectRatio=(typeof o.aspectRatio=='number')?o.aspectRatio:((this.originalSize.width/this.originalSize.height)||1);var cursor=$('.ui-resizable-'+this.axis).css('cursor');$('body').css('cursor',cursor=='auto'?this.axis+'-resize':cursor);el.addClass("ui-resizable-resizing");this._propagate("start",event);return true;},_mouseDrag:function(event){var el=this.helper,o=this.options,props={},that=this,smp=this.originalMousePosition,a=this.axis;var dx=(event.pageX-smp.left)||0,dy=(event.pageY-smp.top)||0;var trigger=this._change[a];if(!trigger)return false;var data=trigger.apply(this,[event,dx,dy]);this._updateVirtualBoundaries(event.shiftKey);if(this._aspectRatio||event.shiftKey)
data=this._updateRatio(data,event);data=this._respectSize(data,event);this._propagate("resize",event);el.css({top:this.position.top+"px",left:this.position.left+"px",width:this.size.width+"px",height:this.size.height+"px"});if(!this._helper&&this._proportionallyResizeElements.length)
this._proportionallyResize();this._updateCache(data);this._trigger('resize',event,this.ui());return false;},_mouseStop:function(event){this.resizing=false;var o=this.options,that=this;if(this._helper){var pr=this._proportionallyResizeElements,ista=pr.length&&(/textarea/i).test(pr[0].nodeName),soffseth=ista&&$.ui.hasScroll(pr[0],'left')?0:that.sizeDiff.height,soffsetw=ista?0:that.sizeDiff.width;var s={width:(that.helper.width()-soffsetw),height:(that.helper.height()-soffseth)},left=(parseInt(that.element.css('left'),10)+(that.position.left-that.originalPosition.left))||null,top=(parseInt(that.element.css('top'),10)+(that.position.top-that.originalPosition.top))||null;if(!o.animate)
this.element.css($.extend(s,{top:top,left:left}));that.helper.height(that.size.height);that.helper.width(that.size.width);if(this._helper&&!o.animate)this._proportionallyResize();}
$('body').css('cursor','auto');this.element.removeClass("ui-resizable-resizing");this._propagate("stop",event);if(this._helper)this.helper.remove();return false;},_updateVirtualBoundaries:function(forceAspectRatio){var o=this.options,pMinWidth,pMaxWidth,pMinHeight,pMaxHeight,b;b={minWidth:isNumber(o.minWidth)?o.minWidth:0,maxWidth:isNumber(o.maxWidth)?o.maxWidth:Infinity,minHeight:isNumber(o.minHeight)?o.minHeight:0,maxHeight:isNumber(o.maxHeight)?o.maxHeight:Infinity};if(this._aspectRatio||forceAspectRatio){pMinWidth=b.minHeight*this.aspectRatio;pMinHeight=b.minWidth/this.aspectRatio;pMaxWidth=b.maxHeight*this.aspectRatio;pMaxHeight=b.maxWidth/this.aspectRatio;if(pMinWidth>b.minWidth)b.minWidth=pMinWidth;if(pMinHeight>b.minHeight)b.minHeight=pMinHeight;if(pMaxWidth<b.maxWidth)b.maxWidth=pMaxWidth;if(pMaxHeight<b.maxHeight)b.maxHeight=pMaxHeight;}
this._vBoundaries=b;},_updateCache:function(data){var o=this.options;this.offset=this.helper.offset();if(isNumber(data.left))this.position.left=data.left;if(isNumber(data.top))this.position.top=data.top;if(isNumber(data.height))this.size.height=data.height;if(isNumber(data.width))this.size.width=data.width;},_updateRatio:function(data,event){var o=this.options,cpos=this.position,csize=this.size,a=this.axis;if(isNumber(data.height))data.width=(data.height*this.aspectRatio);else if(isNumber(data.width))data.height=(data.width/this.aspectRatio);if(a=='sw'){data.left=cpos.left+(csize.width-data.width);data.top=null;}
if(a=='nw'){data.top=cpos.top+(csize.height-data.height);data.left=cpos.left+(csize.width-data.width);}
return data;},_respectSize:function(data,event){var el=this.helper,o=this._vBoundaries,pRatio=this._aspectRatio||event.shiftKey,a=this.axis,ismaxw=isNumber(data.width)&&o.maxWidth&&(o.maxWidth<data.width),ismaxh=isNumber(data.height)&&o.maxHeight&&(o.maxHeight<data.height),isminw=isNumber(data.width)&&o.minWidth&&(o.minWidth>data.width),isminh=isNumber(data.height)&&o.minHeight&&(o.minHeight>data.height);if(isminw)data.width=o.minWidth;if(isminh)data.height=o.minHeight;if(ismaxw)data.width=o.maxWidth;if(ismaxh)data.height=o.maxHeight;var dw=this.originalPosition.left+this.originalSize.width,dh=this.position.top+this.size.height;var cw=/sw|nw|w/.test(a),ch=/nw|ne|n/.test(a);if(isminw&&cw)data.left=dw-o.minWidth;if(ismaxw&&cw)data.left=dw-o.maxWidth;if(isminh&&ch)data.top=dh-o.minHeight;if(ismaxh&&ch)data.top=dh-o.maxHeight;var isNotwh=!data.width&&!data.height;if(isNotwh&&!data.left&&data.top)data.top=null;else if(isNotwh&&!data.top&&data.left)data.left=null;return data;},_proportionallyResize:function(){var o=this.options;if(!this._proportionallyResizeElements.length)return;var element=this.helper||this.element;for(var i=0;i<this._proportionallyResizeElements.length;i++){var prel=this._proportionallyResizeElements[i];if(!this.borderDif){var b=[prel.css('borderTopWidth'),prel.css('borderRightWidth'),prel.css('borderBottomWidth'),prel.css('borderLeftWidth')],p=[prel.css('paddingTop'),prel.css('paddingRight'),prel.css('paddingBottom'),prel.css('paddingLeft')];this.borderDif=$.map(b,function(v,i){var border=parseInt(v,10)||0,padding=parseInt(p[i],10)||0;return border+padding;});}
prel.css({height:(element.height()-this.borderDif[0]-this.borderDif[2])||0,width:(element.width()-this.borderDif[1]-this.borderDif[3])||0});};},_renderProxy:function(){var el=this.element,o=this.options;this.elementOffset=el.offset();if(this._helper){this.helper=this.helper||$('<div style="overflow:hidden;"></div>');var ie6offset=($.ui.ie6?1:0),pxyoffset=($.ui.ie6?2:-1);this.helper.addClass(this._helper).css({width:this.element.outerWidth()+pxyoffset,height:this.element.outerHeight()+pxyoffset,position:'absolute',left:this.elementOffset.left-ie6offset+'px',top:this.elementOffset.top-ie6offset+'px',zIndex:++o.zIndex});this.helper.appendTo("body").disableSelection();}else{this.helper=this.element;}},_change:{e:function(event,dx,dy){return{width:this.originalSize.width+dx};},w:function(event,dx,dy){var o=this.options,cs=this.originalSize,sp=this.originalPosition;return{left:sp.left+dx,width:cs.width-dx};},n:function(event,dx,dy){var o=this.options,cs=this.originalSize,sp=this.originalPosition;return{top:sp.top+dy,height:cs.height-dy};},s:function(event,dx,dy){return{height:this.originalSize.height+dy};},se:function(event,dx,dy){return $.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[event,dx,dy]));},sw:function(event,dx,dy){return $.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[event,dx,dy]));},ne:function(event,dx,dy){return $.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[event,dx,dy]));},nw:function(event,dx,dy){return $.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[event,dx,dy]));}},_propagate:function(n,event){$.ui.plugin.call(this,n,[event,this.ui()]);(n!="resize"&&this._trigger(n,event,this.ui()));},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition};}});$.ui.plugin.add("resizable","alsoResize",{start:function(event,ui){var that=$(this).data("resizable"),o=that.options;var _store=function(exp){$(exp).each(function(){var el=$(this);el.data("resizable-alsoresize",{width:parseInt(el.width(),10),height:parseInt(el.height(),10),left:parseInt(el.css('left'),10),top:parseInt(el.css('top'),10)});});};if(typeof(o.alsoResize)=='object'&&!o.alsoResize.parentNode){if(o.alsoResize.length){o.alsoResize=o.alsoResize[0];_store(o.alsoResize);}
else{$.each(o.alsoResize,function(exp){_store(exp);});}}else{_store(o.alsoResize);}},resize:function(event,ui){var that=$(this).data("resizable"),o=that.options,os=that.originalSize,op=that.originalPosition;var delta={height:(that.size.height-os.height)||0,width:(that.size.width-os.width)||0,top:(that.position.top-op.top)||0,left:(that.position.left-op.left)||0},_alsoResize=function(exp,c){$(exp).each(function(){var el=$(this),start=$(this).data("resizable-alsoresize"),style={},css=c&&c.length?c:el.parents(ui.originalElement[0]).length?['width','height']:['width','height','top','left'];$.each(css,function(i,prop){var sum=(start[prop]||0)+(delta[prop]||0);if(sum&&sum>=0)
style[prop]=sum||null;});el.css(style);});};if(typeof(o.alsoResize)=='object'&&!o.alsoResize.nodeType){$.each(o.alsoResize,function(exp,c){_alsoResize(exp,c);});}else{_alsoResize(o.alsoResize);}},stop:function(event,ui){$(this).removeData("resizable-alsoresize");}});$.ui.plugin.add("resizable","animate",{stop:function(event,ui){var that=$(this).data("resizable"),o=that.options;var pr=that._proportionallyResizeElements,ista=pr.length&&(/textarea/i).test(pr[0].nodeName),soffseth=ista&&$.ui.hasScroll(pr[0],'left')?0:that.sizeDiff.height,soffsetw=ista?0:that.sizeDiff.width;var style={width:(that.size.width-soffsetw),height:(that.size.height-soffseth)},left=(parseInt(that.element.css('left'),10)+(that.position.left-that.originalPosition.left))||null,top=(parseInt(that.element.css('top'),10)+(that.position.top-that.originalPosition.top))||null;that.element.animate($.extend(style,top&&left?{top:top,left:left}:{}),{duration:o.animateDuration,easing:o.animateEasing,step:function(){var data={width:parseInt(that.element.css('width'),10),height:parseInt(that.element.css('height'),10),top:parseInt(that.element.css('top'),10),left:parseInt(that.element.css('left'),10)};if(pr&&pr.length)$(pr[0]).css({width:data.width,height:data.height});that._updateCache(data);that._propagate("resize",event);}});}});$.ui.plugin.add("resizable","containment",{start:function(event,ui){var that=$(this).data("resizable"),o=that.options,el=that.element;var oc=o.containment,ce=(oc instanceof $)?oc.get(0):(/parent/.test(oc))?el.parent().get(0):oc;if(!ce)return;that.containerElement=$(ce);if(/document/.test(oc)||oc==document){that.containerOffset={left:0,top:0};that.containerPosition={left:0,top:0};that.parentData={element:$(document),left:0,top:0,width:$(document).width(),height:$(document).height()||document.body.parentNode.scrollHeight};}
else{var element=$(ce),p=[];$(["Top","Right","Left","Bottom"]).each(function(i,name){p[i]=num(element.css("padding"+name));});that.containerOffset=element.offset();that.containerPosition=element.position();that.containerSize={height:(element.innerHeight()-p[3]),width:(element.innerWidth()-p[1])};var co=that.containerOffset,ch=that.containerSize.height,cw=that.containerSize.width,width=($.ui.hasScroll(ce,"left")?ce.scrollWidth:cw),height=($.ui.hasScroll(ce)?ce.scrollHeight:ch);that.parentData={element:ce,left:co.left,top:co.top,width:width,height:height};}},resize:function(event,ui){var that=$(this).data("resizable"),o=that.options,ps=that.containerSize,co=that.containerOffset,cs=that.size,cp=that.position,pRatio=that._aspectRatio||event.shiftKey,cop={top:0,left:0},ce=that.containerElement;if(ce[0]!=document&&(/static/).test(ce.css('position')))cop=co;if(cp.left<(that._helper?co.left:0)){that.size.width=that.size.width+(that._helper?(that.position.left-co.left):(that.position.left-cop.left));if(pRatio)that.size.height=that.size.width/that.aspectRatio;that.position.left=o.helper?co.left:0;}
if(cp.top<(that._helper?co.top:0)){that.size.height=that.size.height+(that._helper?(that.position.top-co.top):that.position.top);if(pRatio)that.size.width=that.size.height*that.aspectRatio;that.position.top=that._helper?co.top:0;}
that.offset.left=that.parentData.left+that.position.left;that.offset.top=that.parentData.top+that.position.top;var woset=Math.abs((that._helper?that.offset.left-cop.left:(that.offset.left-cop.left))+that.sizeDiff.width),hoset=Math.abs((that._helper?that.offset.top-cop.top:(that.offset.top-co.top))+that.sizeDiff.height);var isParent=that.containerElement.get(0)==that.element.parent().get(0),isOffsetRelative=/relative|absolute/.test(that.containerElement.css('position'));if(isParent&&isOffsetRelative)woset-=that.parentData.left;if(woset+that.size.width>=that.parentData.width){that.size.width=that.parentData.width-woset;if(pRatio)that.size.height=that.size.width/that.aspectRatio;}
if(hoset+that.size.height>=that.parentData.height){that.size.height=that.parentData.height-hoset;if(pRatio)that.size.width=that.size.height*that.aspectRatio;}},stop:function(event,ui){var that=$(this).data("resizable"),o=that.options,cp=that.position,co=that.containerOffset,cop=that.containerPosition,ce=that.containerElement;var helper=$(that.helper),ho=helper.offset(),w=helper.outerWidth()-that.sizeDiff.width,h=helper.outerHeight()-that.sizeDiff.height;if(that._helper&&!o.animate&&(/relative/).test(ce.css('position')))
$(this).css({left:ho.left-cop.left-co.left,width:w,height:h});if(that._helper&&!o.animate&&(/static/).test(ce.css('position')))
$(this).css({left:ho.left-cop.left-co.left,width:w,height:h});}});$.ui.plugin.add("resizable","ghost",{start:function(event,ui){var that=$(this).data("resizable"),o=that.options,cs=that.size;that.ghost=that.originalElement.clone();that.ghost.css({opacity:.25,display:'block',position:'relative',height:cs.height,width:cs.width,margin:0,left:0,top:0}).addClass('ui-resizable-ghost').addClass(typeof o.ghost=='string'?o.ghost:'');that.ghost.appendTo(that.helper);},resize:function(event,ui){var that=$(this).data("resizable"),o=that.options;if(that.ghost)that.ghost.css({position:'relative',height:that.size.height,width:that.size.width});},stop:function(event,ui){var that=$(this).data("resizable"),o=that.options;if(that.ghost&&that.helper)that.helper.get(0).removeChild(that.ghost.get(0));}});$.ui.plugin.add("resizable","grid",{resize:function(event,ui){var that=$(this).data("resizable"),o=that.options,cs=that.size,os=that.originalSize,op=that.originalPosition,a=that.axis,ratio=o._aspectRatio||event.shiftKey;o.grid=typeof o.grid=="number"?[o.grid,o.grid]:o.grid;var ox=Math.round((cs.width-os.width)/(o.grid[0]||1))*(o.grid[0]||1),oy=Math.round((cs.height-os.height)/(o.grid[1]||1))*(o.grid[1]||1);if(/^(se|s|e)$/.test(a)){that.size.width=os.width+ox;that.size.height=os.height+oy;}
else if(/^(ne)$/.test(a)){that.size.width=os.width+ox;that.size.height=os.height+oy;that.position.top=op.top-oy;}
else if(/^(sw)$/.test(a)){that.size.width=os.width+ox;that.size.height=os.height+oy;that.position.left=op.left-ox;}
else{that.size.width=os.width+ox;that.size.height=os.height+oy;that.position.top=op.top-oy;that.position.left=op.left-ox;}}});var num=function(v){return parseInt(v,10)||0;};var isNumber=function(value){return!isNaN(parseInt(value,10));};})(jQuery);(function($,undefined){$.widget("ui.selectable",$.ui.mouse,{version:"1.9.2",options:{appendTo:'body',autoRefresh:true,distance:0,filter:'*',tolerance:'touch'},_create:function(){var that=this;this.element.addClass("ui-selectable");this.dragged=false;var selectees;this.refresh=function(){selectees=$(that.options.filter,that.element[0]);selectees.addClass("ui-selectee");selectees.each(function(){var $this=$(this);var pos=$this.offset();$.data(this,"selectable-item",{element:this,$element:$this,left:pos.left,top:pos.top,right:pos.left+$this.outerWidth(),bottom:pos.top+$this.outerHeight(),startselected:false,selected:$this.hasClass('ui-selected'),selecting:$this.hasClass('ui-selecting'),unselecting:$this.hasClass('ui-unselecting')});});};this.refresh();this.selectees=selectees.addClass("ui-selectee");this._mouseInit();this.helper=$("<div class='ui-selectable-helper'></div>");},_destroy:function(){this.selectees.removeClass("ui-selectee").removeData("selectable-item");this.element.removeClass("ui-selectable ui-selectable-disabled");this._mouseDestroy();},_mouseStart:function(event){var that=this;this.opos=[event.pageX,event.pageY];if(this.options.disabled)
return;var options=this.options;this.selectees=$(options.filter,this.element[0]);this._trigger("start",event);$(options.appendTo).append(this.helper);this.helper.css({"left":event.clientX,"top":event.clientY,"width":0,"height":0});if(options.autoRefresh){this.refresh();}
this.selectees.filter('.ui-selected').each(function(){var selectee=$.data(this,"selectable-item");selectee.startselected=true;if(!event.metaKey&&!event.ctrlKey){selectee.$element.removeClass('ui-selected');selectee.selected=false;selectee.$element.addClass('ui-unselecting');selectee.unselecting=true;that._trigger("unselecting",event,{unselecting:selectee.element});}});$(event.target).parents().andSelf().each(function(){var selectee=$.data(this,"selectable-item");if(selectee){var doSelect=(!event.metaKey&&!event.ctrlKey)||!selectee.$element.hasClass('ui-selected');selectee.$element.removeClass(doSelect?"ui-unselecting":"ui-selected").addClass(doSelect?"ui-selecting":"ui-unselecting");selectee.unselecting=!doSelect;selectee.selecting=doSelect;selectee.selected=doSelect;if(doSelect){that._trigger("selecting",event,{selecting:selectee.element});}else{that._trigger("unselecting",event,{unselecting:selectee.element});}
return false;}});},_mouseDrag:function(event){var that=this;this.dragged=true;if(this.options.disabled)
return;var options=this.options;var x1=this.opos[0],y1=this.opos[1],x2=event.pageX,y2=event.pageY;if(x1>x2){var tmp=x2;x2=x1;x1=tmp;}
if(y1>y2){var tmp=y2;y2=y1;y1=tmp;}
this.helper.css({left:x1,top:y1,width:x2-x1,height:y2-y1});this.selectees.each(function(){var selectee=$.data(this,"selectable-item");if(!selectee||selectee.element==that.element[0])
return;var hit=false;if(options.tolerance=='touch'){hit=(!(selectee.left>x2||selectee.right<x1||selectee.top>y2||selectee.bottom<y1));}else if(options.tolerance=='fit'){hit=(selectee.left>x1&&selectee.right<x2&&selectee.top>y1&&selectee.bottom<y2);}
if(hit){if(selectee.selected){selectee.$element.removeClass('ui-selected');selectee.selected=false;}
if(selectee.unselecting){selectee.$element.removeClass('ui-unselecting');selectee.unselecting=false;}
if(!selectee.selecting){selectee.$element.addClass('ui-selecting');selectee.selecting=true;that._trigger("selecting",event,{selecting:selectee.element});}}else{if(selectee.selecting){if((event.metaKey||event.ctrlKey)&&selectee.startselected){selectee.$element.removeClass('ui-selecting');selectee.selecting=false;selectee.$element.addClass('ui-selected');selectee.selected=true;}else{selectee.$element.removeClass('ui-selecting');selectee.selecting=false;if(selectee.startselected){selectee.$element.addClass('ui-unselecting');selectee.unselecting=true;}
that._trigger("unselecting",event,{unselecting:selectee.element});}}
if(selectee.selected){if(!event.metaKey&&!event.ctrlKey&&!selectee.startselected){selectee.$element.removeClass('ui-selected');selectee.selected=false;selectee.$element.addClass('ui-unselecting');selectee.unselecting=true;that._trigger("unselecting",event,{unselecting:selectee.element});}}}});return false;},_mouseStop:function(event){var that=this;this.dragged=false;var options=this.options;$('.ui-unselecting',this.element[0]).each(function(){var selectee=$.data(this,"selectable-item");selectee.$element.removeClass('ui-unselecting');selectee.unselecting=false;selectee.startselected=false;that._trigger("unselected",event,{unselected:selectee.element});});$('.ui-selecting',this.element[0]).each(function(){var selectee=$.data(this,"selectable-item");selectee.$element.removeClass('ui-selecting').addClass('ui-selected');selectee.selecting=false;selectee.selected=true;selectee.startselected=true;that._trigger("selected",event,{selected:selectee.element});});this._trigger("stop",event);this.helper.remove();return false;}});})(jQuery);(function($,undefined){var numPages=5;$.widget("ui.slider",$.ui.mouse,{version:"1.9.2",widgetEventPrefix:"slide",options:{animate:false,distance:0,max:100,min:0,orientation:"horizontal",range:false,step:1,value:0,values:null},_create:function(){var i,handleCount,o=this.options,existingHandles=this.element.find(".ui-slider-handle").addClass("ui-state-default ui-corner-all"),handle="<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",handles=[];this._keySliding=false;this._mouseSliding=false;this._animateOff=true;this._handleIndex=null;this._detectOrientation();this._mouseInit();this.element.addClass("ui-slider"+" ui-slider-"+this.orientation+" ui-widget"+" ui-widget-content"+" ui-corner-all"+
(o.disabled?" ui-slider-disabled ui-disabled":""));this.range=$([]);if(o.range){if(o.range===true){if(!o.values){o.values=[this._valueMin(),this._valueMin()];}
if(o.values.length&&o.values.length!==2){o.values=[o.values[0],o.values[0]];}}
this.range=$("<div></div>").appendTo(this.element).addClass("ui-slider-range"+" ui-widget-header"+
((o.range==="min"||o.range==="max")?" ui-slider-range-"+o.range:""));}
handleCount=(o.values&&o.values.length)||1;for(i=existingHandles.length;i<handleCount;i++){handles.push(handle);}
this.handles=existingHandles.add($(handles.join("")).appendTo(this.element));this.handle=this.handles.eq(0);this.handles.add(this.range).filter("a").click(function(event){event.preventDefault();}).mouseenter(function(){if(!o.disabled){$(this).addClass("ui-state-hover");}}).mouseleave(function(){$(this).removeClass("ui-state-hover");}).focus(function(){if(!o.disabled){$(".ui-slider .ui-state-focus").removeClass("ui-state-focus");$(this).addClass("ui-state-focus");}else{$(this).blur();}}).blur(function(){$(this).removeClass("ui-state-focus");});this.handles.each(function(i){$(this).data("ui-slider-handle-index",i);});this._on(this.handles,{keydown:function(event){var allowed,curVal,newVal,step,index=$(event.target).data("ui-slider-handle-index");switch(event.keyCode){case $.ui.keyCode.HOME:case $.ui.keyCode.END:case $.ui.keyCode.PAGE_UP:case $.ui.keyCode.PAGE_DOWN:case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:event.preventDefault();if(!this._keySliding){this._keySliding=true;$(event.target).addClass("ui-state-active");allowed=this._start(event,index);if(allowed===false){return;}}
break;}
step=this.options.step;if(this.options.values&&this.options.values.length){curVal=newVal=this.values(index);}else{curVal=newVal=this.value();}
switch(event.keyCode){case $.ui.keyCode.HOME:newVal=this._valueMin();break;case $.ui.keyCode.END:newVal=this._valueMax();break;case $.ui.keyCode.PAGE_UP:newVal=this._trimAlignValue(curVal+((this._valueMax()-this._valueMin())/numPages));break;case $.ui.keyCode.PAGE_DOWN:newVal=this._trimAlignValue(curVal-((this._valueMax()-this._valueMin())/numPages));break;case $.ui.keyCode.UP:case $.ui.keyCode.RIGHT:if(curVal===this._valueMax()){return;}
newVal=this._trimAlignValue(curVal+step);break;case $.ui.keyCode.DOWN:case $.ui.keyCode.LEFT:if(curVal===this._valueMin()){return;}
newVal=this._trimAlignValue(curVal-step);break;}
this._slide(event,index,newVal);},keyup:function(event){var index=$(event.target).data("ui-slider-handle-index");if(this._keySliding){this._keySliding=false;this._stop(event,index);this._change(event,index);$(event.target).removeClass("ui-state-active");}}});this._refreshValue();this._animateOff=false;},_destroy:function(){this.handles.remove();this.range.remove();this.element.removeClass("ui-slider"+" ui-slider-horizontal"+" ui-slider-vertical"+" ui-slider-disabled"+" ui-widget"+" ui-widget-content"+" ui-corner-all");this._mouseDestroy();},_mouseCapture:function(event){var position,normValue,distance,closestHandle,index,allowed,offset,mouseOverHandle,that=this,o=this.options;if(o.disabled){return false;}
this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()};this.elementOffset=this.element.offset();position={x:event.pageX,y:event.pageY};normValue=this._normValueFromMouse(position);distance=this._valueMax()-this._valueMin()+1;this.handles.each(function(i){var thisDistance=Math.abs(normValue-that.values(i));if(distance>thisDistance){distance=thisDistance;closestHandle=$(this);index=i;}});if(o.range===true&&this.values(1)===o.min){index+=1;closestHandle=$(this.handles[index]);}
allowed=this._start(event,index);if(allowed===false){return false;}
this._mouseSliding=true;this._handleIndex=index;closestHandle.addClass("ui-state-active").focus();offset=closestHandle.offset();mouseOverHandle=!$(event.target).parents().andSelf().is(".ui-slider-handle");this._clickOffset=mouseOverHandle?{left:0,top:0}:{left:event.pageX-offset.left-(closestHandle.width()/2),top:event.pageY-offset.top-
(closestHandle.height()/2)-
(parseInt(closestHandle.css("borderTopWidth"),10)||0)-
(parseInt(closestHandle.css("borderBottomWidth"),10)||0)+
(parseInt(closestHandle.css("marginTop"),10)||0)};if(!this.handles.hasClass("ui-state-hover")){this._slide(event,index,normValue);}
this._animateOff=true;return true;},_mouseStart:function(){return true;},_mouseDrag:function(event){var position={x:event.pageX,y:event.pageY},normValue=this._normValueFromMouse(position);this._slide(event,this._handleIndex,normValue);return false;},_mouseStop:function(event){this.handles.removeClass("ui-state-active");this._mouseSliding=false;this._stop(event,this._handleIndex);this._change(event,this._handleIndex);this._handleIndex=null;this._clickOffset=null;this._animateOff=false;return false;},_detectOrientation:function(){this.orientation=(this.options.orientation==="vertical")?"vertical":"horizontal";},_normValueFromMouse:function(position){var pixelTotal,pixelMouse,percentMouse,valueTotal,valueMouse;if(this.orientation==="horizontal"){pixelTotal=this.elementSize.width;pixelMouse=position.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0);}else{pixelTotal=this.elementSize.height;pixelMouse=position.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0);}
percentMouse=(pixelMouse/pixelTotal);if(percentMouse>1){percentMouse=1;}
if(percentMouse<0){percentMouse=0;}
if(this.orientation==="vertical"){percentMouse=1-percentMouse;}
valueTotal=this._valueMax()-this._valueMin();valueMouse=this._valueMin()+percentMouse*valueTotal;return this._trimAlignValue(valueMouse);},_start:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}
return this._trigger("start",event,uiHash);},_slide:function(event,index,newVal){var otherVal,newValues,allowed;if(this.options.values&&this.options.values.length){otherVal=this.values(index?0:1);if((this.options.values.length===2&&this.options.range===true)&&((index===0&&newVal>otherVal)||(index===1&&newVal<otherVal))){newVal=otherVal;}
if(newVal!==this.values(index)){newValues=this.values();newValues[index]=newVal;allowed=this._trigger("slide",event,{handle:this.handles[index],value:newVal,values:newValues});otherVal=this.values(index?0:1);if(allowed!==false){this.values(index,newVal,true);}}}else{if(newVal!==this.value()){allowed=this._trigger("slide",event,{handle:this.handles[index],value:newVal});if(allowed!==false){this.value(newVal);}}}},_stop:function(event,index){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}
this._trigger("stop",event,uiHash);},_change:function(event,index){if(!this._keySliding&&!this._mouseSliding){var uiHash={handle:this.handles[index],value:this.value()};if(this.options.values&&this.options.values.length){uiHash.value=this.values(index);uiHash.values=this.values();}
this._trigger("change",event,uiHash);}},value:function(newValue){if(arguments.length){this.options.value=this._trimAlignValue(newValue);this._refreshValue();this._change(null,0);return;}
return this._value();},values:function(index,newValue){var vals,newValues,i;if(arguments.length>1){this.options.values[index]=this._trimAlignValue(newValue);this._refreshValue();this._change(null,index);return;}
if(arguments.length){if($.isArray(arguments[0])){vals=this.options.values;newValues=arguments[0];for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(newValues[i]);this._change(null,i);}
this._refreshValue();}else{if(this.options.values&&this.options.values.length){return this._values(index);}else{return this.value();}}}else{return this._values();}},_setOption:function(key,value){var i,valsLength=0;if($.isArray(this.options.values)){valsLength=this.options.values.length;}
$.Widget.prototype._setOption.apply(this,arguments);switch(key){case"disabled":if(value){this.handles.filter(".ui-state-focus").blur();this.handles.removeClass("ui-state-hover");this.handles.prop("disabled",true);this.element.addClass("ui-disabled");}else{this.handles.prop("disabled",false);this.element.removeClass("ui-disabled");}
break;case"orientation":this._detectOrientation();this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-"+this.orientation);this._refreshValue();break;case"value":this._animateOff=true;this._refreshValue();this._change(null,0);this._animateOff=false;break;case"values":this._animateOff=true;this._refreshValue();for(i=0;i<valsLength;i+=1){this._change(null,i);}
this._animateOff=false;break;case"min":case"max":this._animateOff=true;this._refreshValue();this._animateOff=false;break;}},_value:function(){var val=this.options.value;val=this._trimAlignValue(val);return val;},_values:function(index){var val,vals,i;if(arguments.length){val=this.options.values[index];val=this._trimAlignValue(val);return val;}else{vals=this.options.values.slice();for(i=0;i<vals.length;i+=1){vals[i]=this._trimAlignValue(vals[i]);}
return vals;}},_trimAlignValue:function(val){if(val<=this._valueMin()){return this._valueMin();}
if(val>=this._valueMax()){return this._valueMax();}
var step=(this.options.step>0)?this.options.step:1,valModStep=(val-this._valueMin())%step,alignValue=val-valModStep;if(Math.abs(valModStep)*2>=step){alignValue+=(valModStep>0)?step:(-step);}
return parseFloat(alignValue.toFixed(5));},_valueMin:function(){return this.options.min;},_valueMax:function(){return this.options.max;},_refreshValue:function(){var lastValPercent,valPercent,value,valueMin,valueMax,oRange=this.options.range,o=this.options,that=this,animate=(!this._animateOff)?o.animate:false,_set={};if(this.options.values&&this.options.values.length){this.handles.each(function(i){valPercent=(that.values(i)-that._valueMin())/(that._valueMax()-that._valueMin())*100;_set[that.orientation==="horizontal"?"left":"bottom"]=valPercent+"%";$(this).stop(1,1)[animate?"animate":"css"](_set,o.animate);if(that.options.range===true){if(that.orientation==="horizontal"){if(i===0){that.range.stop(1,1)[animate?"animate":"css"]({left:valPercent+"%"},o.animate);}
if(i===1){that.range[animate?"animate":"css"]({width:(valPercent-lastValPercent)+"%"},{queue:false,duration:o.animate});}}else{if(i===0){that.range.stop(1,1)[animate?"animate":"css"]({bottom:(valPercent)+"%"},o.animate);}
if(i===1){that.range[animate?"animate":"css"]({height:(valPercent-lastValPercent)+"%"},{queue:false,duration:o.animate});}}}
lastValPercent=valPercent;});}else{value=this.value();valueMin=this._valueMin();valueMax=this._valueMax();valPercent=(valueMax!==valueMin)?(value-valueMin)/(valueMax-valueMin)*100:0;_set[this.orientation==="horizontal"?"left":"bottom"]=valPercent+"%";this.handle.stop(1,1)[animate?"animate":"css"](_set,o.animate);if(oRange==="min"&&this.orientation==="horizontal"){this.range.stop(1,1)[animate?"animate":"css"]({width:valPercent+"%"},o.animate);}
if(oRange==="max"&&this.orientation==="horizontal"){this.range[animate?"animate":"css"]({width:(100-valPercent)+"%"},{queue:false,duration:o.animate});}
if(oRange==="min"&&this.orientation==="vertical"){this.range.stop(1,1)[animate?"animate":"css"]({height:valPercent+"%"},o.animate);}
if(oRange==="max"&&this.orientation==="vertical"){this.range[animate?"animate":"css"]({height:(100-valPercent)+"%"},{queue:false,duration:o.animate});}}}});}(jQuery));(function($,undefined){$.widget("ui.sortable",$.ui.mouse,{version:"1.9.2",widgetEventPrefix:"sort",ready:false,options:{appendTo:"parent",axis:false,connectWith:false,containment:false,cursor:'auto',cursorAt:false,dropOnEmpty:true,forcePlaceholderSize:false,forceHelperSize:false,grid:false,handle:false,helper:"original",items:'> *',opacity:false,placeholder:false,revert:false,scroll:true,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1000},_create:function(){var o=this.options;this.containerCache={};this.element.addClass("ui-sortable");this.refresh();this.floating=this.items.length?o.axis==='x'||(/left|right/).test(this.items[0].item.css('float'))||(/inline|table-cell/).test(this.items[0].item.css('display')):false;this.offset=this.element.offset();this._mouseInit();this.ready=true},_destroy:function(){this.element.removeClass("ui-sortable ui-sortable-disabled");this._mouseDestroy();for(var i=this.items.length-1;i>=0;i--)
this.items[i].item.removeData(this.widgetName+"-item");return this;},_setOption:function(key,value){if(key==="disabled"){this.options[key]=value;this.widget().toggleClass("ui-sortable-disabled",!!value);}else{$.Widget.prototype._setOption.apply(this,arguments);}},_mouseCapture:function(event,overrideHandle){var that=this;if(this.reverting){return false;}
if(this.options.disabled||this.options.type=='static')return false;this._refreshItems(event);var currentItem=null,nodes=$(event.target).parents().each(function(){if($.data(this,that.widgetName+'-item')==that){currentItem=$(this);return false;}});if($.data(event.target,that.widgetName+'-item')==that)currentItem=$(event.target);if(!currentItem)return false;if(this.options.handle&&!overrideHandle){var validHandle=false;$(this.options.handle,currentItem).find("*").andSelf().each(function(){if(this==event.target)validHandle=true;});if(!validHandle)return false;}
this.currentItem=currentItem;this._removeCurrentsFromItems();return true;},_mouseStart:function(event,overrideHandle,noActivation){var o=this.options;this.currentContainer=this;this.refreshPositions();this.helper=this._createHelper(event);this._cacheHelperProportions();this._cacheMargins();this.scrollParent=this.helper.scrollParent();this.offset=this.currentItem.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};$.extend(this.offset,{click:{left:event.pageX-this.offset.left,top:event.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.helper.css("position","absolute");this.cssPosition=this.helper.css("position");this.originalPosition=this._generatePosition(event);this.originalPageX=event.pageX;this.originalPageY=event.pageY;(o.cursorAt&&this._adjustOffsetFromHelper(o.cursorAt));this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]};if(this.helper[0]!=this.currentItem[0]){this.currentItem.hide();}
this._createPlaceholder();if(o.containment)
this._setContainment();if(o.cursor){if($('body').css("cursor"))this._storedCursor=$('body').css("cursor");$('body').css("cursor",o.cursor);}
if(o.opacity){if(this.helper.css("opacity"))this._storedOpacity=this.helper.css("opacity");this.helper.css("opacity",o.opacity);}
if(o.zIndex){if(this.helper.css("zIndex"))this._storedZIndex=this.helper.css("zIndex");this.helper.css("zIndex",o.zIndex);}
if(this.scrollParent[0]!=document&&this.scrollParent[0].tagName!='HTML')
this.overflowOffset=this.scrollParent.offset();this._trigger("start",event,this._uiHash());if(!this._preserveHelperProportions)
this._cacheHelperProportions();if(!noActivation){for(var i=this.containers.length-1;i>=0;i--){this.containers[i]._trigger("activate",event,this._uiHash(this));}}
if($.ui.ddmanager)
$.ui.ddmanager.current=this;if($.ui.ddmanager&&!o.dropBehaviour)
$.ui.ddmanager.prepareOffsets(this,event);this.dragging=true;this.helper.addClass("ui-sortable-helper");this._mouseDrag(event);return true;},_mouseDrag:function(event){this.position=this._generatePosition(event);this.positionAbs=this._convertPositionTo("absolute");if(!this.lastPositionAbs){this.lastPositionAbs=this.positionAbs;}
if(this.options.scroll){var o=this.options,scrolled=false;if(this.scrollParent[0]!=document&&this.scrollParent[0].tagName!='HTML'){if((this.overflowOffset.top+this.scrollParent[0].offsetHeight)-event.pageY<o.scrollSensitivity)
this.scrollParent[0].scrollTop=scrolled=this.scrollParent[0].scrollTop+o.scrollSpeed;else if(event.pageY-this.overflowOffset.top<o.scrollSensitivity)
this.scrollParent[0].scrollTop=scrolled=this.scrollParent[0].scrollTop-o.scrollSpeed;if((this.overflowOffset.left+this.scrollParent[0].offsetWidth)-event.pageX<o.scrollSensitivity)
this.scrollParent[0].scrollLeft=scrolled=this.scrollParent[0].scrollLeft+o.scrollSpeed;else if(event.pageX-this.overflowOffset.left<o.scrollSensitivity)
this.scrollParent[0].scrollLeft=scrolled=this.scrollParent[0].scrollLeft-o.scrollSpeed;}else{if(event.pageY-$(document).scrollTop()<o.scrollSensitivity)
scrolled=$(document).scrollTop($(document).scrollTop()-o.scrollSpeed);else if($(window).height()-(event.pageY-$(document).scrollTop())<o.scrollSensitivity)
scrolled=$(document).scrollTop($(document).scrollTop()+o.scrollSpeed);if(event.pageX-$(document).scrollLeft()<o.scrollSensitivity)
scrolled=$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed);else if($(window).width()-(event.pageX-$(document).scrollLeft())<o.scrollSensitivity)
scrolled=$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed);}
if(scrolled!==false&&$.ui.ddmanager&&!o.dropBehaviour)
$.ui.ddmanager.prepareOffsets(this,event);}
this.positionAbs=this._convertPositionTo("absolute");if(!this.options.axis||this.options.axis!="y")this.helper[0].style.left=this.position.left+'px';if(!this.options.axis||this.options.axis!="x")this.helper[0].style.top=this.position.top+'px';for(var i=this.items.length-1;i>=0;i--){var item=this.items[i],itemElement=item.item[0],intersection=this._intersectsWithPointer(item);if(!intersection)continue;if(item.instance!==this.currentContainer)continue;if(itemElement!=this.currentItem[0]&&this.placeholder[intersection==1?"next":"prev"]()[0]!=itemElement&&!$.contains(this.placeholder[0],itemElement)&&(this.options.type=='semi-dynamic'?!$.contains(this.element[0],itemElement):true)){this.direction=intersection==1?"down":"up";if(this.options.tolerance=="pointer"||this._intersectsWithSides(item)){this._rearrange(event,item);}else{break;}
this._trigger("change",event,this._uiHash());break;}}
this._contactContainers(event);if($.ui.ddmanager)$.ui.ddmanager.drag(this,event);this._trigger('sort',event,this._uiHash());this.lastPositionAbs=this.positionAbs;return false;},_mouseStop:function(event,noPropagation){if(!event)return;if($.ui.ddmanager&&!this.options.dropBehaviour)
$.ui.ddmanager.drop(this,event);if(this.options.revert){var that=this;var cur=this.placeholder.offset();this.reverting=true;$(this.helper).animate({left:cur.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollLeft),top:cur.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollTop)},parseInt(this.options.revert,10)||500,function(){that._clear(event);});}else{this._clear(event,noPropagation);}
return false;},cancel:function(){if(this.dragging){this._mouseUp({target:null});if(this.options.helper=="original")
this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper");else
this.currentItem.show();for(var i=this.containers.length-1;i>=0;i--){this.containers[i]._trigger("deactivate",null,this._uiHash(this));if(this.containers[i].containerCache.over){this.containers[i]._trigger("out",null,this._uiHash(this));this.containers[i].containerCache.over=0;}}}
if(this.placeholder){if(this.placeholder[0].parentNode)this.placeholder[0].parentNode.removeChild(this.placeholder[0]);if(this.options.helper!="original"&&this.helper&&this.helper[0].parentNode)this.helper.remove();$.extend(this,{helper:null,dragging:false,reverting:false,_noFinalSort:null});if(this.domPosition.prev){$(this.domPosition.prev).after(this.currentItem);}else{$(this.domPosition.parent).prepend(this.currentItem);}}
return this;},serialize:function(o){var items=this._getItemsAsjQuery(o&&o.connected);var str=[];o=o||{};$(items).each(function(){var res=($(o.item||this).attr(o.attribute||'id')||'').match(o.expression||(/(.+)[-=_](.+)/));if(res)str.push((o.key||res[1]+'[]')+'='+(o.key&&o.expression?res[1]:res[2]));});if(!str.length&&o.key){str.push(o.key+'=');}
return str.join('&');},toArray:function(o){var items=this._getItemsAsjQuery(o&&o.connected);var ret=[];o=o||{};items.each(function(){ret.push($(o.item||this).attr(o.attribute||'id')||'');});return ret;},_intersectsWith:function(item){var x1=this.positionAbs.left,x2=x1+this.helperProportions.width,y1=this.positionAbs.top,y2=y1+this.helperProportions.height;var l=item.left,r=l+item.width,t=item.top,b=t+item.height;var dyClick=this.offset.click.top,dxClick=this.offset.click.left;var isOverElement=(y1+dyClick)>t&&(y1+dyClick)<b&&(x1+dxClick)>l&&(x1+dxClick)<r;if(this.options.tolerance=="pointer"||this.options.forcePointerForContainers||(this.options.tolerance!="pointer"&&this.helperProportions[this.floating?'width':'height']>item[this.floating?'width':'height'])){return isOverElement;}else{return(l<x1+(this.helperProportions.width/2)&&x2-(this.helperProportions.width/2)<r&&t<y1+(this.helperProportions.height/2)&&y2-(this.helperProportions.height/2)<b);}},_intersectsWithPointer:function(item){var isOverElementHeight=(this.options.axis==='x')||$.ui.isOverAxis(this.positionAbs.top+this.offset.click.top,item.top,item.height),isOverElementWidth=(this.options.axis==='y')||$.ui.isOverAxis(this.positionAbs.left+this.offset.click.left,item.left,item.width),isOverElement=isOverElementHeight&&isOverElementWidth,verticalDirection=this._getDragVerticalDirection(),horizontalDirection=this._getDragHorizontalDirection();if(!isOverElement)
return false;return this.floating?(((horizontalDirection&&horizontalDirection=="right")||verticalDirection=="down")?2:1):(verticalDirection&&(verticalDirection=="down"?2:1));},_intersectsWithSides:function(item){var isOverBottomHalf=$.ui.isOverAxis(this.positionAbs.top+this.offset.click.top,item.top+(item.height/2),item.height),isOverRightHalf=$.ui.isOverAxis(this.positionAbs.left+this.offset.click.left,item.left+(item.width/2),item.width),verticalDirection=this._getDragVerticalDirection(),horizontalDirection=this._getDragHorizontalDirection();if(this.floating&&horizontalDirection){return((horizontalDirection=="right"&&isOverRightHalf)||(horizontalDirection=="left"&&!isOverRightHalf));}else{return verticalDirection&&((verticalDirection=="down"&&isOverBottomHalf)||(verticalDirection=="up"&&!isOverBottomHalf));}},_getDragVerticalDirection:function(){var delta=this.positionAbs.top-this.lastPositionAbs.top;return delta!=0&&(delta>0?"down":"up");},_getDragHorizontalDirection:function(){var delta=this.positionAbs.left-this.lastPositionAbs.left;return delta!=0&&(delta>0?"right":"left");},refresh:function(event){this._refreshItems(event);this.refreshPositions();return this;},_connectWith:function(){var options=this.options;return options.connectWith.constructor==String?[options.connectWith]:options.connectWith;},_getItemsAsjQuery:function(connected){var items=[];var queries=[];var connectWith=this._connectWith();if(connectWith&&connected){for(var i=connectWith.length-1;i>=0;i--){var cur=$(connectWith[i]);for(var j=cur.length-1;j>=0;j--){var inst=$.data(cur[j],this.widgetName);if(inst&&inst!=this&&!inst.options.disabled){queries.push([$.isFunction(inst.options.items)?inst.options.items.call(inst.element):$(inst.options.items,inst.element).not(".ui-sortable-helper").not('.ui-sortable-placeholder'),inst]);}};};}
queries.push([$.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):$(this.options.items,this.element).not(".ui-sortable-helper").not('.ui-sortable-placeholder'),this]);for(var i=queries.length-1;i>=0;i--){queries[i][0].each(function(){items.push(this);});};return $(items);},_removeCurrentsFromItems:function(){var list=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=$.grep(this.items,function(item){for(var j=0;j<list.length;j++){if(list[j]==item.item[0])
return false;};return true;});},_refreshItems:function(event){this.items=[];this.containers=[this];var items=this.items;var queries=[[$.isFunction(this.options.items)?this.options.items.call(this.element[0],event,{item:this.currentItem}):$(this.options.items,this.element),this]];var connectWith=this._connectWith();if(connectWith&&this.ready){for(var i=connectWith.length-1;i>=0;i--){var cur=$(connectWith[i]);for(var j=cur.length-1;j>=0;j--){var inst=$.data(cur[j],this.widgetName);if(inst&&inst!=this&&!inst.options.disabled){queries.push([$.isFunction(inst.options.items)?inst.options.items.call(inst.element[0],event,{item:this.currentItem}):$(inst.options.items,inst.element),inst]);this.containers.push(inst);}};};}
for(var i=queries.length-1;i>=0;i--){var targetData=queries[i][1];var _queries=queries[i][0];for(var j=0,queriesLength=_queries.length;j<queriesLength;j++){var item=$(_queries[j]);item.data(this.widgetName+'-item',targetData);items.push({item:item,instance:targetData,width:0,height:0,left:0,top:0});};};},refreshPositions:function(fast){if(this.offsetParent&&this.helper){this.offset.parent=this._getParentOffset();}
for(var i=this.items.length-1;i>=0;i--){var item=this.items[i];if(item.instance!=this.currentContainer&&this.currentContainer&&item.item[0]!=this.currentItem[0])
continue;var t=this.options.toleranceElement?$(this.options.toleranceElement,item.item):item.item;if(!fast){item.width=t.outerWidth();item.height=t.outerHeight();}
var p=t.offset();item.left=p.left;item.top=p.top;};if(this.options.custom&&this.options.custom.refreshContainers){this.options.custom.refreshContainers.call(this);}else{for(var i=this.containers.length-1;i>=0;i--){var p=this.containers[i].element.offset();this.containers[i].containerCache.left=p.left;this.containers[i].containerCache.top=p.top;this.containers[i].containerCache.width=this.containers[i].element.outerWidth();this.containers[i].containerCache.height=this.containers[i].element.outerHeight();};}
return this;},_createPlaceholder:function(that){that=that||this;var o=that.options;if(!o.placeholder||o.placeholder.constructor==String){var className=o.placeholder;o.placeholder={element:function(){var el=$(document.createElement(that.currentItem[0].nodeName)).addClass(className||that.currentItem[0].className+" ui-sortable-placeholder").removeClass("ui-sortable-helper")[0];if(!className)
el.style.visibility="hidden";return el;},update:function(container,p){if(className&&!o.forcePlaceholderSize)return;if(!p.height()){p.height(that.currentItem.innerHeight()-parseInt(that.currentItem.css('paddingTop')||0,10)-parseInt(that.currentItem.css('paddingBottom')||0,10));};if(!p.width()){p.width(that.currentItem.innerWidth()-parseInt(that.currentItem.css('paddingLeft')||0,10)-parseInt(that.currentItem.css('paddingRight')||0,10));};}};}
that.placeholder=$(o.placeholder.element.call(that.element,that.currentItem));that.currentItem.after(that.placeholder);o.placeholder.update(that,that.placeholder);},_contactContainers:function(event){var innermostContainer=null,innermostIndex=null;for(var i=this.containers.length-1;i>=0;i--){if($.contains(this.currentItem[0],this.containers[i].element[0]))
continue;if(this._intersectsWith(this.containers[i].containerCache)){if(innermostContainer&&$.contains(this.containers[i].element[0],innermostContainer.element[0]))
continue;innermostContainer=this.containers[i];innermostIndex=i;}else{if(this.containers[i].containerCache.over){this.containers[i]._trigger("out",event,this._uiHash(this));this.containers[i].containerCache.over=0;}}}
if(!innermostContainer)return;if(this.containers.length===1){this.containers[innermostIndex]._trigger("over",event,this._uiHash(this));this.containers[innermostIndex].containerCache.over=1;}else{var dist=10000;var itemWithLeastDistance=null;var posProperty=this.containers[innermostIndex].floating?'left':'top';var sizeProperty=this.containers[innermostIndex].floating?'width':'height';var base=this.positionAbs[posProperty]+this.offset.click[posProperty];for(var j=this.items.length-1;j>=0;j--){if(!$.contains(this.containers[innermostIndex].element[0],this.items[j].item[0]))continue;if(this.items[j].item[0]==this.currentItem[0])continue;var cur=this.items[j].item.offset()[posProperty];var nearBottom=false;if(Math.abs(cur-base)>Math.abs(cur+this.items[j][sizeProperty]-base)){nearBottom=true;cur+=this.items[j][sizeProperty];}
if(Math.abs(cur-base)<dist){dist=Math.abs(cur-base);itemWithLeastDistance=this.items[j];this.direction=nearBottom?"up":"down";}}
if(!itemWithLeastDistance&&!this.options.dropOnEmpty)
return;this.currentContainer=this.containers[innermostIndex];itemWithLeastDistance?this._rearrange(event,itemWithLeastDistance,null,true):this._rearrange(event,null,this.containers[innermostIndex].element,true);this._trigger("change",event,this._uiHash());this.containers[innermostIndex]._trigger("change",event,this._uiHash(this));this.options.placeholder.update(this.currentContainer,this.placeholder);this.containers[innermostIndex]._trigger("over",event,this._uiHash(this));this.containers[innermostIndex].containerCache.over=1;}},_createHelper:function(event){var o=this.options;var helper=$.isFunction(o.helper)?$(o.helper.apply(this.element[0],[event,this.currentItem])):(o.helper=='clone'?this.currentItem.clone():this.currentItem);if(!helper.parents('body').length)
$(o.appendTo!='parent'?o.appendTo:this.currentItem[0].parentNode)[0].appendChild(helper[0]);if(helper[0]==this.currentItem[0])
this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")};if(helper[0].style.width==''||o.forceHelperSize)helper.width(this.currentItem.width());if(helper[0].style.height==''||o.forceHelperSize)helper.height(this.currentItem.height());return helper;},_adjustOffsetFromHelper:function(obj){if(typeof obj=='string'){obj=obj.split(' ');}
if($.isArray(obj)){obj={left:+obj[0],top:+obj[1]||0};}
if('left'in obj){this.offset.click.left=obj.left+this.margins.left;}
if('right'in obj){this.offset.click.left=this.helperProportions.width-obj.right+this.margins.left;}
if('top'in obj){this.offset.click.top=obj.top+this.margins.top;}
if('bottom'in obj){this.offset.click.top=this.helperProportions.height-obj.bottom+this.margins.top;}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();if(this.cssPosition=='absolute'&&this.scrollParent[0]!=document&&$.contains(this.scrollParent[0],this.offsetParent[0])){po.left+=this.scrollParent.scrollLeft();po.top+=this.scrollParent.scrollTop();}
if((this.offsetParent[0]==document.body)||(this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()=='html'&&$.ui.ie))
po={top:0,left:0};return{top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)};},_getRelativeOffset:function(){if(this.cssPosition=="relative"){var p=this.currentItem.position();return{top:p.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:p.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()};}else{return{top:0,left:0};}},_cacheMargins:function(){this.margins={left:(parseInt(this.currentItem.css("marginLeft"),10)||0),top:(parseInt(this.currentItem.css("marginTop"),10)||0)};},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};},_setContainment:function(){var o=this.options;if(o.containment=='parent')o.containment=this.helper[0].parentNode;if(o.containment=='document'||o.containment=='window')this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,$(o.containment=='document'?document:window).width()-this.helperProportions.width-this.margins.left,($(o.containment=='document'?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];if(!(/^(document|window|parent)$/).test(o.containment)){var ce=$(o.containment)[0];var co=$(o.containment).offset();var over=($(ce).css("overflow")!='hidden');this.containment=[co.left+(parseInt($(ce).css("borderLeftWidth"),10)||0)+(parseInt($(ce).css("paddingLeft"),10)||0)-this.margins.left,co.top+(parseInt($(ce).css("borderTopWidth"),10)||0)+(parseInt($(ce).css("paddingTop"),10)||0)-this.margins.top,co.left+(over?Math.max(ce.scrollWidth,ce.offsetWidth):ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-(parseInt($(ce).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,co.top+(over?Math.max(ce.scrollHeight,ce.offsetHeight):ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-(parseInt($(ce).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top];}},_convertPositionTo:function(d,pos){if(!pos)pos=this.position;var mod=d=="absolute"?1:-1;var o=this.options,scroll=this.cssPosition=='absolute'&&!(this.scrollParent[0]!=document&&$.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);return{top:(pos.top
+this.offset.relative.top*mod
+this.offset.parent.top*mod
-((this.cssPosition=='fixed'?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop()))*mod)),left:(pos.left
+this.offset.relative.left*mod
+this.offset.parent.left*mod
-((this.cssPosition=='fixed'?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())*mod))};},_generatePosition:function(event){var o=this.options,scroll=this.cssPosition=='absolute'&&!(this.scrollParent[0]!=document&&$.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,scrollIsRootNode=(/(html|body)/i).test(scroll[0].tagName);if(this.cssPosition=='relative'&&!(this.scrollParent[0]!=document&&this.scrollParent[0]!=this.offsetParent[0])){this.offset.relative=this._getRelativeOffset();}
var pageX=event.pageX;var pageY=event.pageY;if(this.originalPosition){if(this.containment){if(event.pageX-this.offset.click.left<this.containment[0])pageX=this.containment[0]+this.offset.click.left;if(event.pageY-this.offset.click.top<this.containment[1])pageY=this.containment[1]+this.offset.click.top;if(event.pageX-this.offset.click.left>this.containment[2])pageX=this.containment[2]+this.offset.click.left;if(event.pageY-this.offset.click.top>this.containment[3])pageY=this.containment[3]+this.offset.click.top;}
if(o.grid){var top=this.originalPageY+Math.round((pageY-this.originalPageY)/o.grid[1])*o.grid[1];pageY=this.containment?(!(top-this.offset.click.top<this.containment[1]||top-this.offset.click.top>this.containment[3])?top:(!(top-this.offset.click.top<this.containment[1])?top-o.grid[1]:top+o.grid[1])):top;var left=this.originalPageX+Math.round((pageX-this.originalPageX)/o.grid[0])*o.grid[0];pageX=this.containment?(!(left-this.offset.click.left<this.containment[0]||left-this.offset.click.left>this.containment[2])?left:(!(left-this.offset.click.left<this.containment[0])?left-o.grid[0]:left+o.grid[0])):left;}}
return{top:(pageY
-this.offset.click.top
-this.offset.relative.top
-this.offset.parent.top
+((this.cssPosition=='fixed'?-this.scrollParent.scrollTop():(scrollIsRootNode?0:scroll.scrollTop())))),left:(pageX
-this.offset.click.left
-this.offset.relative.left
-this.offset.parent.left
+((this.cssPosition=='fixed'?-this.scrollParent.scrollLeft():scrollIsRootNode?0:scroll.scrollLeft())))};},_rearrange:function(event,i,a,hardRefresh){a?a[0].appendChild(this.placeholder[0]):i.item[0].parentNode.insertBefore(this.placeholder[0],(this.direction=='down'?i.item[0]:i.item[0].nextSibling));this.counter=this.counter?++this.counter:1;var counter=this.counter;this._delay(function(){if(counter==this.counter)this.refreshPositions(!hardRefresh);});},_clear:function(event,noPropagation){this.reverting=false;var delayedTriggers=[];if(!this._noFinalSort&&this.currentItem.parent().length)this.placeholder.before(this.currentItem);this._noFinalSort=null;if(this.helper[0]==this.currentItem[0]){for(var i in this._storedCSS){if(this._storedCSS[i]=='auto'||this._storedCSS[i]=='static')this._storedCSS[i]='';}
this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper");}else{this.currentItem.show();}
if(this.fromOutside&&!noPropagation)delayedTriggers.push(function(event){this._trigger("receive",event,this._uiHash(this.fromOutside));});if((this.fromOutside||this.domPosition.prev!=this.currentItem.prev().not(".ui-sortable-helper")[0]||this.domPosition.parent!=this.currentItem.parent()[0])&&!noPropagation)delayedTriggers.push(function(event){this._trigger("update",event,this._uiHash());});if(this!==this.currentContainer){if(!noPropagation){delayedTriggers.push(function(event){this._trigger("remove",event,this._uiHash());});delayedTriggers.push((function(c){return function(event){c._trigger("receive",event,this._uiHash(this));};}).call(this,this.currentContainer));delayedTriggers.push((function(c){return function(event){c._trigger("update",event,this._uiHash(this));};}).call(this,this.currentContainer));}}
for(var i=this.containers.length-1;i>=0;i--){if(!noPropagation)delayedTriggers.push((function(c){return function(event){c._trigger("deactivate",event,this._uiHash(this));};}).call(this,this.containers[i]));if(this.containers[i].containerCache.over){delayedTriggers.push((function(c){return function(event){c._trigger("out",event,this._uiHash(this));};}).call(this,this.containers[i]));this.containers[i].containerCache.over=0;}}
if(this._storedCursor)$('body').css("cursor",this._storedCursor);if(this._storedOpacity)this.helper.css("opacity",this._storedOpacity);if(this._storedZIndex)this.helper.css("zIndex",this._storedZIndex=='auto'?'':this._storedZIndex);this.dragging=false;if(this.cancelHelperRemoval){if(!noPropagation){this._trigger("beforeStop",event,this._uiHash());for(var i=0;i<delayedTriggers.length;i++){delayedTriggers[i].call(this,event);};this._trigger("stop",event,this._uiHash());}
this.fromOutside=false;return false;}
if(!noPropagation)this._trigger("beforeStop",event,this._uiHash());this.placeholder[0].parentNode.removeChild(this.placeholder[0]);if(this.helper[0]!=this.currentItem[0])this.helper.remove();this.helper=null;if(!noPropagation){for(var i=0;i<delayedTriggers.length;i++){delayedTriggers[i].call(this,event);};this._trigger("stop",event,this._uiHash());}
this.fromOutside=false;return true;},_trigger:function(){if($.Widget.prototype._trigger.apply(this,arguments)===false){this.cancel();}},_uiHash:function(_inst){var inst=_inst||this;return{helper:inst.helper,placeholder:inst.placeholder||$([]),position:inst.position,originalPosition:inst.originalPosition,offset:inst.positionAbs,item:inst.currentItem,sender:_inst?_inst.element:null};}});})(jQuery);(function($){function modifier(fn){return function(){var previous=this.element.val();fn.apply(this,arguments);this._refresh();if(previous!==this.element.val()){this._trigger("change");}};}
$.widget("ui.spinner",{version:"1.9.2",defaultElement:"<input>",widgetEventPrefix:"spin",options:{culture:null,icons:{down:"ui-icon-triangle-1-s",up:"ui-icon-triangle-1-n"},incremental:true,max:null,min:null,numberFormat:null,page:10,step:1,change:null,spin:null,start:null,stop:null},_create:function(){this._setOption("max",this.options.max);this._setOption("min",this.options.min);this._setOption("step",this.options.step);this._value(this.element.val(),true);this._draw();this._on(this._events);this._refresh();this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete");}});},_getCreateOptions:function(){var options={},element=this.element;$.each(["min","max","step"],function(i,option){var value=element.attr(option);if(value!==undefined&&value.length){options[option]=value;}});return options;},_events:{keydown:function(event){if(this._start(event)&&this._keydown(event)){event.preventDefault();}},keyup:"_stop",focus:function(){this.previous=this.element.val();},blur:function(event){if(this.cancelBlur){delete this.cancelBlur;return;}
this._refresh();if(this.previous!==this.element.val()){this._trigger("change",event);}},mousewheel:function(event,delta){if(!delta){return;}
if(!this.spinning&&!this._start(event)){return false;}
this._spin((delta>0?1:-1)*this.options.step,event);clearTimeout(this.mousewheelTimer);this.mousewheelTimer=this._delay(function(){if(this.spinning){this._stop(event);}},100);event.preventDefault();},"mousedown .ui-spinner-button":function(event){var previous;previous=this.element[0]===this.document[0].activeElement?this.previous:this.element.val();function checkFocus(){var isActive=this.element[0]===this.document[0].activeElement;if(!isActive){this.element.focus();this.previous=previous;this._delay(function(){this.previous=previous;});}}
event.preventDefault();checkFocus.call(this);this.cancelBlur=true;this._delay(function(){delete this.cancelBlur;checkFocus.call(this);});if(this._start(event)===false){return;}
this._repeat(null,$(event.currentTarget).hasClass("ui-spinner-up")?1:-1,event);},"mouseup .ui-spinner-button":"_stop","mouseenter .ui-spinner-button":function(event){if(!$(event.currentTarget).hasClass("ui-state-active")){return;}
if(this._start(event)===false){return false;}
this._repeat(null,$(event.currentTarget).hasClass("ui-spinner-up")?1:-1,event);},"mouseleave .ui-spinner-button":"_stop"},_draw:function(){var uiSpinner=this.uiSpinner=this.element.addClass("ui-spinner-input").attr("autocomplete","off").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml());this.element.attr("role","spinbutton");this.buttons=uiSpinner.find(".ui-spinner-button").attr("tabIndex",-1).button().removeClass("ui-corner-all");if(this.buttons.height()>Math.ceil(uiSpinner.height()*0.5)&&uiSpinner.height()>0){uiSpinner.height(uiSpinner.height());}
if(this.options.disabled){this.disable();}},_keydown:function(event){var options=this.options,keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.UP:this._repeat(null,1,event);return true;case keyCode.DOWN:this._repeat(null,-1,event);return true;case keyCode.PAGE_UP:this._repeat(null,options.page,event);return true;case keyCode.PAGE_DOWN:this._repeat(null,-options.page,event);return true;}
return false;},_uiSpinnerHtml:function(){return"<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>";},_buttonHtml:function(){return""+"<a class='ui-spinner-button ui-spinner-up ui-corner-tr'>"+"<span class='ui-icon "+this.options.icons.up+"'>&#9650;</span>"+"</a>"+"<a class='ui-spinner-button ui-spinner-down ui-corner-br'>"+"<span class='ui-icon "+this.options.icons.down+"'>&#9660;</span>"+"</a>";},_start:function(event){if(!this.spinning&&this._trigger("start",event)===false){return false;}
if(!this.counter){this.counter=1;}
this.spinning=true;return true;},_repeat:function(i,steps,event){i=i||500;clearTimeout(this.timer);this.timer=this._delay(function(){this._repeat(40,steps,event);},i);this._spin(steps*this.options.step,event);},_spin:function(step,event){var value=this.value()||0;if(!this.counter){this.counter=1;}
value=this._adjustValue(value+step*this._increment(this.counter));if(!this.spinning||this._trigger("spin",event,{value:value})!==false){this._value(value);this.counter++;}},_increment:function(i){var incremental=this.options.incremental;if(incremental){return $.isFunction(incremental)?incremental(i):Math.floor(i*i*i/50000-i*i/500+17*i/200+1);}
return 1;},_precision:function(){var precision=this._precisionOf(this.options.step);if(this.options.min!==null){precision=Math.max(precision,this._precisionOf(this.options.min));}
return precision;},_precisionOf:function(num){var str=num.toString(),decimal=str.indexOf(".");return decimal===-1?0:str.length-decimal-1;},_adjustValue:function(value){var base,aboveMin,options=this.options;base=options.min!==null?options.min:0;aboveMin=value-base;aboveMin=Math.round(aboveMin/options.step)*options.step;value=base+aboveMin;value=parseFloat(value.toFixed(this._precision()));if(options.max!==null&&value>options.max){return options.max;}
if(options.min!==null&&value<options.min){return options.min;}
return value;},_stop:function(event){if(!this.spinning){return;}
clearTimeout(this.timer);clearTimeout(this.mousewheelTimer);this.counter=0;this.spinning=false;this._trigger("stop",event);},_setOption:function(key,value){if(key==="culture"||key==="numberFormat"){var prevValue=this._parse(this.element.val());this.options[key]=value;this.element.val(this._format(prevValue));return;}
if(key==="max"||key==="min"||key==="step"){if(typeof value==="string"){value=this._parse(value);}}
this._super(key,value);if(key==="disabled"){if(value){this.element.prop("disabled",true);this.buttons.button("disable");}else{this.element.prop("disabled",false);this.buttons.button("enable");}}},_setOptions:modifier(function(options){this._super(options);this._value(this.element.val());}),_parse:function(val){if(typeof val==="string"&&val!==""){val=window.Globalize&&this.options.numberFormat?Globalize.parseFloat(val,10,this.options.culture):+val;}
return val===""||isNaN(val)?null:val;},_format:function(value){if(value===""){return"";}
return window.Globalize&&this.options.numberFormat?Globalize.format(value,this.options.numberFormat,this.options.culture):value;},_refresh:function(){this.element.attr({"aria-valuemin":this.options.min,"aria-valuemax":this.options.max,"aria-valuenow":this._parse(this.element.val())});},_value:function(value,allowAny){var parsed;if(value!==""){parsed=this._parse(value);if(parsed!==null){if(!allowAny){parsed=this._adjustValue(parsed);}
value=this._format(parsed);}}
this.element.val(value);this._refresh();},_destroy:function(){this.element.removeClass("ui-spinner-input").prop("disabled",false).removeAttr("autocomplete").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow");this.uiSpinner.replaceWith(this.element);},stepUp:modifier(function(steps){this._stepUp(steps);}),_stepUp:function(steps){this._spin((steps||1)*this.options.step);},stepDown:modifier(function(steps){this._stepDown(steps);}),_stepDown:function(steps){this._spin((steps||1)*-this.options.step);},pageUp:modifier(function(pages){this._stepUp((pages||1)*this.options.page);}),pageDown:modifier(function(pages){this._stepDown((pages||1)*this.options.page);}),value:function(newVal){if(!arguments.length){return this._parse(this.element.val());}
modifier(this._value).call(this,newVal);},widget:function(){return this.uiSpinner;}});}(jQuery));(function($,undefined){var tabId=0,rhash=/#.*$/;function getNextTabId(){return++tabId;}
function isLocal(anchor){return anchor.hash.length>1&&anchor.href.replace(rhash,"")===location.href.replace(rhash,"").replace(/\s/g,"%20");}
$.widget("ui.tabs",{version:"1.9.2",delay:300,options:{active:null,collapsible:false,event:"click",heightStyle:"content",hide:null,show:null,activate:null,beforeActivate:null,beforeLoad:null,load:null},_create:function(){var that=this,options=this.options,active=options.active,locationHash=location.hash.substring(1);this.running=false;this.element.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all").toggleClass("ui-tabs-collapsible",options.collapsible).delegate(".ui-tabs-nav > li","mousedown"+this.eventNamespace,function(event){if($(this).is(".ui-state-disabled")){event.preventDefault();}}).delegate(".ui-tabs-anchor","focus"+this.eventNamespace,function(){if($(this).closest("li").is(".ui-state-disabled")){this.blur();}});this._processTabs();if(active===null){if(locationHash){this.tabs.each(function(i,tab){if($(tab).attr("aria-controls")===locationHash){active=i;return false;}});}
if(active===null){active=this.tabs.index(this.tabs.filter(".ui-tabs-active"));}
if(active===null||active===-1){active=this.tabs.length?0:false;}}
if(active!==false){active=this.tabs.index(this.tabs.eq(active));if(active===-1){active=options.collapsible?false:0;}}
options.active=active;if(!options.collapsible&&options.active===false&&this.anchors.length){options.active=0;}
if($.isArray(options.disabled)){options.disabled=$.unique(options.disabled.concat($.map(this.tabs.filter(".ui-state-disabled"),function(li){return that.tabs.index(li);}))).sort();}
if(this.options.active!==false&&this.anchors.length){this.active=this._findActive(this.options.active);}else{this.active=$();}
this._refresh();if(this.active.length){this.load(options.active);}},_getCreateEventData:function(){return{tab:this.active,panel:!this.active.length?$():this._getPanelForTab(this.active)};},_tabKeydown:function(event){var focusedTab=$(this.document[0].activeElement).closest("li"),selectedIndex=this.tabs.index(focusedTab),goingForward=true;if(this._handlePageNav(event)){return;}
switch(event.keyCode){case $.ui.keyCode.RIGHT:case $.ui.keyCode.DOWN:selectedIndex++;break;case $.ui.keyCode.UP:case $.ui.keyCode.LEFT:goingForward=false;selectedIndex--;break;case $.ui.keyCode.END:selectedIndex=this.anchors.length-1;break;case $.ui.keyCode.HOME:selectedIndex=0;break;case $.ui.keyCode.SPACE:event.preventDefault();clearTimeout(this.activating);this._activate(selectedIndex);return;case $.ui.keyCode.ENTER:event.preventDefault();clearTimeout(this.activating);this._activate(selectedIndex===this.options.active?false:selectedIndex);return;default:return;}
event.preventDefault();clearTimeout(this.activating);selectedIndex=this._focusNextTab(selectedIndex,goingForward);if(!event.ctrlKey){focusedTab.attr("aria-selected","false");this.tabs.eq(selectedIndex).attr("aria-selected","true");this.activating=this._delay(function(){this.option("active",selectedIndex);},this.delay);}},_panelKeydown:function(event){if(this._handlePageNav(event)){return;}
if(event.ctrlKey&&event.keyCode===$.ui.keyCode.UP){event.preventDefault();this.active.focus();}},_handlePageNav:function(event){if(event.altKey&&event.keyCode===$.ui.keyCode.PAGE_UP){this._activate(this._focusNextTab(this.options.active-1,false));return true;}
if(event.altKey&&event.keyCode===$.ui.keyCode.PAGE_DOWN){this._activate(this._focusNextTab(this.options.active+1,true));return true;}},_findNextTab:function(index,goingForward){var lastTabIndex=this.tabs.length-1;function constrain(){if(index>lastTabIndex){index=0;}
if(index<0){index=lastTabIndex;}
return index;}
while($.inArray(constrain(),this.options.disabled)!==-1){index=goingForward?index+1:index-1;}
return index;},_focusNextTab:function(index,goingForward){index=this._findNextTab(index,goingForward);this.tabs.eq(index).focus();return index;},_setOption:function(key,value){if(key==="active"){this._activate(value);return;}
if(key==="disabled"){this._setupDisabled(value);return;}
this._super(key,value);if(key==="collapsible"){this.element.toggleClass("ui-tabs-collapsible",value);if(!value&&this.options.active===false){this._activate(0);}}
if(key==="event"){this._setupEvents(value);}
if(key==="heightStyle"){this._setupHeightStyle(value);}},_tabId:function(tab){return tab.attr("aria-controls")||"ui-tabs-"+getNextTabId();},_sanitizeSelector:function(hash){return hash?hash.replace(/[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g,"\\$&"):"";},refresh:function(){var options=this.options,lis=this.tablist.children(":has(a[href])");options.disabled=$.map(lis.filter(".ui-state-disabled"),function(tab){return lis.index(tab);});this._processTabs();if(options.active===false||!this.anchors.length){options.active=false;this.active=$();}else if(this.active.length&&!$.contains(this.tablist[0],this.active[0])){if(this.tabs.length===options.disabled.length){options.active=false;this.active=$();}else{this._activate(this._findNextTab(Math.max(0,options.active-1),false));}}else{options.active=this.tabs.index(this.active);}
this._refresh();},_refresh:function(){this._setupDisabled(this.options.disabled);this._setupEvents(this.options.event);this._setupHeightStyle(this.options.heightStyle);this.tabs.not(this.active).attr({"aria-selected":"false",tabIndex:-1});this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-expanded":"false","aria-hidden":"true"});if(!this.active.length){this.tabs.eq(0).attr("tabIndex",0);}else{this.active.addClass("ui-tabs-active ui-state-active").attr({"aria-selected":"true",tabIndex:0});this._getPanelForTab(this.active).show().attr({"aria-expanded":"true","aria-hidden":"false"});}},_processTabs:function(){var that=this;this.tablist=this._getList().addClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all").attr("role","tablist");this.tabs=this.tablist.find("> li:has(a[href])").addClass("ui-state-default ui-corner-top").attr({role:"tab",tabIndex:-1});this.anchors=this.tabs.map(function(){return $("a",this)[0];}).addClass("ui-tabs-anchor").attr({role:"presentation",tabIndex:-1});this.panels=$();this.anchors.each(function(i,anchor){var selector,panel,panelId,anchorId=$(anchor).uniqueId().attr("id"),tab=$(anchor).closest("li"),originalAriaControls=tab.attr("aria-controls");if(isLocal(anchor)){selector=anchor.hash;panel=that.element.find(that._sanitizeSelector(selector));}else{panelId=that._tabId(tab);selector="#"+panelId;panel=that.element.find(selector);if(!panel.length){panel=that._createPanel(panelId);panel.insertAfter(that.panels[i-1]||that.tablist);}
panel.attr("aria-live","polite");}
if(panel.length){that.panels=that.panels.add(panel);}
if(originalAriaControls){tab.data("ui-tabs-aria-controls",originalAriaControls);}
tab.attr({"aria-controls":selector.substring(1),"aria-labelledby":anchorId});panel.attr("aria-labelledby",anchorId);});this.panels.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").attr("role","tabpanel");},_getList:function(){return this.element.find("ol,ul").eq(0);},_createPanel:function(id){return $("<div>").attr("id",id).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").data("ui-tabs-destroy",true);},_setupDisabled:function(disabled){if($.isArray(disabled)){if(!disabled.length){disabled=false;}else if(disabled.length===this.anchors.length){disabled=true;}}
for(var i=0,li;(li=this.tabs[i]);i++){if(disabled===true||$.inArray(i,disabled)!==-1){$(li).addClass("ui-state-disabled").attr("aria-disabled","true");}else{$(li).removeClass("ui-state-disabled").removeAttr("aria-disabled");}}
this.options.disabled=disabled;},_setupEvents:function(event){var events={click:function(event){event.preventDefault();}};if(event){$.each(event.split(" "),function(index,eventName){events[eventName]="_eventHandler";});}
this._off(this.anchors.add(this.tabs).add(this.panels));this._on(this.anchors,events);this._on(this.tabs,{keydown:"_tabKeydown"});this._on(this.panels,{keydown:"_panelKeydown"});this._focusable(this.tabs);this._hoverable(this.tabs);},_setupHeightStyle:function(heightStyle){var maxHeight,overflow,parent=this.element.parent();if(heightStyle==="fill"){if(!$.support.minHeight){overflow=parent.css("overflow");parent.css("overflow","hidden");}
maxHeight=parent.height();this.element.siblings(":visible").each(function(){var elem=$(this),position=elem.css("position");if(position==="absolute"||position==="fixed"){return;}
maxHeight-=elem.outerHeight(true);});if(overflow){parent.css("overflow",overflow);}
this.element.children().not(this.panels).each(function(){maxHeight-=$(this).outerHeight(true);});this.panels.each(function(){$(this).height(Math.max(0,maxHeight-
$(this).innerHeight()+$(this).height()));}).css("overflow","auto");}else if(heightStyle==="auto"){maxHeight=0;this.panels.each(function(){maxHeight=Math.max(maxHeight,$(this).height("").height());}).height(maxHeight);}},_eventHandler:function(event){var options=this.options,active=this.active,anchor=$(event.currentTarget),tab=anchor.closest("li"),clickedIsActive=tab[0]===active[0],collapsing=clickedIsActive&&options.collapsible,toShow=collapsing?$():this._getPanelForTab(tab),toHide=!active.length?$():this._getPanelForTab(active),eventData={oldTab:active,oldPanel:toHide,newTab:collapsing?$():tab,newPanel:toShow};event.preventDefault();if(tab.hasClass("ui-state-disabled")||tab.hasClass("ui-tabs-loading")||this.running||(clickedIsActive&&!options.collapsible)||(this._trigger("beforeActivate",event,eventData)===false)){return;}
options.active=collapsing?false:this.tabs.index(tab);this.active=clickedIsActive?$():tab;if(this.xhr){this.xhr.abort();}
if(!toHide.length&&!toShow.length){$.error("jQuery UI Tabs: Mismatching fragment identifier.");}
if(toShow.length){this.load(this.tabs.index(tab),event);}
this._toggle(event,eventData);},_toggle:function(event,eventData){var that=this,toShow=eventData.newPanel,toHide=eventData.oldPanel;this.running=true;function complete(){that.running=false;that._trigger("activate",event,eventData);}
function show(){eventData.newTab.closest("li").addClass("ui-tabs-active ui-state-active");if(toShow.length&&that.options.show){that._show(toShow,that.options.show,complete);}else{toShow.show();complete();}}
if(toHide.length&&this.options.hide){this._hide(toHide,this.options.hide,function(){eventData.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active");show();});}else{eventData.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active");toHide.hide();show();}
toHide.attr({"aria-expanded":"false","aria-hidden":"true"});eventData.oldTab.attr("aria-selected","false");if(toShow.length&&toHide.length){eventData.oldTab.attr("tabIndex",-1);}else if(toShow.length){this.tabs.filter(function(){return $(this).attr("tabIndex")===0;}).attr("tabIndex",-1);}
toShow.attr({"aria-expanded":"true","aria-hidden":"false"});eventData.newTab.attr({"aria-selected":"true",tabIndex:0});},_activate:function(index){var anchor,active=this._findActive(index);if(active[0]===this.active[0]){return;}
if(!active.length){active=this.active;}
anchor=active.find(".ui-tabs-anchor")[0];this._eventHandler({target:anchor,currentTarget:anchor,preventDefault:$.noop});},_findActive:function(index){return index===false?$():this.tabs.eq(index);},_getIndex:function(index){if(typeof index==="string"){index=this.anchors.index(this.anchors.filter("[href$='"+index+"']"));}
return index;},_destroy:function(){if(this.xhr){this.xhr.abort();}
this.element.removeClass("ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible");this.tablist.removeClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all").removeAttr("role");this.anchors.removeClass("ui-tabs-anchor").removeAttr("role").removeAttr("tabIndex").removeData("href.tabs").removeData("load.tabs").removeUniqueId();this.tabs.add(this.panels).each(function(){if($.data(this,"ui-tabs-destroy")){$(this).remove();}else{$(this).removeClass("ui-state-default ui-state-active ui-state-disabled "+"ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel").removeAttr("tabIndex").removeAttr("aria-live").removeAttr("aria-busy").removeAttr("aria-selected").removeAttr("aria-labelledby").removeAttr("aria-hidden").removeAttr("aria-expanded").removeAttr("role");}});this.tabs.each(function(){var li=$(this),prev=li.data("ui-tabs-aria-controls");if(prev){li.attr("aria-controls",prev);}else{li.removeAttr("aria-controls");}});this.panels.show();if(this.options.heightStyle!=="content"){this.panels.css("height","");}},enable:function(index){var disabled=this.options.disabled;if(disabled===false){return;}
if(index===undefined){disabled=false;}else{index=this._getIndex(index);if($.isArray(disabled)){disabled=$.map(disabled,function(num){return num!==index?num:null;});}else{disabled=$.map(this.tabs,function(li,num){return num!==index?num:null;});}}
this._setupDisabled(disabled);},disable:function(index){var disabled=this.options.disabled;if(disabled===true){return;}
if(index===undefined){disabled=true;}else{index=this._getIndex(index);if($.inArray(index,disabled)!==-1){return;}
if($.isArray(disabled)){disabled=$.merge([index],disabled).sort();}else{disabled=[index];}}
this._setupDisabled(disabled);},load:function(index,event){index=this._getIndex(index);var that=this,tab=this.tabs.eq(index),anchor=tab.find(".ui-tabs-anchor"),panel=this._getPanelForTab(tab),eventData={tab:tab,panel:panel};if(isLocal(anchor[0])){return;}
this.xhr=$.ajax(this._ajaxSettings(anchor,event,eventData));if(this.xhr&&this.xhr.statusText!=="canceled"){tab.addClass("ui-tabs-loading");panel.attr("aria-busy","true");this.xhr.success(function(response){setTimeout(function(){panel.html(response);that._trigger("load",event,eventData);},1);}).complete(function(jqXHR,status){setTimeout(function(){if(status==="abort"){that.panels.stop(false,true);}
tab.removeClass("ui-tabs-loading");panel.removeAttr("aria-busy");if(jqXHR===that.xhr){delete that.xhr;}},1);});}},_ajaxSettings:function(anchor,event,eventData){var that=this;return{url:anchor.attr("href"),beforeSend:function(jqXHR,settings){return that._trigger("beforeLoad",event,$.extend({jqXHR:jqXHR,ajaxSettings:settings},eventData));}};},_getPanelForTab:function(tab){var id=$(tab).attr("aria-controls");return this.element.find(this._sanitizeSelector("#"+id));}});if($.uiBackCompat!==false){$.ui.tabs.prototype._ui=function(tab,panel){return{tab:tab,panel:panel,index:this.anchors.index(tab)};};$.widget("ui.tabs",$.ui.tabs,{url:function(index,url){this.anchors.eq(index).attr("href",url);}});$.widget("ui.tabs",$.ui.tabs,{options:{ajaxOptions:null,cache:false},_create:function(){this._super();var that=this;this._on({tabsbeforeload:function(event,ui){if($.data(ui.tab[0],"cache.tabs")){event.preventDefault();return;}
ui.jqXHR.success(function(){if(that.options.cache){$.data(ui.tab[0],"cache.tabs",true);}});}});},_ajaxSettings:function(anchor,event,ui){var ajaxOptions=this.options.ajaxOptions;return $.extend({},ajaxOptions,{error:function(xhr,status){try{ajaxOptions.error(xhr,status,ui.tab.closest("li").index(),ui.tab[0]);}
catch(error){}}},this._superApply(arguments));},_setOption:function(key,value){if(key==="cache"&&value===false){this.anchors.removeData("cache.tabs");}
this._super(key,value);},_destroy:function(){this.anchors.removeData("cache.tabs");this._super();},url:function(index){this.anchors.eq(index).removeData("cache.tabs");this._superApply(arguments);}});$.widget("ui.tabs",$.ui.tabs,{abort:function(){if(this.xhr){this.xhr.abort();}}});$.widget("ui.tabs",$.ui.tabs,{options:{spinner:"<em>Loading&#8230;</em>"},_create:function(){this._super();this._on({tabsbeforeload:function(event,ui){if(event.target!==this.element[0]||!this.options.spinner){return;}
var span=ui.tab.find("span"),html=span.html();span.html(this.options.spinner);ui.jqXHR.complete(function(){span.html(html);});}});}});$.widget("ui.tabs",$.ui.tabs,{options:{enable:null,disable:null},enable:function(index){var options=this.options,trigger;if(index&&options.disabled===true||($.isArray(options.disabled)&&$.inArray(index,options.disabled)!==-1)){trigger=true;}
this._superApply(arguments);if(trigger){this._trigger("enable",null,this._ui(this.anchors[index],this.panels[index]));}},disable:function(index){var options=this.options,trigger;if(index&&options.disabled===false||($.isArray(options.disabled)&&$.inArray(index,options.disabled)===-1)){trigger=true;}
this._superApply(arguments);if(trigger){this._trigger("disable",null,this._ui(this.anchors[index],this.panels[index]));}}});$.widget("ui.tabs",$.ui.tabs,{options:{add:null,remove:null,tabTemplate:"<li><a href='#{href}'><span>#{label}</span></a></li>"},add:function(url,label,index){if(index===undefined){index=this.anchors.length;}
var doInsertAfter,panel,options=this.options,li=$(options.tabTemplate.replace(/#\{href\}/g,url).replace(/#\{label\}/g,label)),id=!url.indexOf("#")?url.replace("#",""):this._tabId(li);li.addClass("ui-state-default ui-corner-top").data("ui-tabs-destroy",true);li.attr("aria-controls",id);doInsertAfter=index>=this.tabs.length;panel=this.element.find("#"+id);if(!panel.length){panel=this._createPanel(id);if(doInsertAfter){if(index>0){panel.insertAfter(this.panels.eq(-1));}else{panel.appendTo(this.element);}}else{panel.insertBefore(this.panels[index]);}}
panel.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").hide();if(doInsertAfter){li.appendTo(this.tablist);}else{li.insertBefore(this.tabs[index]);}
options.disabled=$.map(options.disabled,function(n){return n>=index?++n:n;});this.refresh();if(this.tabs.length===1&&options.active===false){this.option("active",0);}
this._trigger("add",null,this._ui(this.anchors[index],this.panels[index]));return this;},remove:function(index){index=this._getIndex(index);var options=this.options,tab=this.tabs.eq(index).remove(),panel=this._getPanelForTab(tab).remove();if(tab.hasClass("ui-tabs-active")&&this.anchors.length>2){this._activate(index+(index+1<this.anchors.length?1:-1));}
options.disabled=$.map($.grep(options.disabled,function(n){return n!==index;}),function(n){return n>=index?--n:n;});this.refresh();this._trigger("remove",null,this._ui(tab.find("a")[0],panel[0]));return this;}});$.widget("ui.tabs",$.ui.tabs,{length:function(){return this.anchors.length;}});$.widget("ui.tabs",$.ui.tabs,{options:{idPrefix:"ui-tabs-"},_tabId:function(tab){var a=tab.is("li")?tab.find("a[href]"):tab;a=a[0];return $(a).closest("li").attr("aria-controls")||a.title&&a.title.replace(/\s/g,"_").replace(/[^\w\u00c0-\uFFFF\-]/g,"")||this.options.idPrefix+getNextTabId();}});$.widget("ui.tabs",$.ui.tabs,{options:{panelTemplate:"<div></div>"},_createPanel:function(id){return $(this.options.panelTemplate).attr("id",id).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").data("ui-tabs-destroy",true);}});$.widget("ui.tabs",$.ui.tabs,{_create:function(){var options=this.options;if(options.active===null&&options.selected!==undefined){options.active=options.selected===-1?false:options.selected;}
this._super();options.selected=options.active;if(options.selected===false){options.selected=-1;}},_setOption:function(key,value){if(key!=="selected"){return this._super(key,value);}
var options=this.options;this._super("active",value===-1?false:value);options.selected=options.active;if(options.selected===false){options.selected=-1;}},_eventHandler:function(){this._superApply(arguments);this.options.selected=this.options.active;if(this.options.selected===false){this.options.selected=-1;}}});$.widget("ui.tabs",$.ui.tabs,{options:{show:null,select:null},_create:function(){this._super();if(this.options.active!==false){this._trigger("show",null,this._ui(this.active.find(".ui-tabs-anchor")[0],this._getPanelForTab(this.active)[0]));}},_trigger:function(type,event,data){var tab,panel,ret=this._superApply(arguments);if(!ret){return false;}
if(type==="beforeActivate"){tab=data.newTab.length?data.newTab:data.oldTab;panel=data.newPanel.length?data.newPanel:data.oldPanel;ret=this._super("select",event,{tab:tab.find(".ui-tabs-anchor")[0],panel:panel[0],index:tab.closest("li").index()});}else if(type==="activate"&&data.newTab.length){ret=this._super("show",event,{tab:data.newTab.find(".ui-tabs-anchor")[0],panel:data.newPanel[0],index:data.newTab.closest("li").index()});}
return ret;}});$.widget("ui.tabs",$.ui.tabs,{select:function(index){index=this._getIndex(index);if(index===-1){if(this.options.collapsible&&this.options.selected!==-1){index=this.options.selected;}else{return;}}
this.anchors.eq(index).trigger(this.options.event+this.eventNamespace);}});(function(){var listId=0;$.widget("ui.tabs",$.ui.tabs,{options:{cookie:null},_create:function(){var options=this.options,active;if(options.active==null&&options.cookie){active=parseInt(this._cookie(),10);if(active===-1){active=false;}
options.active=active;}
this._super();},_cookie:function(active){var cookie=[this.cookie||(this.cookie=this.options.cookie.name||"ui-tabs-"+(++listId))];if(arguments.length){cookie.push(active===false?-1:active);cookie.push(this.options.cookie);}
return $.cookie.apply(null,cookie);},_refresh:function(){this._super();if(this.options.cookie){this._cookie(this.options.active,this.options.cookie);}},_eventHandler:function(){this._superApply(arguments);if(this.options.cookie){this._cookie(this.options.active,this.options.cookie);}},_destroy:function(){this._super();if(this.options.cookie){this._cookie(null,this.options.cookie);}}});})();$.widget("ui.tabs",$.ui.tabs,{_trigger:function(type,event,data){var _data=$.extend({},data);if(type==="load"){_data.panel=_data.panel[0];_data.tab=_data.tab.find(".ui-tabs-anchor")[0];}
return this._super(type,event,_data);}});$.widget("ui.tabs",$.ui.tabs,{options:{fx:null},_getFx:function(){var hide,show,fx=this.options.fx;if(fx){if($.isArray(fx)){hide=fx[0];show=fx[1];}else{hide=show=fx;}}
return fx?{show:show,hide:hide}:null;},_toggle:function(event,eventData){var that=this,toShow=eventData.newPanel,toHide=eventData.oldPanel,fx=this._getFx();if(!fx){return this._super(event,eventData);}
that.running=true;function complete(){that.running=false;that._trigger("activate",event,eventData);}
function show(){eventData.newTab.closest("li").addClass("ui-tabs-active ui-state-active");if(toShow.length&&fx.show){toShow.animate(fx.show,fx.show.duration,function(){complete();});}else{toShow.show();complete();}}
if(toHide.length&&fx.hide){toHide.animate(fx.hide,fx.hide.duration,function(){eventData.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active");show();});}else{eventData.oldTab.closest("li").removeClass("ui-tabs-active ui-state-active");toHide.hide();show();}}});}})(jQuery);(function($){var increments=0;function addDescribedBy(elem,id){var describedby=(elem.attr("aria-describedby")||"").split(/\s+/);describedby.push(id);elem.data("ui-tooltip-id",id).attr("aria-describedby",$.trim(describedby.join(" ")));}
function removeDescribedBy(elem){var id=elem.data("ui-tooltip-id"),describedby=(elem.attr("aria-describedby")||"").split(/\s+/),index=$.inArray(id,describedby);if(index!==-1){describedby.splice(index,1);}
elem.removeData("ui-tooltip-id");describedby=$.trim(describedby.join(" "));if(describedby){elem.attr("aria-describedby",describedby);}else{elem.removeAttr("aria-describedby");}}
$.widget("ui.tooltip",{version:"1.9.2",options:{content:function(){return $(this).attr("title");},hide:true,items:"[title]:not([disabled])",position:{my:"left top+15",at:"left bottom",collision:"flipfit flip"},show:true,tooltipClass:null,track:false,close:null,open:null},_create:function(){this._on({mouseover:"open",focusin:"open"});this.tooltips={};this.parents={};if(this.options.disabled){this._disable();}},_setOption:function(key,value){var that=this;if(key==="disabled"){this[value?"_disable":"_enable"]();this.options[key]=value;return;}
this._super(key,value);if(key==="content"){$.each(this.tooltips,function(id,element){that._updateContent(element);});}},_disable:function(){var that=this;$.each(this.tooltips,function(id,element){var event=$.Event("blur");event.target=event.currentTarget=element[0];that.close(event,true);});this.element.find(this.options.items).andSelf().each(function(){var element=$(this);if(element.is("[title]")){element.data("ui-tooltip-title",element.attr("title")).attr("title","");}});},_enable:function(){this.element.find(this.options.items).andSelf().each(function(){var element=$(this);if(element.data("ui-tooltip-title")){element.attr("title",element.data("ui-tooltip-title"));}});},open:function(event){var that=this,target=$(event?event.target:this.element).closest(this.options.items);if(!target.length||target.data("ui-tooltip-id")){return;}
if(target.attr("title")){target.data("ui-tooltip-title",target.attr("title"));}
target.data("ui-tooltip-open",true);if(event&&event.type==="mouseover"){target.parents().each(function(){var parent=$(this),blurEvent;if(parent.data("ui-tooltip-open")){blurEvent=$.Event("blur");blurEvent.target=blurEvent.currentTarget=this;that.close(blurEvent,true);}
if(parent.attr("title")){parent.uniqueId();that.parents[this.id]={element:this,title:parent.attr("title")};parent.attr("title","");}});}
this._updateContent(target,event);},_updateContent:function(target,event){var content,contentOption=this.options.content,that=this,eventType=event?event.type:null;if(typeof contentOption==="string"){return this._open(event,target,contentOption);}
content=contentOption.call(target[0],function(response){if(!target.data("ui-tooltip-open")){return;}
that._delay(function(){if(event){event.type=eventType;}
this._open(event,target,response);});});if(content){this._open(event,target,content);}},_open:function(event,target,content){var tooltip,events,delayedShow,positionOption=$.extend({},this.options.position);if(!content){return;}
tooltip=this._find(target);if(tooltip.length){tooltip.find(".ui-tooltip-content").html(content);return;}
if(target.is("[title]")){if(event&&event.type==="mouseover"){target.attr("title","");}else{target.removeAttr("title");}}
tooltip=this._tooltip(target);addDescribedBy(target,tooltip.attr("id"));tooltip.find(".ui-tooltip-content").html(content);function position(event){positionOption.of=event;if(tooltip.is(":hidden")){return;}
tooltip.position(positionOption);}
if(this.options.track&&event&&/^mouse/.test(event.type)){this._on(this.document,{mousemove:position});position(event);}else{tooltip.position($.extend({of:target},this.options.position));}
tooltip.hide();this._show(tooltip,this.options.show);if(this.options.show&&this.options.show.delay){delayedShow=setInterval(function(){if(tooltip.is(":visible")){position(positionOption.of);clearInterval(delayedShow);}},$.fx.interval);}
this._trigger("open",event,{tooltip:tooltip});events={keyup:function(event){if(event.keyCode===$.ui.keyCode.ESCAPE){var fakeEvent=$.Event(event);fakeEvent.currentTarget=target[0];this.close(fakeEvent,true);}},remove:function(){this._removeTooltip(tooltip);}};if(!event||event.type==="mouseover"){events.mouseleave="close";}
if(!event||event.type==="focusin"){events.focusout="close";}
this._on(true,target,events);},close:function(event){var that=this,target=$(event?event.currentTarget:this.element),tooltip=this._find(target);if(this.closing){return;}
if(target.data("ui-tooltip-title")){target.attr("title",target.data("ui-tooltip-title"));}
removeDescribedBy(target);tooltip.stop(true);this._hide(tooltip,this.options.hide,function(){that._removeTooltip($(this));});target.removeData("ui-tooltip-open");this._off(target,"mouseleave focusout keyup");if(target[0]!==this.element[0]){this._off(target,"remove");}
this._off(this.document,"mousemove");if(event&&event.type==="mouseleave"){$.each(this.parents,function(id,parent){$(parent.element).attr("title",parent.title);delete that.parents[id];});}
this.closing=true;this._trigger("close",event,{tooltip:tooltip});this.closing=false;},_tooltip:function(element){var id="ui-tooltip-"+increments++,tooltip=$("<div>").attr({id:id,role:"tooltip"}).addClass("ui-tooltip ui-widget ui-corner-all ui-widget-content "+
(this.options.tooltipClass||""));$("<div>").addClass("ui-tooltip-content").appendTo(tooltip);tooltip.appendTo(this.document[0].body);if($.fn.bgiframe){tooltip.bgiframe();}
this.tooltips[id]=element;return tooltip;},_find:function(target){var id=target.data("ui-tooltip-id");return id?$("#"+id):$();},_removeTooltip:function(tooltip){tooltip.remove();delete this.tooltips[tooltip.attr("id")];},_destroy:function(){var that=this;$.each(this.tooltips,function(id,element){var event=$.Event("blur");event.target=event.currentTarget=element[0];that.close(event,true);$("#"+id).remove();if(element.data("ui-tooltip-title")){element.attr("title",element.data("ui-tooltip-title"));element.removeData("ui-tooltip-title");}});}});}(jQuery));;

/****** FILE: framework/thirdparty/json-js/json2.js *****/

var JSON=JSON||{};(function(){function f(n){return n<10?'0'+n:n;}
if(typeof Date.prototype.toJSON!=='function'){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+'-'+
f(this.getUTCMonth()+1)+'-'+
f(this.getUTCDate())+'T'+
f(this.getUTCHours())+':'+
f(this.getUTCMinutes())+':'+
f(this.getUTCSeconds())+'Z':null;};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf();};}
var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={'\b':'\\b','\t':'\\t','\n':'\\n','\f':'\\f','\r':'\\r','"':'\\"','\\':'\\\\'},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==='string'?c:'\\u'+('0000'+a.charCodeAt(0).toString(16)).slice(-4);})+'"':'"'+string+'"';}
function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==='object'&&typeof value.toJSON==='function'){value=value.toJSON(key);}
if(typeof rep==='function'){value=rep.call(holder,key,value);}
switch(typeof value){case'string':return quote(value);case'number':return isFinite(value)?String(value):'null';case'boolean':case'null':return String(value);case'object':if(!value){return'null';}
gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==='[object Array]'){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||'null';}
v=partial.length===0?'[]':gap?'[\n'+gap+
partial.join(',\n'+gap)+'\n'+
mind+']':'['+partial.join(',')+']';gap=mind;return v;}
if(rep&&typeof rep==='object'){length=rep.length;for(i=0;i<length;i+=1){k=rep[i];if(typeof k==='string'){v=str(k,value);if(v){partial.push(quote(k)+(gap?': ':':')+v);}}}}else{for(k in value){if(Object.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?': ':':')+v);}}}}
v=partial.length===0?'{}':gap?'{\n'+gap+partial.join(',\n'+gap)+'\n'+
mind+'}':'{'+partial.join(',')+'}';gap=mind;return v;}}
if(typeof JSON.stringify!=='function'){JSON.stringify=function(value,replacer,space){var i;gap='';indent='';if(typeof space==='number'){for(i=0;i<space;i+=1){indent+=' ';}}else if(typeof space==='string'){indent=space;}
rep=replacer;if(replacer&&typeof replacer!=='function'&&(typeof replacer!=='object'||typeof replacer.length!=='number')){throw new Error('JSON.stringify');}
return str('',{'':value});};}
if(typeof JSON.parse!=='function'){JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==='object'){for(k in value){if(Object.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v;}else{delete value[k];}}}}
return reviver.call(holder,key,value);}
cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return'\\u'+
('0000'+a.charCodeAt(0).toString(16)).slice(-4);});}
if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,'@').replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,']').replace(/(?:^|:|,)(?:\s*\[)+/g,''))){j=eval('('+text+')');return typeof reviver==='function'?walk({'':j},''):j;}
throw new SyntaxError('JSON.parse');};}}());;

/****** FILE: framework/thirdparty/jquery-entwine/dist/jquery.entwine-dist.js *****/

var Base;(function(){var marker={},fnTest=/xyz/.test(function(){var xyz;})?/\b_super\b/:/.*/;Base=function(){};Base.addMethod=function(name,func){var parent=this._super&&this._super.prototype;if(parent&&fnTest.test(func)){this.prototype[name]=function(){var tmp=this._super;this._super=parent[name];try{var ret=func.apply(this,arguments);}
finally{this._super=tmp;}
return ret;};}
else this.prototype[name]=func;};Base.addMethods=function(props){for(var name in props){if(typeof props[name]=='function')this.addMethod(name,props[name]);else this.prototype[name]=props[name];}};Base.subclassOf=function(parentkls){var kls=this;while(kls){if(kls===parentkls)return true;kls=kls._super;}};Base.extend=function(props){var Kls=function(){if(arguments[0]===marker)return;if(this instanceof Kls){if(this.init)this.init.apply(this,arguments);}
else{var ret=new Kls(marker);if(ret.init)ret.init.apply(ret,arguments);return ret;}};Kls.constructor=Kls;Kls.extend=Base.extend;Kls.addMethod=Base.addMethod;Kls.addMethods=Base.addMethods;Kls.subclassOf=Base.subclassOf;Kls._super=this;Kls.prototype=new this(marker);Kls.prototype.constructor=Kls;Kls.addMethods(props);return Kls;};})();;(function($){var tokens={UNICODE:/\\[0-9a-f]{1,6}(?:\r\n|[ \n\r\t\f])?/,ESCAPE:/(?:UNICODE)|\\[^\n\r\f0-9a-f]/,NONASCII:/[^\x00-\x7F]/,NMSTART:/[_a-z]|(?:NONASCII)|(?:ESCAPE)/,NMCHAR:/[_a-z0-9-]|(?:NONASCII)|(?:ESCAPE)/,IDENT:/-?(?:NMSTART)(?:NMCHAR)*/,NL:/\n|\r\n|\r|\f/,STRING:/(?:STRING1)|(?:STRING2)|(?:STRINGBARE)/,STRING1:/"(?:(?:ESCAPE)|\\(?:NL)|[^\n\r\f\"])*"/,STRING2:/'(?:(?:ESCAPE)|\\(?:NL)|[^\n\r\f\'])*'/,STRINGBARE:/(?:(?:ESCAPE)|\\(?:NL)|[^\n\r\f\]])*/,FUNCTION:/(?:IDENT)\(\)/,INTEGER:/[0-9]+/,WITHN:/([-+])?(INTEGER)?(n)\s*(?:([-+])\s*(INTEGER))?/,WITHOUTN:/([-+])?(INTEGER)/};var rx={not:/:not\(/,not_end:/\)/,tag:/((?:IDENT)|\*)/,id:/#(IDENT)/,cls:/\.(IDENT)/,attr:/\[\s*(IDENT)\s*(?:([^=]?=)\s*(STRING)\s*)?\]/,pseudo_el:/(?::(first-line|first-letter|before|after))|(?:::((?:FUNCTION)|(?:IDENT)))/,pseudo_cls_nth:/:nth-child\(\s*(?:(?:WITHN)|(?:WITHOUTN)|(odd|even))\s*\)/,pseudo_cls:/:(IDENT)/,comb:/\s*(\+|~|>)\s*|\s+/,comma:/\s*,\s*/,important:/\s+!important\s*$/};var token=/[A-Z][A-Z0-9]+/;for(var k in rx){var m,src=rx[k].source;while(m=src.match(token))src=src.replace(m[0],tokens[m[0]].source);rx[k]=new RegExp(src,'gi');}
var ConsumableString=Base.extend({init:function(str){this.str=str;this.pos=0;},match:function(rx){var m;rx.lastIndex=this.pos;if((m=rx.exec(this.str))&&m.index==this.pos){this.pos=rx.lastIndex?rx.lastIndex:this.str.length;return m;}
return null;},peek:function(rx){var m;rx.lastIndex=this.pos;if((m=rx.exec(this.str))&&m.index==this.pos)return m;return null;},showpos:function(){return this.str.slice(0,this.pos)+'<HERE>'+this.str.slice(this.pos);},done:function(){return this.pos==this.str.length;}});var SelectorBase=Base.extend({});var SimpleSelector=SelectorBase.extend({init:function(){this.tag=null;this.id=null;this.classes=[];this.attrs=[];this.nots=[];this.pseudo_classes=[];this.pseudo_els=[];},parse:function(selector){var m;if(m=selector.match(rx.tag))this.tag=m[1];do{if(m=selector.match(rx.not)){this.nots[this.nots.length]=SelectorsGroup().parse(selector);if(!(m=selector.match(rx.not_end))){throw'Invalid :not term in selector';}}
else if(m=selector.match(rx.id))this.id=m[1];else if(m=selector.match(rx.cls))this.classes[this.classes.length]=m[1];else if(m=selector.match(rx.attr))this.attrs[this.attrs.length]=[m[1],m[2],m[3]];else if(m=selector.match(rx.pseudo_el))this.pseudo_els[this.pseudo_els.length]=m[1]||m[2];else if(m=selector.match(rx.pseudo_cls_nth)){if(m[3]){var a=parseInt((m[1]||'')+(m[2]||'1'));var b=parseInt((m[4]||'')+(m[5]||'0'));}
else{var a=m[8]?2:0;var b=m[8]?(4-m[8].length):parseInt((m[6]||'')+m[7]);}
this.pseudo_classes[this.pseudo_classes.length]=['nth-child',[a,b]];}
else if(m=selector.match(rx.pseudo_cls))this.pseudo_classes[this.pseudo_classes.length]=[m[1]];}while(m&&!selector.done());return this;}});var Selector=SelectorBase.extend({init:function(){this.parts=[];},parse:function(cons){this.parts[this.parts.length]=SimpleSelector().parse(cons);while(!cons.done()&&!cons.peek(rx.comma)&&(m=cons.match(rx.comb))){this.parts[this.parts.length]=m[1]||' ';this.parts[this.parts.length]=SimpleSelector().parse(cons);}
return this.parts.length==1?this.parts[0]:this;}});var SelectorsGroup=SelectorBase.extend({init:function(){this.parts=[];},parse:function(cons){this.parts[this.parts.length]=Selector().parse(cons);while(!cons.done()&&(m=cons.match(rx.comma))){this.parts[this.parts.length]=Selector().parse(cons);}
return this.parts.length==1?this.parts[0]:this;}});$.selector=function(s){var cons=ConsumableString(s);var res=SelectorsGroup().parse(cons);res.selector=s;if(!cons.done())throw'Could not parse selector - '+cons.showpos();else return res;};$.selector.SelectorBase=SelectorBase;$.selector.SimpleSelector=SimpleSelector;$.selector.Selector=Selector;$.selector.SelectorsGroup=SelectorsGroup;})(jQuery);;(function($){$.selector.SimpleSelector.addMethod('specifity',function(){if(this.spec)return this.spec;var spec=[this.id?1:0,this.classes.length+this.attrs.length+this.pseudo_classes.length,((this.tag&&this.tag!='*')?1:0)+this.pseudo_els.length];$.each(this.nots,function(i,not){var ns=not.specifity();spec[0]+=ns[0];spec[1]+=ns[1];spec[2]+=ns[2];});return this.spec=spec;});$.selector.Selector.addMethod('specifity',function(){if(this.spec)return this.spec;var spec=[0,0,0];$.each(this.parts,function(i,part){if(i%2)return;var ps=part.specifity();spec[0]+=ps[0];spec[1]+=ps[1];spec[2]+=ps[2];});return this.spec=spec;});$.selector.SelectorsGroup.addMethod('specifity',function(){if(this.spec)return this.spec;var spec=[0,0,0];$.each(this.parts,function(i,part){var ps=part.specifity();spec[0]+=ps[0];spec[1]+=ps[1];spec[2]+=ps[2];});return this.spec=spec;});})(jQuery);;(function($){var div=document.createElement('div');div.innerHTML='<form id="test"><input name="id" type="text"/></form>';var getAttributeDodgy=div.firstChild.getAttribute('id')!=='test';var hasElementTraversal=div.firstElementChild&&div.firstElementChild.tagName=='FORM';var hasChildren=div.children&&div.children[0].tagName=='FORM';var GOOD=/GOOD/g;var BAD=/BAD/g;var STARTS_WITH_QUOTES=/^['"]/g;var join=function(js){return js.join('\n');};var join_complex=function(js){var code=new String(js.join('\n'));code.complex=true;return code;};var varForAttr=function(attr){return'_'+attr.replace(/^[^A-Za-z]|[^A-Za-z0-9]/g,function(m){return'_0x'+m.charCodeAt(0).toString(16)+'_';});};var getAttr;if(!getAttributeDodgy){getAttr=function(attr){return'var '+varForAttr(attr)+' = el.getAttribute("'+attr+'");';};}
else{var getAttrIEMap={'class':'className','for':'htmlFor'};getAttr=function(attr){var ieattr=getAttrIEMap[attr]||attr;return'var '+varForAttr(attr)+' = el.getAttribute("'+ieattr+'",2) || (el.getAttributeNode("'+attr+'")||{}).nodeValue;';};}
var attrchecks={'-':'!K','=':'K != "V"','!=':'K == "V"','~=':'_WS_K.indexOf(" V ") == -1','^=':'!K || K.indexOf("V") != 0','*=':'!K || K.indexOf("V") == -1','$=':'!K || K.substr(K.length-"V".length) != "V"'};var State=$.selector.State=Base.extend({init:function(){this.reset();},reset:function(){this.attrs={};this.wsattrs={};},prev:function(){this.reset();if(hasElementTraversal)return'el = el.previousElementSibling';return'while((el = el.previousSibling) && el.nodeType != 1) {}';},next:function(){this.reset();if(hasElementTraversal)return'el = el.nextElementSibling';return'while((el = el.nextSibling) && el.nodeType != 1) {}';},prevLoop:function(body){this.reset();if(hasElementTraversal)return join(['while(el = el.previousElementSibling){',body]);return join(['while(el = el.previousSibling){','if (el.nodeType != 1) continue;',body]);},parent:function(){this.reset();return'el = el.parentNode;';},parentLoop:function(body){this.reset();return join(['while((el = el.parentNode) && el.nodeType == 1){',body,'}']);},uses_attr:function(attr){if(this.attrs[attr])return;this.attrs[attr]=true;return getAttr(attr);},uses_wsattr:function(attr){if(this.wsattrs[attr])return;this.wsattrs[attr]=true;return join([this.uses_attr(attr),'var _WS_'+varForAttr(attr)+' = " "+'+varForAttr(attr)+'+" ";']);},uses_jqueryFilters:function(){if(this.jqueryFiltersAdded)return;this.jqueryFiltersAdded=true;return'var _$filters = jQuery.find.selectors.filters;';},save:function(lbl){return'var el'+lbl+' = el;';},restore:function(lbl){this.reset();return'el = el'+lbl+';';}});var pseudoclschecks={'first-child':join(['var cel = el;','while(cel = cel.previousSibling){ if (cel.nodeType === 1) BAD; }']),'last-child':join(['var cel = el;','while(cel = cel.nextSibling){ if (cel.nodeType === 1) BAD; }']),'nth-child':function(a,b){var get_i=join(['var i = 1, cel = el;','while(cel = cel.previousSibling){','if (cel.nodeType === 1) i++;','}']);if(a==0)return join([get_i,'if (i- '+b+' != 0) BAD;']);else if(b==0&&a>=0)return join([get_i,'if (i%'+a+' != 0 || i/'+a+' < 0) BAD;']);else if(b==0&&a<0)return join(['BAD;']);else return join([get_i,'if ((i- '+b+')%'+a+' != 0 || (i- '+b+')/'+a+' < 0) BAD;']);}};pseudoclschecks['only-child']=join([pseudoclschecks['first-child'],pseudoclschecks['last-child']]);$.selector.SimpleSelector.addMethod('compile',function(el){var js=[];if(this.tag&&this.tag!='*'){js[js.length]='if (el.tagName != "'+this.tag.toUpperCase()+'") BAD;';}
if(this.id){js[js.length]=el.uses_attr('id');js[js.length]='if (_id !== "'+this.id+'") BAD;';}
if(this.classes.length){js[js.length]=el.uses_wsattr('class');$.each(this.classes,function(i,cls){js[js.length]='if (_WS__class.indexOf(" '+cls+' ") == -1) BAD;';});}
$.each(this.attrs,function(i,attr){js[js.length]=(attr[1]=='~=')?el.uses_wsattr(attr[0]):el.uses_attr(attr[0]);var check=attrchecks[attr[1]||'-'];check=check.replace(/K/g,varForAttr(attr[0])).replace(/V/g,attr[2]&&attr[2].match(STARTS_WITH_QUOTES)?attr[2].slice(1,-1):attr[2]);js[js.length]='if ('+check+') BAD;';});$.each(this.nots,function(i,not){var lbl=++lbl_id;var func=join(['l'+lbl+':{',not.compile(el).replace(BAD,'break l'+lbl).replace(GOOD,'BAD'),'}']);if(!(not instanceof $.selector.SimpleSelector))func=join([el.save(lbl),func,el.restore(lbl)]);js[js.length]=func;});$.each(this.pseudo_classes,function(i,pscls){var check=pseudoclschecks[pscls[0]];if(check){js[js.length]=(typeof check=='function'?check.apply(this,pscls[1]):check);}
else if(check=$.find.selectors.filters[pscls[0]]){js[js.length]=el.uses_jqueryFilters();js[js.length]='if (!_$filters.'+pscls[0]+'(el)) BAD;';}});js[js.length]='GOOD';return join(js);});var lbl_id=0;function as_subexpr(f){if(f.complex)
return join(['l'+(++lbl_id)+':{',f.replace(GOOD,'break l'+lbl_id),'}']);else
return f.replace(GOOD,'');}
var combines={' ':function(el,f1,f2){return join_complex([f2,'while(true){',el.parent(),'if (!el || el.nodeType !== 1) BAD;',f1.compile(el).replace(BAD,'continue'),'}']);},'>':function(el,f1,f2){return join([f2,el.parent(),'if (!el || el.nodeType !== 1) BAD;',f1.compile(el)]);},'~':function(el,f1,f2){return join_complex([f2,el.prevLoop(),f1.compile(el).replace(BAD,'continue'),'}','BAD;']);},'+':function(el,f1,f2){return join([f2,el.prev(),'if (!el) BAD;',f1.compile(el)]);}};$.selector.Selector.addMethod('compile',function(el){var l=this.parts.length;var expr=this.parts[--l].compile(el);while(l){var combinator=this.parts[--l];expr=combines[combinator](el,this.parts[--l],as_subexpr(expr));}
return expr;});$.selector.SelectorsGroup.addMethod('compile',function(el){var expr=[],lbl=++lbl_id;for(var i=0;i<this.parts.length;i++){expr[expr.length]=join([i==0?el.save(lbl):el.restore(lbl),'l'+lbl+'_'+i+':{',this.parts[i].compile(el).replace(BAD,'break l'+lbl+'_'+i),'}']);}
expr[expr.length]='BAD;';return join(expr);});$.selector.SelectorBase.addMethod('matches',function(el){this.matches=new Function('el',join(['if (!el) return false;',this.compile(new State()).replace(BAD,'return false').replace(GOOD,'return true')]));return this.matches(el);});})(jQuery);;(function($){var DIRECT=/DIRECT/g;var CONTEXT=/CONTEXT/g;var EITHER=/DIRECT|CONTEXT/g;$.selector.SelectorBase.addMethod('affectedBy',function(props){this.affectedBy=new Function('props',(['var direct_classes, context_classes, direct_attrs, context_attrs, t;',this.ABC_compile().replace(DIRECT,'direct').replace(CONTEXT,'context'),'return {classes: {context: context_classes, direct: direct_classes}, attrs: {context: context_attrs, direct: direct_attrs}};']).join("\n"));return this.affectedBy(props);});$.selector.SimpleSelector.addMethod('ABC_compile',function(){var parts=[];$.each(this.classes,function(i,cls){parts[parts.length]="if (t = props.classes['"+cls+"']) (DIRECT_classes || (DIRECT_classes = {}))['"+cls+"'] = t;";});$.each(this.nots,function(i,not){parts[parts.length]=not.ABC_compile();});return parts.join("\n");});$.selector.Selector.addMethod('ABC_compile',function(arg){var parts=[];var i=this.parts.length-1;parts[parts.length]=this.parts[i].ABC_compile();while((i=i-2)>=0)parts[parts.length]=this.parts[i].ABC_compile().replace(EITHER,'CONTEXT');return parts.join("\n");});$.selector.SelectorsGroup.addMethod('ABC_compile',function(){var parts=[];$.each(this.parts,function(i,part){parts[parts.length]=part.ABC_compile();});return parts.join("\n");});})(jQuery);;(function($){if($.support.focusinBubbles===undefined){$.support.focusinBubbles=!!($.browser.msie);}
if(!$.support.focusinBubbles&&!$.event.special.focusin){$.each({focus:'focusin',blur:'focusout'},function(original,fix){$.event.special[fix]={setup:function(){if(!this.addEventListener)return false;this.addEventListener(original,$.event.special[fix].handler,true);},teardown:function(){if(!this.removeEventListener)return false;this.removeEventListener(original,$.event.special[fix].handler,true);},handler:function(e){arguments[0]=$.event.fix(e);arguments[0].type=fix;return $.event.handle.apply(this,arguments);}};});}
(function(){var activeFocus=null;$(document).bind('focusin',function(e){var target=e.realTarget||e.target;if(activeFocus&&activeFocus!==target){e.type='focusout';$(activeFocus).trigger(e);e.type='focusin';e.target=target;}
activeFocus=target;}).bind('focusout',function(e){activeFocus=null;});})();})(jQuery);;try{console.log;}
catch(e){window.console=undefined;}
(function($){var sub=function(){function jQuerySub(selector,context){return new jQuerySub.fn.init(selector,context);}
jQuery.extend(true,jQuerySub,$);jQuerySub.superclass=$;jQuerySub.fn=jQuerySub.prototype=$();jQuerySub.fn.constructor=jQuerySub;jQuerySub.fn.init=function init(selector,context){if(context&&context instanceof jQuery&&!(context instanceof jQuerySub)){context=jQuerySub(context);}
return jQuery.fn.init.call(this,selector,context,rootjQuerySub);};jQuerySub.fn.init.prototype=jQuerySub.fn;var rootjQuerySub=jQuerySub(document);return jQuerySub;};var namespaces={};$.entwine=function(){$.fn.entwine.apply(null,arguments);};$.extend($.entwine,{namespaces:namespaces,clear_all_rules:function(){for(var k in $.fn){if($.fn[k].isentwinemethod)delete $.fn[k];}
$(document).unbind('.entwine');$(window).unbind('.entwine');for(var k in namespaces)delete namespaces[k];for(var k in $.entwine.capture_bindings)delete $.entwine.capture_bindings[k];},WARN_LEVEL_NONE:0,WARN_LEVEL_IMPORTANT:1,WARN_LEVEL_BESTPRACTISE:2,warningLevel:0,warn:function(message,level){if(level<=$.entwine.warningLevel&&console&&console.warn){console.warn(message);if(console.trace)console.trace();}},warn_exception:function(where,on,e){if($.entwine.WARN_LEVEL_IMPORTANT<=$.entwine.warningLevel&&console&&console.warn){if(arguments.length==2){e=on;on=null;}
if(on)console.warn('Uncaught exception',e,'in',where,'on',on);else console.warn('Uncaught exception',e,'in',where);if(e.stack)console.warn("Stack Trace:\n"+e.stack);}}});var rulecount=0;var Rule=Base.extend({init:function(selector,name){this.selector=selector;this.specifity=selector.specifity();this.important=0;this.name=name;this.rulecount=rulecount++;}});Rule.compare=function(a,b){var as=a.specifity,bs=b.specifity;return(a.important-b.important)||(as[0]-bs[0])||(as[1]-bs[1])||(as[2]-bs[2])||(a.rulecount-b.rulecount);};$.entwine.RuleList=function(){var list=[];list.addRule=function(selector,name){var rule=Rule(selector,name);list[list.length]=rule;list.sort(Rule.compare);return rule;};return list;};var handlers=[];$.entwine.Namespace=Base.extend({init:function(name){if(name&&!name.match(/^[A-Za-z0-9.]+$/))$.entwine.warn('Entwine namespace '+name+' is not formatted as period seperated identifiers',$.entwine.WARN_LEVEL_BESTPRACTISE);name=name||'__base';this.name=name;this.store={};namespaces[name]=this;if(name=="__base"){this.injectee=$.fn;this.$=$;}
else{this.$=$.sub?$.sub():sub();this.$.cache=$.cache;this.injectee=this.$.prototype;var entwine_wrapper=this.injectee.entwine=function(spacename){var args=arguments;if(!spacename||typeof spacename!='string'){args=$.makeArray(args);args.unshift(name);}
else if(spacename.charAt(0)!='.')args[0]=name+'.'+spacename;return $.fn.entwine.apply(this,args);};this.$.entwine=function(){entwine_wrapper.apply(null,arguments);};for(var i=0;i<handlers.length;i++){var handler=handlers[i],builder;if(builder=handler.namespaceMethodOverrides){var overrides=builder(this);for(var k in overrides)this.injectee[k]=overrides[k];}
if(builder=handler.namespaceStaticOverrides){var overrides=builder(this);for(var k in overrides)this.$.entwine[k]=overrides[k];}}}},one:function(name,funcprop,basefunc){var namespace=this;var funcs=this.store[name];var one=function(el,args,i){if(i===undefined)i=funcs.length;while(i--){if(funcs[i].selector.matches(el)){var ret,tmp_i=el.i,tmp_f=el.f;el.i=i;el.f=one;try{ret=funcs[i][funcprop].apply(namespace.$(el),args);}
finally{el.i=tmp_i;el.f=tmp_f;}
return ret;}}
if(basefunc)return basefunc.apply(namespace.$(el),args);};return one;},build_proxy:function(name,basefunc){var one=this.one(name,'func',basefunc);var prxy=function(){var rv,ctx=$(this);var i=ctx.length;while(i--)rv=one(ctx[i],arguments);return rv;};return prxy;},bind_proxy:function(selector,name,func){var rulelist=this.store[name]||(this.store[name]=$.entwine.RuleList());var rule=rulelist.addRule(selector,name);rule.func=func;if(!this.injectee.hasOwnProperty(name)||!this.injectee[name].isentwinemethod){this.injectee[name]=this.build_proxy(name,this.injectee.hasOwnProperty(name)?this.injectee[name]:null);this.injectee[name].isentwinemethod=true;}
if(!this.injectee[name].isentwinemethod){$.entwine.warn('Warning: Entwine function '+name+' clashes with regular jQuery function - entwine function will not be callable directly on jQuery object',$.entwine.WARN_LEVEL_IMPORTANT);}},add:function(selector,data){for(var k in data){var v=data[k];for(var i=0;i<handlers.length;i++){if(handlers[i].bind&&handlers[i].bind.call(this,selector,k,v))break;}}},has:function(ctx,name){var rulelist=this.store[name];if(!rulelist)return false;for(var i=0;i<rulelist.length;i++){ctx=ctx.not(rulelist[i].selector);if(!ctx.length)return true;}
return false;}});$.entwine.Namespace.addHandler=function(handler){for(var i=0;i<handlers.length&&handlers[i].order<handler.order;i++){}
handlers.splice(i,0,handler);};$.entwine.Namespace.addHandler({order:50,bind:function(selector,k,v){if($.isFunction(v)){this.bind_proxy(selector,k,v);return true;}}});$.extend($.fn,{entwine:function(spacename){var i=0;var selector=null;var namespace=namespaces.__base||$.entwine.Namespace();if(typeof spacename=='string'){if(spacename.charAt('0')=='.')spacename=spacename.substr(1);if(spacename)namespace=namespaces[spacename]||$.entwine.Namespace(spacename);i=1;}
while(i<arguments.length){var res=arguments[i++];if($.isFunction(res)){if(res.length!=1)$.entwine.warn('Function block inside entwine definition does not take $ argument properly',$.entwine.WARN_LEVEL_IMPORTANT);res=res.call(namespace.$(this),namespace.$);}
if(res){if(selector===null)selector=this.selector?$.selector(this.selector):false;if(selector)namespace.add(selector,res);else $.entwine.warn('Entwine block given to entwine call without selector. Make sure you call $(selector).entwine when defining blocks',$.entwine.WARN_LEVEL_IMPORTANT);}}
return namespace.$(this);},_super:function(){var rv,i=this.length;while(i--){var el=this[0];rv=el.f(el,arguments,el.i);}
return rv;}});})(jQuery);;(function($){function getElements(store,original){var node,i=store.length,next=original.firstChild;while((node=next)){if(node.nodeType===1)store[i++]=node;next=node.firstChild||node.nextSibling;while(!next&&(node=node.parentNode)&&node!==original)next=node.nextSibling;}}
function getElementsAlt(store,node){if(node.getElementsByTagName){var els=node.getElementsByTagName('*'),len=els.length,i=0,j=store.length;for(;i<len;i++,j++){store[j]=els[i];}}
else if(node.childNodes){var els=node.childNodes,len=els.length,i=0;for(;i<len;i++){getElements(store,els[i]);}}}
var dontTrigger=false;var patchDomManipCallback=function(original){var patched=function(elem){var added=[];if(!dontTrigger){if(elem.nodeType==1)added[added.length]=elem;getElements(added,elem);}
var rv=original.apply(this,arguments);if(!dontTrigger&&added.length){var event=$.Event('EntwineElementsAdded');event.targets=added;$(document).triggerHandler(event);}
return rv;}
patched.patched=true;return patched;}
var version=$.prototype.jquery.split('.');var callbackIdx=(version[0]>1||version[1]>=10?1:2);var _domManip=$.prototype.domManip;$.prototype.domManip=function(){if(!arguments[callbackIdx].patched)arguments[callbackIdx]=patchDomManipCallback(arguments[callbackIdx]);return _domManip.apply(this,arguments);}
var _html=$.prototype.html;$.prototype.html=function(value){if(value===undefined)return _html.apply(this,arguments);dontTrigger=true;var res=_html.apply(this,arguments);dontTrigger=false;var added=[];var i=0,length=this.length;for(;i<length;i++)getElements(added,this[i]);var event=$.Event('EntwineElementsAdded');event.targets=added;$(document).triggerHandler(event);return res;}
var supressActualClean=false;var _cleanData=$.cleanData;$.cleanData=function(elems){var removed=elems;if(supressActualClean){var i=0,len=elems.length,removed=[],ri=0;for(;i<len;i++){var node=elems[i],current=node;while(current=current.parentNode){if(current.nodeType==9){removed[ri++]=node;break;}}}}
if(removed.length){var event=$.Event('EntwineElementsRemoved');event.targets=removed;$(document).triggerHandler(event);}
if(!supressActualClean)_cleanData.apply(this,arguments);}
var _remove=$.prototype.remove;$.prototype.remove=function(selector,keepdata){supressActualClean=keepdata;var rv=_remove.call(this,selector);supressActualClean=false;return rv;}
$(function(){var added=[];getElements(added,document);var event=$.Event('EntwineElementsAdded');event.targets=added;$(document).triggerHandler(event);});})(jQuery);;(function($){var monkey=function(){var methods=$.makeArray(arguments);var patch=methods.pop();$.each(methods,function(i,method){var old=$.fn[method];$.fn[method]=function(){var self=this,args=$.makeArray(arguments);var rv=old.apply(self,args);patch.apply(self,args);return rv;}});}
var runSoon=window.setTimeout;var ChangeDetails=Base.extend({init:function(){this.global=false;this.attrs={};this.classes={};},triggerEvent:function(){if(changes!=this)return;if(this.check_id)clearTimeout(this.check_id);changes=new ChangeDetails();$(document).triggerHandler("EntwineSubtreeMaybeChanged",[this]);},changed:function(){if(!this.check_id){var self=this;this.check_id=runSoon(function(){self.check_id=null;self.triggerEvent();},10);}},addAll:function(){if(this.global)return this;this.global=true;this.changed();return this;},addSubtree:function(node){return this.addAll();},addSubtreeFuture:function(node){if(this.global)return this;this.subtree=this.subtree?this.subtree.add(node):$(node);this.changed();return this;},addAttr:function(attr,node){if(this.global)return this;this.attrs[attr]=(attr in this.attrs)?this.attrs[attr].add(node):$(node);this.changed();return this;},addClass:function(klass,node){if(this.global)return this;this.classes[klass]=(klass in this.classes)?this.classes[klass].add(node):$(node);this.changed();return this;}});var changes=new ChangeDetails();$(document).bind('EntwineElementsAdded',function(e){changes.addSubtree(e.targets);});var removed=null;$(document).bind('EntwineElementsRemoved',function(e){removed=e.targets;});monkey('remove','html','empty',function(){var subtree=removed;removed=null;if(subtree)changes.addSubtree(subtree);});monkey('removeAttr',function(attr){changes.addAttr(attr,this);});monkey('addClass','removeClass','toggleClass',function(klass){if(typeof klass=='string')changes.addClass(klass,this);});monkey('attr',function(a,b){if(b!==undefined&&typeof a=='string')changes.addAttr(a,this);else if(typeof a!='string'){for(var k in a)changes.addAttr(k,this);}});$.extend($.entwine,{synchronous_mode:function(){if(changes&&changes.check_id)clearTimeout(changes.check_id);changes=new ChangeDetails();runSoon=function(func,delay){func.call(this);return null;};},triggerMatching:function(){changes.addAll();}});})(jQuery);;(function($){if($.support.changeBubbles==undefined){$.support.changeBubbles=true;var el=document.createElement("div");eventName="onchange";if(el.attachEvent){var isSupported=(eventName in el);if(!isSupported){el.setAttribute(eventName,"return;");isSupported=typeof el[eventName]==="function";}
$.support.changeBubbles=isSupported;}}
if(document.compareDocumentPosition){var is_or_contains=function(a,b){return a&&b&&(a==b||!!(a.compareDocumentPosition(b)&16));};}
else{var is_or_contains=function(a,b){return a&&b&&(a==b||(a.contains?a.contains(b):true));};}
$.entwine.Namespace.addMethods({build_event_proxy:function(name){var one=this.one(name,'func');var prxy=function(e,data){e=e.delegatedEvent||e;var el=e.target;while(el&&el.nodeType==1&&!e.isPropagationStopped()){var ret=one(el,arguments);if(ret!==undefined)e.result=ret;if(ret===false){e.preventDefault();e.stopPropagation();}
el=el.parentNode;}};return prxy;},build_mouseenterleave_proxy:function(name){var one=this.one(name,'func');var prxy=function(e){var el=e.target;var rel=e.relatedTarget;while(el&&el.nodeType==1&&!e.isPropagationStopped()){if(is_or_contains(el,rel))break;var ret=one(el,arguments);if(ret!==undefined)e.result=ret;if(ret===false){e.preventDefault();e.stopPropagation();}
el=el.parentNode;}};return prxy;},build_change_proxy:function(name){var one=this.one(name,'func');var getVal=function(elem){var type=elem.type,val=elem.value;if(type==="radio"||type==="checkbox"){val=elem.checked;}
else if(type==="select-multiple"){val="";if(elem.selectedIndex>-1){val=jQuery.map(elem.options,function(elem){return elem.selected;}).join("-");}}
else if(jQuery.nodeName(elem,"select")){val=elem.selectedIndex;}
return val;};var rformElems=/^(?:textarea|input|select)$/i;var testChange=function(e){var elem=e.target,data,val;if(!rformElems.test(elem.nodeName)||elem.readOnly)return;data=jQuery.data(elem,"_entwine_change_data");val=getVal(elem);if(e.type!=="focusout"||elem.type!=="radio"){jQuery.data(elem,"_entwine_change_data",val);}
if(data===undefined||val===data)return;if(data!=null||val){e.type="change";while(elem&&elem.nodeType==1&&!e.isPropagationStopped()){var ret=one(elem,arguments);if(ret!==undefined)e.result=ret;if(ret===false){e.preventDefault();e.stopPropagation();}
elem=elem.parentNode;}}};var prxy=function(e){var event=e.type,elem=e.target,type=jQuery.nodeName(elem,"input")?elem.type:"";switch(event){case'focusout':case'beforedeactivate':testChange.apply(this,arguments);break;case'click':if(type==="radio"||type==="checkbox"||jQuery.nodeName(elem,"select")){testChange.apply(this,arguments);}
break;case'keydown':if((e.keyCode===13&&!jQuery.nodeName(elem,"textarea"))||(e.keyCode===32&&(type==="checkbox"||type==="radio"))||type==="select-multiple"){testChange.apply(this,arguments);}
break;case'focusin':case'beforeactivate':jQuery.data(elem,"_entwine_change_data",getVal(elem));break;}}
return prxy;},bind_event:function(selector,name,func,event){var funcs=this.store[name]||(this.store[name]=$.entwine.RuleList());var proxies=funcs.proxies||(funcs.proxies={});var rule=funcs.addRule(selector,name);rule.func=func;if(!proxies[name]){switch(name){case'onmouseenter':proxies[name]=this.build_mouseenterleave_proxy(name);event='mouseover';break;case'onmouseleave':proxies[name]=this.build_mouseenterleave_proxy(name);event='mouseout';break;case'onchange':if(!$.support.changeBubbles){proxies[name]=this.build_change_proxy(name);event='click keydown focusin focusout beforeactivate beforedeactivate';}
break;case'onsubmit':event='delegatedSubmit';break;case'onfocus':case'onblur':$.entwine.warn('Event '+event+' not supported - using focusin / focusout instead',$.entwine.WARN_LEVEL_IMPORTANT);}
if(!proxies[name])proxies[name]=this.build_event_proxy(name);$(document).bind(event.replace(/(\s+|$)/g,'.entwine$1'),proxies[name]);}}});$.entwine.Namespace.addHandler({order:40,bind:function(selector,k,v){var match,event;if($.isFunction(v)&&(match=k.match(/^on(.*)/))){event=match[1];this.bind_event(selector,k,v,event);return true;}}});var delegate_submit=function(e,data){var delegationEvent=$.Event('delegatedSubmit');delegationEvent.delegatedEvent=e;return $(document).trigger(delegationEvent,data);};$(document).bind('EntwineElementsAdded',function(e){var forms=$(e.targets).filter('form');if(!forms.length)return;forms.bind('submit.entwine_delegate_submit',delegate_submit);});})(jQuery);;(function($){$.entwine.Namespace.addMethods({bind_capture:function(selector,event,name,capture){var store=this.captures||(this.captures={});var rulelists=store[event]||(store[event]={});var rulelist=rulelists[name]||(rulelists[name]=$.entwine.RuleList());rule=rulelist.addRule(selector,event);rule.handler=name;this.bind_proxy(selector,name,capture);}});var bindings=$.entwine.capture_bindings={};var event_proxy=function(event){return function(e){var namespace,capturelists,forevent,capturelist,rule,handler,sel;for(var k in $.entwine.namespaces){namespace=$.entwine.namespaces[k];capturelists=namespace.captures;if(capturelists&&(forevent=capturelists[event])){for(var k in forevent){var capturelist=forevent[k];var triggered=namespace.$([]);var j=capturelist.length;while(j--){rule=capturelist[j];handler=rule.handler;sel=rule.selector.selector;var matching=namespace.$(sel).not(triggered);matching[handler].apply(matching,arguments);triggered=triggered.add(matching);}}}}}};var selector_proxy=function(selector,handler,includechildren){var matcher=$.selector(selector);return function(e){if(matcher.matches(e.target))return handler.apply(this,arguments);}};var document_proxy=function(selector,handler,includechildren){return function(e){if(e.target===document)return handler.apply(this,arguments);}};var window_proxy=function(selector,handler,includechildren){return function(e){if(e.target===window)return handler.apply(this,arguments);}};var property_proxy=function(property,handler,includechildren){var matcher;return function(e){var match=this['get'+property]();if(typeof(match)=='string'){var matcher=(matcher&&match==matcher.selector)?matcher:$.selector(match);if(matcher.matches(e.target))return handler.apply(this,arguments);}
else{if($.inArray(e.target,match)!==-1)return handler.apply(this,arguments);}}};$.entwine.Namespace.addHandler({order:10,bind:function(selector,k,v){var match;if($.isPlainObject(v)&&(match=k.match(/^from\s*(.*)/))){var from=match[1];var proxyGen;if(from.match(/[^\w]/))proxyGen=selector_proxy;else if(from=='Window'||from=='window')proxyGen=window_proxy;else if(from=='Document'||from=='document')proxyGen=document_proxy;else proxyGen=property_proxy;for(var onevent in v){var handler=v[onevent];match=onevent.match(/^on(.*)/);var event=match[1];this.bind_capture(selector,event,k+'_'+event,proxyGen(from,handler));if(!bindings[event]){var namespaced=event.replace(/(\s+|$)/g,'.entwine$1');bindings[event]=event_proxy(event);$(proxyGen==window_proxy?window:document).bind(namespaced,bindings[event]);}}
return true;}}});})(jQuery);;(function($){$.entwine.Namespace.addMethods({bind_condesc:function(selector,name,func){var ctors=this.store.ctors||(this.store.ctors=$.entwine.RuleList());var rule;for(var i=0;i<ctors.length;i++){if(ctors[i].selector.selector==selector.selector){rule=ctors[i];break;}}
if(!rule){rule=ctors.addRule(selector,'ctors');}
rule[name]=func;if(!ctors[name+'proxy']){var one=this.one('ctors',name);var namespace=this;var proxy=function(els,i,func){var j=els.length;while(j--){var el=els[j];var tmp_i=el.i,tmp_f=el.f;el.i=i;el.f=one;try{func.call(namespace.$(el));}
catch(e){$.entwine.warn_exception(name,el,e);}
finally{el.i=tmp_i;el.f=tmp_f;}}};ctors[name+'proxy']=proxy;}}});$.entwine.Namespace.addHandler({order:30,bind:function(selector,k,v){if($.isFunction(v)&&(k=='onmatch'||k=='onunmatch')){this.matchersDirty=true;this.bind_condesc(selector,k,v);return true;}}});$(document).bind('EntwineSubtreeMaybeChanged',function(e,changes){for(var k in $.entwine.namespaces){var namespace=$.entwine.namespaces[k];var ctors=namespace.store.ctors;if(ctors){var matched=null,taken=$([]),released=$([]);var calcmatched=function(j){if(matched!==null)return;matched=$([]);var cache,k=ctors.length;while((--k)>j){if(cache=ctors[k].cache)matched=matched.add(cache);}}
var add,rem,res,rule,sel,ctor,dtor,full;var j=ctors.length;while(j--){rule=ctors[j];sel=rule.selector.selector;ctor=rule.onmatch;dtor=rule.onunmatch;res=null;full=false;if(namespace.matchersDirty||changes.global){full=true;}
else{for(var k in changes.attrs){full=true;break;}
var method=rule.selector.affectedBy(changes);if(method.classes.context){full=true;}
else{for(var k in method.classes.direct){calcmatched(j);var recheck=changes.classes[k].not(matched);if(res===null){res=rule.cache?rule.cache.not(taken).add(released.filter(sel)):$([]);}
res=res.not(recheck).add(recheck.filter(sel));}}}
if(full){calcmatched(j);res=$(sel).not(matched);}
else{if(!res){add=released.length&&released.filter(sel);if(add&&add.length){res=rule.cache?rule.cache.not(taken).add(add):add;}
else{rem=taken.length&&rule.cache&&rule.cache.filter(taken);if(rem&&rem.length){res=rule.cache.not(rem);}}}}
if(res===null){if(matched&&rule.cache)matched=matched.add(rule.cache);}
else{if(rule.cache){add=res.not(rule.cache);rem=rule.cache.not(res);}
else{add=res;rem=null;}
if((add&&add.length)||(rem&&rem.length)){if(rem&&rem.length){released=released.add(rem);if(dtor&&!rule.onunmatchRunning){rule.onunmatchRunning=true;ctors.onunmatchproxy(rem,j,dtor);rule.onunmatchRunning=false;}}
if(add&&add.length){taken=taken.add(add);released=released.not(add);if(ctor&&!rule.onmatchRunning){rule.onmatchRunning=true;ctors.onmatchproxy(add,j,ctor);rule.onmatchRunning=false;}}}
if(matched)matched=matched.add(res);rule.cache=res;}}
namespace.matchersDirty=false;}}});})(jQuery);;(function($){$.entwine.Namespace.addMethods({build_addrem_proxy:function(name){var one=this.one(name,'func');return function(){if(this.length===0){return;}
else if(this.length){var rv,i=this.length;while(i--)rv=one(this[i],arguments);return rv;}
else{return one(this,arguments);}};},bind_addrem_proxy:function(selector,name,func){var rulelist=this.store[name]||(this.store[name]=$.entwine.RuleList());var rule=rulelist.addRule(selector,name);rule.func=func;if(!this.injectee.hasOwnProperty(name)){this.injectee[name]=this.build_addrem_proxy(name);this.injectee[name].isentwinemethod=true;}}});$.entwine.Namespace.addHandler({order:30,bind:function(selector,k,v){if($.isFunction(v)&&(k=='onadd'||k=='onremove')){this.bind_addrem_proxy(selector,k,v);return true;}}});$(document).bind('EntwineElementsAdded',function(e){for(var k in $.entwine.namespaces){var namespace=$.entwine.namespaces[k];if(namespace.injectee.onadd)namespace.injectee.onadd.call(e.targets);}});$(document).bind('EntwineElementsRemoved',function(e){for(var k in $.entwine.namespaces){var namespace=$.entwine.namespaces[k];if(namespace.injectee.onremove)namespace.injectee.onremove.call(e.targets);}});})(jQuery);;(function($){var entwine_prepend='__entwine!';var getEntwineData=function(el,namespace,property){return el.data(entwine_prepend+namespace+'!'+property);};var setEntwineData=function(el,namespace,property,value){return el.data(entwine_prepend+namespace+'!'+property,value);};var getEntwineDataAsHash=function(el,namespace){var hash={};var id=jQuery.data(el[0]);var matchstr=entwine_prepend+namespace+'!';var matchlen=matchstr.length;var cache=jQuery.cache[id];for(var k in cache){if(k.substr(0,matchlen)==matchstr)hash[k.substr(matchlen)]=cache[k];}
return hash;};var setEntwineDataFromHash=function(el,namespace,hash){for(var k in hash)setEntwineData(namespace,k,hash[k]);};var entwineData=function(el,namespace,args){switch(args.length){case 0:return getEntwineDataAsHash(el,namespace);case 1:if(typeof args[0]=='string')return getEntwineData(el,namespace,args[0]);else return setEntwineDataFromHash(el,namespace,args[0]);default:return setEntwineData(el,namespace,args[0],args[1]);}};$.extend($.fn,{entwineData:function(){return entwineData(this,'__base',arguments);}});$.entwine.Namespace.addHandler({order:60,bind:function(selector,k,v){if(k.charAt(0)!=k.charAt(0).toUpperCase())$.entwine.warn('Entwine property '+k+' does not start with a capital letter',$.entwine.WARN_LEVEL_BESTPRACTISE);var getterName='get'+k;var setterName='set'+k;this.bind_proxy(selector,getterName,function(){var r=this.entwineData(k);return r===undefined?v:r;});this.bind_proxy(selector,setterName,function(v){return this.entwineData(k,v);});var getter=this.injectee[getterName];var setter=this.injectee[setterName];this.bind_proxy(selector,k,function(v){return(arguments.length==1?setter:getter).call(this,v);});return true;},namespaceMethodOverrides:function(namespace){return{entwineData:function(){return entwineData(this,namespace.name,arguments);}};}});})(jQuery);;(function($){$.concrete=$.entwine;$.fn.concrete=$.fn.entwine;$.fn.concreteData=$.fn.entwineData;$.entwine.Namespace.addHandler({order:100,bind:function(selector,k,v){return false;},namespaceMethodOverrides:function(namespace){namespace.$.concrete=namespace.$.entwine;namespace.injectee.concrete=namespace.injectee.entwine;namespace.injectee.concreteData=namespace.injectee.entwineData;return{};}});})(jQuery);;;

/****** FILE: framework/thirdparty/jquery-cookie/jquery.cookie.js *****/

jQuery.cookie=function(name,value,options){if(typeof value!='undefined'){options=options||{};if(value===null){value='';options=jQuery.extend({},options);options.expires=-1;}
var expires='';if(options.expires&&(typeof options.expires=='number'||options.expires.toUTCString)){var date;if(typeof options.expires=='number'){date=new Date();date.setTime(date.getTime()+(options.expires*24*60*60*1000));}else{date=options.expires;}
expires='; expires='+date.toUTCString();}
var path=options.path?'; path='+(options.path):'';var domain=options.domain?'; domain='+(options.domain):'';var secure=options.secure?'; secure':'';document.cookie=[name,'=',encodeURIComponent(value),expires,path,domain,secure].join('');}else{var cookieValue=null;if(document.cookie&&document.cookie!=''){var cookies=document.cookie.split(';');for(var i=0;i<cookies.length;i++){var cookie=jQuery.trim(cookies[i]);if(cookie.substring(0,name.length+1)==(name+'=')){cookieValue=decodeURIComponent(cookie.substring(name.length+1));break;}}}
return cookieValue;}};;

/****** FILE: framework/thirdparty/jquery-query/jquery.query.js *****/

new function(settings){var $separator=settings.separator||'&';var $spaces=settings.spaces===false?false:true;var $suffix=settings.suffix===false?'':'[]';var $prefix=settings.prefix===false?false:true;var $hash=$prefix?settings.hash===true?"#":"?":"";var $numbers=settings.numbers===false?false:true;jQuery.query=new function(){var is=function(o,t){return o!=undefined&&o!==null&&(!!t?o.constructor==t:true);};var parse=function(path){var m,rx=/\[([^[]*)\]/g,match=/^([^[]+)(\[.*\])?$/.exec(path),base=match[1],tokens=[];while(m=rx.exec(match[2]))tokens.push(m[1]);return[base,tokens];};var set=function(target,tokens,value){var o,token=tokens.shift();if(typeof target!='object')target=null;if(token===""){if(!target)target=[];if(is(target,Array)){target.push(tokens.length==0?value:set(null,tokens.slice(0),value));}else if(is(target,Object)){var i=0;while(target[i++]!=null);target[--i]=tokens.length==0?value:set(target[i],tokens.slice(0),value);}else{target=[];target.push(tokens.length==0?value:set(null,tokens.slice(0),value));}}else if(token&&token.match(/^\s*[0-9]+\s*$/)){var index=parseInt(token,10);if(!target)target=[];target[index]=tokens.length==0?value:set(target[index],tokens.slice(0),value);}else if(token){var index=token.replace(/^\s*|\s*$/g,"");if(!target)target={};if(is(target,Array)){var temp={};for(var i=0;i<target.length;++i){temp[i]=target[i];}
target=temp;}
target[index]=tokens.length==0?value:set(target[index],tokens.slice(0),value);}else{return value;}
return target;};var queryObject=function(a){var self=this;self.keys={};if(a.queryObject){jQuery.each(a.get(),function(key,val){self.SET(key,val);});}else{jQuery.each(arguments,function(){var q=""+this;q=q.replace(/^[?#]/,'');q=q.replace(/[;&]$/,'');if($spaces)q=q.replace(/[+]/g,' ');jQuery.each(q.split(/[&;]/),function(){var key=decodeURIComponent(this.split('=')[0]||"");var val=decodeURIComponent(this.split('=')[1]||"");if(!key)return;if($numbers){if(/^[+-]?[0-9]+\.[0-9]*$/.test(val))
val=parseFloat(val);else if(/^[+-]?[0-9]+$/.test(val))
val=parseInt(val,10);}
val=(!val&&val!==0)?true:val;if(val!==false&&val!==true&&typeof val!='number')
val=val;self.SET(key,val);});});}
return self;};queryObject.prototype={queryObject:true,has:function(key,type){var value=this.get(key);return is(value,type);},GET:function(key){if(!is(key))return this.keys;var parsed=parse(key),base=parsed[0],tokens=parsed[1];var target=this.keys[base];while(target!=null&&tokens.length!=0){target=target[tokens.shift()];}
return typeof target=='number'?target:target||"";},get:function(key){var target=this.GET(key);if(is(target,Object))
return jQuery.extend(true,{},target);else if(is(target,Array))
return target.slice(0);return target;},SET:function(key,val){var value=!is(val)?null:val;var parsed=parse(key),base=parsed[0],tokens=parsed[1];var target=this.keys[base];this.keys[base]=set(target,tokens.slice(0),value);return this;},set:function(key,val){return this.copy().SET(key,val);},REMOVE:function(key){return this.SET(key,null).COMPACT();},remove:function(key){return this.copy().REMOVE(key);},EMPTY:function(){var self=this;jQuery.each(self.keys,function(key,value){delete self.keys[key];});return self;},load:function(url){var hash=url.replace(/^.*?[#](.+?)(?:\?.+)?$/,"$1");var search=url.replace(/^.*?[?](.+?)(?:#.+)?$/,"$1");return new queryObject(url.length==search.length?'':search,url.length==hash.length?'':hash);},empty:function(){return this.copy().EMPTY();},copy:function(){return new queryObject(this);},COMPACT:function(){function build(orig){var obj=typeof orig=="object"?is(orig,Array)?[]:{}:orig;if(typeof orig=='object'){function add(o,key,value){if(is(o,Array))
o.push(value);else
o[key]=value;}
jQuery.each(orig,function(key,value){if(!is(value))return true;add(obj,key,build(value));});}
return obj;}
this.keys=build(this.keys);return this;},compact:function(){return this.copy().COMPACT();},toString:function(){var i=0,queryString=[],chunks=[],self=this;var encode=function(str){str=str+"";if($spaces)str=str.replace(/ /g,"+");return encodeURIComponent(str);};var addFields=function(arr,key,value){if(!is(value)||value===false)return;var o=[encode(key)];if(value!==true){o.push("=");o.push(encode(value));}
arr.push(o.join(""));};var build=function(obj,base){var newKey=function(key){return!base||base==""?[key].join(""):[base,"[",key,"]"].join("");};jQuery.each(obj,function(key,value){if(typeof value=='object')
build(value,newKey(key));else
addFields(chunks,newKey(key),value);});};build(this.keys);if(chunks.length>0)queryString.push($hash);queryString.push(chunks.join($separator));return queryString.join("");}};return new queryObject(location.search,location.hash);};}(jQuery.query||{});;

/****** FILE: framework/thirdparty/jquery-form/jquery.form.js *****/
;(function($){$.fn.ajaxSubmit=function(options){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this;}
var method,action,url,$form=this;if(typeof options=='function'){options={success:options};}
method=this.attr('method');action=this.attr('action');url=(typeof action==='string')?$.trim(action):'';url=url||window.location.href||'';if(url){url=(url.match(/^([^#]+)/)||[])[1];}
options=$.extend(true,{url:url,success:$.ajaxSettings.success,type:method||'GET',iframeSrc:/^https/i.test(window.location.href||'')?'javascript:false':'about:blank'},options);var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this;}
if(options.beforeSerialize&&options.beforeSerialize(this,options)===false){log('ajaxSubmit: submit aborted via beforeSerialize callback');return this;}
var traditional=options.traditional;if(traditional===undefined){traditional=$.ajaxSettings.traditional;}
var qx,n,v,a=this.formToArray(options.semantic);if(options.data){options.extraData=options.data;qx=$.param(options.data,traditional);}
if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===false){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this;}
this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this;}
var q=$.param(a,traditional);if(qx){q=(q?(q+'&'+qx):qx);}
if(options.type.toUpperCase()=='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null;}
else{options.data=q;}
var callbacks=[];if(options.resetForm){callbacks.push(function(){$form.resetForm();});}
if(options.clearForm){callbacks.push(function(){$form.clearForm(options.includeHidden);});}
if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data){var fn=options.replaceTarget?'replaceWith':'html';$(options.target)[fn](data).each(oldSuccess,arguments);});}
else if(options.success){callbacks.push(options.success);}
options.success=function(data,status,xhr){var context=options.context||options;for(var i=0,max=callbacks.length;i<max;i++){callbacks[i].apply(context,[data,status,xhr||$form,$form]);}};var fileInputs=$('input:file:enabled[value]',this);var hasFileInputs=fileInputs.length>0;var mp='multipart/form-data';var multipart=($form.attr('enctype')==mp||$form.attr('encoding')==mp);var fileAPI=!!(hasFileInputs&&fileInputs.get(0).files&&window.FormData);log("fileAPI :"+fileAPI);var shouldUseFrame=(hasFileInputs||multipart)&&!fileAPI;if(options.iframe!==false&&(options.iframe||shouldUseFrame)){if(options.closeKeepAlive){$.get(options.closeKeepAlive,function(){fileUploadIframe(a);});}
else{fileUploadIframe(a);}}
else if((hasFileInputs||multipart)&&fileAPI){options.progress=options.progress||$.noop;fileUploadXhr(a);}
else{$.ajax(options);}
this.trigger('form-submit-notify',[this,options]);return this;function fileUploadXhr(a){var formdata=new FormData();for(var i=0;i<a.length;i++){if(a[i].type=='file')
continue;formdata.append(a[i].name,a[i].value);}
$form.find('input:file:enabled').each(function(){var name=$(this).attr('name'),files=this.files;if(name){for(var i=0;i<files.length;i++)
formdata.append(name,files[i]);}});if(options.extraData){for(var k in options.extraData)
formdata.append(k,options.extraData[k])}
options.data=null;var s=$.extend(true,{},$.ajaxSettings,options,{contentType:false,processData:false,cache:false,type:'POST'});s.data=null;var beforeSend=s.beforeSend;s.beforeSend=function(xhr,o){o.data=formdata;if(xhr.upload){xhr.upload.onprogress=function(event){o.progress(event.position,event.total);};}
if(beforeSend)
beforeSend.call(o,xhr,options);};$.ajax(s);}
function fileUploadIframe(a){var form=$form[0],el,i,s,g,id,$io,io,xhr,sub,n,timedOut,timeoutHandle;var useProp=!!$.fn.prop;if(a){if(useProp){for(i=0;i<a.length;i++){el=$(form[a[i].name]);el.prop('disabled',false);}}else{for(i=0;i<a.length;i++){el=$(form[a[i].name]);el.removeAttr('disabled');}};}
if($(':input[name=submit],:input[id=submit]',form).length){alert('Error: Form elements must not have name or id of "submit".');return;}
s=$.extend(true,{},$.ajaxSettings,options);s.context=s.context||s;id='jqFormIO'+(new Date().getTime());if(s.iframeTarget){$io=$(s.iframeTarget);n=$io.attr('name');if(n==null)
$io.attr('name',id);else
id=n;}
else{$io=$('<iframe name="'+id+'" src="'+s.iframeSrc+'" />');$io.css({position:'absolute',top:'-1000px',left:'-1000px'});}
io=$io[0];xhr={aborted:0,responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(status){var e=(status==='timeout'?'timeout':'aborted');log('aborting upload... '+e);this.aborted=1;$io.attr('src',s.iframeSrc);xhr.error=e;s.error&&s.error.call(s.context,xhr,e,status);g&&$.event.trigger("ajaxError",[xhr,s,e]);s.complete&&s.complete.call(s.context,xhr,e);}};g=s.global;if(g&&!$.active++){$.event.trigger("ajaxStart");}
if(g){$.event.trigger("ajaxSend",[xhr,s]);}
if(s.beforeSend&&s.beforeSend.call(s.context,xhr,s)===false){if(s.global){$.active--;}
return;}
if(xhr.aborted){return;}
sub=form.clk;if(sub){n=sub.name;if(n&&!sub.disabled){s.extraData=s.extraData||{};s.extraData[n]=sub.value;if(sub.type=="image"){s.extraData[n+'.x']=form.clk_x;s.extraData[n+'.y']=form.clk_y;}}}
var CLIENT_TIMEOUT_ABORT=1;var SERVER_ABORT=2;function getDoc(frame){var doc=frame.contentWindow?frame.contentWindow.document:frame.contentDocument?frame.contentDocument:frame.document;return doc;}
var csrf_token=$('meta[name=csrf-token]').attr('content');var csrf_param=$('meta[name=csrf-param]').attr('content');if(csrf_param&&csrf_token){s.extraData=s.extraData||{};s.extraData[csrf_param]=csrf_token;}
function doSubmit(){var t=$form.attr('target'),a=$form.attr('action');form.setAttribute('target',id);if(!method){form.setAttribute('method','POST');}
if(a!=s.url){form.setAttribute('action',s.url);}
if(!s.skipEncodingOverride&&(!method||/post/i.test(method))){$form.attr({encoding:'multipart/form-data',enctype:'multipart/form-data'});}
if(s.timeout){timeoutHandle=setTimeout(function(){timedOut=true;cb(CLIENT_TIMEOUT_ABORT);},s.timeout);}
function checkState(){try{var state=getDoc(io).readyState;log('state = '+state);if(state.toLowerCase()=='uninitialized')
setTimeout(checkState,50);}
catch(e){log('Server abort: ',e,' (',e.name,')');cb(SERVER_ABORT);timeoutHandle&&clearTimeout(timeoutHandle);timeoutHandle=undefined;}}
var extraInputs=[];try{if(s.extraData){for(var n in s.extraData){extraInputs.push($('<input type="hidden" name="'+n+'">').attr('value',s.extraData[n]).appendTo(form)[0]);}}
if(!s.iframeTarget){$io.appendTo('body');io.attachEvent?io.attachEvent('onload',cb):io.addEventListener('load',cb,false);}
setTimeout(checkState,15);form.submit();}
finally{form.setAttribute('action',a);if(t){form.setAttribute('target',t);}else{$form.removeAttr('target');}
$(extraInputs).remove();}}
if(s.forceSync){doSubmit();}
else{setTimeout(doSubmit,10);}
var data,doc,domCheckCount=50,callbackProcessed;function cb(e){if(xhr.aborted||callbackProcessed){return;}
try{doc=getDoc(io);}
catch(ex){log('cannot access response document: ',ex);e=SERVER_ABORT;}
if(e===CLIENT_TIMEOUT_ABORT&&xhr){xhr.abort('timeout');return;}
else if(e==SERVER_ABORT&&xhr){xhr.abort('server abort');return;}
if(!doc||doc.location.href==s.iframeSrc){if(!timedOut)
return;}
io.detachEvent?io.detachEvent('onload',cb):io.removeEventListener('load',cb,false);var status='success',errMsg;try{if(timedOut){throw'timeout';}
var isXml=s.dataType=='xml'||doc.XMLDocument||$.isXMLDoc(doc);log('isXml='+isXml);if(!isXml&&window.opera&&(doc.body==null||doc.body.innerHTML=='')){if(--domCheckCount){log('requeing onLoad callback, DOM not available');setTimeout(cb,250);return;}}
var docRoot=doc.body?doc.body:doc.documentElement;xhr.responseText=docRoot?docRoot.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;if(isXml)
s.dataType='xml';xhr.getResponseHeader=function(header){var headers={'content-type':s.dataType};return headers[header];};if(docRoot){xhr.status=Number(docRoot.getAttribute('status'))||xhr.status;xhr.statusText=docRoot.getAttribute('statusText')||xhr.statusText;}
var dt=(s.dataType||'').toLowerCase();var scr=/(json|script|text)/.test(dt);if(scr||s.textarea){var ta=doc.getElementsByTagName('textarea')[0];if(ta){xhr.responseText=ta.value;xhr.status=Number(ta.getAttribute('status'))||xhr.status;xhr.statusText=ta.getAttribute('statusText')||xhr.statusText;}
else if(scr){var pre=doc.getElementsByTagName('pre')[0];var b=doc.getElementsByTagName('body')[0];if(pre){xhr.responseText=pre.textContent?pre.textContent:pre.innerText;}
else if(b){xhr.responseText=b.textContent?b.textContent:b.innerText;}}}
else if(dt=='xml'&&!xhr.responseXML&&xhr.responseText!=null){xhr.responseXML=toXml(xhr.responseText);}
try{data=httpData(xhr,dt,s);}
catch(e){status='parsererror';xhr.error=errMsg=(e||status);}}
catch(e){log('error caught: ',e);status='error';xhr.error=errMsg=(e||status);}
if(xhr.aborted){log('upload aborted');status=null;}
if(xhr.status){status=(xhr.status>=200&&xhr.status<300||xhr.status===304)?'success':'error';}
if(status==='success'){s.success&&s.success.call(s.context,data,'success',xhr);g&&$.event.trigger("ajaxSuccess",[xhr,s]);}
else if(status){if(errMsg==undefined)
errMsg=xhr.statusText;s.error&&s.error.call(s.context,xhr,status,errMsg);g&&$.event.trigger("ajaxError",[xhr,s,errMsg]);}
g&&$.event.trigger("ajaxComplete",[xhr,s]);if(g&&!--$.active){$.event.trigger("ajaxStop");}
s.complete&&s.complete.call(s.context,xhr,status);callbackProcessed=true;if(s.timeout)
clearTimeout(timeoutHandle);setTimeout(function(){if(!s.iframeTarget)
$io.remove();xhr.responseXML=null;},100);}
var toXml=$.parseXML||function(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s);}
else{doc=(new DOMParser()).parseFromString(s,'text/xml');}
return(doc&&doc.documentElement&&doc.documentElement.nodeName!='parsererror')?doc:null;};var parseJSON=$.parseJSON||function(s){return window['eval']('('+s+')');};var httpData=function(xhr,type,s){var ct=xhr.getResponseHeader('content-type')||'',xml=type==='xml'||!type&&ct.indexOf('xml')>=0,data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.nodeName==='parsererror'){$.error&&$.error('parsererror');}
if(s&&s.dataFilter){data=s.dataFilter(data,type);}
if(typeof data==='string'){if(type==='json'||!type&&ct.indexOf('json')>=0){data=parseJSON(data);}else if(type==="script"||!type&&ct.indexOf("javascript")>=0){$.globalEval(data);}}
return data;};}};$.fn.ajaxForm=function(options){options=options||{};options.delegation=options.delegation&&$.isFunction($.fn.on);if(!options.delegation&&this.length===0){var o={s:this.selector,c:this.context};if(!$.isReady&&o.s){log('DOM not ready, queuing ajaxForm');$(function(){$(o.s,o.c).ajaxForm(options);});return this;}
log('terminating; zero elements found by selector'+($.isReady?'':' (DOM not ready)'));return this;}
if(options.delegation){$(document).off('submit.form-plugin',this.selector,doAjaxSubmit).off('click.form-plugin',this.selector,captureSubmittingElement).on('submit.form-plugin',this.selector,options,doAjaxSubmit).on('click.form-plugin',this.selector,options,captureSubmittingElement);return this;}
return this.ajaxFormUnbind().bind('submit.form-plugin',options,doAjaxSubmit).bind('click.form-plugin',options,captureSubmittingElement);};function doAjaxSubmit(e){var options=e.data;if(!e.isDefaultPrevented()){e.preventDefault();$(this).ajaxSubmit(options);}}
function captureSubmittingElement(e){var target=e.target;var $el=$(target);if(!($el.is(":submit,input:image"))){var t=$el.closest(':submit');if(t.length==0){return;}
target=t[0];}
var form=this;form.clk=target;if(target.type=='image'){if(e.offsetX!=undefined){form.clk_x=e.offsetX;form.clk_y=e.offsetY;}else if(typeof $.fn.offset=='function'){var offset=$el.offset();form.clk_x=e.pageX-offset.left;form.clk_y=e.pageY-offset.top;}else{form.clk_x=e.pageX-target.offsetLeft;form.clk_y=e.pageY-target.offsetTop;}}
setTimeout(function(){form.clk=form.clk_x=form.clk_y=null;},100);};$.fn.ajaxFormUnbind=function(){return this.unbind('submit.form-plugin click.form-plugin');};$.fn.formToArray=function(semantic){var a=[];if(this.length===0){return a;}
var form=this[0];var els=semantic?form.getElementsByTagName('*'):form.elements;if(!els){return a;}
var i,j,n,v,el,max,jmax;for(i=0,max=els.length;i<max;i++){el=els[i];n=el.name;if(!n){continue;}
if(semantic&&form.clk&&el.type=="image"){if(!el.disabled&&form.clk==el){a.push({name:n,value:$(el).val(),type:el.type});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}
continue;}
v=$.fieldValue(el,true);if(v&&v.constructor==Array){for(j=0,jmax=v.length;j<jmax;j++){a.push({name:n,value:v[j]});}}
else if(v!==null&&typeof v!='undefined'){a.push({name:n,value:v,type:el.type});}}
if(!semantic&&form.clk){var $input=$(form.clk),input=$input[0];n=input.name;if(n&&!input.disabled&&input.type=='image'){a.push({name:n,value:$input.val()});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}}
return a;};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic));};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n){return;}
var v=$.fieldValue(this,successful);if(v&&v.constructor==Array){for(var i=0,max=v.length;i<max;i++){a.push({name:n,value:v[i]});}}
else if(v!==null&&typeof v!='undefined'){a.push({name:this.name,value:v});}});return $.param(a);};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v=='undefined'||(v.constructor==Array&&!v.length)){continue;}
v.constructor==Array?$.merge(val,v):val.push(v);}
return val;};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(successful===undefined){successful=true;}
if(successful&&(!n||el.disabled||t=='reset'||t=='button'||(t=='checkbox'||t=='radio')&&!el.checked||(t=='submit'||t=='image')&&el.form&&el.form.clk!=el||tag=='select'&&el.selectedIndex==-1)){return null;}
if(tag=='select'){var index=el.selectedIndex;if(index<0){return null;}
var a=[],ops=el.options;var one=(t=='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected){var v=op.value;if(!v){v=(op.attributes&&op.attributes['value']&&!(op.attributes['value'].specified))?op.text:op.value;}
if(one){return v;}
a.push(v);}}
return a;}
return $(el).val();};$.fn.clearForm=function(includeHidden){return this.each(function(){$('input,select,textarea',this).clearFields(includeHidden);});};$.fn.clearFields=$.fn.clearInputs=function(includeHidden){var re=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(re.test(t)||tag=='textarea'||(includeHidden&&/hidden/.test(t))){this.value='';}
else if(t=='checkbox'||t=='radio'){this.checked=false;}
else if(tag=='select'){this.selectedIndex=-1;}});};$.fn.resetForm=function(){return this.each(function(){if(typeof this.reset=='function'||(typeof this.reset=='object'&&!this.reset.nodeType)){this.reset();}});};$.fn.enable=function(b){if(b===undefined){b=true;}
return this.each(function(){this.disabled=!b;});};$.fn.selected=function(select){if(select===undefined){select=true;}
return this.each(function(){var t=this.type;if(t=='checkbox'||t=='radio'){this.checked=select;}
else if(this.tagName.toLowerCase()=='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type=='select-one'){$sel.find('option').selected(false);}
this.selected=select;}});};$.fn.ajaxSubmit.debug=false;function log(){if(!$.fn.ajaxSubmit.debug)
return;var msg='[jquery.form] '+Array.prototype.join.call(arguments,'');if(window.console&&window.console.log){window.console.log(msg);}
else if(window.opera&&window.opera.postError){window.opera.postError(msg);}};})(jQuery);;

/****** FILE: framework/admin/thirdparty/jquery-notice/jquery.notice.js *****/

(function(jQuery)
{jQuery.extend({noticeAdd:function(options)
{var defaults={inEffect:{opacity:'show'},inEffectDuration:600,stayTime:3000,text:'',stay:false,type:'notice'}
var options,noticeWrapAll,noticeItemOuter,noticeItemInner,noticeItemClose;options=jQuery.extend({},defaults,options);noticeWrapAll=(!jQuery('.notice-wrap').length)?jQuery('<div></div>').addClass('notice-wrap').appendTo('body'):jQuery('.notice-wrap');noticeItemOuter=jQuery('<div></div>').addClass('notice-item-wrapper');noticeItemInner=jQuery('<div></div>').hide().addClass('notice-item '+options.type).appendTo(noticeWrapAll).html('<p>'+options.text+'</p>').animate(options.inEffect,options.inEffectDuration).wrap(noticeItemOuter);noticeItemClose=jQuery('<div></div>').addClass('notice-item-close').prependTo(noticeItemInner).html('x').click(function(){jQuery.noticeRemove(noticeItemInner)});if(!options.stay)
{setTimeout(function()
{jQuery.noticeRemove(noticeItemInner);},options.stayTime);}},noticeRemove:function(obj)
{obj.animate({opacity:'0'},600,function()
{obj.parent().animate({height:'0px'},300,function()
{obj.parent().remove();});});}});})(jQuery);;

/****** FILE: framework/admin/thirdparty/jsizes/lib/jquery.sizes.js *****/

(function($){var num=function(value){return parseInt(value,10)||0;};$.each(['min','max'],function(i,name){$.fn[name+'Size']=function(value){var width,height;if(value){if(value.width!==undefined){this.css(name+'-width',value.width);}
if(value.height!==undefined){this.css(name+'-height',value.height);}
return this;}
else{width=this.css(name+'-width');height=this.css(name+'-height');return{'width':(name==='max'&&(width===undefined||width==='none'||num(width)===-1)&&Number.MAX_VALUE)||num(width),'height':(name==='max'&&(height===undefined||height==='none'||num(height)===-1)&&Number.MAX_VALUE)||num(height)};}};});$.fn.isVisible=function(){return this.is(':visible');};$.each(['border','margin','padding'],function(i,name){$.fn[name]=function(value){if(value){if(value.top!==undefined){this.css(name+'-top'+(name==='border'?'-width':''),value.top);}
if(value.bottom!==undefined){this.css(name+'-bottom'+(name==='border'?'-width':''),value.bottom);}
if(value.left!==undefined){this.css(name+'-left'+(name==='border'?'-width':''),value.left);}
if(value.right!==undefined){this.css(name+'-right'+(name==='border'?'-width':''),value.right);}
return this;}
else{return{top:num(this.css(name+'-top'+(name==='border'?'-width':''))),bottom:num(this.css(name+'-bottom'+(name==='border'?'-width':''))),left:num(this.css(name+'-left'+(name==='border'?'-width':''))),right:num(this.css(name+'-right'+(name==='border'?'-width':'')))};}};});}(jQuery));;

/****** FILE: framework/admin/thirdparty/jlayout/lib/jlayout.border.js *****/

(function(){jLayout=(typeof jLayout==='undefined')?{}:jLayout;jLayout.border=function(spec){var my={},that={},east=spec.east,west=spec.west,north=spec.north,south=spec.south,center=spec.center;my.hgap=spec.hgap||0;my.vgap=spec.vgap||0;that.items=function(){var items=[];if(east){items.push(east);}
if(west){items.push(west);}
if(north){items.push(north);}
if(south){items.push(south);}
if(center){items.push(center);}
return items;};that.layout=function(container){var size=container.bounds(),insets=container.insets(),top=insets.top,bottom=size.height-insets.bottom,left=insets.left,right=size.width-insets.right,tmp;if(north&&north.isVisible()){tmp=north.preferredSize();north.bounds({'x':left,'y':top,'width':right-left,'height':tmp.height});north.doLayout();top+=tmp.height+my.vgap;}
if(south&&south.isVisible()){tmp=south.preferredSize();south.bounds({'x':left,'y':bottom-tmp.height,'width':right-left,'height':tmp.height});south.doLayout();bottom-=tmp.height+my.vgap;}
if(east&&east.isVisible()){tmp=east.preferredSize();east.bounds({'x':right-tmp.width,'y':top,'width':tmp.width,'height':bottom-top});east.doLayout();right-=tmp.width+my.hgap;}
if(west&&west.isVisible()){tmp=west.preferredSize();west.bounds({'x':left,'y':top,'width':tmp.width,'height':bottom-top});west.doLayout();left+=tmp.width+my.hgap;}
if(center&&center.isVisible()){center.bounds({'x':left,'y':top,'width':right-left,'height':bottom-top});center.doLayout();}
return container;};function typeLayout(type){return function(container){var insets=container.insets(),width=0,height=0,type_size;if(east&&east.isVisible()){type_size=east[type+'Size']();width+=type_size.width+my.hgap;height=type_size.height;}
if(west&&west.isVisible()){type_size=west[type+'Size']();width+=type_size.width+my.hgap;height=Math.max(type_size.height,height);}
if(center&&center.isVisible()){type_size=center[type+'Size']();width+=type_size.width;height=Math.max(type_size.height,height);}
if(north&&north.isVisible()){type_size=north[type+'Size']();width=Math.max(type_size.width,width);height+=type_size.height+my.vgap;}
if(south&&south.isVisible()){type_size=south[type+'Size']();width=Math.max(type_size.width,width);height+=type_size.height+my.vgap;}
return{'width':width+insets.left+insets.right,'height':height+insets.top+insets.bottom};};}
that.preferred=typeLayout('preferred');that.minimum=typeLayout('minimum');that.maximum=typeLayout('maximum');return that;};}());;

/****** FILE: framework/admin/thirdparty/jlayout/lib/jquery.jlayout.js *****/

if(jQuery&&jLayout){(function($){var wrap=$.jLayoutWrap=function(item,resize){var that={};that.item=item;$.each(['min','max'],function(i,name){that[name+'imumSize']=function(value){var l=item.data('jlayout');if(l){return l[name+'imum'](that);}else{return item[name+'Size'](value);}};});$.extend(that,{doLayout:function(){var l=item.data('jlayout');if(l)l.layout(that);else if(item.is('[data-layout-type]')){item.layout({resize:false});}
item.css({position:'absolute'});},isVisible:function(){return item.isVisible();},insets:function(){var p=item.padding(),b=item.border();return{'top':p.top,'bottom':p.bottom+b.bottom+b.top,'left':p.left,'right':p.right+b.right+b.left};},bounds:function(value){var tmp={};if(value){if(typeof value.x==='number'){tmp.left=value.x;}
if(typeof value.y==='number'){tmp.top=value.y;}
if(typeof value.width==='number'){tmp.width=(value.width-(item.outerWidth(true)-item.width()));tmp.width=(tmp.width>=0)?tmp.width:0;}
if(typeof value.height==='number'){tmp.height=value.height-(item.outerHeight(true)-item.height());tmp.height=(tmp.height>=0)?tmp.height:0;}
item.css(tmp);return item;}else{tmp=item.position();return{'x':tmp.left,'y':tmp.top,'width':item.outerWidth(false),'height':item.outerHeight(false)};}},preferredSize:function(){var minSize,maxSize,margin=item.margin(),size={width:0,height:0},l=item.data('jlayout');if(l&&resize){size=l.preferred(that);minSize=that.minimumSize();maxSize=that.maximumSize();size.width+=margin.left+margin.right;size.height+=margin.top+margin.bottom;if(size.width<minSize.width||size.height<minSize.height){size.width=Math.max(size.width,minSize.width);size.height=Math.max(size.height,minSize.height);}else if(size.width>maxSize.width||size.height>maxSize.height){size.width=Math.min(size.width,maxSize.width);size.height=Math.min(size.height,maxSize.height);}}else{size=that.bounds();size.width+=margin.left+margin.right;size.height+=margin.top+margin.bottom;}
return size;}});return that;}
$.fn.layout=function(options){var opts=$.extend({},$.fn.layout.defaults,options);return $.each(this,function(){var element=$(this),o=$.metadata&&element.metadata().layout?$.extend(opts,element.metadata().layout):opts,o=element.data('layoutType')?$.extend(o,{type:element.data('layoutType')}):o,elementWrapper=wrap(element,o.resize);if(o.type==='border'&&typeof jLayout.border!=='undefined'){$.each(['north','south','west','east','center'],function(i,name){if(element.children().hasClass(name)){o[name]=wrap(element.children('.'+name+':first'));}});element.data('jlayout',jLayout.border(o));}else if(o.type==='grid'&&typeof jLayout.grid!=='undefined'){o.items=[];element.children().each(function(i){if(!$(this).hasClass('ui-resizable-handle')){o.items[i]=wrap($(this));}});element.data('jlayout',jLayout.grid(o));}else if(o.type==='flexGrid'&&typeof jLayout.flexGrid!=='undefined'){o.items=[];element.children().each(function(i){if(!$(this).hasClass('ui-resizable-handle')){o.items[i]=wrap($(this));}});element.data('jlayout',jLayout.flexGrid(o));}else if(o.type==='column'&&typeof jLayout.column!=='undefined'){o.items=[];element.children().each(function(i){if(!$(this).hasClass('ui-resizable-handle')){o.items[i]=wrap($(this));}});element.data('jlayout',jLayout.column(o));}else if(o.type==='flow'&&typeof jLayout.flow!=='undefined'){o.items=[];element.children().each(function(i){if(!$(this).hasClass('ui-resizable-handle')){o.items[i]=wrap($(this));}});element.data('jlayout',jLayout.flow(o));}
if(o.resize){elementWrapper.bounds(elementWrapper.preferredSize());}
elementWrapper.doLayout();element.css({position:'relative'});if($.ui!==undefined){element.addClass('ui-widget');}});};$.fn.layout.defaults={resize:true,type:'grid'};}(jQuery));};

/****** FILE: framework/admin/thirdparty/history-js/scripts/uncompressed/history.js *****/

(function(window,undefined){"use strict";var
console=window.console||undefined,document=window.document,navigator=window.navigator,sessionStorage=window.sessionStorage||false,setTimeout=window.setTimeout,clearTimeout=window.clearTimeout,setInterval=window.setInterval,clearInterval=window.clearInterval,JSON=window.JSON,alert=window.alert,History=window.History=window.History||{},history=window.history;try{sessionStorage.setItem('TEST','1');sessionStorage.removeItem('TEST');}catch(e){sessionStorage=false;}
JSON.stringify=JSON.stringify||JSON.encode;JSON.parse=JSON.parse||JSON.decode;if(typeof History.init!=='undefined'){throw new Error('History.js Core has already been loaded...');}
History.init=function(options){if(typeof History.Adapter==='undefined'){return false;}
if(typeof History.initCore!=='undefined'){History.initCore();}
if(typeof History.initHtml4!=='undefined'){History.initHtml4();}
return true;};History.initCore=function(options){if(typeof History.initCore.initialized!=='undefined'){return false;}
else{History.initCore.initialized=true;}
History.options=History.options||{};History.options.hashChangeInterval=History.options.hashChangeInterval||100;History.options.safariPollInterval=History.options.safariPollInterval||500;History.options.doubleCheckInterval=History.options.doubleCheckInterval||500;History.options.disableSuid=History.options.disableSuid||false;History.options.storeInterval=History.options.storeInterval||1000;History.options.busyDelay=History.options.busyDelay||250;History.options.debug=History.options.debug||false;History.options.initialTitle=History.options.initialTitle||document.title;History.options.html4Mode=History.options.html4Mode||false;History.options.delayInit=History.options.delayInit||false;History.intervalList=[];History.clearAllIntervals=function(){var i,il=History.intervalList;if(typeof il!=="undefined"&&il!==null){for(i=0;i<il.length;i++){clearInterval(il[i]);}
History.intervalList=null;}};History.debug=function(){if((History.options.debug||false)){History.log.apply(History,arguments);}};History.log=function(){var
consoleExists=!(typeof console==='undefined'||typeof console.log==='undefined'||typeof console.log.apply==='undefined'),textarea=document.getElementById('log'),message,i,n,args,arg;if(consoleExists){args=Array.prototype.slice.call(arguments);message=args.shift();if(typeof console.debug!=='undefined'){console.debug.apply(console,[message,args]);}
else{console.log.apply(console,[message,args]);}}
else{message=("\n"+arguments[0]+"\n");}
for(i=1,n=arguments.length;i<n;++i){arg=arguments[i];if(typeof arg==='object'&&typeof JSON!=='undefined'){try{arg=JSON.stringify(arg);}
catch(Exception){}}
message+="\n"+arg+"\n";}
if(textarea){textarea.value+=message+"\n-----\n";textarea.scrollTop=textarea.scrollHeight-textarea.clientHeight;}
else if(!consoleExists){alert(message);}
return true;};History.getInternetExplorerMajorVersion=function(){var result=History.getInternetExplorerMajorVersion.cached=(typeof History.getInternetExplorerMajorVersion.cached!=='undefined')?History.getInternetExplorerMajorVersion.cached:(function(){var v=3,div=document.createElement('div'),all=div.getElementsByTagName('i');while((div.innerHTML='<!--[if gt IE '+(++v)+']><i></i><![endif]-->')&&all[0]){}
return(v>4)?v:false;})();return result;};History.isInternetExplorer=function(){var result=History.isInternetExplorer.cached=(typeof History.isInternetExplorer.cached!=='undefined')?History.isInternetExplorer.cached:Boolean(History.getInternetExplorerMajorVersion());return result;};if(History.options.html4Mode){History.emulated={pushState:true,hashChange:true};}
else{History.emulated={pushState:!Boolean(window.history&&window.history.pushState&&window.history.replaceState&&!((/ Mobile\/([1-7][a-z]|(8([abcde]|f(1[0-8]))))/i).test(navigator.userAgent)||(/AppleWebKit\/5([0-2]|3[0-2])/i).test(navigator.userAgent))),hashChange:Boolean(!(('onhashchange'in window)||('onhashchange'in document))||(History.isInternetExplorer()&&History.getInternetExplorerMajorVersion()<8))};}
History.enabled=!History.emulated.pushState;History.bugs={setHash:Boolean(!History.emulated.pushState&&navigator.vendor==='Apple Computer, Inc.'&&/AppleWebKit\/5([0-2]|3[0-3])/.test(navigator.userAgent)),safariPoll:Boolean(!History.emulated.pushState&&navigator.vendor==='Apple Computer, Inc.'&&/AppleWebKit\/5([0-2]|3[0-3])/.test(navigator.userAgent)),ieDoubleCheck:Boolean(History.isInternetExplorer()&&History.getInternetExplorerMajorVersion()<8),hashEscape:Boolean(History.isInternetExplorer()&&History.getInternetExplorerMajorVersion()<7)};History.isEmptyObject=function(obj){for(var name in obj){if(obj.hasOwnProperty(name)){return false;}}
return true;};History.cloneObject=function(obj){var hash,newObj;if(obj){hash=JSON.stringify(obj);newObj=JSON.parse(hash);}
else{newObj={};}
return newObj;};History.getRootUrl=function(){var rootUrl=document.location.protocol+'//'+(document.location.hostname||document.location.host);if(document.location.port||false){rootUrl+=':'+document.location.port;}
rootUrl+='/';return rootUrl;};History.getBaseHref=function(){var
baseElements=document.getElementsByTagName('base'),baseElement=null,baseHref='';if(baseElements.length===1){baseElement=baseElements[0];baseHref=baseElement.href.replace(/[^\/]+$/,'');}
baseHref=baseHref.replace(/\/+$/,'');if(baseHref)baseHref+='/';return baseHref;};History.getBaseUrl=function(){var baseUrl=History.getBaseHref()||History.getBasePageUrl()||History.getRootUrl();return baseUrl;};History.getPageUrl=function(){var
State=History.getState(false,false),stateUrl=(State||{}).url||History.getLocationHref(),pageUrl;pageUrl=stateUrl.replace(/\/+$/,'').replace(/[^\/]+$/,function(part,index,string){return(/\./).test(part)?part:part+'/';});return pageUrl;};History.getBasePageUrl=function(){var basePageUrl=(History.getLocationHref()).replace(/[#\?].*/,'').replace(/[^\/]+$/,function(part,index,string){return(/[^\/]$/).test(part)?'':part;}).replace(/\/+$/,'')+'/';return basePageUrl;};History.getFullUrl=function(url,allowBaseHref){var fullUrl=url,firstChar=url.substring(0,1);allowBaseHref=(typeof allowBaseHref==='undefined')?true:allowBaseHref;if(/[a-z]+\:\/\//.test(url)){}
else if(firstChar==='/'){fullUrl=History.getRootUrl()+url.replace(/^\/+/,'');}
else if(firstChar==='#'){fullUrl=History.getPageUrl().replace(/#.*/,'')+url;}
else if(firstChar==='?'){fullUrl=History.getPageUrl().replace(/[\?#].*/,'')+url;}
else{if(allowBaseHref){fullUrl=History.getBaseUrl()+url.replace(/^(\.\/)+/,'');}else{fullUrl=History.getBasePageUrl()+url.replace(/^(\.\/)+/,'');}}
return fullUrl.replace(/\#$/,'');};History.getShortUrl=function(url){var shortUrl=url,baseUrl=History.getBaseUrl(),rootUrl=History.getRootUrl();if(History.emulated.pushState){shortUrl=shortUrl.replace(baseUrl,'');}
shortUrl=shortUrl.replace(rootUrl,'/');if(History.isTraditionalAnchor(shortUrl)){shortUrl='./'+shortUrl;}
shortUrl=shortUrl.replace(/^(\.\/)+/g,'./').replace(/\#$/,'');return shortUrl;};History.getLocationHref=function(doc){doc=doc||document;if(doc.URL===doc.location.href)
return doc.location.href;if(doc.location.href===decodeURIComponent(doc.URL))
return doc.URL;if(doc.location.hash&&decodeURIComponent(doc.location.href.replace(/^[^#]+/,""))===doc.location.hash)
return doc.location.href;if(doc.URL.indexOf('#')==-1&&doc.location.href.indexOf('#')!=-1)
return doc.location.href;return doc.URL||doc.location.href;};History.store={};History.idToState=History.idToState||{};History.stateToId=History.stateToId||{};History.urlToId=History.urlToId||{};History.storedStates=History.storedStates||[];History.savedStates=History.savedStates||[];History.normalizeStore=function(){History.store.idToState=History.store.idToState||{};History.store.urlToId=History.store.urlToId||{};History.store.stateToId=History.store.stateToId||{};};History.getState=function(friendly,create){if(typeof friendly==='undefined'){friendly=true;}
if(typeof create==='undefined'){create=true;}
var State=History.getLastSavedState();if(!State&&create){State=History.createStateObject();}
if(friendly){State=History.cloneObject(State);State.url=State.cleanUrl||State.url;}
return State;};History.getIdByState=function(newState){var id=History.extractId(newState.url),str;if(!id){str=History.getStateString(newState);if(typeof History.stateToId[str]!=='undefined'){id=History.stateToId[str];}
else if(typeof History.store.stateToId[str]!=='undefined'){id=History.store.stateToId[str];}
else{while(true){id=(new Date()).getTime()+String(Math.random()).replace(/\D/g,'');if(typeof History.idToState[id]==='undefined'&&typeof History.store.idToState[id]==='undefined'){break;}}
History.stateToId[str]=id;History.idToState[id]=newState;}}
return id;};History.normalizeState=function(oldState){var newState,dataNotEmpty;if(!oldState||(typeof oldState!=='object')){oldState={};}
if(typeof oldState.normalized!=='undefined'){return oldState;}
if(!oldState.data||(typeof oldState.data!=='object')){oldState.data={};}
newState={};newState.normalized=true;newState.title=oldState.title||'';newState.url=History.getFullUrl(oldState.url?decodeURIComponent(oldState.url):(History.getLocationHref()));newState.hash=History.getShortUrl(newState.url);newState.data=History.cloneObject(oldState.data);newState.id=History.getIdByState(newState);newState.cleanUrl=newState.url.replace(/\??\&_suid.*/,'');newState.url=newState.cleanUrl;dataNotEmpty=!History.isEmptyObject(newState.data);if((newState.title||dataNotEmpty)&&History.options.disableSuid!==true){newState.hash=History.getShortUrl(newState.url).replace(/\??\&_suid.*/,'');if(!/\?/.test(newState.hash)){newState.hash+='?';}
newState.hash+='&_suid='+newState.id;}
newState.hashedUrl=History.getFullUrl(newState.hash);if((History.emulated.pushState||History.bugs.safariPoll)&&History.hasUrlDuplicate(newState)){newState.url=newState.hashedUrl;}
return newState;};History.createStateObject=function(data,title,url){var State={'data':data,'title':title,'url':url};State=History.normalizeState(State);return State;};History.getStateById=function(id){id=String(id);var State=History.idToState[id]||History.store.idToState[id]||undefined;return State;};History.getStateString=function(passedState){var State,cleanedState,str;State=History.normalizeState(passedState);cleanedState={data:State.data,title:passedState.title,url:passedState.url};str=JSON.stringify(cleanedState);return str;};History.getStateId=function(passedState){var State,id;State=History.normalizeState(passedState);id=State.id;return id;};History.getHashByState=function(passedState){var State,hash;State=History.normalizeState(passedState);hash=State.hash;return hash;};History.extractId=function(url_or_hash){var id,parts,url,tmp;if(url_or_hash.indexOf('#')!=-1)
{tmp=url_or_hash.split("#")[0];}
else
{tmp=url_or_hash;}
parts=/(.*)\&_suid=([0-9]+)$/.exec(tmp);url=parts?(parts[1]||url_or_hash):url_or_hash;id=parts?String(parts[2]||''):'';return id||false;};History.isTraditionalAnchor=function(url_or_hash){var isTraditional=!(/[\/\?\.]/.test(url_or_hash));return isTraditional;};History.extractState=function(url_or_hash,create){var State=null,id,url;create=create||false;id=History.extractId(url_or_hash);if(id){State=History.getStateById(id);}
if(!State){url=History.getFullUrl(url_or_hash);id=History.getIdByUrl(url)||false;if(id){State=History.getStateById(id);}
if(!State&&create&&!History.isTraditionalAnchor(url_or_hash)){State=History.createStateObject(null,null,url);}}
return State;};History.getIdByUrl=function(url){var id=History.urlToId[url]||History.store.urlToId[url]||undefined;return id;};History.getLastSavedState=function(){return History.savedStates[History.savedStates.length-1]||undefined;};History.getLastStoredState=function(){return History.storedStates[History.storedStates.length-1]||undefined;};History.hasUrlDuplicate=function(newState){var hasDuplicate=false,oldState;oldState=History.extractState(newState.url);hasDuplicate=oldState&&oldState.id!==newState.id;return hasDuplicate;};History.storeState=function(newState){History.urlToId[newState.url]=newState.id;History.storedStates.push(History.cloneObject(newState));return newState;};History.isLastSavedState=function(newState){var isLast=false,newId,oldState,oldId;if(History.savedStates.length){newId=newState.id;oldState=History.getLastSavedState();oldId=oldState.id;isLast=(newId===oldId);}
return isLast;};History.saveState=function(newState){if(History.isLastSavedState(newState)){return false;}
History.savedStates.push(History.cloneObject(newState));return true;};History.getStateByIndex=function(index){var State=null;if(typeof index==='undefined'){State=History.savedStates[History.savedStates.length-1];}
else if(index<0){State=History.savedStates[History.savedStates.length+index];}
else{State=History.savedStates[index];}
return State;};History.getCurrentIndex=function(){var index=null;if(History.savedStates.length<1){index=0;}
else{index=History.savedStates.length-1;}
return index;};History.getHash=function(doc){var url=History.getLocationHref(doc),hash;hash=History.getHashByUrl(url);return hash;};History.unescapeHash=function(hash){var result=History.normalizeHash(hash);result=decodeURIComponent(result);return result;};History.normalizeHash=function(hash){var result=hash.replace(/[^#]*#/,'').replace(/#.*/,'');return result;};History.setHash=function(hash,queue){var State,pageUrl;if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.setHash,args:arguments,queue:queue});return false;}
History.busy(true);State=History.extractState(hash,true);if(State&&!History.emulated.pushState){History.pushState(State.data,State.title,State.url,false);}
else if(History.getHash()!==hash){if(History.bugs.setHash){pageUrl=History.getPageUrl();History.pushState(null,null,pageUrl+'#'+hash,false);}
else{document.location.hash=hash;}}
return History;};History.escapeHash=function(hash){var result=History.normalizeHash(hash);result=window.encodeURIComponent(result);if(!History.bugs.hashEscape){result=result.replace(/\%21/g,'!').replace(/\%26/g,'&').replace(/\%3D/g,'=').replace(/\%3F/g,'?');}
return result;};History.getHashByUrl=function(url){var hash=String(url).replace(/([^#]*)#?([^#]*)#?(.*)/,'$2');hash=History.unescapeHash(hash);return hash;};History.setTitle=function(newState){var title=newState.title,firstState;if(!title){firstState=History.getStateByIndex(0);if(firstState&&firstState.url===newState.url){title=firstState.title||History.options.initialTitle;}}
try{document.getElementsByTagName('title')[0].innerHTML=title.replace('<','&lt;').replace('>','&gt;').replace(' & ',' &amp; ');}
catch(Exception){}
document.title=title;return History;};History.queues=[];History.busy=function(value){if(typeof value!=='undefined'){History.busy.flag=value;}
else if(typeof History.busy.flag==='undefined'){History.busy.flag=false;}
if(!History.busy.flag){clearTimeout(History.busy.timeout);var fireNext=function(){var i,queue,item;if(History.busy.flag)return;for(i=History.queues.length-1;i>=0;--i){queue=History.queues[i];if(queue.length===0)continue;item=queue.shift();History.fireQueueItem(item);History.busy.timeout=setTimeout(fireNext,History.options.busyDelay);}};History.busy.timeout=setTimeout(fireNext,History.options.busyDelay);}
return History.busy.flag;};History.busy.flag=false;History.fireQueueItem=function(item){return item.callback.apply(item.scope||History,item.args||[]);};History.pushQueue=function(item){History.queues[item.queue||0]=History.queues[item.queue||0]||[];History.queues[item.queue||0].push(item);return History;};History.queue=function(item,queue){if(typeof item==='function'){item={callback:item};}
if(typeof queue!=='undefined'){item.queue=queue;}
if(History.busy()){History.pushQueue(item);}else{History.fireQueueItem(item);}
return History;};History.clearQueue=function(){History.busy.flag=false;History.queues=[];return History;};History.stateChanged=false;History.doubleChecker=false;History.doubleCheckComplete=function(){History.stateChanged=true;History.doubleCheckClear();return History;};History.doubleCheckClear=function(){if(History.doubleChecker){clearTimeout(History.doubleChecker);History.doubleChecker=false;}
return History;};History.doubleCheck=function(tryAgain){History.stateChanged=false;History.doubleCheckClear();if(History.bugs.ieDoubleCheck){History.doubleChecker=setTimeout(function(){History.doubleCheckClear();if(!History.stateChanged){tryAgain();}
return true;},History.options.doubleCheckInterval);}
return History;};History.safariStatePoll=function(){var
urlState=History.extractState(History.getLocationHref()),newState;if(!History.isLastSavedState(urlState)){newState=urlState;}
else{return;}
if(!newState){newState=History.createStateObject();}
History.Adapter.trigger(window,'popstate');return History;};History.back=function(queue){if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.back,args:arguments,queue:queue});return false;}
History.busy(true);History.doubleCheck(function(){History.back(false);});history.go(-1);return true;};History.forward=function(queue){if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.forward,args:arguments,queue:queue});return false;}
History.busy(true);History.doubleCheck(function(){History.forward(false);});history.go(1);return true;};History.go=function(index,queue){var i;if(index>0){for(i=1;i<=index;++i){History.forward(queue);}}
else if(index<0){for(i=-1;i>=index;--i){History.back(queue);}}
else{throw new Error('History.go: History.go requires a positive or negative integer passed.');}
return History;};if(History.emulated.pushState){var emptyFunction=function(){};History.pushState=History.pushState||emptyFunction;History.replaceState=History.replaceState||emptyFunction;}
else{History.onPopState=function(event,extra){var stateId=false,newState=false,currentHash,currentState;History.doubleCheckComplete();currentHash=History.getHash();if(currentHash){currentState=History.extractState(currentHash||History.getLocationHref(),true);if(currentState){History.replaceState(currentState.data,currentState.title,currentState.url,false);}
else{History.Adapter.trigger(window,'anchorchange');History.busy(false);}
History.expectedStateId=false;return false;}
stateId=History.Adapter.extractEventData('state',event,extra)||false;if(stateId){newState=History.getStateById(stateId);}
else if(History.expectedStateId){newState=History.getStateById(History.expectedStateId);}
else{newState=History.extractState(History.getLocationHref());}
if(!newState){newState=History.createStateObject(null,null,History.getLocationHref());}
History.expectedStateId=false;if(History.isLastSavedState(newState)){History.busy(false);return false;}
History.storeState(newState);History.saveState(newState);History.setTitle(newState);History.Adapter.trigger(window,'statechange');History.busy(false);return true;};History.Adapter.bind(window,'popstate',History.onPopState);History.pushState=function(data,title,url,queue){if(History.getHashByUrl(url)&&History.emulated.pushState){throw new Error('History.js does not support states with fragement-identifiers (hashes/anchors).');}
if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.pushState,args:arguments,queue:queue});return false;}
History.busy(true);var newState=History.createStateObject(data,title,url);if(History.isLastSavedState(newState)){History.busy(false);}
else{History.storeState(newState);History.expectedStateId=newState.id;history.pushState(newState.id,newState.title,newState.url);History.Adapter.trigger(window,'popstate');}
return true;};History.replaceState=function(data,title,url,queue){if(History.getHashByUrl(url)&&History.emulated.pushState){throw new Error('History.js does not support states with fragement-identifiers (hashes/anchors).');}
if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.replaceState,args:arguments,queue:queue});return false;}
History.busy(true);var newState=History.createStateObject(data,title,url);if(History.isLastSavedState(newState)){History.busy(false);}
else{History.storeState(newState);History.expectedStateId=newState.id;history.replaceState(newState.id,newState.title,newState.url);History.Adapter.trigger(window,'popstate');}
return true;};}
if(sessionStorage){try{History.store=JSON.parse(sessionStorage.getItem('History.store'))||{};}
catch(err){History.store={};}
History.normalizeStore();}
else{History.store={};History.normalizeStore();}
History.Adapter.bind(window,"unload",History.clearAllIntervals);History.saveState(History.storeState(History.extractState(History.getLocationHref(),true)));if(sessionStorage){History.onUnload=function(){var currentStore,item,currentStoreString;try{currentStore=JSON.parse(sessionStorage.getItem('History.store'))||{};}
catch(err){currentStore={};}
currentStore.idToState=currentStore.idToState||{};currentStore.urlToId=currentStore.urlToId||{};currentStore.stateToId=currentStore.stateToId||{};for(item in History.idToState){if(!History.idToState.hasOwnProperty(item)){continue;}
currentStore.idToState[item]=History.idToState[item];}
for(item in History.urlToId){if(!History.urlToId.hasOwnProperty(item)){continue;}
currentStore.urlToId[item]=History.urlToId[item];}
for(item in History.stateToId){if(!History.stateToId.hasOwnProperty(item)){continue;}
currentStore.stateToId[item]=History.stateToId[item];}
History.store=currentStore;History.normalizeStore();currentStoreString=JSON.stringify(currentStore);try{sessionStorage.setItem('History.store',currentStoreString);}
catch(e){if(/QUOTA_EXCEEDED_ERR/.test(e.message)){sessionStorage.removeItem('History.store');sessionStorage.setItem('History.store',currentStoreString);}else{throw e;}}};History.intervalList.push(setInterval(History.onUnload,History.options.storeInterval));History.Adapter.bind(window,'beforeunload',History.onUnload);History.Adapter.bind(window,'unload',History.onUnload);}
if(!History.emulated.pushState){if(History.bugs.safariPoll){History.intervalList.push(setInterval(History.safariStatePoll,History.options.safariPollInterval));}
if(navigator.vendor==='Apple Computer, Inc.'||(navigator.appCodeName||'')==='Mozilla'){History.Adapter.bind(window,'hashchange',function(){History.Adapter.trigger(window,'popstate');});if(History.getHash()){History.Adapter.onDomLoad(function(){History.Adapter.trigger(window,'hashchange');});}}}};if(!History.options||!History.options.delayInit){History.init();}})(window);;

/****** FILE: framework/admin/thirdparty/history-js/scripts/uncompressed/history.adapter.jquery.js *****/

(function(window,undefined){"use strict";var
History=window.History=window.History||{},jQuery=window.jQuery;if(typeof History.Adapter!=='undefined'){throw new Error('History.js Adapter has already been loaded...');}
History.Adapter={bind:function(el,event,callback){jQuery(el).bind(event,callback);},trigger:function(el,event,extra){jQuery(el).trigger(event,extra);},extractEventData:function(key,event,extra){var result=(event&&event.originalEvent&&event.originalEvent[key])||(extra&&extra[key])||undefined;return result;},onDomLoad:function(callback){jQuery(callback);}};if(typeof History.init!=='undefined'){History.init();}})(window);;

/****** FILE: framework/admin/thirdparty/history-js/scripts/uncompressed/history.html4.js *****/

(function(window,undefined){"use strict";var
document=window.document,setTimeout=window.setTimeout||setTimeout,clearTimeout=window.clearTimeout||clearTimeout,setInterval=window.setInterval||setInterval,History=window.History=window.History||{};if(typeof History.initHtml4!=='undefined'){throw new Error('History.js HTML4 Support has already been loaded...');}
History.initHtml4=function(){if(typeof History.initHtml4.initialized!=='undefined'){return false;}
else{History.initHtml4.initialized=true;}
History.enabled=true;History.savedHashes=[];History.isLastHash=function(newHash){var oldHash=History.getHashByIndex(),isLast;isLast=newHash===oldHash;return isLast;};History.isHashEqual=function(newHash,oldHash){newHash=encodeURIComponent(newHash).replace(/%25/g,"%");oldHash=encodeURIComponent(oldHash).replace(/%25/g,"%");return newHash===oldHash;};History.saveHash=function(newHash){if(History.isLastHash(newHash)){return false;}
History.savedHashes.push(newHash);return true;};History.getHashByIndex=function(index){var hash=null;if(typeof index==='undefined'){hash=History.savedHashes[History.savedHashes.length-1];}
else if(index<0){hash=History.savedHashes[History.savedHashes.length+index];}
else{hash=History.savedHashes[index];}
return hash;};History.discardedHashes={};History.discardedStates={};History.discardState=function(discardedState,forwardState,backState){var discardedStateHash=History.getHashByState(discardedState),discardObject;discardObject={'discardedState':discardedState,'backState':backState,'forwardState':forwardState};History.discardedStates[discardedStateHash]=discardObject;return true;};History.discardHash=function(discardedHash,forwardState,backState){var discardObject={'discardedHash':discardedHash,'backState':backState,'forwardState':forwardState};History.discardedHashes[discardedHash]=discardObject;return true;};History.discardedState=function(State){var StateHash=History.getHashByState(State),discarded;discarded=History.discardedStates[StateHash]||false;return discarded;};History.discardedHash=function(hash){var discarded=History.discardedHashes[hash]||false;return discarded;};History.recycleState=function(State){var StateHash=History.getHashByState(State);if(History.discardedState(State)){delete History.discardedStates[StateHash];}
return true;};if(History.emulated.hashChange){History.hashChangeInit=function(){History.checkerFunction=null;var lastDocumentHash='',iframeId,iframe,lastIframeHash,checkerRunning,startedWithHash=Boolean(History.getHash());if(History.isInternetExplorer()){iframeId='historyjs-iframe';iframe=document.createElement('iframe');iframe.setAttribute('id',iframeId);iframe.setAttribute('src','#');iframe.style.display='none';document.body.appendChild(iframe);iframe.contentWindow.document.open();iframe.contentWindow.document.close();lastIframeHash='';checkerRunning=false;History.checkerFunction=function(){if(checkerRunning){return false;}
checkerRunning=true;var
documentHash=History.getHash(),iframeHash=History.getHash(iframe.contentWindow.document.location);if(documentHash!==lastDocumentHash){lastDocumentHash=documentHash;if(iframeHash!==documentHash){lastIframeHash=iframeHash=documentHash;iframe.contentWindow.document.open();iframe.contentWindow.document.close();iframe.contentWindow.document.location.hash=History.escapeHash(documentHash);}
History.Adapter.trigger(window,'hashchange');}
else if(iframeHash!==lastIframeHash){lastIframeHash=iframeHash;if(startedWithHash&&iframeHash===''){History.back();}
else{History.setHash(iframeHash,false);}}
checkerRunning=false;return true;};}
else{History.checkerFunction=function(){var documentHash=History.getHash()||'';if(documentHash!==lastDocumentHash){lastDocumentHash=documentHash;History.Adapter.trigger(window,'hashchange');}
return true;};}
History.intervalList.push(setInterval(History.checkerFunction,History.options.hashChangeInterval));return true;};History.Adapter.onDomLoad(History.hashChangeInit);}
if(History.emulated.pushState){History.onHashChange=function(event){var currentUrl=((event&&event.newURL)||History.getLocationHref()),currentHash=History.getHashByUrl(currentUrl),currentState=null,currentStateHash=null,currentStateHashExits=null,discardObject;if(History.isLastHash(currentHash)){History.busy(false);return false;}
History.doubleCheckComplete();History.saveHash(currentHash);if(currentHash&&History.isTraditionalAnchor(currentHash)){History.Adapter.trigger(window,'anchorchange');History.busy(false);return false;}
currentState=History.extractState(History.getFullUrl(currentHash||History.getLocationHref()),true);if(History.isLastSavedState(currentState)){History.busy(false);return false;}
currentStateHash=History.getHashByState(currentState);discardObject=History.discardedState(currentState);if(discardObject){if(History.getHashByIndex(-2)===History.getHashByState(discardObject.forwardState)){History.back(false);}else{History.forward(false);}
return false;}
History.pushState(currentState.data,currentState.title,encodeURI(currentState.url),false);return true;};History.Adapter.bind(window,'hashchange',History.onHashChange);History.pushState=function(data,title,url,queue){url=encodeURI(url).replace(/%25/g,"%");if(History.getHashByUrl(url)){throw new Error('History.js does not support states with fragment-identifiers (hashes/anchors).');}
if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.pushState,args:arguments,queue:queue});return false;}
History.busy(true);var newState=History.createStateObject(data,title,url),newStateHash=History.getHashByState(newState),oldState=History.getState(false),oldStateHash=History.getHashByState(oldState),html4Hash=History.getHash(),wasExpected=History.expectedStateId==newState.id;History.storeState(newState);History.expectedStateId=newState.id;History.recycleState(newState);History.setTitle(newState);if(newStateHash===oldStateHash){History.busy(false);return false;}
History.saveState(newState);if(!wasExpected)
History.Adapter.trigger(window,'statechange');if(!History.isHashEqual(newStateHash,html4Hash)&&!History.isHashEqual(newStateHash,History.getShortUrl(History.getLocationHref()))){History.setHash(newStateHash,false);}
History.busy(false);return true;};History.replaceState=function(data,title,url,queue){url=encodeURI(url).replace(/%25/g,"%");if(History.getHashByUrl(url)){throw new Error('History.js does not support states with fragment-identifiers (hashes/anchors).');}
if(queue!==false&&History.busy()){History.pushQueue({scope:History,callback:History.replaceState,args:arguments,queue:queue});return false;}
History.busy(true);var newState=History.createStateObject(data,title,url),newStateHash=History.getHashByState(newState),oldState=History.getState(false),oldStateHash=History.getHashByState(oldState),previousState=History.getStateByIndex(-2);History.discardState(oldState,newState,previousState);if(newStateHash===oldStateHash){History.storeState(newState);History.expectedStateId=newState.id;History.recycleState(newState);History.setTitle(newState);History.saveState(newState);History.Adapter.trigger(window,'statechange');History.busy(false);}
else{History.pushState(newState.data,newState.title,newState.url,false);}
return true;};}
if(History.emulated.pushState){if(History.getHash()&&!History.emulated.hashChange){History.Adapter.onDomLoad(function(){History.Adapter.trigger(window,'hashchange');});}}};if(typeof History.init!=='undefined'){History.init();}})(window);;

/****** FILE: framework/thirdparty/jstree/jquery.jstree.js *****/
"use strict";(function(){if(jQuery&&jQuery.jstree){return;}
var is_ie6=false,is_ie7=false,is_ff2=false;(function($){$.vakata={};$.vakata.css={get_css:function(rule_name,delete_flag,sheet){rule_name=rule_name.toLowerCase();var css_rules=sheet.cssRules||sheet.rules,j=0;do{if(css_rules.length&&j>css_rules.length+5){return false;}
if(css_rules[j].selectorText&&css_rules[j].selectorText.toLowerCase()==rule_name){if(delete_flag===true){if(sheet.removeRule){sheet.removeRule(j);}
if(sheet.deleteRule){sheet.deleteRule(j);}
return true;}
else{return css_rules[j];}}}
while(css_rules[++j]);return false;},add_css:function(rule_name,sheet){if($.jstree.css.get_css(rule_name,false,sheet)){return false;}
if(sheet.insertRule){sheet.insertRule(rule_name+' { }',0);}else{sheet.addRule(rule_name,null,0);}
return $.vakata.css.get_css(rule_name);},remove_css:function(rule_name,sheet){return $.vakata.css.get_css(rule_name,true,sheet);},add_sheet:function(opts){}};var instances=[],focused_instance=-1,plugins={},prepared_move={};$.fn.jstree=function(settings){var isMethodCall=(typeof settings=='string'),args=Array.prototype.slice.call(arguments,1),returnValue=this;if(isMethodCall){if(settings.substring(0,1)=='_'){return returnValue;}
this.each(function(){var instance=instances[$.data(this,"jstree_instance_id")],methodValue=(instance&&$.isFunction(instance[settings]))?instance[settings].apply(instance,args):instance;if(typeof methodValue!=="undefined"&&(settings.indexOf("is_")===0||(methodValue!==true&&methodValue!==false))){returnValue=methodValue;return false;}});}
else{this.each(function(){var instance_id=$.data(this,"jstree_instance_id"),a=[],b=settings?$.extend({},true,settings):{},c=$(this),s=false,t=[];a=a.concat(args);if(c.data("jstree")){a.push(c.data("jstree"));}
b=a.length?$.extend.apply(null,[true,b].concat(a)):b;if(typeof instance_id!=="undefined"&&instances[instance_id]){instances[instance_id].destroy();}
instance_id=parseInt(instances.push({}),10)-1;$.data(this,"jstree_instance_id",instance_id);b.plugins=$.isArray(b.plugins)?b.plugins:$.jstree.defaults.plugins.slice();b.plugins.unshift("core");b.plugins=b.plugins.sort().join(",,").replace(/(,|^)([^,]+)(,,\2)+(,|$)/g,"$1$2$4").replace(/,,+/g,",").replace(/,$/,"").split(",");s=$.extend(true,{},$.jstree.defaults,b);s.plugins=b.plugins;$.each(plugins,function(i,val){if($.inArray(i,s.plugins)===-1){s[i]=null;delete s[i];}
else{t.push(i);}});s.plugins=t;instances[instance_id]=new $.jstree._instance(instance_id,$(this).addClass("jstree jstree-"+instance_id),s);$.each(instances[instance_id]._get_settings().plugins,function(i,val){instances[instance_id].data[val]={};});$.each(instances[instance_id]._get_settings().plugins,function(i,val){if(plugins[val]){plugins[val].__init.apply(instances[instance_id]);}});setTimeout(function(){if(instances[instance_id]){instances[instance_id].init();}},0);});}
return returnValue;};$.jstree={defaults:{plugins:[]},_focused:function(){return instances[focused_instance]||null;},_reference:function(needle){if(instances[needle]){return instances[needle];}
var o=$(needle);if(!o.length&&typeof needle==="string"){o=$("#"+needle);}
if(!o.length){return null;}
return instances[o.closest(".jstree").data("jstree_instance_id")]||null;},_instance:function(index,container,settings){this.data={core:{}};this.get_settings=function(){return $.extend(true,{},settings);};this._get_settings=function(){return settings;};this.get_index=function(){return index;};this.get_container=function(){return container;};this.get_container_ul=function(){return container.children("ul:eq(0)");};this._set_settings=function(s){settings=$.extend(true,{},settings,s);};},_fn:{},plugin:function(pname,pdata){pdata=$.extend({},{__init:$.noop,__destroy:$.noop,_fn:{},defaults:false},pdata);plugins[pname]=pdata;$.jstree.defaults[pname]=pdata.defaults;$.each(pdata._fn,function(i,val){val.plugin=pname;val.old=$.jstree._fn[i];$.jstree._fn[i]=function(){var rslt,func=val,args=Array.prototype.slice.call(arguments),evnt=new $.Event("before.jstree"),rlbk=false;if(this.data.core.locked===true&&i!=="unlock"&&i!=="is_locked"){return;}
do{if(func&&func.plugin&&$.inArray(func.plugin,this._get_settings().plugins)!==-1){break;}
func=func.old;}while(func);if(!func){return;}
if(i.indexOf("_")===0){rslt=func.apply(this,args);}
else{rslt=this.get_container().triggerHandler(evnt,{"func":i,"inst":this,"args":args,"plugin":func.plugin});if(rslt===false){return;}
if(typeof rslt!=="undefined"){args=rslt;}
rslt=func.apply($.extend({},this,{__callback:function(data){this.get_container().triggerHandler(i+'.jstree',{"inst":this,"args":args,"rslt":data,"rlbk":rlbk});},__rollback:function(){rlbk=this.get_rollback();return rlbk;},__call_old:function(replace_arguments){return func.old.apply(this,(replace_arguments?Array.prototype.slice.call(arguments,1):args));}}),args);}
return rslt;};$.jstree._fn[i].old=val.old;$.jstree._fn[i].plugin=pname;});},rollback:function(rb){if(rb){if(!$.isArray(rb)){rb=[rb];}
$.each(rb,function(i,val){instances[val.i].set_rollback(val.h,val.d);});}}};$.jstree._fn=$.jstree._instance.prototype={};$(function(){var u=navigator.userAgent.toLowerCase(),v=(u.match(/.+?(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[0,'0'])[1],css_string=''+'.jstree ul, .jstree li { display:block; margin:0 0 0 0; padding:0 0 0 0; list-style-type:none; } '+'.jstree li { display:block; min-height:18px; line-height:18px; white-space:nowrap; margin-left:18px; min-width:18px; } '+'.jstree-rtl li { margin-left:0; margin-right:18px; } '+'.jstree > ul > li { margin-left:0px; } '+'.jstree-rtl > ul > li { margin-right:0px; } '+'.jstree ins { display:inline-block; text-decoration:none; width:18px; height:18px; margin:0 0 0 0; padding:0; } '+'.jstree a { display:inline-block; line-height:16px; height:16px; color:black; white-space:nowrap; text-decoration:none; padding:1px 2px; margin:0; } '+'.jstree a:focus { outline: none; } '+'.jstree a > ins { height:16px; width:16px; } '+'.jstree a > .jstree-icon { margin-right:3px; } '+'.jstree-rtl a > .jstree-icon { margin-left:3px; margin-right:0; } '+'li.jstree-open > ul { display:block; } '+'li.jstree-closed > ul { display:none; } ';if(/msie/.test(u)&&parseInt(v,10)==6){is_ie6=true;try{document.execCommand("BackgroundImageCache",false,true);}catch(err){}
css_string+=''+'.jstree li { height:18px; margin-left:0; margin-right:0; } '+'.jstree li li { margin-left:18px; } '+'.jstree-rtl li li { margin-left:0px; margin-right:18px; } '+'li.jstree-open ul { display:block; } '+'li.jstree-closed ul { display:none !important; } '+'.jstree li a { display:inline; border-width:0 !important; padding:0px 2px !important; } '+'.jstree li a ins { height:16px; width:16px; margin-right:3px; } '+'.jstree-rtl li a ins { margin-right:0px; margin-left:3px; } ';}
if(/msie/.test(u)&&parseInt(v,10)==7){is_ie7=true;css_string+='.jstree li a { border-width:0 !important; padding:0px 2px !important; } ';}
if(!/compatible/.test(u)&&/mozilla/.test(u)&&parseFloat(v,10)<1.9){is_ff2=true;css_string+=''+'.jstree ins { display:-moz-inline-box; } '+'.jstree li { line-height:12px; } '+'.jstree a { display:-moz-inline-box; } '+'.jstree .jstree-no-icons .jstree-checkbox { display:-moz-inline-stack !important; } ';}
$.vakata.css.add_sheet({str:css_string,title:"jstree"});});$.jstree.plugin("core",{__init:function(){this.data.core.locked=false;this.data.core.to_open=this.get_settings().core.initially_open;this.data.core.to_load=this.get_settings().core.initially_load;},defaults:{html_titles:false,animation:500,initially_open:[],initially_load:[],open_parents:true,notify_plugins:true,rtl:false,load_open:false,strings:{loading:"Loading ...",new_node:"New node",multiple_selection:"Multiple selection"}},_fn:{init:function(){this.set_focus();if(this._get_settings().core.rtl){this.get_container().addClass("jstree-rtl").css("direction","rtl");}
this.get_container().html("<ul><li class='jstree-last jstree-leaf'><ins>&#160;</ins><a class='jstree-loading' href='#'><ins class='jstree-icon'>&#160;</ins>"+this._get_string("loading")+"</a></li></ul>");this.data.core.li_height=this.get_container_ul().find("li.jstree-closed, li.jstree-leaf").eq(0).height()||18;this.get_container().delegate("li > ins","click.jstree",$.proxy(function(event){var trgt=$(event.target);this.toggle_node(trgt);},this)).bind("mousedown.jstree",$.proxy(function(){this.set_focus();},this)).bind("dblclick.jstree",function(event){var sel;if(document.selection&&document.selection.empty){document.selection.empty();}
else{if(window.getSelection){sel=window.getSelection();try{sel.removeAllRanges();sel.collapse();}catch(err){}}}});if(this._get_settings().core.notify_plugins){this.get_container().bind("load_node.jstree",$.proxy(function(e,data){var o=this._get_node(data.rslt.obj),t=this;if(o===-1){o=this.get_container_ul();}
if(!o.length){return;}
o.find("li").each(function(){var th=$(this);if(th.data("jstree")){$.each(th.data("jstree"),function(plugin,values){if(t.data[plugin]&&$.isFunction(t["_"+plugin+"_notify"])){t["_"+plugin+"_notify"].call(t,th,values);}});}});},this));}
if(this._get_settings().core.load_open){this.get_container().bind("load_node.jstree",$.proxy(function(e,data){var o=this._get_node(data.rslt.obj),t=this;if(o===-1){o=this.get_container_ul();}
if(!o.length){return;}
o.find("li.jstree-open:not(:has(ul))").each(function(){t.load_node(this,$.noop,$.noop);});},this));}
this.__callback();this.load_node(-1,function(){this.loaded();this.reload_nodes();});},destroy:function(){var i,n=this.get_index(),s=this._get_settings(),_this=this;$.each(s.plugins,function(i,val){try{plugins[val].__destroy.apply(_this);}catch(err){}});this.__callback();if(this.is_focused()){for(i in instances){if(instances.hasOwnProperty(i)&&i!=n){instances[i].set_focus();break;}}}
if(n===focused_instance){focused_instance=-1;}
this.get_container().unbind(".jstree").undelegate(".jstree").removeData("jstree_instance_id").find("[class^='jstree']").andSelf().attr("class",function(){return this.className.replace(/jstree[^ ]*|$/ig,'');});$(document).unbind(".jstree-"+n).undelegate(".jstree-"+n);instances[n]=null;delete instances[n];},_core_notify:function(n,data){if(data.opened){this.open_node(n,false,true);}},lock:function(){this.data.core.locked=true;this.get_container().children("ul").addClass("jstree-locked").css("opacity","0.7");this.__callback({});},unlock:function(){this.data.core.locked=false;this.get_container().children("ul").removeClass("jstree-locked").css("opacity","1");this.__callback({});},is_locked:function(){return this.data.core.locked;},save_opened:function(){var _this=this;this.data.core.to_open=[];this.get_container_ul().find("li.jstree-open").each(function(){if(this.id){_this.data.core.to_open.push("#"+this.id.toString().replace(/^#/,"").replace(/\\\//g,"/").replace(/\//g,"\\\/").replace(/\\\./g,".").replace(/\./g,"\\.").replace(/\:/g,"\\:"));}});this.__callback(_this.data.core.to_open);},save_loaded:function(){},reload_nodes:function(is_callback){var _this=this,done=true,current=[],remaining=[];if(!is_callback){this.data.core.reopen=false;this.data.core.refreshing=true;this.data.core.to_open=$.map($.makeArray(this.data.core.to_open),function(n){return"#"+n.toString().replace(/^#/,"").replace(/\\\//g,"/").replace(/\//g,"\\\/").replace(/\\\./g,".").replace(/\./g,"\\.").replace(/\:/g,"\\:");});this.data.core.to_load=$.map($.makeArray(this.data.core.to_load),function(n){return"#"+n.toString().replace(/^#/,"").replace(/\\\//g,"/").replace(/\//g,"\\\/").replace(/\\\./g,".").replace(/\./g,"\\.").replace(/\:/g,"\\:");});if(this.data.core.to_open.length){this.data.core.to_load=this.data.core.to_load.concat(this.data.core.to_open);}}
if(this.data.core.to_load.length){$.each(this.data.core.to_load,function(i,val){if(val=="#"){return true;}
if($(val).length){current.push(val);}
else{remaining.push(val);}});if(current.length){this.data.core.to_load=remaining;$.each(current,function(i,val){if(!_this._is_loaded(val)){_this.load_node(val,function(){_this.reload_nodes(true);},function(){_this.reload_nodes(true);});done=false;}});}}
if(this.data.core.to_open.length){$.each(this.data.core.to_open,function(i,val){_this.open_node(val,false,true);});}
if(done){if(this.data.core.reopen){clearTimeout(this.data.core.reopen);}
this.data.core.reopen=setTimeout(function(){_this.__callback({},_this);},50);this.data.core.refreshing=false;this.reopen();}},reopen:function(){var _this=this;if(this.data.core.to_open.length){$.each(this.data.core.to_open,function(i,val){_this.open_node(val,false,true);});}
this.__callback({});},refresh:function(obj,s_call,e_call){var _this=this;this.save_opened();if(!obj){obj=-1;}
obj=this._get_node(obj);if(!obj){obj=-1;}
if(obj!==-1){obj.children("UL").remove();}
else{this.get_container_ul().empty();}
this.load_node(obj,function(){_this.__callback({"obj":obj});_this.reload_nodes();if(s_call)s_call.call(this);},e_call);},loaded:function(){this.__callback();},set_focus:function(){if(this.is_focused()){return;}
var f=$.jstree._focused();if(f){f.unset_focus();}
this.get_container().addClass("jstree-focused");focused_instance=this.get_index();this.__callback();},is_focused:function(){return focused_instance==this.get_index();},unset_focus:function(){if(this.is_focused()){this.get_container().removeClass("jstree-focused");focused_instance=-1;}
this.__callback();},_get_node:function(obj){var $obj=$(obj,this.get_container());if($obj.is(".jstree")||obj==-1){return-1;}
$obj=$obj.closest("li",this.get_container());return $obj.length?$obj:false;},_get_next:function(obj,strict){obj=this._get_node(obj);if(obj===-1){return this.get_container().find("> ul > li:first-child");}
if(!obj.length){return false;}
if(strict){return(obj.nextAll("li").size()>0)?obj.nextAll("li:eq(0)"):false;}
if(obj.hasClass("jstree-open")){return obj.find("li:eq(0)");}
else if(obj.nextAll("li").size()>0){return obj.nextAll("li:eq(0)");}
else{return obj.parentsUntil(".jstree","li").next("li").eq(0);}},_get_prev:function(obj,strict){obj=this._get_node(obj);if(obj===-1){return this.get_container().find("> ul > li:last-child");}
if(!obj.length){return false;}
if(strict){return(obj.prevAll("li").length>0)?obj.prevAll("li:eq(0)"):false;}
if(obj.prev("li").length){obj=obj.prev("li").eq(0);while(obj.hasClass("jstree-open")){obj=obj.children("ul:eq(0)").children("li:last");}
return obj;}
else{var o=obj.parentsUntil(".jstree","li:eq(0)");return o.length?o:false;}},_get_parent:function(obj){obj=this._get_node(obj);if(obj==-1||!obj.length){return false;}
var o=obj.parentsUntil(".jstree","li:eq(0)");return o.length?o:-1;},_get_children:function(obj){obj=this._get_node(obj);if(obj===-1){return this.get_container().children("ul:eq(0)").children("li");}
if(!obj.length){return false;}
return obj.children("ul:eq(0)").children("li");},get_path:function(obj,id_mode){var p=[],_this=this;obj=this._get_node(obj);if(obj===-1||!obj||!obj.length){return false;}
obj.parentsUntil(".jstree","li").each(function(){p.push(id_mode?this.id:_this.get_text(this));});p.reverse();p.push(id_mode?obj.attr("id"):this.get_text(obj));return p;},_get_string:function(key){return this._get_settings().core.strings[key]||key;},is_open:function(obj){obj=this._get_node(obj);return obj&&obj!==-1&&obj.hasClass("jstree-open");},is_closed:function(obj){obj=this._get_node(obj);return obj&&obj!==-1&&obj.hasClass("jstree-closed");},is_leaf:function(obj){obj=this._get_node(obj);return obj&&obj!==-1&&obj.hasClass("jstree-leaf");},correct_state:function(obj){obj=this._get_node(obj);if(!obj||obj===-1){return false;}
obj.removeClass("jstree-closed jstree-open").addClass("jstree-leaf").children("ul").remove();this.__callback({"obj":obj});},open_node:function(obj,callback,skip_animation){obj=this._get_node(obj);if(!obj.length){return false;}
if(!obj.hasClass("jstree-closed")){if(callback){callback.call();}return false;}
var s=skip_animation||is_ie6?0:this._get_settings().core.animation,t=this;if(!this._is_loaded(obj)){obj.children("a").addClass("jstree-loading");this.load_node(obj,function(){t.open_node(obj,callback,skip_animation);},callback);}
else{if(this._get_settings().core.open_parents){obj.parentsUntil(".jstree",".jstree-closed").each(function(){t.open_node(this,false,true);});}
if(s){obj.children("ul").css("display","none");}
obj.removeClass("jstree-closed").addClass("jstree-open").children("a").removeClass("jstree-loading");if(s){obj.children("ul").stop(true,true).slideDown(s,function(){this.style.display="";t.after_open(obj);});}
else{t.after_open(obj);}
this.__callback({"obj":obj});if(callback){callback.call();}}},after_open:function(obj){this.__callback({"obj":obj});},close_node:function(obj,skip_animation){obj=this._get_node(obj);var s=skip_animation||is_ie6?0:this._get_settings().core.animation,t=this;if(!obj.length||!obj.hasClass("jstree-open")){return false;}
if(s){obj.children("ul").attr("style","display:block !important");}
obj.removeClass("jstree-open").addClass("jstree-closed");if(s){obj.children("ul").stop(true,true).slideUp(s,function(){this.style.display="";t.after_close(obj);});}
else{t.after_close(obj);}
this.__callback({"obj":obj});},after_close:function(obj){this.__callback({"obj":obj});},toggle_node:function(obj){obj=this._get_node(obj);if(obj.hasClass("jstree-closed")){return this.open_node(obj);}
if(obj.hasClass("jstree-open")){return this.close_node(obj);}},open_all:function(obj,do_animation,original_obj){obj=obj?this._get_node(obj):-1;if(!obj||obj===-1){obj=this.get_container_ul();}
if(original_obj){obj=obj.find("li.jstree-closed");}
else{original_obj=obj;if(obj.is(".jstree-closed")){obj=obj.find("li.jstree-closed").andSelf();}
else{obj=obj.find("li.jstree-closed");}}
var _this=this;obj.each(function(){var __this=this;if(!_this._is_loaded(this)){_this.open_node(this,function(){_this.open_all(__this,do_animation,original_obj);},!do_animation);}
else{_this.open_node(this,false,!do_animation);}});if(original_obj.find('li.jstree-closed').length===0){this.__callback({"obj":original_obj});}},close_all:function(obj,do_animation){var _this=this;obj=obj?this._get_node(obj):this.get_container();if(!obj||obj===-1){obj=this.get_container_ul();}
obj.find("li.jstree-open").andSelf().each(function(){_this.close_node(this,!do_animation);});this.__callback({"obj":obj});},clean_node:function(obj){obj=obj&&obj!=-1?$(obj):this.get_container_ul();obj=obj.is("li")?obj.find("li").andSelf():obj.find("li");obj.removeClass("jstree-last").filter("li:last-child").addClass("jstree-last").end().filter(":has(li)").not(".jstree-open").removeClass("jstree-leaf").addClass("jstree-closed");obj.not(".jstree-open, .jstree-closed").addClass("jstree-leaf").children("ul").remove();this.__callback({"obj":obj});},get_rollback:function(){this.__callback();return{i:this.get_index(),h:this.get_container().children("ul").clone(true),d:this.data};},set_rollback:function(html,data){this.get_container().empty().append(html);this.data=data;this.__callback();},load_node:function(obj,s_call,e_call){this.__callback({"obj":obj});},_is_loaded:function(obj){return true;},create_node:function(obj,position,js,callback,is_loaded){obj=this._get_node(obj);position=typeof position==="undefined"?"last":position;var d=$("<li />"),s=this._get_settings().core,tmp;if(obj!==-1&&!obj.length){return false;}
if(!is_loaded&&!this._is_loaded(obj)){this.load_node(obj,function(){this.create_node(obj,position,js,callback,true);});return false;}
this.__rollback();if(typeof js==="string"){js={"data":js};}
if(!js){js={};}
if(js.attr){d.attr(js.attr);}
if(js.metadata){d.data(js.metadata);}
if(js.state){d.addClass("jstree-"+js.state);}
if(!js.data){js.data=this._get_string("new_node");}
if(!$.isArray(js.data)){tmp=js.data;js.data=[];js.data.push(tmp);}
$.each(js.data,function(i,m){tmp=$("<a />");if($.isFunction(m)){m=m.call(this,js);}
if(typeof m=="string"){tmp.attr('href','#')[s.html_titles?"html":"text"](m);}
else{if(!m.attr){m.attr={};}
if(!m.attr.href){m.attr.href='#';}
tmp.attr(m.attr)[s.html_titles?"html":"text"](m.title);if(m.language){tmp.addClass(m.language);}}
tmp.prepend("<ins class='jstree-icon'>&#160;</ins>");if(!m.icon&&js.icon){m.icon=js.icon;}
if(m.icon){if(m.icon.indexOf("/")===-1){tmp.children("ins").addClass(m.icon);}
else{tmp.children("ins").css("background","url('"+m.icon+"') center center no-repeat");}}
d.append(tmp);});d.prepend("<ins class='jstree-icon'>&#160;</ins>");if(obj===-1){obj=this.get_container();if(position==="before"){position="first";}
if(position==="after"){position="last";}}
switch(position){case"before":obj.before(d);tmp=this._get_parent(obj);break;case"after":obj.after(d);tmp=this._get_parent(obj);break;case"inside":case"first":if(!obj.children("ul").length){obj.append("<ul />");}
obj.children("ul").prepend(d);tmp=obj;break;case"last":if(!obj.children("ul").length){obj.append("<ul />");}
obj.children("ul").append(d);tmp=obj;break;default:if(!obj.children("ul").length){obj.append("<ul />");}
if(!position){position=0;}
tmp=obj.children("ul").children("li").eq(position);if(tmp.length){tmp.before(d);}
else{obj.children("ul").append(d);}
tmp=obj;break;}
if(tmp===-1||tmp.get(0)===this.get_container().get(0)){tmp=-1;}
this.clean_node(tmp);this.__callback({"obj":d,"parent":tmp});if(callback){callback.call(this,d);}
return d;},get_text:function(obj){obj=this._get_node(obj);if(!obj.length){return false;}
var s=this._get_settings().core.html_titles;obj=obj.children("a:eq(0)");if(s){obj=obj.clone();obj.children("INS").remove();return obj.html();}
else{obj=obj.contents().filter(function(){return this.nodeType==3;})[0];return obj?obj.nodeValue:'';}},set_text:function(obj,val){obj=this._get_node(obj);if(!obj.length){return false;}
obj=obj.children("a:eq(0)");if(this._get_settings().core.html_titles){var tmp=obj.children("INS").clone();obj.html(val).prepend(tmp);this.__callback({"obj":obj,"name":val});return true;}
else{obj=obj.contents().filter(function(){return this.nodeType==3;})[0];this.__callback({"obj":obj,"name":val});return(obj.nodeValue=val);}},rename_node:function(obj,val){obj=this._get_node(obj);this.__rollback();if(obj&&obj.length&&this.set_text.apply(this,Array.prototype.slice.call(arguments))){this.__callback({"obj":obj,"name":val});}},delete_node:function(obj){obj=this._get_node(obj);if(!obj.length){return false;}
this.__rollback();var p=this._get_parent(obj),prev=$([]),t=this;obj.each(function(){prev=prev.add(t._get_prev(this));});obj=obj.detach();if(p!==-1&&p.find("> ul > li").length===0){p.removeClass("jstree-open jstree-closed").addClass("jstree-leaf");}
this.clean_node(p);this.__callback({"obj":obj,"prev":prev,"parent":p});return obj;},prepare_move:function(o,r,pos,cb,is_cb){var p={};p.ot=$.jstree._reference(o)||this;p.o=p.ot._get_node(o);p.r=r===-1?-1:this._get_node(r);p.p=(typeof pos==="undefined"||pos===false)?"last":pos;if(!is_cb&&prepared_move.o&&prepared_move.o[0]===p.o[0]&&prepared_move.r[0]===p.r[0]&&prepared_move.p===p.p){this.__callback(prepared_move);if(cb){cb.call(this,prepared_move);}
return;}
p.ot=$.jstree._reference(p.o)||this;p.rt=$.jstree._reference(p.r)||this;if(p.r===-1||!p.r){p.cr=-1;switch(p.p){case"first":case"before":case"inside":p.cp=0;break;case"after":case"last":p.cp=p.rt.get_container().find(" > ul > li").length;break;default:p.cp=p.p;break;}}
else{if(!/^(before|after)$/.test(p.p)&&!this._is_loaded(p.r)){return this.load_node(p.r,function(){this.prepare_move(o,r,pos,cb,true);});}
switch(p.p){case"before":p.cp=p.r.index();p.cr=p.rt._get_parent(p.r);break;case"after":p.cp=p.r.index()+1;p.cr=p.rt._get_parent(p.r);break;case"inside":case"first":p.cp=0;p.cr=p.r;break;case"last":p.cp=p.r.find(" > ul > li").length;p.cr=p.r;break;default:p.cp=p.p;p.cr=p.r;break;}}
p.np=p.cr==-1?p.rt.get_container():p.cr;p.op=p.ot._get_parent(p.o);p.cop=p.o.index();if(p.op===-1){p.op=p.ot?p.ot.get_container():this.get_container();}
if(!/^(before|after)$/.test(p.p)&&p.op&&p.np&&p.op[0]===p.np[0]&&p.o.index()<p.cp){p.cp++;}
p.or=p.np.find(" > ul > li:nth-child("+(p.cp+1)+")");prepared_move=p;this.__callback(prepared_move);if(cb){cb.call(this,prepared_move);}},check_move:function(){var obj=prepared_move,ret=true,r=obj.r===-1?this.get_container():obj.r;if(!obj||!obj.o||obj.or[0]===obj.o[0]){return false;}
if(!obj.cy){if(obj.op&&obj.np&&obj.op[0]===obj.np[0]&&obj.cp-1===obj.o.index()){return false;}
obj.o.each(function(){if(r.parentsUntil(".jstree","li").andSelf().index(this)!==-1){ret=false;return false;}});}
return ret;},move_node:function(obj,ref,position,is_copy,is_prepared,skip_check){if(!is_prepared){return this.prepare_move(obj,ref,position,function(p){this.move_node(p,false,false,is_copy,true,skip_check);});}
if(is_copy){prepared_move.cy=true;}
if(!skip_check&&!this.check_move()){return false;}
this.__rollback();var o=false;if(is_copy){o=obj.o.clone(true);o.find("*[id]").andSelf().each(function(){if(this.id){this.id="copy_"+this.id;}});}
else{o=obj.o;}
if(obj.or.length){obj.or.before(o);}
else{if(!obj.np.children("ul").length){$("<ul />").appendTo(obj.np);}
obj.np.children("ul:eq(0)").append(o);}
try{obj.ot.clean_node(obj.op);obj.rt.clean_node(obj.np);if(!obj.op.find("> ul > li").length){obj.op.removeClass("jstree-open jstree-closed").addClass("jstree-leaf").children("ul").remove();}}catch(e){}
if(is_copy){prepared_move.cy=true;prepared_move.oc=o;}
this.__callback(prepared_move);return prepared_move;},_get_move:function(){return prepared_move;}}});})(jQuery);(function($){var scrollbar_width,e1,e2;$(function(){if(/msie/.test(navigator.userAgent.toLowerCase())){e1=$('<textarea cols="10" rows="2"></textarea>').css({position:'absolute',top:-1000,left:0}).appendTo('body');e2=$('<textarea cols="10" rows="2" style="overflow: hidden;"></textarea>').css({position:'absolute',top:-1000,left:0}).appendTo('body');scrollbar_width=e1.width()-e2.width();e1.add(e2).remove();}
else{e1=$('<div />').css({width:100,height:100,overflow:'auto',position:'absolute',top:-1000,left:0}).prependTo('body').append('<div />').find('div').css({width:'100%',height:200});scrollbar_width=100-e1.width();e1.parent().remove();}});$.jstree.plugin("ui",{__init:function(){this.data.ui.selected=$();this.data.ui.last_selected=false;this.data.ui.hovered=null;this.data.ui.to_select=this.get_settings().ui.initially_select;this.get_container().delegate("a","click.jstree",$.proxy(function(event){event.preventDefault();event.currentTarget.blur();if(!$(event.currentTarget).hasClass("jstree-loading")){this.select_node(event.currentTarget,true,event);}},this)).delegate("a","mouseenter.jstree",$.proxy(function(event){if(!$(event.currentTarget).hasClass("jstree-loading")){this.hover_node(event.target);}},this)).delegate("a","mouseleave.jstree",$.proxy(function(event){if(!$(event.currentTarget).hasClass("jstree-loading")){this.dehover_node(event.target);}},this)).bind("reopen.jstree",$.proxy(function(){this.reselect();},this)).bind("get_rollback.jstree",$.proxy(function(){this.dehover_node();this.save_selected();},this)).bind("set_rollback.jstree",$.proxy(function(){this.reselect();},this)).bind("close_node.jstree",$.proxy(function(event,data){var s=this._get_settings().ui,obj=this._get_node(data.rslt.obj),clk=(obj&&obj.length)?obj.children("ul").find("a.jstree-clicked"):$(),_this=this;if(s.selected_parent_close===false||!clk.length){return;}
clk.each(function(){_this.deselect_node(this);if(s.selected_parent_close==="select_parent"){_this.select_node(obj);}});},this)).bind("delete_node.jstree",$.proxy(function(event,data){var s=this._get_settings().ui.select_prev_on_delete,obj=this._get_node(data.rslt.obj),clk=(obj&&obj.length)?obj.find("a.jstree-clicked"):[],_this=this;clk.each(function(){_this.deselect_node(this);});if(s&&clk.length){data.rslt.prev.each(function(){if(this.parentNode){_this.select_node(this);return false;}});}},this)).bind("move_node.jstree",$.proxy(function(event,data){if(data.rslt.cy){data.rslt.oc.find("a.jstree-clicked").removeClass("jstree-clicked");}},this));},defaults:{select_limit:-1,select_multiple_modifier:"ctrl",select_range_modifier:"shift",selected_parent_close:"select_parent",selected_parent_open:true,select_prev_on_delete:true,disable_selecting_children:false,initially_select:[]},_fn:{_get_node:function(obj,allow_multiple){if(typeof obj==="undefined"||obj===null){return allow_multiple?this.data.ui.selected:this.data.ui.last_selected;}
var $obj=$(obj,this.get_container());if($obj.is(".jstree")||obj==-1){return-1;}
$obj=$obj.closest("li",this.get_container());return $obj.length?$obj:false;},_ui_notify:function(n,data){if(data.selected){this.select_node(n,false);}},save_selected:function(){var _this=this;this.data.ui.to_select=[];this.data.ui.selected.each(function(){if(this.id){_this.data.ui.to_select.push("#"+this.id.toString().replace(/^#/,"").replace(/\\\//g,"/").replace(/\//g,"\\\/").replace(/\\\./g,".").replace(/\./g,"\\.").replace(/\:/g,"\\:"));}});this.__callback(this.data.ui.to_select);},reselect:function(){var _this=this,s=this.data.ui.to_select;s=$.map($.makeArray(s),function(n){return"#"+n.toString().replace(/^#/,"").replace(/\\\//g,"/").replace(/\//g,"\\\/").replace(/\\\./g,".").replace(/\./g,"\\.").replace(/\:/g,"\\:");});$.each(s,function(i,val){if(val&&val!=="#"){_this.select_node(val);}});this.data.ui.selected=this.data.ui.selected.filter(function(){return this.parentNode;});this.__callback();},refresh:function(obj){this.save_selected();return this.__call_old();},hover_node:function(obj){obj=this._get_node(obj);if(!obj.length){return false;}
if(!obj.hasClass("jstree-hovered")){this.dehover_node();}
this.data.ui.hovered=obj.children("a").addClass("jstree-hovered").parent();this._fix_scroll(obj);this.__callback({"obj":obj});},dehover_node:function(){var obj=this.data.ui.hovered,p;if(!obj||!obj.length){return false;}
p=obj.children("a").removeClass("jstree-hovered").parent();if(this.data.ui.hovered[0]===p[0]){this.data.ui.hovered=null;}
this.__callback({"obj":obj});},select_node:function(obj,check,e){obj=this._get_node(obj);if(obj==-1||!obj||!obj.length){return false;}
var s=this._get_settings().ui,is_multiple=(s.select_multiple_modifier=="on"||(s.select_multiple_modifier!==false&&e&&e[s.select_multiple_modifier+"Key"])),is_range=(s.select_range_modifier!==false&&e&&e[s.select_range_modifier+"Key"]&&this.data.ui.last_selected&&this.data.ui.last_selected[0]!==obj[0]&&this.data.ui.last_selected.parent()[0]===obj.parent()[0]),is_selected=this.is_selected(obj),proceed=true,t=this;if(check){if(s.disable_selecting_children&&is_multiple&&((obj.parentsUntil(".jstree","li").children("a.jstree-clicked").length)||(obj.children("ul").find("a.jstree-clicked:eq(0)").length))){return false;}
proceed=false;switch(!0){case(is_range):this.data.ui.last_selected.addClass("jstree-last-selected");obj=obj[obj.index()<this.data.ui.last_selected.index()?"nextUntil":"prevUntil"](".jstree-last-selected").andSelf();if(s.select_limit==-1||obj.length<s.select_limit){this.data.ui.last_selected.removeClass("jstree-last-selected");this.data.ui.selected.each(function(){if(this!==t.data.ui.last_selected[0]){t.deselect_node(this);}});is_selected=false;proceed=true;}
else{proceed=false;}
break;case(is_selected&&!is_multiple):this.deselect_all();is_selected=false;proceed=true;break;case(!is_selected&&!is_multiple):if(s.select_limit==-1||s.select_limit>0){this.deselect_all();proceed=true;}
break;case(is_selected&&is_multiple):this.deselect_node(obj);break;case(!is_selected&&is_multiple):if(s.select_limit==-1||this.data.ui.selected.length+1<=s.select_limit){proceed=true;}
break;}}
if(proceed&&!is_selected){if(!is_range){this.data.ui.last_selected=obj;}
obj.children("a").addClass("jstree-clicked");if(s.selected_parent_open){obj.parents(".jstree-closed").each(function(){t.open_node(this,false,true);});}
this.data.ui.selected=this.data.ui.selected.add(obj);this._fix_scroll(obj.eq(0));this.__callback({"obj":obj,"e":e});}},_fix_scroll:function(obj){var c=this.get_container()[0],t;if(c.scrollHeight>c.offsetHeight){obj=this._get_node(obj);if(!obj||obj===-1||!obj.length||!obj.is(":visible")){return;}
t=obj.offset().top-this.get_container().offset().top;if(t<0){c.scrollTop=c.scrollTop+t-1;}
if(t+this.data.core.li_height+(c.scrollWidth>c.offsetWidth?scrollbar_width:0)>c.offsetHeight){c.scrollTop=c.scrollTop+(t-c.offsetHeight+this.data.core.li_height+1+(c.scrollWidth>c.offsetWidth?scrollbar_width:0));}}},deselect_node:function(obj){obj=this._get_node(obj);if(!obj.length){return false;}
if(this.is_selected(obj)){obj.children("a").removeClass("jstree-clicked");this.data.ui.selected=this.data.ui.selected.not(obj);if(this.data.ui.last_selected.get(0)===obj.get(0)){this.data.ui.last_selected=this.data.ui.selected.eq(0);}
this.__callback({"obj":obj});}},toggle_select:function(obj){obj=this._get_node(obj);if(!obj.length){return false;}
if(this.is_selected(obj)){this.deselect_node(obj);}
else{this.select_node(obj);}},is_selected:function(obj){return this.data.ui.selected.index(this._get_node(obj))>=0;},get_selected:function(context){return context?$(context).find("a.jstree-clicked").parent():this.data.ui.selected;},deselect_all:function(context){var ret=context?$(context).find("a.jstree-clicked").parent():this.get_container().find("a.jstree-clicked").parent();ret.children("a.jstree-clicked").removeClass("jstree-clicked");this.data.ui.selected=$([]);this.data.ui.last_selected=false;this.__callback({"obj":ret});}}});$.jstree.defaults.plugins.push("ui");})(jQuery);(function($){$.jstree.plugin("crrm",{__init:function(){this.get_container().bind("move_node.jstree",$.proxy(function(e,data){if(this._get_settings().crrm.move.open_onmove){var t=this;data.rslt.np.parentsUntil(".jstree").andSelf().filter(".jstree-closed").each(function(){t.open_node(this,false,true);});}},this));},defaults:{input_width_limit:200,move:{always_copy:false,open_onmove:true,default_position:"last",check_move:function(m){return true;}}},_fn:{_show_input:function(obj,callback){obj=this._get_node(obj);var rtl=this._get_settings().core.rtl,w=this._get_settings().crrm.input_width_limit,w1=obj.children("ins").width(),w2=obj.find("> a:visible > ins").width()*obj.find("> a:visible > ins").length,t=this.get_text(obj),h1=$("<div />",{css:{"position":"absolute","top":"-200px","left":(rtl?"0px":"-1000px"),"visibility":"hidden"}}).appendTo("body"),h2=obj.css("position","relative").append($("<input />",{"value":t,"class":"jstree-rename-input","css":{"padding":"0","border":"1px solid silver","position":"absolute","left":(rtl?"auto":(w1+w2+4)+"px"),"right":(rtl?(w1+w2+4)+"px":"auto"),"top":"0px","height":(this.data.core.li_height-2)+"px","lineHeight":(this.data.core.li_height-2)+"px","width":"150px"},"blur":$.proxy(function(){var i=obj.children(".jstree-rename-input"),v=i.val();if(v===""){v=t;}
h1.remove();i.remove();this.set_text(obj,t);this.rename_node(obj,v);callback.call(this,obj,v,t);obj.css("position","");},this),"keyup":function(event){var key=event.keyCode||event.which;if(key==27){this.value=t;this.blur();return;}
else if(key==13){this.blur();return;}
else{h2.width(Math.min(h1.text("pW"+this.value).width(),w));}},"keypress":function(event){var key=event.keyCode||event.which;if(key==13){return false;}}})).children(".jstree-rename-input");this.set_text(obj,"");h1.css({fontFamily:h2.css('fontFamily')||'',fontSize:h2.css('fontSize')||'',fontWeight:h2.css('fontWeight')||'',fontStyle:h2.css('fontStyle')||'',fontStretch:h2.css('fontStretch')||'',fontVariant:h2.css('fontVariant')||'',letterSpacing:h2.css('letterSpacing')||'',wordSpacing:h2.css('wordSpacing')||''});h2.width(Math.min(h1.text("pW"+h2[0].value).width(),w))[0].select();},rename:function(obj){obj=this._get_node(obj);this.__rollback();var f=this.__callback;this._show_input(obj,function(obj,new_name,old_name){f.call(this,{"obj":obj,"new_name":new_name,"old_name":old_name});});},create:function(obj,position,js,callback,skip_rename){var t,_this=this;obj=this._get_node(obj);if(!obj){obj=-1;}
this.__rollback();t=this.create_node(obj,position,js,function(t){var p=this._get_parent(t),pos=$(t).index();if(callback){callback.call(this,t);}
if(p.length&&p.hasClass("jstree-closed")){this.open_node(p,false,true);}
if(!skip_rename){this._show_input(t,function(obj,new_name,old_name){_this.__callback({"obj":obj,"name":new_name,"parent":p,"position":pos});});}
else{_this.__callback({"obj":t,"name":this.get_text(t),"parent":p,"position":pos});}});return t;},remove:function(obj){obj=this._get_node(obj,true);var p=this._get_parent(obj),prev=this._get_prev(obj);this.__rollback();obj=this.delete_node(obj);if(obj!==false){this.__callback({"obj":obj,"prev":prev,"parent":p});}},check_move:function(){if(!this.__call_old()){return false;}
var s=this._get_settings().crrm.move;if(!s.check_move.call(this,this._get_move())){return false;}
return true;},move_node:function(obj,ref,position,is_copy,is_prepared,skip_check){var s=this._get_settings().crrm.move;if(!is_prepared){if(typeof position==="undefined"){position=s.default_position;}
if(position==="inside"&&!s.default_position.match(/^(before|after)$/)){position=s.default_position;}
return this.__call_old(true,obj,ref,position,is_copy,false,skip_check);}
if(s.always_copy===true||(s.always_copy==="multitree"&&obj.rt.get_index()!==obj.ot.get_index())){is_copy=true;}
this.__call_old(true,obj,ref,position,is_copy,true,skip_check);},cut:function(obj){obj=this._get_node(obj,true);if(!obj||!obj.length){return false;}
this.data.crrm.cp_nodes=false;this.data.crrm.ct_nodes=obj;this.__callback({"obj":obj});},copy:function(obj){obj=this._get_node(obj,true);if(!obj||!obj.length){return false;}
this.data.crrm.ct_nodes=false;this.data.crrm.cp_nodes=obj;this.__callback({"obj":obj});},paste:function(obj){obj=this._get_node(obj);if(!obj||!obj.length){return false;}
var nodes=this.data.crrm.ct_nodes?this.data.crrm.ct_nodes:this.data.crrm.cp_nodes;if(!this.data.crrm.ct_nodes&&!this.data.crrm.cp_nodes){return false;}
if(this.data.crrm.ct_nodes){this.move_node(this.data.crrm.ct_nodes,obj);this.data.crrm.ct_nodes=false;}
if(this.data.crrm.cp_nodes){this.move_node(this.data.crrm.cp_nodes,obj,false,true);}
this.__callback({"obj":obj,"nodes":nodes});}}});})(jQuery);(function($){var themes_loaded=[];$.jstree._themes=false;$.jstree.plugin("themes",{__init:function(){this.get_container().bind("init.jstree",$.proxy(function(){var s=this._get_settings().themes;this.data.themes.dots=s.dots;this.data.themes.icons=s.icons;this.set_theme(s.theme,s.url);},this)).bind("loaded.jstree",$.proxy(function(){if(!this.data.themes.dots){this.hide_dots();}
else{this.show_dots();}
if(!this.data.themes.icons){this.hide_icons();}
else{this.show_icons();}},this));},defaults:{theme:"default",url:false,dots:true,icons:true},_fn:{set_theme:function(theme_name,theme_url){if(!theme_name){return false;}
if(!theme_url){theme_url=$.jstree._themes+theme_name+'/style.css';}
if($.inArray(theme_url,themes_loaded)==-1){$.vakata.css.add_sheet({"url":theme_url});themes_loaded.push(theme_url);}
if(this.data.themes.theme!=theme_name){this.get_container().removeClass('jstree-'+this.data.themes.theme);this.data.themes.theme=theme_name;}
this.get_container().addClass('jstree-'+theme_name);if(!this.data.themes.dots){this.hide_dots();}
else{this.show_dots();}
if(!this.data.themes.icons){this.hide_icons();}
else{this.show_icons();}
this.__callback();},get_theme:function(){return this.data.themes.theme;},show_dots:function(){this.data.themes.dots=true;this.get_container().children("ul").removeClass("jstree-no-dots");},hide_dots:function(){this.data.themes.dots=false;this.get_container().children("ul").addClass("jstree-no-dots");},toggle_dots:function(){if(this.data.themes.dots){this.hide_dots();}else{this.show_dots();}},show_icons:function(){this.data.themes.icons=true;this.get_container().children("ul").removeClass("jstree-no-icons");},hide_icons:function(){this.data.themes.icons=false;this.get_container().children("ul").addClass("jstree-no-icons");},toggle_icons:function(){if(this.data.themes.icons){this.hide_icons();}else{this.show_icons();}}}});$(function(){if($.jstree._themes===false){$("script").each(function(){if(this.src.toString().match(/jquery\.jstree[^\/]*?\.js(\?.*)?$/)){$.jstree._themes=this.src.toString().replace(/jquery\.jstree[^\/]*?\.js(\?.*)?$/,"")+'themes/';return false;}});}
if($.jstree._themes===false){$.jstree._themes="themes/";}});$.jstree.defaults.plugins.push("themes");})(jQuery);(function($){var bound=[];function exec(i,event){var f=$.jstree._focused(),tmp;if(f&&f.data&&f.data.hotkeys&&f.data.hotkeys.enabled){tmp=f._get_settings().hotkeys[i];if(tmp){return tmp.call(f,event);}}}
$.jstree.plugin("hotkeys",{__init:function(){if(typeof $.hotkeys==="undefined"){throw"jsTree hotkeys: jQuery hotkeys plugin not included.";}
if(!this.data.ui){throw"jsTree hotkeys: jsTree UI plugin not included.";}
$.each(this._get_settings().hotkeys,function(i,v){if(v!==false&&$.inArray(i,bound)==-1){$(document).bind("keydown",i,function(event){return exec(i,event);});bound.push(i);}});this.get_container().bind("lock.jstree",$.proxy(function(){if(this.data.hotkeys.enabled){this.data.hotkeys.enabled=false;this.data.hotkeys.revert=true;}},this)).bind("unlock.jstree",$.proxy(function(){if(this.data.hotkeys.revert){this.data.hotkeys.enabled=true;}},this));this.enable_hotkeys();},defaults:{"up":function(){var o=this.data.ui.hovered||this.data.ui.last_selected||-1;this.hover_node(this._get_prev(o));return false;},"ctrl+up":function(){var o=this.data.ui.hovered||this.data.ui.last_selected||-1;this.hover_node(this._get_prev(o));return false;},"shift+up":function(){var o=this.data.ui.hovered||this.data.ui.last_selected||-1;this.hover_node(this._get_prev(o));return false;},"down":function(){var o=this.data.ui.hovered||this.data.ui.last_selected||-1;this.hover_node(this._get_next(o));return false;},"ctrl+down":function(){var o=this.data.ui.hovered||this.data.ui.last_selected||-1;this.hover_node(this._get_next(o));return false;},"shift+down":function(){var o=this.data.ui.hovered||this.data.ui.last_selected||-1;this.hover_node(this._get_next(o));return false;},"left":function(){var o=this.data.ui.hovered||this.data.ui.last_selected;if(o){if(o.hasClass("jstree-open")){this.close_node(o);}
else{this.hover_node(this._get_prev(o));}}
return false;},"ctrl+left":function(){var o=this.data.ui.hovered||this.data.ui.last_selected;if(o){if(o.hasClass("jstree-open")){this.close_node(o);}
else{this.hover_node(this._get_prev(o));}}
return false;},"shift+left":function(){var o=this.data.ui.hovered||this.data.ui.last_selected;if(o){if(o.hasClass("jstree-open")){this.close_node(o);}
else{this.hover_node(this._get_prev(o));}}
return false;},"right":function(){var o=this.data.ui.hovered||this.data.ui.last_selected;if(o&&o.length){if(o.hasClass("jstree-closed")){this.open_node(o);}
else{this.hover_node(this._get_next(o));}}
return false;},"ctrl+right":function(){var o=this.data.ui.hovered||this.data.ui.last_selected;if(o&&o.length){if(o.hasClass("jstree-closed")){this.open_node(o);}
else{this.hover_node(this._get_next(o));}}
return false;},"shift+right":function(){var o=this.data.ui.hovered||this.data.ui.last_selected;if(o&&o.length){if(o.hasClass("jstree-closed")){this.open_node(o);}
else{this.hover_node(this._get_next(o));}}
return false;},"space":function(){if(this.data.ui.hovered){this.data.ui.hovered.children("a:eq(0)").click();}
return false;},"ctrl+space":function(event){event.type="click";if(this.data.ui.hovered){this.data.ui.hovered.children("a:eq(0)").trigger(event);}
return false;},"shift+space":function(event){event.type="click";if(this.data.ui.hovered){this.data.ui.hovered.children("a:eq(0)").trigger(event);}
return false;},"f2":function(){this.rename(this.data.ui.hovered||this.data.ui.last_selected);},"del":function(){this.remove(this.data.ui.hovered||this._get_node(null));}},_fn:{enable_hotkeys:function(){this.data.hotkeys.enabled=true;},disable_hotkeys:function(){this.data.hotkeys.enabled=false;}}});})(jQuery);(function($){$.jstree.plugin("json_data",{__init:function(){var s=this._get_settings().json_data;if(s.progressive_unload){this.get_container().bind("after_close.jstree",function(e,data){data.rslt.obj.children("ul").remove();});}},defaults:{data:false,ajax:false,correct_state:true,progressive_render:false,progressive_unload:false},_fn:{load_node:function(obj,s_call,e_call){var _this=this;this.load_node_json(obj,function(){_this.__callback({"obj":_this._get_node(obj)});s_call.call(this);},e_call);},_is_loaded:function(obj){var s=this._get_settings().json_data;obj=this._get_node(obj);return obj==-1||!obj||(!s.ajax&&!s.progressive_render&&!$.isFunction(s.data))||obj.is(".jstree-open, .jstree-leaf")||obj.children("ul").children("li").length>0;},refresh:function(obj){obj=this._get_node(obj);var s=this._get_settings().json_data;if(obj&&obj!==-1&&s.progressive_unload&&($.isFunction(s.data)||!!s.ajax)){obj.removeData("jstree_children");}
return this.__call_old();},load_node_json:function(obj,s_call,e_call){var s=this.get_settings().json_data,d,error_func=function(){},success_func=function(){};obj=this._get_node(obj);if(obj&&obj!==-1&&(s.progressive_render||s.progressive_unload)&&!obj.is(".jstree-open, .jstree-leaf")&&obj.children("ul").children("li").length===0&&obj.data("jstree_children")){d=this._parse_json(obj.data("jstree_children"),obj);if(d){obj.append(d);if(!s.progressive_unload){obj.removeData("jstree_children");}}
this.clean_node(obj);if(s_call){s_call.call(this);}
return;}
if(obj&&obj!==-1){if(obj.data("jstree_is_loading")){return;}
else{obj.data("jstree_is_loading",true);}}
switch(!0){case(!s.data&&!s.ajax):throw"Neither data nor ajax settings supplied.";case($.isFunction(s.data)):s.data.call(this,obj,$.proxy(function(d){d=this._parse_json(d,obj);if(!d){if(obj===-1||!obj){if(s.correct_state){this.get_container().children("ul").empty();}}
else{obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(s.correct_state){this.correct_state(obj);}}
if(e_call){e_call.call(this);}}
else{if(obj===-1||!obj){this.get_container().children("ul").empty().append(d.children());}
else{obj.append(d).children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");}
this.clean_node(obj);if(s_call){s_call.call(this);}}},this));break;case(!!s.data&&!s.ajax)||(!!s.data&&!!s.ajax&&(!obj||obj===-1)):if(!obj||obj==-1){d=this._parse_json(s.data,obj);if(d){this.get_container().children("ul").empty().append(d.children());this.clean_node();}
else{if(s.correct_state){this.get_container().children("ul").empty();}}}
if(s_call){s_call.call(this);}
break;case(!s.data&&!!s.ajax)||(!!s.data&&!!s.ajax&&obj&&obj!==-1):error_func=function(x,t,e){var ef=this.get_settings().json_data.ajax.error;if(ef){ef.call(this,x,t,e);}
if(obj!=-1&&obj.length){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(t==="success"&&s.correct_state){this.correct_state(obj);}}
else{if(t==="success"&&s.correct_state){this.get_container().children("ul").empty();}}
if(e_call){e_call.call(this);}};success_func=function(d,t,x){var sf=this.get_settings().json_data.ajax.success;if(sf){d=sf.call(this,d,t,x)||d;}
if(d===""||(d&&d.toString&&d.toString().replace(/^[\s\n]+$/,"")==="")||(!$.isArray(d)&&!$.isPlainObject(d))){return error_func.call(this,x,t,"");}
d=this._parse_json(d,obj);if(d){if(obj===-1||!obj){this.get_container().children("ul").empty().append(d.children());}
else{obj.append(d).children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");}
this.clean_node(obj);if(s_call){s_call.call(this);}}
else{if(obj===-1||!obj){if(s.correct_state){this.get_container().children("ul").empty();if(s_call){s_call.call(this);}}}
else{obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(s.correct_state){this.correct_state(obj);if(s_call){s_call.call(this);}}}}};s.ajax.context=this;s.ajax.error=error_func;s.ajax.success=success_func;if(!s.ajax.dataType){s.ajax.dataType="json";}
if($.isFunction(s.ajax.url)){s.ajax.url=s.ajax.url.call(this,obj);}
if($.isFunction(s.ajax.data)){s.ajax.data=s.ajax.data.call(this,obj);}
$.ajax(s.ajax);break;}},_parse_json:function(js,obj,is_callback){var d=false,p=this._get_settings(),s=p.json_data,t=p.core.html_titles,tmp,i,j,ul1,ul2;if(!js){return d;}
if(s.progressive_unload&&obj&&obj!==-1){obj.data("jstree_children",d);}
if($.isArray(js)){d=$();if(!js.length){return false;}
for(i=0,j=js.length;i<j;i++){tmp=this._parse_json(js[i],obj,true);if(tmp.length){d=d.add(tmp);}}}
else{if(typeof js=="string"){js={data:js};}
if(!js.data&&js.data!==""){return d;}
d=$("<li />");if(js.attr){d.attr(js.attr);}
if(js.metadata){d.data(js.metadata);}
if(js.state){d.addClass("jstree-"+js.state);}
if(!$.isArray(js.data)){tmp=js.data;js.data=[];js.data.push(tmp);}
$.each(js.data,function(i,m){tmp=$("<a />");if($.isFunction(m)){m=m.call(this,js);}
if(typeof m=="string"){tmp.attr('href','#')[t?"html":"text"](m);}
else{if(!m.attr){m.attr={};}
if(!m.attr.href){m.attr.href='#';}
tmp.attr(m.attr)[t?"html":"text"](m.title);if(m.language){tmp.addClass(m.language);}}
tmp.prepend("<ins class='jstree-icon'>&#160;</ins>");if(!m.icon&&js.icon){m.icon=js.icon;}
if(m.icon){if(m.icon.indexOf("/")===-1){tmp.children("ins").addClass(m.icon);}
else{tmp.children("ins").css("background","url('"+m.icon+"') center center no-repeat");}}
d.append(tmp);});d.prepend("<ins class='jstree-icon'>&#160;</ins>");if(js.children){if(s.progressive_render&&js.state!=="open"){d.addClass("jstree-closed").data("jstree_children",js.children);}
else{if(s.progressive_unload){d.data("jstree_children",js.children);}
if($.isArray(js.children)&&js.children.length){tmp=this._parse_json(js.children,obj,true);if(tmp.length){ul2=$("<ul />");ul2.append(tmp);d.append(ul2);}}}}}
if(!is_callback){ul1=$("<ul />");ul1.append(d);d=ul1;}
return d;},get_json:function(obj,li_attr,a_attr,is_callback){var result=[],s=this._get_settings(),_this=this,tmp1,tmp2,li,a,t,lang;obj=this._get_node(obj);if(!obj||obj===-1){obj=this.get_container().find("> ul > li");}
li_attr=$.isArray(li_attr)?li_attr:["id","class"];if(!is_callback&&this.data.types){li_attr.push(s.types.type_attr);}
a_attr=$.isArray(a_attr)?a_attr:[];obj.each(function(){li=$(this);tmp1={data:[]};if(li_attr.length){tmp1.attr={};}
$.each(li_attr,function(i,v){tmp2=li.attr(v);if(tmp2&&tmp2.length&&tmp2.replace(/jstree[^ ]*/ig,'').length){tmp1.attr[v]=(" "+tmp2).replace(/ jstree[^ ]*/ig,'').replace(/\s+$/ig," ").replace(/^ /,"").replace(/ $/,"");}});if(li.hasClass("jstree-open")){tmp1.state="open";}
if(li.hasClass("jstree-closed")){tmp1.state="closed";}
if(li.data()){tmp1.metadata=li.data();}
a=li.children("a");a.each(function(){t=$(this);if(a_attr.length||$.inArray("languages",s.plugins)!==-1||t.children("ins").get(0).style.backgroundImage.length||(t.children("ins").get(0).className&&t.children("ins").get(0).className.replace(/jstree[^ ]*|$/ig,'').length)){lang=false;if($.inArray("languages",s.plugins)!==-1&&$.isArray(s.languages)&&s.languages.length){$.each(s.languages,function(l,lv){if(t.hasClass(lv)){lang=lv;return false;}});}
tmp2={attr:{},title:_this.get_text(t,lang)};$.each(a_attr,function(k,z){tmp2.attr[z]=(" "+(t.attr(z)||"")).replace(/ jstree[^ ]*/ig,'').replace(/\s+$/ig," ").replace(/^ /,"").replace(/ $/,"");});if($.inArray("languages",s.plugins)!==-1&&$.isArray(s.languages)&&s.languages.length){$.each(s.languages,function(k,z){if(t.hasClass(z)){tmp2.language=z;return true;}});}
if(t.children("ins").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\s+$/ig,"").length){tmp2.icon=t.children("ins").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\s+$/ig," ").replace(/^ /,"").replace(/ $/,"");}
if(t.children("ins").get(0).style.backgroundImage.length){tmp2.icon=t.children("ins").get(0).style.backgroundImage.replace("url(","").replace(")","");}}
else{tmp2=_this.get_text(t);}
if(a.length>1){tmp1.data.push(tmp2);}
else{tmp1.data=tmp2;}});li=li.find("> ul > li");if(li.length){tmp1.children=_this.get_json(li,li_attr,a_attr,true);}
result.push(tmp1);});return result;}}});})(jQuery);(function($){var sh=false;$.jstree.plugin("languages",{__init:function(){this._load_css();},defaults:[],_fn:{set_lang:function(i){var langs=this._get_settings().languages,st=false,selector=".jstree-"+this.get_index()+' a';if(!$.isArray(langs)||langs.length===0){return false;}
if($.inArray(i,langs)==-1){if(!!langs[i]){i=langs[i];}
else{return false;}}
if(i==this.data.languages.current_language){return true;}
st=$.vakata.css.get_css(selector+"."+this.data.languages.current_language,false,sh);if(st!==false){st.style.display="none";}
st=$.vakata.css.get_css(selector+"."+i,false,sh);if(st!==false){st.style.display="";}
this.data.languages.current_language=i;this.__callback(i);return true;},get_lang:function(){return this.data.languages.current_language;},_get_string:function(key,lang){var langs=this._get_settings().languages,s=this._get_settings().core.strings;if($.isArray(langs)&&langs.length){lang=(lang&&$.inArray(lang,langs)!=-1)?lang:this.data.languages.current_language;}
if(s[lang]&&s[lang][key]){return s[lang][key];}
if(s[key]){return s[key];}
return key;},get_text:function(obj,lang){obj=this._get_node(obj)||this.data.ui.last_selected;if(!obj.size()){return false;}
var langs=this._get_settings().languages,s=this._get_settings().core.html_titles;if($.isArray(langs)&&langs.length){lang=(lang&&$.inArray(lang,langs)!=-1)?lang:this.data.languages.current_language;obj=obj.children("a."+lang);}
else{obj=obj.children("a:eq(0)");}
if(s){obj=obj.clone();obj.children("INS").remove();return obj.html();}
else{obj=obj.contents().filter(function(){return this.nodeType==3;})[0];return obj.nodeValue;}},set_text:function(obj,val,lang){obj=this._get_node(obj)||this.data.ui.last_selected;if(!obj.size()){return false;}
var langs=this._get_settings().languages,s=this._get_settings().core.html_titles,tmp;if($.isArray(langs)&&langs.length){lang=(lang&&$.inArray(lang,langs)!=-1)?lang:this.data.languages.current_language;obj=obj.children("a."+lang);}
else{obj=obj.children("a:eq(0)");}
if(s){tmp=obj.children("INS").clone();obj.html(val).prepend(tmp);this.__callback({"obj":obj,"name":val,"lang":lang});return true;}
else{obj=obj.contents().filter(function(){return this.nodeType==3;})[0];this.__callback({"obj":obj,"name":val,"lang":lang});return(obj.nodeValue=val);}},_load_css:function(){var langs=this._get_settings().languages,str="/* languages css */",selector=".jstree-"+this.get_index()+' a',ln;if($.isArray(langs)&&langs.length){this.data.languages.current_language=langs[0];for(ln=0;ln<langs.length;ln++){str+=selector+"."+langs[ln]+" {";if(langs[ln]!=this.data.languages.current_language){str+=" display:none; ";}
str+=" } ";}
sh=$.vakata.css.add_sheet({'str':str,'title':"jstree-languages"});}},create_node:function(obj,position,js,callback){var t=this.__call_old(true,obj,position,js,function(t){var langs=this._get_settings().languages,a=t.children("a"),ln;if($.isArray(langs)&&langs.length){for(ln=0;ln<langs.length;ln++){if(!a.is("."+langs[ln])){t.append(a.eq(0).clone().removeClass(langs.join(" ")).addClass(langs[ln]));}}
a.not("."+langs.join(", .")).remove();}
if(callback){callback.call(this,t);}});return t;}}});})(jQuery);(function($){$.jstree.plugin("cookies",{__init:function(){if(typeof $.cookie==="undefined"){throw"jsTree cookie: jQuery cookie plugin not included.";}
var s=this._get_settings().cookies,tmp;if(!!s.save_loaded){tmp=$.cookie(s.save_loaded);if(tmp&&tmp.length){this.data.core.to_load=tmp.split(",");}}
if(!!s.save_opened){tmp=$.cookie(s.save_opened);if(tmp&&tmp.length){this.data.core.to_open=tmp.split(",");}}
if(!!s.save_selected){tmp=$.cookie(s.save_selected);if(tmp&&tmp.length&&this.data.ui){this.data.ui.to_select=tmp.split(",");}}
this.get_container().one((this.data.ui?"reselect":"reopen")+".jstree",$.proxy(function(){this.get_container().bind("open_node.jstree close_node.jstree select_node.jstree deselect_node.jstree",$.proxy(function(e){if(this._get_settings().cookies.auto_save){this.save_cookie((e.handleObj.namespace+e.handleObj.type).replace("jstree",""));}},this));},this));},defaults:{save_loaded:"jstree_load",save_opened:"jstree_open",save_selected:"jstree_select",auto_save:true,cookie_options:{}},_fn:{save_cookie:function(c){if(this.data.core.refreshing){return;}
var s=this._get_settings().cookies;if(!c){if(s.save_loaded){this.save_loaded();$.cookie(s.save_loaded,this.data.core.to_load.join(","),s.cookie_options);}
if(s.save_opened){this.save_opened();$.cookie(s.save_opened,this.data.core.to_open.join(","),s.cookie_options);}
if(s.save_selected&&this.data.ui){this.save_selected();$.cookie(s.save_selected,this.data.ui.to_select.join(","),s.cookie_options);}
return;}
switch(c){case"open_node":case"close_node":if(!!s.save_opened){this.save_opened();$.cookie(s.save_opened,this.data.core.to_open.join(","),s.cookie_options);}
if(!!s.save_loaded){this.save_loaded();$.cookie(s.save_loaded,this.data.core.to_load.join(","),s.cookie_options);}
break;case"select_node":case"deselect_node":if(!!s.save_selected&&this.data.ui){this.save_selected();$.cookie(s.save_selected,this.data.ui.to_select.join(","),s.cookie_options);}
break;}}}});})(jQuery);(function($){$.jstree.plugin("sort",{__init:function(){this.get_container().bind("load_node.jstree",$.proxy(function(e,data){var obj=this._get_node(data.rslt.obj);obj=obj===-1?this.get_container().children("ul"):obj.children("ul");this.sort(obj);},this)).bind("rename_node.jstree create_node.jstree create.jstree",$.proxy(function(e,data){this.sort(data.rslt.obj.parent());},this)).bind("move_node.jstree",$.proxy(function(e,data){var m=data.rslt.np==-1?this.get_container():data.rslt.np;this.sort(m.children("ul"));},this));},defaults:function(a,b){return this.get_text(a)>this.get_text(b)?1:-1;},_fn:{sort:function(obj){var s=this._get_settings().sort,t=this;obj.append($.makeArray(obj.children("li")).sort($.proxy(s,t)));obj.find("> li > ul").each(function(){t.sort($(this));});this.clean_node(obj);}}});})(jQuery);(function($){var o=false,r=false,m=false,ml=false,sli=false,sti=false,dir1=false,dir2=false,last_pos=false;$.vakata.dnd={is_down:false,is_drag:false,helper:false,scroll_spd:10,init_x:0,init_y:0,threshold:5,helper_left:5,helper_top:10,user_data:{},drag_start:function(e,data,html){if($.vakata.dnd.is_drag){$.vakata.drag_stop({});}
try{e.currentTarget.unselectable="on";e.currentTarget.onselectstart=function(){return false;};if(e.currentTarget.style){e.currentTarget.style.MozUserSelect="none";}}catch(err){}
$.vakata.dnd.init_x=e.pageX;$.vakata.dnd.init_y=e.pageY;$.vakata.dnd.user_data=data;$.vakata.dnd.is_down=true;$.vakata.dnd.helper=$("<div id='vakata-dragged' />").html(html);$(document).bind("mousemove",$.vakata.dnd.drag);$(document).bind("mouseup",$.vakata.dnd.drag_stop);return false;},drag:function(e){if(!$.vakata.dnd.is_down){return;}
if(!$.vakata.dnd.is_drag){if(Math.abs(e.pageX-$.vakata.dnd.init_x)>5||Math.abs(e.pageY-$.vakata.dnd.init_y)>5){$.vakata.dnd.helper.appendTo("body");$.vakata.dnd.is_drag=true;$(document).triggerHandler("drag_start.vakata",{"event":e,"data":$.vakata.dnd.user_data});}
else{return;}}
if(e.type==="mousemove"){var d=$(document),t=d.scrollTop(),l=d.scrollLeft();if(e.pageY-t<20){if(sti&&dir1==="down"){clearInterval(sti);sti=false;}
if(!sti){dir1="up";sti=setInterval(function(){$(document).scrollTop($(document).scrollTop()-$.vakata.dnd.scroll_spd);},150);}}
else{if(sti&&dir1==="up"){clearInterval(sti);sti=false;}}
if($(window).height()-(e.pageY-t)<20){if(sti&&dir1==="up"){clearInterval(sti);sti=false;}
if(!sti){dir1="down";sti=setInterval(function(){$(document).scrollTop($(document).scrollTop()+$.vakata.dnd.scroll_spd);},150);}}
else{if(sti&&dir1==="down"){clearInterval(sti);sti=false;}}
if(e.pageX-l<20){if(sli&&dir2==="right"){clearInterval(sli);sli=false;}
if(!sli){dir2="left";sli=setInterval(function(){$(document).scrollLeft($(document).scrollLeft()-$.vakata.dnd.scroll_spd);},150);}}
else{if(sli&&dir2==="left"){clearInterval(sli);sli=false;}}
if($(window).width()-(e.pageX-l)<20){if(sli&&dir2==="left"){clearInterval(sli);sli=false;}
if(!sli){dir2="right";sli=setInterval(function(){$(document).scrollLeft($(document).scrollLeft()+$.vakata.dnd.scroll_spd);},150);}}
else{if(sli&&dir2==="right"){clearInterval(sli);sli=false;}}}
$.vakata.dnd.helper.css({left:(e.pageX+$.vakata.dnd.helper_left)+"px",top:(e.pageY+$.vakata.dnd.helper_top)+"px"});$(document).triggerHandler("drag.vakata",{"event":e,"data":$.vakata.dnd.user_data});},drag_stop:function(e){if(sli){clearInterval(sli);}
if(sti){clearInterval(sti);}
$(document).unbind("mousemove",$.vakata.dnd.drag);$(document).unbind("mouseup",$.vakata.dnd.drag_stop);$(document).triggerHandler("drag_stop.vakata",{"event":e,"data":$.vakata.dnd.user_data});$.vakata.dnd.helper.remove();$.vakata.dnd.init_x=0;$.vakata.dnd.init_y=0;$.vakata.dnd.user_data={};$.vakata.dnd.is_down=false;$.vakata.dnd.is_drag=false;}};$(function(){var css_string='#vakata-dragged { display:block; margin:0 0 0 0; padding:4px 4px 4px 24px; position:absolute; top:-2000px; line-height:16px; z-index:10000; } ';$.vakata.css.add_sheet({str:css_string,title:"vakata"});});$.jstree.plugin("dnd",{__init:function(){this.data.dnd={active:false,after:false,inside:false,before:false,off:false,prepared:false,w:0,to1:false,to2:false,cof:false,cw:false,ch:false,i1:false,i2:false,mto:false};this.get_container().bind("mouseenter.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){if(this.data.themes){m.attr("class","jstree-"+this.data.themes.theme);if(ml){ml.attr("class","jstree-"+this.data.themes.theme);}
$.vakata.dnd.helper.attr("class","jstree-dnd-helper jstree-"+this.data.themes.theme);}
if(e.currentTarget===e.target&&$.vakata.dnd.user_data.obj&&$($.vakata.dnd.user_data.obj).length&&$($.vakata.dnd.user_data.obj).parents(".jstree:eq(0)")[0]!==e.target){var tr=$.jstree._reference(e.target),dc;if(tr.data.dnd.foreign){dc=tr._get_settings().dnd.drag_check.call(this,{"o":o,"r":tr.get_container(),is_root:true});if(dc===true||dc.inside===true||dc.before===true||dc.after===true){$.vakata.dnd.helper.children("ins").attr("class","jstree-ok");}}
else{tr.prepare_move(o,tr.get_container(),"last");if(tr.check_move()){$.vakata.dnd.helper.children("ins").attr("class","jstree-ok");}}}}},this)).bind("mouseup.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree&&e.currentTarget===e.target&&$.vakata.dnd.user_data.obj&&$($.vakata.dnd.user_data.obj).length&&$($.vakata.dnd.user_data.obj).parents(".jstree:eq(0)")[0]!==e.target){var tr=$.jstree._reference(e.currentTarget),dc;if(tr.data.dnd.foreign){dc=tr._get_settings().dnd.drag_check.call(this,{"o":o,"r":tr.get_container(),is_root:true});if(dc===true||dc.inside===true||dc.before===true||dc.after===true){tr._get_settings().dnd.drag_finish.call(this,{"o":o,"r":tr.get_container(),is_root:true});}}
else{tr.move_node(o,tr.get_container(),"last",e[tr._get_settings().dnd.copy_modifier+"Key"]);}}},this)).bind("mouseleave.jstree",$.proxy(function(e){if(e.relatedTarget&&e.relatedTarget.id&&e.relatedTarget.id==="jstree-marker-line"){return false;}
if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){if(this.data.dnd.i1){clearInterval(this.data.dnd.i1);}
if(this.data.dnd.i2){clearInterval(this.data.dnd.i2);}
if(this.data.dnd.to1){clearTimeout(this.data.dnd.to1);}
if(this.data.dnd.to2){clearTimeout(this.data.dnd.to2);}
if($.vakata.dnd.helper.children("ins").hasClass("jstree-ok")){$.vakata.dnd.helper.children("ins").attr("class","jstree-invalid");}}},this)).bind("mousemove.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){var cnt=this.get_container()[0];if(e.pageX+24>this.data.dnd.cof.left+this.data.dnd.cw){if(this.data.dnd.i1){clearInterval(this.data.dnd.i1);}
this.data.dnd.i1=setInterval($.proxy(function(){this.scrollLeft+=$.vakata.dnd.scroll_spd;},cnt),100);}
else if(e.pageX-24<this.data.dnd.cof.left){if(this.data.dnd.i1){clearInterval(this.data.dnd.i1);}
this.data.dnd.i1=setInterval($.proxy(function(){this.scrollLeft-=$.vakata.dnd.scroll_spd;},cnt),100);}
else{if(this.data.dnd.i1){clearInterval(this.data.dnd.i1);}}
if(e.pageY+24>this.data.dnd.cof.top+this.data.dnd.ch){if(this.data.dnd.i2){clearInterval(this.data.dnd.i2);}
this.data.dnd.i2=setInterval($.proxy(function(){this.scrollTop+=$.vakata.dnd.scroll_spd;},cnt),100);}
else if(e.pageY-24<this.data.dnd.cof.top){if(this.data.dnd.i2){clearInterval(this.data.dnd.i2);}
this.data.dnd.i2=setInterval($.proxy(function(){this.scrollTop-=$.vakata.dnd.scroll_spd;},cnt),100);}
else{if(this.data.dnd.i2){clearInterval(this.data.dnd.i2);}}}},this)).bind("scroll.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree&&m&&ml){m.hide();ml.hide();}},this)).delegate("a","mousedown.jstree",$.proxy(function(e){if(e.which===1){this.start_drag(e.currentTarget,e);return false;}},this)).delegate("a","mouseenter.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){this.dnd_enter(e.currentTarget);}},this)).delegate("a","mousemove.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){if(!r||!r.length||r.children("a")[0]!==e.currentTarget){this.dnd_enter(e.currentTarget);}
if(typeof this.data.dnd.off.top==="undefined"){this.data.dnd.off=$(e.target).offset();}
this.data.dnd.w=(e.pageY-(this.data.dnd.off.top||0))%this.data.core.li_height;if(this.data.dnd.w<0){this.data.dnd.w+=this.data.core.li_height;}
this.dnd_show();}},this)).delegate("a","mouseleave.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){if(e.relatedTarget&&e.relatedTarget.id&&e.relatedTarget.id==="jstree-marker-line"){return false;}
if(m){m.hide();}
if(ml){ml.hide();}
this.data.dnd.mto=setTimeout((function(t){return function(){t.dnd_leave(e);};})(this),0);}},this)).delegate("a","mouseup.jstree",$.proxy(function(e){if($.vakata.dnd.is_drag&&$.vakata.dnd.user_data.jstree){this.dnd_finish(e);}},this));$(document).bind("drag_stop.vakata",$.proxy(function(){if(this.data.dnd.to1){clearTimeout(this.data.dnd.to1);}
if(this.data.dnd.to2){clearTimeout(this.data.dnd.to2);}
if(this.data.dnd.i1){clearInterval(this.data.dnd.i1);}
if(this.data.dnd.i2){clearInterval(this.data.dnd.i2);}
this.data.dnd.after=false;this.data.dnd.before=false;this.data.dnd.inside=false;this.data.dnd.off=false;this.data.dnd.prepared=false;this.data.dnd.w=false;this.data.dnd.to1=false;this.data.dnd.to2=false;this.data.dnd.i1=false;this.data.dnd.i2=false;this.data.dnd.active=false;this.data.dnd.foreign=false;if(m){m.css({"top":"-2000px"});}
if(ml){ml.css({"top":"-2000px"});}},this)).bind("drag_start.vakata",$.proxy(function(e,data){if(data.data.jstree){var et=$(data.event.target);if(et.closest(".jstree").hasClass("jstree-"+this.get_index())){this.dnd_enter(et);}}},this));var s=this._get_settings().dnd;if(s.drag_target){$(document).delegate(s.drag_target,"mousedown.jstree-"+this.get_index(),$.proxy(function(e){o=e.target;$.vakata.dnd.drag_start(e,{jstree:true,obj:e.target},"<ins class='jstree-icon'></ins>"+$(e.target).text());if(this.data.themes){if(m){m.attr("class","jstree-"+this.data.themes.theme);}
if(ml){ml.attr("class","jstree-"+this.data.themes.theme);}
$.vakata.dnd.helper.attr("class","jstree-dnd-helper jstree-"+this.data.themes.theme);}
$.vakata.dnd.helper.children("ins").attr("class","jstree-invalid");var cnt=this.get_container();this.data.dnd.cof=cnt.offset();this.data.dnd.cw=parseInt(cnt.width(),10);this.data.dnd.ch=parseInt(cnt.height(),10);this.data.dnd.foreign=true;e.preventDefault();},this));}
if(s.drop_target){$(document).delegate(s.drop_target,"mouseenter.jstree-"+this.get_index(),$.proxy(function(e){if(this.data.dnd.active&&this._get_settings().dnd.drop_check.call(this,{"o":o,"r":$(e.target),"e":e})){$.vakata.dnd.helper.children("ins").attr("class","jstree-ok");}},this)).delegate(s.drop_target,"mouseleave.jstree-"+this.get_index(),$.proxy(function(e){if(this.data.dnd.active){$.vakata.dnd.helper.children("ins").attr("class","jstree-invalid");}},this)).delegate(s.drop_target,"mouseup.jstree-"+this.get_index(),$.proxy(function(e){if(this.data.dnd.active&&$.vakata.dnd.helper.children("ins").hasClass("jstree-ok")){this._get_settings().dnd.drop_finish.call(this,{"o":o,"r":$(e.target),"e":e});}},this));}},defaults:{copy_modifier:"ctrl",check_timeout:100,open_timeout:500,drop_target:".jstree-drop",drop_check:function(data){return true;},drop_finish:$.noop,drag_target:".jstree-draggable",drag_finish:$.noop,drag_check:function(data){return{after:false,before:false,inside:true};}},__destroy:function(){if($('.jstree').length<=1){$(document).unbind("drag_start.vakata").unbind("drag_stop.vakata");}
o=false;},_fn:{dnd_prepare:function(){if(!r||!r.length){return;}
this.data.dnd.off=r.offset();if(this._get_settings().core.rtl){this.data.dnd.off.right=this.data.dnd.off.left+r.width();}
if(this.data.dnd.foreign){var a=this._get_settings().dnd.drag_check.call(this,{"o":o,"r":r});this.data.dnd.after=a.after;this.data.dnd.before=a.before;this.data.dnd.inside=a.inside;this.data.dnd.prepared=true;return this.dnd_show();}
this.prepare_move(o,r,"before");this.data.dnd.before=this.check_move();this.prepare_move(o,r,"after");this.data.dnd.after=this.check_move();if(this._is_loaded(r)){this.prepare_move(o,r,"inside");this.data.dnd.inside=this.check_move();}
else{this.data.dnd.inside=false;}
this.data.dnd.prepared=true;return this.dnd_show();},dnd_show:function(){if(!this.data.dnd.prepared){return;}
var o=["before","inside","after"],r=false,rtl=this._get_settings().core.rtl,pos;if(this.data.dnd.w<this.data.core.li_height/3){o=["before","inside","after"];}
else if(this.data.dnd.w<=this.data.core.li_height*2/3){o=this.data.dnd.w<this.data.core.li_height/2?["inside","before","after"]:["inside","after","before"];}
else{o=["after","inside","before"];}
$.each(o,$.proxy(function(i,val){if(this.data.dnd[val]){$.vakata.dnd.helper.children("ins").attr("class","jstree-ok");r=val;return false;}},this));if(r===false){$.vakata.dnd.helper.children("ins").attr("class","jstree-invalid");}
pos=rtl?(this.data.dnd.off.right-18):(this.data.dnd.off.left+10);switch(r){case"before":m.css({"left":pos+"px","top":(this.data.dnd.off.top-6)+"px"}).show();if(ml){ml.css({"left":(pos+8)+"px","top":(this.data.dnd.off.top-1)+"px"}).show();}
break;case"after":m.css({"left":pos+"px","top":(this.data.dnd.off.top+this.data.core.li_height-6)+"px"}).show();if(ml){ml.css({"left":(pos+8)+"px","top":(this.data.dnd.off.top+this.data.core.li_height-1)+"px"}).show();}
break;case"inside":m.css({"left":pos+(rtl?-4:4)+"px","top":(this.data.dnd.off.top+this.data.core.li_height/2-5)+"px"}).show();if(ml){ml.hide();}
break;default:m.hide();if(ml){ml.hide();}
break;}
last_pos=r;return r;},dnd_open:function(){this.data.dnd.to2=false;this.open_node(r,$.proxy(this.dnd_prepare,this),true);},dnd_finish:function(e){if(this.data.dnd.foreign){if(this.data.dnd.after||this.data.dnd.before||this.data.dnd.inside){this._get_settings().dnd.drag_finish.call(this,{"o":o,"r":r,"p":last_pos});}}
else{this.dnd_prepare();this.move_node(o,r,last_pos,e[this._get_settings().dnd.copy_modifier+"Key"]);}
o=false;r=false;m.hide();if(ml){ml.hide();}},dnd_enter:function(obj){if(this.data.dnd.mto){clearTimeout(this.data.dnd.mto);this.data.dnd.mto=false;}
var s=this._get_settings().dnd;this.data.dnd.prepared=false;r=this._get_node(obj);if(s.check_timeout){if(this.data.dnd.to1){clearTimeout(this.data.dnd.to1);}
this.data.dnd.to1=setTimeout($.proxy(this.dnd_prepare,this),s.check_timeout);}
else{this.dnd_prepare();}
if(s.open_timeout){if(this.data.dnd.to2){clearTimeout(this.data.dnd.to2);}
if(r&&r.length&&r.hasClass("jstree-closed")){this.data.dnd.to2=setTimeout($.proxy(this.dnd_open,this),s.open_timeout);}}
else{if(r&&r.length&&r.hasClass("jstree-closed")){this.dnd_open();}}},dnd_leave:function(e){this.data.dnd.after=false;this.data.dnd.before=false;this.data.dnd.inside=false;$.vakata.dnd.helper.children("ins").attr("class","jstree-invalid");m.hide();if(ml){ml.hide();}
if(r&&r[0]===e.target.parentNode){if(this.data.dnd.to1){clearTimeout(this.data.dnd.to1);this.data.dnd.to1=false;}
if(this.data.dnd.to2){clearTimeout(this.data.dnd.to2);this.data.dnd.to2=false;}}},start_drag:function(obj,e){o=this._get_node(obj);if(this.data.ui&&this.is_selected(o)){o=this._get_node(null,true);}
var dt=o.length>1?this._get_string("multiple_selection"):this.get_text(o),cnt=this.get_container();if(!this._get_settings().core.html_titles){dt=dt.replace(/</ig,"&lt;").replace(/>/ig,"&gt;");}
$.vakata.dnd.drag_start(e,{jstree:true,obj:o},"<ins class='jstree-icon'></ins>"+dt);if(this.data.themes){if(m){m.attr("class","jstree-"+this.data.themes.theme);}
if(ml){ml.attr("class","jstree-"+this.data.themes.theme);}
$.vakata.dnd.helper.attr("class","jstree-dnd-helper jstree-"+this.data.themes.theme);}
this.data.dnd.cof=cnt.offset();this.data.dnd.cw=parseInt(cnt.width(),10);this.data.dnd.ch=parseInt(cnt.height(),10);this.data.dnd.active=true;}}});$(function(){var css_string=''+'#vakata-dragged ins { display:block; text-decoration:none; width:16px; height:16px; margin:0 0 0 0; padding:0; position:absolute; top:4px; left:4px; '+' -moz-border-radius:4px; border-radius:4px; -webkit-border-radius:4px; '+'} '+'#vakata-dragged .jstree-ok { background:green; } '+'#vakata-dragged .jstree-invalid { background:red; } '+'#jstree-marker { padding:0; margin:0; font-size:12px; overflow:hidden; height:12px; width:8px; position:absolute; top:-30px; z-index:10001; background-repeat:no-repeat; display:none; background-color:transparent; text-shadow:1px 1px 1px white; color:black; line-height:10px; } '+'#jstree-marker-line { padding:0; margin:0; line-height:0%; font-size:1px; overflow:hidden; height:1px; width:100px; position:absolute; top:-30px; z-index:10000; background-repeat:no-repeat; display:none; background-color:#456c43; '+' cursor:pointer; border:1px solid #eeeeee; border-left:0; -moz-box-shadow: 0px 0px 2px #666; -webkit-box-shadow: 0px 0px 2px #666; box-shadow: 0px 0px 2px #666; '+' -moz-border-radius:1px; border-radius:1px; -webkit-border-radius:1px; '+'}'+'';$.vakata.css.add_sheet({str:css_string,title:"jstree"});m=$("<div />").attr({id:"jstree-marker"}).hide().html("&raquo;").bind("mouseleave mouseenter",function(e){m.hide();ml.hide();e.preventDefault();e.stopImmediatePropagation();return false;}).appendTo("body");ml=$("<div />").attr({id:"jstree-marker-line"}).hide().bind("mouseup",function(e){if(r&&r.length){r.children("a").trigger(e);e.preventDefault();e.stopImmediatePropagation();return false;}}).bind("mouseleave",function(e){var rt=$(e.relatedTarget);if(rt.is(".jstree")||rt.closest(".jstree").length===0){if(r&&r.length){r.children("a").trigger(e);m.hide();ml.hide();e.preventDefault();e.stopImmediatePropagation();return false;}}}).appendTo("body");$(document).bind("drag_start.vakata",function(e,data){if(data.data.jstree){m.show();if(ml){ml.show();}}});$(document).bind("drag_stop.vakata",function(e,data){if(data.data.jstree){m.hide();if(ml){ml.hide();}}});});})(jQuery);(function($){$.jstree.plugin("checkbox",{__init:function(){this.data.checkbox.noui=this._get_settings().checkbox.override_ui;if(this.data.ui&&this.data.checkbox.noui){this.select_node=this.deselect_node=this.deselect_all=$.noop;this.get_selected=this.get_checked;}
this.get_container().bind("open_node.jstree create_node.jstree clean_node.jstree refresh.jstree",$.proxy(function(e,data){this._prepare_checkboxes(data.rslt.obj);},this)).bind("loaded.jstree",$.proxy(function(e){this._prepare_checkboxes();},this)).delegate((this.data.ui&&this.data.checkbox.noui?"a":"ins.jstree-checkbox"),"click.jstree",$.proxy(function(e){e.preventDefault();if(this._get_node(e.target).hasClass("jstree-checked")){this.uncheck_node(e.target);}
else{this.check_node(e.target);}
if(this.data.ui&&this.data.checkbox.noui){this.save_selected();if(this.data.cookies){this.save_cookie("select_node");}}
else{e.stopImmediatePropagation();return false;}},this));},defaults:{override_ui:false,two_state:false,real_checkboxes:false,checked_parent_open:true,real_checkboxes_names:function(n){return[("check_"+(n[0].id||Math.ceil(Math.random()*10000))),1];}},__destroy:function(){this.get_container().find("input.jstree-real-checkbox").removeClass("jstree-real-checkbox").end().find("ins.jstree-checkbox").remove();},_fn:{_checkbox_notify:function(n,data){if(data.checked){this.check_node(n,false);}},_prepare_checkboxes:function(obj){obj=!obj||obj==-1?this.get_container().find("> ul > li"):this._get_node(obj);if(obj===false){return;}
var c,_this=this,t,ts=this._get_settings().checkbox.two_state,rc=this._get_settings().checkbox.real_checkboxes,rcn=this._get_settings().checkbox.real_checkboxes_names;obj.each(function(){t=$(this);c=t.is("li")&&(t.hasClass("jstree-checked")||(rc&&t.children(":checked").length))?"jstree-checked":"jstree-unchecked";t.find("li").andSelf().each(function(){var $t=$(this),nm;$t.children("a"+(_this.data.languages?"":":eq(0)")).not(":has(.jstree-checkbox)").prepend("<ins class='jstree-checkbox'>&#160;</ins>").parent().not(".jstree-checked, .jstree-unchecked").addClass(ts?"jstree-unchecked":c);if(rc){if(!$t.children(":checkbox").length){nm=rcn.call(_this,$t);$t.prepend("<input type='checkbox' class='jstree-real-checkbox' id='"+nm[0]+"' name='"+nm[0]+"' value='"+nm[1]+"' />");}
else{$t.children(":checkbox").addClass("jstree-real-checkbox");}}
if(!ts){if(c==="jstree-checked"||$t.hasClass("jstree-checked")||$t.children(':checked').length){$t.find("li").andSelf().addClass("jstree-checked").children(":checkbox").prop("checked",true);}}
else{if($t.hasClass("jstree-checked")||$t.children(':checked').length){$t.addClass("jstree-checked").children(":checkbox").prop("checked",true);}}});});if(!ts){obj.find(".jstree-checked").parent().parent().each(function(){_this._repair_state(this);});}},change_state:function(obj,state){obj=this._get_node(obj);var coll=false,rc=this._get_settings().checkbox.real_checkboxes;if(!obj||obj===-1){return false;}
state=(state===false||state===true)?state:obj.hasClass("jstree-checked");if(this._get_settings().checkbox.two_state){if(state){obj.removeClass("jstree-checked").addClass("jstree-unchecked");if(rc){obj.children(":checkbox").prop("checked",false);}}
else{obj.removeClass("jstree-unchecked").addClass("jstree-checked");if(rc){obj.children(":checkbox").prop("checked",true);}}}
else{if(state){coll=obj.find("li").andSelf();if(!coll.filter(".jstree-checked, .jstree-undetermined").length){return false;}
coll.removeClass("jstree-checked jstree-undetermined").addClass("jstree-unchecked");if(rc){coll.children(":checkbox").prop("checked",false);}}
else{coll=obj.find("li").andSelf();if(!coll.filter(".jstree-unchecked, .jstree-undetermined").length){return false;}
coll.removeClass("jstree-unchecked jstree-undetermined").addClass("jstree-checked");if(rc){coll.children(":checkbox").prop("checked",true);}
if(this.data.ui){this.data.ui.last_selected=obj;}
this.data.checkbox.last_selected=obj;}
obj.parentsUntil(".jstree","li").each(function(){var $this=$(this);if(state){if($this.children("ul").children("li.jstree-checked, li.jstree-undetermined").length){$this.parentsUntil(".jstree","li").andSelf().removeClass("jstree-checked jstree-unchecked").addClass("jstree-undetermined");if(rc){$this.parentsUntil(".jstree","li").andSelf().children(":checkbox").prop("checked",false);}
return false;}
else{$this.removeClass("jstree-checked jstree-undetermined").addClass("jstree-unchecked");if(rc){$this.children(":checkbox").prop("checked",false);}}}
else{if($this.children("ul").children("li.jstree-unchecked, li.jstree-undetermined").length){$this.parentsUntil(".jstree","li").andSelf().removeClass("jstree-checked jstree-unchecked").addClass("jstree-undetermined");if(rc){$this.parentsUntil(".jstree","li").andSelf().children(":checkbox").prop("checked",false);}
return false;}
else{$this.removeClass("jstree-unchecked jstree-undetermined").addClass("jstree-checked");if(rc){$this.children(":checkbox").prop("checked",true);}}}});}
if(this.data.ui&&this.data.checkbox.noui){this.data.ui.selected=this.get_checked();}
this.__callback(obj);return true;},check_node:function(obj){if(this.change_state(obj,false)){obj=this._get_node(obj);if(this._get_settings().checkbox.checked_parent_open){var t=this;obj.parents(".jstree-closed").each(function(){t.open_node(this,false,true);});}
this.__callback({"obj":obj});}},uncheck_node:function(obj){if(this.change_state(obj,true)){this.__callback({"obj":this._get_node(obj)});}},check_all:function(){var _this=this,coll=this._get_settings().checkbox.two_state?this.get_container_ul().find("li"):this.get_container_ul().children("li");coll.each(function(){_this.change_state(this,false);});this.__callback();},uncheck_all:function(){var _this=this,coll=this._get_settings().checkbox.two_state?this.get_container_ul().find("li"):this.get_container_ul().children("li");coll.each(function(){_this.change_state(this,true);});this.__callback();},is_checked:function(obj){obj=this._get_node(obj);return obj.length?obj.is(".jstree-checked"):false;},get_checked:function(obj,get_all){obj=!obj||obj===-1?this.get_container():this._get_node(obj);return get_all||this._get_settings().checkbox.two_state?obj.find(".jstree-checked"):obj.find("> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked");},get_unchecked:function(obj,get_all){obj=!obj||obj===-1?this.get_container():this._get_node(obj);return get_all||this._get_settings().checkbox.two_state?obj.find(".jstree-unchecked"):obj.find("> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked");},show_checkboxes:function(){this.get_container().children("ul").removeClass("jstree-no-checkboxes");},hide_checkboxes:function(){this.get_container().children("ul").addClass("jstree-no-checkboxes");},_repair_state:function(obj){obj=this._get_node(obj);if(!obj.length){return;}
if(this._get_settings().checkbox.two_state){obj.find('li').andSelf().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked',true);return;}
var rc=this._get_settings().checkbox.real_checkboxes,a=obj.find("> ul > .jstree-checked").length,b=obj.find("> ul > .jstree-undetermined").length,c=obj.find("> ul > li").length;if(c===0){if(obj.hasClass("jstree-undetermined")){this.change_state(obj,false);}}
else if(a===0&&b===0){this.change_state(obj,true);}
else if(a===c){this.change_state(obj,false);}
else{obj.parentsUntil(".jstree","li").andSelf().removeClass("jstree-checked jstree-unchecked").addClass("jstree-undetermined");if(rc){obj.parentsUntil(".jstree","li").andSelf().children(":checkbox").prop("checked",false);}}},reselect:function(){if(this.data.ui&&this.data.checkbox.noui){var _this=this,s=this.data.ui.to_select;s=$.map($.makeArray(s),function(n){return"#"+n.toString().replace(/^#/,"").replace(/\\\//g,"/").replace(/\//g,"\\\/").replace(/\\\./g,".").replace(/\./g,"\\.").replace(/\:/g,"\\:");});this.deselect_all();$.each(s,function(i,val){_this.check_node(val);});this.__callback();}
else{this.__call_old();}},save_loaded:function(){var _this=this;this.data.core.to_load=[];this.get_container_ul().find("li.jstree-closed.jstree-undetermined").each(function(){if(this.id){_this.data.core.to_load.push("#"+this.id);}});}}});$(function(){var css_string='.jstree .jstree-real-checkbox { display:none; } ';$.vakata.css.add_sheet({str:css_string,title:"jstree"});});})(jQuery);(function($){$.vakata.xslt=function(xml,xsl,callback){var rs="",xm,xs,processor,support;if(document.recalc){xm=document.createElement('xml');xs=document.createElement('xml');xm.innerHTML=xml;xs.innerHTML=xsl;$("body").append(xm).append(xs);setTimeout((function(xm,xs,callback){return function(){callback.call(null,xm.transformNode(xs.XMLDocument));setTimeout((function(xm,xs){return function(){$(xm).remove();$(xs).remove();};})(xm,xs),200);};})(xm,xs,callback),100);return true;}
if(typeof window.DOMParser!=="undefined"&&typeof window.XMLHttpRequest!=="undefined"&&typeof window.XSLTProcessor==="undefined"){xml=new DOMParser().parseFromString(xml,"text/xml");xsl=new DOMParser().parseFromString(xsl,"text/xml");}
if(typeof window.DOMParser!=="undefined"&&typeof window.XMLHttpRequest!=="undefined"&&typeof window.XSLTProcessor!=="undefined"){processor=new XSLTProcessor();support=$.isFunction(processor.transformDocument)?(typeof window.XMLSerializer!=="undefined"):true;if(!support){return false;}
xml=new DOMParser().parseFromString(xml,"text/xml");xsl=new DOMParser().parseFromString(xsl,"text/xml");if($.isFunction(processor.transformDocument)){rs=document.implementation.createDocument("","",null);processor.transformDocument(xml,xsl,rs,null);callback.call(null,new XMLSerializer().serializeToString(rs));return true;}
else{processor.importStylesheet(xsl);rs=processor.transformToFragment(xml,document);callback.call(null,$("<div />").append(rs).html());return true;}}
return false;};var xsl={'nest':'<'+'?xml version="1.0" encoding="utf-8" ?>'+'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >'+'<xsl:output method="html" encoding="utf-8" omit-xml-declaration="yes" standalone="no" indent="no" media-type="text/html" />'+'<xsl:template match="/">'+' <xsl:call-template name="nodes">'+'  <xsl:with-param name="node" select="/root" />'+' </xsl:call-template>'+'</xsl:template>'+'<xsl:template name="nodes">'+' <xsl:param name="node" />'+' <ul>'+' <xsl:for-each select="$node/item">'+'  <xsl:variable name="children" select="count(./item) &gt; 0" />'+'  <li>'+'   <xsl:attribute name="class">'+'    <xsl:if test="position() = last()">jstree-last </xsl:if>'+'    <xsl:choose>'+'     <xsl:when test="@state = \'open\'">jstree-open </xsl:when>'+'     <xsl:when test="$children or @hasChildren or @state = \'closed\'">jstree-closed </xsl:when>'+'     <xsl:otherwise>jstree-leaf </xsl:otherwise>'+'    </xsl:choose>'+'    <xsl:value-of select="@class" />'+'   </xsl:attribute>'+'   <xsl:for-each select="@*">'+'    <xsl:if test="name() != \'class\' and name() != \'state\' and name() != \'hasChildren\'">'+'     <xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>'+'    </xsl:if>'+'   </xsl:for-each>'+' <ins class="jstree-icon"><xsl:text>&#xa0;</xsl:text></ins>'+'   <xsl:for-each select="content/name">'+'    <a>'+'    <xsl:attribute name="href">'+'     <xsl:choose>'+'     <xsl:when test="@href"><xsl:value-of select="@href" /></xsl:when>'+'     <xsl:otherwise>#</xsl:otherwise>'+'     </xsl:choose>'+'    </xsl:attribute>'+'    <xsl:attribute name="class"><xsl:value-of select="@lang" /> <xsl:value-of select="@class" /></xsl:attribute>'+'    <xsl:attribute name="style"><xsl:value-of select="@style" /></xsl:attribute>'+'    <xsl:for-each select="@*">'+'     <xsl:if test="name() != \'style\' and name() != \'class\' and name() != \'href\'">'+'      <xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>'+'     </xsl:if>'+'    </xsl:for-each>'+'     <ins>'+'      <xsl:attribute name="class">jstree-icon '+'       <xsl:if test="string-length(attribute::icon) > 0 and not(contains(@icon,\'/\'))"><xsl:value-of select="@icon" /></xsl:if>'+'      </xsl:attribute>'+'      <xsl:if test="string-length(attribute::icon) > 0 and contains(@icon,\'/\')"><xsl:attribute name="style">background:url(<xsl:value-of select="@icon" />) center center no-repeat;</xsl:attribute></xsl:if>'+'      <xsl:text>&#xa0;</xsl:text>'+'     </ins>'+'     <xsl:copy-of select="./child::node()" />'+'    </a>'+'   </xsl:for-each>'+'   <xsl:if test="$children or @hasChildren"><xsl:call-template name="nodes"><xsl:with-param name="node" select="current()" /></xsl:call-template></xsl:if>'+'  </li>'+' </xsl:for-each>'+' </ul>'+'</xsl:template>'+'</xsl:stylesheet>','flat':'<'+'?xml version="1.0" encoding="utf-8" ?>'+'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >'+'<xsl:output method="html" encoding="utf-8" omit-xml-declaration="yes" standalone="no" indent="no" media-type="text/xml" />'+'<xsl:template match="/">'+' <ul>'+' <xsl:for-each select="//item[not(@parent_id) or @parent_id=0 or not(@parent_id = //item/@id)]">'+'  <xsl:call-template name="nodes">'+'   <xsl:with-param name="node" select="." />'+'   <xsl:with-param name="is_last" select="number(position() = last())" />'+'  </xsl:call-template>'+' </xsl:for-each>'+' </ul>'+'</xsl:template>'+'<xsl:template name="nodes">'+' <xsl:param name="node" />'+' <xsl:param name="is_last" />'+' <xsl:variable name="children" select="count(//item[@parent_id=$node/attribute::id]) &gt; 0" />'+' <li>'+' <xsl:attribute name="class">'+'  <xsl:if test="$is_last = true()">jstree-last </xsl:if>'+'  <xsl:choose>'+'   <xsl:when test="@state = \'open\'">jstree-open </xsl:when>'+'   <xsl:when test="$children or @hasChildren or @state = \'closed\'">jstree-closed </xsl:when>'+'   <xsl:otherwise>jstree-leaf </xsl:otherwise>'+'  </xsl:choose>'+'  <xsl:value-of select="@class" />'+' </xsl:attribute>'+' <xsl:for-each select="@*">'+'  <xsl:if test="name() != \'parent_id\' and name() != \'hasChildren\' and name() != \'class\' and name() != \'state\'">'+'  <xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>'+'  </xsl:if>'+' </xsl:for-each>'+' <ins class="jstree-icon"><xsl:text>&#xa0;</xsl:text></ins>'+' <xsl:for-each select="content/name">'+'  <a>'+'  <xsl:attribute name="href">'+'   <xsl:choose>'+'   <xsl:when test="@href"><xsl:value-of select="@href" /></xsl:when>'+'   <xsl:otherwise>#</xsl:otherwise>'+'   </xsl:choose>'+'  </xsl:attribute>'+'  <xsl:attribute name="class"><xsl:value-of select="@lang" /> <xsl:value-of select="@class" /></xsl:attribute>'+'  <xsl:attribute name="style"><xsl:value-of select="@style" /></xsl:attribute>'+'  <xsl:for-each select="@*">'+'   <xsl:if test="name() != \'style\' and name() != \'class\' and name() != \'href\'">'+'    <xsl:attribute name="{name()}"><xsl:value-of select="." /></xsl:attribute>'+'   </xsl:if>'+'  </xsl:for-each>'+'   <ins>'+'    <xsl:attribute name="class">jstree-icon '+'     <xsl:if test="string-length(attribute::icon) > 0 and not(contains(@icon,\'/\'))"><xsl:value-of select="@icon" /></xsl:if>'+'    </xsl:attribute>'+'    <xsl:if test="string-length(attribute::icon) > 0 and contains(@icon,\'/\')"><xsl:attribute name="style">background:url(<xsl:value-of select="@icon" />) center center no-repeat;</xsl:attribute></xsl:if>'+'    <xsl:text>&#xa0;</xsl:text>'+'   </ins>'+'   <xsl:copy-of select="./child::node()" />'+'  </a>'+' </xsl:for-each>'+' <xsl:if test="$children">'+'  <ul>'+'  <xsl:for-each select="//item[@parent_id=$node/attribute::id]">'+'   <xsl:call-template name="nodes">'+'    <xsl:with-param name="node" select="." />'+'    <xsl:with-param name="is_last" select="number(position() = last())" />'+'   </xsl:call-template>'+'  </xsl:for-each>'+'  </ul>'+' </xsl:if>'+' </li>'+'</xsl:template>'+'</xsl:stylesheet>'},escape_xml=function(string){return string.toString().replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&apos;');};$.jstree.plugin("xml_data",{defaults:{data:false,ajax:false,xsl:"flat",clean_node:false,correct_state:true,get_skip_empty:false,get_include_preamble:true},_fn:{load_node:function(obj,s_call,e_call){var _this=this;this.load_node_xml(obj,function(){_this.__callback({"obj":_this._get_node(obj)});s_call.call(this);},e_call);},_is_loaded:function(obj){var s=this._get_settings().xml_data;obj=this._get_node(obj);return obj==-1||!obj||(!s.ajax&&!$.isFunction(s.data))||obj.is(".jstree-open, .jstree-leaf")||obj.children("ul").children("li").size()>0;},load_node_xml:function(obj,s_call,e_call){var s=this.get_settings().xml_data,error_func=function(){},success_func=function(){};obj=this._get_node(obj);if(obj&&obj!==-1){if(obj.data("jstree_is_loading")){return;}
else{obj.data("jstree_is_loading",true);}}
switch(!0){case(!s.data&&!s.ajax):throw"Neither data nor ajax settings supplied.";case($.isFunction(s.data)):s.data.call(this,obj,$.proxy(function(d){this.parse_xml(d,$.proxy(function(d){if(d){d=d.replace(/ ?xmlns="[^"]*"/ig,"");if(d.length>10){d=$(d);if(obj===-1||!obj){this.get_container().children("ul").empty().append(d.children());}
else{obj.children("a.jstree-loading").removeClass("jstree-loading");obj.append(d);obj.removeData("jstree_is_loading");}
if(s.clean_node){this.clean_node(obj);}
if(s_call){s_call.call(this);}}
else{if(obj&&obj!==-1){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(s.correct_state){this.correct_state(obj);if(s_call){s_call.call(this);}}}
else{if(s.correct_state){this.get_container().children("ul").empty();if(s_call){s_call.call(this);}}}}}},this));},this));break;case(!!s.data&&!s.ajax)||(!!s.data&&!!s.ajax&&(!obj||obj===-1)):if(!obj||obj==-1){this.parse_xml(s.data,$.proxy(function(d){if(d){d=d.replace(/ ?xmlns="[^"]*"/ig,"");if(d.length>10){d=$(d);this.get_container().children("ul").empty().append(d.children());if(s.clean_node){this.clean_node(obj);}
if(s_call){s_call.call(this);}}}
else{if(s.correct_state){this.get_container().children("ul").empty();if(s_call){s_call.call(this);}}}},this));}
break;case(!s.data&&!!s.ajax)||(!!s.data&&!!s.ajax&&obj&&obj!==-1):error_func=function(x,t,e){var ef=this.get_settings().xml_data.ajax.error;if(ef){ef.call(this,x,t,e);}
if(obj!==-1&&obj.length){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(t==="success"&&s.correct_state){this.correct_state(obj);}}
else{if(t==="success"&&s.correct_state){this.get_container().children("ul").empty();}}
if(e_call){e_call.call(this);}};success_func=function(d,t,x){d=x.responseText;var sf=this.get_settings().xml_data.ajax.success;if(sf){d=sf.call(this,d,t,x)||d;}
if(d===""||(d&&d.toString&&d.toString().replace(/^[\s\n]+$/,"")==="")){return error_func.call(this,x,t,"");}
this.parse_xml(d,$.proxy(function(d){if(d){d=d.replace(/ ?xmlns="[^"]*"/ig,"");if(d.length>10){d=$(d);if(obj===-1||!obj){this.get_container().children("ul").empty().append(d.children());}
else{obj.children("a.jstree-loading").removeClass("jstree-loading");obj.append(d);obj.removeData("jstree_is_loading");}
if(s.clean_node){this.clean_node(obj);}
if(s_call){s_call.call(this);}}
else{if(obj&&obj!==-1){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(s.correct_state){this.correct_state(obj);if(s_call){s_call.call(this);}}}
else{if(s.correct_state){this.get_container().children("ul").empty();if(s_call){s_call.call(this);}}}}}},this));};s.ajax.context=this;s.ajax.error=error_func;s.ajax.success=success_func;if(!s.ajax.dataType){s.ajax.dataType="xml";}
if($.isFunction(s.ajax.url)){s.ajax.url=s.ajax.url.call(this,obj);}
if($.isFunction(s.ajax.data)){s.ajax.data=s.ajax.data.call(this,obj);}
$.ajax(s.ajax);break;}},parse_xml:function(xml,callback){var s=this._get_settings().xml_data;$.vakata.xslt(xml,xsl[s.xsl],callback);},get_xml:function(tp,obj,li_attr,a_attr,is_callback){var result="",s=this._get_settings(),_this=this,tmp1,tmp2,li,a,lang;if(!tp){tp="flat";}
if(!is_callback){is_callback=0;}
obj=this._get_node(obj);if(!obj||obj===-1){obj=this.get_container().find("> ul > li");}
li_attr=$.isArray(li_attr)?li_attr:["id","class"];if(!is_callback&&this.data.types&&$.inArray(s.types.type_attr,li_attr)===-1){li_attr.push(s.types.type_attr);}
a_attr=$.isArray(a_attr)?a_attr:[];if(!is_callback){if(s.xml_data.get_include_preamble){result+='<'+'?xml version="1.0" encoding="UTF-8"?'+'>';}
result+="<root>";}
obj.each(function(){result+="<item";li=$(this);$.each(li_attr,function(i,v){var t=li.attr(v);if(!s.xml_data.get_skip_empty||typeof t!=="undefined"){result+=" "+v+"=\""+escape_xml((" "+(t||"")).replace(/ jstree[^ ]*/ig,'').replace(/\s+$/ig," ").replace(/^ /,"").replace(/ $/,""))+"\"";}});if(li.hasClass("jstree-open")){result+=" state=\"open\"";}
if(li.hasClass("jstree-closed")){result+=" state=\"closed\"";}
if(tp==="flat"){result+=" parent_id=\""+escape_xml(is_callback)+"\"";}
result+=">";result+="<content>";a=li.children("a");a.each(function(){tmp1=$(this);lang=false;result+="<name";if($.inArray("languages",s.plugins)!==-1){$.each(s.languages,function(k,z){if(tmp1.hasClass(z)){result+=" lang=\""+escape_xml(z)+"\"";lang=z;return false;}});}
if(a_attr.length){$.each(a_attr,function(k,z){var t=tmp1.attr(z);if(!s.xml_data.get_skip_empty||typeof t!=="undefined"){result+=" "+z+"=\""+escape_xml((" "+t||"").replace(/ jstree[^ ]*/ig,'').replace(/\s+$/ig," ").replace(/^ /,"").replace(/ $/,""))+"\"";}});}
if(tmp1.children("ins").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\s+$/ig,"").length){result+=' icon="'+escape_xml(tmp1.children("ins").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\s+$/ig," ").replace(/^ /,"").replace(/ $/,""))+'"';}
if(tmp1.children("ins").get(0).style.backgroundImage.length){result+=' icon="'+escape_xml(tmp1.children("ins").get(0).style.backgroundImage.replace("url(","").replace(")","").replace(/'/ig,"").replace(/"/ig,""))+'"';}
result+=">";result+="<![CDATA["+_this.get_text(tmp1,lang)+"]]>";result+="</name>";});result+="</content>";tmp2=li[0].id||true;li=li.find("> ul > li");if(li.length){tmp2=_this.get_xml(tp,li,li_attr,a_attr,tmp2);}
else{tmp2="";}
if(tp=="nest"){result+=tmp2;}
result+="</item>";if(tp=="flat"){result+=tmp2;}});if(!is_callback){result+="</root>";}
return result;}}});})(jQuery);(function($){$.expr[':'].jstree_contains=function(a,i,m){return(a.textContent||a.innerText||"").toLowerCase().indexOf(m[3].toLowerCase())>=0;};$.expr[':'].jstree_title_contains=function(a,i,m){return(a.getAttribute("title")||"").toLowerCase().indexOf(m[3].toLowerCase())>=0;};$.jstree.plugin("search",{__init:function(){this.data.search.str="";this.data.search.result=$();if(this._get_settings().search.show_only_matches){this.get_container().bind("search.jstree",function(e,data){$(this).children("ul").find("li").hide().removeClass("jstree-last");data.rslt.nodes.parentsUntil(".jstree").andSelf().show().filter("ul").each(function(){$(this).children("li:visible").eq(-1).addClass("jstree-last");});}).bind("clear_search.jstree",function(){$(this).children("ul").find("li").css("display","").end().end().jstree("clean_node",-1);});}},defaults:{ajax:false,search_method:"jstree_contains",show_only_matches:false},_fn:{search:function(str,skip_async){if($.trim(str)===""){this.clear_search();return;}
var s=this.get_settings().search,t=this,error_func=function(){},success_func=function(){};this.data.search.str=str;if(!skip_async&&s.ajax!==false&&this.get_container_ul().find("li.jstree-closed:not(:has(ul)):eq(0)").length>0){this.search.supress_callback=true;error_func=function(){};success_func=function(d,t,x){var sf=this.get_settings().search.ajax.success;if(sf){d=sf.call(this,d,t,x)||d;}
this.data.search.to_open=d;this._search_open();};s.ajax.context=this;s.ajax.error=error_func;s.ajax.success=success_func;if($.isFunction(s.ajax.url)){s.ajax.url=s.ajax.url.call(this,str);}
if($.isFunction(s.ajax.data)){s.ajax.data=s.ajax.data.call(this,str);}
if(!s.ajax.data){s.ajax.data={"search_string":str};}
if(!s.ajax.dataType||/^json/.exec(s.ajax.dataType)){s.ajax.dataType="json";}
$.ajax(s.ajax);return;}
if(this.data.search.result.length){this.clear_search();}
this.data.search.result=this.get_container().find("a"+(this.data.languages?"."+this.get_lang():"")+":"+(s.search_method)+"("+this.data.search.str+")");this.data.search.result.addClass("jstree-search").parent().parents(".jstree-closed").each(function(){t.open_node(this,false,true);});this.__callback({nodes:this.data.search.result,str:str});},clear_search:function(str){this.data.search.result.removeClass("jstree-search");this.__callback(this.data.search.result);this.data.search.result=$();},_search_open:function(is_callback){var _this=this,done=true,current=[],remaining=[];if(this.data.search.to_open.length){$.each(this.data.search.to_open,function(i,val){if(val=="#"){return true;}
if($(val).length&&$(val).is(".jstree-closed")){current.push(val);}
else{remaining.push(val);}});if(current.length){this.data.search.to_open=remaining;$.each(current,function(i,val){_this.open_node(val,function(){_this._search_open(true);});});done=false;}}
if(done){this.search(this.data.search.str,true);}}}});})(jQuery);(function($){$.vakata.context={hide_on_mouseleave:false,cnt:$("<div id='vakata-contextmenu' />"),vis:false,tgt:false,par:false,func:false,data:false,rtl:false,show:function(s,t,x,y,d,p,rtl){$.vakata.context.rtl=!!rtl;var html=$.vakata.context.parse(s),h,w;if(!html){return;}
$.vakata.context.vis=true;$.vakata.context.tgt=t;$.vakata.context.par=p||t||null;$.vakata.context.data=d||null;$.vakata.context.cnt.html(html).css({"visibility":"hidden","display":"block","left":0,"top":0});if($.vakata.context.hide_on_mouseleave){$.vakata.context.cnt.one("mouseleave",function(e){$.vakata.context.hide();});}
h=$.vakata.context.cnt.height();w=$.vakata.context.cnt.width();if(x+w>$(document).width()){x=$(document).width()-(w+5);$.vakata.context.cnt.find("li > ul").addClass("right");}
if(y+h>$(document).height()){y=y-(h+t[0].offsetHeight);$.vakata.context.cnt.find("li > ul").addClass("bottom");}
$.vakata.context.cnt.css({"left":x,"top":y}).find("li:has(ul)").bind("mouseenter",function(e){var w=$(document).width(),h=$(document).height(),ul=$(this).children("ul").show();if(w!==$(document).width()){ul.toggleClass("right");}
if(h!==$(document).height()){ul.toggleClass("bottom");}}).bind("mouseleave",function(e){$(this).children("ul").hide();}).end().css({"visibility":"visible"}).show();$(document).triggerHandler("context_show.vakata");},hide:function(){$.vakata.context.vis=false;$.vakata.context.cnt.attr("class","").css({"visibility":"hidden"});$(document).triggerHandler("context_hide.vakata");},parse:function(s,is_callback){if(!s){return false;}
var str="",tmp=false,was_sep=true;if(!is_callback){$.vakata.context.func={};}
str+="<ul>";$.each(s,function(i,val){if(!val){return true;}
$.vakata.context.func[i]=val.action;if(!was_sep&&val.separator_before){str+="<li class='vakata-separator vakata-separator-before'></li>";}
was_sep=false;str+="<li class='"+(val._class||"")+(val._disabled?" jstree-contextmenu-disabled ":"")+"'><ins ";if(val.icon&&val.icon.indexOf("/")===-1){str+=" class='"+val.icon+"' ";}
if(val.icon&&val.icon.indexOf("/")!==-1){str+=" style='background:url("+val.icon+") center center no-repeat;' ";}
str+=">&#160;</ins><a href='#' rel='"+i+"'>";if(val.submenu){str+="<span style='float:"+($.vakata.context.rtl?"left":"right")+";'>&raquo;</span>";}
str+=val.label+"</a>";if(val.submenu){tmp=$.vakata.context.parse(val.submenu,true);if(tmp){str+=tmp;}}
str+="</li>";if(val.separator_after){str+="<li class='vakata-separator vakata-separator-after'></li>";was_sep=true;}});str=str.replace(/<li class\='vakata-separator vakata-separator-after'\><\/li\>$/,"");str+="</ul>";$(document).triggerHandler("context_parse.vakata");return str.length>10?str:false;},exec:function(i){if($.isFunction($.vakata.context.func[i])){$.vakata.context.func[i].call($.vakata.context.data,$.vakata.context.par);return true;}
else{return false;}}};$(function(){var css_string=''+'#vakata-contextmenu { display:block; visibility:hidden; left:0; top:-200px; position:absolute; margin:0; padding:0; min-width:180px; background:#ebebeb; border:1px solid silver; z-index:10000; *width:180px; } '+'#vakata-contextmenu ul { min-width:180px; *width:180px; } '+'#vakata-contextmenu ul, #vakata-contextmenu li { margin:0; padding:0; list-style-type:none; display:block; } '+'#vakata-contextmenu li { line-height:20px; min-height:20px; position:relative; padding:0px; } '+'#vakata-contextmenu li a { padding:1px 6px; line-height:17px; display:block; text-decoration:none; margin:1px 1px 0 1px; } '+'#vakata-contextmenu li ins { float:left; width:16px; height:16px; text-decoration:none; margin-right:2px; } '+'#vakata-contextmenu li a:hover, #vakata-contextmenu li.vakata-hover > a { background:gray; color:white; } '+'#vakata-contextmenu li ul { display:none; position:absolute; top:-2px; left:100%; background:#ebebeb; border:1px solid gray; } '+'#vakata-contextmenu .right { right:100%; left:auto; } '+'#vakata-contextmenu .bottom { bottom:-1px; top:auto; } '+'#vakata-contextmenu li.vakata-separator { min-height:0; height:1px; line-height:1px; font-size:1px; overflow:hidden; margin:0 2px; background:silver; /* border-top:1px solid #fefefe; */ padding:0; } ';$.vakata.css.add_sheet({str:css_string,title:"vakata"});$.vakata.context.cnt.delegate("a","click",function(e){e.preventDefault();}).delegate("a","mouseup",function(e){if(!$(this).parent().hasClass("jstree-contextmenu-disabled")&&$.vakata.context.exec($(this).attr("rel"))){$.vakata.context.hide();}
else{$(this).blur();}}).delegate("a","mouseover",function(){$.vakata.context.cnt.find(".vakata-hover").removeClass("vakata-hover");}).appendTo("body");$(document).bind("mousedown",function(e){if($.vakata.context.vis&&!$.contains($.vakata.context.cnt[0],e.target)){$.vakata.context.hide();}});if(typeof $.hotkeys!=="undefined"){$(document).bind("keydown","up",function(e){if($.vakata.context.vis){var o=$.vakata.context.cnt.find("ul:visible").last().children(".vakata-hover").removeClass("vakata-hover").prevAll("li:not(.vakata-separator)").first();if(!o.length){o=$.vakata.context.cnt.find("ul:visible").last().children("li:not(.vakata-separator)").last();}
o.addClass("vakata-hover");e.stopImmediatePropagation();e.preventDefault();}}).bind("keydown","down",function(e){if($.vakata.context.vis){var o=$.vakata.context.cnt.find("ul:visible").last().children(".vakata-hover").removeClass("vakata-hover").nextAll("li:not(.vakata-separator)").first();if(!o.length){o=$.vakata.context.cnt.find("ul:visible").last().children("li:not(.vakata-separator)").first();}
o.addClass("vakata-hover");e.stopImmediatePropagation();e.preventDefault();}}).bind("keydown","right",function(e){if($.vakata.context.vis){$.vakata.context.cnt.find(".vakata-hover").children("ul").show().children("li:not(.vakata-separator)").removeClass("vakata-hover").first().addClass("vakata-hover");e.stopImmediatePropagation();e.preventDefault();}}).bind("keydown","left",function(e){if($.vakata.context.vis){$.vakata.context.cnt.find(".vakata-hover").children("ul").hide().children(".vakata-separator").removeClass("vakata-hover");e.stopImmediatePropagation();e.preventDefault();}}).bind("keydown","esc",function(e){$.vakata.context.hide();e.preventDefault();}).bind("keydown","space",function(e){$.vakata.context.cnt.find(".vakata-hover").last().children("a").click();e.preventDefault();});}});$.jstree.plugin("contextmenu",{__init:function(){this.get_container().delegate("a","contextmenu.jstree",$.proxy(function(e){e.preventDefault();if(!$(e.currentTarget).hasClass("jstree-loading")){this.show_contextmenu(e.currentTarget,e.pageX,e.pageY);}},this)).delegate("a","click.jstree",$.proxy(function(e){if(this.data.contextmenu){$.vakata.context.hide();}},this)).bind("destroy.jstree",$.proxy(function(){if(this.data.contextmenu){$.vakata.context.hide();}},this));$(document).bind("context_hide.vakata",$.proxy(function(){this.data.contextmenu=false;},this));},__destroy:function(){if($('.jstree').length<=1){$(document).unbind("context_hide.vakata");}},defaults:{select_node:false,show_at_node:true,items:{"create":{"separator_before":false,"separator_after":true,"label":"Create","action":function(obj){this.create(obj);}},"rename":{"separator_before":false,"separator_after":false,"label":"Rename","action":function(obj){this.rename(obj);}},"remove":{"separator_before":false,"icon":false,"separator_after":false,"label":"Delete","action":function(obj){if(this.is_selected(obj)){this.remove();}else{this.remove(obj);}}},"ccp":{"separator_before":true,"icon":false,"separator_after":false,"label":"Edit","action":false,"submenu":{"cut":{"separator_before":false,"separator_after":false,"label":"Cut","action":function(obj){this.cut(obj);}},"copy":{"separator_before":false,"icon":false,"separator_after":false,"label":"Copy","action":function(obj){this.copy(obj);}},"paste":{"separator_before":false,"icon":false,"separator_after":false,"label":"Paste","action":function(obj){this.paste(obj);}}}}}},_fn:{show_contextmenu:function(obj,x,y){obj=this._get_node(obj);var s=this.get_settings().contextmenu,a=obj.children("a:visible:eq(0)"),o=false,i=false;if(s.select_node&&this.data.ui&&!this.is_selected(obj)){this.deselect_all();this.select_node(obj,true);}
if(s.show_at_node||typeof x==="undefined"||typeof y==="undefined"){o=a.offset();x=o.left;y=o.top+this.data.core.li_height;}
i=obj.data("jstree")&&obj.data("jstree").contextmenu?obj.data("jstree").contextmenu:s.items;if($.isFunction(i)){i=i.call(this,obj);}
this.data.contextmenu=true;$.vakata.context.show(i,a,x,y,this,obj,this._get_settings().core.rtl);if(this.data.themes){$.vakata.context.cnt.attr("class","jstree-"+this.data.themes.theme+"-context");}}}});})(jQuery);(function($){$.jstree.plugin("types",{__init:function(){var s=this._get_settings().types;this.data.types.attach_to=[];this.get_container().bind("init.jstree",$.proxy(function(){var types=s.types,attr=s.type_attr,icons_css="",_this=this;$.each(types,function(i,tp){$.each(tp,function(k,v){if(!/^(max_depth|max_children|icon|valid_children)$/.test(k)){_this.data.types.attach_to.push(k);}});if(!tp.icon){return true;}
if(tp.icon.image||tp.icon.position){if(i=="default"){icons_css+='.jstree-'+_this.get_index()+' a > .jstree-icon { ';}
else{icons_css+='.jstree-'+_this.get_index()+' li['+attr+'="'+i+'"] > a > .jstree-icon { ';}
if(tp.icon.image){icons_css+=' background-image:url('+tp.icon.image+'); ';}
if(tp.icon.position){icons_css+=' background-position:'+tp.icon.position+'; ';}
else{icons_css+=' background-position:0 0; ';}
icons_css+='} ';}});if(icons_css!==""){$.vakata.css.add_sheet({'str':icons_css,title:"jstree-types"});}},this)).bind("before.jstree",$.proxy(function(e,data){var s,t,o=this._get_settings().types.use_data?this._get_node(data.args[0]):false,d=o&&o!==-1&&o.length?o.data("jstree"):false;if(d&&d.types&&d.types[data.func]===false){e.stopImmediatePropagation();return false;}
if($.inArray(data.func,this.data.types.attach_to)!==-1){if(!data.args[0]||(!data.args[0].tagName&&!data.args[0].jquery)){return;}
s=this._get_settings().types.types;t=this._get_type(data.args[0]);if(((s[t]&&typeof s[t][data.func]!=="undefined")||(s["default"]&&typeof s["default"][data.func]!=="undefined"))&&this._check(data.func,data.args[0])===false){e.stopImmediatePropagation();return false;}}},this));if(is_ie6){this.get_container().bind("load_node.jstree set_type.jstree",$.proxy(function(e,data){var r=data&&data.rslt&&data.rslt.obj&&data.rslt.obj!==-1?this._get_node(data.rslt.obj).parent():this.get_container_ul(),c=false,s=this._get_settings().types;$.each(s.types,function(i,tp){if(tp.icon&&(tp.icon.image||tp.icon.position)){c=i==="default"?r.find("li > a > .jstree-icon"):r.find("li["+s.type_attr+"='"+i+"'] > a > .jstree-icon");if(tp.icon.image){c.css("backgroundImage","url("+tp.icon.image+")");}
c.css("backgroundPosition",tp.icon.position||"0 0");}});},this));}},defaults:{max_children:-1,max_depth:-1,valid_children:"all",use_data:false,type_attr:"rel",types:{"default":{"max_children":-1,"max_depth":-1,"valid_children":"all"}}},_fn:{_types_notify:function(n,data){if(data.type&&this._get_settings().types.use_data){this.set_type(data.type,n);}},_get_type:function(obj){obj=this._get_node(obj);return(!obj||!obj.length)?false:obj.attr(this._get_settings().types.type_attr)||"default";},set_type:function(str,obj){obj=this._get_node(obj);var ret=(!obj.length||!str)?false:obj.attr(this._get_settings().types.type_attr,str);if(ret){this.__callback({obj:obj,type:str});}
return ret;},_check:function(rule,obj,opts){obj=this._get_node(obj);var v=false,t=this._get_type(obj),d=0,_this=this,s=this._get_settings().types,data=false;if(obj===-1){if(!!s[rule]){v=s[rule];}
else{return;}}
else{if(t===false){return;}
data=s.use_data?obj.data("jstree"):false;if(data&&data.types&&typeof data.types[rule]!=="undefined"){v=data.types[rule];}
else if(!!s.types[t]&&typeof s.types[t][rule]!=="undefined"){v=s.types[t][rule];}
else if(!!s.types["default"]&&typeof s.types["default"][rule]!=="undefined"){v=s.types["default"][rule];}}
if($.isFunction(v)){v=v.call(this,obj);}
if(rule==="max_depth"&&obj!==-1&&opts!==false&&s.max_depth!==-2&&v!==0){obj.children("a:eq(0)").parentsUntil(".jstree","li").each(function(i){if(s.max_depth!==-1&&s.max_depth-(i+1)<=0){v=0;return false;}
d=(i===0)?v:_this._check(rule,this,false);if(d!==-1&&d-(i+1)<=0){v=0;return false;}
if(d>=0&&(d-(i+1)<v||v<0)){v=d-(i+1);}
if(s.max_depth>=0&&(s.max_depth-(i+1)<v||v<0)){v=s.max_depth-(i+1);}});}
return v;},check_move:function(){if(!this.__call_old()){return false;}
var m=this._get_move(),s=m.rt._get_settings().types,mc=m.rt._check("max_children",m.cr),md=m.rt._check("max_depth",m.cr),vc=m.rt._check("valid_children",m.cr),ch=0,d=1,t;if(vc==="none"){return false;}
if($.isArray(vc)&&m.ot&&m.ot._get_type){m.o.each(function(){if($.inArray(m.ot._get_type(this),vc)===-1){d=false;return false;}});if(d===false){return false;}}
if(s.max_children!==-2&&mc!==-1){ch=m.cr===-1?this.get_container().find("> ul > li").not(m.o).length:m.cr.find("> ul > li").not(m.o).length;if(ch+m.o.length>mc){return false;}}
if(s.max_depth!==-2&&md!==-1){d=0;if(md===0){return false;}
if(typeof m.o.d==="undefined"){t=m.o;while(t.length>0){t=t.find("> ul > li");d++;}
m.o.d=d;}
if(md-m.o.d<0){return false;}}
return true;},create_node:function(obj,position,js,callback,is_loaded,skip_check){if(!skip_check&&(is_loaded||this._is_loaded(obj))){var p=(typeof position=="string"&&position.match(/^before|after$/i)&&obj!==-1)?this._get_parent(obj):this._get_node(obj),s=this._get_settings().types,mc=this._check("max_children",p),md=this._check("max_depth",p),vc=this._check("valid_children",p),ch;if(typeof js==="string"){js={data:js};}
if(!js){js={};}
if(vc==="none"){return false;}
if($.isArray(vc)){if(!js.attr||!js.attr[s.type_attr]){if(!js.attr){js.attr={};}
js.attr[s.type_attr]=vc[0];}
else{if($.inArray(js.attr[s.type_attr],vc)===-1){return false;}}}
if(s.max_children!==-2&&mc!==-1){ch=p===-1?this.get_container().find("> ul > li").length:p.find("> ul > li").length;if(ch+1>mc){return false;}}
if(s.max_depth!==-2&&md!==-1&&(md-1)<0){return false;}}
return this.__call_old(true,obj,position,js,callback,is_loaded,skip_check);}}});})(jQuery);(function($){$.jstree.plugin("html_data",{__init:function(){this.data.html_data.original_container_html=this.get_container().find(" > ul > li").clone(true);this.data.html_data.original_container_html.find("li").andSelf().contents().filter(function(){return this.nodeType==3;}).remove();},defaults:{data:false,ajax:false,correct_state:true},_fn:{load_node:function(obj,s_call,e_call){var _this=this;this.load_node_html(obj,function(){_this.__callback({"obj":_this._get_node(obj)});s_call.call(this);},e_call);},_is_loaded:function(obj){obj=this._get_node(obj);return obj==-1||!obj||(!this._get_settings().html_data.ajax&&!$.isFunction(this._get_settings().html_data.data))||obj.is(".jstree-open, .jstree-leaf")||obj.children("ul").children("li").size()>0;},load_node_html:function(obj,s_call,e_call){var d,s=this.get_settings().html_data,error_func=function(){},success_func=function(){};obj=this._get_node(obj);if(obj&&obj!==-1){if(obj.data("jstree_is_loading")){return;}
else{obj.data("jstree_is_loading",true);}}
switch(!0){case($.isFunction(s.data)):s.data.call(this,obj,$.proxy(function(d){if(d&&d!==""&&d.toString&&d.toString().replace(/^[\s\n]+$/,"")!==""){d=$(d);if(!d.is("ul")){d=$("<ul />").append(d);}
if(obj==-1||!obj){this.get_container().children("ul").empty().append(d.children()).find("li, a").filter(function(){return!this.firstChild||!this.firstChild.tagName||this.firstChild.tagName!=="INS";}).prepend("<ins class='jstree-icon'>&#160;</ins>").end().filter("a").children("ins:first-child").not(".jstree-icon").addClass("jstree-icon");}
else{obj.children("a.jstree-loading").removeClass("jstree-loading");obj.append(d).children("ul").find("li, a").filter(function(){return!this.firstChild||!this.firstChild.tagName||this.firstChild.tagName!=="INS";}).prepend("<ins class='jstree-icon'>&#160;</ins>").end().filter("a").children("ins:first-child").not(".jstree-icon").addClass("jstree-icon");obj.removeData("jstree_is_loading");}
this.clean_node(obj);if(s_call){s_call.call(this);}}
else{if(obj&&obj!==-1){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(s.correct_state){this.correct_state(obj);if(s_call){s_call.call(this);}}}
else{if(s.correct_state){this.get_container().children("ul").empty();if(s_call){s_call.call(this);}}}}},this));break;case(!s.data&&!s.ajax):if(!obj||obj==-1){this.get_container().children("ul").empty().append(this.data.html_data.original_container_html).find("li, a").filter(function(){return!this.firstChild||!this.firstChild.tagName||this.firstChild.tagName!=="INS";}).prepend("<ins class='jstree-icon'>&#160;</ins>").end().filter("a").children("ins:first-child").not(".jstree-icon").addClass("jstree-icon");this.clean_node();}
if(s_call){s_call.call(this);}
break;case(!!s.data&&!s.ajax)||(!!s.data&&!!s.ajax&&(!obj||obj===-1)):if(!obj||obj==-1){d=$(s.data);if(!d.is("ul")){d=$("<ul />").append(d);}
this.get_container().children("ul").empty().append(d.children()).find("li, a").filter(function(){return!this.firstChild||!this.firstChild.tagName||this.firstChild.tagName!=="INS";}).prepend("<ins class='jstree-icon'>&#160;</ins>").end().filter("a").children("ins:first-child").not(".jstree-icon").addClass("jstree-icon");this.clean_node();}
if(s_call){s_call.call(this);}
break;case(!s.data&&!!s.ajax)||(!!s.data&&!!s.ajax&&obj&&obj!==-1):obj=this._get_node(obj);error_func=function(x,t,e){var ef=this.get_settings().html_data.ajax.error;if(ef){ef.call(this,x,t,e);}
if(obj!=-1&&obj.length){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(t==="success"&&s.correct_state){this.correct_state(obj);}}
else{if(t==="success"&&s.correct_state){this.get_container().children("ul").empty();}}
if(e_call){e_call.call(this);}};success_func=function(d,t,x){var sf=this.get_settings().html_data.ajax.success;if(sf){d=sf.call(this,d,t,x)||d;}
if(d===""||(d&&d.toString&&d.toString().replace(/^[\s\n]+$/,"")==="")){return error_func.call(this,x,t,"");}
if(d){d=$(d);if(!d.is("ul")){d=$("<ul />").append(d);}
if(obj==-1||!obj){this.get_container().children("ul").empty().append(d.children()).find("li, a").filter(function(){return!this.firstChild||!this.firstChild.tagName||this.firstChild.tagName!=="INS";}).prepend("<ins class='jstree-icon'>&#160;</ins>").end().filter("a").children("ins:first-child").not(".jstree-icon").addClass("jstree-icon");}
else{obj.children("a.jstree-loading").removeClass("jstree-loading");obj.append(d).children("ul").find("li, a").filter(function(){return!this.firstChild||!this.firstChild.tagName||this.firstChild.tagName!=="INS";}).prepend("<ins class='jstree-icon'>&#160;</ins>").end().filter("a").children("ins:first-child").not(".jstree-icon").addClass("jstree-icon");obj.removeData("jstree_is_loading");}
this.clean_node(obj);if(s_call){s_call.call(this);}}
else{if(obj&&obj!==-1){obj.children("a.jstree-loading").removeClass("jstree-loading");obj.removeData("jstree_is_loading");if(s.correct_state){this.correct_state(obj);if(s_call){s_call.call(this);}}}
else{if(s.correct_state){this.get_container().children("ul").empty();if(s_call){s_call.call(this);}}}}};s.ajax.context=this;s.ajax.error=error_func;s.ajax.success=success_func;if(!s.ajax.dataType){s.ajax.dataType="html";}
if($.isFunction(s.ajax.url)){s.ajax.url=s.ajax.url.call(this,obj);}
if($.isFunction(s.ajax.data)){s.ajax.data=s.ajax.data.call(this,obj);}
$.ajax(s.ajax);break;}}}});$.jstree.defaults.plugins.push("html_data");})(jQuery);(function($){$.jstree.plugin("themeroller",{__init:function(){var s=this._get_settings().themeroller;this.get_container().addClass("ui-widget-content").addClass("jstree-themeroller").delegate("a","mouseenter.jstree",function(e){if(!$(e.currentTarget).hasClass("jstree-loading")){$(this).addClass(s.item_h);}}).delegate("a","mouseleave.jstree",function(){$(this).removeClass(s.item_h);}).bind("init.jstree",$.proxy(function(e,data){data.inst.get_container().find("> ul > li > .jstree-loading > ins").addClass("ui-icon-refresh");this._themeroller(data.inst.get_container().find("> ul > li"));},this)).bind("open_node.jstree create_node.jstree",$.proxy(function(e,data){this._themeroller(data.rslt.obj);},this)).bind("loaded.jstree refresh.jstree",$.proxy(function(e){this._themeroller();},this)).bind("close_node.jstree",$.proxy(function(e,data){this._themeroller(data.rslt.obj);},this)).bind("delete_node.jstree",$.proxy(function(e,data){this._themeroller(data.rslt.parent);},this)).bind("correct_state.jstree",$.proxy(function(e,data){data.rslt.obj.children("ins.jstree-icon").removeClass(s.opened+" "+s.closed+" ui-icon").end().find("> a > ins.ui-icon").filter(function(){return this.className.toString().replace(s.item_clsd,"").replace(s.item_open,"").replace(s.item_leaf,"").indexOf("ui-icon-")===-1;}).removeClass(s.item_open+" "+s.item_clsd).addClass(s.item_leaf||"jstree-no-icon");},this)).bind("select_node.jstree",$.proxy(function(e,data){data.rslt.obj.children("a").addClass(s.item_a);},this)).bind("deselect_node.jstree deselect_all.jstree",$.proxy(function(e,data){this.get_container().find("a."+s.item_a).removeClass(s.item_a).end().find("a.jstree-clicked").addClass(s.item_a);},this)).bind("dehover_node.jstree",$.proxy(function(e,data){data.rslt.obj.children("a").removeClass(s.item_h);},this)).bind("hover_node.jstree",$.proxy(function(e,data){this.get_container().find("a."+s.item_h).not(data.rslt.obj).removeClass(s.item_h);data.rslt.obj.children("a").addClass(s.item_h);},this)).bind("move_node.jstree",$.proxy(function(e,data){this._themeroller(data.rslt.o);this._themeroller(data.rslt.op);},this));},__destroy:function(){var s=this._get_settings().themeroller,c=["ui-icon"];$.each(s,function(i,v){v=v.split(" ");if(v.length){c=c.concat(v);}});this.get_container().removeClass("ui-widget-content").find("."+c.join(", .")).removeClass(c.join(" "));},_fn:{_themeroller:function(obj){var s=this._get_settings().themeroller;obj=(!obj||obj==-1)?this.get_container_ul():this._get_node(obj);obj=(!obj||obj==-1)?this.get_container_ul():obj.parent();obj.find("li.jstree-closed").children("ins.jstree-icon").removeClass(s.opened).addClass("ui-icon "+s.closed).end().children("a").addClass(s.item).children("ins.jstree-icon").addClass("ui-icon").filter(function(){return this.className.toString().replace(s.item_clsd,"").replace(s.item_open,"").replace(s.item_leaf,"").indexOf("ui-icon-")===-1;}).removeClass(s.item_leaf+" "+s.item_open).addClass(s.item_clsd||"jstree-no-icon").end().end().end().end().find("li.jstree-open").children("ins.jstree-icon").removeClass(s.closed).addClass("ui-icon "+s.opened).end().children("a").addClass(s.item).children("ins.jstree-icon").addClass("ui-icon").filter(function(){return this.className.toString().replace(s.item_clsd,"").replace(s.item_open,"").replace(s.item_leaf,"").indexOf("ui-icon-")===-1;}).removeClass(s.item_leaf+" "+s.item_clsd).addClass(s.item_open||"jstree-no-icon").end().end().end().end().find("li.jstree-leaf").children("ins.jstree-icon").removeClass(s.closed+" ui-icon "+s.opened).end().children("a").addClass(s.item).children("ins.jstree-icon").addClass("ui-icon").filter(function(){return this.className.toString().replace(s.item_clsd,"").replace(s.item_open,"").replace(s.item_leaf,"").indexOf("ui-icon-")===-1;}).removeClass(s.item_clsd+" "+s.item_open).addClass(s.item_leaf||"jstree-no-icon");}},defaults:{"opened":"ui-icon-triangle-1-se","closed":"ui-icon-triangle-1-e","item":"ui-state-default","item_h":"ui-state-hover","item_a":"ui-state-active","item_open":"ui-icon-folder-open","item_clsd":"ui-icon-folder-collapsed","item_leaf":"ui-icon-document"}});$(function(){var css_string=''+'.jstree-themeroller .ui-icon { overflow:visible; } '+'.jstree-themeroller a { padding:0 2px; } '+'.jstree-themeroller .jstree-no-icon { display:none; }';$.vakata.css.add_sheet({str:css_string,title:"jstree"});});})(jQuery);(function($){$.jstree.plugin("unique",{__init:function(){this.get_container().bind("before.jstree",$.proxy(function(e,data){var nms=[],res=true,p,t;if(data.func=="move_node"){if(data.args[4]===true){if(data.args[0].o&&data.args[0].o.length){data.args[0].o.children("a").each(function(){nms.push($(this).text().replace(/^\s+/g,""));});res=this._check_unique(nms,data.args[0].np.find("> ul > li").not(data.args[0].o),"move_node");}}}
if(data.func=="create_node"){if(data.args[4]||this._is_loaded(data.args[0])){p=this._get_node(data.args[0]);if(data.args[1]&&(data.args[1]==="before"||data.args[1]==="after")){p=this._get_parent(data.args[0]);if(!p||p===-1){p=this.get_container();}}
if(typeof data.args[2]==="string"){nms.push(data.args[2]);}
else if(!data.args[2]||!data.args[2].data){nms.push(this._get_string("new_node"));}
else{nms.push(data.args[2].data);}
res=this._check_unique(nms,p.find("> ul > li"),"create_node");}}
if(data.func=="rename_node"){nms.push(data.args[1]);t=this._get_node(data.args[0]);p=this._get_parent(t);if(!p||p===-1){p=this.get_container();}
res=this._check_unique(nms,p.find("> ul > li").not(t),"rename_node");}
if(!res){e.stopPropagation();return false;}},this));},defaults:{error_callback:$.noop},_fn:{_check_unique:function(nms,p,func){var cnms=[],ok=true;p.children("a").each(function(){cnms.push($(this).text().replace(/^\s+/g,""));});if(!cnms.length||!nms.length){return true;}
$.each(nms,function(i,v){if($.inArray(v,cnms)!==-1){ok=false;return false;}});if(!ok){this._get_settings().unique.error_callback.call(null,nms,p,func);}
return ok;},check_move:function(){if(!this.__call_old()){return false;}
var p=this._get_move(),nms=[];if(p.o&&p.o.length){p.o.children("a").each(function(){nms.push($(this).text().replace(/^\s+/g,""));});return this._check_unique(nms,p.np.find("> ul > li").not(p.o),"check_move");}
return true;}}});})(jQuery);(function($){$.jstree.plugin("wholerow",{__init:function(){if(!this.data.ui){throw"jsTree wholerow: jsTree UI plugin not included.";}
this.data.wholerow.html=false;this.data.wholerow.to=false;this.get_container().bind("init.jstree",$.proxy(function(e,data){this._get_settings().core.animation=0;},this)).bind("open_node.jstree create_node.jstree clean_node.jstree loaded.jstree",$.proxy(function(e,data){this._prepare_wholerow_span(data&&data.rslt&&data.rslt.obj?data.rslt.obj:-1);},this)).bind("search.jstree clear_search.jstree reopen.jstree after_open.jstree after_close.jstree create_node.jstree delete_node.jstree clean_node.jstree",$.proxy(function(e,data){if(this.data.to){clearTimeout(this.data.to);}
this.data.to=setTimeout((function(t,o){return function(){t._prepare_wholerow_ul(o);};})(this,data&&data.rslt&&data.rslt.obj?data.rslt.obj:-1),0);},this)).bind("deselect_all.jstree",$.proxy(function(e,data){this.get_container().find(" > .jstree-wholerow .jstree-clicked").removeClass("jstree-clicked "+(this.data.themeroller?this._get_settings().themeroller.item_a:""));},this)).bind("select_node.jstree deselect_node.jstree ",$.proxy(function(e,data){data.rslt.obj.each(function(){var ref=data.inst.get_container().find(" > .jstree-wholerow li:visible:eq("+(parseInt((($(this).offset().top-data.inst.get_container().offset().top+data.inst.get_container()[0].scrollTop)/data.inst.data.core.li_height),10))+")");ref.children("a").attr("class",data.rslt.obj.children("a").attr("class"));});},this)).bind("hover_node.jstree dehover_node.jstree",$.proxy(function(e,data){this.get_container().find(" > .jstree-wholerow .jstree-hovered").removeClass("jstree-hovered "+(this.data.themeroller?this._get_settings().themeroller.item_h:""));if(e.type==="hover_node"){var ref=this.get_container().find(" > .jstree-wholerow li:visible:eq("+(parseInt(((data.rslt.obj.offset().top-this.get_container().offset().top+this.get_container()[0].scrollTop)/this.data.core.li_height),10))+")");ref.children("a").attr("class",data.rslt.obj.children(".jstree-hovered").attr("class"));}},this)).delegate(".jstree-wholerow-span, ins.jstree-icon, li","click.jstree",function(e){var n=$(e.currentTarget);if(e.target.tagName==="A"||(e.target.tagName==="INS"&&n.closest("li").is(".jstree-open, .jstree-closed"))){return;}
n.closest("li").children("a:visible:eq(0)").click();e.stopImmediatePropagation();}).delegate("li","mouseover.jstree",$.proxy(function(e){e.stopImmediatePropagation();if($(e.currentTarget).children(".jstree-hovered, .jstree-clicked").length){return false;}
this.hover_node(e.currentTarget);return false;},this)).delegate("li","mouseleave.jstree",$.proxy(function(e){if($(e.currentTarget).children("a").hasClass("jstree-hovered").length){return;}
this.dehover_node(e.currentTarget);},this));if(is_ie7||is_ie6){$.vakata.css.add_sheet({str:".jstree-"+this.get_index()+" { position:relative; } ",title:"jstree"});}},defaults:{},__destroy:function(){this.get_container().children(".jstree-wholerow").remove();this.get_container().find(".jstree-wholerow-span").remove();},_fn:{_prepare_wholerow_span:function(obj){obj=!obj||obj==-1?this.get_container().find("> ul > li"):this._get_node(obj);if(obj===false){return;}
obj.each(function(){$(this).find("li").andSelf().each(function(){var $t=$(this);if($t.children(".jstree-wholerow-span").length){return true;}
$t.prepend("<span class='jstree-wholerow-span' style='width:"+($t.parentsUntil(".jstree","li").length*18)+"px;'>&#160;</span>");});});},_prepare_wholerow_ul:function(){var o=this.get_container().children("ul").eq(0),h=o.html();o.addClass("jstree-wholerow-real");if(this.data.wholerow.last_html!==h){this.data.wholerow.last_html=h;this.get_container().children(".jstree-wholerow").remove();this.get_container().append(o.clone().removeClass("jstree-wholerow-real").wrapAll("<div class='jstree-wholerow' />").parent().width(o.parent()[0].scrollWidth).css("top",(o.height()+(is_ie7?5:0))*-1).find("li[id]").each(function(){this.removeAttribute("id");}).end());}}}});$(function(){var css_string=''+'.jstree .jstree-wholerow-real { position:relative; z-index:1; } '+'.jstree .jstree-wholerow-real li { cursor:pointer; } '+'.jstree .jstree-wholerow-real a { border-left-color:transparent !important; border-right-color:transparent !important; } '+'.jstree .jstree-wholerow { position:relative; z-index:0; height:0; } '+'.jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { width:100%; } '+'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li, .jstree .jstree-wholerow a { margin:0 !important; padding:0 !important; } '+'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { background:transparent !important; }'+'.jstree .jstree-wholerow ins, .jstree .jstree-wholerow span, .jstree .jstree-wholerow input { display:none !important; }'+'.jstree .jstree-wholerow a, .jstree .jstree-wholerow a:hover { text-indent:-9999px; !important; width:100%; padding:0 !important; border-right-width:0px !important; border-left-width:0px !important; } '+'.jstree .jstree-wholerow-span { position:absolute; left:0; margin:0px; padding:0; height:18px; border-width:0; padding:0; z-index:0; }';if(is_ff2){css_string+=''+'.jstree .jstree-wholerow a { display:block; height:18px; margin:0; padding:0; border:0; } '+'.jstree .jstree-wholerow-real a { border-color:transparent !important; } ';}
if(is_ie7||is_ie6){css_string+=''+'.jstree .jstree-wholerow, .jstree .jstree-wholerow li, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow a { margin:0; padding:0; line-height:18px; } '+'.jstree .jstree-wholerow a { display:block; height:18px; line-height:18px; overflow:hidden; } ';}
$.vakata.css.add_sheet({str:css_string,title:"jstree"});});})(jQuery);(function($){var nodeInterface=["getChildren","getChildrenCount","getAttr","getName","getProps"],validateInterface=function(obj,inter){var valid=true;obj=obj||{};inter=[].concat(inter);$.each(inter,function(i,v){if(!$.isFunction(obj[v])){valid=false;return false;}});return valid;};$.jstree.plugin("model",{__init:function(){if(!this.data.json_data){throw"jsTree model: jsTree json_data plugin not included.";}
this._get_settings().json_data.data=function(n,b){var obj=(n==-1)?this._get_settings().model.object:n.data("jstree_model");if(!validateInterface(obj,nodeInterface)){return b.call(null,false);}
if(this._get_settings().model.async){obj.getChildren($.proxy(function(data){this.model_done(data,b);},this));}
else{this.model_done(obj.getChildren(),b);}};},defaults:{object:false,id_prefix:false,async:false},_fn:{model_done:function(data,callback){var ret=[],s=this._get_settings(),_this=this;if(!$.isArray(data)){data=[data];}
$.each(data,function(i,nd){var r=nd.getProps()||{};r.attr=nd.getAttr()||{};if(nd.getChildrenCount()){r.state="closed";}
r.data=nd.getName();if(!$.isArray(r.data)){r.data=[r.data];}
if(_this.data.types&&$.isFunction(nd.getType)){r.attr[s.types.type_attr]=nd.getType();}
if(r.attr.id&&s.model.id_prefix){r.attr.id=s.model.id_prefix+r.attr.id;}
if(!r.metadata){r.metadata={};}
r.metadata.jstree_model=nd;ret.push(r);});callback.call(null,ret);}}});})(jQuery);})();;

/****** FILE: framework/admin/thirdparty/chosen/chosen/chosen.jquery.js *****/

(function(){var SelectParser;SelectParser=(function(){SelectParser.name='SelectParser';function SelectParser(){this.options_index=0;this.parsed=[];}
SelectParser.prototype.add_node=function(child){if(child.nodeName.toUpperCase()==="OPTGROUP"){return this.add_group(child);}else{return this.add_option(child);}};SelectParser.prototype.add_group=function(group){var group_position,option,_i,_len,_ref,_results;group_position=this.parsed.length;this.parsed.push({array_index:group_position,group:true,label:group.label,children:0,disabled:group.disabled});_ref=group.childNodes;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){option=_ref[_i];_results.push(this.add_option(option,group_position,group.disabled));}
return _results;};SelectParser.prototype.add_option=function(option,group_position,group_disabled){if(option.nodeName.toUpperCase()==="OPTION"){if(option.text!==""){if(group_position!=null){this.parsed[group_position].children+=1;}
this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:option.value,text:option.text,html:option.innerHTML,selected:option.selected,disabled:group_disabled===true?group_disabled:option.disabled,group_array_index:group_position,classes:option.className,style:option.style.cssText});}else{this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:true});}
return this.options_index+=1;}};return SelectParser;})();SelectParser.select_to_array=function(select){var child,parser,_i,_len,_ref;parser=new SelectParser();_ref=select.childNodes;for(_i=0,_len=_ref.length;_i<_len;_i++){child=_ref[_i];parser.add_node(child);}
return parser.parsed;};this.SelectParser=SelectParser;}).call(this);(function(){var AbstractChosen,root;root=this;AbstractChosen=(function(){AbstractChosen.name='AbstractChosen';function AbstractChosen(form_field,options){this.form_field=form_field;this.options=options!=null?options:{};this.set_default_values();this.is_multiple=this.form_field.multiple;this.set_default_text();this.setup();this.set_up_html();this.register_observers();this.finish_setup();}
AbstractChosen.prototype.set_default_values=function(){var _this=this;this.click_test_action=function(evt){return _this.test_active_click(evt);};this.activate_action=function(evt){return _this.activate_field(evt);};this.active_field=false;this.mouse_on_container=false;this.results_showing=false;this.result_highlighted=null;this.result_single_selected=null;this.allow_single_deselect=(this.options.allow_single_deselect!=null)&&(this.form_field.options[0]!=null)&&this.form_field.options[0].text===""?this.options.allow_single_deselect:false;this.disable_search_threshold=this.options.disable_search_threshold||0;this.disable_search=this.options.disable_search||false;this.search_contains=this.options.search_contains||false;this.choices=0;this.single_backstroke_delete=this.options.single_backstroke_delete||false;return this.max_selected_options=this.options.max_selected_options||Infinity;};AbstractChosen.prototype.set_default_text=function(){if(this.form_field.getAttribute("data-placeholder")){this.default_text=this.form_field.getAttribute("data-placeholder");}else if(this.is_multiple){this.default_text=this.options.placeholder_text_multiple||this.options.placeholder_text||"Select Some Options";}else{this.default_text=this.options.placeholder_text_single||this.options.placeholder_text||"Select an Option";}
return this.results_none_found=this.form_field.getAttribute("data-no_results_text")||this.options.no_results_text||"No results match";};AbstractChosen.prototype.mouse_enter=function(){return this.mouse_on_container=true;};AbstractChosen.prototype.mouse_leave=function(){return this.mouse_on_container=false;};AbstractChosen.prototype.input_focus=function(evt){var _this=this;if(this.is_multiple){if(!this.active_field){return setTimeout((function(){return _this.container_mousedown();}),50);}}else{if(!this.active_field){return this.activate_field();}}};AbstractChosen.prototype.input_blur=function(evt){var _this=this;if(!this.mouse_on_container){this.active_field=false;return setTimeout((function(){return _this.blur_test();}),100);}};AbstractChosen.prototype.result_add_option=function(option){var classes,style;if(!option.disabled){option.dom_id=this.container_id+"_o_"+option.array_index;classes=option.selected&&this.is_multiple?[]:["active-result"];if(option.selected){classes.push("result-selected");}
if(option.group_array_index!=null){classes.push("group-option");}
if(option.classes!==""){classes.push(option.classes);}
style=option.style.cssText!==""?" style=\""+option.style+"\"":"";return'<li id="'+option.dom_id+'" class="'+classes.join(' ')+'"'+style+'>'+option.html+'</li>';}else{return"";}};AbstractChosen.prototype.results_update_field=function(){if(!this.is_multiple){this.results_reset_cleanup();}
this.result_clear_highlight();this.result_single_selected=null;return this.results_build();};AbstractChosen.prototype.results_toggle=function(){if(this.results_showing){return this.results_hide();}else{return this.results_show();}};AbstractChosen.prototype.results_search=function(evt){if(this.results_showing){return this.winnow_results();}else{return this.results_show();}};AbstractChosen.prototype.keyup_checker=function(evt){var stroke,_ref;stroke=(_ref=evt.which)!=null?_ref:evt.keyCode;this.search_field_scale();switch(stroke){case 8:if(this.is_multiple&&this.backstroke_length<1&&this.choices>0){return this.keydown_backstroke();}else if(!this.pending_backstroke){this.result_clear_highlight();return this.results_search();}
break;case 13:evt.preventDefault();if(this.results_showing){return this.result_select(evt);}
break;case 27:if(this.results_showing){this.results_hide();}
return true;case 9:case 38:case 40:case 16:case 91:case 17:break;default:return this.results_search();}};AbstractChosen.prototype.generate_field_id=function(){var new_id;new_id=this.generate_random_id();this.form_field.id=new_id;return new_id;};AbstractChosen.prototype.generate_random_char=function(){var chars,newchar,rand;chars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";rand=Math.floor(Math.random()*chars.length);return newchar=chars.substring(rand,rand+1);};return AbstractChosen;})();root.AbstractChosen=AbstractChosen;}).call(this);(function(){var $,Chosen,get_side_border_padding,root,__hasProp={}.hasOwnProperty,__extends=function(child,parent){for(var key in parent){if(__hasProp.call(parent,key))child[key]=parent[key];}function ctor(){this.constructor=child;}ctor.prototype=parent.prototype;child.prototype=new ctor;child.__super__=parent.prototype;return child;};root=this;$=jQuery;$.fn.extend({chosen:function(options){if($.browser.msie&&($.browser.version==="6.0"||($.browser.version==="7.0"&&document.documentMode===7))){return this;}
return this.each(function(input_field){var $this;$this=$(this);if(!$this.hasClass("chzn-done")){return $this.data('chosen',new Chosen(this,options));}});}});Chosen=(function(_super){__extends(Chosen,_super);Chosen.name='Chosen';function Chosen(){return Chosen.__super__.constructor.apply(this,arguments);}
Chosen.prototype.setup=function(){this.form_field_jq=$(this.form_field);this.current_value=this.form_field_jq.val();return this.is_rtl=this.form_field_jq.hasClass("chzn-rtl");};Chosen.prototype.finish_setup=function(){return this.form_field_jq.addClass("chzn-done");};Chosen.prototype.set_up_html=function(){var container_div,dd_top,dd_width,rise,sf_width;this.container_id=this.form_field.id.length?this.form_field.id.replace(/(:|\.)/g,'_'):this.generate_field_id();this.container_id+="_chzn";this.f_width=this.form_field_jq.outerWidth();this.default_text=this.form_field_jq.data('placeholder')?this.form_field_jq.data('placeholder'):this.default_text_default;container_div=$("<div />",{id:this.container_id,"class":"chzn-container"+(this.is_rtl?' chzn-rtl':''),style:'width: '+(this.options.width||this.f_width)+'px;'});if(this.is_multiple){container_div.html('<ul class="chzn-choices"><li class="search-field"><input type="text" value="'+this.default_text+'" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chzn-drop" style="left:-9000px;"><ul class="chzn-results"></ul></div>');}else{container_div.html('<a href="javascript:void(0)" class="chzn-single chzn-default" tabindex="-1"><span>'+this.default_text+'</span><div><b></b></div></a><div class="chzn-drop" style="left:-9000px;"><div class="chzn-search"><input type="text" autocomplete="off" /></div><ul class="chzn-results"></ul></div>');}
this.form_field_jq.hide().after(container_div);this.container=$('#'+this.container_id);this.container.addClass("chzn-container-"+(this.is_multiple?"multi":"single"));this.dropdown=this.container.find('div.chzn-drop').first();rise=this.rise_up(this.container,this.dropdown);dd_top=rise?-this.container.find('.chzn-drop').height():this.container.height();dd_width=this.container.width()-get_side_border_padding(this.dropdown);this.dropdown.css({"width":dd_width+"px","top":dd_top+"px"});this.search_field=this.container.find('input').first();this.search_results=this.container.find('ul.chzn-results').first();this.search_field_scale();this.search_no_results=this.container.find('li.no-results').first();if(this.is_multiple){this.search_choices=this.container.find('ul.chzn-choices').first();this.search_container=this.container.find('li.search-field').first();}else{this.search_container=this.container.find('div.chzn-search').first();this.selected_item=this.container.find('.chzn-single').first();sf_width=dd_width-get_side_border_padding(this.search_container)-get_side_border_padding(this.search_field);this.search_field.css({"width":sf_width+"px"});}
this.results_build();this.set_tab_index();return this.form_field_jq.trigger("liszt:ready",{chosen:this});};Chosen.prototype.register_observers=function(){var _this=this;this.container.mousedown(function(evt){return _this.container_mousedown(evt);});this.container.mouseup(function(evt){return _this.container_mouseup(evt);});this.container.mouseenter(function(evt){return _this.mouse_enter(evt);});this.container.mouseleave(function(evt){return _this.mouse_leave(evt);});this.search_results.mouseup(function(evt){return _this.search_results_mouseup(evt);});this.search_results.mouseover(function(evt){return _this.search_results_mouseover(evt);});this.search_results.mouseout(function(evt){return _this.search_results_mouseout(evt);});this.form_field_jq.bind("liszt:updated",function(evt){return _this.results_update_field(evt);});this.form_field_jq.bind("liszt:activate",function(evt){return _this.activate_field(evt);});this.form_field_jq.bind("liszt:open",function(evt){return _this.container_mousedown(evt);});this.search_field.blur(function(evt){return _this.input_blur(evt);});this.search_field.keyup(function(evt){return _this.keyup_checker(evt);});this.search_field.keydown(function(evt){return _this.keydown_checker(evt);});this.search_field.focus(function(evt){return _this.input_focus(evt);});if(this.is_multiple){return this.search_choices.click(function(evt){return _this.choices_click(evt);});}else{return this.container.click(function(evt){return evt.preventDefault();});}};Chosen.prototype.search_field_disabled=function(){this.is_disabled=this.form_field_jq[0].disabled;if(this.is_disabled){this.container.addClass('chzn-disabled');this.search_field[0].disabled=true;if(!this.is_multiple){this.selected_item.unbind("focus",this.activate_action);}
return this.close_field();}else{this.container.removeClass('chzn-disabled');this.search_field[0].disabled=false;if(!this.is_multiple){return this.selected_item.bind("focus",this.activate_action);}}};Chosen.prototype.container_mousedown=function(evt){var target_closelink;if(!this.is_disabled){target_closelink=evt!=null?($(evt.target)).hasClass("search-choice-close"):false;if(evt&&evt.type==="mousedown"&&!this.results_showing){evt.stopPropagation();}
if(!this.pending_destroy_click&&!target_closelink){if(!this.active_field){if(this.is_multiple){this.search_field.val("");}
$(document).click(this.click_test_action);this.results_show();}else if(!this.is_multiple&&evt&&(($(evt.target)[0]===this.selected_item[0])||$(evt.target).parents("a.chzn-single").length)){evt.preventDefault();this.results_toggle();}
return this.activate_field();}else{return this.pending_destroy_click=false;}}};Chosen.prototype.container_mouseup=function(evt){if(evt.target.nodeName==="ABBR"&&!this.is_disabled){return this.results_reset(evt);}};Chosen.prototype.blur_test=function(evt){if(!this.active_field&&this.container.hasClass("chzn-container-active")){return this.close_field();}};Chosen.prototype.close_field=function(){$(document).unbind("click",this.click_test_action);if(!this.is_multiple){this.selected_item.attr("tabindex",this.search_field.attr("tabindex"));this.search_field.attr("tabindex",-1);}
this.active_field=false;this.results_hide();this.container.removeClass("chzn-container-active");this.winnow_results_clear();this.clear_backstroke();this.show_search_field_default();return this.search_field_scale();};Chosen.prototype.activate_field=function(){this.container.addClass("chzn-container-active");this.active_field=true;this.search_field.val(this.search_field.val());return this.search_field.focus();};Chosen.prototype.test_active_click=function(evt){if($(evt.target).parents('#'+this.container_id).length){return this.active_field=true;}else{return this.close_field();}};Chosen.prototype.results_build=function(){var content,data,_i,_len,_ref;this.parsing=true;this.results_data=root.SelectParser.select_to_array(this.form_field);if(this.is_multiple&&this.choices>0){this.search_choices.find("li.search-choice").remove();this.choices=0;}else if(!this.is_multiple){this.selected_item.addClass("chzn-default").find("span").text(this.default_text);if(this.disable_search||this.form_field.options.length<=this.disable_search_threshold){this.container.addClass("chzn-container-single-nosearch");}else{this.container.removeClass("chzn-container-single-nosearch");}}
content='';_ref=this.results_data;for(_i=0,_len=_ref.length;_i<_len;_i++){data=_ref[_i];if(data.group){content+=this.result_add_group(data);}else if(!data.empty){content+=this.result_add_option(data);if(data.selected&&this.is_multiple){this.choice_build(data);}else if(data.selected&&!this.is_multiple){this.selected_item.removeClass("chzn-default").find("span").text(data.text);if(this.allow_single_deselect){this.single_deselect_control_build();}}}}
this.search_field_disabled();this.show_search_field_default();this.search_field_scale();this.search_results.html(content);return this.parsing=false;};Chosen.prototype.result_add_group=function(group){if(!group.disabled){group.dom_id=this.container_id+"_g_"+group.array_index;return'<li id="'+group.dom_id+'" class="group-result">'+$("<div />").text(group.label).html()+'</li>';}else{return"";}};Chosen.prototype.result_do_highlight=function(el){var high_bottom,high_top,maxHeight,visible_bottom,visible_top;if(el.length){this.result_clear_highlight();this.result_highlight=el;this.result_highlight.addClass("highlighted");maxHeight=parseInt(this.search_results.css("maxHeight"),10);visible_top=this.search_results.scrollTop();visible_bottom=maxHeight+visible_top;high_top=this.result_highlight.position().top+this.search_results.scrollTop();high_bottom=high_top+this.result_highlight.outerHeight();if(high_bottom>=visible_bottom){return this.search_results.scrollTop((high_bottom-maxHeight)>0?high_bottom-maxHeight:0);}else if(high_top<visible_top){return this.search_results.scrollTop(high_top);}}};Chosen.prototype.result_clear_highlight=function(){if(this.result_highlight){this.result_highlight.removeClass("highlighted");}
return this.result_highlight=null;};Chosen.prototype.results_show=function(){var dd_top,dd_width,rise;if(!this.is_multiple){this.selected_item.addClass("chzn-single-with-drop");if(this.result_single_selected){this.result_do_highlight(this.result_single_selected);}}
dd_width=this.container.width()-get_side_border_padding(this.dropdown);rise=this.rise_up(this.container,this.dropdown);dd_top=rise?-this.container.find('.chzn-drop').height():this.is_multiple?this.container.height():this.container.height()-1;this.form_field_jq.trigger("liszt:showing_dropdown",{chosen:this});this.dropdown.css({"top":dd_top+"px","left":0});this.results_showing=true;this.search_field.css('width',(dd_width-get_side_border_padding(this.search_container)-get_side_border_padding(this.search_field))+'px');this.search_field.focus();this.search_field.val(this.search_field.val());return this.winnow_results();};Chosen.prototype.results_hide=function(){if(!this.is_multiple){this.selected_item.removeClass("chzn-single-with-drop");}
this.result_clear_highlight();this.form_field_jq.trigger("liszt:hiding_dropdown",{chosen:this});this.dropdown.css({"left":"-9000px"});return this.results_showing=false;};Chosen.prototype.set_tab_index=function(el){var ti;if(this.form_field_jq.attr("tabindex")){ti=this.form_field_jq.attr("tabindex");this.form_field_jq.attr("tabindex",-1);return this.search_field.attr("tabindex",ti);}};Chosen.prototype.show_search_field_default=function(){if(this.is_multiple&&this.choices<1&&!this.active_field){this.search_field.val(this.default_text);return this.search_field.addClass("default");}else{this.search_field.val("");return this.search_field.removeClass("default");}};Chosen.prototype.search_results_mouseup=function(evt){var target;target=$(evt.target).hasClass("active-result")?$(evt.target):$(evt.target).parents(".active-result").first();if(target.length){this.result_highlight=target;this.result_select(evt);return this.search_field.focus();}};Chosen.prototype.search_results_mouseover=function(evt){var target;target=$(evt.target).hasClass("active-result")?$(evt.target):$(evt.target).parents(".active-result").first();if(target){return this.result_do_highlight(target);}};Chosen.prototype.search_results_mouseout=function(evt){if($(evt.target).hasClass("active-result"||$(evt.target).parents('.active-result').first())){return this.result_clear_highlight();}};Chosen.prototype.choices_click=function(evt){evt.preventDefault();if(this.active_field&&!($(evt.target).hasClass("search-choice"||$(evt.target).parents('.search-choice').first))&&!this.results_showing){return this.results_show();}};Chosen.prototype.choice_build=function(item){var choice_id,html,link,_this=this;choice_id=this.container_id+"_c_"+item.array_index;this.choices+=1;if(item.disabled){html='<li class="search-choice search-choice-disabled" id="'+choice_id+'"><span>'+item.html+'</span></li>';}else{html='<li class="search-choice" id="'+choice_id+'"><span>'+item.html+'</span><a href="javascript:void(0)" class="search-choice-close" rel="'+item.array_index+'"></a></li>';}
this.search_container.before(html);link=$('#'+choice_id).find("a").first();return link.click(function(evt){return _this.choice_destroy_link_click(evt);});};Chosen.prototype.choice_destroy_link_click=function(evt){evt.preventDefault();if(!this.is_disabled){this.pending_destroy_click=true;return this.choice_destroy($(evt.target));}else{return evt.stopPropagation;}};Chosen.prototype.choice_destroy=function(link){if(this.result_deselect(link.attr("rel"))){this.choices-=1;this.show_search_field_default();if(this.is_multiple&&this.choices>0&&this.search_field.val().length<1){this.results_hide();}
return link.parents('li').first().remove();}};Chosen.prototype.results_reset=function(){this.form_field.options[0].selected=true;this.selected_item.find("span").text(this.default_text);if(!this.is_multiple){this.selected_item.addClass("chzn-default");}
this.show_search_field_default();this.results_reset_cleanup();this.form_field_jq.trigger("change");if(this.active_field){return this.results_hide();}};Chosen.prototype.results_reset_cleanup=function(){this.current_value=this.form_field_jq.val();return this.selected_item.find("abbr").remove();};Chosen.prototype.result_select=function(evt){var high,high_id,item,position;if(this.result_highlight){high=this.result_highlight;high_id=high.attr("id");this.result_clear_highlight();if(this.is_multiple){this.result_deactivate(high);}else{this.search_results.find(".result-selected").removeClass("result-selected");this.result_single_selected=high;this.selected_item.removeClass("chzn-default");}
high.addClass("result-selected");position=high_id.substr(high_id.lastIndexOf("_")+1);item=this.results_data[position];item.selected=true;this.form_field.options[item.options_index].selected=true;if(this.is_multiple){this.choice_build(item);}else{this.selected_item.find("span").first().text(item.text);if(this.allow_single_deselect){this.single_deselect_control_build();}}
if(!(evt.metaKey&&this.is_multiple)){this.results_hide();}
this.search_field.val("");if(this.is_multiple||this.form_field_jq.val()!==this.current_value){this.form_field_jq.trigger("change",{'selected':this.form_field.options[item.options_index].value});}
this.current_value=this.form_field_jq.val();return this.search_field_scale();}};Chosen.prototype.result_activate=function(el){return el.addClass("active-result");};Chosen.prototype.result_deactivate=function(el){return el.removeClass("active-result");};Chosen.prototype.result_deselect=function(pos){var result,result_data;result_data=this.results_data[pos];if(!this.form_field.options[result_data.options_index].disabled){result_data.selected=false;this.form_field.options[result_data.options_index].selected=false;result=$("#"+this.container_id+"_o_"+pos);result.removeClass("result-selected").addClass("active-result").show();this.result_clear_highlight();this.winnow_results();this.form_field_jq.trigger("change",{deselected:this.form_field.options[result_data.options_index].value});this.search_field_scale();return true;}else{return false;}};Chosen.prototype.single_deselect_control_build=function(){if(this.allow_single_deselect&&this.selected_item.find("abbr").length<1){return this.selected_item.find("span").first().after("<abbr class=\"search-choice-close\"></abbr>");}};Chosen.prototype.winnow_results=function(){var found,option,part,parts,regex,regexAnchor,result,result_id,results,searchText,startpos,text,zregex,_i,_j,_len,_len1,_ref;this.no_results_clear();results=0;searchText=this.search_field.val()===this.default_text?"":$('<div/>').text($.trim(this.search_field.val())).html();regexAnchor=this.search_contains?"":"^";regex=new RegExp(regexAnchor+searchText.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),'i');zregex=new RegExp(searchText.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),'i');_ref=this.results_data;for(_i=0,_len=_ref.length;_i<_len;_i++){option=_ref[_i];if(!option.disabled&&!option.empty){if(option.group){$('#'+option.dom_id).css('display','none');}else if(!(this.is_multiple&&option.selected)){found=false;result_id=option.dom_id;result=$("#"+result_id);if(regex.test(option.html)){found=true;results+=1;}else if(option.html.indexOf(" ")>=0||option.html.indexOf("[")===0){parts=option.html.replace(/\[|\]/g,"").split(" ");if(parts.length){for(_j=0,_len1=parts.length;_j<_len1;_j++){part=parts[_j];if(regex.test(part)){found=true;results+=1;}}}}
if(found){if(searchText.length){startpos=option.html.search(zregex);text=option.html.substr(0,startpos+searchText.length)+'</em>'+option.html.substr(startpos+searchText.length);text=text.substr(0,startpos)+'<em>'+text.substr(startpos);}else{text=option.html;}
result.html(text);this.result_activate(result);if(option.group_array_index!=null){$("#"+this.results_data[option.group_array_index].dom_id).css('display','list-item');}}else{if(this.result_highlight&&result_id===this.result_highlight.attr('id')){this.result_clear_highlight();}
this.result_deactivate(result);}}}}
if(results<1&&searchText.length){return this.no_results(searchText);}else{return this.winnow_results_set_highlight();}};Chosen.prototype.winnow_results_clear=function(){var li,lis,_i,_len,_results;this.search_field.val("");lis=this.search_results.find("li");_results=[];for(_i=0,_len=lis.length;_i<_len;_i++){li=lis[_i];li=$(li);if(li.hasClass("group-result")){_results.push(li.css('display','auto'));}else if(!this.is_multiple||!li.hasClass("result-selected")){_results.push(this.result_activate(li));}else{_results.push(void 0);}}
return _results;};Chosen.prototype.winnow_results_set_highlight=function(){var do_high,selected_results;if(!this.result_highlight){selected_results=!this.is_multiple?this.search_results.find(".result-selected.active-result"):[];do_high=selected_results.length?selected_results.first():this.search_results.find(".active-result").first();if(do_high!=null){return this.result_do_highlight(do_high);}}};Chosen.prototype.no_results=function(terms){var no_results_html;no_results_html=$('<li class="no-results">'+this.results_none_found+' "<span></span>"</li>');no_results_html.find("span").first().html(terms);return this.search_results.append(no_results_html);};Chosen.prototype.no_results_clear=function(){return this.search_results.find(".no-results").remove();};Chosen.prototype.keydown_arrow=function(){var first_active,next_sib;if(!this.result_highlight){first_active=this.search_results.find("li.active-result").first();if(first_active){this.result_do_highlight($(first_active));}}else if(this.results_showing){next_sib=this.result_highlight.nextAll("li.active-result").first();if(next_sib){this.result_do_highlight(next_sib);}}
if(!this.results_showing){return this.results_show();}};Chosen.prototype.keyup_arrow=function(){var prev_sibs;if(!this.results_showing&&!this.is_multiple){return this.results_show();}else if(this.result_highlight){prev_sibs=this.result_highlight.prevAll("li.active-result");if(prev_sibs.length){return this.result_do_highlight(prev_sibs.first());}else{if(this.choices>0){this.results_hide();}
return this.result_clear_highlight();}}};Chosen.prototype.keydown_backstroke=function(){var next_available_destroy;if(this.pending_backstroke){this.choice_destroy(this.pending_backstroke.find("a").first());return this.clear_backstroke();}else{next_available_destroy=this.search_container.siblings("li.search-choice").last();if(next_available_destroy.length&&!next_available_destroy.hasClass("search-choice-disabled")){this.pending_backstroke=next_available_destroy;if(this.single_backstroke_delete){return this.keydown_backstroke();}else{return this.pending_backstroke.addClass("search-choice-focus");}}}};Chosen.prototype.clear_backstroke=function(){if(this.pending_backstroke){this.pending_backstroke.removeClass("search-choice-focus");}
return this.pending_backstroke=null;};Chosen.prototype.keydown_checker=function(evt){var stroke,_ref;stroke=(_ref=evt.which)!=null?_ref:evt.keyCode;this.search_field_scale();if(stroke!==8&&this.pending_backstroke){this.clear_backstroke();}
switch(stroke){case 8:this.backstroke_length=this.search_field.val().length;break;case 9:if(this.results_showing&&!this.is_multiple){this.result_select(evt);}
this.mouse_on_container=false;break;case 13:evt.preventDefault();break;case 38:evt.preventDefault();this.keyup_arrow();break;case 40:this.keydown_arrow();break;}};Chosen.prototype.search_field_scale=function(){var dd_top,div,h,rise,style,style_block,styles,w,_i,_len;if(this.is_multiple){h=0;w=0;style_block="position:absolute; left: -1000px; top: -1000px; display:none;";styles=['font-size','font-style','font-weight','font-family','line-height','text-transform','letter-spacing'];for(_i=0,_len=styles.length;_i<_len;_i++){style=styles[_i];style_block+=style+":"+this.search_field.css(style)+";";}
div=$('<div />',{'style':style_block});div.text(this.search_field.val());$('body').append(div);w=div.width()+25;div.remove();if(w>this.f_width-10){w=this.f_width-10;}
this.search_field.css({'width':w+'px'});rise=this.rise_up(this.container,this.dropdown);dd_top=rise?-this.container.find('.chzn-drop').height():this.container.height();return this.dropdown.css({"top":dd_top+"px"});}};Chosen.prototype.generate_random_id=function(){var string;string="sel"+this.generate_random_char()+this.generate_random_char()+this.generate_random_char();while($("#"+string).length>0){string+=this.generate_random_char();}
return string;};Chosen.prototype.rise_up=function(container,dropdown){var elHeight,elPos,endOfWindow,trigger;trigger=container.find('a.chzn-single');if(trigger.length>0){endOfWindow=($(window).height()+$(document).scrollTop())-container.find('a').innerHeight();elPos=trigger.offset().top;elHeight=dropdown.innerHeight();if(elPos+elHeight>endOfWindow&&elPos-elHeight>0){container.addClass('chzn-with-rise');return true;}else{container.removeClass('chzn-with-rise');return false;}}else{return false;}};return Chosen;})(AbstractChosen);get_side_border_padding=function(elmt){var side_border_padding;return side_border_padding=elmt.outerWidth()-elmt.width();};root.get_side_border_padding=get_side_border_padding;}).call(this);;

/****** FILE: framework/admin/thirdparty/jquery-hoverIntent/jquery.hoverIntent.js *****/

(function($){$.fn.hoverIntent=function(f,g){var cfg={sensitivity:7,interval:100,timeout:350};cfg=$.extend(cfg,g?{over:f,out:g}:f);var cX,cY,pX,pY;var track=function(ev){cX=ev.pageX;cY=ev.pageY;};var compare=function(ev,ob){ob.hoverIntent_t=clearTimeout(ob.hoverIntent_t);if((Math.abs(pX-cX)+Math.abs(pY-cY))<cfg.sensitivity){$(ob).unbind("mousemove",track);ob.hoverIntent_s=1;return cfg.over.apply(ob,[ev]);}else{pX=cX;pY=cY;ob.hoverIntent_t=setTimeout(function(){compare(ev,ob);},cfg.interval);}};var delay=function(ev,ob){ob.hoverIntent_t=clearTimeout(ob.hoverIntent_t);ob.hoverIntent_s=0;return cfg.out.apply(ob,[ev]);};var handleHover=function(e){var ev=jQuery.extend({},e);var ob=this;if(ob.hoverIntent_t){ob.hoverIntent_t=clearTimeout(ob.hoverIntent_t);}
if(e.type=="mouseenter"){pX=ev.pageX;pY=ev.pageY;$(ob).bind("mousemove",track);if(ob.hoverIntent_s!=1){ob.hoverIntent_t=setTimeout(function(){compare(ev,ob);},cfg.interval);}}else{$(ob).unbind("mousemove",track);if(ob.hoverIntent_s==1){ob.hoverIntent_t=setTimeout(function(){delay(ev,ob);},cfg.timeout);}}};return this.bind('mouseenter',handleHover).bind('mouseleave',handleHover);};})(jQuery);;

/****** FILE: framework/admin/javascript/jquery-changetracker/lib/jquery.changetracker.js *****/

(function($){$.fn.changetracker=function(_options){var self=this;if(this.length>1){this.each(function(i,item){this.changetracker(_options);});return this;}
this.defaults={fieldSelector:':input:not(:submit)',ignoreFieldSelector:"",changedCssClass:'changed'};var options=$.extend({},this.defaults,_options);this.initialize=function(){if($.meta)options=$.extend({},options,this.data());var dirty=false;var onchange=function(e){var $field=$(e.target);var origVal=$field.data('changetracker.origVal'),newVal;if($field.is(':checkbox')){newVal=$field.is(':checked')?1:0;}else{newVal=$field.val();}
if(origVal===null||newVal!=origVal){$field.addClass(options.changedCssClass);self.addClass(options.changedCssClass);}else{$field.removeClass(options.changedCssClass);if($field.is(':radio')){self.find(':radio[name='+$field.attr('name')+']').removeClass(options.changedCssClass);}
if(!dirty&&!self.getFields().filter('.'+options.changedCssClass).length){self.removeClass(options.changedCssClass);}}};var fields=this.getFields(),origVal;fields.filter(':radio,:checkbox').bind('click.changetracker',onchange);fields.not(':radio,:checkbox').bind('change.changetracker',onchange);fields.each(function(){if($(this).is(':radio,:checkbox')){origVal=self.find(':input[name='+$(this).attr('name')+']:checked').val();}else{origVal=$(this).val();}
$(this).data('changetracker.origVal',origVal);});self.bind('dirty.changetracker',function(){dirty=true;self.addClass(options.changedCssClass);});this.data('changetracker',true);};this.destroy=function(){this.getFields().unbind('.changetracker').removeClass(options.changedCssClass).removeData('changetracker.origVal');this.unbind('.changetracker').removeData('changetracker');};this.reset=function(){this.getFields().each(function(){self.resetField(this);});this.removeClass(options.changedCssClass);};this.resetField=function(field){return $(field).removeData('changetracker.origVal').removeClass('changed');};this.getFields=function(){return this.find(options.fieldSelector).not(options.ignoreFieldSelector);};if(typeof arguments[0]==='string'){var property=arguments[1];var args=Array.prototype.slice.call(arguments);args.splice(0,1);return this[arguments[0]].apply(this,args);}else{return this.initialize();}};}(jQuery));;

/****** FILE: framework/javascript/i18n.js *****/

if(typeof(ss)=='undefined')ss={};ss.i18n={currentLocale:null,defaultLocale:'en_US',lang:{},inited:false,init:function(){if(this.inited)return;this.currentLocale=this.detectLocale();this.inited=true;},setLocale:function(locale){this.currentLocale=locale;},getLocale:function(){return(this.currentLocale)?this.currentLocale:this.defaultLocale;},_t:function(entity,fallbackString,priority,context){this.init();var langName=this.getLocale().replace(/_[\w]+/i,'');if(this.lang&&this.lang[this.getLocale()]&&this.lang[this.getLocale()][entity]){return this.lang[this.getLocale()][entity];}else if(this.lang&&this.lang[langName]&&this.lang[langName][entity]){return this.lang[langName][entity];}else if(this.lang&&this.lang[this.defaultLocale]&&this.lang[this.defaultLocale][entity]){return this.lang[this.defaultLocale][entity];}else if(fallbackString){return fallbackString;}else{return'';}},addDictionary:function(locale,dict){if(!this.lang[locale])this.lang[locale]={};for(entity in dict){this.lang[locale][entity]=dict[entity];}},getDictionary:function(locale){return this.lang[locale];},stripStr:function(str){return str.replace(/^\s*/,"").replace(/\s*$/,"");},stripStrML:function(str){var parts=str.split('\n');for(var i=0;i<parts.length;i++)
parts[i]=stripStr(parts[i]);return stripStr(parts.join(" "));},sprintf:function(S){if(arguments.length==1)return S;var nS="";var tS=S.split("%s");var args=[];for(var i=1,len=arguments.length;i<len;++i){args.push(arguments[i]);};for(var i=0;i<args.length;i++){if(tS[i].lastIndexOf('%')==tS[i].length-1&&i!=args.length-1)
tS[i]+="s"+tS.splice(i+1,1)[0];nS+=tS[i]+args[i];}
return nS+tS[tS.length-1];},detectLocale:function(){var rawLocale;var detectedLocale;rawLocale=jQuery('body').attr('lang');if(!rawLocale){var metas=document.getElementsByTagName('meta');for(var i=0;i<metas.length;i++){if(metas[i].attributes['http-equiv']&&metas[i].attributes['http-equiv'].nodeValue.toLowerCase()=='content-language'){rawLocale=metas[i].attributes['content'].nodeValue;}}}
if(!rawLocale)rawLocale=this.defaultLocale;var rawLocaleParts=rawLocale.match(/([^-|_]*)[-|_](.*)/);if(rawLocale.length==2){for(compareLocale in ss.i18n.lang){if(compareLocale.substr(0,2).toLowerCase()==rawLocale.toLowerCase()){detectedLocale=compareLocale;break;}}}else if(rawLocaleParts){detectedLocale=rawLocaleParts[1].toLowerCase()+'_'+rawLocaleParts[2].toUpperCase();}
return detectedLocale;},addEvent:function(obj,evType,fn,useCapture){if(obj.addEventListener){obj.addEventListener(evType,fn,useCapture);return true;}else if(obj.attachEvent){var r=obj.attachEvent("on"+evType,fn);return r;}else{alert("Handler could not be attached");}}};ss.i18n.addEvent(window,"load",function(){ss.i18n.init();});;

/****** FILE: framework/javascript/TreeDropdownField.js *****/

(function($){$.entwine('ss',function($){var windowWidth,windowHeight;$(window).bind('resize.treedropdownfield',function(){var cb=function(){$('.TreeDropdownField').closePanel();};if($.browser.msie&&parseInt($.browser.version,10)<9){var newWindowWidth=$(window).width(),newWindowHeight=$(window).height();if(newWindowWidth!=windowWidth||newWindowHeight!=windowHeight){windowWidth=newWindowWidth;windowHeight=newWindowHeight;cb();}}else{cb();}});var strings={'openlink':ss.i18n._t('TreeDropdownField.OpenLink'),'fieldTitle':'('+ss.i18n._t('TreeDropdownField.FieldTitle')+')','searchFieldTitle':'('+ss.i18n._t('TreeDropdownField.SearchFieldTitle')+')'};var _clickTestFn=function(e){if(!$(e.target).parents('.TreeDropdownField').length)$('.TreeDropdownField').closePanel();};$('.TreeDropdownField').entwine({CurrentXhr:null,onadd:function(){this.append('<span class="treedropdownfield-title"></span>'+'<div class="treedropdownfield-toggle-panel-link"><a href="#" class="ui-icon ui-icon-triangle-1-s"></a></div>'+'<div class="treedropdownfield-panel"><div class="tree-holder"></div></div>');var linkTitle=strings.openLink;if(linkTitle)this.find("treedropdownfield-toggle-panel-link a").attr('title',linkTitle);if(this.data('title'))this.setTitle(decodeURIComponent(this.data('title')));this.getPanel().hide();this._super();},getPanel:function(){return this.find('.treedropdownfield-panel');},openPanel:function(){$('.TreeDropdownField').closePanel();$('body').bind('click',_clickTestFn);var panel=this.getPanel(),tree=this.find('.tree-holder');panel.css('width',this.width());panel.show();var toggle=this.find(".treedropdownfield-toggle-panel-link");toggle.addClass('treedropdownfield-open-tree');this.addClass("treedropdownfield-open-tree");toggle.find("a").removeClass('ui-icon-triangle-1-s').addClass('ui-icon-triangle-1-n');if(tree.is(':empty')&&!panel.hasClass('loading')){this.loadTree(null,this._riseUp);}else{this._riseUp();}
this.trigger('panelshow');},_riseUp:function(){var container=this,dropdown=this.getPanel(),toggle=this.find(".treedropdownfield-toggle-panel-link"),offsetTop=toggle.innerHeight(),elHeight,elPos,endOfWindow;if(toggle.length>0){endOfWindow=($(window).height()+$(document).scrollTop())-toggle.innerHeight();elPos=toggle.offset().top;elHeight=dropdown.innerHeight();if(elPos+elHeight>endOfWindow&&elPos-elHeight>0){container.addClass('treedropdownfield-with-rise');offsetTop=-dropdown.outerHeight();}else{container.removeClass('treedropdownfield-with-rise');}}
dropdown.css({"top":offsetTop+"px"});},closePanel:function(){jQuery('body').unbind('click',_clickTestFn);var toggle=this.find(".treedropdownfield-toggle-panel-link");toggle.removeClass('treedropdownfield-open-tree');this.removeClass('treedropdownfield-open-tree treedropdownfield-with-rise');toggle.find("a").removeClass('ui-icon-triangle-1-n').addClass('ui-icon-triangle-1-s');this.getPanel().hide();this.trigger('panelhide');},togglePanel:function(){this[this.getPanel().is(':visible')?'closePanel':'openPanel']();},setTitle:function(title){if(!title)title=strings.fieldTitle;this.find('.treedropdownfield-title').html(title);this.data('title',encodeURIComponent(title));},getTitle:function(){return this.find('.treedropdownfield-title').text();},updateTitle:function(){var self=this,tree=self.find('.tree-holder'),val=this.getValue();var updateFn=function(){var val=self.getValue();if(val){var node=tree.find('*[data-id="'+val+'"]'),title=node.children('a').find("span.jstree_pageicon")?node.children('a').find("span.item").html():null;if(!title)title=(node.length>0)?tree.jstree('get_text',node[0]):null;if(title){self.setTitle(title);self.data('title',title)}
if(node)tree.jstree('select_node',node);}};if(!tree.is(':empty')||!val)updateFn();else this.loadTree({forceValue:val},updateFn);},setValue:function(val){this.data('metadata',$.extend(this.data('metadata'),{id:val}));this.find(':input:hidden').val(val).trigger('change');},getValue:function(){return this.find(':input:hidden').val();},loadTree:function(params,callback){var self=this,panel=this.getPanel(),treeHolder=$(panel).find('.tree-holder'),params=(params)?$.extend({},this.getRequestParams(),params):this.getRequestParams(),xhr;if(this.getCurrentXhr())this.getCurrentXhr().abort();panel.addClass('loading');xhr=$.ajax({url:this.data('urlTree'),data:params,complete:function(xhr,status){panel.removeClass('loading');},success:function(html,status,xhr){treeHolder.html(html);var firstLoad=true;treeHolder.jstree('destroy').bind('loaded.jstree',function(e,data){var val=self.getValue(),selectNode=treeHolder.find('*[data-id="'+val+'"]'),currentNode=data.inst.get_selected();if(val&&selectNode!=currentNode)data.inst.select_node(selectNode);firstLoad=false;if(callback)callback.apply(self);}).jstree(self.getTreeConfig()).bind('select_node.jstree',function(e,data){var node=data.rslt.obj,id=$(node).data('id');if(!firstLoad&&self.getValue()==id){self.data('metadata',null);self.setTitle(null);self.setValue(null);data.inst.deselect_node(node);}else{self.data('metadata',$.extend({id:id},$(node).getMetaData()));self.setTitle(data.inst.get_text(node));self.setValue(id);}
if(!firstLoad)self.closePanel();firstLoad=false;});self.setCurrentXhr(null);}});this.setCurrentXhr(xhr);},getTreeConfig:function(){var self=this;return{'core':{'animation':0},'html_data':{'data':this.getPanel().find('.tree-holder').html(),'ajax':{'url':function(node){var url=$.path.parseUrl(self.data('urlTree')).hrefNoSearch;return url+'/'+($(node).data("id")?$(node).data("id"):0);},'data':function(node){var query=$.query.load(self.data('urlTree')).keys;var params=self.getRequestParams();params=$.extend({},query,params,{ajax:1});return params;}}},'ui':{"select_limit":1,'initially_select':[this.getPanel().find('.current').attr('id')]},'themes':{'theme':'apple'},'types':{'types':{'default':{'check_node':function(node){return(!node.hasClass('disabled'));},'uncheck_node':function(node){return(!node.hasClass('disabled'));},'select_node':function(node){return(!node.hasClass('disabled'));},'deselect_node':function(node){return(!node.hasClass('disabled'));}}}},'plugins':['html_data','ui','themes','types']};},getRequestParams:function(){return{};}});$('.TreeDropdownField .tree-holder li').entwine({getMetaData:function(){var matches=this.attr('class').match(/class-([^\s]*)/i);var klass=matches?matches[1]:'';return{ClassName:klass};}});$('.TreeDropdownField *').entwine({getField:function(){return this.parents('.TreeDropdownField:first');}});$('.TreeDropdownField').entwine({onclick:function(e){this.togglePanel();return false;}});$('.TreeDropdownField .treedropdownfield-panel').entwine({onclick:function(e){return false;}});$('.TreeDropdownField.searchable').entwine({onadd:function(){this._super();var title=ss.i18n._t('TreeDropdownField.ENTERTOSEARCH');this.find('.treedropdownfield-panel').prepend($('<input type="text" class="search treedropdownfield-search" data-skip-autofocus="true" placeholder="'+title+'" value="" />'));},search:function(str,callback){this.openPanel();this.loadTree({search:str},callback);},cancelSearch:function(){this.closePanel();this.loadTree();}});$('.TreeDropdownField.searchable input.search').entwine({onkeydown:function(e){var field=this.getField();if(e.keyCode==13){field.search(this.val());return false;}else if(e.keyCode==27){field.cancelSearch();}}});$('.TreeDropdownField.multiple').entwine({getTreeConfig:function(){var cfg=this._super();cfg.checkbox={override_ui:true,two_state:true};cfg.plugins.push('checkbox');cfg.ui.select_limit=-1;return cfg;},loadTree:function(params,callback){var self=this,panel=this.getPanel(),treeHolder=$(panel).find('.tree-holder');var params=(params)?$.extend({},this.getRequestParams(),params):this.getRequestParams(),xhr;if(this.getCurrentXhr())this.getCurrentXhr().abort();panel.addClass('loading');xhr=$.ajax({url:this.data('urlTree'),data:params,complete:function(xhr,status){panel.removeClass('loading');},success:function(html,status,xhr){treeHolder.html(html);var firstLoad=true;self.setCurrentXhr(null);treeHolder.jstree('destroy').bind('loaded.jstree',function(e,data){$.each(self.getValue(),function(i,val){data.inst.check_node(treeHolder.find('*[data-id='+val+']'));});firstLoad=false;if(callback)callback.apply(self);}).jstree(self.getTreeConfig()).bind('uncheck_node.jstree check_node.jstree',function(e,data){var nodes=data.inst.get_checked(null,true);self.setValue($.map(nodes,function(el,i){return $(el).data('id');}));self.setTitle($.map(nodes,function(el,i){return data.inst.get_text(el);}));self.data('metadata',$.map(nodes,function(el,i){return{id:$(el).data('id'),metadata:$(el).getMetaData()};}));});}});this.setCurrentXhr(xhr);},getValue:function(){var val=this._super();return val.split(/ *, */);},setValue:function(val){this._super($.isArray(val)?val.join(','):val);},setTitle:function(title){this._super($.isArray(title)?title.join(', '):title);},updateTitle:function(){}});$('.TreeDropdownField input[type=hidden]').entwine({onadd:function(){this.bind('change.TreeDropdownField',function(){$(this).getField().updateTitle();});},onremove:function(){this.unbind('.TreeDropdownField');}});});}(jQuery));;

/****** FILE: framework/javascript/DateField.js *****/

(function($){$.fn.extend({ssDatepicker:function(opts){return $(this).each(function(){if($(this).data('datepicker'))return;$(this).siblings("button").addClass("ui-icon ui-icon-calendar");var holder=$(this).parents('.field.date:first'),config=$.extend(opts||{},$(this).data(),$(this).data('jqueryuiconfig'),{});if(!config.showcalendar)return;if(config.locale&&$.datepicker.regional[config.locale]){config=$.extend(config,$.datepicker.regional[config.locale],{});}
if(config.min)config.minDate=$.datepicker.parseDate('yy-mm-dd',config.min);if(config.max)config.maxDate=$.datepicker.parseDate('yy-mm-dd',config.max);config.dateFormat=config.jquerydateformat;$(this).datepicker(config);});}});$(document).on("click",".field.date input.text,.fieldholder-small input.text.date",function(){$(this).ssDatepicker();if($(this).data('datepicker')){$(this).datepicker('show');}});}(jQuery));;

/****** FILE: framework/javascript/HtmlEditorField.js *****/

var ss=ss||{};ss.editorWrappers={};ss.editorWrappers.tinyMCE=(function(){var instance;return{init:function(config){if(!ss.editorWrappers.tinyMCE.initialized){tinyMCE.init(config);ss.editorWrappers.tinyMCE.initialized=true;}},getInstance:function(){return this.instance;},onopen:function(){},onclose:function(){},save:function(){tinyMCE.triggerSave();},create:function(domID,config){this.instance=new tinymce.Editor(domID,config);this.instance.onInit.add(function(ed){if(!ss.editorWrappers.tinyMCE.patched){var originalDestroy=tinymce.themes.AdvancedTheme.prototype.destroy;tinymce.themes.AdvancedTheme.prototype.destroy=function(){originalDestroy.apply(this,arguments);if(this.statusKeyboardNavigation){this.statusKeyboardNavigation.destroy();this.statusKeyboardNavigation=null;}}
ss.editorWrappers.tinyMCE.patched=true;}
jQuery(ed.getElement()).trigger('editorinit');var interval;jQuery(ed.getBody()).on('focus',function(){interval=setInterval(function(){ed.save();},5000);});jQuery(ed.getBody()).on('blur',function(){clearInterval(interval);});});this.instance.onChange.add(function(ed,l){ed.save();jQuery(ed.getElement()).trigger('change');});this.instance.render();},repaint:function(){tinyMCE.execCommand("mceRepaint");},isDirty:function(){return this.getInstance().isDirty();},getContent:function(){return this.getInstance().getContent();},getDOM:function(){return this.getInstance().dom;},getContainer:function(){return this.getInstance().getContainer();},getSelectedNode:function(){return this.getInstance().selection.getNode();},selectNode:function(node){this.getInstance().selection.select(node);},setContent:function(html,opts){this.getInstance().execCommand('mceSetContent',false,html,opts);},insertContent:function(html,opts){this.getInstance().execCommand('mceInsertContent',false,html,opts);},replaceContent:function(html,opts){this.getInstance().execCommand('mceReplaceContent',false,html,opts);},insertLink:function(attrs,opts){this.getInstance().execCommand("mceInsertLink",false,attrs,opts);},removeLink:function(){this.getInstance().execCommand('unlink',false);},cleanLink:function(href,node){var cb=tinyMCE.settings['urlconverter_callback'];if(cb)href=eval(cb+"(href, node, true);");if(href.match(new RegExp('^'+tinyMCE.settings['document_base_url']+'(.*)$'))){href=RegExp.$1;}
if(href.match(/^javascript:\s*mctmp/))href='';return href;},createBookmark:function(){return this.getInstance().selection.getBookmark();},moveToBookmark:function(bookmark){this.getInstance().selection.moveToBookmark(bookmark);this.getInstance().focus();},blur:function(){this.getInstance().selection.collapse();},addUndo:function(){this.getInstance().undoManager.add();}};});ss.editorWrappers['default']=ss.editorWrappers.tinyMCE;(function($){$.entwine('ss',function($){$('textarea.htmleditor').entwine({Editor:null,onadd:function(){var edClass=this.data('editor')||'default',ed=ss.editorWrappers[edClass]();this.setEditor(ed);if(typeof ssTinyMceConfig!='undefined')this.redraw();this._super();},onremove:function(){var ed=tinyMCE.get(this.attr('id'));if(ed){ed.remove();ed.destroy();$.each(jQuery.cache,function(){var source=this.handle&&this.handle.elem;if(!source)return;var parent=source;while(parent&&parent.nodeType==1)parent=parent.parentNode;if(!parent)$(source).unbind().remove();});}
this._super();},getContainingForm:function(){return this.closest('form');},fromWindow:{onload:function(){this.redraw();}},redraw:function(){var config=ssTinyMceConfig,self=this,ed=this.getEditor();ed.init(config);ed.create(this.attr('id'),config);this._super();},'from .cms-edit-form':{onbeforesubmitform:function(e){this.getEditor().save();this._super();}},oneditorinit:function(){var redrawObj=$(this.getEditor().getInstance().getContainer());setTimeout(function(){redrawObj.show();},10);},'from .cms-container':{onbeforestatechange:function(){this.css('visibility','hidden');var ed=this.getEditor(),container=(ed&&ed.getInstance())?ed.getContainer():null;if(container&&container.length)container.remove();}},isChanged:function(){var ed=this.getEditor();return(ed&&ed.getInstance()&&ed.isDirty());},resetChanged:function(){var ed=this.getEditor();if(typeof tinyMCE=='undefined')return;var inst=tinyMCE.getInstanceById(this.attr('id'));if(inst)inst.startContent=tinymce.trim(inst.getContent({format:'raw',no_events:1}));},openLinkDialog:function(){this.openDialog('link');},openMediaDialog:function(){this.openDialog('media');},openDialog:function(type){var capitalize=function(text){return text.charAt(0).toUpperCase()+text.slice(1).toLowerCase();};var self=this,url=$('#cms-editor-dialogs').data('url'+capitalize(type)+'form'),dialog=$('.htmleditorfield-'+type+'dialog');if(dialog.length){dialog.getForm().setElement(this);dialog.open();}else{dialog=$('<div class="htmleditorfield-dialog htmleditorfield-'+type+'dialog loading">');$('body').append(dialog);$.ajax({url:url,complete:function(){dialog.removeClass('loading');},success:function(html){dialog.html(html);dialog.getForm().setElement(self);dialog.trigger('ssdialogopen');}});}}});$('.htmleditorfield-dialog').entwine({onadd:function(){if(!this.is('.ui-dialog-content')){this.ssdialog({autoOpen:true});}
this._super();},getForm:function(){return this.find('form');},open:function(){this.ssdialog('open');},close:function(){this.ssdialog('close');},toggle:function(bool){if(this.is(':visible'))this.close();else this.open();}});$('form.htmleditorfield-form').entwine({Selection:null,Bookmark:null,Element:null,setSelection:function(node){return this._super($(node));},onadd:function(){var titleEl=this.find(':header:first');this.getDialog().attr('title',titleEl.text());this._super();},onremove:function(){this.setSelection(null);this.setBookmark(null);this.setElement(null);this._super();},getDialog:function(){return this.closest('.htmleditorfield-dialog');},fromDialog:{onssdialogopen:function(){var ed=this.getEditor();ed.onopen();this.setSelection(ed.getSelectedNode());this.setBookmark(ed.createBookmark());ed.blur();this.find(':input:not(:submit)[data-skip-autofocus!="true"]').filter(':visible:enabled').eq(0).focus();this.updateFromEditor();this.redraw();},onssdialogclose:function(){var ed=this.getEditor();ed.onclose();ed.moveToBookmark(this.getBookmark());this.setSelection(null);this.setBookmark(null);this.resetFields();}},getEditor:function(){return this.getElement().getEditor();},modifySelection:function(callback){var ed=this.getEditor();ed.moveToBookmark(this.getBookmark());callback.call(this,ed);this.setSelection(ed.getSelectedNode());this.setBookmark(ed.createBookmark());ed.blur();},updateFromEditor:function(){},redraw:function(){},resetFields:function(){this.find('.tree-holder').empty();}});$('form.htmleditorfield-linkform').entwine({onsubmit:function(e){this.insertLink();this.getDialog().close();return false;},resetFields:function(){this._super();this[0].reset();},redraw:function(){this._super();var linkType=this.find(':input[name=LinkType]:checked').val(),list=['internal','external','file','email'];this.addAnchorSelector();this.find('div.content .field').hide();this.find('.field#LinkType').show();this.find('.field#'+linkType).show();if(linkType=='internal'||linkType=='anchor')this.find('.field#Anchor').show();if(linkType!=='email')this.find('.field#TargetBlank').show();if(linkType=='anchor'){this.find('.field#AnchorSelector').show();this.find('.field#AnchorRefresh').show();}
this.find('.field#Description').show();},getLinkAttributes:function(){var href,target=null,anchor=this.find(':input[name=Anchor]').val();if(this.find(':input[name=TargetBlank]').is(':checked'))target='_blank';switch(this.find(':input[name=LinkType]:checked').val()){case'internal':href='[sitetree_link,id='+this.find(':input[name=internal]').val()+']';if(anchor)href+='#'+anchor;break;case'anchor':href='#'+anchor;break;case'file':href='[file_link,id='+this.find(':input[name=file]').val()+']';target='_blank';break;case'email':href='mailto:'+this.find(':input[name=email]').val();target=null;break;default:href=this.find(':input[name=external]').val();if(href.indexOf('://')==-1)href='http://'+href;break;}
return{href:href,target:target,title:this.find(':input[name=Description]').val()};},insertLink:function(){this.modifySelection(function(ed){ed.insertLink(this.getLinkAttributes());});this.updateFromEditor();},removeLink:function(){this.modifySelection(function(ed){ed.removeLink();});this.close();},addAnchorSelector:function(){if(this.find(':input[name=AnchorSelector]').length)return;var self=this,anchorSelector;if(!$.browser.ie){anchorSelector=$('<select id="Form_EditorToolbarLinkForm_AnchorSelector" name="AnchorSelector"></select>');this.find(':input[name=Anchor]').parent().append(anchorSelector);anchorSelector.focus(function(e){self.refreshAnchors();});}else{var buttonRefresh=$('<a id="Form_EditorToolbarLinkForm_AnchorRefresh" title="Refresh the anchor list" alt="Refresh the anchor list" class="buttonRefresh"><span></span></a>');anchorSelector=$('<select id="Form_EditorToolbarLinkForm_AnchorSelector" class="hasRefreshButton" name="AnchorSelector"></select>');this.find(':input[name=Anchor]').parent().append(buttonRefresh).append(anchorSelector);buttonRefresh.click(function(e){self.refreshAnchors();});}
self.refreshAnchors();anchorSelector.change(function(e){self.find(':input[name="Anchor"]').val($(this).val());});},refreshAnchors:function(){var selector=this.find(':input[name=AnchorSelector]'),anchors=[],ed=this.getEditor();if(ed){var raw=ed.getContent().match(/name="([^"]+?)"|name='([^']+?)'/gim);if(raw&&raw.length){for(var i=0;i<raw.length;i++){anchors.push(raw[i].substr(6).replace(/"$/,''));}}}
selector.empty();selector.append($('<option value="" selected="1">'+
ss.i18n._t('HtmlEditorField.SelectAnchor')+'</option>'));for(var j=0;j<anchors.length;j++){selector.append($('<option value="'+anchors[j]+'">'+anchors[j]+'</option>'));}},updateFromEditor:function(){var htmlTagPattern=/<\S[^><]*>/g,fieldName,data=this.getCurrentLink();if(data){for(fieldName in data){var el=this.find(':input[name='+fieldName+']'),selected=data[fieldName];if(typeof(selected)=='string')selected=selected.replace(htmlTagPattern,'');if(el.is(':checkbox')){el.prop('checked',selected).change();}else if(el.is(':radio')){el.val([selected]).change();}else{el.val(selected).change();}}}},getCurrentLink:function(){var selectedEl=this.getSelection(),href="",target="",title="",action="insert",style_class="";var linkDataSource=null;if(selectedEl.length){if(selectedEl.is('a')){linkDataSource=selectedEl;}else{linkDataSource=selectedEl=selectedEl.parents('a:first');}}
if(linkDataSource&&linkDataSource.length)this.modifySelection(function(ed){ed.selectNode(linkDataSource[0]);});if(!linkDataSource.attr('href'))linkDataSource=null;if(linkDataSource){href=linkDataSource.attr('href');target=linkDataSource.attr('target');title=linkDataSource.attr('title');style_class=linkDataSource.attr('class');href=this.getEditor().cleanLink(href,linkDataSource);action="update";}
if(href.match(/^mailto:(.*)$/)){return{LinkType:'email',email:RegExp.$1,Description:title};}else if(href.match(/^(assets\/.*)$/)||href.match(/^\[file_link\s*(?:\s*|%20|,)?id=([0-9]+)\]?(#.*)?$/)){return{LinkType:'file',file:RegExp.$1,Description:title,TargetBlank:target?true:false};}else if(href.match(/^#(.*)$/)){return{LinkType:'anchor',Anchor:RegExp.$1,Description:title,TargetBlank:target?true:false};}else if(href.match(/^\[sitetree_link(?:\s*|%20|,)?id=([0-9]+)\]?(#.*)?$/i)){return{LinkType:'internal',internal:RegExp.$1,Anchor:RegExp.$2?RegExp.$2.substr(1):'',Description:title,TargetBlank:target?true:false};}else if(href){return{LinkType:'external',external:href,Description:title,TargetBlank:target?true:false};}else{return null;}}});$('form.htmleditorfield-linkform input[name=LinkType]').entwine({onclick:function(e){this.parents('form:first').redraw();},onchange:function(){this.parents('form:first').redraw();}});$('form.htmleditorfield-linkform :submit[name=action_remove]').entwine({onclick:function(e){this.parents('form:first').removeLink();return false;}});$('form.htmleditorfield-mediaform').entwine({toggleCloseButton:function(){var updateExisting=Boolean(this.find('.ss-htmleditorfield-file').length);this.find('.overview .action-delete')[updateExisting?'hide':'show']();},onsubmit:function(){this.modifySelection(function(ed){this.find('.ss-htmleditorfield-file').each(function(){$(this).insertHTML(ed);});ed.repaint();});this.getDialog().close();return false;},updateFromEditor:function(){var self=this,node=this.getSelection();if(node.is('img')){this.showFileView(node.data('url')||node.attr('src')).done(function(filefield){filefield.updateFromNode(node);self.toggleCloseButton();self.redraw();});}
this.redraw();},redraw:function(updateExisting){this._super();var node=this.getSelection(),hasItems=Boolean(this.find('.ss-htmleditorfield-file').length),editingSelected=node.is('img'),header=this.find('.header-edit');header[(hasItems)?'show':'hide']();this.find('.Actions :submit').button(hasItems?'enable':'disable').toggleClass('ui-state-disabled',!hasItems);this.find('#MediaFormInsertMediaTabs,.header-edit')[editingSelected?'hide':'show']();this.find('.htmleditorfield-mediaform-heading.insert')[editingSelected?'hide':'show']();this.find('.ss-uploadfield-item-actions')[editingSelected?'hide':'show']();this.find('.ss-uploadfield-item-name')[editingSelected?'hide':'show']();this.find('.ss-uploadfield-item-preview')[editingSelected?'hide':'show']();this.find('.Actions .media-insert')[editingSelected?'hide':'show']();this.find('.htmleditorfield-mediaform-heading.update')[editingSelected?'show':'hide']();this.find('.Actions .media-update')[editingSelected?'show':'hide']();this.find('.ss-uploadfield-item-editform').toggleEditForm(editingSelected);},resetFields:function(){this.find('.ss-htmleditorfield-file').remove();this.find('.ss-gridfield-items .ui-selected').removeClass('ui-selected');this.find('li.ss-uploadfield-item').remove();this.redraw();this._super();},getFileView:function(idOrUrl){return this.find('.ss-htmleditorfield-file[data-id='+idOrUrl+']');},showFileView:function(idOrUrl){var self=this,params=(Number(idOrUrl)==idOrUrl)?{ID:idOrUrl}:{FileURL:idOrUrl};var item=$('<div class="ss-htmleditorfield-file loading" />');this.find('.content-edit').prepend(item);var dfr=$.Deferred();$.ajax({url:$.path.addSearchParams(this.attr('action').replace(/MediaForm/,'viewfile'),params),success:function(html,status,xhr){var newItem=$(html).filter('.ss-htmleditorfield-file');item.replaceWith(newItem);self.redraw();dfr.resolve(newItem);},error:function(){item.remove();dfr.reject();}});return dfr.promise();}});$('form.htmleditorfield-mediaform .ss-gridfield-items').entwine({onselectableselected:function(e,ui){var form=this.closest('form'),item=$(ui.selected);if(!item.is('.ss-gridfield-item'))return;form.closest('form').showFileView(item.data('id'));form.redraw();},onselectableunselected:function(e,ui){var form=this.closest('form'),item=$(ui.unselected);if(!item.is('.ss-gridfield-item'))return;form.getFileView(item.data('id')).remove();form.redraw();}});$('form.htmleditorfield-form.htmleditorfield-mediaform div.ss-assetuploadfield').entwine({onfileuploadstop:function(e){var form=this.closest('form');var editFieldIDs=[];form.find('div.content-edit').find('div.ss-htmleditorfield-file').each(function(){editFieldIDs.push($(this).data('id'));});var uploadedFiles=$('.ss-uploadfield-files',this).children('.ss-uploadfield-item');uploadedFiles.each(function(){var uploadedID=$(this).data('fileid');if(uploadedID&&$.inArray(uploadedID,editFieldIDs)==-1){$(this).remove();form.showFileView(uploadedID);}});form.redraw();}});$('form.htmleditorfield-form.htmleditorfield-mediaform input.remoteurl').entwine({onadd:function(){this.validate();},onkeyup:function(){this.validate();},onchange:function(){this.validate();},getAddButton:function(){return this.closest('.CompositeField').find('button.add-url');},validate:function(){var val=this.val(),orig=val;val=val.replace(/^https?:\/\//i,'');if(orig!==val)this.val(val);this.getAddButton().button(!!val?'enable':'disable');return!!val;}});$('form.htmleditorfield-form.htmleditorfield-mediaform .add-url').entwine({getURLField:function(){return this.closest('.CompositeField').find('input.remoteurl');},onclick:function(e){var urlField=this.getURLField(),container=this.closest('.CompositeField'),form=this.closest('form');if(urlField.validate()){container.addClass('loading');form.showFileView('http://'+urlField.val()).done(function(){container.removeClass('loading');});form.redraw();}
return false;}});$('form.htmleditorfield-mediaform .ss-htmleditorfield-file').entwine({getAttributes:function(){},getExtraData:function(){},getHTML:function(){return $('<div>').append($('<a/>').attr({href:this.data('url')}).text(this.find('.name').text())).html();},insertHTML:function(ed){ed.replaceContent(this.getHTML());},updateFromNode:function(node){},updateDimensions:function(constrainBy,maxW,maxH){var widthEl=this.find(':input[name=Width]'),heightEl=this.find(':input[name=Height]'),w=widthEl.val(),h=heightEl.val(),aspect;if(w&&h){if(constrainBy){aspect=heightEl.getOrigVal()/widthEl.getOrigVal();if(constrainBy=='Width'){if(maxW&&w>maxW)w=maxW;h=Math.floor(w*aspect);}else if(constrainBy=='Height'){if(maxH&&h>maxH)h=maxH;w=Math.ceil(h/aspect);}}else{if(maxW&&w>maxW)w=maxW;if(maxH&&h>maxH)h=maxH;}
widthEl.val(w);heightEl.val(h);}}});$('form.htmleditorfield-mediaform .ss-htmleditorfield-file.image').entwine({getAttributes:function(){var width=this.find(':input[name=Width]').val(),height=this.find(':input[name=Height]').val();return{'src':this.find(':input[name=URL]').val(),'alt':this.find(':input[name=AltText]').val(),'width':width?parseInt(width,10):null,'height':height?parseInt(height,10):null,'title':this.find(':input[name=Title]').val(),'class':this.find(':input[name=CSSClass]').val()};},getExtraData:function(){return{'CaptionText':this.find(':input[name=CaptionText]').val()};},getHTML:function(){},insertHTML:function(ed){var form=this.closest('form'),node=form.getSelection(),ed=form.getEditor();var attrs=this.getAttributes(),extraData=this.getExtraData();var replacee=(node&&node.is('img'))?node:null;if(replacee&&replacee.parent().is('.captionImage'))replacee=replacee.parent();var img=(node&&node.is('img'))?node:$('<img />');img.attr(attrs);var container=img.parent('.captionImage'),caption=container.find('.caption');if(extraData.CaptionText){if(!container.length){container=$('<div></div>');}
container.attr('class','captionImage '+attrs['class']).css('width',attrs.width);if(!caption.length){caption=$('<p class="caption"></p>').appendTo(container);}
caption.attr('class','caption '+attrs['class']).text(extraData.CaptionText);}
else{container=caption=null;}
var replacer=container?container:img;if(replacee&&replacee.not(replacer).length){replacee.replaceWith(replacer);}
if(container){container.prepend(img);}
if(!replacee){ed.repaint();ed.insertContent($('<div />').append(replacer).html(),{skip_undo:1});}
ed.addUndo();ed.repaint();},updateFromNode:function(node){this.find(':input[name=AltText]').val(node.attr('alt'));this.find(':input[name=Title]').val(node.attr('title'));this.find(':input[name=CSSClass]').val(node.attr('class'));this.find(':input[name=Width]').val(node.width());this.find(':input[name=Height]').val(node.height());this.find(':input[name=CaptionText]').val(node.siblings('.caption:first').text());}});$('form.htmleditorfield-mediaform .ss-htmleditorfield-file.flash').entwine({getAttributes:function(){var width=this.find(':input[name=Width]').val(),height=this.find(':input[name=Height]').val();return{'src':this.find(':input[name=URL]').val(),'width':width?parseInt(width,10):null,'height':height?parseInt(height,10):null};},getHTML:function(){var attrs=this.getAttributes();var el=tinyMCE.activeEditor.plugins.media.dataToImg({'type':'flash','width':attrs.width,'height':attrs.height,'params':{'src':attrs.src},'video':{'sources':[]}});return $('<div />').append(el).html();},updateFromNode:function(node){}});$('form.htmleditorfield-mediaform .ss-htmleditorfield-file.embed').entwine({getAttributes:function(){var width=this.find(':input[name=Width]').val(),height=this.find(':input[name=Height]').val();return{'src':this.find('.thumbnail-preview').attr('src'),'width':width?parseInt(width,10):null,'height':height?parseInt(height,10):null,'class':this.find(':input[name=CSSClass]').val()};},getExtraData:function(){var width=this.find(':input[name=Width]').val(),height=this.find(':input[name=Height]').val();return{'CaptionText':this.find(':input[name=CaptionText]').val(),'Url':this.find(':input[name=URL]').val(),'thumbnail':this.find('.thumbnail-preview').attr('src'),'width':width?parseInt(width,10):null,'height':height?parseInt(height,10):null,'cssclass':this.find(':input[name=CSSClass]').val()};},getHTML:function(){var el,attrs=this.getAttributes(),extraData=this.getExtraData(),imgEl=$('<img />').attr(attrs).addClass('ss-htmleditorfield-file embed');$.each(extraData,function(key,value){imgEl.attr('data-'+key,value)});if(extraData.CaptionText){el=$('<div style="width: '+attrs['width']+'px;" class="captionImage '+attrs['class']+'"><p class="caption">'+extraData.CaptionText+'</p></div>').prepend(imgEl);}else{el=imgEl;}
return $('<div />').append(el).html();},updateFromNode:function(node){this.find(':input[name=Width]').val(node.width());this.find(':input[name=Height]').val(node.height());this.find(':input[name=Title]').val(node.attr('title'));this.find(':input[name=CSSClass]').val(node.data('cssclass'));}});$('form.htmleditorfield-mediaform .ss-htmleditorfield-file .dimensions :input').entwine({OrigVal:null,onmatch:function(){this._super();this.setOrigVal(parseInt(this.val(),10));},onunmatch:function(){this._super();},onfocusout:function(e){this.closest('.ss-htmleditorfield-file').updateDimensions(this.attr('name'));}});$('form.htmleditorfield-mediaform .ss-uploadfield-item .ss-uploadfield-item-cancel').entwine({onclick:function(e){var form=this.closest('form'),file=this.closest('ss-uploadfield-item');form.find('.ss-gridfield-item[data-id='+file.data('id')+']').removeClass('ui-selected');this.closest('.ss-uploadfield-item').remove();form.redraw();e.preventDefault();}});$('div.ss-assetuploadfield .ss-uploadfield-item-edit, div.ss-assetuploadfield .ss-uploadfield-item-name').entwine({getEditForm:function(){return this.closest('.ss-uploadfield-item').find('.ss-uploadfield-item-editform');},fromEditForm:{onchange:function(e){var form=$(e.target);form.removeClass('edited');form.addClass('edited');}},onclick:function(e){var editForm=this.getEditForm();editForm.parent('.ss-uploadfield-item').removeClass('ui-state-warning');editForm.toggleEditForm();e.preventDefault();return false;}});$('div.ss-assetuploadfield .ss-uploadfield-item-editform').entwine({toggleEditForm:function(bool){var itemInfo=this.prev('.ss-uploadfield-item-info'),status=itemInfo.find('.ss-uploadfield-item-status');var text="";if(bool===true||(bool!==false&&this.height()===0)){text=ss.i18n._t('UploadField.Editing',"Editing ...");this.height('auto');itemInfo.find('.toggle-details-icon').addClass('opened');status.removeClass('ui-state-success-text').removeClass('ui-state-warning-text');}else{this.height(0);itemInfo.find('.toggle-details-icon').removeClass('opened');if(!this.hasClass('edited')){text=ss.i18n._t('UploadField.NOCHANGES','No Changes')
status.addClass('ui-state-success-text');}else{text=ss.i18n._t('UploadField.CHANGESSAVED','Changes Made')
this.removeClass('edited');status.addClass('ui-state-success-text');}}
status.attr('title',text).text(text);}});$('form.htmleditorfield-mediaform #ParentID .TreeDropdownField').entwine({onadd:function(){this._super();var self=this;this.bind('change',function(){var fileList=self.closest('form').find('.ss-gridfield');fileList.setState('ParentID',self.getValue());fileList.reload();});}});});})(jQuery);function sapphiremce_cleanup(type,value){if(type=='get_from_editor'){value=value.replace(/<p [^>]*margin-left[^>]*>([^\n|\n\015|\015\n]*)<\/p>/ig,"<blockquote><p>$1</p></blockquote>");value=value.replace(/<[a-z0-9]+:imagedata[^>]+src="?([^> "]+)"?[^>]*>/ig,"<img src=\"$1\">");value=value.replace(new RegExp('<(!--)([^>]*)(--)>','g'),"");value=value.replace(/([ \f\r\t\n\'\"])class=mso[a-z0-9]+[^ >]+/ig,"$1");value=value.replace(/([ \f\r\t\n\'\"]class=")mso[a-z0-9]+[^ ">]+ /ig,"$1");value=value.replace(/([ \f\r\t\n\'\"])class="mso[a-z0-9]+[^">]+"/ig,"$1");value=value.replace(/([ \f\r\t\n\'\"])on[a-z]+=[^ >]+/ig,"$1");value=value.replace(/ >/ig,">");value=value.replace(/<(\/[A-Za-z0-9]+)[ \f\r\t\n]+[^>]*>/ig,"<$1>");}
if(type=='get_from_editor_dom'){jQuery(value).find('img').each(function(){this.onresizestart=null;this.onresizeend=null;this.removeAttribute('onresizestart');this.removeAttribute('onresizeend');});}
return value;};

/****** FILE: framework/javascript/TabSet.js *****/

(function($){$.entwine('ss',function($){$('.ss-tabset').entwine({IgnoreTabState:false,onadd:function(){this.redrawTabs();this._super();},onremove:function(){if(this.data('uiTabs'))this.tabs('destroy');this._super();},redrawTabs:function(){this.rewriteHashlinks();this.tabs();},rewriteHashlinks:function(){$(this).find('ul a').each(function(){if(!$(this).attr('href'))return;var matches=$(this).attr('href').match(/#.*/);if(!matches)return;$(this).attr('href',document.location.href.replace(/#.*/,'')+matches[0]);});}});});})(jQuery);;

/****** FILE: framework/admin/javascript/ssui.core.js *****/

(function($){$.widget('ssui.button',$.ui.button,{options:{alternate:{icon:null,text:null},showingAlternate:false},toggleAlternate:function(){if(this._trigger('ontogglealternate')===false)return;if(!this.options.alternate.icon&&!this.options.alternate.text)return;this.options.showingAlternate=!this.options.showingAlternate;this.refresh();},_refreshAlternate:function(){this._trigger('beforerefreshalternate');if(!this.options.alternate.icon&&!this.options.alternate.text)return;if(this.options.showingAlternate){this.element.find('.ui-button-icon-primary').hide();this.element.find('.ui-button-text').hide();this.element.find('.ui-button-icon-alternate').show();this.element.find('.ui-button-text-alternate').show();}
else{this.element.find('.ui-button-icon-primary').show();this.element.find('.ui-button-text').show();this.element.find('.ui-button-icon-alternate').hide();this.element.find('.ui-button-text-alternate').hide();}
this._trigger('afterrefreshalternate');},_resetButton:function(){var iconPrimary=this.element.data('icon-primary'),iconSecondary=this.element.data('icon-secondary');if(!iconPrimary)iconPrimary=this.element.data('icon');if(iconPrimary)this.options.icons.primary='btn-icon-'+iconPrimary;if(iconSecondary)this.options.icons.secondary='btn-icon-'+iconSecondary;$.ui.button.prototype._resetButton.call(this);if(!this.options.alternate.text){this.options.alternate.text=this.element.data('text-alternate');}
if(!this.options.alternate.icon){this.options.alternate.icon=this.element.data('icon-alternate');}
if(!this.options.showingAlternate){this.options.showingAlternate=this.element.hasClass('ss-ui-alternate');}
if(this.options.alternate.icon){this.buttonElement.append("<span class='ui-button-icon-alternate ui-button-icon-primary ui-icon btn-icon-"
+this.options.alternate.icon+"'></span>");}
if(this.options.alternate.text){this.buttonElement.append("<span class='ui-button-text-alternate ui-button-text'>"+this.options.alternate.text+"</span>");}
this._refreshAlternate();},refresh:function(){$.ui.button.prototype.refresh.call(this);this._refreshAlternate();},destroy:function(){this.element.find('.ui-button-text-alternate').remove();this.element.find('.ui-button-icon-alternate').remove();$.ui.button.prototype.destroy.call(this);}});$.widget("ssui.ssdialog",$.ui.dialog,{options:{iframeUrl:'',reloadOnOpen:true,dialogExtraClass:'',modal:true,bgiframe:true,autoOpen:false,autoPosition:true,minWidth:500,maxWidth:700,minHeight:300,maxHeight:600,widthRatio:0.8,heightRatio:0.8,resizable:false},_create:function(){$.ui.dialog.prototype._create.call(this);var self=this;var iframe=$('<iframe marginWidth="0" marginHeight="0" frameBorder="0" scrolling="auto"></iframe>');iframe.bind('load',function(e){if($(this).attr('src')=='about:blank')return;iframe.addClass('loaded').show();self._resizeIframe();self.uiDialog.removeClass('loading');}).hide();if(this.options.dialogExtraClass)this.uiDialog.addClass(this.options.dialogExtraClass);this.element.append(iframe);if(this.options.iframeUrl)this.element.css('overflow','hidden');},open:function(){$.ui.dialog.prototype.open.call(this);var self=this,iframe=this.element.children('iframe');if(this.options.iframeUrl&&(!iframe.hasClass('loaded')||this.options.reloadOnOpen)){iframe.hide();iframe.attr('src',this.options.iframeUrl);this.uiDialog.addClass('loading');}
$(window).bind('resize.ssdialog',function(){self._resizeIframe();});},close:function(){$.ui.dialog.prototype.close.call(this);this.uiDialog.unbind('resize.ssdialog');$(window).unbind('resize.ssdialog');},_resizeIframe:function(){var opts={},newWidth,newHeight,iframe=this.element.children('iframe');;if(this.options.widthRatio){newWidth=$(window).width()*this.options.widthRatio;if(this.options.minWidth&&newWidth<this.options.minWidth){opts.width=this.options.minWidth}else if(this.options.maxWidth&&newWidth>this.options.maxWidth){opts.width=this.options.maxWidth;}else{opts.width=newWidth;}}
if(this.options.heightRatio){newHeight=$(window).height()*this.options.heightRatio;if(this.options.minHeight&&newHeight<this.options.minHeight){opts.height=this.options.minHeight}else if(this.options.maxHeight&&newHeight>this.options.maxHeight){opts.height=this.options.maxHeight;}else{opts.height=newHeight;}}
if(!jQuery.isEmptyObject(opts)){this._setOptions(opts);iframe.attr('width',opts.width
-parseFloat(this.element.css('paddingLeft'))
-parseFloat(this.element.css('paddingRight')));iframe.attr('height',opts.height
-parseFloat(this.element.css('paddingTop'))
-parseFloat(this.element.css('paddingBottom')));if(this.options.autoPosition){this._setOption("position",this.options.position);}}}});$.widget("ssui.titlebar",{_create:function(){this.originalTitle=this.element.attr('title');var self=this;var options=this.options;var title=options.title||this.originalTitle||'&nbsp;';var titleId=$.ui.dialog.getTitleId(this.element);this.element.parent().addClass('ui-dialog');var uiDialogTitlebar=this.element.addClass('ui-dialog-titlebar '+'ui-widget-header '+'ui-corner-all '+'ui-helper-clearfix');if(options.closeButton){var uiDialogTitlebarClose=$('<a href="#"/>').addClass('ui-dialog-titlebar-close '+'ui-corner-all').attr('role','button').hover(function(){uiDialogTitlebarClose.addClass('ui-state-hover');},function(){uiDialogTitlebarClose.removeClass('ui-state-hover');}).focus(function(){uiDialogTitlebarClose.addClass('ui-state-focus');}).blur(function(){uiDialogTitlebarClose.removeClass('ui-state-focus');}).mousedown(function(ev){ev.stopPropagation();}).appendTo(uiDialogTitlebar);var uiDialogTitlebarCloseText=(this.uiDialogTitlebarCloseText=$('<span/>')).addClass('ui-icon '+'ui-icon-closethick').text(options.closeText).appendTo(uiDialogTitlebarClose);}
var uiDialogTitle=$('<span/>').addClass('ui-dialog-title').attr('id',titleId).html(title).prependTo(uiDialogTitlebar);uiDialogTitlebar.find("*").add(uiDialogTitlebar).disableSelection();},destroy:function(){this.element.unbind('.dialog').removeData('dialog').removeClass('ui-dialog-content ui-widget-content').hide().appendTo('body');(this.originalTitle&&this.element.attr('title',this.originalTitle));}});$.extend($.ssui.titlebar,{version:"0.0.1",options:{title:'',closeButton:false,closeText:'close'},uuid:0,getTitleId:function($el){return'ui-dialog-title-'+($el.attr('id')||++this.uuid);}});}(jQuery));;

/****** FILE: framework/javascript/GridField.js *****/

(function($){$.entwine('ss',function($){$('.ss-gridfield').entwine({reload:function(ajaxOpts,successCallback){var self=this,form=this.closest('form'),focusedElName=this.find(':input:focus').attr('name'),data=form.find(':input').serializeArray();if(!ajaxOpts)ajaxOpts={};if(!ajaxOpts.data)ajaxOpts.data=[];ajaxOpts.data=ajaxOpts.data.concat(data);if(window.location.search){ajaxOpts.data=window.location.search.replace(/^\?/,'')+'&'+$.param(ajaxOpts.data);}
form.addClass('loading');$.ajax($.extend({},{headers:{"X-Pjax":'CurrentField'},type:"POST",url:this.data('url'),dataType:'html',success:function(data){self.empty().append($(data).children());if(focusedElName)self.find(':input[name="'+focusedElName+'"]').focus();var content;if(ajaxOpts.data[0].filter=="show"){content='<span class="non-sortable"></span>';self.addClass('show-filter').find('.filter-header').show();}else{content='<button name="showFilter" class="ss-gridfield-button-filter trigger"></button>';self.removeClass('show-filter').find('.filter-header').hide();}
self.find('.sortable-header th:last').html(content);form.removeClass('loading');if(successCallback)successCallback.apply(this,arguments);self.trigger('reload',self);},error:function(e){alert(ss.i18n._t('GRIDFIELD.ERRORINTRANSACTION'));form.removeClass('loading');}},ajaxOpts));},showDetailView:function(url){window.location.href=url;},getItems:function(){return this.find('.ss-gridfield-item');},setState:function(k,v){var state=this.getState();state[k]=v;this.find(':input[name="'+this.data('name')+'[GridState]"]').val(JSON.stringify(state));},getState:function(){return JSON.parse(this.find(':input[name="'+this.data('name')+'[GridState]"]').val());}});$('.ss-gridfield *').entwine({getGridField:function(){return this.closest('.ss-gridfield');}});$('.ss-gridfield :button[name=showFilter]').entwine({onclick:function(e){$('.filter-header').show('slow').find(':input:first').focus();this.closest('.ss-gridfield').addClass('show-filter');this.parent().html('<span class="non-sortable"></span>');e.preventDefault();}});$('.ss-gridfield .ss-gridfield-item').entwine({onclick:function(e){if($(e.target).closest('.action').length){this._super(e);return false;}
var editLink=this.find('.edit-link');if(editLink.length)this.getGridField().showDetailView(editLink.prop('href'));},onmouseover:function(){if(this.find('.edit-link').length)this.css('cursor','pointer');},onmouseout:function(){this.css('cursor','default');}});$('.ss-gridfield .action').entwine({onclick:function(e){var filterState='show';if(this.hasClass('ss-gridfield-button-close')||!(this.closest('.ss-gridfield').hasClass('show-filter'))){filterState='hidden';}
this.getGridField().reload({data:[{name:this.attr('name'),value:this.val(),filter:filterState}]});e.preventDefault();}});$('.ss-gridfield .col-buttons .action.gridfield-button-delete, .cms-edit-form .Actions button.action.action-delete').entwine({onclick:function(e){if(!confirm(ss.i18n._t('TABLEFIELD.DELETECONFIRMMESSAGE'))){e.preventDefault();return false;}else{this._super(e);}}});$('.ss-gridfield .action.gridfield-button-print').entwine({UUID:null,onmatch:function(){this._super();this.setUUID(new Date().getTime());},onunmatch:function(){this._super();},onclick:function(e){var btn=this.closest(':button'),grid=this.getGridField(),form=this.closest('form'),data=form.find(':input.gridstate').serialize();;data+="&"+encodeURIComponent(btn.attr('name'))+'='+encodeURIComponent(btn.val());if(window.location.search){data=window.location.search.replace(/^\?/,'')+'&'+data;}
var connector=grid.data('url').indexOf('?')==-1?'?':'&';var url=$.path.makeUrlAbsolute(grid.data('url')+connector+data,$('base').attr('href'));var newWindow=window.open(url);return false;}});$('.ss-gridfield-print-iframe').entwine({onmatch:function(){this.hide().bind('load',function(){this.focus();var ifWin=this.contentWindow||this;ifWin.print();});;},onunmatch:function(){this._super();}});$('.ss-gridfield .action.no-ajax').entwine({onclick:function(e){var self=this,btn=this.closest(':button'),grid=this.getGridField(),form=this.closest('form'),data=form.find(':input.gridstate').serialize();data+="&"+encodeURIComponent(btn.attr('name'))+'='+encodeURIComponent(btn.val());if(window.location.search){data=window.location.search.replace(/^\?/,'')+'&'+data;}
var connector=grid.data('url').indexOf('?')==-1?'?':'&';window.location.href=$.path.makeUrlAbsolute(grid.data('url')+connector+data,$('base').attr('href'));return false;}});$('.ss-gridfield .action-detail').entwine({onclick:function(){this.getGridField().showDetailView($(this).prop('href'));return false;}});$('.ss-gridfield[data-selectable]').entwine({getSelectedItems:function(){return this.find('.ss-gridfield-item.ui-selected');},getSelectedIDs:function(){return $.map(this.getSelectedItems(),function(el){return $(el).data('id');});}});$('.ss-gridfield[data-selectable] .ss-gridfield-items').entwine({onmatch:function(){this._super();this.selectable();},onunmatch:function(){this._super();this.selectable('destroy');}});$('.ss-gridfield .filter-header :input').entwine({onmatch:function(){var filterbtn=this.closest('.fieldgroup').find('.ss-gridfield-button-filter'),resetbtn=this.closest('.fieldgroup').find('.ss-gridfield-button-reset');if(this.val()){filterbtn.addClass('filtered');resetbtn.addClass('filtered');}
this._super();},onunmatch:function(){this._super();},onkeydown:function(e){if(this.closest('.ss-gridfield-button-reset').length)return;var filterbtn=this.closest('.fieldgroup').find('.ss-gridfield-button-filter'),resetbtn=this.closest('.fieldgroup').find('.ss-gridfield-button-reset');if(e.keyCode=='13'){var btns=this.closest('.filter-header').find('.ss-gridfield-button-filter');var filterState='show';if(this.hasClass('ss-gridfield-button-close')||!(this.closest('.ss-gridfield').hasClass('show-filter'))){filterState='hidden';}
this.getGridField().reload({data:[{name:btns.attr('name'),value:btns.val(),filter:filterState}]});return false;}else{filterbtn.addClass('hover-alike');resetbtn.addClass('hover-alike');}}});$(".ss-gridfield .relation-search").entwine({onfocusin:function(event){this.autocomplete({source:function(request,response){var searchField=$(this.element);var form=$(this.element).closest("form");$.ajax({headers:{"X-Pjax":'Partial'},type:"GET",url:$(searchField).data('searchUrl'),data:encodeURIComponent(searchField.attr('name'))+'='+encodeURIComponent(searchField.val()),success:function(data){response($.map(JSON.parse(data),function(name,id){return{label:name,value:name,id:id};}));},error:function(e){alert(ss.i18n._t('GRIDFIELD.ERRORINTRANSACTION','An error occured while fetching data from the server\n Please try again later.'));}});},select:function(event,ui){$(this).closest(".ss-gridfield").find("#action_gridfield_relationfind").replaceWith('<input type="hidden" name="relationID" value="'+ui.item.id+'" id="relationID"/>');var addbutton=$(this).closest(".ss-gridfield").find("#action_gridfield_relationadd");if(addbutton.data('button')){addbutton.button('enable');}else{addbutton.removeAttr('disabled');}}});}});$(".ss-gridfield .pagination-page-number input").entwine({onkeydown:function(event){if(event.keyCode==13){var newpage=parseInt($(this).val(),10);var gridfield=$(this).getGridField();gridfield.setState('GridFieldPaginator',{currentPage:newpage});gridfield.reload();return false;}}});});}(jQuery));;

